/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "my_string.h"
#include <string>
#include <cstring>
#include <iostream>

namespace cola {
template <class S>
my_string<S>::my_string(my_string<S> const& s)
{

//	if (*this == s)
//		return;

	for (int i = 0; i < const_cast<my_string<S>& >(s).length(); i++) 
		(*this)[i] = const_cast<my_string<S>& >(s)[i];
}

////////////////////////
// private functions
///////////////////////

template <class S>
char *my_string<S>::chompnot()
{
	do_copy(this);
	char *buf = new char[length()+1];
	for ( int i = 0;i < static_cast<my_string_paste>(_mem).get_i() + 1; i++ ) {
		memset(buf, 0, std::strlen(buf));
		int j;
		while (j < length() && _string[j] != ' ' && _string[j] != '\n')
			j++;	
		j++;		
		while (j < length() && (*buf++ = _string[j]))
			j++;	
	}
	return buf;
}	

template <class S>
int my_string<S>::seek(my_string<S> const& s, my_string<S> const& haystack, int  &x)
{
	int t = x;
	int i = 0;
	unsigned int j = 0;
	for (i = x, j = 0; i < const_cast<my_string<S>& >(haystack).length(); i++) {
		if (_string[j] == const_cast<my_string<S>& >(haystack)[i]) {
			for ( ; j < _string.length(); j++) 
				if (_string[j] == const_cast<my_string<S>& >(haystack)[i+j])
					continue;
		
			if (j == _string.length()) {
				x=t;
				return 0;
			}
		}
	}	
	x = i;
	return -1;	
}


}

template class cola::my_stringbase<std::string>;
template class cola::my_string<std::string>;

