/*
 Copyright (C) Johan Ceuppens 2011-2013

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef _MARKOV_LINDEMAYERSYSTEM_H_
#define _MARKOV_LINDEMAYERSYSTEM_H_


#include<cstring>
#include<iostream>
#include<vector>
#include<deque>
#include<functional>
#include<iterator>

namespace cola
{


class lindemayer_system
{
public:	
	template<class D>
	class lindemayer_stack
	{
	public:
		lindemayer_stack() : _bottom(NULL), _next(NULL) {}
		virtual ~lindemayer_stack() { delete _bottom; }

		void pop() { delete _next; _next = NULL; } 
		void push(D d) { _next = new lindemayer_stack; _next->setData(d); setNext(_next); } 

		void setData(D d) { _data = d; }	
		void setNext(lindemayer_stack *lms, lindemayer_stack *n = NULL) { lms->_next = n; }
	
	protected:
		D _data;
		lindemayer_stack *_next;
		lindemayer_stack *_bottom;
	};	

	template<class D>
	class lindemayer_bubble_deque
	{
	public:
		lindemayer_bubble_deque() {}
		virtual ~lindemayer_bubble_deque() {}
	
		virtual void bubble();	
		void push_back(const D& val) { _deque.push_back(val); }
		void push_front(const D& val) { _deque.push_front(val); }
			
		void pop_back() { _deque.pop_back(); }	
		void pop_front() { _deque.pop_front(); }
		typename std::iterator<std::input_iterator_tag, D> insert(std::iterator<std::input_iterator_tag, D> pos, D const& val) { _deque.insert(pos,val); }	
		typename std::iterator<std::input_iterator_tag, D> erase(std::iterator<std::input_iterator_tag, D>  pos) { _deque.insert(pos); }	
		void clear() { _deque.clear(); }
		void swap(std::deque<D>& d) { _deque.swap(d); }

	protected:
		std::deque<D> _deque;	
	};

	template<class S, class T>
	class lindemayer_axiom
	{
	public:
		lindemayer_axiom() {}
		virtual ~lindemayer_axiom() {}

		void setOp(std::mem_fun_t<S,T> op) { _op = op; }
		S operator()() { T::_op(); }
		
		protected:
		std::mem_fun_t<S,T> _op;
	};

public:
	lindemayer_system();
	virtual ~lindemayer_system();

	void transform();

public:
	lindemayer_system& operator=(lindemayer_system const& s); 
	lindemayer_system(lindemayer_system const& s);
};
} //namespace cola
#endif
