/*
 Copyright (C) Johan Ceuppens 2011-2013

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef _MARKOV_LINDEMAYER_LEAF_H_
#define _MARKOV_LINDEMAYER_LEAF_H_


#include<cstring>
#include<iostream>
#include<vector>

#include "my_string.h"
#include "lindemayer_system.h"

#include "lindemayer_util.h"

namespace cola
{
template<class S, class T>
class lindemayer_leaf : public lindemayer_system
{
public:
	lindemayer_leaf();
	virtual ~lindemayer_leaf();

	void addAxiom(lindemayer_axiom<S, T> const& ax) { _axioms->push_back(ax); }

	void transform();

protected:
	lindemayer_stack<my_string<std::string> > *_stack;	
	std::vector<lindemayer_axiom<S, T> > *_axioms;	
public:
	////lindemayer_leaf& operator=(lindemayer_leaf const& s); 
	lindemayer_leaf(lindemayer_leaf const& s);
};
} //namespace cola
#endif
