/*
 Copyright (C) Johan Ceuppens 2011

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef PARSERBASE_H
#define PARSERBASE_H
#include <map>

namespace cola {

template <class S, class T>
class ParserBase
{
public:
	ParserBase<S,T>() {}
	ParserBase(ParserBase const& n) {}
	virtual ~ParserBase<S,T>() {}

public:
	int parse(S const& filename, S const& parsefilename, int const& wordid = -1);

private:
	void do_copy(T s);
	int telllen(S const& filename, int &l);
	int filein(S const& filename, T const& buf);
	int load_keywords(S const& filename, std::map<int, T> const& m);

protected:
	int load(S const& filename, S const& parsefilename, std::map<int, T> const& m, T const& buf);
	int parse_for(T const& fors, int &i, T const& buf);

public:
	ParserBase &operator=(ParserBase const& n) { return *this; }


};

}

#endif
