/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Persistence::ReadWriteLock class interface                                */
/*                                                                           */
/*===========================================================================*/
#ifndef	PersistReadWriteLock
#define	PersistReadWriteLock

extern "C" 
{
# include	<pthread.h>
}


namespace	Persistence
{
  class ReadWriteLock
  {
  protected:
    pthread_mutex_t	readLock;
    pthread_cond_t	readCond;
    size_t		nReaders;

  protected:
    ReadWriteLock()
      : nReaders(0)
    {
      pthread_mutex_init(&readLock, 0);
      pthread_cond_init(&readCond, 0);
    }

    virtual
    ~ReadWriteLock()
    {}

    void
    startWrite()
    {
      pthread_mutex_lock(&readLock);
      while ( 0 < nReaders )
	pthread_cond_wait(&readCond, &readLock);
    }

    void
    endWrite()
    {
      pthread_cond_signal(&readCond);	// signal the next writer
      pthread_mutex_unlock(&readLock);
    }

    void
    startRead()
    {
      pthread_mutex_lock(&readLock);
      {
	++nReaders;
      }
      pthread_mutex_unlock(&readLock);
    }

    void
    endRead()
    {
      pthread_mutex_lock(&readLock);
      {
	if ( !--nReaders )
	  {
	    pthread_cond_signal(&readCond);	// signal the first writer
	  }
      }
      pthread_mutex_unlock(&readLock);
    }
  }
  ;
}
#endif
