/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::SrcFilter - input Filter implementation                          */
/*                                                                           */
/*===========================================================================*/
#ifdef __GNUG__
#pragma implementation
#endif


#include	<SrcFilter.H>
#include	<persist/GetPutDelTemplates.H>
#include	<persist/RelocateTemplates.H>

namespace	Persistence
{
  using namespace Examples;

  //
  // instantiate template functions
  //
  template
  SrcFilter *	get(
		    const char *	name
		    );

  template
  SrcFilter *	get(
		    const Id
		    );
  template
  Status	put(
		    SrcFilter &
		    );
  template
  Status	del(
		    SrcFilter &
		    );
  template
  SrcFilter *	first();

  template
  SrcFilter *	next(const SrcFilter	&);

  template
  SrcFilter *	relocate(
			 SrcFilter &
			 );

  template
  void		swizzle(
			SrcFilter &
			);

}


namespace	Examples
{
  using namespace	Persistence;

  Id		SrcFilter::ClassId(ExampleSrcFilter);
  Name		SrcFilter::ClassName("SrcFilter");
  LongName	SrcFilter::ClassDecl(SrcFilterClassDecl);
  LongName	SrcFilter::ClassImpl("SrcFilter.C $Id$ keyword substitution from version control");

  SrcFilter::SrcFilter(
		       bool	first	// first thread ever?
		       ,int	nod	// which node to run thread on
		       ,Sync &	syn
		       ,Que &	outque
		       ,size_t	tlen
		       )
    : Filter((Name("->") + outque.cname()).cstr()
	     ,classId()
	     ,first
	     ,nod
	     ,syn
	     )
    , outputQue(*this
		,outque
		)
    , testLength(tlen)
  {
    init(
	 ClassId		// Class ClassId
	 ,ClassName.cstr()
	 ,ClassDecl.cstr()
	 ,ClassImpl.cstr()	// Class Class Impl
	 ,0			// don't keep track of SrcFilters
	 );
    outque.input(this->id());
  }


  SrcFilter::~SrcFilter()
  {
    if ( (dtorCommand() == DtorCommand::DEL)
	 ||
	 (dtorCommand() == DtorCommand::DELETE)
	 )
      outputQue->input(0);
  }
						   

  Status
  SrcFilter::start()
  {
    // first initialize outputQue
    outputQue->initReadWrite();

    Status	s;

    s = outputQue->start();
    if ( s.succeeded() )
      {
	s &= Filter::start();
      }

    if ( !s.succeeded() )
      {
	s &= Status(
		    "SrcFilter"
		    ,"start"
		    ,cname()
		    );
	s.os() << " failed to start on separate thread" << std::endl;
      }
    return(s);
  }
  
  //------------------------------------------------------------------------------
  Status
  SrcFilter::put()
  {
    Status s(Persistence::put<SrcFilter>(*this));

    if ( s.succeeded() )
      return(s);
    else
      {
	Status sta("SrcFilter"
		   ,"put"
		   ,cname()
		   );
	sta.os() << " failed" << std::endl;
	sta &= s;
	return(sta);
      }
  }

  Status
  SrcFilter::del()
  {
    Status s(Persistence::del<SrcFilter>(*this));
    
    if ( s.succeeded() )
      return(s);
    else
      {
	Status sta("SrcFilter"
		   ,"del"
		   ,cname()
		   );
	sta.os() << " failed" << std::endl;
	sta &= s;
	return(sta);
      }
  }
  //------------------------------------------------------------------------------
  SrcFilter *
  SrcFilter::relocate()
  {
    return(Persistence::relocate<SrcFilter>(*this));
  }

  void
  SrcFilter::swizzle()
  {
    Persistence::swizzle<SrcFilter>(*this);
  }

  void
  SrcFilter::run()
  {
    // source
    iWrite w = outputQue->beginWrite();
    size_t i;
    Array is(outputQue->width());	// array to mark elements in a frame
    for ( i = 0
	    ;
	  i < outputQue->width()
	    ;
	  ++i
	  )
      {
	is[i] = float(i)/100;
      }
	
    for ( i = 0
	    ;
	  i < testLength
	    ;
	  ++i
	    , ++w
	  )
      {
	float frameNo = float(i);
	SubArray a = *w;
	a = frameNo;
	a += is;
	//std::cout << cname() << " wrote frame " << frameNo << std::endl;
      }
    // w is deleted out of the for() scope
    // which ends the writing of the outputQue
  }
  //------------------------------------------------------------------------------
  void		SrcFilter::dump(
				ostream &	out
				) const
  {
    Object::dump(out);

    out << "output que is " << outputQue->cname() << std::endl;
    out << "test length = " << testLength << std::endl;
  }

}
