/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Observ Object-derived class implementation                      */
/*                                                                           */
/*===========================================================================*/
#ifndef	ExampleObserv
#define ExampleObserv	201

#define ObservClassDecl	"Observ.H $Id$ keyword substitution from version control"

#ifdef __GNUG__
#pragma interface
#endif

#include	<Class.H>

#include	<map>
#include	<string>

namespace	Examples
{
  using std::map;
  using std::string;

  using namespace Persistence;

  class Observ;
  typedef Observ 	Obs;
  typedef ref<Obs *>	refObs;

  class Observ : public Obj, public ClassInfo
  {
  public:
    enum SomeProperty
      {
	CENTER	= 0,
	DOWN	= -1,
	UP	= 1
      };
    
    enum ObsType
      {
	NONS		= 0,

	OPENBACK    	= 21,
	MIDBACK		= 22,
	CLOSBACK	= 23,
	MIDFRONT	= 24,
	CLOSFRONT	= 25,
	CLOSROUND	= 26,  
	MIDROUND	= 27,    
	CLOSSHWA	= 28,   
	SHWA		= 29,
	              
	LABIAL		= 101,
	DENTAL		= 102,
	ALVEOLAR	= 103,
	LATERAL		= 104,
	RETROFLEX	= 105,
	PALATAL		= 106,
	VELAR		= 107,
	UVULAR		= 108,

      };

    friend class ClassInfo;
    // class data and methods
  private:
    // common to all persistent classes
    static
    Id			ClassId;
    static
    Name		ClassName;
    static
    LongName		ClassDecl;
    static
    LongName		ClassImpl;
  public:
    static
    Id    		classId()
    {
      return(ClassId);
    }
    
    static
    const char *	className()
    {
      return(ClassName.cstr());
    }
    
    static
    const char *	classDecl()
    {
      return(ClassDecl.cstr());
    }

    static
    const char *	classImpl()
    {
      return(ClassImpl.cstr());
    }

  private:
    // particular to this class
    static
    const size_t	DefaultNumObs = 9;
    static
    map<ObsType, string>			ObsTypes;
    typedef map<ObsType, string>::iterator	iObsTypes;
    
    static
    void
    initObsTypes();

    //
    //	object data
    //
  private:
    ObsType		type;
    SomeProperty	prop;
    refObs		rlast;
    //ref		rmap;
    
    
    //
    //  object methods
    //
  public:
    Observ()
      {
	if ( ObsTypes.empty() )
	  {
	    initObsTypes();
	  }
      }


    Observ(
	   const char *		nm
	   ,ObsType		typ
	   ,SomeProperty	prp = CENTER
	   ,const char *	lastnm = ""
	   );

    ~Observ();


    Obs &	last()
    {
      return(*rlast);
    }
    
    void	updateProp(
			   ObsType		typ
			   ,SomeProperty	prp = CENTER
			   ,const char *	lastnm = ""
			   );

    void	dump(
		     ostream &	out
		     ) const;
  }
  ;
}

#endif
