/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Examples::Observ Object-derived class                                     */
/*                                                                           */
/*===========================================================================*/
#ifdef __GNUG__
#pragma implementation
#endif

#include	<Observ.H>
#include	<persist/GetPutDelTemplates.H>

namespace	Persistence
{
  using Examples::Observ;
  using Examples::Obs;

  //
  // instantiate obligatory template functions
  //

  template
  Obs *		get(
		    const char *	name
		    );

  template
  Obs *		get(
		    const Id		id
		    );

  // Observ has Obj::put() and Obj::del()

  template
  Obs *		first();

  template
  Obs *		next(const Obs	&);

}

namespace	Examples
{
  using namespace Persistence;

  Id		Observ::ClassId(ExampleObserv);
  Name		Observ::ClassName("Observ");
  LongName	Observ::ClassDecl(ObservClassDecl);
  LongName	Observ::ClassImpl("Observ.C $Id$ keyword substitution from version control");


  map<Observ::ObsType, string> Observ::ObsTypes;	// this constitutes definition!

  void
  Observ::initObsTypes()
  {
    ObsTypes[NONS]       = "nons";

    ObsTypes[OPENBACK]   = "openback";
    ObsTypes[MIDBACK]    = "midback";
    ObsTypes[CLOSBACK]   = "closback";
    ObsTypes[MIDFRONT]   = "midfront";
    ObsTypes[CLOSFRONT]  = "closfront";
    ObsTypes[CLOSROUND]  = "closround";
    ObsTypes[MIDROUND]   = "midround";
    ObsTypes[CLOSSHWA]   = "closshwa";
    ObsTypes[SHWA]       = "shwa";

    ObsTypes[LABIAL]     = "labial";
    ObsTypes[DENTAL]     = "dental";
    ObsTypes[ALVEOLAR]   = "alveolar";
    ObsTypes[LATERAL]    = "lateral";
    ObsTypes[RETROFLEX]  = "retroflex";
    ObsTypes[PALATAL]    = "palatal";
    ObsTypes[VELAR]      = "velar";
    ObsTypes[UVULAR]     = "uvular";

  }

  Observ::Observ(
		 const char *	nm
		 ,const ObsType	typ
		 ,SomeProperty	prp
		 ,const char *	lastnm
		 )
    : Obj(nm, ClassId)
      ,type(typ)
      ,prop(prp)
  {
    if ( ObsTypes.empty() )
      {
	initObsTypes();

	init(
	     ClassId
	     ,ClassName.cstr()
	     ,ClassDecl.cstr()
	     ,ClassImpl.cstr()
	     ,DefaultNumObs
	     );
      }

    rlast = Id(0);
    if ( Name(lastnm) != "" )
      {
	if (Obs * o = get<Obs>(lastnm))
	  {
	    rlast = *o;
	  }
      }

    Class *cla = get<Class>(ClassId);

    if ( cla->has_objs() )
      {
	cla->insert_obj(*this);
      }

  }

  Observ::~Observ()
  {
    // must reverse the insertion in Observ(...)
    Class *cla = get<Class>(ClassId);
    if ( cla->has_objs() )
      {
	cla->remove_obj(*this);
      }
  }

  void
  Observ::updateProp(
		     ObsType		typ
		     ,SomeProperty	prp
		     ,const char *	lastnm
		     )
  {
    if ( prp != prop )
      {
	prop = prp;
	Obj::update();
      }
	
    if ( typ != type)
      {
	type = typ;
	Obj::update();
      }

    if ( Name(lastnm) != "" )
      {
	Obs * o = get<Obs>(lastnm);
	if ( o 
	     && (Name(lastnm) != o->cname())
	     )
	  {
	    rlast = *o;
	    Obj::update();
	  }
      }
  }

  void
  Observ::dump(
	       ostream &	out
	       ) const
  {
    this->Obj::dump(out);

    out << "Observ type = " << ObsTypes[type] << std::endl;

    if ( CENTER == prop )
      {
	out << "Observ prop = " << "CENTER" << std::endl;
      }
    else if ( DOWN == prop )
      {
	out << "Observ prop = " << "DOWN" << std::endl;
      }
    else
      {
	out << "Observ prop = " << "UP" << std::endl;
      }

    if ( rlast != Id(0) )
      {
	out << "last Observ is " << rlast->cname() << std::endl;
      }
  }

}
