/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* ExtinguishObservables                                                     */
/*                                                                           */
/*===========================================================================*/
#include	<Observ.H>
#include	<GoBase.H>

extern "C"
{
#include	<stdlib.h>
}
/*===========================================================================
  =========================================================================*/
int main(
	 int     	argc
	 , const char**	argv
	 )
{
  using namespace Persistence;
  using namespace Examples;

  GoBase *	ob = new GoBase(
				"objects"
				,"."
				);

  /***
   ***	extinguish State observables
   ***/
  Status sta(
	     ""
	     ,"example"
	     ,"ExtinguishObservables"
	     );

  Class * cla = get<Class>(Observ::classId());

  if ( cla )
    {
      sta = cla->del();
      if ( sta.succeeded() )
	{
	  std::cout << "deleted Observ Class object" << std::endl;
	}
      else
	std::cout << sta;
    }

  for ( cla = first<Class>()
	  ;
	0 != cla
	  ;
	cla = next<Class>(*cla)
	)
    {
      sta = cla->put();
      if ( sta.succeeded() )
	{
	  std::cout << "saved Class '" << cla->cname() << "'" << std::endl;
	}
      else
	std::cout << sta;
    }


  delete ob;

  exit(0);
}


