/*===========================================================================*/
/*
 * This file is part of libpersist - a c++ library for object persistence
 *
 * Copyright (C) 2006  Elaine Tsiang YueLien
 *
 * libpersist is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* BuildNUMAThreads                                                          */
/*                                                                           */
/*===========================================================================*/
#include	<GoBase.H>
#include	<SrcFilter.H>
#include	<ThruFilter.H>
#include	<SinkFilter.H>
#include	<BlockStream.H>

/*===========================================================================
  =========================================================================*/
int main(int argc, const char* argv[])
{
  using namespace	Examples;
  using namespace	Persistence;

  //------------------------------------------------------------------------------
  //	open object data base
  //
  GoBase *	ob = new GoBase(
				"objects"
				,"."
				);



  // rebuild Ques and Filters
  Bout.begin();
  Sync * sync = get<Sync>("ExampleNUMAThreads");
  Bout.end();

  Bout.begin();
  SrcFilter * src = get<SrcFilter>("->Que1");
  Bout.end();

  Bout.begin();
  ThruFilter * thru = get<ThruFilter>("Que1->Que2");
  Bout.end();

  Bout.begin();
  SinkFilter * sink = get<SinkFilter>("Que2->");
  Bout.end();

  Bout.begin();
  Que * que1 = get<Que>("Que1");
  Bout.end();

  Bout.begin();
  Que * que2 = get<Que>("Que2");
  Bout.end();


  Bout.begin();
  if ( sync )
    sync->dump(std::cout);
  Bout.end();


  Bout.begin();
  if ( src )
    src->del();
  Bout.end();


  Bout.begin();
  if ( thru )
    thru->del();
  Bout.end();


  Bout.begin();
  if ( sink )
    sink->del();
  Bout.end();


  que1 = new Que("Que1"
		 ,7	//width
		 ,29	//length
		 );

  que2 = new Que("Que2"
		 ,13
		 ,23
		 );

  if ( !sync )
    sync = new Sync("ExampleNUMAThreads");

  src = new SrcFilter(
		      true	// first thread
		      , 0	// one node 1
		      , *sync
		      , *que1	// output
		      , 1001	// length of source signal
		      );

  thru = new ThruFilter(
			false
			, 1
			, *sync
			, *que1	// input
			, *que2	// output
			);

  sink = new SinkFilter(
			false
			, 1
			, *sync
			, *que2	// input
			);

  Bout.begin();
  sync->dump(std::cout);
  Bout.end();

  Bout.begin();
  sync->put();
  Bout.end();


  Bout.begin();
  src->dump(std::cout);
  Bout.end();

  Bout.begin();
  que1->dump(std::cout);
  Bout.end();

  Bout.begin();
  thru->dump(std::cout);
  Bout.end();

  Bout.begin();
  que2->dump(std::cout);
  Bout.end();

  Bout.begin();
  sink->dump(std::cout);
  Bout.end();

    
  Class * cla = get<Class>(Class::classId());
  cla->put();

  exit(0);
}
