/*===========================================================================*/
/*
 * This file is part of libogg++ - a c++ library for the Ogg transport format
 *
 * Copyright (C) 2006, 2007  Elaine Tsiang YueLien
 *
 * libogg++ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA
 *
 *===========================================================================*/
/*                                                                           */
/* Ogg::Transport to Logical interface                                       */
/*                                                                           */
/*===========================================================================*/
#ifndef TransportToLogicalInterface
#define	TransportToLogicalInterface

#ifdef __GNUG__
#pragma interface
#endif

namespace	Ogg
{
  class		TransportToLogical;
}

#include	<LogicalImpl.H>


///
///@file <src/lib/TransportToLogical.H>
///
namespace	Ogg
{
  /// @brief Transport to Logical implementation interface
  ///
  /// @ingroup transportImplementation
  ///
  /// Deques packets from each of its Logical streams.
  /// Encapsulates packet(s) into the corresponding page.
  /// Or decapsulates packets from an Ogg stream
  /// and enques them to the appropriate Logical stream.
  ///
  class TransportToLogical
  {
    friend class	Logical;
    friend class	LogicalImpl;
    friend class	ReaderImpl;

  protected:
    Transport &
    intf();

    /// @brief What this transport was set up to do
    bool
    encapsulating();

    /// @brief Add a logical stream
    ///
    /// Called by LogicalImpl::LogicalImpl
    ///
    void
    add(
	LogicalToTransport &
	);

    /// @brief Remove a logical stream
    ///
    /// Called by LogicalImpl::~LogicalImpl
    ///
    void
    remove(
	   LogicalToTransport &
	   ); 

    //@{
    /// @brief Called by Reader to start the selection process
    void
    startSelect();

    /// @brief Called by Reader to indicate the selection process is complete
    void
    doneSelect();

    /// @brief Called by a ReaderImpl to get  the first packet of the Logical with serialNo.
    ///
    /// Return the first packet of the Logical stream
    /// if the serialNo is valid, and if the stream has not been claimed.
    /// Otherwise, this returns null.
    /// Note this does not consume the packet as in Logical::Reader:: operators
    const
    Packet *
    firstPacket(
		long	serialNo
		);

    /// @brief Claim the stream for this Logical
    //@}
    void
    claim(
	  LogicalToTransport &
	  );

    /// @brief Seek forward to packetNo and position in logical stream
    Packet *
    seek(
	 LogicalToTransport &
	 ,PacketNo
	 ,Position
	 );
  };
};
#endif
