/* Copyright (C) 2004 W.P. van Paassen - peter@paassen.tmfweb.nl

   This file is part of libmd5model
   
   libmd5model will attempt to parse ID's Doom3 mesh, animation and camera model formats
   
   libmd5model is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your
   option) any later version.

   libmd5model is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with libmd5model; see the file COPYING.  If not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */
%{
#include "md5mesh_defines.h"
#include "md5mesh_parser.h"
#include <stdio.h>
extern int fileno(FILE* stream);
%}
%option nounput
%option noyywrap
%option prefix="MD5MESH_"

digit			[0-9]

%%

MD5Version		return VERSIONID;
joints			return JOINTSID;
commandline		return CMDLINEID;
numJoints		return NUMJOINTSID;
numMeshes		return NUMMESHESID;
mesh			return MESHID;
vert			return VERTID;
tri			return TRIID;
weight			return WEIGHTID;
shader			return SHADERID;
numverts		return NUMVERTSID;
numtris			return NUMTRISID;
numweights		return NUMWEIGHTSID;
"\"".*"\""		yytext[yyleng-1]='\0'; MD5MESH_lval.ctype = yytext + 1; return STRING;
"{"			return LCURLY;
"}"			return RCURLY;
"("			return LBRACKET;
")"			return RBRACKET;
"-"?{digit}*"."{digit}+	MD5MESH_lval.ftype = atof(yytext); return NUMBER;
"-"?{digit}+		MD5MESH_lval.itype = atoi(yytext); return NUMBER;
"//".*\n		/* eating up comments */
[ \t\n]+		/* eating up whitespace */
.			/* nada */	

%%
