/*
Copyright (C) 2015 John Tse

This file is part of Libknit.

Libknit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Libknit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Libknit.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

static void swap(uint8_t *S, uint16_t i, uint16_t j) {
	uint8_t t;

	t    = S[i];
	S[i] = S[j];
	S[j] = t;
}

static void KSA(uint8_t *S, uint8_t *key, uint32_t keylength) {
	uint16_t i;
	uint16_t j;

	for (i = 0; i < 256; i++)
		S[i] = i;

	j = 0;

	for (i = 0; i < 256; i++) {
		j = (j + S[i] + key[i % keylength]) % 256;
		swap(S, i, j);
	}
}

static void PRGA(uint8_t *S, uint32_t p_length, uint8_t *K) {
	uint16_t i;
	uint16_t j;

	i = 0;
	j = 0;

	while (p_length--) {
		i = (i + 1) % 256;
		j = (j + S[i]) % 256;
		swap(S, i, j);
		*K++ = S[(S[i] + S[j]) % 256];
	}
}

void rc4_crypt(uint8_t *k, size_t k_length, uint8_t *i, size_t i_length, uint8_t **o) {
	uint8_t S[256];
	uint8_t *K;

	K  = calloc(i_length, 1);
	*o = calloc(i_length, 1);

	KSA(S, k, k_length);
	PRGA(S, i_length, K);

	for (uint32_t j = 0; j < i_length; j++)
		(*o)[j] = i[j] ^ K[j];
}
