/*
Copyright (C) 2015 John Tse

This file is part of Libknit.

Libknit is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Libknit is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Libknit.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "knit.h"

#define _KNIT_CIPHER  3
#define _KNIT_HASH   12
#define _KNIT_MODE   48 
#define _KNIT_MAC    64 

#define _KNIT_BLOCK_CIPHER  1
#define _KNIT_STREAM_CIPHER 2

#define _KNIT_ERROR_OK           (uint8_t *) "No error"
#define _KNIT_ERROR_NO_OP        (uint8_t *) "No operation was set"
#define _KNIT_ERROR_NO_ALGO      (uint8_t *) "No algorithm was set"
#define _KNIT_ERROR_NO_KEY       (uint8_t *) "No key was set"
#define _KNIT_ERROR_NO_IV        (uint8_t *) "No iv was set"
#define _KNIT_ERROR_MIN_KEY_SIZE (uint8_t *) "Key size is smaller than needed"

void ecb(void (*cipher)(uint64_t, uint64_t *), size_t, size_t, void *, void *);
void cbc_encrypt(void (*cipher)(uint64_t, uint64_t *), size_t, size_t, uint64_t, void *, void *);
void cbc_decrypt(void (*cipher)(uint64_t, uint64_t *), size_t, size_t, uint64_t, void *, void *);
void ofb(void (*cipher)(uint64_t, uint64_t *), size_t, size_t, uint64_t, void *, void *);

void blowfish_encrypt(uint64_t, uint64_t *);
void blowfish_decrypt(uint64_t, uint64_t *);
void blowfish_key_expansion(uint8_t *, uint32_t);

void rc2_encrypt(uint64_t, uint64_t *);
void rc2_decrypt(uint64_t, uint64_t *);
void rc2_key_expansion(uint8_t *, uint32_t, uint32_t);

void rc4_crypt(uint8_t *, size_t, uint8_t *, size_t, uint8_t **);

uint8_t * md2(uint8_t *, uint64_t);
uint8_t * md4(uint8_t *, uint64_t);
uint8_t * md5(uint8_t *, uint64_t);

uint8_t * hmac(uint8_t * (*)(uint8_t *, uint64_t), uint16_t, uint16_t, uint8_t *, size_t, uint8_t *, size_t);

uint64_t s2i(uint8_t *, uint32_t);
uint8_t * i2s(uint64_t, uint32_t);

uint8_t _knit_encrypt(KNIT, void *, size_t, uint8_t **, size_t *);
uint8_t _knit_decrypt(KNIT, void *, size_t, uint8_t **, size_t *);
uint8_t _knit_hash(KNIT, void *, size_t, uint8_t **);
uint8_t _knit_mac(KNIT, void *, size_t, uint8_t **);
