#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by 
Liberty Eiffel The GNU Eiffel Compiler, Eiffel tools and libraries
    release 2016.05 (Alexander Graham Bell)

Copyright (C), 2011-2016 - C.ADRIAN, P.REDAELLI, R.MACK
    http://www.liberty-eiffel.org

Original SmartEiffel code:
Copyright (C), 1994-2002 - INRIA - LORIA - ESIAL UHP Nancy 1 - FRANCE
Copyright (C), 2003-2005 - INRIA - LORIA - IUT Charlemagne Nancy 2 - FRANCE
D.COLNET, P.RIBET, C.ADRIAN, V.CROIZIER, F.MERIZEN
    http://smarteiffel.loria.fr
C Compiler options used: -pipe -O2
*/

/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
/*
  This file (Liberty/sys/runtime/base.h) contains all basic Eiffel
  type definitions.
  This file is automatically included in the header for all modes of
  compilation: -boost, -no_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/

#ifndef _BASE_H
#define _BASE_H

#if defined(_MSC_VER) && (_MSC_VER >= 1400)       /* VC8+ */
# ifndef _CRT_SECURE_NO_DEPRECATE
#  define _CRT_SECURE_NO_DEPRECATE
# endif
# ifndef _CRT_NONSTDC_NO_DEPRECATE
#  define _CRT_NONSTDC_NO_DEPRECATE
# endif
#endif   /* VC8+ */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  include <unistd.h>
#endif
#if !defined(WIN32) && \
           (defined(WINVER) || defined(_WIN32_WINNT) || defined(_WIN32) || \
                defined(__WIN32__) || defined(__TOS_WIN__) || defined(_MSC_VER))
#  define WIN32 1
#endif
#ifdef WIN32
#  include <windows.h>
#endif
#ifdef SE_THREAD
#ifdef WIN32
#  define TLS(type) __declspec(thread) type
#else
#  ifndef O_RDONLY
#    include <sys/file.h>
#  endif
#  ifndef O_RDONLY
#    define O_RDONLY 0000
#  endif
#  define TLS(type) __thread type
#endif
#else
#define TLS(type) type
#endif

#if defined(_MSC_VER) && (_MSC_VER < 1600) /* MSVC older than v10 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "I64d"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c
#  define INT64_C(c) c ## i64
#  define UINT8_C(c) c ## u
#  define UINT16_C(c) c ## u
#  define UINT32_C(c) c ## u
#  define UINT64_C(c) c ## ui64
#elif defined(__WATCOMC__) && (__WATCOMC__ <= 1220) /* WATCOM 12.2 or lower */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#  define UINT8_C(c) c ## u
#  define UINT16_C(c) c ## u
#  define UINT32_C(c) c ## UL
#  define UINT64_C(c) c ## ui64
#elif defined(__BORLANDC__) && (__BORLANDC__ < 0x600) /* Borland before 6.0 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "I64Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#  define UINT8_C(c) c ## u
#  define UINT16_C(c) c ## u
#  define UINT32_C(c) c ## UL
#  define UINT64_C(c) c ## ui64
#elif defined(__FreeBSD__) && (__FreeBSD__ < 5) /* FreeBSD before 5.0 */ && !defined (_SYS_INTTYPES_H_)
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed long long int int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned long long int uint64_t;
#elif defined(__CYGWIN__) && defined(__BIT_TYPES_DEFINED__) /* Cygwin defines intxx_t in sys/types.h instead of inttypes.h */
#  include <cygwin/version.h>
#  if defined(CYGWIN_VERSION_DLL_MAJOR) && (CYGWIN_VERSION_DLL_MAJOR<1005)
typedef unsigned char uint8_t;
typedef __uint16_t uint16_t;
typedef __uint32_t uint32_t;
typedef __uint64_t uint64_t;
#  endif
#elif defined(SASC)
#    error("Too old SAS/C compiler, sorry.");
#elif defined(__SASC__)
#  if (__SASC__ < 750 ) /*  SAS/C before 7.50 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed long long int int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned long long int uint64_t;
#  endif
#else
#  include <inttypes.h>
#  if !defined(INT8_MAX) && defined(INT16_MAX)
/* int8_t is not mandatory */
typedef int_least8_t int8_t;
#  endif
#endif

#if !defined(PRId16)
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "lld"
#elif !defined(PRId8)
#  define PRId8 "d"
#endif
#if !defined(INT16_C)
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## LL
#  define UINT8_C(c) c ## u
#  define UINT16_C(c) c ## u
#  define UINT32_C(c) c ## UL
#  define UINT64_C(c) c ## ULL
#elif !defined(INT8_C)
#  define INT8_C(c) c
#  define UINT8_C(c) c ## u
#endif
#if !defined(INT16_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#  define INT8_MAX (INT8_C(127))
#  define INT16_MIN (-INT16_C(32767)-1)
#  define INT16_MAX (INT16_C(32767))
#  define INT32_MIN (-INT32_C(2147483647)-1)
#  define INT32_MAX (INT32_C(2147483647))
#  define INT64_MIN (-INT64_C(9223372036854775807)-1)
#  define INT64_MAX (INT64_C(9223372036854775807))
#elif !defined(INT8_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#endif

/*
 C compiler specific declaration for non-returning functions. Use
 NO_RETURN void foo(int bar);
 to declare a function prototype for function that doesn't return.
 */
#if defined __GNUC__
#  define NO_RETURN __attribute__ ((noreturn))
#elif defined __POCC__ || defined __BORLANDC__ || defined _MSC_VER
#  define NO_RETURN __declspec(noreturn)
#else
#  define NO_RETURN
/* maybe some warning occur unless NO_RETURN is defined for your compiler */
#endif

/*
  Endian stuff
*/
#if defined(BSD) && (BSD >= 199103)
#  include <machine/endian.h>
#elif defined(__alpha__) || defined(__alpha) || defined(_M_ALPHA)
/* bi-endian processor, current mode should be find in machine/endian.h file */
#  include <machine/endian.h>
#elif defined(linux)
#  include <endian.h>
#endif



#if !defined(BYTE_ORDER) && defined(__BYTE_ORDER)
#  define BYTE_ORDER      __BYTE_ORDER
#endif

#if !defined(LITTLE_ENDIAN) && defined(__LITTLE_ENDIAN)
#  define LITTLE_ENDIAN      __LITTLE_ENDIAN
#endif

#if !defined(BIG_ENDIAN) && defined(__BIG_ENDIAN)
#  define BIG_ENDIAN      __BIG_ENDIAN
#endif

#if !defined(LITTLE_ENDIAN)
#  define LITTLE_ENDIAN   1234    /* LSB first (vax, pc) */
#endif
#if !defined(BIG_ENDIAN)
#  define BIG_ENDIAN      4321    /* MSB first (IBM, net) */
#endif
#if !defined(PDP_ENDIAN)
#  define PDP_ENDIAN      3412    /* LSB first in word, MSW first in long */
#endif

#if !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_RIGHT)
#  define BYTE_ORDER      LITTLE_ENDIAN
#elif !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_LEFT)
#  define BYTE_ORDER      BIG_ENDIAN
#elif !defined(BYTE_ORDER)

/* ARM */
#  if defined(__ARMEL__)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  elif defined(__ARMEB__)
#    define BYTE_ORDER      BIG_ENDIAN
#  elif defined(__arm__)
#    error "ARMs are bi-endian processors. Endianness is unknown for this system, please drop an e-mail to liberty-eiffel@gnu.org"
#  endif

/* HP RISC */
#  if defined(__hppa__) || defined(__hppa) || defined(__hp9000) || \
          defined(__hp9000s300) || defined(hp9000s300) || \
          defined(__hp9000s700) || defined(hp9000s700) || \
          defined(__hp9000s800) || defined(hp9000s800) || defined(hp9000s820)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* IBM */
#  if defined(ibm032) || defined(ibm370) || defined(_IBMR2) || \
          defined(IBM370) || defined(__MVS__)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Intel x86 */
#  if defined(i386) || defined(__i386__) || defined(__i386) || \
          defined(_M_IX86) || defined(_X86_) || defined(__THW_INTEL) || \
          defined(sun386)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Intel Itanium */
#  if defined(__ia64__) || defined(_IA64) || defined(__IA64__) || \
          defined(_M_IA64) || defined(_M_AMD64) || defined(_M_IX86) || defined(_AMD64_)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Nationnal Semiconductor 32000 serie */
#  if  defined(ns32000)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Motorola 68000 */
#  if defined(mc68000) || defined(is68k) || defined(macII) || defined(m68k)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* MIPS */
#  if defined(MIPSEL) || defined(_MIPSEL)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  elif defined(MIPSEB) || defined(_MIPSEB)
#    define BYTE_ORDER      BIG_ENDIAN
#  elif defined(__mips__) || defined(__mips) || defined(__MIPS__)
#    error "MIPS are bi-endian processors. Endianness is unknown for this system, please drop an e-mail to liberty-eiffel@gnu.org"
#  endif

/* Power PC */
/* this processor is bi-endian, how to know if little-endian is set? */
#  if defined(__powerpc) || defined(__powerpc__) || defined(__POWERPC__) || \
          defined(__ppc__) || defined(__ppc) || defined(_M_PPC) || \
          defined(__PPC) || defined(__PPC__)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Pyramid 9810 */
#  if defined(pyr)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* RS/6000 */
#  if defined(__THW_RS6000) || defined(_IBMR2) || defined(_POWER) || \
          defined(_ARCH_PWR) || defined(_ARCH_PWR2)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* SPARC */
#  if defined(__sparc__) || defined(sparc) || defined(__sparc)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* CCI Tahoe */
#  if defined(tahoe)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* VAX */
#  if defined(vax) || defined(VAX) || defined(__vax__) || defined(_vax_) || \
          defined(__vax) || defined(__VAX)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* ELATE is a virtual OS with a little endian Virtual Processor */
#  if defined(__ELATE__)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous little endian */
#  if defined(wrltitan)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous big endian */
#  if defined(apollo) || defined(__convex__) || defined(_CRAY) || defined(sel)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif
#endif


#if !defined(BYTE_ORDER)
#  error "Unknown byte order. Add your system in above macros once you know your system type. Please drop an e-mail to liberty-eiffel@gnu.org"
#endif
#if (BYTE_ORDER != BIG_ENDIAN && BYTE_ORDER != LITTLE_ENDIAN)
#  error "Only little-endian and big-endian are valid at this time. Please drop an e-mail to liberty-eiffel@gnu.org"
#endif


/*
  Byte swapping stuff
*/
extern void copy_swap_16(const uint16_t *src, uint16_t *dest, int count);


/* Because ANSI C EXIT_* are not always defined: */
#ifndef EXIT_FAILURE
#  define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS 0
#endif

/*
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.

   NOTE: with gcc, -ansi is used for SmartEiffel generated files EXCEPT in
   -no_split mode. ANSI only recognizes the non-sig versions.
*/
#if (defined(_SIGSET_H_types) && !defined(__STRICT_ANSI__))
#  define JMP_BUF    sigjmp_buf
#  define SETJMP(x)  sigsetjmp( (x), 1)
#  define LONGJMP    siglongjmp
#else
#  define JMP_BUF    jmp_buf
#  define SETJMP(x)  setjmp( (x) )
#  define LONGJMP    longjmp
#endif

/*
   Type to store reference objects Id:
 */
typedef int Tid;
typedef struct S0 T0;
struct S0{Tid id;};

/*
   The default channel used to print runtime error messages:
*/
#define SE_ERR stderr

/*
   Eiffel type INTEGER_8 is #1:
*/
typedef int8_t T1;
#define EIF_INTEGER_8 T1
#define M1 (INT8_C(0))
#define EIF_INTEGER_8_BITS (CHAR_BIT)
#define EIF_MINIMUM_INTEGER_8 (INT8_MIN)
#define EIF_MAXIMUM_INTEGER_8 (INT8_MAX)

/*
  Eiffel type INTEGER_16 is #10:
*/
typedef int16_t T10;
#define EIF_INTEGER_16 T10
#define M10 (INT16_C(0))
#define EIF_INTEGER_16_BITS (CHAR_BIT*sizeof(T10t))
#define EIF_MINIMUM_INTEGER_16 (INT16_MIN) /*-32768*/
#define EIF_MAXIMUM_INTEGER_16 (INT16_MAX) /*+32767*/

/*
  Eiffel type INTEGER or INTEGER_32 is #2:
*/
typedef int32_t T2;
#define EIF_INTEGER T2
#define EIF_INTEGER_32 T2
#define M2 (INT32_C(0))
#define EIF_INTEGER_BITS ((T2)(CHAR_BIT*sizeof(T2)))
#define EIF_INTEGER_32_BITS EIF_INTEGER_BITS
#define EIF_MINIMUM_INTEGER (INT32_MIN)
#define EIF_MAXIMUM_INTEGER (INT32_MAX)

/*
  Eiffel type INTEGER_64 is #11:
*/
typedef int64_t T11;
#define EIF_INTEGER_64 T11
#define M11 (INT64_C(0))
#define EIF_INTEGER_64_BITS (CHAR_BIT*sizeof(T11))
#define EIF_MINIMUM_INTEGER_64 (INT64_MIN)
#define EIF_MAXIMUM_INTEGER_64 (INT64_MAX)

/*
  Eiffel type CHARACTER is #3:
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT)
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T10)(x))
#define T3to_integer(x) ((signed char)(x))
#define T3to_integer_8(x) ((signed char)(x))
#define T3to_bit(x) (x)

/*
  Eiffel type REAL_32 is #4:
*/
typedef float T4;
typedef T4 real32_t;
#define EIF_REAL_32 T4
#define M4 (0.0)
#define EIF_MINIMUM_REAL_32 (-(FLT_MAX))
#define EIF_MAXIMUM_REAL_32 (FLT_MAX)

/*
  Eiffel type REAL or REAL_64 is #5:
*/
typedef double T5;
typedef T5 real64_t;
#define EIF_REAL T5
#define EIF_REAL_64 T5
#define M5 (0.0)
#define EIF_MINIMUM_REAL_64 (-(DBL_MAX))
#define EIF_MINIMUM_REAL (EIF_MINIMUM_REAL_64)
#define EIF_MAXIMUM_REAL_64 (DBL_MAX)
#define EIF_MAXIMUM_REAL (EIF_MAXIMUM_REAL_64)

/*
  Eiffel type REAL_EXTENDED is #12:
*/
typedef long double T12;
typedef T12 real_extended_t;
#define EIF_REAL_EXTENDED T12
#define EIF_REAL_128 T12
#define M12 (0.0)
#define EIF_MINIMUM_REAL_EXTENDED (-(DBL_MAX))
#define EIF_MAXIMUM_REAL_EXTENDED (DBL_MAX)

/*
  Eiffel type BOOLEAN is #6:
*/
typedef char T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT)

/*
   Eiffel type POINTER is #8:
*/
typedef void* T8;
#define EIF_POINTER T8
/* Sometimes, NULL is defined as 0 */
#define M8 ((void*)NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(void*))

/*
  To use type STRING on the C side:
*/
#define EIF_STRING T7*

/*
  Some Other EIF_* defined in ETL:
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ
#define EIF_ANY EIF_OBJ

/*
   Wrappers for `malloc' and `calloc':
*/
void se_check_malloc(const void*result, const char*format, ...);
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);
void* se_realloc(void* src, size_t size);
void* se_malloc_(size_t size, void*(*alloc)(size_t));
void* se_calloc_(size_t nmemb, size_t size, void*(*alloc)(size_t,size_t));

/*
   die method.
 */
void se_die(int code);

/*
        Runtime hooks. They allow different runtime modules to be quite independant. In time, they will also allow
        thread-safe operations.

        Currently known modules:
          - boost
          - no_check
          - sedb
          - gc
          - print stack
          - profile
          - plugins

        However, currently only profile uses this method. It will be extended to other modules later.

        The currently defined hooks are described in the enum below (the names should be self-explanatory).
 */
typedef enum {
  SE_HANDLE_EXCEPTION_SET, /* called when an exception handler is set, prior to SETJMP */
  SE_HANDLE_EXCEPTION_CLEAR, /* called when a feature with an exception handler normally returns */
  SE_HANDLE_EXCEPTION_THROWN, /* called when an exception is thrown, prior to the LONGJMP */
  SE_HANDLE_ENTER_GC, /* called when gc_start() begins */
  SE_HANDLE_EXIT_GC, /* called when gc_start() ends */
  SE_HANDLE_ENTER_PRINT_STACK, /* called when se_print_run_time_stack() begins */
  SE_HANDLE_EXIT_PRINT_STACK, /* called when se_print_run_time_stack() ends */
  SE_HANDLE_NO_MORE_MEMORY, /* called by se_alloc() and co */
  SE_HANDLE_SEDB_BREAK, /* called when sedb stops the program */
  SE_HANDLE_SEDB_CONTINUE, /* called when sedb continues the program */
  SE_HANDLE_RUNTIME_ERROR, /* called when a runtime error is raised and not caught by an exception. Cannot be raised in boost mode. */
  SE_HANDLE_DIE_WITH_CODE, /* called when the program is stopped by the die_with_code feature. The data points to the int code. */
  SE_HANDLE_NORMAL_EXIT /* called when the program correctly terminates. The data is null. */
} se_handler_action_t;

extern int handlers_count;
typedef void se_runtime_handler_t(se_handler_action_t action, void*data);
void register_handler(se_runtime_handler_t*handler);
void _handle(se_handler_action_t action, void*data);

#define handle(action,data) do{if(handlers_count>0)_handle(action,data);}while(0)

#endif /* #ifndef _BASE_H */
#define SE_BOOST 1
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#ifndef WIN32
#  include <dirent.h>
#endif
#ifndef WIN32
#  include <unistd.h>
#endif

EIF_POINTER directory_open(EIF_POINTER path);
EIF_POINTER directory_read_entry(EIF_POINTER dirstream);
EIF_POINTER directory_get_entry_name(EIF_POINTER entry);
EIF_BOOLEAN directory_close(EIF_POINTER dirstream);
#define directory_current_working_directory (directory_cwd())
EIF_POINTER directory_cwd(void);
EIF_BOOLEAN directory_chdir(EIF_POINTER destination);
EIF_BOOLEAN directory_mkdir(EIF_POINTER directory_path);
EIF_BOOLEAN directory_rmdir(EIF_POINTER directory_path);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define basic_exec_system_none  0
#define basic_exec_system_posix 1
#define basic_exec_system_win32 2

#include "eiffel_exec.h"

/***************************
 * Common macros and types *
 * basic_exec_xxx          *
 ***************************/

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE || defined  __APPLE__

/*#  include <unistd.h> done in base.h */
/*#  include <sys/types.h> done in base.h */
#include <sys/wait.h>

typedef struct se_exec_data se_exec_data_t;
struct se_exec_data {
  pid_t id; /* the launched child process id */
  int running; /* true if the process is running */
  int child; /* true if the process is the child itself (useful for duplicate) */
  int status; /* the status of the child process if finished */
};

extern char** environ;

#define basic_exec_id(data) (((se_exec_data_t*)data)->id)
#define basic_exec_is_child(data) (((se_exec_data_t*)data)->child)
#define basic_exec_status(data) (((se_exec_data_t*)data)->status)
#define basic_exec_alloc_pipe() (calloc(2, sizeof(int)))
#define basic_exec_free_pipe(p) (free(p))
#define basic_exec_alloc_data() ((se_exec_data_t*)se_malloc(sizeof(se_exec_data_t)))
#define basic_exec_free_data(p) (free(p))
#define basic_exec_init_pipe(p) ((EIF_BOOLEAN)(pipe(p)>=0))
#define basic_exec_system basic_exec_system_posix

#elif defined WIN32
/*#  include <windows.h> done in base.h */

typedef struct se_exec_data se_exec_data_t;
struct se_exec_data {
  PROCESS_INFORMATION process_information;
  int running;
  DWORD status;
};

#define basic_exec_id(data) (((se_exec_data_t*)data)->process_information.dwProcessId)
#define basic_exec_is_child(data) (0)
#define basic_exec_status(data) (((se_exec_data_t*)data)->status)

#define basic_exec_alloc_pipe() (calloc(2, sizeof(HANDLE)))
#define basic_exec_free_pipe(p) (free(p))
#define basic_exec_alloc_data() ((se_exec_data_t*)se_malloc(sizeof(se_exec_data_t)))
#define basic_exec_free_data(p) (free(p))
#define basic_exec_system basic_exec_system_win32

extern EIF_BOOLEAN basic_exec_init_pipe(HANDLE*p);

#else
/* Dummy implementation that always reports an error back to the Eiffel side */
typedef int se_exec_data_t;

#define basic_exec_id(data) (-1)
#define basic_exec_is_child(data) (0)
#define basic_exec_status(data) (0)

#define basic_exec_alloc_pipe() (NULL)
#define basic_exec_free_pipe(p) /* dummy */
#define basic_exec_alloc_data() ((se_exec_data_t*)NULL)
#define basic_exec_free_data(p) /* dummy */
#define basic_exec_init_pipe(p) ((EIF_BOOLEAN)0)
#define basic_exec_system basic_exec_system_none

#endif

/***********************************
 * Prototypes for common functions *
 * basic_exec_xxx                  *
 ***********************************/

extern EIF_BOOLEAN basic_exec_is_finished(se_exec_data_t*data);
extern void basic_exec_wait(se_exec_data_t*data);
extern void basic_exec_cleanup(se_exec_data_t*data, int status);

/*************************************************
 * Posix-specific function prototypes and macros *
 * basic_exec_posix_xxx                          *
 *************************************************/

extern EIF_BOOLEAN basic_exec_posix_execute(se_exec_data_t*data, char*prog, char**args, EIF_BOOLEAN keep_env, char**add_env, int*in_fd, int*out_fd, int*err_fd);
extern EIF_INTEGER basic_exec_posix_get_character (EIF_INTEGER fd);
extern void basic_exec_posix_put_character(EIF_INTEGER fd, EIF_CHARACTER c);
extern void basic_exec_posix_wait_any(se_exec_data_t*data);
extern void basic_exec_posix_any_finished(se_exec_data_t*data);

#if basic_exec_system == basic_exec_system_posix
#define basic_exec_posix_flush(fd) (fsync(fd))
#define basic_exec_posix_close(fd) (close(fd))
#define basic_exec_posix_kill(data, sig) (kill((data)->id, (sig)))
#define basic_exec_posix_get_in_descriptor(pipe) (((int*)pipe)[0])
#define basic_exec_posix_get_out_descriptor(pipe) (((int*)pipe)[1])
#else
#define basic_exec_posix_flush(fd) /* dummy */
#define basic_exec_posix_close(fd) /* dummy */
#define basic_exec_posix_kill(data, sig) /* dummy */
#define basic_exec_posix_get_in_descriptor(pipe) 0
#define basic_exec_posix_get_out_descriptor(pipe) 0
#endif

/*************************************************
 * Win32-specific function prototypes and macros *
 * basic_exec_win32_xxx                          *
 *************************************************/

#if basic_exec_system == basic_exec_system_win32
#define basic_exec_win32_flush(h) FlushFileBuffers((HANDLE)h)
#define basic_exec_win32_close(h) CloseHandle((HANDLE)h)
#define basic_exec_win32_handle(data) ((int)((se_exec_data_t*)data)->process_information.hProcess)
#define basic_exec_win32_maximum_wait (MAXIMUM_WAIT_OBJECTS)
extern EIF_BOOLEAN basic_exec_win32_execute(se_exec_data_t*data, char*args, EIF_BOOLEAN keep_env, char*add_env, HANDLE*in_h, HANDLE*out_h, HANDLE*err_h);
extern EIF_BOOLEAN basic_exec_win32_wait_any(HANDLE*handles, DWORD count, se_exec_data_t*data);
extern EIF_BOOLEAN basic_exec_win32_any_finished(HANDLE*handles, DWORD count, se_exec_data_t*data);
extern void basic_exec_win32_put_character(HANDLE h, EIF_CHARACTER c);
extern EIF_INTEGER basic_exec_win32_get_character (HANDLE h);
#define basic_exec_win32_get_in_handle(pipe) (((HANDLE*)pipe)[0])
#define basic_exec_win32_get_out_handle(pipe) (((HANDLE*)pipe)[1])
#else
#define basic_exec_win32_flush(h) /* dummy */
#define basic_exec_win32_close(h) /* dummy */
#define basic_exec_win32_handle(data) (0)
#define basic_exec_win32_maximum_wait (0)
extern EIF_BOOLEAN basic_exec_win32_execute(se_exec_data_t*data, char*args, EIF_BOOLEAN keep_env, char*add_env, void*in_h, void*out_h, void*err_h);
extern EIF_BOOLEAN basic_exec_win32_wait_any(void*handles, int count, se_exec_data_t*data);
extern EIF_BOOLEAN basic_exec_win32_any_finished(void*handles, int count, se_exec_data_t*data);
extern void basic_exec_win32_put_character(void*h, EIF_CHARACTER c);
extern EIF_INTEGER basic_exec_win32_get_character (void*h);
#define basic_exec_win32_get_in_handle(pipe) NULL
#define basic_exec_win32_get_out_handle(pipe) NULL
#endif

extern void basic_exec_waitpid_init(EIF_OBJECT);
extern EIF_INTEGER basic_exec_waitpid_fd(void);
extern EIF_INTEGER basic_exec_waitpid_read_buffer(void*);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define mbi_unsigned_32_to_integer_64(x) (((int64_t)((uint32_t)(x))))
#define mbi_unsigned_less_than(a,b) ((((uint32_t)(a)) < ((uint32_t)(b))))
#define mbi_unsigned_greater_than(a,b) ((((uint32_t)(a)) > ((uint32_t)(b))))
#define mbi_unsigned_greater_or_equal(a,b) ((((uint32_t)(a)) >= ((uint32_t)(b))))
#define mbi_storage_at(s, n) (((s)+(n)))
EIF_BOOLEAN mbi_inc (int32_t *p);
EIF_BOOLEAN mbi_add (int32_t a, int32_t b, int32_t *p);
EIF_BOOLEAN mbi_add_with_inc (int32_t a, int32_t b, int32_t *p);
EIF_BOOLEAN mbi_dec (int32_t *p);
EIF_BOOLEAN mbi_subtract (int32_t a, int32_t b, int32_t *p);
EIF_BOOLEAN mbi_subtract_with_dec (int32_t a, int32_t b, int32_t *p);
EIF_INTEGER mbi_multiply (int32_t a, int32_t b, int32_t *p);
EIF_INTEGER mbi_multiply_with_add (int32_t a, int32_t b, int32_t c, int32_t *p);
EIF_INTEGER mbi_multiply_with_2_add (int32_t a, int32_t b, int32_t c, int32_t d, int32_t *p);
EIF_INTEGER mbi_divide (int32_t a, int32_t b, int32_t d, int32_t *r);



/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define basic_getenv(v) (getenv((char*)v))
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/

EIF_INTEGER fstat_st_size(EIF_POINTER path);
EIF_INTEGER_64 fstat_st_mtime(EIF_POINTER path);
EIF_BOOLEAN fstat_st_is_file(EIF_POINTER path);
EIF_BOOLEAN fstat_st_is_dir(EIF_POINTER path);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#include <errno.h>

#define text_file_read_open(p) (fopen(((char*)(p)),"r"))
#define text_file_write_open(p) (fopen(((char*)(p)),"w"))
#define text_file_write_append(p) (fopen(((char*)(p)),"a"))
#define text_file_read_write_open(p) (fopen(((char*)(p)),"r+"))
#define text_file_read_write_append(p) (fopen(((char*)(p)),"a+"))
#define binary_file_read_open(p) (fopen(((char*)(p)),"rb"))
#define binary_file_write_open(p) (fopen(((char*)(p)),"wb"))
#define binary_file_write_append(p) (fopen(((char*)(p)),"ab"))
#define io_fclose(p) (fclose((FILE*)(p)))
#define io_flush(p) (fflush((FILE*)(p)))
#define io_getc(f) (getc(((FILE*)(f))))
#define io_putc(b, f) (putc((b),((FILE*)(f))))
#define io_ungetc(b, f) (ungetc((b), (FILE*)(f)))
#define io_fread(b, n, f) (fread((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define io_fwrite(b, n, f) (fwrite((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define io_feof(f) (feof(((FILE*)(f))))
#define io_rename(o, n) (rename(((char*)(o)),((char*)(n))) == 0)
#define io_remove(f) (remove(((char*)(f))) == 0)
#define io_fseek(f, o) (fseek((FILE*)(f),(o),SEEK_SET))
#define io_ftell(f) ((EIF_INTEGER_64)ftell((FILE*)(f)))

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  define read_stdin(b, s) (read(STDIN_FILENO, b, s))
#else
   extern int read_stdin(EIF_CHARACTER *buffer, int size);
#endif

extern int io_copy(char*source, char*target);
extern int io_file_exists(char*source);
extern int io_same_physical_file(char*path1,char*path2);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define pointer_hash_code(p) (((unsigned int)(unsigned long)(p))>>1)
#define pointer_to_natural_32(p) ((unsigned int) (p))
#define pointer_to_any(p) ((T0*)(p))
#define pointer_plus(p, o) (((char*)(p))+o)
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#ifdef WIN32
#  include <time.h>
#else
#  include <sys/time.h>
#endif

extern EIF_INTEGER basic_microsecond_microsecond;
extern EIF_INTEGER_64 basic_microsecond_time;
#define basic_microsecond_update (_basic_microsecond_update())
void _basic_microsecond_update(void);
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define sprintf_pointer(buffer, pointer) sprintf((char*)(buffer),"%p",pointer)
void sprintf_real_64(EIF_CHARACTER* b, EIF_CHARACTER m, int32_t f, real64_t r);
void sprintf_real_extended(EIF_CHARACTER* b, EIF_CHARACTER m, int32_t f, real_extended_t r);
/* C Header Pass 1: */
typedef union _se_agent se_agent;
typedef struct _se_agent0 se_agent0;
typedef struct S29 T29;
typedef int T296;
typedef struct S113 T113;
typedef struct S126 T126;
typedef void*T903;
typedef struct S104 T104;
typedef struct S283 T283;
typedef struct S117 T117;
typedef struct S111 T111;
typedef struct S291 T291;
typedef void*T281;
typedef int T297;
typedef struct S7 T7;
typedef struct S909 T909;
typedef struct S293 T293;
typedef struct S86 T86;
typedef struct S910 T910;
typedef struct S295 T295;
typedef int T554;
typedef struct S546 T546;
typedef struct S78 T78;
typedef struct S911 T911;
typedef struct S557 T557;
typedef struct S561 T561;
typedef struct S562 T562;
typedef struct S563 T563;
typedef struct S564 T564;
typedef struct S565 T565;
typedef struct S912 T912;
typedef struct S913 T913;
typedef struct S102 T102;
typedef struct S556 T556;
typedef int T545;
typedef struct S464 T464;
typedef struct S665 T665;
typedef struct S81 T81;
typedef struct S69 T69;
typedef struct S467 T467;
typedef struct S123 T123;
typedef struct S708 T708;
typedef struct S709 T709;
typedef struct S704 T704;
typedef struct S914 T914;
typedef struct S107 T107;
typedef struct S566 T566;
typedef struct S710 T710;
typedef struct S351 T351;
typedef struct S437 T437;
typedef struct S915 T915;
typedef struct S333 T333;
typedef struct S711 T711;
typedef struct S916 T916;
typedef struct S447 T447;
typedef struct S790 T790;
typedef struct S588 T588;
typedef struct S621 T621;
typedef struct S622 T622;
typedef struct S623 T623;
typedef struct S624 T624;
typedef struct S625 T625;
typedef struct S637 T637;
typedef struct S638 T638;
typedef struct S639 T639;
typedef struct S641 T641;
typedef struct S642 T642;
typedef struct S646 T646;
typedef struct S647 T647;
typedef struct S648 T648;
typedef struct S649 T649;
typedef struct S650 T650;
typedef struct S651 T651;
typedef struct S652 T652;
typedef struct S654 T654;
typedef struct S655 T655;
typedef struct S653 T653;
typedef struct S656 T656;
typedef struct S657 T657;
typedef struct S658 T658;
typedef struct S917 T917;
typedef struct S552 T552;
typedef struct S97 T97;
typedef struct S91 T91;
typedef struct S383 T383;
typedef void*T110;
typedef struct S95 T95;
typedef struct S286 T286;
typedef struct S89 T89;
typedef struct S919 T919;
typedef struct S920 T920;
typedef struct S921 T921;
typedef struct S306 T306;
typedef struct S108 T108;
typedef void*T116;
typedef void*T125;
typedef struct S124 T124;
typedef void*T127;
typedef struct S452 T452;
typedef struct S923 T923;
typedef struct S924 T924;
typedef struct S925 T925;
typedef struct S341 T341;
typedef struct S120 T120;
typedef struct S290 T290;
typedef struct S926 T926;
typedef struct S441 T441;
typedef struct S929 T929;
typedef int T587;
typedef struct S930 T930;
typedef struct S931 T931;
typedef struct S932 T932;
typedef struct S727 T727;
typedef struct S728 T728;
typedef struct S729 T729;
typedef struct S318 T318;
typedef struct S935 T935;
typedef struct S936 T936;
typedef struct S719 T719;
typedef struct S551 T551;
typedef struct S937 T937;
typedef struct S938 T938;
typedef struct S720 T720;
typedef struct S939 T939;
typedef int T940;
typedef struct S340 T340;
typedef struct S943 T943;
typedef int T807;
typedef struct S804 T804;
typedef struct S806 T806;
typedef int T944;
typedef struct S945 T945;
typedef struct S946 T946;
typedef struct S59 T59;
typedef struct S805 T805;
typedef struct S947 T947;
typedef struct S953 T953;
typedef struct S954 T954;
typedef int T80;
typedef struct S955 T955;
typedef int T957;
typedef struct S959 T959;
typedef struct S106 T106;
typedef struct S962 T962;
typedef struct S783 T783;
typedef struct S825 T825;
typedef struct S964 T964;
typedef struct S966 T966;
typedef struct S968 T968;
typedef struct S970 T970;
typedef struct S785 T785;
typedef struct S491 T491;
typedef struct S973 T973;
typedef struct S367 T367;
typedef struct S974 T974;
typedef struct S407 T407;
typedef struct S975 T975;
typedef struct S462 T462;
typedef struct S433 T433;
typedef struct S395 T395;
typedef struct S439 T439;
typedef struct S440 T440;
typedef struct S505 T505;
typedef struct S514 T514;
typedef struct S516 T516;
typedef struct S121 T121;
typedef struct S517 T517;
typedef struct S458 T458;
typedef struct S423 T423;
typedef struct S480 T480;
typedef struct S418 T418;
typedef struct S449 T449;
typedef struct S455 T455;
typedef struct S453 T453;
typedef struct S456 T456;
typedef struct S396 T396;
typedef struct S450 T450;
typedef struct S422 T422;
typedef struct S448 T448;
typedef struct S451 T451;
typedef struct S459 T459;
typedef struct S518 T518;
typedef struct S504 T504;
typedef struct S292 T292;
typedef struct S461 T461;
typedef struct S436 T436;
typedef struct S282 T282;
typedef struct S486 T486;
typedef struct S488 T488;
typedef struct S489 T489;
typedef struct S490 T490;
typedef struct S438 T438;
typedef struct S976 T976;
typedef struct S289 T289;
typedef struct S497 T497;
typedef struct S977 T977;
typedef struct S538 T538;
typedef struct S507 T507;
typedef struct S416 T416;
typedef struct S493 T493;
typedef struct S386 T386;
typedef struct S494 T494;
typedef struct S495 T495;
typedef struct S370 T370;
typedef struct S361 T361;
typedef struct S364 T364;
typedef struct S366 T366;
typedef struct S355 T355;
typedef struct S359 T359;
typedef struct S360 T360;
typedef struct S509 T509;
typedef struct S510 T510;
typedef struct S511 T511;
typedef struct S499 T499;
typedef struct S400 T400;
typedef struct S471 T471;
typedef struct S481 T481;
typedef struct S500 T500;
typedef struct S535 T535;
typedef struct S536 T536;
typedef struct S978 T978;
typedef struct S979 T979;
typedef struct S468 T468;
typedef struct S469 T469;
typedef struct S980 T980;
typedef struct S406 T406;
typedef struct S981 T981;
typedef struct S684 T684;
typedef struct S982 T982;
typedef struct S435 T435;
typedef struct S983 T983;
typedef struct S403 T403;
typedef struct S537 T537;
typedef struct S984 T984;
typedef struct S496 T496;
typedef struct S427 T427;
typedef struct S413 T413;
typedef struct S985 T985;
typedef struct S371 T371;
typedef struct S384 T384;
typedef struct S376 T376;
typedef struct S498 T498;
typedef struct S443 T443;
typedef struct S484 T484;
typedef struct S485 T485;
typedef struct S378 T378;
typedef struct S419 T419;
typedef struct S482 T482;
typedef struct S513 T513;
typedef struct S503 T503;
typedef struct S381 T381;
typedef struct S409 T409;
typedef struct S483 T483;
typedef struct S477 T477;
typedef struct S410 T410;
typedef struct S680 T680;
typedef struct S502 T502;
typedef struct S472 T472;
typedef struct S411 T411;
typedef struct S473 T473;
typedef struct S475 T475;
typedef struct S512 T512;
typedef struct S534 T534;
typedef struct S533 T533;
typedef struct S529 T529;
typedef struct S530 T530;
typedef struct S531 T531;
typedef struct S532 T532;
typedef struct S528 T528;
typedef struct S389 T389;
typedef struct S412 T412;
typedef struct S524 T524;
typedef struct S525 T525;
typedef struct S526 T526;
typedef struct S527 T527;
typedef struct S417 T417;
typedef struct S523 T523;
typedef struct S520 T520;
typedef struct S521 T521;
typedef struct S522 T522;
typedef struct S519 T519;
typedef struct S476 T476;
typedef struct S479 T479;
typedef struct S478 T478;
typedef struct S988 T988;
typedef struct S446 T446;
typedef struct S784 T784;
typedef struct S470 T470;
typedef struct S372 T372;
typedef struct S425 T425;
typedef struct S408 T408;
typedef struct S989 T989;
typedef struct S990 T990;
typedef struct S421 T421;
typedef T0 T991;
typedef struct S993 T993;
typedef struct S995 T995;
typedef struct S997 T997;
typedef struct S998 T998;
typedef struct S463 T463;
typedef struct S999 T999;
typedef struct S445 T445;
typedef struct S460 T460;
typedef struct S1000 T1000;
typedef struct S442 T442;
typedef struct S415 T415;
typedef struct S1001 T1001;
typedef struct S1002 T1002;
typedef struct S101 T101;
typedef struct S1004 T1004;
typedef struct S701 T701;
typedef struct S1005 T1005;
typedef T0 T1006;
typedef T0 T1008;
typedef struct S1010 T1010;
typedef struct S1011 T1011;
typedef struct S543 T543;
typedef struct S1013 T1013;
typedef struct S1014 T1014;
typedef struct S1017 T1017;
typedef struct S1018 T1018;
typedef struct S1021 T1021;
typedef struct S1022 T1022;
typedef struct S1023 T1023;
typedef struct S1024 T1024;
typedef struct S1027 T1027;
typedef struct S1031 T1031;
typedef struct S1036 T1036;
typedef struct S1037 T1037;
typedef struct S1038 T1038;
typedef struct S1039 T1039;
typedef struct S1040 T1040;
typedef struct S547 T547;
typedef struct S1041 T1041;
typedef struct S1042 T1042;
typedef struct S581 T581;
typedef struct S1044 T1044;
typedef struct S1045 T1045;
typedef struct S1046 T1046;
/*BUG:NA@runtime!*/typedef struct S379 T379;
typedef struct S1049 T1049;
typedef struct S1051 T1051;
typedef struct S1052 T1052;
typedef struct S1053 T1053;
typedef struct S1054 T1054;
typedef struct S660 T660;
typedef struct S1055 T1055;
typedef struct S1056 T1056;
typedef struct S1057 T1057;
typedef struct S348 T348;
typedef struct S1058 T1058;
typedef struct S1063 T1063;
typedef struct S1064 T1064;
typedef struct S1065 T1065;
typedef struct S1066 T1066;
typedef struct S1069 T1069;
typedef struct S1072 T1072;
typedef struct S1075 T1075;
typedef struct S1079 T1079;
typedef struct S842 T842;
typedef void*T843;
typedef struct S844 T844;
typedef struct S846 T846;
typedef struct S848 T848;
typedef struct S849 T849;
typedef struct S850 T850;
typedef struct S851 T851;
typedef struct S1080 T1080;
typedef struct S845 T845;
typedef struct S852 T852;
typedef struct S1081 T1081;
typedef struct S1084 T1084;
typedef struct S1086 T1086;
typedef struct S1089 T1089;
typedef struct S583 T583;
typedef struct S1091 T1091;
typedef struct S1093 T1093;
typedef T0 T1094;
typedef struct S1095 T1095;
typedef struct S1096 T1096;
typedef struct S324 T324;
typedef int T747;
typedef struct S1098 T1098;
typedef struct S1101 T1101;
typedef T0 T1102;
/*BUG:NA@runtime!*/typedef struct S707 T707;
typedef struct S1105 T1105;
typedef struct S1106 T1106;
typedef struct S542 T542;
typedef struct S1108 T1108;
typedef struct S809 T809;
typedef struct S1110 T1110;
typedef struct S1111 T1111;
typedef struct S1113 T1113;
typedef struct S1116 T1116;
typedef struct S1119 T1119;
typedef struct S1122 T1122;
typedef struct S1124 T1124;
typedef struct S726 T726;
typedef struct S699 T699;
typedef struct S696 T696;
typedef struct S584 T584;
typedef struct S700 T700;
typedef struct S1128 T1128;
typedef struct S1130 T1130;
typedef struct S693 T693;
typedef struct S686 T686;
typedef struct S689 T689;
typedef struct S691 T691;
typedef struct S698 T698;
typedef struct S692 T692;
typedef struct S688 T688;
typedef struct S690 T690;
typedef struct S697 T697;
typedef struct S432 T432;
typedef struct S1132 T1132;
typedef struct S1133 T1133;
typedef struct S1134 T1134;
typedef struct S1135 T1135;
typedef struct S713 T713;
/*BUG:NA@runtime!*/typedef void*T353;
/*BUG:NA@runtime!*/typedef struct S404 T404;
/*BUG:NA@runtime!*/typedef void*T402;
typedef struct S1142 T1142;
typedef struct S1146 T1146;
typedef struct S763 T763;
typedef struct S1148 T1148;
typedef struct S394 T394;
typedef struct S465 T465;
typedef struct S675 T675;
typedef struct S1149 T1149;
typedef struct S1150 T1150;
typedef struct S676 T676;
typedef struct S1151 T1151;
typedef struct S1152 T1152;
typedef struct S1153 T1153;
typedef struct S1157 T1157;
/*BUG:NA@runtime!*/typedef void*T391;
typedef struct S1162 T1162;
typedef struct S1165 T1165;
typedef struct S1167 T1167;
typedef struct S1168 T1168;
typedef struct S1170 T1170;
typedef struct S428 T428;
typedef struct S1173 T1173;
typedef struct S1176 T1176;
/*BUG:NA@runtime!*/typedef struct S344 T344;
/*BUG:NA@runtime!*/typedef void*T87;
/*BUG:NA@runtime!*/typedef struct S349 T349;
typedef struct S1180 T1180;
typedef struct S1185 T1185;
typedef struct S1188 T1188;
typedef struct S1193 T1193;
typedef struct S1196 T1196;
typedef struct S1199 T1199;
/*BUG:NA@runtime!*/typedef struct S1204 T1204;
typedef struct S1207 T1207;
typedef struct S1210 T1210;
typedef struct S1213 T1213;
typedef struct S1216 T1216;
typedef struct S1220 T1220;
typedef struct S1222 T1222;
/*BUG:NA@runtime!*/typedef void*T354;
typedef struct S1229 T1229;
typedef struct S1234 T1234;
typedef struct S1237 T1237;
typedef struct S1240 T1240;
typedef struct S1243 T1243;
typedef struct S1248 T1248;
typedef struct S879 T879;
typedef struct S1250 T1250;
/*BUG:NA@runtime!*/typedef void*T40;
typedef struct S1253 T1253;
typedef struct S1254 T1254;
typedef struct S1255 T1255;
typedef struct S1256 T1256;
typedef struct S369 T369;
typedef struct S1259 T1259;
/*BUG:NA@runtime!*/typedef void*T569;
typedef struct S1263 T1263;
typedef struct S1268 T1268;
typedef struct S1269 T1269;
typedef struct S801 T801;
typedef struct S802 T802;
typedef struct S803 T803;
typedef struct S798 T798;
typedef struct S799 T799;
typedef struct S800 T800;
typedef struct S1273 T1273;
typedef struct S1278 T1278;
typedef struct S1281 T1281;
typedef struct S1283 T1283;
typedef struct S1286 T1286;
typedef struct S1289 T1289;
typedef struct S1291 T1291;
/*BUG:NA@runtime!*/typedef void*T393;
/*BUG:NA@runtime!*/typedef void*T357;
typedef struct S1300 T1300;
typedef struct S1304 T1304;
typedef struct S1308 T1308;
typedef int T1312;
typedef struct S1315 T1315;
typedef struct S1318 T1318;
typedef struct S1320 T1320;
typedef struct S1321 T1321;
typedef struct S1322 T1322;
typedef struct S1325 T1325;
typedef struct S1328 T1328;
typedef struct S61 T61;
typedef struct S811 T811;
typedef int T1331;
typedef struct S767 T767;
typedef struct S682 T682;
typedef T0 T1333;
typedef struct S1335 T1335;
typedef struct S1336 T1336;
typedef struct S1337 T1337;
typedef struct S1338 T1338;
typedef struct S1340 T1340;
typedef struct S1343 T1343;
typedef struct S702 T702;
typedef struct S667 T667;
typedef struct S580 T580;
typedef struct S548 T548;
typedef struct S1344 T1344;
typedef struct S668 T668;
typedef struct S672 T672;
typedef struct S671 T671;
typedef struct S673 T673;
typedef struct S670 T670;
typedef struct S681 T681;
typedef struct S666 T666;
typedef uint64_t T16; /*NATURAL_64*/
typedef struct S683 T683;
typedef int T342;
typedef struct S1345 T1345;
typedef struct S1346 T1346;
typedef struct S544 T544;
typedef struct S677 T677;
typedef struct S578 T578;
typedef struct S685 T685;
typedef struct S764 T764;
typedef struct S765 T765;
typedef struct S1348 T1348;
typedef struct S1349 T1349;
typedef struct S1350 T1350;
typedef int T320;
typedef struct S128 T128;
typedef struct S1351 T1351;
typedef struct S1352 T1352;
typedef struct S770 T770;
typedef struct S122 T122;
typedef struct S1357 T1357;
typedef struct S429 T429;
typedef struct S426 T426;
typedef struct S380 T380;
typedef struct S820 T820;
typedef struct S663 T663;
typedef struct S818 T818;
typedef struct S771 T771;
typedef struct S669 T669;
typedef struct S553 T553;
typedef struct S1359 T1359;
typedef struct S819 T819;
typedef struct S662 T662;
typedef struct S350 T350;
typedef int T1360;
typedef struct S1361 T1361;
typedef struct S871 T871;
typedef struct S873 T873;
typedef struct S874 T874;
typedef struct S875 T875;
typedef struct S1363 T1363;
typedef struct S1365 T1365;
typedef struct S1369 T1369;
typedef struct S1372 T1372;
typedef struct S1375 T1375;
typedef struct S1378 T1378;
typedef struct S1379 T1379;
typedef struct S1380 T1380;
typedef struct S674 T674;
typedef struct S869 T869;
typedef struct S738 T738;
typedef struct S1384 T1384;
typedef int T1389;
typedef struct S1390 T1390;
typedef struct S1392 T1392;
typedef struct S1393 T1393;
typedef struct S1394 T1394;
typedef struct S1395 T1395;
typedef struct S1396 T1396;
typedef struct S1400 T1400;
typedef struct S1401 T1401;
typedef struct S1405 T1405;
typedef struct S904 T904;
typedef struct S577 T577;
typedef struct S659 T659;
typedef T0 T1407;
typedef struct S1409 T1409;
typedef T0 T1410;
typedef struct S1412 T1412;
typedef T0 T1413;
typedef T0 T1415;
typedef T0 T1417;
typedef struct S571 T571;
typedef struct S572 T572;
typedef struct S573 T573;
typedef struct S574 T574;
typedef struct S575 T575;
typedef struct S576 T576;
typedef T0 T1419;
typedef int T1420;
typedef T0 T1422;
typedef struct S1426 T1426;
typedef int T1427;
typedef struct S824 T824;
typedef T0 T1429;
typedef int T1432;
typedef struct S1434 T1434;
typedef struct S841 T841;
typedef struct S1435 T1435;
typedef struct S1436 T1436;
typedef struct S743 T743;
typedef struct S1437 T1437;
typedef struct S1438 T1438;
/*BUG:NA@runtime!*/typedef void*T570;
typedef struct S1442 T1442;
typedef struct S740 T740;
typedef T0 T1447;
typedef T0 T1449;
typedef T0 T1451;
typedef T0 T1453;
typedef T0 T1455;
typedef T0 T1457;
typedef T0 T1459;
typedef struct S1461 T1461;
typedef struct S816 T816;
typedef struct S1462 T1462;
typedef struct S814 T814;
typedef int T1463;
typedef struct S1464 T1464;
typedef struct S1466 T1466;
/* C Header Pass 2: */
typedef T3*T9;
#define M9 NULL
typedef T0**T934;
#define M934 NULL
typedef T0**T948;
#define M948 NULL
typedef struct S951 T951;
typedef struct S952 T952;
typedef T0**T956;
#define M956 NULL
typedef T0**T960;
#define M960 NULL
typedef T10*T961;
#define M961 NULL
typedef T0**T965;
#define M965 NULL
typedef struct S994 T994;
typedef T0**T996;
#define M996 NULL
typedef T0**T1025;
#define M1025 NULL
typedef struct S1026 T1026;
typedef T0**T1028;
#define M1028 NULL
typedef struct S1029 T1029;
typedef T2*T1030;
#define M1030 NULL
typedef T0**T1047;
#define M1047 NULL
typedef struct S1048 T1048;
typedef T0**T1050;
#define M1050 NULL
typedef T0**T1067;
#define M1067 NULL
typedef struct S1068 T1068;
typedef T0**T1070;
#define M1070 NULL
typedef struct S1071 T1071;
typedef T0**T1073;
#define M1073 NULL
typedef T0**T1074;
#define M1074 NULL
typedef struct S1076 T1076;
typedef T351*T1082;
#define M1082 NULL
typedef T0**T1083;
#define M1083 NULL
typedef T0**T1085;
#define M1085 NULL
typedef struct S1087 T1087;
typedef T0**T1088;
#define M1088 NULL
typedef struct S1090 T1090;
typedef T0**T1092;
#define M1092 NULL
typedef T0**T1100;
#define M1100 NULL
typedef T0**T1103;
#define M1103 NULL
typedef T0**T1104;
#define M1104 NULL
typedef struct S1112 T1112;
typedef T0**T1114;
#define M1114 NULL
typedef struct S1115 T1115;
typedef T0**T1117;
#define M1117 NULL
typedef T0**T1118;
#define M1118 NULL
typedef struct S1120 T1120;
typedef struct S1121 T1121;
typedef T0**T1123;
#define M1123 NULL
typedef T0**T1125;
#define M1125 NULL
typedef T0**T1126;
#define M1126 NULL
typedef T0**T1127;
#define M1127 NULL
typedef T0**T1136;
#define M1136 NULL
typedef T0**T1137;
#define M1137 NULL
typedef T0**T1138;
#define M1138 NULL
typedef T0**T1139;
#define M1139 NULL
typedef T0**T1140;
#define M1140 NULL
typedef T0**T1141;
#define M1141 NULL
typedef T0**T1143;
#define M1143 NULL
typedef T0**T1144;
#define M1144 NULL
typedef T0**T1145;
#define M1145 NULL
typedef T0**T1147;
#define M1147 NULL
typedef T0**T1155;
#define M1155 NULL
typedef T0**T1156;
#define M1156 NULL
typedef struct S1158 T1158;
typedef T0**T1159;
#define M1159 NULL
typedef T11*T1160;
#define M1160 NULL
typedef T0**T1161;
#define M1161 NULL
typedef struct S1163 T1163;
typedef T0**T1164;
#define M1164 NULL
typedef struct S1166 T1166;
typedef struct S1169 T1169;
typedef T0**T1171;
#define M1171 NULL
typedef struct S1172 T1172;
typedef T0**T1174;
#define M1174 NULL
typedef T0**T1175;
#define M1175 NULL
typedef T0**T1177;
#define M1177 NULL
typedef T0**T1178;
#define M1178 NULL
typedef T0**T1179;
#define M1179 NULL
typedef T0**T1181;
#define M1181 NULL
typedef struct S1182 T1182;
typedef T0**T1184;
#define M1184 NULL
typedef struct S1186 T1186;
typedef T0**T1187;
#define M1187 NULL
typedef struct S1189 T1189;
typedef T0**T1194;
#define M1194 NULL
typedef struct S1195 T1195;
typedef struct S1198 T1198;
typedef T0**T1200;
#define M1200 NULL
typedef T0**T1201;
#define M1201 NULL
typedef T0**T1202;
#define M1202 NULL
typedef T0**T1203;
#define M1203 NULL
typedef struct S1205 T1205;
typedef struct S1206 T1206;
typedef T0**T1208;
#define M1208 NULL
typedef struct S1209 T1209;
typedef T0**T1211;
#define M1211 NULL
typedef T0**T1212;
#define M1212 NULL
typedef struct S1214 T1214;
typedef T0**T1215;
#define M1215 NULL
typedef T0**T1217;
#define M1217 NULL
typedef struct S1218 T1218;
typedef T0**T1219;
#define M1219 NULL
typedef struct S1221 T1221;
typedef T0**T1223;
#define M1223 NULL
typedef struct S1224 T1224;
typedef T0**T1225;
#define M1225 NULL
typedef T0**T1226;
#define M1226 NULL
typedef T0**T1227;
#define M1227 NULL
typedef T0**T1228;
#define M1228 NULL
typedef struct S1230 T1230;
typedef T0**T1231;
#define M1231 NULL
typedef struct S1233 T1233;
typedef T0**T1235;
#define M1235 NULL
typedef T0**T1236;
#define M1236 NULL
typedef struct S1238 T1238;
typedef struct S1239 T1239;
typedef T0**T1241;
#define M1241 NULL
typedef struct S1242 T1242;
typedef T0**T1244;
#define M1244 NULL
typedef T0**T1245;
#define M1245 NULL
typedef T1*T1246;
#define M1246 NULL
typedef struct S1247 T1247;
typedef T0**T1249;
#define M1249 NULL
typedef T0**T1251;
#define M1251 NULL
typedef T0**T1252;
#define M1252 NULL
typedef T0**T1258;
#define M1258 NULL
typedef T0**T1260;
#define M1260 NULL
typedef T324*T1261;
#define M1261 NULL
typedef struct S1262 T1262;
typedef T0**T1264;
#define M1264 NULL
typedef struct S1265 T1265;
typedef T0**T1266;
#define M1266 NULL
typedef T0**T1267;
#define M1267 NULL
typedef struct S1271 T1271;
typedef T0**T1274;
#define M1274 NULL
typedef struct S1275 T1275;
typedef T0**T1276;
#define M1276 NULL
typedef struct S1277 T1277;
typedef T0**T1279;
#define M1279 NULL
typedef T0**T1280;
#define M1280 NULL
typedef struct S1282 T1282;
typedef T0**T1284;
#define M1284 NULL
typedef struct S1285 T1285;
typedef T0**T1287;
#define M1287 NULL
typedef struct S1288 T1288;
typedef T0**T1290;
#define M1290 NULL
typedef T0**T1292;
#define M1292 NULL
typedef T0**T1293;
#define M1293 NULL
typedef T0**T1294;
#define M1294 NULL
typedef T0**T1295;
#define M1295 NULL
typedef T0**T1296;
#define M1296 NULL
typedef T0**T1297;
#define M1297 NULL
typedef T0**T1298;
#define M1298 NULL
typedef struct S1299 T1299;
typedef T0**T1301;
#define M1301 NULL
typedef T0**T1302;
#define M1302 NULL
typedef T0**T1303;
#define M1303 NULL
typedef T0**T1305;
#define M1305 NULL
typedef struct S1306 T1306;
typedef T0**T1307;
#define M1307 NULL
typedef struct S1309 T1309;
typedef T0**T1310;
#define M1310 NULL
typedef T0**T1311;
#define M1311 NULL
typedef T0**T1314;
#define M1314 NULL
typedef struct S1316 T1316;
typedef T0**T1317;
#define M1317 NULL
typedef struct S1319 T1319;
typedef T0**T1323;
#define M1323 NULL
typedef T0**T1324;
#define M1324 NULL
typedef T0**T1326;
#define M1326 NULL
typedef struct S1327 T1327;
typedef T0**T1329;
#define M1329 NULL
typedef struct S1330 T1330;
typedef T0**T1358;
#define M1358 NULL
typedef T0**T1362;
#define M1362 NULL
typedef struct S1364 T1364;
typedef T0**T1366;
#define M1366 NULL
typedef struct S1367 T1367;
typedef T0**T1368;
#define M1368 NULL
typedef struct S1370 T1370;
typedef struct S1371 T1371;
typedef T0**T1373;
#define M1373 NULL
typedef struct S1374 T1374;
typedef T0**T1376;
#define M1376 NULL
typedef T0**T1377;
#define M1377 NULL
typedef T0**T1381;
#define M1381 NULL
typedef T0**T1382;
#define M1382 NULL
typedef T0**T1383;
#define M1383 NULL
typedef struct S1385 T1385;
typedef T0**T1386;
#define M1386 NULL
typedef T8*T1387;
#define M1387 NULL
typedef T0**T1388;
#define M1388 NULL
typedef struct S1399 T1399;
typedef T0**T1402;
#define M1402 NULL
typedef T0**T1403;
#define M1403 NULL
typedef struct S1404 T1404;
typedef T0**T1406;
#define M1406 NULL
typedef T0**T1439;
#define M1439 NULL
typedef T0**T1440;
#define M1440 NULL
typedef T0**T1441;
#define M1441 NULL
typedef T0**T1443;
#define M1443 NULL
typedef struct S1444 T1444;
typedef T0**T1445;
#define M1445 NULL
typedef T0**T1446;
#define M1446 NULL
typedef T0**T1465;
#define M1465 NULL
typedef struct S1467 T1467;
/* C Header Pass 3: */
struct S295{T6 _last_delete_succeeded;T6 _last_rename_succeeded;};
int se_cmpT295(T295* o1,T295* o2);
struct S546{T8 _current_entry;T8 _directory_stream;};
int se_cmpT546(T546* o1,T546* o2);
struct S351{T2 _mangling;};
int se_cmpT351(T351* o1,T351* o2);
struct S711{T295 _file_tools;};
int se_cmpT711(T711* o1,T711* o2);
struct S790{T0* _hashed_string_memory;T2 _column;T2 _line;};
int se_cmpT790(T790* o1,T790* o2);
extern T940 M940;
extern T944 M944;
struct S951{Tid id;T0*o;};
extern T951 M951;
struct S952{Tid id;T0*o;};
extern T952 M952;
extern T957 M957;
struct S726{T11 _time_memory;};
int se_cmpT726(T726* o1,T726* o2);
struct S491{T726 _time;T2 _microsecond;};
int se_cmpT491(T491* o1,T491* o2);
struct S990{T0* _comparator;};
int se_cmpT990(T990* o1,T990* o2);
extern T990 M990;
struct S994{Tid id;T0*o;};
extern T994 M994;
struct S1026{Tid id;T0*o;};
extern T1026 M1026;
struct S1029{Tid id;T0*o;};
extern T1029 M1029;
struct S1048{Tid id;T0*o;};
extern T1048 M1048;
struct S348{T0* _class_name;T0* _feature_name;T2 _hash_code;};
int se_cmpT348(T348* o1,T348* o2);
struct S1068{Tid id;T0*o;};
extern T1068 M1068;
struct S1071{Tid id;T0*o;};
extern T1071 M1071;
struct S1076{Tid id;T0*o;};
extern T1076 M1076;
struct S1087{Tid id;T0*o;};
extern T1087 M1087;
struct S1090{Tid id;T0*o;};
extern T1090 M1090;
struct S324{T0* _item_memory;T2 _capacity;};
int se_cmpT324(T324* o1,T324* o2);
struct S542{T0* _group;T6 _direct_error;T6 _keep_environment;T6 _direct_input;T6 _direct_output;};
int se_cmpT542(T542* o1,T542* o2);
struct S1112{Tid id;T0*o;};
extern T1112 M1112;
struct S1115{Tid id;T0*o;};
extern T1115 M1115;
struct S1120{Tid id;T0*o;};
extern T1120 M1120;
struct S1121{Tid id;T0*o;};
extern T1121 M1121;
struct S1158{Tid id;T0*o;};
extern T1158 M1158;
struct S1163{Tid id;T0*o;};
extern T1163 M1163;
struct S1166{Tid id;T0*o;};
extern T1166 M1166;
struct S1169{Tid id;T0*o;};
extern T1169 M1169;
struct S1172{Tid id;T0*o;};
extern T1172 M1172;
struct S1182{Tid id;T0*o;};
extern T1182 M1182;
struct S1186{Tid id;T0*o;};
extern T1186 M1186;
struct S1189{Tid id;T0*o;};
extern T1189 M1189;
struct S1195{Tid id;T0*o;};
extern T1195 M1195;
struct S1198{Tid id;T0*o;};
extern T1198 M1198;
struct S1205{Tid id;T0*o;};
extern T1205 M1205;
struct S1206{Tid id;T0*o;};
extern T1206 M1206;
struct S1209{Tid id;T0*o;};
extern T1209 M1209;
struct S1214{Tid id;T0*o;};
extern T1214 M1214;
struct S1218{Tid id;T0*o;};
extern T1218 M1218;
struct S1221{Tid id;T0*o;};
extern T1221 M1221;
struct S1224{Tid id;T0*o;};
extern T1224 M1224;
struct S1230{Tid id;T0*o;};
extern T1230 M1230;
struct S1233{Tid id;T0*o;};
extern T1233 M1233;
struct S1238{Tid id;T0*o;};
extern T1238 M1238;
struct S1239{Tid id;T0*o;};
extern T1239 M1239;
struct S1242{Tid id;T0*o;};
extern T1242 M1242;
struct S1247{Tid id;T0*o;};
extern T1247 M1247;
struct S1262{Tid id;T0*o;};
extern T1262 M1262;
struct S1265{Tid id;T0*o;};
extern T1265 M1265;
struct S1271{Tid id;T0*o;};
extern T1271 M1271;
struct S1275{Tid id;T0*o;};
extern T1275 M1275;
struct S1277{Tid id;T0*o;};
extern T1277 M1277;
struct S1282{Tid id;T0*o;};
extern T1282 M1282;
struct S1285{Tid id;T0*o;};
extern T1285 M1285;
struct S1288{Tid id;T0*o;};
extern T1288 M1288;
struct S1299{Tid id;T0*o;};
extern T1299 M1299;
struct S1306{Tid id;T0*o;};
extern T1306 M1306;
struct S1309{Tid id;T0*o;};
extern T1309 M1309;
extern T1312 M1312;
struct S1316{Tid id;T0*o;};
extern T1316 M1316;
struct S1319{Tid id;T0*o;};
extern T1319 M1319;
struct S1327{Tid id;T0*o;};
extern T1327 M1327;
struct S1330{Tid id;T0*o;};
extern T1330 M1330;
extern T1331 M1331;
struct S767{T0* _first_error;T2 _first_error_character;T2 _first_error_index;};
int se_cmpT767(T767* o1,T767* o2);
extern T1360 M1360;
struct S1364{Tid id;T0*o;};
extern T1364 M1364;
struct S1367{Tid id;T0*o;};
extern T1367 M1367;
struct S1370{Tid id;T0*o;};
extern T1370 M1370;
struct S1371{Tid id;T0*o;};
extern T1371 M1371;
struct S1374{Tid id;T0*o;};
extern T1374 M1374;
struct S1385{Tid id;T0*o;};
extern T1385 M1385;
extern T1389 M1389;
struct S1399{Tid id;T0*o;};
extern T1399 M1399;
struct S1404{Tid id;T0*o;};
extern T1404 M1404;
extern T1420 M1420;
extern T1427 M1427;
extern T1432 M1432;
struct S1444{Tid id;T0*o;};
extern T1444 M1444;
extern T1463 M1463;
struct S1467{Tid id;T0*o;};
extern T1467 M1467;
/* C Header Pass 4: */
struct S29{T0* _level_flag;T6 _version_flag;T6 _help_flag;};
extern T29 M29;
extern T296 M296;
struct S113{T0* _c_compiler_path;T0* _c_strip_path;T0* _c_linker_path;T0* _plugins;T0* _plugin_factory;T0* _config_loadpath_files;T0* _c_compiler;T0* _smarteiffel_options;T0* _is_unix_like;T0* _ace_compiler_options;T0* _is_win_like;T0* _cpp_linker_path;T0* _short_directory;T0* _cpp_compiler;T0* _bin_directory;T0* _config_loadpath_names;T0* _sys_directory;T0* _ace_linker_options;T0* _config;T0* _cpp_compiler_path;T0* _seconf;T0* _extra_loadpath_files;T0* _system_flavor;T0* _system_name;T0* _cpp_strip_path;T2 _c_compiler_mode;T2 _path_id;T6 _no_strip;T6 _root_class_wait_for_procedure;T6 _is_alternate_c_mode;T546 _basic_directory;T6 _c_mode_has_explicit_linker_path_or_option;};
extern T113 M113;
struct S126{T0* _output_path;T0* _error_stream;T0* _output_stream;T2 _output_state;T6 _is_verbose;};
extern T126 M126;
extern T903 M903;
struct S104{T0* _local_vars;T0* _closure_local_vars;T0* _current_line;T0* _closure_arguments;T0* _last_parent_edge;T0* _arguments;T0* _last_formal_generic_type_mark;T0* _formal_generic_list;T0* _last_feature_name;T0* _tmp_feature;T0* _last_class_name;T0* _last_class_text;T0* _last_expression;T0* _cluster;T0* _last_instruction;T0* _last_feature_name_list;T0* _last_feature_declaration;T0* _last_type_mark;T0* _last_comment;T0* _last_manifest_string;T0* _last_tag_mark;T11 _total_time;T2 _line;T2 _start_column;T2 _column;T2 _eiffel_parser_stamp;T2 _inline_agent_counter;T2 _start_line;T10 _current_id;T6 _inside_rescue_flag;T6 _ok;T790 _token_buffer;T3 _cc;T6 _tuple_flag;T6 _inside_ensure_flag;T6 _drop_comments;T6 _is_running;T6 _inside_function_flag;T6 _no_rescue;T6 _inside_class_invariant_flag;T6 _skipped_new_line;};
extern T104 M104;
struct S283{T0* _file_path;T0* _default_debug_keys;T0* _executable_name_memory;T0* _last_comment;T0* _splitter_memory;T0* _current_line;T2 _start_column;T2 _highest_encountered_level;T2 _root_index;T2 _default_assertion_level;T2 _line;T2 _column;T2 _start_line;T6 _sedb_flag;T6 _skipped_new_line;T6 _need_path_id;T6 _drop_comments;T6 _clean;T6 _manifest_string_trace;T6 _relax;T3 _cc;T6 _profile;T6 _safety_check;T6 _default_trace;T6 _no_main;T790 _token_buffer;T6 _flat_check;T6 _precompile_header;T6 _high_memory_compiler;};
extern T283 M283;
struct S117{T0* _native_procedure_mapper;T0* _once_mark_list;T0* _native_function_mapper;T0* _code_compiler;T0* _memory;T0* _compound_expression_compiler;T0* _native_need_wrapper;T0* _out_h;T0* _va_arg_type;T0* _arg_mapper;T0* _external_type;T0* _target_mapper;T0* _target_type;T0* _initializer;T0* _introspection_function;T0* _mapper;T0* _registered_natives;T0* _live_type_compiler;T0* _unused_contexts;T0* _header_pass_4;T0* _argument_type;T0* _header_pass_3;T0* _introspection_display;T0* _header_pass_2;T0* _include_memory;T0* _header_pass_1;T0* _result_type;T0* _header_pass_0;T0* _need_struct;T0* _native_c_definition;T2 _procedure_count;T2 _real_procedure_count;T2 _function_count_in_file;T2 _precursor_routine_count;T2 _top;T2 _function_count;T2 _pending_c_function_counter;T2 _real_function_count;T6 _has_c_plus_plus;T6 _pending_c_function;T6 _in_assignment;T6 _assignment_evobt;T6 _executable_is_up_to_date;T6 _assertion_checks_disabled;T6 _has_closures;};
extern T117 M117;
struct S111{T0* _type_native_array_character_memory;T0* _type_string_memory;T0* _live_type_map_;T0* _type_character_memory;T0* _polymorphic_distribution;T0* _type_boolean_memory;T0* _type_pointer_memory;T0* _type_unicode_string_memory;T0* _type_real_extended_memory;T0* _type_any_memory;T0* _type_real_32_memory;T0* _specializing_closure_arguments_lists;T0* _type_natural_32_memory;T0* _specializing_feature_arguments_list;T0* _type_natural_8_memory;T0* _specializing_closure_local_var_lists;T0* _type_integer_32_memory;T0* _specializing_feature_local_var_list;T0* _type_integer_8_memory;T0* _se_atexit_stamp;T0* _type_real_64_memory;T0* _agent_switches;T0* _type_natural_16_memory;T0* _agent_creations;T0* _type_integer_16_memory;T0* _class_invariants;T0* _type_natural_64_memory;T0* _run_features;T0* _root_procedure;T0* _type_integer_64_memory;T2 _void_target_procedure_call_count;T2 _monomorphic_function_call_count;T2 _polymorphic_procedure_call_count;T2 _monomorphic_procedure_call_count;T2 _expanded_target_procedure_call_count;T2 _void_target_function_call_count;T2 _polymorphic_function_call_count;T2 _magic_count;T2 _expanded_target_function_call_count;T2 _se_atexit_id;T2 _inspect_when_merge_counter;T6 _thread_used;int _live_type_sorter;T6 _generating_type_used;T6 _no_id;T6 _pretty_flag;T6 _generator_used;T6 _short_or_class_check_flag;T6 _deep_twin_used;T6 _simplify_done;};
extern T111 M111;
struct S291{T10 _min_id;T10 _max_id;};
extern T291 M291;
extern T281 M281;
extern T297 M297;
struct S7{Tid id;T9 _storage;T2 _storage_lower;T2 _storage_signature_count;T2 _capacity;T2 _count;T2 _generation;T6 _has_storage_signature;};
extern T7 M7;
struct S909{Tid id;T934 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T909 M909;
struct S293{T0* _errors_pool;T0* _positions;T0* _explanation;T0* _action;T2 _warning_counter;T2 _error_counter;T6 _style_warning;T6 _no_warning;T6 _flymake_mode;};
extern T293 M293;
struct S86{T0* _cecil_files;T2 _state;};
extern T86 M86;
struct S910{T0* _item;};
extern T910 M910;
extern T295 M295;
extern T554 M554;
extern T546 M546;
struct S78{Tid id;T0* _output_filter;};
extern T78 M78;
struct S911{Tid id;T0* _free_nodes;T0* _cache_node;T948 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T911 M911;
struct S557{Tid id;T0* _destination_notation;T0* _current_path;};
extern T557 M557;
struct S561{Tid id;T0* _destination_notation;T0* _current_path;};
extern T561 M561;
struct S562{Tid id;};
extern T562 M562;
struct S563{Tid id;};
extern T563 M563;
struct S564{Tid id;};
extern T564 M564;
struct S565{Tid id;};
extern T565 M565;
struct S912{T0* _item;};
extern T912 M912;
struct S913{T6 _item;};
extern T913 M913;
struct S102{T0* _filter;T0* _path;T9 _buffer;T8 _input_stream;T2 _buffer_position;T2 _buffer_size;T2 _capacity;T6 _end_of_input;T6 _end_reached;T3 _filtered_last_character;};
extern T102 M102;
struct S556{T0* _smarteiffel_options;T0* _cpp_linker_options;T0* _cpp_compiler_options;T0* _cpp_linker_path;T0* _cpp_strip_path;T0* _cpp_compiler_path;T0* _cpp_compiler;T0* _c_linker_options;T0* _c_compiler_options;T0* _c_strip_path;T0* _c_linker_path;T0* _c_compiler_path;T0* _c_compiler;};
extern T556 M556;
extern T545 M545;
struct S464{Tid id;T0* _path;T0* _filter;T9 _buffer;T8 _output_stream;T11 _flushed_character_count;T2 _buffer_position;T2 _capacity;};
extern T464 M464;
struct S665{Tid id;T0* _stream;T0* _filter;};
extern T665 M665;
struct S81{Tid id;T0* _filter;};
extern T81 M81;
struct S69{Tid id;T0* _filter;T9 _buffer;T2 _buffer_position;T2 _capacity;};
extern T69 M69;
struct S467{Tid id;T0* _require_assertion;T0* _local_vars;T0* _obsolete_mark;T0* _assigned;T0* _header_comment;T0* _routine_then;T0* _type;T0* _index_list;T0* _arguments;T0* _routine_body;T0* _names;T6 _has_closures;T6 _busy;};
extern T467 M467;
struct S123{T0* _cluster;T0* _hashed_path;T0* _text;T2 _count;};
extern T123 M123;
struct S708{Tid id;T0* _live_type;T0* _c_path;T6 _dont_split;};
extern T708 M708;
struct S709{Tid id;T0* _live_type;int _sorter;T0* _c_path;T0* _suffixes;T0* _ids;T2 _count;T6 _dont_split;};
extern T709 M709;
struct S704{Tid id;T0* _c_path;T0* _live_type;T2 _split_id;T6 _dont_split;};
extern T704 M704;
struct S914{T956 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T914 M914;
struct S107{T0* _to_string;T2 _hash_code;};
extern T107 M107;
struct S566{T0* _path;T0* _name;int _collection_sorter;T546 _basic_directory;T0* _name_list;T6 _exists;};
extern T566 M566;
struct S710{Tid id;T0* _classeses;T0* _parent;T2 _distance;T546 _basic_directory;};
extern T710 M710;
extern T351 M351;
struct S437{Tid id;T0* _list;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T437 M437;
struct S915{Tid id;T934 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T915 M915;
struct S333{T0* _low_surrogate_values;T0* _low_surrogate_indexes;T961 _storage;T2 _count;T2 _generation;T2 _capacity;};
extern T333 M333;
extern T711 M711;
struct S916{T965 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T916 M916;
struct S447{T0* _pool;T0* _default_debug_keys;T0* _type_dictionary;T0* _exclude_list;T0* _include_list;T0* _directory_path;T0* _option_debug_keys;T0* _name;T0* _tree;T0* _class_text_map;T0* _option_assertion_level;T0* _option_trace;T2 _default_assertion_level;T3 _default_trace;};
extern T447 M447;
extern T790 M790;
struct S588{Tid id;T2 _priority;T990 _sorter;T0* _compiled;};
extern T588 M588;
struct S621{Tid id;T0* _compiled;};
extern T621 M621;
struct S622{Tid id;T0* _compiled;};
extern T622 M622;
struct S623{Tid id;T0* _compiled;};
extern T623 M623;
struct S624{Tid id;T0* _compiled;};
extern T624 M624;
struct S625{Tid id;T0* _compiled;};
extern T625 M625;
struct S637{Tid id;};
extern T637 M637;
struct S638{Tid id;};
extern T638 M638;
struct S639{Tid id;T0* _target_formal_type;T0* _type;};
extern T639 M639;
struct S641{Tid id;T0* _type;};
extern T641 M641;
struct S642{Tid id;T0* _type;};
extern T642 M642;
struct S646{Tid id;T0* _finish;T0* _type;T0* _continue;T6 _is_expression;};
extern T646 M646;
struct S647{Tid id;T0* _name;T0* _bcn;T0* _type_of_current;T0* _rf8;};
extern T647 M647;
struct S648{Tid id;T0* _rf7;T0* _name;T0* _bcn;T0* _type_of_current;};
extern T648 M648;
struct S649{Tid id;T0* _external_routine_memory;T0* _rf8;T0* _rf7;};
extern T649 M649;
struct S650{Tid id;T6 _put_else;};
extern T650 M650;
struct S651{Tid id;T6 _put_coma;};
extern T651 M651;
struct S652{Tid id;};
extern T652 M652;
struct S654{Tid id;};
extern T654 M654;
struct S655{Tid id;};
extern T655 M655;
struct S653{Tid id;};
extern T653 M653;
struct S656{Tid id;};
extern T656 M656;
struct S657{Tid id;T6 _flag;};
extern T657 M657;
struct S658{Tid id;T0* _name;T0* _type_of_current;T6 _flag;};
extern T658 M658;
struct S917{T0* _free_nodes;T0* _cache_node;T996 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T917 M917;
struct S552{T0* _specializing_type_memory;T0* _times;T2 _safety_check_state;T491 _phase_time;T2 _phase;T6 _inlining_dynamic_dispatch_done;T6 _collecting_done;};
extern T552 M552;
struct S97{Tid id;T0* _parent_lists;T0* _obsolete_mark;T0* _insert_inherit_test_memory_cache;T0* _index_list;T0* _declaration_type_of_like_current_memory;T0* _feature_dictionary;T0* _heading_comment2;T0* _external_type;T0* _formal_generic_list;T0* _class_invariant;T0* _name;T0* _creation_clause_list;T0* _heading_comment1;T0* _check_expanded_with_flag;T0* _cluster;T0* _feature_clause_list;T0* _path;T0* _end_comment;T0* _tagged_data_map;T2 _assertion_level;T2 _hash_code;T10 _id;T6 _creation_list_check_done;T6 _is_deferred;T6 _sedb_trace;T6 _is_expanded;};
extern T97 M97;
struct S91{T0* _native_array_element_type;T0* _target_type;T351 _native_array_internals_from_generating_type_position;T0* _new_type;T0* _external_routine;T0* _type_internals_handler;T0* _native_array_internals_from_generating_type_args;T6 _has_capacity;T351 _internals_from_generating_type_position;T6 _can_twin;};
extern T91 M91;
struct S383{Tid id;T0* _create_function_list;T0* _writable_attributes_mem;T0* _precursor_run_features;T0* _to_internals_stamp;T0* _precursor_classes;T0* _create_blank_internals_instruction;T0* _live_features;T0* _tagged_data_map;T0* _run_time_set;T0* _actual_clients_;T0* _class_text_name;T0* _default_create_stamp;T0* _class_text;T0* _structure_signature_memory;T0* _name;T0* _memory_dispose_stamp;T0* _canonical_type_mark;T0* _type;T0* _default_create_run_feature_memory;T2 _hash_code;T2 _generating_type_level;T2 _id;T2 _tagged_memory;T6 _collecting_deep_twin;T1 _collect_is_deep_equal_status;T6 _has_been_collected;T6 _is_collecting;T6 _at_run_time;T6 _create_blank_internals_used;};
extern T383 M383;
extern T110 M110;
struct S95{T0* _to_string;T0* _class_text_memory;T0* _hashed_name;T2 _hash_code;T6 _has_tried_to_load;T351 _start_position;T6 _allow_missing;};
extern T95 M95;
struct S286{T0* _name;T0* _canonical_type_mark;T0* _address_of_memory2;T0* _live_type;T0* _temporary_simple_feature_name;T0* _feature_stamps;T0* _item;T0* _default_rescue_compound;T0* _private_generic_list;T0* _children_edge_load;T0* _class_text;T0* _parents;T0* _parents_edge_load;T0* _address_of_memory1;T0* _children_edge;T0* _external_type;T0* _parents_edge;T0* _insert_inherit_test_memory_cache;T0* _children;T0* _class_invariant;T0* _writable_attributes_memory;T2 _hash_code;T6 _default_rescue_collected;T6 _is_deferred;T6 _mark;T6 _has_local_closure;};
extern T286 M286;
struct S89{T0* _rename_up_parent_class;T0* _run_features;T0* _rename_up_context_class;T0* _rename_down_edge;T0* _anonymous_features;T0* _rename_down_context_class;T0* _roots;T0* _rename_up_edge;T0* _rename_down_child_feature_stamp;T0* _rename_down_child_class;T0* _rename_up_parent_feature_stamp;T0* _name;T2 _hash_code;};
extern T89 M89;
struct S919{T0* _free_nodes;T1025 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T919 M919;
struct S920{T0* _free_nodes;T0* _cache_node;T1028 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T920 M920;
struct S921{T1030 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T921 M921;
struct S306{Tid id;T0* _original;T0* _holders;T9 _storage;T2 _capacity;T2 _storage_lower;T2 _hash_code;T2 _count;T6 _immutable;T6 _is_interned;};
extern T306 M306;
struct S108{T0* _se_ums_;T0* _se_ms_;T0* _unicode_string_type;T0* _unicode_string_manifest_initialize_stamp;T0* _string_from_external_sized_copy_stamp;T6 _first_unicode_manifest_string_collected_flag;T6 _first_manifest_string_collected_flag;T6 _is_string_collected;};
extern T108 M108;
extern T116 M116;
extern T125 M125;
struct S124{T6 _agent_creation_collected_flag;};
extern T124 M124;
extern T127 M127;
struct S452{Tid id;T0* _class_text_memory;T0* _generic_creation;T0* _class_text_name;T6 _has_tried_to_load;};
extern T452 M452;
struct S923{T1047 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T923 M923;
struct S924{T0* _free_nodes;T1050 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T924 M924;
struct S925{T1030 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T925 M925;
struct S341{T0* _current_context;T0* _code_stack;T2 _context_level;T2 _sedb_counter;};
extern T341 M341;
struct S120{T0* _feature_stamp;T0* _insert_seeds;T0* _context_type;T0* _seeds;T0* _seeds_of_current_feature;T0* _insert_seeds_of_current_feature;T0* _feature_stamps_memory;T0* _features_dictionary;T0* _current_mixer;T0* _features;T0* _pending_list;T0* _current_fn;T0* _specialize_and_check_list;T0* _insert_problem_seeds;T0* _free;T2 _waiting_type;T1 _state;T6 _specialize_and_check_in_progress;};
extern T120 M120;
struct S290{T351 _start_position;T0* _name_alias;T0* _name;T2 _name_type;T6 _complete_name_flag;};
extern T290 M290;
struct S926{T1067 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T926 M926;
struct S441{Tid id;T0* _class_text_memory;T0* _generic_creation;T0* _class_text_name;T6 _has_tried_to_load;};
extern T441 M441;
struct S929{T0* _free_nodes;T0* _cache_node;T1070 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T929 M929;
extern T587 M587;
struct S930{T0* _free_nodes;T0* _cache_node;T1073 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T930 M930;
struct S931{T0* _free_nodes;T1074 _buckets;T2 _cache_user;T2 _generation;T2 _count;T2 _capacity;};
extern T931 M931;
struct S932{T2 _item;};
extern T932 M932;
struct S727{Tid id;T6 _info_flag;};
extern T727 M727;
struct S728{Tid id;T0* _assign_na;T0* _gc_define2;T0* _native_array_collector;T6 _info_flag;};
extern T728 M728;
struct S729{Tid id;T0* _before_mark_compiler;T0* _info_compiler;T0* _c_struct_signature_tagger;T0* _functions_compiler;T0* _native_array_collector;T0* _header_compiler;T0* _c_struct_signature_map;T0* _need_mark;T6 _info_flag;T6 _dispose_flag;};
extern T729 M729;
struct S318{Tid id;T0* _memory__;T0* _memory_;T0* _storage;T0* _template;};
extern T318 M318;
struct S935{T1082 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T935 M935;
struct S936{T1083 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T936 M936;
struct S719{T0* _explanation;T0* _positions;T6 _is_emitted;};
extern T719 M719;
struct S551{T0* _set;T0* _owner;};
extern T551 M551;
struct S937{T0* _free_nodes;T1085 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T937 M937;
struct S938{T1088 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T938 M938;
struct S720{Tid id;T0* _data;};
extern T720 M720;
struct S939{T1083 _storage;T2 _capacity;T2 _lower;T2 _generation;T2 _storage_lower;T2 _upper;};
extern T939 M939;
struct S340{T0* _entries;T0* _path_h;T0* _path;};
extern T340 M340;
struct S943{T0* _free_nodes;T0* _cache_node;T1092 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T943 M943;
extern T807 M807;
struct S804{Tid id;T0* _config;};
extern T804 M804;
struct S806{Tid id;T0* _os;T0* _flavor;T2 _jobs;};
extern T806 M806;
struct S945{T934 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T945 M945;
struct S946{T0* _item;};
extern T946 M946;
struct S59{int _items_comparator;T0* _strings;T324 _recycling_item;};
extern T59 M59;
struct S805{Tid id;T0* _flavor;T0* _my_path;T0* _os;T0* _my_tools;T0* _short;T0* _my_environment;T0* _sys;T0* _my_c_modes;T0* _bin;T0* _my_loadpaths;T2 _jobs;};
extern T805 M805;
struct S947{T0* _next;T0* _key;T0* _item;};
extern T947 M947;
struct S953{T0* _next;T0* _key;T0* _item;};
extern T953 M953;
struct S954{T0* _free_nodes;T1100 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T954 M954;
extern T80 M80;
struct S955{T1103 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T955 M955;
struct S959{T1104 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T959 M959;
struct S106{T0* _file_path;T0* _sections;T0* _default_section;T0* _last_comment;T0* _last_section;T0* _last_manifest_string;T0* _last_key;T0* _current_line;T2 _start_column;T2 _column;T2 _line;T2 _start_line;T10 _id;T6 _is_invalid;T790 _token_buffer;T6 _expand_execute;T6 _skipped_new_line;T6 _drop_comments;T6 _expand_var;T3 _cc;};
extern T106 M106;
struct S962{T961 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T962 M962;
struct S783{Tid id;T546 _basic_directory;T0* _path;T0* _name;T0* _cluster;T0* _classeses;T0* _parent;T2 _distance;};
extern T783 M783;
struct S825{Tid id;T546 _basic_directory;T0* _path;T0* _name;T0* _classeses;T0* _parent;T2 _distance;};
extern T825 M825;
struct S964{T0* _free_nodes;T1114 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T964 M964;
struct S966{T0* _free_nodes;T1117 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T966 M966;
struct S968{T0* _free_nodes;T1118 _buckets;T2 _cache_user;T2 _generation;T2 _count;T2 _capacity;};
extern T968 M968;
struct S970{T0* _free_nodes;T1123 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T970 M970;
struct S785{T0* _cluster;T0* _classes;};
extern T785 M785;
extern T491 M491;
struct S973{Tid id;T1125 _storage;T2 _capacity;T2 _lower;T2 _generation;T2 _storage_lower;T2 _upper;};
extern T973 M973;
struct S367{Tid id;T351 _start_position;T0* _flat_list;T0* _list;};
extern T367 M367;
struct S974{Tid id;T1126 _storage;T2 _capacity;T2 _lower;T2 _generation;T2 _storage_lower;T2 _upper;};
extern T974 M974;
struct S407{Tid id;T351 _start_position;T0* _flat_list;T0* _list;};
extern T407 M407;
struct S975{T1127 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T975 M975;
struct S462{T0* _closure_local_vars;T0* _closure_arguments;T6 _has_closures;T6 _is_inline_agent;T351 _sedb_trace_before_exit;T0* _obsolete_mark;T0* _header_comment;T0* _anonymous_feature;T0* _result_type;T0* _arguments;T0* _assigned;T0* _names;T0* _feature_clause;T0* _index_list;};
extern T462 M462;
struct S433{T0* _list;T0* _tag;T0* _spec;};
extern T433 M433;
struct S395{Tid id;T0* _unicode_string;T0* _to_string;T0* _source_view;T0* _initial_storage_id;T0* _once_variable;T0* _alias_link;T2 _hash_code_memory;T6 _unicode_flag;T351 _start_position;T6 _once_flag;};
extern T395 M395;
struct S439{T351 _start_position;T0* _list;T6 _no_generic_constraint_flag;};
extern T439 M439;
struct S440{T0* _name;T0* _constraint;T2 _rank;};
extern T440 M440;
struct S505{Tid id;T0* _written_name;T0* _type_marks_memory;T0* _generic_creation;T0* _class_text_memory;T0* _formal_name;T0* _formal_generic_arg;T2 _rank;T6 _has_tried_to_load;T6 _already_checking;};
extern T505 M505;
struct S514{Tid id;T0* _class_text_memory;T0* _generic_creation;T351 _start_position;T6 _has_tried_to_load;};
extern T514 M514;
struct S516{Tid id;T351 _start_position;T0* _feature_stamp_memory;T0* _declaration_type;T0* _written_name;T0* _class_text_memory;T0* _generic_creation;T0* _like_what;T6 _has_tried_to_load;};
extern T516 M516;
struct S121{T2 _mode;T6 _semi_colon_flag;};
extern T121 M121;
struct S517{Tid id;T351 _start_position;T0* _type_marks_memory;T0* _generic_creation;T0* _class_text_memory;T0* _like_what;T0* _written_name;T6 _has_tried_to_load;T6 _like_argument_computing;};
extern T517 M517;
struct S458{Tid id;T0* _class_text_name;T0* _signature_resolved_memory;T0* _long_name_memory;T0* _type_memory;T0* _declaration_type_memory;T0* _written_name_memory;T0* _generic_list;T0* _class_text_memory;T0* _generic_creation;T0* _static_memory;T6 _has_tried_to_load;};
extern T458 M458;
struct S423{Tid id;T0* _class_text_name;T0* _signature_resolved_memory;T0* _long_name_memory;T0* _type_memory;T0* _declaration_type_memory;T0* _written_name_memory;T0* _generic_list;T0* _class_text_memory;T0* _generic_creation;T0* _static_memory;T6 _has_tried_to_load;};
extern T423 M423;
struct S480{Tid id;T0* _class_text_name;T0* _signature_resolved_memory;T0* _long_name_memory;T0* _type_memory;T0* _declaration_type_memory;T0* _written_name_memory;T0* _generic_list;T0* _class_text_memory;T0* _generic_creation;T0* _static_memory;T6 _has_tried_to_load;};
extern T480 M480;
struct S418{Tid id;T0* _type_memory;T0* _generic_creation;T0* _class_text_memory;T0* _long_name_memory;T0* _class_text_name;T6 _has_tried_to_load;T6 _is_user_empty_expanded_flag;};
extern T418 M418;
struct S449{Tid id;T0* _class_text_name;T0* _generic_creation;T0* _pretty_name;T0* _class_text_memory;T2 _bit_count;T6 _has_tried_to_load;};
extern T449 M449;
struct S455{Tid id;T0* _class_text_name;T0* _signature_resolved_memory;T0* _long_name_memory;T0* _type_memory;T0* _declaration_type_memory;T0* _written_name_memory;T0* _generic_list;T0* _class_text_memory;T0* _generic_creation;T0* _static_memory;T6 _has_tried_to_load;};
extern T455 M455;
struct S453{Tid id;T0* _class_text_memory;T0* _type_memory;T0* _generic_creation;T0* _class_text_name;T6 _has_tried_to_load;};
extern T453 M453;
struct S456{Tid id;T0* _generic_list;T0* _class_text_name;T0* _signature_resolved_memory;T0* _long_name_memory;T0* _type_memory;T0* _declaration_type_memory;T0* _written_name_memory;T0* _static_memory;T0* _class_text_memory;T0* _generic_creation;T2 _pretty_code;T6 _has_tried_to_load;};
extern T456 M456;
struct S396{Tid id;T0* _class_text_memory;T0* _generic_creation;T0* _class_text_name;T6 _has_tried_to_load;};
extern T396 M396;
struct S450{Tid id;T0* _class_text_memory;T0* _generic_creation;T0* _class_text_name;T6 _has_tried_to_load;};
extern T450 M450;
struct S422{Tid id;T0* _class_text_name;T0* _generic_creation;T0* _pretty_name;T0* _class_text_memory;T2 _bit_count_memory;T6 _has_tried_to_load;};
extern T422 M422;
struct S448{Tid id;T0* _class_text_name;T0* _generic_creation;T0* _pretty_name;T0* _class_text_memory;T2 _bit_count;T6 _has_tried_to_load;};
extern T448 M448;
struct S451{Tid id;T0* _class_text_memory;T0* _generic_creation;T0* _class_text_name;T6 _has_tried_to_load;};
extern T451 M451;
struct S459{Tid id;T0* _class_text_name;T0* _signature_resolved_memory;T0* _generic_creation;T0* _static_memory;T0* _declaration_type_memory;T0* _long_name_memory;T0* _generic_list;T0* _class_text_memory;T0* _written_name_memory;T0* _type_memory;T6 _is_user_empty_expanded_flag;T6 _has_tried_to_load;};
extern T459 M459;
struct S518{Tid id;T0* _long_name_memory;T0* _specialized_type_mark;T0* _generic_list_memory;T0* _static_memory;T0* _class_text_memory;T0* _generic_creation;T0* _class_type_mark;T6 _has_tried_to_load;};
extern T518 M518;
struct S504{T0* _remainder;T0* _first;};
extern T504 M504;
struct S292{T0* _eiffel_view_memory;T0* _type_mark_list;T351 _start_position;};
extern T292 M292;
struct S461{T0* _remainder;T0* _first;};
extern T461 M461;
struct S436{T0* _procedure_list;T0* _comment;T0* _clients;T351 _start_position;};
extern T436 M436;
struct S282{T0* _to_string;T0* _manifest_string;T2 _count;T2 _idx;};
extern T282 M282;
struct S486{Tid id;T0* _external_tag;};
extern T486 M486;
struct S488{Tid id;T0* _feature_name;T0* _alias_data;T0* _external_tag;T0* _plugin;T2 _hash_code;};
extern T488 M488;
struct S489{Tid id;T0* _rf8_memory;T0* _rf7_memory;T0* _external_tag;};
extern T489 M489;
struct S490{Tid id;T0* _struct;T0* _access;T0* _external_tag;T0* _signature;T0* _type;T2 _access_mode;T6 _macro;T6 _c_inline;T6 _parsing_done;T6 _need_prototype;};
extern T490 M490;
struct S438{T0* _alias_tag;T0* _native;T351 _start_position;T0* _default_value;T0* _type_name;};
extern T438 M438;
struct S976{T1136 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T976 M976;
struct S289{T0* _comment;T0* _type_mark;T0* _parent_lists;T0* _undefine_list;T0* _class_text_name;T0* _rename_list;T0* _class_text;T0* _export_list;T0* _redefine_list;T6 _is_insert_member;};
extern T289 M289;
struct S497{T0* _old_name;T0* _new_name;};
extern T497 M497;
struct S977{T1137 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T977 M977;
struct S538{Tid id;T0* _list;T351 _start_position;};
extern T538 M538;
struct S507{Tid id;T0* _feature_name;T0* _target;T0* _written_declaration_type_mark_memory;T0* _feature_stamp;T0* _arguments_0;T6 _is_assigned_to;};
extern T507 M507;
struct S416{Tid id;T0* _right_side;T0* _left_writable;T0* _left_type_mark;};
extern T416 M416;
struct S493{Tid id;T0* _curly_type;T351 _start_position;T0* _resolved_memory;T2 _rank;};
extern T493 M493;
struct S386{Tid id;T0* _result_type_memory;T0* _pretty_view;T11 _value_memory;T351 _start_position;T2 _size;};
extern T386 M386;
struct S494{Tid id;T0* _normalized_memory;T0* _result_type;T0* _pretty_view;T351 _start_position;};
extern T494 M494;
struct S495{Tid id;T0* _item_list;T351 _irregular_position;T0* _optional_arguments;T0* _manifest_make_feature_stamp;T0* _type_mark;T0* _created_type;T0* _manifest_put_feature_stamp;T2 _semicolon_count;T351 _start_position;};
extern T495 M495;
struct S370{Tid id;T351 _end_position;T351 _start_position;T0* _remainder;T0* _first_one;T6 _synthetic_tuple;};
extern T370 M370;
struct S361{Tid id;T0* _feature_name;T0* _target;T0* _written_declaration_type_mark_memory;T0* _feature_stamp;T0* _arguments_0;T6 _is_assigned_to;};
extern T361 M361;
struct S364{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T364 M364;
struct S366{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T366 M366;
struct S355{Tid id;T0* _arguments_0;T0* _creation_type;T0* _feature_name;T0* _target;T0* _feature_stamp;T2 _eiffel_parser_stamp;};
extern T355 M355;
struct S359{Tid id;T0* _arguments;T0* _creation_type;T0* _parentheses_feature_name_memory;T0* _feature_name;T0* _target;T0* _feature_stamp;T2 _eiffel_parser_stamp;};
extern T359 M359;
struct S360{Tid id;T0* _arguments;T0* _creation_type;T0* _parentheses_feature_name_memory;T0* _feature_name;T0* _target;T0* _feature_stamp;T2 _eiffel_parser_stamp;};
extern T360 M360;
struct S509{Tid id;T0* _feature_name;T0* _target;T0* _written_declaration_type_mark_memory;T0* _feature_stamp;T0* _arguments_0;T6 _is_assigned_to;};
extern T509 M509;
struct S510{Tid id;T0* _feature_name;T0* _target;T0* _written_declaration_type_mark_memory;T0* _feature_stamp;T0* _arguments_0;T6 _is_assigned_to;};
extern T510 M510;
struct S511{Tid id;T0* _feature_name;T0* _target;T0* _written_declaration_type_mark_memory;T0* _feature_stamp;T0* _arguments_0;T6 _is_assigned_to;};
extern T511 M511;
struct S499{Tid id;T0* _create_expression;T0* _effective_arg_list;T351 _start_position;};
extern T499 M499;
struct S400{Tid id;T351 _start_position;};
extern T400 M400;
struct S471{Tid id;T351 _start_position;};
extern T471 M471;
struct S481{Tid id;T351 _start_position;T0* _pretty_view;T3 _value;};
extern T481 M481;
struct S500{Tid id;T0* _specialized_parent;T0* _specialized_anonymous_feature;T0* _arguments;T0* _parent;T351 _start_position;};
extern T500 M500;
struct S535{Tid id;T0* _declaration_type_memory;T0* _explicit_type_mark;T351 _start_position;};
extern T535 M535;
struct S536{Tid id;T0* _explicit_type;T0* _writable;T0* _call;T6 _default_create_call;T351 _start_position;};
extern T536 M536;
struct S978{T1138 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T978 M978;
struct S979{Tid id;T1139 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T979 M979;
struct S468{Tid id;T0* _to_string;T0* _hashed_string;T0* _outside_set;T0* _result_type;T2 _rank;T351 _start_position;};
extern T468 M468;
struct S469{Tid id;T0* _name_list;};
extern T469 M469;
struct S980{Tid id;T1140 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T980 M980;
struct S406{Tid id;T0* _name;};
extern T406 M406;
struct S981{T1141 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T981 M981;
struct S684{Tid id;T0* _direct_parents_require;T0* _local_require;T2 _eiffel_parser_stamp;T6 _is_require_else;};
extern T684 M684;
struct S982{T1143 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T982 M982;
struct S435{Tid id;T0* _source_view;T0* _comment;T0* _expression;T0* _tag;};
extern T435 M435;
struct S983{Tid id;T1144 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T983 M983;
struct S403{Tid id;T0* _result_type;T0* _to_string;T0* _outside_set;T0* _hashed_string;T2 _parsing_reference_counter;T351 _start_position;T2 _rank;T2 _live_reference_counter;};
extern T403 M403;
struct S537{Tid id;T0* _assertion_list;T0* _index_list;T2 _eiffel_parser_stamp;};
extern T537 M537;
struct S984{T1145 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T984 M984;
struct S496{Tid id;T0* _compound;T0* _key_list;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T496 M496;
struct S427{Tid id;T0* _then_compound;T0* _expression;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T427 M427;
struct S413{Tid id;T0* _else_compound;T0* _elseif_list;T0* _then_compound;T0* _expression;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T413 M413;
struct S985{T1147 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T985 M985;
struct S371{Tid id;T0* _dispatch_live_type;T0* _strip_condition;T0* _values;T0* _list;T0* _condition_live_type;T0* _compound;T0* _header_comment;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T371 M371;
struct S384{Tid id;T0* _written_declaration_type_mark;T0* _declaration_type;T351 _start_position;};
extern T384 M384;
struct S376{Tid id;T0* _dynamic_dispatch_temporary1;T0* _condition_type;T0* _manifest_string_inspector;T0* _else_compound;T351 _else_position;T0* _when_list;T0* _expression;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T376 M376;
struct S498{Tid id;T0* _dynamic_dispatch_temporary1;T0* _condition_type;T0* _manifest_string_inspector;T0* _else_compound;T351 _else_position;T0* _when_list;T0* _expression;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T498 M498;
struct S443{Tid id;T0* _list;T0* _header_comment;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T443 M443;
struct S484{Tid id;T0* _expression;T0* _comment2;T0* _tag;T0* _comment1;};
extern T484 M484;
struct S485{Tid id;T0* _loop_body;T0* _until_expression;T0* _loop_variant;T0* _loop_invariant;T0* _initialize;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T485 M485;
struct S378{Tid id;T0* _once_function;T0* _enclosing_function;T0* _written_declaration_type_mark;T0* _type_mark_memory;T0* _declaration_type;T351 _start_position;};
extern T378 M378;
struct S419{Tid id;T0* _explicit_type;T351 _start_position;T0* _call;T0* _writable;T2 _eiffel_parser_stamp;T6 _default_create_call;};
extern T419 M419;
struct S482{Tid id;T0* _source_view;T0* _c_code;T2 _eiffel_parser_stamp;T6 _is_c_inline_c;T351 _start_position;};
extern T482 M482;
struct S513{Tid id;T0* _specialized_parent;T0* _specialized_anonymous_feature;T0* _arguments;T0* _parent;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T513 M513;
struct S503{Tid id;T0* _written_declaration_type_mark;T0* _declaration_type;T351 _start_position;};
extern T503 M503;
struct S381{Tid id;T0* _right_side;T0* _left_side;T2 _eiffel_parser_stamp;};
extern T381 M381;
struct S409{Tid id;T0* _left_side;T0* _right_side;T2 _eiffel_parser_stamp;T6 _forced_flag;};
extern T409 M409;
struct S483{Tid id;T0* _right_side;T0* _left_side;T2 _eiffel_parser_stamp;};
extern T483 M483;
struct S477{Tid id;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T477 M477;
struct S410{Tid id;T0* _list;T2 _eiffel_parser_stamp;};
extern T410 M410;
struct S680{Tid id;T351 _start_position;T0* _list;T0* _header_comment;T2 _eiffel_parser_stamp;T6 _is_ensure_then;};
extern T680 M680;
struct S502{Tid id;T0* _closed_operand_list;T0* _open_operand_list;T0* _feature_stamp;T0* _code;T0* _context_features;T0* _original_function_call;T0* _resolved_memory;T0* _inline_feature;T6 _has_omitted_open_arguments;T351 _start_position;};
extern T502 M502;
struct S472{Tid id;T0* _comment;T0* _expression;};
extern T472 M472;
struct S411{Tid id;T351 _start_position;};
extern T411 M411;
struct S473{Tid id;T0* _then_expression;T0* _expression;T351 _start_position;};
extern T473 M473;
struct S475{Tid id;T0* _resolve_map;T0* _else_part;T0* _elseif_list;T0* _then_expression;T0* _expression;T351 _start_position;};
extern T475 M475;
struct S512{Tid id;T0* _expression;T351 _start_position;T0* _tagged_data_map;};
extern T512 M512;
struct S534{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T534 M534;
struct S533{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T533 M533;
struct S529{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T529 M529;
struct S530{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T530 M530;
struct S531{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T531 M531;
struct S532{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T532 M532;
struct S528{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T528 M528;
struct S389{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T389 M389;
struct S412{Tid id;T0* _right_side;T0* _left_side;T351 _operator_position;T6 _eq_flag;};
extern T412 M412;
struct S524{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T524 M524;
struct S525{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T525 M525;
struct S526{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T526 M526;
struct S527{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T527 M527;
struct S417{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T417 M417;
struct S523{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T523 M523;
struct S520{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T520 M520;
struct S521{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T521 M521;
struct S522{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T522 M522;
struct S519{Tid id;T0* _feature_name;T0* _arguments;T0* _target;T0* _parentheses_feature_name_memory;T0* _feature_stamp;T0* _written_declaration_type_mark_memory;T6 _is_assigned_to;};
extern T519 M519;
struct S476{Tid id;T0* _calling_code;T0* _feature_stamp;T0* _target_type;T0* _feature_name;T0* _local_name;};
extern T476 M476;
struct S479{T0* _permissions;T0* _items;T0* _for_all;T351 _start_position;};
extern T479 M479;
struct S478{T0* _list;T0* _clients;};
extern T478 M478;
struct S988{T1155 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T988 M988;
struct S446{T0* _list;T0* _class_text;T0* _comment;T0* _clients;};
extern T446 M446;
struct S784{T0* _path;T0* _cluster;T0* _class_name;};
extern T784 M784;
struct S470{T351 _start_position;T0* _hashed_name;};
extern T470 M470;
struct S372{Tid id;T0* _declaration_type;T0* _formal_arg_list;T2 _closure_rank;T351 _start_position;T2 _rank;T6 _is_outside;};
extern T372 M372;
struct S425{Tid id;T0* _declaration_type;T0* _written_declaration_type_mark;T0* _feature_stamp;T0* _feature_name;};
extern T425 M425;
struct S408{Tid id;T0* _declaration_type;T0* _local_var_list;T0* _written_declaration_type_mark;T2 _closure_rank;T351 _start_position;T2 _rank;T6 _is_outside;};
extern T408 M408;
struct S989{T0* _cache_node;T0* _free_nodes;T1156 _buckets;T2 _cache_user;T2 _cache_buckets;T2 _generation;T2 _count;T2 _capacity;};
extern T989 M989;
struct S421{Tid id;T0* _ensure_assertion;T0* _type_of_current;T0* _old_list;T0* _result_type;T0* _name;T0* _require_assertion;T0* _base_feature;T2 _use_current_state;T2 _order;};
extern T421 M421;
struct S993{T1159 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T993 M993;
struct S995{T0* _next;T0* _key;T0* _item;};
extern T995 M995;
struct S997{T1160 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T997 M997;
struct S998{T0* _free_nodes;T1161 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T998 M998;
struct S463{T0* _insert_comment;T0* _inherit_comment;T0* _inherit_list;T0* _class_text;T0* _insert_list;T6 _default_insert_any_added_flag;};
extern T463 M463;
struct S999{T0* _free_nodes;T1164 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T999 M999;
struct S445{T0* _list;};
extern T445 M445;
struct S460{T0* _list;};
extern T460 M460;
struct S1000{T0* _free_nodes;T0* _cache_node;T1171 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1000 M1000;
struct S442{Tid id;T0* _list;T0* _header_comment;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T442 M442;
struct S415{Tid id;T0* _closure_local_vars;T0* _result_type;T0* _closure_arguments;T0* _alias_string;T0* _permissions;T0* _routine_body;T0* _assigner;T0* _local_vars;T0* _ensure_assertion;T0* _obsolete_mark;T0* _require_assertion;T0* _native;T0* _header_comment;T0* _end_comment;T0* _feature_text;T0* _index_list;T0* _arguments;T6 _has_closures;T6 _is_generated_eiffel;};
extern T415 M415;
struct S1001{T0* _free_nodes;T0* _cache_node;T1174 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1001 M1001;
struct S1002{T1175 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T1002 M1002;
struct S101{T0* _thread_types;};
extern T101 M101;
struct S1004{T1177 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1004 M1004;
struct S701{Tid id;T0* _permissions;T0* _assigner;T0* _end_comment;T0* _ensure_assertion;T0* _obsolete_mark;T0* _require_assertion;T0* _closure_local_vars;T0* _header_comment;T0* _specialized_feature_stamp;T0* _index_list;T0* _feature_text;T0* _closure_arguments;T0* _result_type;T2 _rank;};
extern T701 M701;
struct S1005{T1178 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1005 M1005;
struct S1010{T1179 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1010 M1010;
struct S1011{T0* _free_nodes;T0* _cache_node;T1181 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1011 M1011;
struct S543{T0* _source_type;T0* _destination_graph_nodes;T2 _hash_code;};
extern T543 M543;
struct S1013{T0* _cache_node;T0* _free_nodes;T1184 _buckets;T2 _cache_user;T2 _cache_buckets;T2 _generation;T2 _count;T2 _capacity;};
extern T1013 M1013;
struct S1014{T0* _free_nodes;T1187 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1014 M1014;
struct S1017{T1175 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1017 M1017;
struct S1018{T0* _cache_node;T0* _free_nodes;T1194 _val_buckets;T1194 _key_buckets;T2 _count;T2 _capacity;T2 _generation;T2 _cache_user;T2 _cache_buckets;};
extern T1018 M1018;
struct S1021{T0* _free_nodes;T1200 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1021 M1021;
struct S1022{T960 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1022 M1022;
struct S1023{T1201 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1023 M1023;
struct S1024{T0* _next;T0* _key;T0* _item;};
extern T1024 M1024;
struct S1027{T0* _next;T0* _key;T0* _item;};
extern T1027 M1027;
struct S1031{T1202 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1031 M1031;
struct S1036{T0* _free_nodes;T1203 _buckets;T2 _cache_user;T2 _generation;T2 _count;T2 _capacity;};
extern T1036 M1036;
struct S1037{T0* _free_nodes;T0* _cache_node;T1208 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1037 M1037;
struct S1038{T0* _free_nodes;T0* _cache_node;T1211 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1038 M1038;
struct S1039{T0* _cache_node;T0* _free_nodes;T1212 _buckets;T2 _cache_user;T2 _cache_buckets;T2 _generation;T2 _count;T2 _capacity;};
extern T1039 M1039;
struct S1040{T1215 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1040 M1040;
struct S547{Tid id;T0* _context_type;T0* _feature_stamp;T0* _dynamic_type;};
extern T547 M547;
struct S1041{T0* _free_nodes;T0* _cache_node;T1217 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1041 M1041;
struct S1042{T1358 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1042 M1042;
struct S581{T0* _agent_type;T0* _signature;};
extern T581 M581;
struct S1044{T0* _cache_node;T0* _free_nodes;T1219 _buckets;T2 _cache_user;T2 _cache_buckets;T2 _generation;T2 _count;T2 _capacity;};
extern T1044 M1044;
struct S1045{T0* _free_nodes;T0* _cache_node;T1223 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1045 M1045;
struct S1046{T1225 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1046 M1046;
struct S1049{T0* _next;T0* _key;T0* _item;};
extern T1049 M1049;
struct S1051{T1226 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1051 M1051;
struct S1052{T1227 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1052 M1052;
struct S1053{T0* _free_nodes;T0* _cache_node;T1228 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1053 M1053;
struct S1054{T1231 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1054 M1054;
struct S660{T0* _parents_edges;T0* _build_definition;T0* _feature_name;T0* _parents_type;T0* _body_type;T0* _parents_af;T0* _body_inherit;T0* _body_feature;T6 _local_definition;T1 _computing_result_type;T6 _signature_ready;};
extern T660 M660;
struct S1055{T0* _free_nodes;T1235 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1055 M1055;
struct S1056{T1175 _storage;T2 _capacity;T2 _lower;T2 _generation;T2 _storage_lower;T2 _upper;};
extern T1056 M1056;
struct S1057{T0* _cache_node;T0* _free_nodes;T1236 _buckets;T2 _cache_user;T2 _cache_buckets;T2 _generation;T2 _count;T2 _capacity;};
extern T1057 M1057;
extern T348 M348;
struct S1058{T0* _free_nodes;T0* _cache_node;T1241 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1058 M1058;
struct S1063{T0* _free_nodes;T1244 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1063 M1063;
struct S1064{T1245 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T1064 M1064;
struct S1065{T1246 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T1065 M1065;
struct S1066{T1179 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1066 M1066;
struct S1069{T0* _next;T0* _key;T0* _item;};
extern T1069 M1069;
struct S1072{T0* _next;T0* _key;T10 _item;};
extern T1072 M1072;
struct S1075{T0* _next;T0* _item;};
extern T1075 M1075;
struct S1079{T0* _free_nodes;T1249 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1079 M1079;
struct S842{Tid id;T0* _bdw;T0* _type;T0* _assignment;};
extern T842 M842;
extern T843 M843;
struct S844{Tid id;T0* _bdw;T0* _live_type;T0* _native_array_collector;};
extern T844 M844;
struct S846{Tid id;T0* _structer;};
extern T846 M846;
struct S848{Tid id;T0* _wa_cycle;T0* _wa_cyclic_buf;T0* _wa_buf;};
extern T848 M848;
struct S849{Tid id;};
extern T849 M849;
struct S850{Tid id;};
extern T850 M850;
struct S851{Tid id;T6 _flag;};
extern T851 M851;
struct S1080{T1251 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1080 M1080;
struct S845{Tid id;T0* _tag;T2 _count;T2 _id;};
extern T845 M845;
struct S852{Tid id;T0* _type;T0* _tag;};
extern T852 M852;
struct S1081{T1252 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1081 M1081;
struct S1084{T0* _lost_nodes_memory;T0* _root;T0* _map;T0* _item_memory;T2 _count;T2 _generation;T6 _rebalance;T6 _map_dirty;};
extern T1084 M1084;
struct S1086{T0* _item;T0* _next;T2 _key;};
extern T1086 M1086;
struct S1089{T1258 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1089 M1089;
struct S583{T0* _feature_name;T0* _target_type_mark;T0* _code;T0* _c_name;T0* _target_type;T6 _is_creation;};
extern T583 M583;
struct S1091{T0* _next;T0* _key;T0* _item;};
extern T1091 M1091;
struct S1093{T0* _item;};
extern T1093 M1093;
struct S1095{T1260 _storage;T2 _capacity;T2 _lower;T2 _generation;T2 _storage_lower;T2 _upper;};
extern T1095 M1095;
struct S1096{T1261 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1096 M1096;
extern T324 M324;
extern T747 M747;
struct S1098{T0* _free_nodes;T1264 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1098 M1098;
struct S1101{T1266 _storage;T2 _capacity;T2 _lower;T2 _generation;T2 _storage_lower;T2 _upper;};
extern T1101 M1101;
struct S1105{T0* _ordered_keys;T0* _free_nodes;T1267 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1105 M1105;
struct S1106{Tid id;T0* _cache_node;T0* _ordered_keys;T0* _free_nodes;T948 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1106 M1106;
extern T542 M542;
struct S1108{T0* _free_nodes;T0* _cache_node;T1274 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1108 M1108;
struct S809{Tid id;T0* _to_string;};
extern T809 M809;
struct S1110{T1276 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1110 M1110;
struct S1111{T0* _free_nodes;T1279 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1111 M1111;
struct S1113{T0* _next;T0* _key;T0* _item;};
extern T1113 M1113;
struct S1116{T0* _next;T0* _key;T0* _item;};
extern T1116 M1116;
struct S1119{T0* _next;T0* _item;};
extern T1119 M1119;
struct S1122{T0* _next;T0* _key;T2 _item;};
extern T1122 M1122;
struct S1124{T0* _free_nodes;T1280 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1124 M1124;
extern T726 M726;
struct S699{Tid id;T0* _value_memory;T0* _obsolete_mark;T0* _result_type;T0* _closure_local_vars;T0* _closure_arguments;T0* _permissions;T0* _assigner;T0* _ensure_assertion;T0* _require_assertion;T0* _header_comment;T0* _feature_text;T0* _index_list;};
extern T699 M699;
struct S696{Tid id;T0* _assigner;T0* _value_memory;T0* _index_list;T0* _ensure_assertion;T0* _result_type;T0* _require_assertion;T0* _closure_arguments;T0* _header_comment;T0* _obsolete_mark;T0* _feature_text;T0* _permissions;T0* _closure_local_vars;T2 _rank;};
extern T696 M696;
struct S584{Tid id;T0* _arguments;T0* _closure_local_vars;T0* _inline_result;T0* _closure_arguments;T0* _rescue_compound;T0* _permissions;T0* _routine_then;T0* _assigner;T0* _local_vars;T0* _ensure_assertion;T0* _obsolete_mark;T0* _require_assertion;T0* _result_type;T0* _header_comment;T0* _routine_body;T0* _feature_text;T0* _index_list;T0* _end_comment;T2 _use_current_state;T6 _has_closures;};
extern T584 M584;
struct S700{Tid id;T0* _value_memory;T0* _obsolete_mark;T0* _result_type;T0* _closure_local_vars;T0* _closure_arguments;T0* _permissions;T0* _assigner;T0* _ensure_assertion;T0* _require_assertion;T0* _header_comment;T0* _feature_text;T0* _index_list;};
extern T700 M700;
struct S1128{Tid id;T1125 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1128 M1128;
struct S1130{Tid id;T1126 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1130 M1130;
struct S693{Tid id;T0* _value_memory;T0* _obsolete_mark;T0* _result_type;T0* _closure_local_vars;T0* _closure_arguments;T0* _permissions;T0* _assigner;T0* _ensure_assertion;T0* _require_assertion;T0* _header_comment;T0* _feature_text;T0* _index_list;};
extern T693 M693;
struct S686{Tid id;T0* _closure_arguments;T0* _permissions;T0* _routine_body;T0* _index_list;T0* _assigner;T0* _end_comment;T0* _ensure_assertion;T0* _arguments;T0* _require_assertion;T0* _result_type;T0* _header_comment;T0* _obsolete_mark;T0* _feature_text;T0* _local_vars;T0* _closure_local_vars;T6 _has_closures;};
extern T686 M686;
struct S689{Tid id;T0* _closure_local_vars;T0* _closure_arguments;T0* _alias_string;T0* _permissions;T0* _routine_body;T0* _assigner;T0* _local_vars;T0* _ensure_assertion;T0* _obsolete_mark;T0* _require_assertion;T0* _native;T0* _header_comment;T0* _end_comment;T0* _feature_text;T0* _index_list;T0* _arguments;T6 _has_closures;T6 _is_generated_eiffel;};
extern T689 M689;
struct S691{Tid id;T0* _closure_local_vars;T0* _closure_arguments;T0* _rescue_compound;T0* _permissions;T0* _routine_then;T0* _assigner;T0* _local_vars;T0* _ensure_assertion;T0* _obsolete_mark;T0* _require_assertion;T0* _arguments;T0* _header_comment;T0* _routine_body;T0* _feature_text;T0* _index_list;T0* _end_comment;T2 _use_current_state;T6 _has_closures;};
extern T691 M691;
struct S698{Tid id;T0* _value_memory;T0* _obsolete_mark;T0* _result_type;T0* _closure_local_vars;T0* _closure_arguments;T0* _permissions;T0* _assigner;T0* _ensure_assertion;T0* _require_assertion;T0* _header_comment;T0* _feature_text;T0* _index_list;};
extern T698 M698;
struct S692{Tid id;T0* _closure_local_vars;T0* _result_type;T0* _closure_arguments;T0* _rescue_compound;T0* _permissions;T0* _routine_then;T0* _assigner;T0* _local_vars;T0* _ensure_assertion;T0* _obsolete_mark;T0* _require_assertion;T0* _arguments;T0* _header_comment;T0* _routine_body;T0* _feature_text;T0* _index_list;T0* _end_comment;T2 _use_current_state;T6 _has_closures;};
extern T692 M692;
struct S688{Tid id;T0* _permissions;T0* _routine_body;T0* _index_list;T0* _assigner;T0* _end_comment;T0* _ensure_assertion;T0* _arguments;T0* _require_assertion;T0* _closure_arguments;T0* _header_comment;T0* _obsolete_mark;T0* _feature_text;T0* _local_vars;T0* _closure_local_vars;T6 _has_closures;};
extern T688 M688;
struct S690{Tid id;T0* _closure_local_vars;T0* _closure_arguments;T0* _rescue_compound;T0* _permissions;T0* _routine_then;T0* _assigner;T0* _local_vars;T0* _ensure_assertion;T0* _obsolete_mark;T0* _require_assertion;T0* _arguments;T0* _header_comment;T0* _routine_body;T0* _feature_text;T0* _index_list;T0* _end_comment;T2 _use_current_state;T6 _has_closures;};
extern T690 M690;
struct S697{Tid id;T0* _assigner;T0* _value_memory;T0* _ensure_assertion;T0* _obsolete_mark;T0* _require_assertion;T0* _closure_local_vars;T0* _header_comment;T0* _permissions;T0* _feature_text;T0* _result_type;T0* _index_list;T0* _closure_arguments;T2 _rank;};
extern T697 M697;
struct S432{T0* _list;};
extern T432 M432;
struct S1132{T1284 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T1132 M1132;
struct S1133{T0* _free_nodes;T1287 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1133 M1133;
struct S1134{T0* _free_nodes;T0* _cache_node;T1290 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1134 M1134;
struct S1135{T1047 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1135 M1135;
struct S713{T0* _list;};
extern T713 M713;
struct S1142{T1292 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1142 M1142;
struct S1146{T1293 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1146 M1146;
struct S763{Tid id;T0* _lower_manifest_expression;T0* _upper_manifest_expression;T0* _upper;T0* _lower;};
extern T763 M763;
struct S1148{T1294 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1148 M1148;
struct S394{Tid id;T0* _manifest_expression;T0* _expression;};
extern T394 M394;
struct S465{Tid id;T0* _list;};
extern T465 M465;
struct S675{Tid id;T0* _declaration_type;T0* _type_mark;T0* _writable;};
extern T675 M675;
struct S1149{T1295 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1149 M1149;
struct S1150{T1296 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1150 M1150;
struct S676{Tid id;T0* _original_capture;T0* _capture_memory;T2 _rank;T6 _inside_agent_launcher_flag;T351 _start_position;};
extern T676 M676;
struct S1151{T1297 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1151 M1151;
struct S1152{T1298 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1152 M1152;
struct S1153{T0* _free_nodes;T1301 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1153 M1153;
struct S1157{T0* _next;T0* _item;};
extern T1157 M1157;
struct S1162{T0* _next;T0* _key;T1 _item;};
extern T1162 M1162;
struct S1165{T0* _next;T0* _key;T0* _item;};
extern T1165 M1165;
struct S1167{T1302 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1167 M1167;
struct S1168{T1303 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1168 M1168;
struct S1170{T0* _next;T0* _key;T0* _item;};
extern T1170 M1170;
struct S428{Tid id;T0* _compound;T2 _eiffel_parser_stamp;};
extern T428 M428;
struct S1173{T0* _next;T0* _key;T0* _item;};
extern T1173 M1173;
struct S1176{T0* _free_nodes;T0* _cache_node;T1305 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1176 M1176;
struct S1180{T0* _next;T0* _key;T0* _item;};
extern T1180 M1180;
struct S1185{T0* _next;T0* _item;};
extern T1185 M1185;
struct S1188{T0* _next;T0* _key;T1 _item;};
extern T1188 M1188;
struct S1193{T0* _next_val;T0* _next_key;T0* _key;T0* _val;};
extern T1193 M1193;
struct S1196{T0* _free_nodes;T1307 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1196 M1196;
struct S1199{T0* _next;T0* _key;T0* _item;};
extern T1199 M1199;
struct S1204{T0* _next;T0* _item;};
extern T1204 M1204;
struct S1207{T0* _next;T0* _key;T0* _item;};
extern T1207 M1207;
struct S1210{T0* _next;T0* _key;T0* _item;};
extern T1210 M1210;
struct S1213{T0* _next;T0* _item;};
extern T1213 M1213;
struct S1216{T0* _next;T0* _key;T0* _item;};
extern T1216 M1216;
struct S1220{T0* _next;T0* _item;};
extern T1220 M1220;
struct S1222{T0* _next;T0* _key;T0* _item;};
extern T1222 M1222;
struct S1229{T0* _next;T0* _key;T0* _item;};
extern T1229 M1229;
struct S1234{T0* _next;T0* _key;T0* _item;};
extern T1234 M1234;
struct S1237{T0* _next;T348 _item;};
extern T1237 M1237;
struct S1240{T0* _next;T348 _key;T0* _item;};
extern T1240 M1240;
struct S1243{T0* _next;T0* _key;T0* _item;};
extern T1243 M1243;
struct S1248{T0* _next;T0* _key;T0* _item;};
extern T1248 M1248;
struct S879{T0* _struct;};
extern T879 M879;
struct S1250{T1310 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1250 M1250;
struct S1253{T1311 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1253 M1253;
struct S1254{T0* _right;T0* _left;T0* _item;T2 _balance;int _safe_equal;};
extern T1254 M1254;
struct S1255{Tid id;T1311 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1255 M1255;
struct S1256{T0* _free_nodes;T1314 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1256 M1256;
struct S369{Tid id;T2 _rank;T351 _start_position;T0* _result_type;T0* _declaration_type;};
extern T369 M369;
struct S1259{T0* _cache_node;T0* _free_nodes;T1317 _buckets;T2 _cache_user;T2 _cache_buckets;T2 _generation;T2 _count;T2 _capacity;};
extern T1259 M1259;
struct S1263{T0* _next;T0* _key;T0* _item;};
extern T1263 M1263;
struct S1268{T0* _next;T0* _key;T0* _item;};
extern T1268 M1268;
struct S1269{Tid id;T0* _traversable;T2 _generation;T2 _item_index;};
extern T1269 M1269;
struct S801{Tid id;T0* _output;T0* _input;T0* _errstream;T0* _error;T0* _instream;T0* _group;T0* _outstream;T8 _data;T6 _is_connected;T6 _direct_input;T6 _direct_error;T6 _direct_output;};
extern T801 M801;
struct S802{Tid id;T0* _output;T0* _input;T0* _errstream;T0* _error;T0* _instream;T0* _group;T0* _outstream;T8 _data;T6 _is_connected;T6 _direct_input;T6 _direct_error;T6 _direct_output;};
extern T802 M802;
struct S803{Tid id;T0* _group;T6 _direct_error;T6 _direct_output;T6 _direct_input;};
extern T803 M803;
struct S798{Tid id;T0* _id_map;T8 _data;};
extern T798 M798;
struct S799{Tid id;T0* _handle_map;T8 _data;T6 _handle_list_dirty;};
extern T799 M799;
struct S800{Tid id;};
extern T800 M800;
struct S1273{T0* _next;T0* _key;T0* _item;};
extern T1273 M1273;
struct S1278{T0* _next;T0* _key;T0* _item;};
extern T1278 M1278;
struct S1281{T0* _next;T0* _key;T0* _item;};
extern T1281 M1281;
struct S1283{T1323 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1283 M1283;
struct S1286{T0* _next;T0* _key;T0* _item;};
extern T1286 M1286;
struct S1289{T0* _next;T0* _key;T0* _item;};
extern T1289 M1289;
struct S1291{T1324 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1291 M1291;
struct S1300{T0* _next;T0* _key;T0* _item;};
extern T1300 M1300;
struct S1304{T0* _next;T0* _key;T0* _item;};
extern T1304 M1304;
struct S1308{T0* _next;T0* _key;T0* _item;};
extern T1308 M1308;
struct S1315{T0* _next;T0* _key;T0* _item;};
extern T1315 M1315;
struct S1318{T0* _next;T0* _item;};
extern T1318 M1318;
struct S1320{T1030 _storage;T2 _capacity;T2 _lower;T2 _generation;T2 _storage_lower;T2 _upper;};
extern T1320 M1320;
struct S1321{T0* _free_nodes;T1326 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1321 M1321;
struct S1322{T0* _free_nodes;T1329 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1322 M1322;
struct S1325{T0* _item;T0* _next;T2 _key;};
extern T1325 M1325;
struct S1328{T0* _item;T0* _next;T2 _key;};
extern T1328 M1328;
struct S61{T0* _filter;T9 _buffer;T2 _capacity;};
extern T61 M61;
struct S811{Tid id;T0* _to_string_cache;T0* _path;T3 _drive;T6 _valid_cache;};
extern T811 M811;
extern T767 M767;
struct S682{Tid id;T2 _eiffel_parser_stamp;T351 _start_position;T3 _info_code;};
extern T682 M682;
struct S1335{T0* _free_nodes;T1362 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1335 M1335;
struct S1336{T0* _item_2;T0* _item_1;};
extern T1336 M1336;
struct S1337{T0* _free_nodes;T1366 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1337 M1337;
struct S1338{T0* _cache_node;T0* _free_nodes;T1368 _buckets;T2 _cache_user;T2 _cache_buckets;T2 _generation;T2 _count;T2 _capacity;};
extern T1338 M1338;
struct S1340{T0* _free_nodes;T0* _cache_node;T1373 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1340 M1340;
struct S1343{T0* _free_nodes;T0* _cache_node;T1376 _buckets;T2 _count;T2 _cache_user;T2 _generation;T2 _capacity;T2 _cache_buckets;};
extern T1343 M1343;
struct S702{Tid id;T351 _end_position;T351 _start_position;T6 _synthetic_tuple;};
extern T702 M702;
struct S667{Tid id;T0* _type_mark;T351 _start_position;};
extern T667 M667;
struct S580{Tid id;T0* _target_type;T0* _feature_stamp;T351 _start_position;};
extern T580 M580;
struct S548{T0* _code;};
extern T548 M548;
struct S1344{T1377 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1344 M1344;
struct S668{Tid id;T0* _dynamic_type;T0* _side_effect_free_expression;};
extern T668 M668;
struct S672{Tid id;T0* _target_type;T0* _target;T0* _tagged_data_map;};
extern T672 M672;
struct S671{Tid id;T0* _live_type;T0* _dynamic_dispatch_temporary1;};
extern T671 M671;
struct S673{Tid id;T0* _dynamic_dispatch_temporary1;};
extern T673 M673;
struct S670{Tid id;T351 _start_position;T0* _tag;T0* _tagged_data_map;T0* _original_expression;T6 _collect_flag;};
extern T670 M670;
struct S681{Tid id;T0* _expression;T2 _eiffel_parser_stamp;};
extern T681 M681;
struct S666{Tid id;T0* _result_type_memory;T0* _pretty_view;uint64_t _value_memory;T351 _start_position;T2 _size;};
extern T666 M666;
struct S683{Tid id;T0* _error_message;T2 _eiffel_parser_stamp;int _exceptions;T351 _start_position;T2 _error_code;};
extern T683 M683;
extern T342 M342;
struct S1345{T1358 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1345 M1345;
struct S1346{T0* _root;T0* _lost_nodes_memory;T0* _map;T2 _generation;T2 _count;T6 _rebalance;T351 _item_memory;T6 _map_dirty;};
extern T1346 M1346;
struct S544{Tid id;T0* _expression_type;T0* _expression;T0* _resolved_memory;};
extern T544 M544;
struct S677{Tid id;T0* _feature_name_memory;T0* _written_link;T0* _agent_args;T0* _fake_tuple;T0* _target;T0* _agent_type;};
extern T677 M677;
struct S578{Tid id;T0* _target_type;T0* _feature_stamp;T351 _start_position;T2 _eiffel_parser_stamp;};
extern T578 M578;
struct S685{Tid id;T0* _agent_type;T0* _feature_name_memory;T0* _written_link;T0* _agent_args;T0* _fake_tuple;T0* _target;T2 _eiffel_parser_stamp;};
extern T685 M685;
struct S764{T0* _headers;T351 _start_position;T0* _string_pool;T2 _empty_index;T351 _empty_position;};
extern T764 M764;
struct S765{Tid id;T0* _type;T0* _trace;T6 _trace_result;};
extern T765 M765;
struct S1348{T0* _item;};
extern T1348 M1348;
struct S1349{T1381 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1349 M1349;
struct S1350{T1382 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1350 M1350;
extern T320 M320;
struct S128{Tid id;T6 _can_be_dropped_flag;T6 _precomputable;};
extern T128 M128;
struct S1351{T0* _free_nodes;T1383 _buckets;T2 _cache_user;T2 _generation;T2 _count;T2 _capacity;};
extern T1351 M1351;
struct S1352{T1386 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1352 M1352;
struct S770{Tid id;T0* _base_feature;T0* _routine_body;T0* _local_vars;T0* _ensure_assertion;T0* _require_assertion;T0* _old_list;T0* _arguments;T0* _name;T0* _result_type;T0* _type_of_current;T2 _use_current_state;};
extern T770 M770;
struct S122{T6 _used;};
extern T122 M122;
struct S1357{T1201 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T1357 M1357;
struct S429{Tid id;T0* _feature_name;T0* _target;T0* _written_declaration_type_mark_memory;T0* _feature_stamp;T0* _arguments_0;T6 _is_assigned_to;};
extern T429 M429;
struct S426{Tid id;T0* _explicit_type;T351 _start_position;T0* _call;T0* _writable;T2 _eiffel_parser_stamp;T6 _default_create_call;};
extern T426 M426;
struct S380{Tid id;T351 _start_position;T0* _target_type;T3 _array_name;};
extern T380 M380;
struct S820{Tid id;T0* _old_list;T0* _result_type;T0* _name;T0* _base_feature;T0* _type_of_current;T0* _value;T2 _use_current_state;};
extern T820 M820;
struct S663{Tid id;T0* _arguments;T0* _base_feature;T0* _rescue_compound;T0* _routine_body;T0* _local_vars;T0* _require_assertion;T0* _old_list;T0* _ensure_assertion;T0* _name;T0* _result_type;T0* _type_of_current;T2 _use_current_state;};
extern T663 M663;
struct S818{Tid id;T0* _base_feature;T0* _ensure_assertion;T0* _require_assertion;T0* _old_list;T0* _arguments;T0* _name;T0* _result_type;T0* _type_of_current;T2 _use_current_state;};
extern T818 M818;
struct S771{Tid id;T0* _base_feature;T0* _routine_body;T0* _local_vars;T0* _ensure_assertion;T0* _old_list;T0* _arguments;T0* _name;T0* _require_assertion;T0* _type_of_current;T2 _use_current_state;};
extern T771 M771;
struct S669{Tid id;T351 _start_position;T0* _declaration_type;T0* _index;T0* _array;};
extern T669 M669;
struct S553{Tid id;T0* _arguments;T0* _base_feature;T0* _ensure_assertion;T0* _routine_body;T0* _type_of_current;T0* _old_list;T0* _require_assertion;T0* _name;T0* _local_vars;T0* _rescue_compound;T2 _use_current_state;T6 _side_effect_free_flag;};
extern T553 M553;
struct S1359{T1310 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T1359 M1359;
struct S819{Tid id;T0* _arguments;T0* _base_feature;T0* _rescue_compound;T0* _routine_body;T0* _local_vars;T0* _require_assertion;T0* _old_list;T0* _ensure_assertion;T0* _name;T0* _result_type;T0* _type_of_current;T2 _use_current_state;};
extern T819 M819;
struct S662{Tid id;T0* _base_feature;T0* _ensure_assertion;T0* _rescue_compound;T0* _routine_body;T0* _local_vars;T0* _old_list;T0* _arguments;T0* _name;T0* _require_assertion;T0* _type_of_current;T2 _use_current_state;};
extern T662 M662;
struct S350{T2 _item;};
extern T350 M350;
struct S1361{T1387 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1361 M1361;
struct S871{Tid id;T0* _process;T0* _filter;T8 _pipe;T2 _filtered_descriptor;T6 _is_connected;};
extern T871 M871;
struct S873{Tid id;T0* _process;T8 _pipe;T2 _filtered_descriptor;T6 _is_connected;T6 _can_unread_character;T6 _has_unread_character;T3 _unread_buffer;T6 _end_of_input;T3 _filtered_last_character;};
extern T873 M873;
struct S874{Tid id;T0* _process;T0* _filter;T8 _pipe;T8 _handle;T6 _is_connected;};
extern T874 M874;
struct S875{Tid id;T0* _process;T8 _handle;T8 _pipe;T6 _is_connected;T6 _can_unread_character;T6 _has_unread_character;T3 _unread_buffer;T6 _end_of_input;T3 _filtered_last_character;};
extern T875 M875;
struct S1363{T0* _next;T0* _key;T0* _item;};
extern T1363 M1363;
struct S1365{T0* _next;T0* _key;T0* _item;};
extern T1365 M1365;
struct S1369{T0* _next;T0* _item;};
extern T1369 M1369;
struct S1372{T0* _next;T0* _key;T0* _item;};
extern T1372 M1372;
struct S1375{T0* _next;T0* _key;T0* _item;};
extern T1375 M1375;
struct S1378{T1388 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1378 M1378;
struct S1379{T2 _balance;T351 _item;T0* _left;T0* _right;int _safe_equal;};
extern T1379 M1379;
struct S1380{Tid id;T1388 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1380 M1380;
struct S674{Tid id;T0* _list;T351 _start_position;};
extern T674 M674;
struct S869{T0* _transitions;T0* _headers;T0* _tag_state;T2 _empty_idx;T2 _id;T2 _maxstate;T6 _has_empty;};
extern T869 M869;
struct S738{Tid id;T11 _value;};
extern T738 M738;
struct S1384{T0* _next;T0* _item;};
extern T1384 M1384;
struct S1390{T0* _map;T0* _root;T0* _lost_nodes_memory;T2 _value_memory;T2 _count;T2 _generation;T2 _key_memory;T6 _rebalance;T6 _map_dirty;};
extern T1390 M1390;
struct S1392{T0* _first_link;T0* _free_nodes;T0* _last_link;T0* _mem_lnk;T2 _upper;T2 _generation;T2 _mem_idx;};
extern T1392 M1392;
struct S1393{T2 _item_2;T3 _item_1;};
extern T1393 M1393;
struct S1394{T1402 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1394 M1394;
struct S1395{T1403 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1395 M1395;
struct S1396{T0* _left;T0* _right;T2 _balance;int _safe_equal_key;T2 _value;T2 _key;};
extern T1396 M1396;
struct S1400{T0* _next;T0* _item;};
extern T1400 M1400;
struct S1401{T0* _free_nodes;T1406 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1401 M1401;
struct S1405{T0* _next;T0* _key;T0* _item;};
extern T1405 M1405;
struct S904{T0* _c_auto_init_plugin_deps_name;T0* _c_auto_init_plugin_deps_location;T0* _c_auto_init_function_name;T0* _c_compiler_options;T0* _c_linker_options;T0* _c_library_paths;T0* _c_libraries;T0* _c_header_paths;T0* _c_headers;T0* _c_sources;T351 _start_position;T6 _is_included;T6 _auto_init_done;T546 _bd;T0* _path;T0* _name;T2 _hash_code;};
extern T904 M904;
struct S577{T0* _type;T0* _doc_tag;T2 _number;T2 _eiffel_parser_stamp;};
extern T577 M577;
struct S659{T2 _declared_tmp_counter;};
extern T659 M659;
struct S1409{T1439 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1409 M1409;
struct S1412{T1440 _storage;T2 _lower;T2 _generation;T2 _capacity;T2 _upper;};
extern T1412 M1412;
struct S571{Tid id;T0* _internal_c_local_memory;T0* _static_type_memory;T0* _effective_arguments_memory;T0* _target_memory;T0* _anonymous_feature_memory;T0* _type_memory;};
extern T571 M571;
struct S572{Tid id;T0* _internal_c_local_memory;T0* _static_type_memory;T0* _effective_arguments_memory;T0* _target_memory;T0* _anonymous_feature_memory;T0* _type_memory;};
extern T572 M572;
struct S573{Tid id;T0* _internal_c_local_memory;T0* _static_type_memory;T0* _effective_arguments_memory;T0* _target_memory;T0* _anonymous_feature_memory;T0* _type_memory;};
extern T573 M573;
struct S574{Tid id;T0* _internal_c_local_memory;T0* _static_type_memory;T0* _effective_arguments_memory;T0* _target_memory;T0* _anonymous_feature_memory;T0* _type_memory;};
extern T574 M574;
struct S575{Tid id;T0* _internal_c_local_memory;T0* _static_type_memory;T0* _effective_arguments_memory;T0* _target_memory;T0* _anonymous_feature_memory;T0* _type_memory;};
extern T575 M575;
struct S576{Tid id;T0* _internal_c_local_memory;T0* _static_type_memory;T0* _effective_arguments_memory;T0* _target_memory;T0* _anonymous_feature_memory;T0* _type_memory;};
extern T576 M576;
struct S1426{Tid id;T0* _dictionary;T2 _generation;T2 _item_index;};
extern T1426 M1426;
struct S824{Tid id;T2 _count;T2 _index;};
extern T824 M824;
struct S1434{T1441 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1434 M1434;
struct S841{Tid id;T6 _item;};
extern T841 M841;
struct S1435{T0* _free_nodes;T1443 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1435 M1435;
struct S1436{T1445 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1436 M1436;
struct S743{T1030 _storage;T2 _capacity;T2 _offset;T2 _integer_length;T6 _negative;};
extern T743 M743;
struct S1437{Tid id;T1403 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1437 M1437;
struct S1438{T1446 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1438 M1438;
struct S1442{T0* _next;T0* _key;T0* _item;};
extern T1442 M1442;
struct S740{Tid id;T1030 _storage;T2 _capacity;T6 _negative;};
extern T740 M740;
struct S1461{T1137 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1461 M1461;
struct S816{Tid id;T0* _item;};
extern T816 M816;
struct S1462{T0* _free_nodes;T1465 _buckets;T2 _capacity;T2 _generation;T2 _cache_user;T2 _count;};
extern T1462 M1462;
struct S814{Tid id;T2 _item;};
extern T814 M814;
struct S1464{T9 _storage;T2 _generation;T2 _capacity;T2 _upper;};
extern T1464 M1464;
struct S1466{T0* _item;T0* _next;T2 _key;};
extern T1466 M1466;
extern char*s358_1195446850A;
extern char*s113_0A;
extern char*s117_1418906530A;
extern char*s33_424424A;
extern char*s647_25969530A;
extern char*s121_9A;
extern char*s111_10A;
extern char*s33_424430A;
extern char*s381_1114345928A;
extern char*s660_1983193131A;
extern char*s30_199827552A;
extern char*s117_1564992795A;
extern char*s647_59375621A;
extern char*s117_1772404517A;
extern char*s104_1078639380A;
extern char*s436_772854717A;
extern char*s104_1138390195A;
extern char*s117_523400916A;
extern char*s104_393689A;
extern char*s483_218994080A;
extern char*s117_12331A;
extern char*s694_32A;
extern char*s625_5794275A;
extern char*s729_1880914324A;
extern char*s104_34A;
extern char*s729_1607908341A;
extern char*s33_38A;
extern char*s117_40A;
extern char*s117_41A;
extern char*s640_7233618A;
extern char*s33_42A;
extern char*s33_43A;
extern char*s117_44A;
extern char*s117_36951A;
extern char*s113_45A;
extern char*s467_46A;
extern char*s113_47A;
extern char*s638_48A;
extern char*s126_1071750288A;
extern char*s29_1889925553A;
extern char*s425_532898088A;
extern char*s625_1664036235A;
extern char*s488_58A;
extern char*s625_1023028228A;
extern char*s648_59A;
extern char*s121_60A;
extern char*s33_60A;
extern char*s33_61A;
extern char*s647_2017590A;
extern char*s844_1752899740A;
extern char*s33_62A;
extern char*s30_63A;
extern char*s805_1883030297A;
extern char*s33_64A;
extern char*s106_1684808173A;
extern char*s650_1216329562A;
extern char*s104_67A;
extern char*s104_1268871407A;
extern char*s647_219498506A;
extern char*s30_1202957293A;
extern char*s34_212160365A;
extern char*s642_80037A;
extern char*s33_12376A;
extern char*s120_325166540A;
extern char*s117_77A;
extern char*s437_77A;
extern char*s825_79A;
extern char*s117_1206795525A;
extern char*s117_441192857A;
extern char*s625_82A;
extern char*s552_251231528A;
extern char*s625_84A;
extern char*s117_2189840A;
extern char*s115_301485A;
extern char*s117_392938270A;
extern char*s625_585895143A;
extern char*s640_91A;
extern char*s117_93A;
extern char*s33_94A;
extern char*s104_916596A;
extern char*s825_2008215484A;
extern char*s729_152877053A;
extern char*s113_99A;
extern char*s848_101A;
extern char*s283_376816512A;
extern char*s113_273430505A;
extern char*s30_104A;
extern char*s642_105A;
extern char*s101_283093730A;
extern char*s113_109A;
extern char*s447_178490A;
extern char*s33_112335826A;
extern char*s117_114A;
extern char*s97_772983982A;
extern char*s702_115A;
extern char*s577_1399364920A;
extern char*s30_118A;
extern char*s495_123A;
extern char*s33_124A;
extern char*s729_125A;
extern char*s33_126A;
extern char*s117_273430530A;
extern char*s117_391886489A;
extern char*s554_876265439A;
extern char*s727_6284A;
extern char*s377_1485085274A;
extern char*s117_545126362A;
extern char*s409_1089483711A;
extern char*s647_579867211A;
extern char*s104_629850238A;
extern char*s117_1629400044A;
extern char*s33_80109A;
extern char*s642_252339A;
extern char*s120_612971904A;
extern char*s447_202915491A;
extern char*s407_446205995A;
extern char*s642_6305A;
extern char*s104_280897875A;
extern char*s415_1324593410A;
extern char*s34_1473988901A;
extern char*s583_168A;
extern char*s435_145102259A;
extern char*s104_339436953A;
extern char*s113_539873441A;
extern char*s467_1876110531A;
extern char*s650_51065777A;
extern char*s104_470853074A;
extern char*s702_1257264577A;
extern char*s582_6330A;
extern char*s113_180A;
extern char*s33_961210799A;
extern char*s117_116813823A;
extern char*s117_30942A;
extern char*s117_37095A;
extern char*s844_61699A;
extern char*s33_269315573A;
extern char*s34_436911A;
extern char*s642_1341914655A;
extern char*s105_1604340919A;
extern char*s283_1341859296A;
extern char*s104_194A;
extern char*s660_42706587A;
extern char*s111_195A;
extern char*s117_475921520A;
extern char*s365_788380019A;
extern char*s624_619030689A;
extern char*s293_200A;
extern char*s642_117385886A;
extern char*s729_786221024A;
extern char*s117_6355A;
extern char*s728_1409981632A;
extern char*s117_204A;
extern char*s640_205A;
extern char*s844_85966583A;
extern char*s110_580488532A;
extern char*s848_212314278A;
extern char*s104_639285944A;
extern char*s427_1085830094A;
extern char*s111_215A;
extern char*s395_905138318A;
extern char*s283_216A;
extern char*s342_2070057757A;
extern char*s33_217A;
extern char*s488_218A;
extern char*s33_218A;
extern char*s647_160146A;
extern char*s117_993675817A;
extern char*s33_220A;
extern char*s104_873294598A;
extern char*s33_54688766A;
extern char*s647_4638080A;
extern char*s640_226A;
extern char*s104_1922692108A;
extern char*s117_227A;
extern char*s283_1302880443A;
extern char*s342_1306325004A;
extern char*s117_585944489A;
extern char*s639_230A;
extern char*s433_230A;
extern char*s642_236A;
extern char*s623_237A;
extern char*s117_240A;
extern char*s113_240A;
extern char*s111_241A;
extern char*s33_241A;
extern char*s554_242A;
extern char*s640_36137368A;
extern char*s844_6395A;
extern char*s621_244A;
extern char*s117_245A;
extern char*s727_246A;
extern char*s625_247A;
extern char*s33_1682815431A;
extern char*s117_249A;
extern char*s117_251A;
extern char*s104_251A;
extern char*s293_252A;
extern char*s625_254A;
extern char*s647_255A;
extern char*s589_255A;
extern char*s111_542094038A;
extern char*s619_257A;
extern char*s117_257A;
extern char*s117_258A;
extern char*s625_259A;
extern char*s642_259A;
extern char*s727_6411A;
extern char*s111_262A;
extern char*s34_10703002A;
extern char*s117_1312728230A;
extern char*s640_263A;
extern char*s642_264A;
extern char*s647_265A;
extern char*s647_1665734122A;
extern char*s640_184795A;
extern char*s625_436987A;
extern char*s456_1428348580A;
extern char*s293_43325A;
extern char*s113_270A;
extern char*s415_190952A;
extern char*s435_271A;
extern char*s117_272A;
extern char*s647_6425A;
extern char*s640_1097836905A;
extern char*s105_116346440A;
extern char*s117_1017947719A;
extern char*s565_276A;
extern char*s117_277A;
extern char*s117_277C;
extern char*s117_277B;
extern char*s825_277A;
extern char*s386_278A;
extern char*s111_1255776138A;
extern char*s111_1131876546A;
extern char*s117_282A;
extern char*s33_282A;
extern char*s117_284B;
extern char*s117_284A;
extern char*s543_287A;
extern char*s625_287A;
extern char*s848_1854022405A;
extern char*s543_80251A;
extern char*s653_293A;
extern char*s653_294A;
extern char*s495_594795843A;
extern char*s653_295A;
extern char*s647_296A;
extern char*s33_296A;
extern char*s113_297A;
extern char*s642_244699380A;
extern char*s113_298A;
extern char*s447_299A;
extern char*s293_300A;
extern char*s113_301A;
extern char*s904_302A;
extern char*s117_6455A;
extern char*s495_305A;
extern char*s117_1754886761A;
extern char*s33_430881A;
extern char*s117_317A;
extern char*s33_406284A;
extern char*s33_42134669A;
extern char*s436_325449730A;
extern char*s117_1238750212A;
extern char*s104_1088075316A;
extern char*s289_90592250A;
extern char*s283_322A;
extern char*s729_35343969A;
extern char*s801_324A;
extern char*s113_326A;
extern char*s625_327A;
extern char*s647_197159A;
extern char*s113_327A;
extern char*s367_327A;
extern char*s32_329A;
extern char*s589_1710309A;
extern char*s32_331A;
extern char*s117_10739979A;
extern char*s625_815493762A;
extern char*s113_333A;
extern char*s113_334A;
extern char*s32_334A;
extern char*s120_107193812A;
extern char*s35_336A;
extern char*s583_142931125A;
extern char*s113_340A;
extern char*s113_341A;
extern char*s554_342A;
extern char*s640_345A;
extern char*s33_1501191A;
extern char*s489_348A;
extern char*s34_437070A;
extern char*s765_351A;
extern char*s117_1243560324A;
extern char*s122_1568216255A;
extern char*s111_36611104A;
extern char*s33_1578334651A;
extern char*s678_301503927A;
extern char*s538_360A;
extern char*s386_360A;
extern char*s33_361A;
extern char*s420_1136256141A;
extern char*s488_2140868216A;
extern char*s728_8033571A;
extern char*s642_366A;
extern char*s105_1700247488A;
extern char*s33_371A;
extern char*s538_372A;
extern char*s625_376A;
extern char*s467_1223342011A;
extern char*s409_376A;
extern char*s848_377A;
extern char*s848_166455A;
extern char*s117_379A;
extern char*s506_2054176037A;
extern char*s33_548214405A;
extern char*s481_898426A;
extern char*s113_1561265653A;
extern char*s117_175857472A;
extern char*s117_382A;
extern char*s104_1761000927A;
extern char*s582_6534A;
extern char*s624_197373672A;
extern char*s113_62728285A;
extern char*s33_10377126A;
extern char*s640_1639500234A;
extern char*s117_396A;
extern char*s125_397A;
extern char*s729_6550A;
extern char*s115_402A;
extern char*s625_2054563574A;
extern char*s412_1442631340A;
extern char*s34_9909665A;
extern char*s117_6559A;
extern char*s848_1748680500A;
extern char*s104_1011636926A;
extern char*s625_1484470448A;
extern char*s729_411A;
extern char*s625_1212159A;
extern char*s104_1733505988A;
extern char*s117_1601653158A;
extern char*s647_419A;
extern char*s367_892535123A;
extern char*s117_1957408550A;
extern char*s117_781060556A;
extern char*s117_726728775A;
extern char*s436_1604599495A;
extern char*s420_343527626A;
extern char*s105_74239A;
extern char*s729_6580A;
extern char*s393_1808265259A;
extern char*s619_86545A;
extern char*s447_205111678A;
extern char*s105_696478167A;
extern char*s648_82239308A;
extern char*s467_1604408825A;
extern char*s286_38905513A;
extern char*s660_1447552176A;
extern char*s33_1603529235A;
extern char*s101_313227818A;
extern char*s848_526175446A;
extern char*s33_80416A;
extern char*s117_1793244543A;
extern char*s648_1395477828A;
extern char*s844_733445699A;
extern char*s33_878996813A;
extern char*s111_408537579A;
extern char*s117_10666295A;
extern char*s117_339308075A;
extern char*s415_1297676933A;
extern char*s848_6614A;
extern char*s342_1489034545A;
extern char*s904_1935504882A;
extern char*s117_471A;
extern char*s653_471A;
extern char*s678_1084920002A;
extern char*s653_474A;
extern char*s437_1240817101A;
extern char*s653_476A;
extern char*s113_1192507148A;
extern char*s33_1639475718A;
extern char*s648_529853775A;
extern char*s675_1937147216A;
extern char*s111_1459577427A;
extern char*s447_397816412A;
extern char*s113_1721407046A;
extern char*s489_1577658176A;
extern char*s625_283801480A;
extern char*s660_1655357614A;
extern char*s104_1363289683A;
extern char*s117_548663546A;
extern char*s811_498A;
extern char*s352_1155816456A;
extern char*s34_2073386A;
extern char*s104_2117894368A;
extern char*s582_6655A;
extern char*s352_1753601396A;
extern char*s30_613587359A;
extern char*s640_506A;
extern char*s582_215791A;
extern char*s642_1181502A;
extern char*s844_1544707291A;
extern char*s104_1524784203A;
extern char*s904_1942892277A;
extern char*s117_365905049A;
extern char*s728_1970645590A;
extern char*s484_334725631A;
extern char*s805_1000694404A;
extern char*s728_722650754A;
extern char*s727_6671A;
extern char*s349_25373399A;
extern char*s117_526A;
extern char*s728_1477636806A;
extern char*s642_1084495643A;
extern char*s415_889865702A;
extern char*s33_534A;
extern char*s647_535A;
extern char*s113_6687A;
extern char*s510_2057854492A;
extern char*s117_932172292A;
extern char*s104_955638361A;
extern char*s33_548A;
extern char*s104_9897510A;
extern char*s34_10315778A;
extern char*s126_605800239A;
extern char*s33_552A;
extern char*s117_12855A;
extern char*s488_1490203324A;
extern char*s637_6706A;
extern char*s104_2030568676A;
extern char*s117_1901889757A;
extern char*s124_557A;
extern char*s848_25822456A;
extern char*s709_559A;
extern char*s104_1471861047A;
extern char*s642_550508910A;
extern char*s34_1532343833A;
extern char*s805_68224A;
extern char*s381_1744510279A;
extern char*s293_22396357A;
extern char*s640_570A;
extern char*s127_570A;
extern char*s642_1832703325A;
extern char*s34_54418471A;
extern char*s104_1228072329A;
extern char*s117_1988895671A;
extern char*s117_273430980A;
extern char*s589_166654A;
extern char*s283_1476966395A;
extern char*s117_1290234339A;
extern char*s104_1961160815A;
extern char*s412_1037594318A;
extern char*s104_751585121A;
extern char*s34_2233396A;
extern char*s727_273418685A;
extern char*s30_1724187394A;
extern char*s34_48390502A;
extern char*s108_589A;
extern char*s653_591A;
extern char*s113_2077353217A;
extern char*s283_2132072515A;
extern char*s35_594A;
extern char*s848_596A;
extern char*s33_9713026A;
extern char*s33_36193081A;
extern char*s530_2080244194A;
extern char*s34_600A;
extern char*s105_1317175740A;
extern char*s113_1398953286A;
extern char*s111_1463938603A;
extern char*s115_603A;
extern char*s848_604A;
extern char*s848_6755A;
extern char*s104_1207921682A;
extern char*s111_801894175A;
extern char*s104_437331A;
extern char*s420_1260488135A;
extern char*s104_611A;
extern char*s33_548331507A;
extern char*s113_614A;
extern char*s729_185146A;
extern char*s117_1419097826A;
extern char*s111_427937988A;
extern char*s113_179868158A;
extern char*s647_475042348A;
extern char*s447_620A;
extern char*s625_68284A;
extern char*s642_6775A;
extern char*s625_5395051A;
extern char*s117_625A;
extern char*s506_625A;
extern char*s117_5395053A;
extern char*s34_627A;
extern char*s642_693716559A;
extern char*s126_354654986A;
extern char*s33_51915068A;
extern char*s120_1661847054A;
extern char*s105_85511833A;
extern char*s640_1367878466A;
extern char*s117_811016135A;
extern char*s117_635A;
extern char*s33_636A;
extern char*s100_1861287086A;
extern char*s490_449661A;
extern char*s34_640A;
extern char*s642_2251910A;
extern char*s637_5395074A;
extern char*s111_1174466439A;
extern char*s117_651A;
extern char*s34_1690381566A;
extern char*s728_12955A;
extern char*s729_19622345A;
extern char*s33_1744399653A;
extern char*s647_6810A;
extern char*s108_660A;
extern char*s283_661A;
extern char*s110_97543221A;
extern char*s637_4570857A;
extern char*s642_1175100011A;
extern char*s33_669A;
extern char*s647_670A;
extern char*s34_670A;
extern char*s111_671A;
extern char*s30_525197655A;
extern char*s414_925886099A;
extern char*s647_351281A;
extern char*s115_674A;
extern char*s104_1135641353A;
extern char*s113_676A;
extern char*s104_1284231066A;
extern char*s660_378711602A;
extern char*s113_1087245292A;
extern char*s91_685A;
extern char*s113_686A;
extern char*s113_689A;
extern char*s117_1713607783A;
extern char*s625_6845A;
extern char*s729_1824264277A;
extern char*s582_905827712A;
extern char*s846_699A;
extern char*s622_619166512A;
extern char*s625_228498053A;
extern char*s289_875060418A;
extern char*s647_1375807179A;
extern char*s33_1115958189A;
extern char*s33_1206543966A;
extern char*s637_4570907A;
extern char*s29_1325879523A;
extern char*s104_316863332A;
extern char*s660_1197649626A;
extern char*s552_1899804731A;
extern char*s625_10937200A;
extern char*s117_6877A;
extern char*s115_13028A;
extern char*s117_1403825006A;
extern char*s33_80694A;
extern char*s589_1290234494A;
extern char*s502_1767084619A;
extern char*s106_1385667261A;
extern char*s33_849712179A;
extern char*s637_4570932A;
extern char*s292_740A;
extern char*s554_1114764925A;
extern char*s642_744A;
extern char*s115_1772235A;
extern char*s625_750A;
extern char*s642_1261705A;
extern char*s711_1601130656A;
extern char*s111_1460051321A;
extern char*s283_527202963A;
extern char*s117_1195084695A;
extern char*s577_2007779419A;
extern char*s415_613384625A;
extern char*s104_1928025553A;
extern char*s113_643573734A;
extern char*s495_589832448A;
extern char*s729_40031469A;
extern char*s848_10937240A;
extern char*s113_1255020047A;
extern char*s637_4570957A;
extern char*s506_1091323489A;
extern char*s648_68406039A;
extern char*s552_1280946519A;
extern char*s848_5161461A;
extern char*s642_644847010A;
extern char*s33_567319806A;
extern char*s642_1124563501A;
extern char*s118_6926A;
extern char*s115_51699930A;
extern char*s409_7867907A;
extern char*s33_1597390874A;
extern char*s33_567319812A;
extern char*s117_7720290A;
extern char*s648_1034063848A;
extern char*s637_4570982A;
extern char*s122_899910547A;
extern char*s848_2092663259A;
extern char*s647_6946A;
extern char*s117_1994813154A;
extern char*s33_567319829A;
extern char*s117_220957020A;
extern char*s647_1738839292A;
extern char*s436_282823780A;
extern char*s647_1824713404A;
extern char*s33_9676326A;
extern char*s625_80771A;
extern char*s283_1091711046A;
extern char*s647_6965A;
extern char*s637_4571007A;
extern char*s650_8046326A;
extern char*s621_1710532409A;
extern char*s33_1671553525A;
extern char*s117_1981256377A;
extern char*s113_10937305A;
extern char*s625_173055A;
extern char*s490_55156846A;
extern char*s552_958892525A;
extern char*s104_52979396A;
extern char*s517_1083118122A;
extern char*s642_400650A;
extern char*s642_86950A;
extern char*s34_400652A;
extern char*s647_427390771A;
extern char*s283_1707020207A;
extern char*s637_4571032A;
extern char*s625_345908476A;
extern char*s647_6995A;
extern char*s97_142319A;
extern char*s34_11251026A;
extern char*s436_170383550A;
extern char*s113_373286592A;
extern char*s104_1275558331A;
extern char*s117_1860992059A;
extern char*s637_4571057A;
extern char*s104_888875725A;
extern char*s848_1648235130A;
extern char*s283_902457136A;
extern char*s33_1498845794A;
extern char*s488_1331532446A;
extern char*s412_1769582063A;
extern char*s647_7025A;
extern char*s844_719514099A;
extern char*s848_1288623074A;
extern char*s505_672729595A;
extern char*s850_730579755A;
extern char*s283_1130154866A;
extern char*s415_923532A;
extern char*s904_7037A;
extern char*s111_1814748872A;
extern char*s349_345225764A;
extern char*s642_1291760099A;
extern char*s33_80854A;
extern char*s33_13194A;
extern char*s286_1820580025A;
extern char*s647_1689502217A;
extern char*s637_185428A;
extern char*s640_686612424A;
extern char*s34_10193105A;
extern char*s32_831708366A;
extern char*s33_10377643A;
extern char*s637_185438A;
extern char*s113_703496930A;
extern char*s850_1295032451A;
extern char*s637_185443A;
extern char*s678_501491947A;
extern char*s637_185448A;
extern char*s111_1786429697A;
extern char*s637_185453A;
extern char*s415_1552156565A;
extern char*s34_1975394A;
extern char*s33_1594034A;
extern char*s104_75996531A;
extern char*s33_2246041A;
extern char*s637_185458A;
extern char*s848_1012357115A;
extern char*s117_1065055A;
extern char*s111_1497652563A;
extern char*s728_323156020A;
extern char*s637_185463A;
extern char*s282_51017327A;
extern char*s117_934A;
extern char*s111_24235874A;
extern char*s383_1809213019A;
extern char*s467_1284372793A;
extern char*s482_1204053035A;
extern char*s34_1839765037A;
extern char*s637_185468A;
extern char*s113_830570470A;
extern char*s589_481249030A;
extern char*s763_495673125A;
extern char*s120_1752297822A;
extern char*s117_1642367158A;
extern char*s117_273431355A;
extern char*s283_708319A;
extern char*s126_7106A;
extern char*s728_15009395A;
extern char*s848_915251302A;
extern char*s111_902457224A;
extern char*s439_171706123A;
extern char*s113_50863580A;
extern char*s729_2046881533A;
extern char*s482_1204053060A;
extern char*s554_1747846A;
extern char*s642_7118A;
extern char*s33_1607595572A;
extern char*s660_557767498A;
extern char*s34_1992063831A;
extern char*s516_1962243783A;
extern char*s729_207160501A;
extern char*s650_124454155A;
extern char*s495_1496963692A;
extern char*s642_54714119A;
extern char*s647_87090A;
extern char*s117_1586448448A;
extern char*s848_77282146A;
extern char*s647_185515A;
extern char*s456_540477054A;
extern char*s86_1761241425A;
extern char*s121_992A;
extern char*s117_1500500537A;
extern char*s506_259431724A;
extern char*s104_1587734026A;
extern char*s844_903312259A;
extern char*s844_167080A;
extern char*s848_160930A;
extern char*s104_1703575813A;
extern char*s589_948263A;
extern char*s650_160937A;
extern char*s283_89867121A;
extern char*s415_205616643A;
extern char*s117_514187710A;
extern char*s460_1615634978A;
extern char*s104_2080029331A;
extern char*s104_266191698A;
extern char*s113_851047233A;
extern char*s117_1346694814A;
extern char*s111_1365578385A;
extern char*s104_1090616383A;
extern char*s117_308580A;
extern char*s689_247541875A;
extern char*s467_1436450217A;
extern char*s111_713806135A;
extern char*s358_646901709A;
extern char*s104_1581435442A;
extern char*s480_743946038A;
extern char*s848_1413869902A;
extern char*s706_1043A;
extern char*s411_736853937A;
extern char*s467_69279758A;
extern char*s113_17494489A;
extern char*s707_1047A;
extern char*s647_397220332A;
extern char*s293_7207A;
extern char*s34_10876026A;
extern char*s117_437780A;
extern char*s848_1473891377A;
extern char*s104_1380562254A;
extern char*s660_1092806174A;
extern char*s423_1719402393A;
extern char*s110_23085765A;
extern char*s729_1102979933A;
extern char*s848_1927410765A;
extern char*s848_1574324912A;
extern char*s35_87180A;
extern char*s97_439490016A;
extern char*s111_385188989A;
extern char*s104_1934613587A;
extern char*s117_965818786A;
extern char*s640_7220A;
extern char*s493_68732A;
extern char*s117_1905187208A;
extern char*s117_4620481A;
extern char*s498_7232A;
extern char*s642_7235A;
extern char*s467_1305581590A;
extern char*s415_156630152A;
extern char*s30_1090A;
extern char*s729_1102979958A;
extern char*s554_1027113524A;
extern char*s642_1348915394A;
extern char*s117_1901755A;
extern char*s640_580292587A;
extern char*s366_1839715989A;
extern char*s476_99702656A;
extern char*s621_302501127A;
extern char*s467_1630520481A;
extern char*s117_197932A;
extern char*s825_1101A;
extern char*s648_1034107223A;
extern char*s479_1554555636A;
extern char*s104_879341913A;
extern char*s415_1277330071A;
extern char*s117_893005A;
extern char*s848_2136427942A;
extern char*s495_1034900711A;
extern char*s447_1112A;
extern char*s104_1617443474A;
extern char*s117_588411932A;
extern char*s467_1051699101A;
extern char*s538_1330923746A;
extern char*s97_1121A;
extern char*s377_327012886A;
extern char*s104_1717397235A;
extern char*s104_1003875089A;
extern char*s35_2141685A;
extern char*s640_1446625A;
extern char*s358_1759986771A;
extern char*s117_4620546A;
extern char*s117_1055242101A;
extern char*s848_7296A;
extern char*s551_927498134A;
extern char*s729_10322525A;
extern char*s425_1099750743A;
extern char*s291_1133285999A;
extern char*s844_1524126691A;
extern char*s112_1645670452A;
extern char*s33_1157A;
extern char*s341_1981041429A;
extern char*s117_273443870A;
extern char*s619_7317A;
extern char*s117_1350760769A;
extern char*s111_1535001676A;
extern char*s729_419443A;
extern char*s484_1867518592A;
extern char*s113_1964046235A;
extern char*s117_1142598643A;
extern char*s415_905382A;
extern char*s844_1858599648A;
extern char*s283_305465997A;
extern char*s33_1944903A;
extern char*s695_235492225A;
extern char*s33_55040341A;
extern char*s117_1196A;
extern char*s554_28418819A;
extern char*s34_10648581A;
extern char*s394_1552710436A;
extern char*s104_1819737650A;
extern char*s111_1206593669A;
extern char*s17_1210A;
extern char*s35_2246326A;
extern char*s113_1215A;
extern char*s283_767646015A;
extern char*s286_1641573945A;
extern char*s117_1319581398A;
extern char*s33_9529116A;
extern char*s640_11300605A;
extern char*s647_52075585A;
extern char*s126_1430004152A;
extern char*s506_1297302480A;
extern char*s647_1671074150A;
extern char*s415_1324951230A;
extern char*s32_1897129554A;
extern char*s293_188916891A;
extern char*s104_155929078A;
extern char*s111_646243744A;
extern char*s640_1232A;
extern char*s33_276937706A;
extern char*s844_1180476551A;
extern char*s33_1235A;
extern char*s640_1240A;
extern char*s848_407207A;
extern char*s436_1700082283A;
extern char*s647_520388145A;
extern char*s33_55040391A;
extern char*s729_1246A;
extern char*s647_704592146A;
extern char*s33_1247A;
extern char*s647_837784A;
extern char*s625_7400A;
extern char*s479_1377394679A;
extern char*s104_445001496A;
extern char*s393_1088174660A;
extern char*s729_52555395A;
extern char*s30_513843490A;
extern char*s33_55040401A;
extern char*s117_499425548A;
extern char*s293_4479182A;
extern char*s625_1485929081A;
extern char*s728_1208340604A;
extern char*s33_2067995A;
extern char*s647_870841390A;
extern char*s117_1919660703A;
extern char*s111_1265A;
extern char*s117_1271A;
extern char*s625_1271A;
extern char*s97_74133124A;
extern char*s849_1274A;
extern char*s117_148900A;
extern char*s577_38182A;
extern char*s625_182255408A;
extern char*s648_1431664982A;
extern char*s648_1280A;
extern char*s727_1281A;
extern char*s117_1284A;
extern char*s640_1285A;
extern char*s728_1286A;
extern char*s648_1291A;
extern char*s675_1083579905A;
extern char*s117_81256A;
extern char*s117_1295B;
extern char*s117_1295A;
extern char*s642_25900A;
extern char*s640_1298A;
extern char*s447_1642232185A;
extern char*s467_1952642401A;
extern char*s729_666720494A;
extern char*s637_1302A;
extern char*s642_685204250A;
extern char*s638_7454A;
extern char*s637_1312A;
extern char*s729_14757563A;
extern char*s33_259659630A;
extern char*s340_855586967A;
extern char*s34_1988096A;
extern char*s625_7475A;
extern char*s33_747962924A;
extern char*s117_32080A;
extern char*s552_902076231A;
extern char*s117_1326A;
extern char*s378_1686701A;
extern char*s34_945182441A;
extern char*s117_1330A;
extern char*s848_26635163A;
extern char*s33_1245671098A;
extern char*s113_1335A;
extern char*s418_13637A;
extern char*s844_1542419950A;
extern char*s104_2097430832A;
extern char*s105_140920753A;
extern char*s625_37202594A;
extern char*s495_412142950A;
extern char*s436_1304837581A;
extern char*s34_87466A;
extern char*s117_411134193A;
extern char*s289_413151726A;
extern char*s286_1136866084A;
extern char*s650_1068122514A;
extern char*s729_2077255577A;
extern char*s647_116864219A;
extern char*s436_1081673178A;
extern char*s640_1380A;
extern char*s497_869266852A;
extern char*s349_590983311A;
extern char*s121_1382A;
extern char*s104_2001512180A;
extern char*s381_762122588A;
extern char*s283_139303084A;
extern char*s625_2028521226A;
extern char*s291_362867332A;
extern char*s105_996106634A;
extern char*s104_1910692676A;
extern char*s104_1466196812A;
extern char*s844_1043020315A;
extern char*s117_1618833880A;
extern char*s660_1846931416A;
extern char*s283_86060043A;
extern char*s904_1807195960A;
extern char*s577_7557A;
extern char*s416_1127350535A;
extern char*s292_87520A;
extern char*s582_1407A;
extern char*s729_1994331A;
extern char*s728_1582973561A;
extern char*s415_1705796732A;
extern char*s846_1414A;
extern char*s105_181806522A;
extern char*s117_1417A;
extern char*s642_32175A;
extern char*s660_39109479A;
extern char*s104_342864313A;
extern char*s420_1732344459A;
extern char*s104_2110077371A;
extern char*s370_462870327A;
extern char*s33_87541A;
extern char*s33_1427A;
extern char*s126_210310269A;
extern char*s124_489233515A;
extern char*s111_1459510708A;
extern char*s844_1114679499A;
extern char*s729_1028650A;
extern char*s420_1382321814A;
extern char*s648_29107967A;
extern char*s117_1540494783A;
extern char*s113_1438A;
extern char*s642_1241777620A;
extern char*s117_2087300232A;
extern char*s647_1124779458A;
extern char*s30_941571923A;
extern char*s707_1452A;
extern char*s363_1440516445A;
extern char*s127_150325744A;
extern char*s516_90494969A;
extern char*s728_308117350A;
extern char*s283_1689176777A;
extern char*s117_1924772383A;
extern char*s729_1246790712A;
extern char*s488_486705491A;
extern char*s729_530955790A;
extern char*s846_81437A;
extern char*s117_1476A;
extern char*s648_813409A;
extern char*s449_1478A;
extern char*s117_188283590A;
extern char*s637_1481A;
extern char*s642_1307328870A;
extern char*s349_934695142A;
extern char*s117_1273572186A;
extern char*s30_579450289A;
extern char*s104_54634669A;
extern char*s117_1493A;
extern char*s33_1375414302A;
extern char*s104_243230489A;
extern char*s104_1744209811A;
extern char*s729_1770234694A;
extern char*s117_13801A;
extern char*s117_586511651A;
extern char*s713_511703191A;
extern char*s848_479982486A;
extern char*s117_1404852998A;
extern char*s409_35382059A;
extern char*s104_49203356A;
extern char*s117_2142659303A;
extern char*s415_2480364A;
extern char*s352_1514297749A;
extern char*s409_354065377A;
extern char*s120_582925635A;
extern char*s104_2047201942A;
extern char*s104_1909979286A;
extern char*s126_1680762272A;
extern char*s104_1642195503A;
extern char*s33_880412606A;
extern char*s34_2234341A;
extern char*s283_1709309070A;
extern char*s113_1102814319A;
extern char*s647_1530A;
extern char*s844_7682A;
extern char*s104_833080669A;
extern char*s647_1679636650A;
extern char*s490_413651A;
extern char*s848_129037214A;
extern char*s33_279656751A;
extern char*s415_2480394A;
extern char*s104_962885232A;
extern char*s647_4178071A;
extern char*s33_859431564A;
extern char*s117_490869799A;
extern char*s104_791727511A;
extern char*s117_1164920984A;
extern char*s104_2099054905A;
extern char*s678_643795973A;
extern char*s729_1111954737A;
extern char*s34_1957581A;
extern char*s283_1553744164A;
extern char*s117_1565A;
extern char*s647_511943145A;
extern char*s104_2037548A;
extern char*s625_491029751A;
extern char*s848_1111960899A;
extern char*s117_1471782099A;
extern char*s104_955584028A;
extern char*s34_407540A;
extern char*s33_438300A;
extern char*s117_432958168A;
extern char*s356_242535516A;
extern char*s729_1760239413A;
extern char*s727_161521A;
extern char*s642_283285900A;
extern char*s33_1319421852A;
extern char*s117_1661632742A;
extern char*s729_2006740748A;
extern char*s113_485672260A;
extern char*s33_761722990A;
extern char*s495_1319735562A;
extern char*s104_1208507031A;
extern char*s625_1185483839A;
extern char*s728_1370665846A;
extern char*s126_3556890A;
extern char*s105_1038536453A;
extern char*s624_1191155066A;
extern char*s113_2011772281A;
extern char*s33_185934049A;
extern char*s728_1992734941A;
extern char*s641_1625A;
extern char*s113_1626A;
extern char*s415_2480479A;
extern char*s33_185934055A;
extern char*s30_7779A;
extern char*s104_2055333675A;
extern char*s117_1607940692A;
extern char*s117_860532685A;
extern char*s113_2139128753A;
extern char*s729_1783951564A;
extern char*s117_1639A;
extern char*s34_1532344910A;
extern char*s33_619776399A;
extern char*s34_479921113A;
extern char*s488_522818189A;
extern char*s825_1644A;
extern char*s33_185934072A;
extern char*s648_32400A;
extern char*s625_1923813010A;
extern char*s624_1646A;
extern char*s479_2141380032A;
extern char*s104_1254996328A;
extern char*s352_1788472558A;
extern char*s848_687744958A;
extern char*s117_1650A;
extern char*s642_1650A;
extern char*s848_1651A;
extern char*s436_265238926A;
extern char*s113_7809A;
extern char*s642_180037A;
extern char*s619_386149138A;
extern char*s440_123839750A;
extern char*s104_401981819A;
extern char*s117_1164208A;
extern char*s583_1046299075A;
extern char*s729_1676A;
extern char*s33_1326673961A;
extern char*s728_112977096A;
extern char*s647_32435A;
extern char*s848_44739A;
extern char*s467_154976132A;
extern char*s650_57298260A;
extern char*s648_81730033A;
extern char*s637_845936425A;
extern char*s35_1994621A;
extern char*s104_1289042164A;
extern char*s647_32456A;
extern char*s117_1946737844A;
extern char*s117_14005A;
extern char*s117_192841706A;
extern char*s383_1348774A;
extern char*s415_1337425939A;
extern char*s120_1875884480A;
extern char*s554_142089811A;
extern char*s117_7869A;
extern char*s648_1185225610A;
extern char*s728_636642526A;
extern char*s293_2082988666A;
extern char*s113_7878A;
extern char*s642_1727A;
extern char*s425_183516812A;
extern char*s647_1586596820A;
extern char*s648_29126717A;
extern char*s34_14036A;
extern char*s33_55926626A;
extern char*s117_48520827A;
extern char*s642_1060489498A;
extern char*s622_161665A;
extern char*s436_1857191624A;
extern char*s122_1797674551A;
extern char*s113_1744A;
extern char*s126_1758326604A;
extern char*s642_1115076A;
extern char*s642_180128A;
extern char*s104_941240074A;
extern char*s283_608446371A;
extern char*s494_1753A;
extern char*s495_112048371A;
extern char*s89_22612837A;
extern char*s117_1765A;
extern char*s420_176104896A;
extern char*s386_1712194128A;
extern char*s105_256559978A;
extern char*s117_1700132018A;
extern char*s420_1458557644A;
extern char*s97_1052333303A;
extern char*s117_1043020690A;
extern char*s104_1296817101A;
extern char*s113_1775A;
extern char*s29_1128710280A;
extern char*s104_376006259A;
extern char*s117_1364588829A;
extern char*s385_7506001A;
extern char*s117_36778611A;
extern char*s104_970900228A;
extern char*s622_565063403A;
extern char*s467_2108232434A;
extern char*s117_4049151A;
extern char*s904_2108496933A;
extern char*s848_1523807481A;
extern char*s510_920757291A;
extern char*s409_1801A;
extern char*s104_1917483795A;
extern char*s660_1658151484A;
extern char*s117_1630601156A;
extern char*s111_89019087A;
extern char*s34_2185421A;
extern char*s34_251171752A;
extern char*s104_1778077539A;
extern char*s33_312005144A;
extern char*s104_1665385073A;
extern char*s362_1771711260A;
extern char*s554_1826A;
extern char*s127_75639A;
extern char*s495_1832A;
extern char*s647_1651828280A;
extern char*s349_1813679543A;
extern char*s647_1214258443A;
extern char*s647_167916A;
extern char*s647_1840A;
extern char*s647_108351709A;
extern char*s729_869136A;
extern char*s33_94407393A;
extern char*s33_14150A;
extern char*s848_32605A;
extern char*s104_50040236A;
extern char*s729_1697044300A;
extern char*s117_1154403080A;
extern char*s488_1468725331A;
extern char*s117_426087775A;
extern char*s117_57150800A;
extern char*s104_1021024803A;
extern char*s848_47598300A;
extern char*s286_1188332009A;
extern char*s104_603076667A;
extern char*s648_534333098A;
extern char*s848_692075493A;
extern char*s117_107312226A;
extern char*s467_90390825A;
extern char*s729_1992679842A;
extern char*s117_267478119A;
extern char*s35_2191641A;
extern char*s624_565069653A;
extern char*s648_2001063662A;
extern char*s35_822199910A;
extern char*s104_2047202317A;
extern char*s647_32650A;
extern char*s623_2057228449A;
extern char*s624_832280A;
extern char*s117_438660461A;
extern char*s104_502181838A;
extern char*s33_403163040A;
extern char*s117_870017790A;
extern char*s104_307717976A;
extern char*s111_327902A;
extern char*s647_1900A;
extern char*s647_10089540A;
extern char*s104_1938643327A;
extern char*s117_1580612071A;
extern char*s589_1747685533A;
extern char*s33_735034101A;
extern char*s104_376006384A;
extern char*s467_573004463A;
extern char*s33_50778415A;
extern char*s625_505232755A;
extern char*s640_36126743A;
extern char*s117_7918258A;
extern char*s846_413927315A;
extern char*s729_172408303A;
extern char*s729_1994852A;
extern char*s33_1530432238A;
extern char*s647_887295984A;
extern char*s104_2061122069A;
extern char*s104_1933A;
extern char*s583_992810240A;
extern char*s33_88048A;
extern char*s117_950675891A;
extern char*s33_88049A;
extern char*s582_942808765A;
extern char*s104_246527867A;
extern char*s113_69601A;
extern char*s33_55041091A;
extern char*s104_4492176A;
extern char*s625_2111741A;
extern char*s848_27909038A;
extern char*s33_36200588A;
extern char*s583_724183788A;
extern char*s113_683870135A;
extern char*s33_261093457A;
extern char*s650_1962A;
extern char*s495_909851733A;
extern char*s33_1286698901A;
extern char*s104_1505459217A;
extern char*s104_1421116705A;
extern char*s647_9794360A;
extern char*s113_1115301A;
extern char*s126_124992A;
extern char*s625_2072064738A;
extern char*s33_1680885744A;
extern char*s728_1933391A;
extern char*s904_1574596468A;
extern char*s728_1949186219A;
extern char*s650_8131A;
extern char*s117_11086084A;
extern char*s625_4996600A;
extern char*s486_444860A;
extern char*s104_676728857A;
extern char*s34_451011A;
extern char*s33_55041141A;
extern char*s120_1127406485A;
extern char*s111_2029530601A;
extern char*s117_1492394528A;
extern char*s33_55041151A;
extern char*s647_19199275A;
extern char*s126_1711985232A;
extern char*s640_807791A;
extern char*s104_1284361566A;
extern char*s111_1378502623A;
extern char*s412_729510616A;
extern char*s642_28032126A;
extern char*s495_1646704683A;
extern char*s117_1965252672A;
extern char*s640_161951A;
extern char*s286_1281353746A;
extern char*s117_772432310A;
extern char*s286_169314461A;
extern char*s342_971287994A;
extern char*s33_586229245A;
extern char*s647_484454800A;
extern char*s650_1150927957A;
extern char*s848_917774306A;
extern char*s33_1395184171A;
extern char*s647_10089690A;
extern char*s117_1307483215A;
extern char*s111_891552598A;
extern char*s117_1724182721A;
extern char*s647_476433922A;
extern char*s111_1145029170A;
extern char*s377_1970431863A;
extern char*s105_446380143A;
extern char*s117_826425832A;
extern char*s640_21020045A;
extern char*s647_9954400A;
extern char*s35_2028737205A;
extern char*s113_186217457A;
extern char*s647_162010A;
extern char*s117_1656195746A;
extern char*s111_1483967746A;
extern char*s409_1747372019A;
extern char*s640_162019A;
extern char*s647_162020A;
extern char*s625_2095A;
extern char*s650_5279655A;
extern char*s416_1993565801A;
extern char*s117_506210947A;
extern char*s33_1300046706A;
extern char*s33_2104A;
extern char*s648_32860A;
extern char*s648_2110A;
extern char*s648_140263367A;
extern char*s117_32869A;
extern char*s104_2001191A;
extern char*s625_1032053803A;
extern char*s844_788978585A;
extern char*s495_1427483140A;
extern char*s844_546112503A;
extern char*s341_977955761A;
extern char*s34_408086A;
extern char*s117_531983658A;
extern char*s552_1806821466A;
extern char*s34_251916328A;
extern char*s104_1176245553A;
extern char*s97_1781104140A;
extern char*s115_57487A;
extern char*s117_451157A;
extern char*s104_1561427335A;
extern char*s846_321989A;
extern char*s647_8291A;
extern char*s641_8291A;
extern char*s494_2009909053A;
extern char*s647_162070A;
extern char*s34_69805A;
extern char*s506_412149904A;
extern char*s637_2150A;
extern char*s650_1113554587A;
extern char*s117_654499311A;
extern char*s117_10944785A;
extern char*s117_389672A;
extern char*s117_389675A;
extern char*s582_147115629A;
extern char*s848_1927425A;
extern char*s849_14464A;
extern char*s383_202031759A;
extern char*s104_2051403723A;
extern char*s642_162095A;
extern char*s727_2138778683A;
extern char*s286_32926A;
extern char*s647_734603803A;
extern char*s415_900982204A;
extern char*s115_2178A;
extern char*s34_401994A;
extern char*s844_1744880961A;
extern char*s33_2035472654A;
extern char*s844_42739336A;
extern char*s105_2131871127A;
extern char*s904_482960256A;
extern char*s113_69851A;
extern char*s552_1243691337A;
extern char*s117_1826935309A;
extern char*s34_2032026A;
extern char*s647_1726920051A;
extern char*s34_264667428A;
extern char*s117_351488799A;
extern char*s104_4750778A;
extern char*s117_383570A;
extern char*s844_1005223232A;
extern char*s647_1240185282A;
extern char*s34_820292A;
extern char*s120_1585514726A;
extern char*s117_1637927398A;
extern char*s283_698011541A;
extern char*s403_529996976A;
extern char*s120_1297180456A;
extern char*s33_1447702A;
extern char*s113_1255802680A;
extern char*s538_922867504A;
extern char*s34_88336A;
extern char*s104_599810839A;
extern char*s33_451252A;
extern char*s648_376332712A;
extern char*s624_1112927266A;
extern char*s362_206355982A;
extern char*s33_840111968A;
extern char*s495_115013643A;
extern char*s647_234933541A;
extern char*s32_1181006553A;
extern char*s104_1023251859A;
extern char*s764_2114672999A;
extern char*s415_442652821A;
extern char*s111_601041072A;
extern char*s436_797085749A;
extern char*s33_1297432701A;
extern char*s848_5839580A;
extern char*s33_2067759348A;
extern char*s650_1236414794A;
extern char*s625_832670A;
extern char*s650_8436A;
extern char*s447_408035024A;
extern char*s660_1679625106A;
extern char*s340_864187036A;
extern char*s729_1155996628A;
extern char*s33_1209184326A;
extern char*s104_700613496A;
extern char*s647_45355A;
extern char*s120_1041926341A;
extern char*s625_2301A;
extern char*s104_1689577436A;
extern char*s33_1604515261A;
extern char*s647_1096165867A;
extern char*s104_860582570A;
extern char*s554_2003309199A;
extern char*s647_245384155A;
extern char*s117_1816632501A;
extern char*s120_1811139659A;
extern char*s33_728963476A;
extern char*s637_156095A;
extern char*s33_9647090A;
extern char*s729_8475A;
extern char*s848_945011211A;
extern char*s104_28789007A;
extern char*s104_1874765620A;
extern char*s115_395994A;
extern char*s647_8485A;
extern char*s112_546635553A;
extern char*s647_1553763390A;
extern char*s117_20552830A;
extern char*s659_1664721281A;
extern char*s104_1752914319A;
extern char*s104_2020913390A;
extern char*s34_414461A;
extern char*s729_8499A;
extern char*s625_1426099398A;
extern char*s104_156243902A;
extern char*s639_1476205446A;
extern char*s642_1936367907A;
extern char*s283_1955866577A;
extern char*s33_10938831A;
extern char*s659_1025503229A;
extern char*s117_273715710A;
extern char*s461_914877497A;
extern char*s848_1653483427A;
extern char*s904_1384629373A;
extern char*s647_244793715A;
extern char*s379_1360462097A;
extern char*s801_1121854A;
extern char*s349_2084982239A;
extern char*s33_175767198A;
extern char*s660_1238684603A;
extern char*s113_45436A;
extern char*s848_737599544A;
extern char*s117_419316052A;
extern char*s117_2382A;
extern char*s97_1452647150A;
extern char*s117_1898865296A;
extern char*s379_41841490A;
extern char*s113_217674A;
extern char*s117_149822297A;
extern char*s619_1359151955A;
extern char*s619_8545A;
extern char*s656_2394A;
extern char*s117_1965511388A;
extern char*s117_2395A;
extern char*s656_2395A;
extern char*s729_1418601377A;
extern char*s104_1478844272A;
extern char*s104_1223700793A;
extern char*s104_529554293A;
extern char*s293_63912A;
extern char*s104_2117988535A;
extern char*s554_2091317800A;
extern char*s111_2114217978A;
extern char*s729_1327517381A;
extern char*s642_2065182209A;
extern char*s117_1530032908A;
extern char*s412_1222747401A;
extern char*s111_768828206A;
extern char*s283_2070822678A;
extern char*s34_76226A;
extern char*s104_439136A;
extern char*s104_1491933617A;
extern char*s117_2417A;
extern char*s447_146113272A;
extern char*s97_2123229206A;
extern char*s283_763815152A;
extern char*s283_957054969A;
extern char*s501_180503525A;
extern char*s115_2440A;
extern char*s283_556698697A;
extern char*s113_6159594A;
extern char*s844_82948679A;
extern char*s623_199280A;
extern char*s467_1157128572A;
extern char*s728_645592960A;
extern char*s624_1483857391A;
extern char*s647_8779932A;
extern char*s647_168532A;
extern char*s554_1646495986A;
extern char*s650_1956008156A;
extern char*s105_274238642A;
extern char*s33_2090604340A;
extern char*s33_591414963A;
extern char*s118_1753572602A;
extern char*s104_614881029A;
extern char*s621_11381817A;
extern char*s642_48939825A;
extern char*s105_332623945A;
extern char*s624_358648841A;
extern char*s111_1272176911A;
extern char*s415_282345691A;
extern char*s582_1119207694A;
extern char*s729_118716790A;
extern char*s642_48939847A;
extern char*s104_554066118A;
extern char*s104_1439398002A;
extern char*s488_1917908900A;
extern char*s104_1193216533A;
extern char*s642_279959115A;
extern char*s104_277837020A;
extern char*s33_2504A;
extern char*s106_1656731300A;
extern char*s729_49917876A;
extern char*s554_193194A;
extern char*s115_207986277A;
extern char*s104_180894A;
extern char*s844_2075405A;
extern char*s842_125876584A;
extern char*s296_1477688005A;
extern char*s342_1777506207A;
extern char*s290_1933944A;
extern char*s34_402346A;
extern char*s647_33291A;
extern char*s126_2537A;
extern char*s104_761631659A;
extern char*s386_2126200255A;
extern char*s122_584218374A;
extern char*s117_2545A;
extern char*s104_784199689A;
extern char*s625_1575353618A;
extern char*s844_886939850A;
extern char*s589_33316A;
extern char*s33_1223768616A;
extern char*s846_2082029949A;
extern char*s704_2565A;
extern char*s104_1909918820A;
extern char*s660_1711825865A;
extern char*s33_744845610A;
extern char*s729_1637706318A;
extern char*s415_1670460393A;
extern char*s554_64080A;
extern char*s647_2571A;
extern char*s117_10028705A;
extern char*s647_1079001A;
extern char*s625_1489891655A;
extern char*s412_1182157125A;
extern char*s647_37173080A;
extern char*s589_3920780A;
extern char*s115_76405A;
extern char*s120_305596576A;
extern char*s117_1361175839A;
extern char*s283_22915075A;
extern char*s117_218061703A;
extern char*s113_98806116A;
extern char*s117_830104658A;
extern char*s34_82570A;
extern char*s729_411283072A;
extern char*s104_1731250773A;
extern char*s32_1194182360A;
extern char*s104_1564737054A;
extern char*s30_8771A;
extern char*s105_894954671A;
extern char*s583_950159899A;
extern char*s104_2992013A;
extern char*s113_440518794A;
extern char*s117_2630A;
extern char*s29_569105454A;
extern char*s674_2113799934A;
extern char*s34_114085235A;
extern char*s117_1308400309A;
extern char*s648_1773508175A;
extern char*s113_8801A;
extern char*s117_470486490A;
extern char*s647_524787520A;
extern char*s113_530877013A;
extern char*s467_789877170A;
extern char*s104_1098712729A;
extern char*s647_1116064705A;
extern char*s648_1053613605A;
extern char*s582_2670A;
extern char*s117_33425A;
extern char*s381_292944046A;
extern char*s848_1069766146A;
extern char*s33_88795A;
extern char*s825_480414235A;
extern char*s370_1572647306A;
extern char*s850_585110409A;
extern char*s848_8836A;
extern char*s117_1082664800A;
extern char*s807_1309286095A;
extern char*s123_138929174A;
extern char*s647_1263916320A;
extern char*s30_1010347497A;
extern char*s34_2063276A;
extern char*s33_201970776A;
extern char*s34_396356A;
extern char*s647_1023363018A;
extern char*s488_1089314041A;
extern char*s844_1866745094A;
extern char*s33_201970793A;
extern char*s286_2089269822A;
extern char*s33_756809447A;
extern char*s637_23647157A;
extern char*s35_234165132A;
extern char*s33_201970799A;
extern char*s621_15019A;
extern char*s34_479922190A;
extern char*s729_2050807628A;
extern char*s647_15020A;
extern char*s117_33475A;
extern char*s479_1172758533A;
extern char*s660_1912840703A;
extern char*s117_1934139A;
extern char*s349_1646268668A;
extern char*s117_8880A;
extern char*s113_8884A;
extern char*s729_633992455A;
extern char*s647_8885A;
extern char*s552_520647979A;
extern char*s412_112006296A;
extern char*s113_8889A;
extern char*s117_941548611A;
extern char*s729_1637595774A;
extern char*s32_8897A;
extern char*s104_45224899A;
extern char*s112_1359484467A;
extern char*s117_162838175A;
extern char*s33_30191860A;
extern char*s117_2753A;
extern char*s283_1251030042A;
extern char*s648_851596A;
extern char*s117_900404594A;
extern char*s29_1525604536A;
extern char*s33_1673345408A;
extern char*s33_954385774A;
extern char*s117_181146A;
extern char*s293_10926944A;
extern char*s439_1666936074A;
extern char*s648_1034090448A;
extern char*s117_1089314127A;
extern char*s104_1007106012A;
extern char*s415_2004103151A;
extern char*s97_672350142A;
extern char*s728_1517878904A;
extern char*s440_142865912A;
extern char*s484_946986142A;
extern char*s848_236525A;
extern char*s33_827429162A;
extern char*s728_1215237414A;
extern char*s729_444775459A;
extern char*s341_311661671A;
extern char*s117_1140133715A;
extern char*s282_758913190A;
extern char*s844_1020256883A;
extern char*s33_253393261A;
extern char*s117_1040899642A;
extern char*s282_319940936A;
extern char*s34_1509818A;
extern char*s113_8976A;
extern char*s105_1581369567A;
extern char*s104_2137524537A;
extern char*s848_2830A;
extern char*s729_1246644455A;
extern char*s117_1136523103A;
extern char*s115_2833A;
extern char*s436_1529695024A;
extern char*s349_556920526A;
extern char*s447_1026844627A;
extern char*s729_567426438A;
extern char*s113_8991A;
extern char*s647_2217200A;
extern char*s415_1143055473A;
extern char*s113_1331737400A;
extern char*s502_76659A;
extern char*s117_985140858A;
extern char*s283_961330339A;
extern char*s648_177459204A;
extern char*s425_936707889A;
extern char*s120_612334905A;
extern char*s113_1431838787A;
extern char*s104_483077794A;
extern char*s848_52067A;
extern char*s418_1721243342A;
extern char*s117_400297641A;
extern char*s647_4204001A;
extern char*s383_2870A;
extern char*s117_1746979137A;
extern char*s117_1591358844A;
extern char*s33_52347889A;
extern char*s33_76691A;
extern char*s111_1574136045A;
extern char*s340_36115402A;
extern char*s395_527180488A;
extern char*s117_2883A;
extern char*s104_1910823336A;
extern char*s848_618166083A;
extern char*s33_1095772782A;
extern char*s113_218174A;
extern char*s647_907447617A;
extern char*s117_786180653A;
extern char*s844_1871081731A;
extern char*s485_1057882626A;
extern char*s290_15195A;
extern char*s647_9045A;
extern char*s904_712467074A;
extern char*s554_45953A;
extern char*s33_869539012A;
extern char*s625_1728089446A;
extern char*s647_1671063525A;
extern char*s86_522142839A;
extern char*s844_15205A;
extern char*s117_54734511A;
extern char*s660_1691484858A;
extern char*s647_520377520A;
extern char*s33_1574640467A;
extern char*s113_9073A;
extern char*s647_39831A;
extern char*s619_1971245A;
extern char*s342_580435889A;
extern char*s33_48958735A;
extern char*s104_727272566A;
extern char*s106_1377150320A;
extern char*s33_170256464A;
extern char*s104_1953566687A;
extern char*s660_81368369A;
extern char*s296_624587783A;
extern char*s846_1694775670A;
extern char*s125_2947A;
extern char*s650_1614701960A;
extern char*s34_8054609A;
extern char*s113_9107A;
extern char*s729_99483079A;
extern char*s640_101328382A;
extern char*s467_947318471A;
extern char*s729_1230018439A;
extern char*s113_9121A;
extern char*s383_181352A;
extern char*s729_497096041A;
extern char*s904_387651299A;
extern char*s647_2118444283A;
extern char*s117_9130A;
extern char*s810_1182938696A;
extern char*s113_2109537640A;
extern char*s32_2057783129A;
extern char*s648_1213355397A;
extern char*s625_759184012A;
extern char*s117_374291339A;
extern char*s117_712350300A;
extern char*s113_415107A;
extern char*s104_1775667520A;
extern char*s729_679909928A;
extern char*s647_2996A;
extern char*s848_998144220A;
extern char*s117_1582839830A;
extern char*s33_180965424A;
extern char*s383_732402575A;
extern char*s650_3006A;
extern char*s33_180965430A;
extern char*s728_1110320023A;
extern char*s383_44462444A;
extern char*s117_1540564023A;
extern char*s117_1281004126A;
extern char*s117_1450568746A;
extern char*s104_188494264A;
extern char*s33_11001014A;
extern char*s33_180965447A;
extern char*s104_167445550A;
extern char*s904_698701270A;
extern char*s33_10945665A;
extern char*s117_3040A;
extern char*s582_1757386798A;
extern char*s105_1708886163A;
extern char*s293_1661812564A;
extern char*s283_2028436769A;
extern char*s117_15351A;
extern char*s660_214672950A;
extern char*s33_2174354A;
extern char*s625_1111279623A;
extern char*s660_1961403182A;
extern char*s650_2117730851A;
extern char*s290_15370A;
extern char*s120_69115705A;
extern char*s113_9220A;
extern char*s115_3069A;
extern char*s289_1492303331A;
extern char*s113_9222A;
extern char*s104_723705127A;
extern char*s120_1008693261A;
extern char*s283_3073A;
extern char*s33_3075A;
extern char*s104_1922694958A;
extern char*s120_840703310A;
extern char*s34_3085A;
extern char*s640_101328511A;
extern char*s34_51843716A;
extern char*s117_1145546877A;
extern char*s409_1896547075A;
extern char*s488_1014770470A;
extern char*s113_3094A;
extern char*s625_1125599189A;
extern char*s30_546820847A;
extern char*s115_1663868A;
extern char*s35_89216A;
extern char*s650_138425A;
extern char*s624_15405A;
extern char*s486_384465A;
extern char*s105_1923039443A;
extern char*s467_958494983A;
extern char*s729_1197879602A;
extern char*s554_1213220196A;
extern char*s33_1856946950A;
extern char*s33_39154229A;
extern char*s126_3115A;
extern char*s104_370754643A;
extern char*s104_188014584A;
extern char*s117_1935236890A;
extern char*s111_1066764899A;
extern char*s848_33875A;
extern char*s104_1502870799A;
extern char*s117_1737592965A;
extern char*s104_144939139A;
extern char*s104_1409701608A;
extern char*s104_1550836304A;
extern char*s358_1186844731A;
extern char*s386_30745830A;
extern char*s436_1134247532A;
extern char*s117_375072661A;
extern char*s844_1278999019A;
extern char*s767_849265556A;
extern char*s111_298390A;
extern char*s104_734506354A;
extern char*s113_721564652A;
extern char*s33_15448A;
extern char*s391_3147A;
extern char*s625_26975282A;
extern char*s104_822318035A;
extern char*s117_756717624A;
extern char*s33_207673214A;
extern char*s117_2057758694A;
extern char*s104_1926379486A;
extern char*s659_1901947715A;
extern char*s625_26975293A;
extern char*s499_1329824754A;
extern char*s283_2040665077A;
extern char*s117_1811657197A;
extern char*s115_3169A;
extern char*s33_207673231A;
extern char*s728_26975309A;
extern char*s642_3175A;
extern char*s35_2248290A;
extern char*s34_3175A;
extern char*s647_653639191A;
extern char*s120_938738041A;
extern char*s848_884381655A;
extern char*s729_3181A;
extern char*s727_146599966A;
extern char*s729_156962A;
extern char*s705_46245A;
extern char*s105_1452518781A;
extern char*s111_689013605A;
extern char*s283_1389956963A;
extern char*s117_36460172A;
extern char*s33_7095298A;
extern char*s490_3196A;
extern char*s117_323348966A;
extern char*s117_2101369329A;
extern char*s33_280482649A;
extern char*s104_279996728A;
extern char*s648_3209A;
extern char*s647_802840A;
extern char*s647_1679626025A;
extern char*s625_3212A;
extern char*s499_2088401A;
extern char*s642_602573626A;
extern char*s352_97896378A;
extern char*s111_633144097A;
extern char*s33_1753751730A;
extern char*s113_9366A;
extern char*s104_1898638542A;
extern char*s104_1460213717A;
extern char*s105_92397395A;
extern char*s647_1278500877A;
extern char*s640_7224500A;
extern char*s647_15533A;
extern char*s104_1452100558A;
extern char*s104_850458948A;
extern char*s33_421505A;
extern char*s377_336696676A;
extern char*s763_2068836731A;
extern char*s104_1389575653A;
extern char*s495_1088102843A;
extern char*s642_4179775A;
extern char*s120_2035830473A;
extern char*s104_638895319A;
extern char*s640_40427625A;
extern char*s342_770157670A;
extern char*s843_80501401A;
extern char*s424_835850355A;
extern char*s111_498062040A;
extern char*s552_651043570A;
extern char*s625_1610470399A;
extern char*s848_834589410A;
extern char*s625_46337A;
extern char*s283_1811847991A;
extern char*s117_660780608A;
extern char*s33_7704337A;
extern char*s117_15589A;
extern char*s647_1206509635A;
extern char*s113_3291A;
extern char*s113_1346168095A;
extern char*s117_46350A;
extern char*s33_33120277A;
extern char*s729_38305571A;
extern char*s113_3294A;
extern char*s111_1255397791A;
extern char*s117_616198177A;
extern char*s848_40205A;
extern char*s111_1928938448A;
extern char*s349_70962A;
extern char*s117_960414291A;
extern char*s126_1072344038A;
extern char*s101_15605A;
extern char*s475_1990220866A;
extern char*s104_1725672511A;
extern char*s117_2115332211A;
extern char*s125_287218105A;
extern char*s104_2008366323A;
extern char*s111_1896793334A;
extern char*s647_83277A;
extern char*s848_1316551052A;
extern char*s286_1897894366A;
extern char*s489_1810101146A;
extern char*s113_3320A;
extern char*s415_276773717A;
extern char*s483_1050501857A;
extern char*s647_104084395A;
extern char*s583_13424808A;
extern char*s640_15629A;
extern char*s370_83290A;
extern char*s489_34086A;
extern char*s648_105695965A;
extern char*s660_58505493A;
extern char*s104_147793411A;
extern char*s34_1223234252A;
extern char*s467_221949868A;
extern char*s383_3337A;
extern char*s844_835204573A;
extern char*s104_1297544492A;
extern char*s117_1125599439A;
extern char*s729_259021955A;
extern char*s589_1500847347A;
extern char*s113_150382995A;
extern char*s291_360205908A;
extern char*s104_1710947057A;
extern char*s386_1731781A;
extern char*s104_760340765A;
extern char*s381_376260024A;
extern char*s117_562506158A;
extern char*s767_1398420907A;
extern char*s648_129654140A;
extern char*s764_89481A;
extern char*s117_511465169A;
extern char*s377_240593583A;
extern char*s377_611824887A;
extern char*s625_3374A;
extern char*s495_192265186A;
extern char*s647_83345A;
extern char*s30_1102047298A;
extern char*s104_1109293176A;
extern char*s111_292482A;
extern char*s33_698215697A;
extern char*s111_763853019A;
extern char*s642_23451005A;
extern char*s117_3393A;
extern char*s104_883016350A;
extern char*s420_739187517A;
extern char*s117_693319512A;
extern char*s33_89510A;
extern char*s33_1297876698A;
extern char*s117_42279221A;
extern char*s104_1390190909A;
extern char*s642_2024156039A;
extern char*s648_1062582514A;
extern char*s283_1977886A;
extern char*s34_3415A;
extern char*s678_22122412A;
extern char*s624_480740974A;
extern char*s115_15721A;
extern char*s33_3421A;
extern char*s117_5164112A;
extern char*s647_1338608648A;
extern char*s844_1808489692A;
extern char*s117_3430A;
extern char*s642_169510A;
extern char*s117_1855175789A;
extern char*s104_1166362205A;
extern char*s113_759424351A;
extern char*s104_2060176323A;
extern char*s490_83406A;
extern char*s33_15751A;
extern char*s108_1449185201A;
extern char*s111_3451A;
extern char*s117_2123070311A;
extern char*s848_1242450095A;
extern char*s104_239621812A;
extern char*s117_3457A;
extern char*s289_1534075159A;
extern char*s412_362752532A;
extern char*s356_1742784741A;
extern char*s377_1485100899A;
extern char*s104_95110222A;
extern char*s33_3460A;
extern char*s729_1203674198A;
extern char*s113_1067454155A;
extern char*s848_46525A;
extern char*s33_3472A;
extern char*s113_270309168A;
extern char*s33_3474A;
extern char*s117_3475A;
extern char*s117_2038260346A;
extern char*s904_10220290A;
extern char*s113_423056960A;
extern char*s640_3485A;
extern char*s113_592781506A;
extern char*s647_1821634438A;
extern char*s637_22854451A;
extern char*s117_120095614A;
extern char*s33_1418282620A;
extern char*s625_20240284A;
extern char*s115_3494A;
extern char*s117_325655889A;
extern char*s490_3496A;
extern char*s383_1317154036A;
extern char*s416_176211197A;
extern char*s377_1984383762A;
extern char*s33_3501A;
extern char*s104_46597328A;
extern char*s104_1631593164A;
extern char*s848_1173325215A;
extern char*s122_253892190A;
extern char*s497_1387816739A;
extern char*s849_136857117A;
extern char*s624_1199805276A;
extern char*s416_256961544A;
extern char*s120_1129671576A;
extern char*s91_3520A;
extern char*s113_15828A;
extern char*s848_1058430701A;
extern char*s117_1728206941A;
extern char*s117_333756789A;
extern char*s33_15831A;
extern char*s33_1947246A;
extern char*s29_1767481079A;
extern char*s111_1225577982A;
extern char*s104_1522646678A;
extern char*s33_1947251A;
extern char*s729_1713875121A;
extern char*s34_77350A;
extern char*s117_1571473322A;
extern char*s439_1379248421A;
extern char*s104_201048978A;
extern char*s805_789213750A;
extern char*s33_3545A;
extern char*s849_692716864A;
extern char*s640_4622950A;
extern char*s650_646768902A;
extern char*s708_1499315956A;
extern char*s91_1462938943A;
extern char*s577_3557A;
extern char*s117_1965730A;
extern char*s105_176469602A;
extern char*s283_2100317873A;
extern char*s104_3567A;
extern char*s625_9720A;
extern char*s843_936093505A;
extern char*s765_858562A;
extern char*s640_23186700A;
extern char*s727_28273584A;
extern char*s117_357794960A;
extern char*s104_161325869A;
extern char*s647_304601115A;
extern char*s729_9980517A;
extern char*s34_3595A;
extern char*s848_1645106999A;
extern char*s489_852437A;
extern char*s117_77412A;
extern char*s34_3601A;
extern char*s97_1229059519A;
extern char*s117_726227573A;
extern char*s117_434116584A;
extern char*s729_15915A;
extern char*s104_1061217192A;
extern char*s126_1342164121A;
extern char*s727_1193180751A;
extern char*s95_1554312113A;
extern char*s848_239388241A;
extern char*s625_9775A;
extern char*s33_279523519A;
extern char*s283_551231644A;
extern char*s97_620670284A;
extern char*s552_965507650A;
extern char*s904_1676707A;
extern char*s117_1065652086A;
extern char*s846_882069342A;
extern char*s729_1549077634A;
extern char*s642_206626A;
extern char*s554_1015749028A;
extern char*s283_3645A;
extern char*s649_54686040A;
extern char*s30_1009954795A;
extern char*s728_1527912055A;
extern char*s117_1723513855A;
extern char*s34_89771A;
extern char*s729_961294240A;
extern char*s111_2106290588A;
extern char*s104_1522646803A;
extern char*s33_577213499A;
extern char*s467_82722309A;
extern char*s104_375534514A;
extern char*s33_3669A;
extern char*s659_1750246116A;
extern char*s624_1199620901A;
extern char*s506_79148593A;
extern char*s33_911175911A;
extern char*s642_1631421108A;
extern char*s904_28287A;
extern char*s647_755813960A;
extern char*s33_169371474A;
extern char*s104_57337161A;
extern char*s291_1539722017A;
extern char*s34_16001A;
extern char*s126_852938266A;
extern char*s117_395316170A;
extern char*s33_1947419A;
extern char*s117_1565125654A;
extern char*s462_1087076085A;
extern char*s420_581709925A;
extern char*s362_1687352176A;
extern char*s729_89821A;
extern char*s117_1773201687A;
extern char*s97_1914699291A;
extern char*s120_429361964A;
extern char*s104_1453066751A;
extern char*s117_56845112A;
extern char*s435_1288915017A;
extern char*s415_1469170081A;
extern char*s825_1635136368A;
extern char*s34_937397683A;
extern char*s117_926388A;
extern char*s349_1524252299A;
extern char*s342_560316788A;
extern char*s33_2218105A;
extern char*s113_89862A;
extern char*s291_411001267A;
extern char*s416_1933023161A;
extern char*s117_671483818A;
extern char*s414_1140411454A;
extern char*s33_203589551A;
extern char*s647_9905A;
extern char*s647_34510A;
extern char*s117_449414272A;
extern char*s642_3760A;
extern char*s97_510352234A;
extern char*s409_1128496981A;
extern char*s104_407741255A;
extern char*s117_22971612A;
extern char*s764_560556710A;
extern char*s117_1316373138A;
extern char*s415_944882A;
extern char*s625_403595A;
extern char*s647_2030510390A;
extern char*s506_52976196A;
extern char*s111_956422775A;
extern char*s425_1931700734A;
extern char*s580_638047023A;
extern char*s283_1737556726A;
extern char*s33_275488632A;
extern char*s283_2044479327A;
extern char*s35_77608A;
extern char*s647_9980719A;
extern char*s117_122027336A;
extern char*s848_40705A;
extern char*s34_2593373A;
extern char*s126_113009974A;
extern char*s479_907165587A;
extern char*s651_2187411A;
extern char*s904_1760616840A;
extern char*s283_1799491166A;
extern char*s447_892969089A;
extern char*s111_1194472660A;
extern char*s104_1943393816A;
extern char*s489_9808515A;
extern char*s805_65332A;
extern char*s625_2187432A;
extern char*s728_357653724A;
extern char*s625_403650A;
extern char*s105_372047073A;
extern char*s678_1864907075A;
extern char*s117_1595351811A;
extern char*s104_1786174287A;
extern char*s33_440571A;
extern char*s104_2082787810A;
extern char*s283_1059495149A;
extern char*s111_388205767A;
extern char*s33_1604522960A;
extern char*s293_2064444A;
extern char*s33_2187464A;
extern char*s117_697705640A;
extern char*s291_188525860A;
extern char*s34_49076540A;
extern char*s281_1587749191A;
extern char*s113_143937264A;
extern char*s111_1131498768A;
extern char*s283_452889A;
extern char*s117_1450791030A;
extern char*s850_1411018665A;
extern char*s436_2134616155A;
extern char*s412_333554149A;
extern char*s117_397592212A;
extern char*s35_16177A;
extern char*s412_461679483A;
extern char*s33_2187483A;
extern char*s648_1502256459A;
extern char*s104_1491971992A;
extern char*s623_11241768A;
extern char*s34_59251A;
extern char*s293_1224218969A;
extern char*s293_1750778A;
extern char*s112_2107398012A;
extern char*s106_745978733A;
extern char*s117_2123661269A;
extern char*s848_384078512A;
extern char*s111_2045223723A;
extern char*s678_191115496A;
extern char*s370_2082970A;
extern char*s117_522691310A;
extern char*s110_1442714837A;
extern char*s113_1056930268A;
extern char*s648_2187545A;
extern char*s104_1687580001A;
extern char*s104_1301660112A;
extern char*s117_1266427187A;
extern char*s504_455005721A;
extern char*s117_1136118256A;
extern char*s485_779913846A;
extern char*s381_389128515A;
extern char*s660_7440512A;
extern char*s647_77767A;
extern char*s117_2060090728A;
extern char*s283_641030424A;
extern char*s647_77773A;
extern char*s848_1869083728A;
extern char*s34_16264A;
extern char*s34_9790205A;
extern char*s621_1476287022A;
extern char*s844_646707803A;
extern char*s104_99041221A;
extern char*s848_1847665958A;
extern char*s640_7225250A;
extern char*s640_2187584A;
extern char*s640_2187585A;
extern char*s34_265093627A;
extern char*s117_1234811086A;
extern char*s414_435568604A;
extern char*s729_34749A;
extern char*s32_635943583A;
extern char*s105_175744216A;
extern char*s117_700572143A;
extern char*s33_1223936132A;
extern char*s640_40428375A;
extern char*s342_1207039342A;
extern char*s415_511502716A;
extern char*s33_37186806A;
extern char*s825_1847764413A;
extern char*s625_2187619A;
extern char*s642_809795A;
extern char*s383_4488096A;
extern char*s625_208313786A;
extern char*s105_175744241A;
extern char*s33_77832A;
extern char*s283_1667312535A;
extern char*s283_90141A;
extern char*s403_1814961148A;
extern char*s467_161769183A;
extern char*s379_432936020A;
extern char*s117_889346373A;
extern char*s117_4980205A;
extern char*s104_872019014A;
extern char*s120_7612837A;
extern char*s342_41769343A;
extern char*s283_1984169029A;
extern char*s104_1476889913A;
extern char*s729_2039472678A;
extern char*s583_26108906A;
extern char*s33_65574A;
extern char*s117_1417828020A;
extern char*s33_197002151A;
extern char*s642_440120430A;
extern char*s729_533301931A;
extern char*s648_388821092A;
extern char*s104_1160088831A;
extern char*s104_902126A;
extern char*s642_2089246593A;
extern char*s647_234855416A;
extern char*s33_550709268A;
extern char*s117_253935823A;
extern char*s97_1468715266A;
extern char*s33_197002168A;
extern char*s104_732932648A;
extern char*s625_657822788A;
extern char*s642_2353775A;
extern char*s105_1836169859A;
extern char*s34_434665A;
extern char*s105_175744316A;
extern char*s117_2060613700A;
extern char*s425_626532654A;
extern char*s33_197002174A;
extern char*s489_397949195A;
extern char*s408_647790517A;
extern char*s117_1922677534A;
extern char*s117_2114508771A;
extern char*s283_1805205737A;
extern char*s33_573080478A;
extern char*s412_2089449608A;
extern char*s767_1139569132A;
extern char*s113_1832417772A;
extern char*s648_84085A;
extern char*s104_1732402521A;
extern char*s642_47187A;
extern char*s619_1152812249A;
extern char*s120_1248054333A;
extern char*s33_53339A;
extern char*s30_1335263213A;
extern char*s729_1085305030A;
extern char*s291_838840612A;
extern char*s110_1616517694A;
extern char*s621_1476281050A;
extern char*s589_742356033A;
extern char*s844_1456062714A;
extern char*s33_49076823A;
extern char*s117_1858528797A;
extern char*s625_1949908058A;
extern char*s117_10940631A;
extern char*s727_870210728A;
extern char*s111_218672210A;
extern char*s447_397660162A;
extern char*s30_375350487A;
extern char*s113_1361085152A;
extern char*s366_556780396A;
extern char*s729_1403828457A;
extern char*s493_1610077639A;
extern char*s117_16487A;
extern char*s104_398318341A;
extern char*s370_731327330A;
extern char*s105_595894613A;
extern char*s104_1174611449A;
extern char*s764_2027238465A;
extern char*s34_78002A;
extern char*s377_165601417A;
extern char*s767_1927020241A;
extern char*s349_1246984134A;
extern char*s728_1062817045A;
extern char*s117_1617526527A;
extern char*s642_16510A;
extern char*s33_1202672333A;
extern char*s104_897447412A;
extern char*s113_19761224A;
extern char*s825_1959331451A;
extern char*s848_1990989A;
extern char*s104_521861207A;
extern char*s117_5367889A;
extern char*s104_586311386A;
extern char*s625_422487A;
extern char*s117_47278A;
extern char*s104_1093012317A;
extern char*s104_1437345301A;
extern char*s904_2072196164A;
extern char*s33_1744612358A;
extern char*s104_1759774576A;
extern char*s456_1118729658A;
extern char*s117_2096892436A;
extern char*s420_1061310076A;
extern char*s104_4235A;
extern char*s111_1610926534A;
extern char*s104_1154110220A;
extern char*s282_956361723A;
extern char*s117_1110850242A;
extern char*s117_1377391529A;
extern char*s647_884813300A;
extern char*s647_4881995A;
extern char*s117_1197714671A;
extern char*s642_840791A;
extern char*s105_543076045A;
extern char*s650_4256A;
extern char*s729_280766651A;
extern char*s106_42698349A;
extern char*s705_928596125A;
extern char*s117_246893097A;
extern char*s117_1911279888A;
extern char*s104_1454703466A;
extern char*s409_332834879A;
extern char*s383_78082A;
extern char*s113_1223801083A;
extern char*s416_1907958363A;
extern char*s495_94643563A;
extern char*s89_650029656A;
extern char*s647_17743770A;
extern char*s117_1964848975A;
extern char*s728_871385705A;
extern char*s104_688657949A;
extern char*s34_90408A;
extern char*s848_1314337673A;
extern char*s105_1242149539A;
extern char*s33_7748406A;
extern char*s538_840796792A;
extern char*s640_3934795A;
extern char*s729_4308A;
extern char*s342_198146473A;
extern char*s104_126038302A;
extern char*s33_16616A;
extern char*s113_2121681051A;
extern char*s640_36122993A;
extern char*s844_182705A;
extern char*s415_1718483009A;
extern char*s34_16630A;
extern char*s106_1784452489A;
extern char*s34_10208843A;
extern char*s34_56255230A;
extern char*s113_725963810A;
extern char*s33_16639A;
extern char*s33_78150A;
extern char*s104_2016523575A;
extern char*s456_1888871872A;
extern char*s34_1730514379A;
extern char*s512_1879799154A;
extern char*s642_1553642381A;
extern char*s687_1166590709A;
extern char*s848_1396798042A;
extern char*s33_705019679A;
extern char*s33_1339128A;
extern char*s624_25641730A;
extern char*s33_451899881A;
extern char*s33_1297145705A;
extern char*s115_59731A;
extern char*s551_2014364610A;
extern char*s113_39204698A;
extern char*s113_61342149A;
extern char*s104_768172015A;
extern char*s488_1979303915A;
extern char*s647_17743865A;
extern char*s370_416499A;
extern char*s105_1226144723A;
extern char*s370_416500A;
extern char*s377_61858840A;
extern char*s33_16686A;
extern char*s848_1279738389A;
extern char*s371_881547256A;
extern char*s35_385751A;
extern char*s33_999658760A;
extern char*s849_666336072A;
extern char*s849_41300A;
extern char*s704_355003A;
extern char*s844_1037766A;
extern char*s117_561301605A;
extern char*s117_988839165A;
extern char*s386_31214580A;
extern char*s647_106047655A;
extern char*s283_2085574777A;
extern char*s846_1006394131A;
extern char*s104_996097357A;
extern char*s113_84381A;
extern char*s283_416541A;
extern char*s642_4425A;
extern char*s624_1511378937A;
extern char*s33_90544A;
extern char*s117_280139425A;
extern char*s409_29037A;
extern char*s728_255799920A;
extern char*s767_888288799A;
extern char*s34_427898753A;
extern char*s642_847125A;
extern char*s647_111269879A;
extern char*s349_2084824380A;
extern char*s282_988261007A;
extern char*s117_1240218271A;
extern char*s105_175744666A;
extern char*s709_1085938891A;
extern char*s554_32450971A;
extern char*s554_311952415A;
extern char*s640_920950A;
extern char*s34_78263A;
extern char*s642_958274895A;
extern char*s648_804085A;
extern char*s117_561947515A;
extern char*s34_16761A;
extern char*s763_786403659A;
extern char*s117_758545786A;
extern char*s104_1559455194A;
extern char*s117_21391495A;
extern char*s105_175744691A;
extern char*s104_1421961899A;
extern char*s363_1479430694A;
extern char*s447_597973944A;
extern char*s117_16782A;
extern char*s34_84443A;
extern char*s710_161074567A;
extern char*s420_182862A;
extern char*s111_1914558593A;
extern char*s111_1450022771A;
extern char*s625_430519127A;
extern char*s104_611217054A;
extern char*s409_138555764A;
extern char*s113_1615398571A;
extern char*s790_1400894751A;
extern char*s117_2086571326A;
extern char*s108_1880881887A;
extern char*s767_263008962A;
extern char*s33_839855894A;
extern char*s104_1075925125A;
extern char*s104_488830629A;
extern char*s349_2050169721A;
extern char*s647_1174230416A;
extern char*s111_1661328107A;
extern char*s33_2126626A;
extern char*s117_179423058A;
extern char*s111_42846255A;
extern char*s409_1816745449A;
extern char*s488_56907446A;
extern char*s729_614557109A;
extern char*s488_10559665A;
extern char*s589_1208522276A;
extern char*s729_1215177661A;
extern char*s120_576322499A;
extern char*s415_1592935176A;
extern char*s33_324411A;
extern char*s33_1739790308A;
extern char*s97_15142174A;
extern char*s647_195246A;
extern char*s589_1502207936A;
extern char*s713_1345295929A;
extern char*s113_149455415A;
extern char*s647_1605175681A;
extern char*s370_22271191A;
extern char*s467_375578482A;
extern char*s625_948421114A;
extern char*s625_35330A;
extern char*s33_16877A;
extern char*s120_784841421A;
extern char*s104_107634778A;
extern char*s415_350193314A;
extern char*s729_269141588A;
extern char*s106_1043946153A;
extern char*s113_1515266530A;
extern char*s117_1065942137A;
extern char*s104_104977558A;
extern char*s412_401707956A;
extern char*s489_16902A;
extern char*s436_1878889060A;
extern char*s117_18131599A;
extern char*s554_1185594A;
extern char*s848_784300160A;
extern char*s501_850294241A;
extern char*s33_243411981A;
extern char*s33_1419919903A;
extern char*s104_2102385657A;
extern char*s415_211605167A;
extern char*s104_762747069A;
extern char*s113_466551816A;
extern char*s113_2009849A;
extern char*s117_1743948446A;
extern char*s850_1682659883A;
extern char*s848_1007239A;
extern char*s807_630125369A;
extern char*s104_2028592127A;
extern char*s97_1838187926A;
extern char*s104_214231661A;
extern char*s489_1163823042A;
extern char*s807_17725666A;
extern char*s33_1770803725A;
extern char*s34_16942A;
extern char*s764_989731302A;
extern char*s409_897982986A;
extern char*s111_1783880762A;
extern char*s844_1038016A;
extern char*s34_10049231A;
extern char*s642_206419907A;
extern char*s848_931143030A;
extern char*s637_810433A;
extern char*s286_1973946666A;
extern char*s104_1062177790A;
extern char*s904_1994165009A;
extern char*s625_46733806A;
extern char*s286_1838870713A;
extern char*s642_1008067448A;
extern char*s111_485115581A;
extern char*s485_2101296982A;
extern char*s113_1097945864A;
extern char*s101_2219026A;
extern char*s848_90782A;
extern char*s904_1508488213A;
extern char*s650_1511667A;
extern char*s642_20481355A;
extern char*s655_90792A;
extern char*s34_78490A;
extern char*s35_78495A;
extern char*s113_146157A;
extern char*s729_1428771266A;
extern char*s370_931579788A;
extern char*s904_1942675017A;
extern char*s647_252669317A;
extern char*s33_41849945A;
extern char*s126_27561173A;
extern char*s117_1533928773A;
extern char*s825_2007377394A;
extern char*s105_1658160521A;
extern char*s647_933501A;
extern char*s490_1136691048A;
extern char*s117_1170250908A;
extern char*s383_35157672A;
extern char*s104_1436398529A;
extern char*s727_1657834530A;
extern char*s844_1619999729A;
extern char*s647_626047338A;
extern char*s729_178014651A;
extern char*s33_447584A;
extern char*s104_1414519430A;
extern char*s117_1404148845A;
extern char*s117_958964069A;
extern char*s650_90405963A;
extern char*s729_1494814589A;
extern char*s497_439056951A;
extern char*s358_767649523A;
extern char*s33_1554777A;
extern char*s33_447600A;
extern char*s17_1216703285A;
extern char*s463_22861847A;
extern char*s117_530940601A;
extern char*s117_724500276A;
extern char*s493_1723490337A;
extern char*s33_591417242A;
extern char*s647_10895A;
extern char*s104_2096474678A;
extern char*s904_1439959996A;
extern char*s656_11205716A;
extern char*s728_1061058398A;
extern char*s647_10430693A;
extern char*s111_445497083A;
extern char*s848_176986A;
extern char*s117_997623147A;
extern char*s625_1623721137A;
extern char*s117_2055072316A;
extern char*s113_631091213A;
extern char*s33_1735712398A;
extern char*s33_51906905A;
extern char*s848_73472312A;
extern char*s97_625881326A;
extern char*s34_78591A;
extern char*s642_379993A;
extern char*s727_1750560930A;
extern char*s111_1224226011A;
extern char*s415_163270777A;
extern char*s386_561523426A;
extern char*s416_1490189105A;
extern char*s349_1060258809A;
extern char*s283_2108992007A;
extern char*s33_1192911276A;
extern char*s34_10990481A;
extern char*s647_1514442508A;
extern char*s104_1632732392A;
extern char*s33_167970159A;
extern char*s104_264380934A;
extern char*s117_1253959973A;
extern char*s621_565060278A;
extern char*s647_78629A;
extern char*s111_1605895597A;
extern char*s106_126291003A;
extern char*s729_790599008A;
extern char*s283_1658492806A;
extern char*s33_48856070A;
extern char*s33_1622700141A;
extern char*s625_1694771411A;
extern char*s117_78646A;
extern char*s289_722230651A;
extern char*s625_404651A;
extern char*s640_8087250A;
extern char*s642_119389596A;
extern char*s104_1453916708A;
extern char*s104_844703215A;
extern char*s117_2237652A;
extern char*s30_1364794873A;
extern char*s416_1256137461A;
extern char*s660_1465905014A;
extern char*s106_618869258A;
extern char*s29_1852009437A;
extern char*s105_174945438A;
extern char*s35_1777434714A;
extern char*s104_501268295A;
extern char*s642_380065A;
extern char*s111_313299890A;
extern char*s624_605650769A;
extern char*s104_1950357785A;
extern char*s104_2077708091A;
extern char*s684_1760457965A;
extern char*s117_850522083A;
extern char*s113_447734A;
extern char*s117_824324978A;
extern char*s363_793028699A;
extern char*s420_2007408328A;
extern char*s34_17176A;
extern char*s412_1090404950A;
extern char*s34_878084737A;
extern char*s342_1492212881A;
extern char*s711_78239462A;
extern char*s104_2141291014A;
extern char*s660_1548937422A;
extern char*s34_17206A;
extern char*s126_210141519A;
extern char*s34_2065491A;
extern char*s623_565066528A;
extern char*s117_27063164A;
extern char*s648_1719326284A;
extern char*s126_349372A;
extern char*s117_106460275A;
extern char*s554_1722217257A;
extern char*s33_84881A;
extern char*s34_17221A;
extern char*s117_1917882A;
extern char*s409_1424594977A;
extern char*s850_576790349A;
extern char*s113_129391217A;
extern char*s33_2038667775A;
extern char*s763_1762204931A;
extern char*s848_1497878015A;
extern char*s104_2127445170A;
extern char*s33_50246319A;
extern char*s729_790599133A;
extern char*s283_926093361A;
extern char*s552_1134353920A;
extern char*s642_1898591066A;
extern char*s111_580671658A;
extern char*s117_545118879A;
extern char*s642_380168A;
extern char*s104_23410A;
extern char*s117_508495830A;
extern char*s848_77562923A;
extern char*s467_1790874766A;
extern char*s377_7238542A;
extern char*s104_469031018A;
extern char*s729_453998A;
extern char*s647_1671077900A;
extern char*s642_1952787551A;
extern char*s848_1739163321A;
extern char*s33_447851A;
extern char*s286_689575137A;
extern char*s495_29585A;
extern char*s589_100561530A;
extern char*s33_2098363273A;
extern char*s111_1004555549A;
extern char*s117_104036848A;
extern char*s33_349117293A;
extern char*s30_1812938425A;
extern char*s105_1861857328A;
extern char*s120_1816788953A;
extern char*s660_1541882313A;
extern char*s554_4992A;
extern char*s764_2131486419A;
extern char*s104_179688005A;
extern char*s104_928941315A;
extern char*s111_1836299930A;
extern char*s126_195766720A;
extern char*s104_1680421289A;
extern char*s415_165614527A;
extern char*s648_872295A;
extern char*s33_84969A;
extern char*s625_2142146116A;
extern char*s642_380218A;
extern char*s844_101355036A;
extern char*s415_1057872442A;
extern char*s117_1717499533A;
extern char*s647_204519611A;
extern char*s904_838816886A;
extern char*s120_1998329594A;
extern char*s844_800004081A;
extern char*s104_75828399A;
extern char*s104_1204389280A;
extern char*s447_1628100917A;
extern char*s105_1578831409A;
extern char*s104_1307652273A;
extern char*s104_1690004585A;
extern char*s126_1018573728A;
extern char*s104_1741759101A;
extern char*s844_486352305A;
extern char*s436_1627141371A;
extern char*s35_914215870A;
extern char*s113_1588150185A;
extern char*s113_91157A;
extern char*s805_1932458562A;
extern char*s483_375013061A;
extern char*s97_8198176A;
extern char*s647_60405A;
extern char*s727_1345708525A;
extern char*s467_1875641781A;
extern char*s848_1831440704A;
extern char*s416_29662A;
extern char*s763_1309017823A;
extern char*s33_1487451A;
extern char*s283_1453633985A;
extern char*s283_1736752216A;
extern char*s117_495363549A;
extern char*s728_1240206596A;
extern char*s104_1545228536A;
extern char*s409_277033810A;
extern char*s104_973007162A;
extern char*s113_561720547A;
extern char*s371_197895058A;
extern char*s111_1889118664A;
extern char*s625_1387812168A;
extern char*s394_668815628A;
extern char*s104_2108887750A;
extern char*s33_240810599A;
extern char*s554_165909873A;
extern char*s117_2022630A;
extern char*s115_11253A;
extern char*s113_2194860A;
extern char*s640_1127821710A;
extern char*s33_240810604A;
extern char*s642_2022635A;
extern char*s121_128358027A;
extern char*s34_392625A;
extern char*s625_4999725A;
extern char*s104_199494346A;
extern char*s625_706329A;
extern char*s846_1777096676A;
extern char*s678_143852403A;
extern char*s660_831146693A;
extern char*s33_17422A;
extern char*s33_2054549840A;
extern char*s104_1912621670A;
extern char*s467_1141741445A;
extern char*s659_265537649A;
extern char*s642_380343A;
extern char*s678_167300030A;
extern char*s729_1384921237A;
extern char*s104_922446006A;
extern char*s104_66884963A;
extern char*s104_134219969A;
extern char*s30_53561911A;
extern char*s117_471553120A;
extern char*s729_1374304640A;
extern char*s642_504830035A;
extern char*s393_128333478A;
extern char*s113_262628264A;
extern char*s642_1888091524A;
extern char*s489_1809088081A;
extern char*s104_1701980726A;
extern char*s33_337331A;
extern char*s117_17480A;
extern char*s97_1056980719A;
extern char*s117_1680956616A;
extern char*s104_2060540980A;
extern char*s650_5313505A;
extern char*s475_1199044228A;
extern char*s35_17498A;
extern char*s126_1293738877A;
extern char*s104_1046025807A;
extern char*s33_1483884743A;
extern char*s621_985967445A;
extern char*s648_2102695A;
extern char*s117_17507A;
extern char*s660_139854341A;
extern char*s104_2176510A;
extern char*s104_552734069A;
extern char*s846_1387277146A;
extern char*s111_1556970935A;
extern char*s729_35966A;
extern char*s650_5313530A;
extern char*s648_1416678934A;
extern char*s394_492964813A;
extern char*s105_1538234998A;
extern char*s34_306165094A;
extern char*s111_921818688A;
extern char*s415_1505530135A;
extern char*s647_46980416A;
extern char*s120_870131842A;
extern char*s117_2072467813A;
extern char*s415_177461A;
extern char*s370_572614135A;
extern char*s289_867234734A;
extern char*s848_97510A;
extern char*s97_445214625A;
extern char*s104_1275488910A;
extern char*s29_386614A;
extern char*s283_929353692A;
extern char*s621_1316811340A;
extern char*s538_637371887A;
extern char*s729_558682149A;
extern char*s117_51599861A;
extern char*s554_1707891936A;
extern char*s117_1416365293A;
extern char*s554_11429A;
extern char*s111_170061979A;
extern char*s625_1992695545A;
extern char*s729_398948A;
extern char*s625_5284A;
extern char*s104_755120513A;
extern char*s529_890319497A;
extern char*s104_2087550139A;
extern char*s625_21632225A;
extern char*s729_328118105A;
extern char*s848_775406525A;
extern char*s494_1370872538A;
extern char*s647_520373770A;
extern char*s35_10714216A;
extern char*s647_1836091144A;
extern char*s123_300594A;
extern char*s625_2036521484A;
extern char*s33_1740332382A;
extern char*s111_1379717706A;
extern char*s104_1606714210A;
extern char*s33_1644425991A;
extern char*s660_1677586033A;
extern char*s625_4434071A;
extern char*s642_4766225A;
extern char*s420_1119905623A;
extern char*s844_1509872874A;
extern char*s648_1087446800A;
extern char*s34_75797981A;
extern char*s729_49680837A;
extern char*s846_8050871A;
extern char*s105_744085684A;
extern char*s117_1173628471A;
extern char*s577_146251545A;
extern char*s33_267647687A;
extern char*s117_825893997A;
extern char*s490_380590A;
extern char*s844_1832086881A;
extern char*s412_988692517A;
extern char*s392_5382A;
extern char*s660_2025498932A;
extern char*s483_789350917A;
extern char*s104_96053257A;
extern char*s283_17696A;
extern char*s104_1062283098A;
extern char*s293_1831619428A;
extern char*s340_1262756502A;
extern char*s729_444175272A;
extern char*s34_17715A;
extern char*s283_880804011A;
extern char*s650_300665A;
extern char*s105_2004339522A;
extern char*s349_1001314405A;
extern char*s289_92467250A;
extern char*s293_878860A;
extern char*s647_537910373A;
extern char*s104_112999293A;
extern char*s582_30034A;
extern char*s104_568400887A;
extern char*s117_1968768303A;
extern char*s104_783329131A;
extern char*s625_180709512A;
extern char*s117_169662319A;
extern char*s104_1984637890A;
extern char*s120_1605047378A;
extern char*s117_1435285930A;
extern char*s104_79251A;
extern char*s104_756929053A;
extern char*s104_142936234A;
extern char*s904_1377638770A;
extern char*s660_21306364A;
extern char*s117_738771309A;
extern char*s111_295542551A;
extern char*s625_386819A;
extern char*s381_22401251A;
extern char*s647_358916317A;
extern char*s105_348041349A;
extern char*s117_401124480A;
extern char*s349_1149307517A;
extern char*s436_1837585965A;
extern char*s729_1642168697A;
extern char*s393_305790140A;
extern char*s625_242108838A;
extern char*s625_56760755A;
extern char*s625_60837A;
extern char*s625_1367040625A;
extern char*s33_1979951A;
extern char*s498_1965077754A;
extern char*s117_471707221A;
extern char*s476_1809998749A;
extern char*s115_17794A;
extern char*s33_386854A;
extern char*s117_1844536619A;
extern char*s624_1151663379A;
extern char*s104_776600004A;
extern char*s846_1126647264A;
extern char*s391_2014931627A;
extern char*s89_1331038845A;
extern char*s104_150329797A;
extern char*s117_802495724A;
extern char*s126_1723571071A;
extern char*s117_719604853A;
extern char*s115_39617954A;
extern char*s113_25704393A;
extern char*s583_5515A;
extern char*s104_397329363A;
extern char*s117_1881374985A;
extern char*s117_713312393A;
extern char*s104_676769302A;
extern char*s33_1896328073A;
extern char*s33_79341A;
extern char*s625_882065083A;
extern char*s117_862271166A;
extern char*s293_60894A;
extern char*s33_48672249A;
extern char*s117_23988287A;
extern char*s117_1682814572A;
extern char*s33_572288431A;
extern char*s506_2099969245A;
extern char*s111_1019367716A;
extern char*s552_1381550903A;
extern char*s807_2078852867A;
extern char*s33_572288437A;
extern char*s729_189437896A;
extern char*s104_1536599162A;
extern char*s729_1891487260A;
extern char*s111_91926102A;
extern char*s625_560761477A;
extern char*s415_530141799A;
extern char*s104_202933204A;
extern char*s33_572288454A;
extern char*s117_1672511676A;
extern char*s728_6943896A;
extern char*s104_120546715A;
extern char*s111_479236135A;
extern char*s624_5580A;
extern char*s111_1865554673A;
extern char*s104_922212712A;
extern char*s111_1162901343A;
extern char*s625_674382779A;
extern char*s370_1546692995A;
extern char*s495_1411247976A;
extern char*s728_1665893228A;
extern char*s117_1842506892A;
extern char*s117_4692662A;
extern char*s648_835985A;
extern char*s849_5498450A;
extern char*s844_2070967345A;
extern char*s642_312808564A;
extern char*s117_1994596535A;
extern char*s653_17916A;
extern char*s111_5615A;
extern char*s844_42521A;
extern char*s639_627106219A;
extern char*s117_1413407004A;
extern char*s33_1680926299A;
extern char*s34_436196A;
extern char*s495_1142240176A;
extern char*s805_602797481A;
extern char*s113_120239233A;
extern char*s848_28263330A;
extern char*s33_17941A;
extern char*s33_506823435A;
extern char*s35_10554609A;
extern char*s283_816126476A;
extern char*s104_1869854287A;
extern char*s104_2009918711A;
extern char*s704_861846863A;
extern char*s33_39002989A;
extern char*s552_456083848A;
extern char*s29_85614A;
extern char*s642_521905705A;
extern char*s848_291421585A;
extern char*s117_1586354711A;
extern char*s728_1166044581A;
extern char*s104_971408488A;
extern char*s502_1773984820A;
extern char*s111_866669263A;
extern char*s489_1961687A;
extern char*s122_51895507A;
extern char*s117_36434A;
extern char*s848_1815688614A;
extern char*s104_210812758A;
extern char*s409_1250079569A;
extern char*s660_1722095007A;
extern char*s436_1333985363A;
extern char*s117_2041682A;
extern char*s358_786054293A;
extern char*s625_988243818A;
extern char*s33_1937220099A;
extern char*s848_567878339A;
extern char*s625_5720A;
extern char*s848_598811726A;
extern char*s112_1461366457A;
extern char*s767_1613492996A;
extern char*s104_18036A;
extern char*s33_247239028A;
extern char*s33_278061691A;
extern char*s728_1942608409A;
extern char*s729_41125176A;
extern char*s849_1506490209A;
extern char*s640_1406782500A;
extern char*s29_425790270A;
extern char*s104_1740357387A;
extern char*s117_2103819988A;
extern char*s412_1816888147A;
extern char*s104_1694969179A;
extern char*s117_1836282258A;
extern char*s640_1188262106A;
extern char*s638_263576126A;
extern char*s104_825716016A;
extern char*s848_1649648619A;
extern char*s117_273731430A;
extern char*s33_1549680A;
extern char*s488_1848584263A;
extern char*s349_1642968637A;
extern char*s848_1040644265A;
extern char*s117_1042003640A;
extern char*s381_5787A;
extern char*s34_18090A;
extern char*s463_114137597A;
extern char*s648_946895A;
extern char*s409_1721307786A;
extern char*s33_1549697A;
extern char*s117_1360840737A;
extern char*s117_1352413868A;
extern char*s619_11952A;
extern char*s33_1549703A;
extern char*s111_98784712A;
extern char*s282_1968202785A;
extern char*s33_18110A;
extern char*s117_1063704391A;
extern char*s625_1566831588A;
extern char*s117_1339521386A;
extern char*s283_374877A;
extern char*s728_1635390646A;
extern char*s848_2021999449A;
extern char*s660_1849347035A;
extern char*s117_1460025642A;
extern char*s848_484169497A;
extern char*s495_14429929A;
extern char*s126_809686569A;
extern char*s642_6575105A;
extern char*s115_18144A;
extern char*s104_18150A;
extern char*s117_457314246A;
extern char*s120_290966604A;
extern char*s848_322115272A;
extern char*s648_2122389958A;
extern char*s117_1624663341A;
extern char*s104_1320619413A;
extern char*s104_442256615A;
extern char*s640_112304676A;
extern char*s468_2015374870A;
extern char*s625_472574902A;
extern char*s283_1325140408A;
extern char*s104_2116282032A;
extern char*s35_267875778A;
extern char*s846_201266601A;
extern char*s506_18186A;
extern char*s848_1985327250A;
extern char*s848_1196941282A;
extern char*s33_1176378494A;
extern char*s647_559906822A;
extern char*s554_1096544670A;
extern char*s33_55924644A;
extern char*s846_2097247A;
extern char*s124_2120987577A;
extern char*s409_5912A;
extern char*s289_1153312264A;
extern char*s506_1985887020A;
extern char*s117_163413385A;
extern char*s848_1800342110A;
extern char*s625_1992825354A;
extern char*s647_854330615A;
extern char*s904_1067567332A;
extern char*s33_1673348567A;
extern char*s111_5873980A;
extern char*s656_399591A;
extern char*s97_1539816514A;
extern char*s126_44975894A;
extern char*s34_56927287A;
extern char*s647_1709245815A;
extern char*s647_4680700A;
extern char*s104_518055462A;
extern char*s495_84293096A;
extern char*s33_1831158645A;
extern char*s848_175186427A;
extern char*s104_732257893A;
extern char*s642_352968782A;
extern char*s117_49152444A;
extern char*s383_18257A;
extern char*s416_902517583A;
extern char*s843_496139469A;
extern char*s293_927785894A;
extern char*s342_673829558A;
extern char*s371_1664909434A;
extern char*s365_1215781867A;
extern char*s467_529299514A;
extern char*s104_1387339410A;
extern char*s104_445504446A;
extern char*s111_1242126608A;
extern char*s35_10714862A;
extern char*s113_1494914262A;
extern char*s117_5980A;
extern char*s439_983618541A;
extern char*s728_341361877A;
extern char*s729_1869700848A;
extern char*s111_1568923104A;
extern char*s115_448859A;
extern char*s33_1553736287A;
extern char*s34_1980461A;
extern char*s848_744114A;
extern char*s104_1575461624A;
extern char*s104_1181926797A;
extern char*s648_531809155A;
extern char*s117_8359055A;
extern char*s33_9712276A;
extern char*s728_2005219697A;
extern char*s729_172080A;
extern char*s117_1427351705A;
extern char*s34_1168210079A;
extern char*s844_1664195965A;
extern char*s647_42916A;
extern char*s29_24284008A;
extern char*s729_249330648A;
extern char*s289_1145998825A;
extern char*s647_842552A;
extern char*s117_431043495A;
extern char*s117_490486762A;
extern char*s104_727903062A;
extern char*s113_165012750A;
extern char*s113_2075119688A;
extern char*s435_306215109A;
extern char*s104_1583181163A;
extern char*s117_1377208779A;
extern char*s647_153655A;
extern char*s111_212031001A;
extern char*s104_12184A;
extern char*s110_1152235958A;
extern char*s117_1160736641A;
extern char*s86_1501391323A;
extern char*s117_12188A;
extern char*s650_1985290496A;
extern char*s117_113036818A;
extern char*s117_12201A;
extern char*s104_34383990A;
extern char*s105_35386613A;
extern char*s460_498169402A;
extern char*s640_781095A;
extern char*s104_1593742473A;
extern char*s120_740900172A;
extern char*s104_2018315248A;
extern char*s117_1009317511A;
extern char*s104_124311631A;
extern char*s538_1359629264A;
extern char*s439_1920465143A;
extern char*s710_8777401A;
extern char*s117_1838958244A;
extern char*s104_1962710217A;
extern char*s848_1901427808A;
extern char*s848_365929075A;
extern char*s850_958639438A;
extern char*s34_1593051A;
extern char*s113_5578901A;
extern char*s342_176865800A;
extern char*s640_7227375A;
extern char*s104_431394186A;
extern char*s674_1159783306A;
extern char*s625_9589368A;
extern char*s844_1048179568A;
extern char*s35_388005040A;
extern char*s113_1319327951A;
extern char*s660_374042271A;
extern char*s111_3579844A;
extern char*s34_1747646688A;
extern char*s589_51582255A;
extern char*s727_264935842A;
extern char*s126_141444A;
extern char*s105_432335312A;
extern char*s848_1265395998A;
extern char*s640_40430500A;
extern char*s625_5794220A;
extern char*s283_1598804806A;
extern char*s640_860088160A;
extern char*s106_356743A;
extern char*s904_1377633305A;
extern char*s729_1958195441A;
extern char*s117_209121A;
extern char*s104_1615234134A;
extern char*s625_338723264A;
extern char*s467_1573210512A;
extern char*s117_1790869799A;
extern char*s625_3912034A;
extern char*s680_1257368965A;
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void se_signal_handler(int sig);
/*The generic se_agent0 definition:*/
struct _se_agent0{
Tid id;
Tid creation_mold_id;
void(*afp)(se_agent*);
int(*eq)(se_agent*,se_agent*);
};
/*INTEGER_32*/T6 r2in_range(T2 C,T2 a1,T2 a2);
/*INTEGER_32*/T2 r2max(T2 C,T2 a1);
/*INTEGER_32*/T6 r2is_even(T2 C);
/*INTEGER_32*/T2 r2min(T2 C,T2 a1);
/*INTEGER_32*/T2 r2_ix_9292(T2 C,T2 a1);
/*INTEGER_32*/T0*r2to_string(T2 C);
/*INTEGER_32*/T2 r2_ix_4747(T2 C,T2 a1);
/*INTEGER_32*/T3 r2hexadecimal_digit(T2 C);
/*INTEGER_32*/T6 r2is_odd(T2 C);
/*INTEGER_32*/T6 r2bit_test(T2 C,T1 a1);
/*INTEGER_32*/void r2append_in(T2 C,T0*a1);
/*INTEGER_32*/T3 r2decimal_digit(T2 C);
/*INTEGER_32*/void r2to_hexadecimal_in(T2 C,T0*a1);
extern T0*oBC83string_buffer;
extern int fBC83string_buffer;
/*INTEGER_32*/T0*r2string_buffer(void);
/*INTEGER_8*/T1 r1min(T1 C,T1 a1);
/*INTEGER_8*/void r1to_octal_in(T1 C,T0*a1);
/*INTEGER_8*/T3 r1hexadecimal_digit(T1 C);
/*INTEGER_8*/T3 r1decimal_digit(T1 C);
/*CHARACTER*/T3 r3to_upper(T3 C);
/*CHARACTER*/T6 r3is_digit(T3 C);
/*CHARACTER*/T6 r3in_range(T3 C,T3 a1,T3 a2);
/*CHARACTER*/T1 r3value(T3 C);
/*CHARACTER*/T6 r3is_separator(T3 C);
/*CHARACTER*/T6 r3is_lower(T3 C);
/*CHARACTER*/T1 r3decimal_value(T3 C);
/*CHARACTER*/T1 r3hexadecimal_value(T3 C);
/*CHARACTER*/T3 r3to_lower(T3 C);
/*CHARACTER*/T6 r3is_hexadecimal_digit(T3 C);
/*CHARACTER*/T6 r3_ix_60(T3 C,T3 a1);
/*CHARACTER*/T6 r3same_as(T3 C,T3 a1);
/*CHARACTER*/T6 r3is_letter(T3 C);
/*CHARACTER*/T6 r3_ix_6061(T3 C,T3 a1);
/*CHARACTER*/T6 r3is_upper(T3 C);
/*CHARACTER*/T6 r3_ix_6261(T3 C,T3 a1);
/*BOOLEAN*/T6 r6_ix_and(T6 C,T6 a1);
/*BOOLEAN*/T6 r6_ix_or(T6 C,T6 a1);
/*INTEGER_16*/T6 r10in_range(T10 C,T10 a1,T10 a2);
/*INTEGER_16*/T10 r10max(T10 C,T10 a1);
/*INTEGER_16*/T10 r10min(T10 C,T10 a1);
/*INTEGER_16*/T2 r10to_integer_32(T10 C);
/*INTEGER_16*/void r10append_in(T10 C,T0*a1);
/*INTEGER_16*/T3 r10decimal_digit(T10 C);
/*REAL_64*/void r5append_in_format(T5 C,T0*a1,T2 a2);
extern T9 oBC315sprintf_buffer;
/*INTEGER_64*/T6 r11in_range(T11 C,T11 a1,T11 a2);
/*INTEGER_64*/T6 r11fit_integer_8(T11 C);
/*INTEGER_64*/T0*r11to_number(T11 C);
/*INTEGER_64*/T2 r11high_32(T11 C);
/*INTEGER_64*/T11 r11_ix_9292(T11 C,T11 a1);
/*INTEGER_64*/T6 r11fit_integer_32(T11 C);
/*INTEGER_64*/T6 r11fit_integer_16(T11 C);
/*INTEGER_64*/T0*r11to_string(T11 C);
/*INTEGER_64*/T11 r11_ix_4747(T11 C,T11 a1);
/*INTEGER_64*/T6 r11is_odd(T11 C);
/*INTEGER_64*/void r11append_in(T11 C,T0*a1);
/*INTEGER_64*/T3 r11decimal_digit(T11 C);
/*INTEGER_64*/T11 r11_ix_94(T11 C,T11 a1);
/*INTEGER_64*/T0*r11string_buffer(void);
/*POINTER*/T8 r8_ix_43(T8 C,T2 a1);
/*POINTER*/T2 r8hash_code(T8 C);
/*NATURAL_64*/T6 r16fit_natural_32(uint64_t C);
/*NATURAL_64*/T6 r16fit_natural_16(uint64_t C);
/*NATURAL_64*/T6 r16fit_natural_8(uint64_t C);
/*NATURAL_64*/void r16append_in(uint64_t C,T0*a1);
/*NATURAL_64*/T3 r16decimal_digit(uint64_t C);
/*NATIVE_ARRAY[CHARACTER]*/T2 r9fast_reverse_index_of(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/T9 r9realloc(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/T2 r9fast_index_of(T9 C,T3 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/T6 r9slice_fast_has(T9 C,T3 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/void r9copy_from(T9 C,T9 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/void r9move(T9 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/void r9clear(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/void r9set_slice_with(T9 C,T3 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/void r9clear_all(T9 C,T2 a1);
/*NATIVE_ARRAY[CHARACTER]*/void r9set_all_with(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/T6 r9slice_fast_memcmp(T9 C,T2 a1,T9 a2,T2 a3,T2 a4);
/*NATIVE_ARRAY[CHARACTER]*/void r9copy_slice_from(T9 C,T9 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/T2 r9slice_fast_occurrences(T9 C,T3 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[STRING]*/T934 r934realloc(T934 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/T2 r934fast_index_of(T934 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[STRING]*/void r934copy_from(T934 C,T934 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/T6 r934safe_equal(T0*a1,T0*a2);
/*NATIVE_ARRAY[STRING]*/void r934clear(T934 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/void r934set_slice_with(T934 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[STRING]*/void r934clear_all(T934 C,T2 a1);
/*NATIVE_ARRAY[STRING]*/void r934remove(T934 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/void r934set_all_with(T934 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/T2 r934first_index_of(T934 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/void r934copy_slice_from(T934 C,T934 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[STRING,STRING]]*/void r948clear_all(T948 C,T2 a1);
/*NATIVE_ARRAY[HASHED_STRING]*/T956 r956realloc(T956 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_STRING]*/T2 r956fast_index_of(T956 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_STRING]*/void r956copy_from(T956 C,T956 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_STRING]*/void r956clear(T956 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_STRING]*/void r956clear_all(T956 C,T2 a1);
/*NATIVE_ARRAY[HASHED_STRING]*/void r956copy_slice_from(T956 C,T956 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CLASS_TEXT]*/T960 r960realloc(T960 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLASS_TEXT]*/void r960copy_from(T960 C,T960 a1,T2 a2);
/*NATIVE_ARRAY[CLASS_TEXT]*/void r960clear(T960 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLASS_TEXT]*/void r960clear_all(T960 C,T2 a1);
/*NATIVE_ARRAY[CLASS_TEXT]*/void r960copy_slice_from(T960 C,T960 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTEGER_16]*/T961 r961realloc(T961 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_16]*/void r961copy_from(T961 C,T961 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_16]*/void r961clear_all(T961 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_16]*/void r961copy_slice_from(T961 C,T961 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CLUSTER]*/T965 r965realloc(T965 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLUSTER]*/void r965copy_from(T965 C,T965 a1,T2 a2);
/*NATIVE_ARRAY[CLUSTER]*/void r965clear_all(T965 C,T2 a1);
/*NATIVE_ARRAY[CLUSTER]*/void r965copy_slice_from(T965 C,T965 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[RUN_FEATURE,NATIVE]]*/void r996clear_all(T996 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]]*/void r1025clear_all(T1025 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLASS_TEXT,HASHED_STRING]]*/void r1028clear_all(T1028 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_32]*/T1030 r1030realloc(T1030 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/T2 r1030fast_index_of(T1030 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTEGER_32]*/void r1030copy_from(T1030 C,T1030 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/void r1030move(T1030 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTEGER_32]*/void r1030clear(T1030 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/void r1030set_slice_with(T1030 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTEGER_32]*/void r1030clear_all(T1030 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_32]*/void r1030remove(T1030 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/void r1030set_all_with(T1030 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_32]*/void r1030copy_slice_from(T1030 C,T1030 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[TYPE_MARK]*/T1047 r1047realloc(T1047 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE_MARK]*/void r1047copy_from(T1047 C,T1047 a1,T2 a2);
/*NATIVE_ARRAY[TYPE_MARK]*/void r1047clear(T1047 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE_MARK]*/void r1047set_slice_with(T1047 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[TYPE_MARK]*/void r1047clear_all(T1047 C,T2 a1);
/*NATIVE_ARRAY[TYPE_MARK]*/void r1047set_all_with(T1047 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[TYPE_MARK]*/void r1047copy_slice_from(T1047 C,T1047 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TYPE,HASHED_STRING]]*/void r1050clear_all(T1050 C,T2 a1);
/*NATIVE_ARRAY[LIVE_TYPE]*/T1067 r1067realloc(T1067 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LIVE_TYPE]*/T2 r1067fast_index_of(T1067 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[LIVE_TYPE]*/void r1067copy_from(T1067 C,T1067 a1,T2 a2);
/*NATIVE_ARRAY[LIVE_TYPE]*/void r1067clear(T1067 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LIVE_TYPE]*/void r1067clear_all(T1067 C,T2 a1);
/*NATIVE_ARRAY[LIVE_TYPE]*/void r1067copy_slice_from(T1067 C,T1067 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]]*/void r1070clear_all(T1070 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[INTEGER_16,HASHED_STRING]]*/void r1073clear_all(T1073 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[HASHED_STRING]]*/void r1074clear_all(T1074 C,T2 a1);
/*NATIVE_ARRAY[POSITION]*/T1082 r1082realloc(T1082 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[POSITION]*/void r1082copy_from(T1082 C,T1082 a1,T2 a2);
/*NATIVE_ARRAY[POSITION]*/T1082 r1082calloc(T1082 C,T2 a1);
/*NATIVE_ARRAY[POSITION]*/void r1082clear(T1082 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[POSITION]*/void r1082clear_all(T1082 C,T2 a1);
/*NATIVE_ARRAY[POSITION]*/void r1082slice_copy(T1082 C,T2 a1,T1082 a2,T2 a3,T2 a4);
/*NATIVE_ARRAY[POSITION]*/void r1082copy_slice_from(T1082 C,T1082 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[TAGGED_ERROR]*/T1083 r1083realloc(T1083 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TAGGED_ERROR]*/void r1083copy_from(T1083 C,T1083 a1,T2 a2);
/*NATIVE_ARRAY[TAGGED_ERROR]*/void r1083clear(T1083 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TAGGED_ERROR]*/void r1083clear_all(T1083 C,T2 a1);
/*NATIVE_ARRAY[TAGGED_ERROR]*/void r1083copy_slice_from(T1083 C,T1083 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FAST_ARRAY[FIXED_STRING],INTEGER_32]]*/void r1085clear_all(T1085 C,T2 a1);
/*NATIVE_ARRAY[FIXED_STRING]*/T1088 r1088realloc(T1088 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FIXED_STRING]*/T2 r1088fast_index_of(T1088 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FIXED_STRING]*/void r1088copy_from(T1088 C,T1088 a1,T2 a2);
/*NATIVE_ARRAY[FIXED_STRING]*/T6 r1088safe_equal(T0*a1,T0*a2);
/*NATIVE_ARRAY[FIXED_STRING]*/void r1088clear(T1088 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FIXED_STRING]*/void r1088clear_all(T1088 C,T2 a1);
/*NATIVE_ARRAY[FIXED_STRING]*/void r1088remove(T1088 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FIXED_STRING]*/T2 r1088first_index_of(T1088 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[FIXED_STRING]*/void r1088copy_slice_from(T1088 C,T1088 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CECIL_FILE,STRING]]*/void r1092clear_all(T1092 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]]*/void r1100clear_all(T1100 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_NAME]*/T1103 r1103realloc(T1103 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_NAME]*/void r1103copy_from(T1103 C,T1103 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_NAME]*/void r1103clear(T1103 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_NAME]*/void r1103clear_all(T1103 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_NAME]*/void r1103copy_slice_from(T1103 C,T1103 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CLASSES]*/T1104 r1104realloc(T1104 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLASSES]*/void r1104copy_from(T1104 C,T1104 a1,T2 a2);
/*NATIVE_ARRAY[CLASSES]*/void r1104clear(T1104 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLASSES]*/void r1104clear_all(T1104 C,T2 a1);
/*NATIVE_ARRAY[CLASSES]*/void r1104copy_slice_from(T1104 C,T1104 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLASSES,STRING]]*/void r1114clear_all(T1114 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FAST_ARRAY[STRING],CLASS_NAME]]*/void r1117clear_all(T1117 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[CLASS_NAME]]*/void r1118clear_all(T1118 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[INTEGER_32,CLASS_NAME]]*/void r1123clear_all(T1123 C,T2 a1);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/T1125 r1125realloc(T1125 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/void r1125copy_from(T1125 C,T1125 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/void r1125clear(T1125 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/void r1125clear_all(T1125 C,T2 a1);
/*NATIVE_ARRAY[FORMAL_ARG_LIST]*/void r1125copy_slice_from(T1125 C,T1125 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[LOCAL_VAR_LIST]*/T1126 r1126realloc(T1126 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_VAR_LIST]*/void r1126copy_from(T1126 C,T1126 a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_VAR_LIST]*/void r1126clear(T1126 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_VAR_LIST]*/void r1126clear_all(T1126 C,T2 a1);
/*NATIVE_ARRAY[LOCAL_VAR_LIST]*/void r1126copy_slice_from(T1126 C,T1126 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FEATURE_TEXT]*/T1127 r1127realloc(T1127 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_TEXT]*/void r1127copy_from(T1127 C,T1127 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_TEXT]*/void r1127clear(T1127 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_TEXT]*/void r1127clear_all(T1127 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_TEXT]*/void r1127copy_slice_from(T1127 C,T1127 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[PARENT_EDGE]*/T1136 r1136realloc(T1136 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[PARENT_EDGE]*/T2 r1136fast_index_of(T1136 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r1136copy_from(T1136 C,T1136 a1,T2 a2);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r1136clear(T1136 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r1136clear_all(T1136 C,T2 a1);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r1136remove(T1136 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[PARENT_EDGE]*/void r1136copy_slice_from(T1136 C,T1136 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[EXPRESSION]*/T1137 r1137realloc(T1137 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXPRESSION]*/void r1137copy_from(T1137 C,T1137 a1,T2 a2);
/*NATIVE_ARRAY[EXPRESSION]*/void r1137clear(T1137 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXPRESSION]*/void r1137clear_all(T1137 C,T2 a1);
/*NATIVE_ARRAY[EXPRESSION]*/void r1137copy_slice_from(T1137 C,T1137 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[TMP_FEATURE]*/T1138 r1138realloc(T1138 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TMP_FEATURE]*/void r1138copy_from(T1138 C,T1138 a1,T2 a2);
/*NATIVE_ARRAY[TMP_FEATURE]*/void r1138clear(T1138 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TMP_FEATURE]*/void r1138clear_all(T1138 C,T2 a1);
/*NATIVE_ARRAY[TMP_FEATURE]*/void r1138copy_slice_from(T1138 C,T1138 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[ARGUMENT_NAME_DEF]*/T1139 r1139realloc(T1139 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ARGUMENT_NAME_DEF]*/void r1139copy_from(T1139 C,T1139 a1,T2 a2);
/*NATIVE_ARRAY[ARGUMENT_NAME_DEF]*/void r1139set_slice_with(T1139 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[ARGUMENT_NAME_DEF]*/void r1139clear_all(T1139 C,T2 a1);
/*NATIVE_ARRAY[ARGUMENT_NAME_DEF]*/void r1139set_all_with(T1139 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[ARGUMENT_NAME_DEF]*/void r1139copy_slice_from(T1139 C,T1139 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[LOCAL_ARGUMENT_DEF]*/void r1140set_slice_with(T1140 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[LOCAL_ARGUMENT_DEF]*/void r1140clear_all(T1140 C,T2 a1);
/*NATIVE_ARRAY[LOCAL_ARGUMENT_DEF]*/void r1140set_all_with(T1140 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[DECLARATION]*/T1141 r1141realloc(T1141 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DECLARATION]*/void r1141copy_from(T1141 C,T1141 a1,T2 a2);
/*NATIVE_ARRAY[DECLARATION]*/void r1141set_slice_with(T1141 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[DECLARATION]*/void r1141clear_all(T1141 C,T2 a1);
/*NATIVE_ARRAY[DECLARATION]*/void r1141set_all_with(T1141 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[DECLARATION]*/void r1141copy_slice_from(T1141 C,T1141 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[ASSERTION]*/T1143 r1143realloc(T1143 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ASSERTION]*/void r1143copy_from(T1143 C,T1143 a1,T2 a2);
/*NATIVE_ARRAY[ASSERTION]*/void r1143clear(T1143 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ASSERTION]*/void r1143clear_all(T1143 C,T2 a1);
/*NATIVE_ARRAY[ASSERTION]*/void r1143copy_slice_from(T1143 C,T1143 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[LOCAL_NAME_DEF]*/T1144 r1144realloc(T1144 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_NAME_DEF]*/void r1144copy_from(T1144 C,T1144 a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_NAME_DEF]*/void r1144set_slice_with(T1144 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[LOCAL_NAME_DEF]*/void r1144clear_all(T1144 C,T2 a1);
/*NATIVE_ARRAY[LOCAL_NAME_DEF]*/void r1144set_all_with(T1144 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[LOCAL_NAME_DEF]*/void r1144copy_slice_from(T1144 C,T1144 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[MANIFEST_STRING]*/T1145 r1145realloc(T1145 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[MANIFEST_STRING]*/void r1145copy_from(T1145 C,T1145 a1,T2 a2);
/*NATIVE_ARRAY[MANIFEST_STRING]*/void r1145clear(T1145 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[MANIFEST_STRING]*/void r1145clear_all(T1145 C,T2 a1);
/*NATIVE_ARRAY[MANIFEST_STRING]*/void r1145copy_slice_from(T1145 C,T1145 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/T1147 r1147realloc(T1147 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/void r1147copy_from(T1147 C,T1147 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/void r1147clear(T1147 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/void r1147clear_all(T1147 C,T2 a1);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/void r1147remove(T1147 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_CLAUSE]*/void r1147copy_slice_from(T1147 C,T1147 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[EXPORT_ITEM]*/T1155 r1155realloc(T1155 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXPORT_ITEM]*/void r1155copy_from(T1155 C,T1155 a1,T2 a2);
/*NATIVE_ARRAY[EXPORT_ITEM]*/void r1155set_slice_with(T1155 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[EXPORT_ITEM]*/void r1155clear_all(T1155 C,T2 a1);
/*NATIVE_ARRAY[EXPORT_ITEM]*/void r1155set_all_with(T1155 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[EXPORT_ITEM]*/void r1155copy_slice_from(T1155 C,T1155 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_SET_NODE[LIVE_TYPE]]*/void r1156clear_all(T1156 C,T2 a1);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/T1159 r1159realloc(T1159 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/T2 r1159fast_index_of(T1159 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/void r1159copy_from(T1159 C,T1159 a1,T2 a2);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/void r1159clear(T1159 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/void r1159clear_all(T1159 C,T2 a1);
/*NATIVE_ARRAY[EXTERNAL_ROUTINE]*/void r1159copy_slice_from(T1159 C,T1159 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTEGER_64]*/T1160 r1160realloc(T1160 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_64]*/void r1160copy_from(T1160 C,T1160 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_64]*/void r1160clear(T1160 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_64]*/void r1160clear_all(T1160 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_64]*/void r1160copy_slice_from(T1160 C,T1160 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[INTEGER_8,CLASS_TEXT]]*/void r1161clear_all(T1161 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TAGGED_DATA,FIXED_STRING]]*/void r1164clear_all(T1164 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_NAME]]*/void r1171clear_all(T1171 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_STAMP]]*/void r1174clear_all(T1174 C,T2 a1);
/*NATIVE_ARRAY[TYPE]*/T1175 r1175realloc(T1175 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/T2 r1175fast_index_of(T1175 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[TYPE]*/void r1175copy_from(T1175 C,T1175 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/void r1175clear(T1175 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/void r1175set_slice_with(T1175 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[TYPE]*/void r1175clear_all(T1175 C,T2 a1);
/*NATIVE_ARRAY[TYPE]*/void r1175remove(T1175 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/void r1175set_all_with(T1175 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[TYPE]*/void r1175copy_slice_from(T1175 C,T1175 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[RUN_FEATURE]*/T1177 r1177realloc(T1177 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE]*/T2 r1177fast_index_of(T1177 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[RUN_FEATURE]*/void r1177copy_from(T1177 C,T1177 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE]*/void r1177clear(T1177 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE]*/void r1177clear_all(T1177 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE]*/void r1177copy_slice_from(T1177 C,T1177 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/T1178 r1178realloc(T1178 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/void r1178copy_from(T1178 C,T1178 a1,T2 a2);
/*NATIVE_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/void r1178clear_all(T1178 C,T2 a1);
/*NATIVE_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/void r1178copy_slice_from(T1178 C,T1178 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/T1179 r1179realloc(T1179 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/T2 r1179fast_index_of(T1179 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/void r1179copy_from(T1179 C,T1179 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/void r1179clear(T1179 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/void r1179clear_all(T1179 C,T2 a1);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE]*/void r1179copy_slice_from(T1179 C,T1179 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[GRAPH_NODE,TYPE]]*/void r1181clear_all(T1181 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[TYPE]]*/void r1184clear_all(T1184 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[INTEGER_8,TYPE]]*/void r1187clear_all(T1187 C,T2 a1);
/*NATIVE_ARRAY[HASHED_BIJECTIVE_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]]*/void r1194clear_all(T1194 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[RUN_FEATURE,TYPE]]*/void r1200clear_all(T1200 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_STAMP]*/T1201 r1201realloc(T1201 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_STAMP]*/T2 r1201fast_index_of(T1201 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r1201copy_from(T1201 C,T1201 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r1201clear(T1201 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r1201set_slice_with(T1201 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r1201clear_all(T1201 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r1201set_all_with(T1201 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_STAMP]*/void r1201copy_slice_from(T1201 C,T1201 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/T1202 r1202realloc(T1202 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/void r1202copy_from(T1202 C,T1202 a1,T2 a2);
/*NATIVE_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/void r1202clear(T1202 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/void r1202clear_all(T1202 C,T2 a1);
/*NATIVE_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/void r1202copy_slice_from(T1202 C,T1202 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_SET_NODE[STRING]]*/void r1203clear_all(T1203 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[MANIFEST_STRING,STRING]]*/void r1208clear_all(T1208 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[MANIFEST_STRING,MANIFEST_STRING]]*/void r1211clear_all(T1211 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[MANIFEST_GENERIC]]*/void r1212clear_all(T1212 C,T2 a1);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/T1215 r1215realloc(T1215 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/T2 r1215fast_index_of(T1215 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/void r1215copy_from(T1215 C,T1215 a1,T2 a2);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/void r1215clear(T1215 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/void r1215clear_all(T1215 C,T2 a1);
/*NATIVE_ARRAY[NON_VOID_NO_DISPATCH]*/void r1215copy_slice_from(T1215 C,T1215 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FAST_ARRAY[AGENT_CREATION],TYPE]]*/void r1217clear_all(T1217 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[AGENT_ARGS]]*/void r1219clear_all(T1219 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[HASHED_SET[TYPE],TYPE]]*/void r1223clear_all(T1223 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/T1225 r1225realloc(T1225 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/void r1225copy_from(T1225 C,T1225 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/void r1225clear(T1225 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/void r1225clear_all(T1225 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET[TYPE]]*/void r1225copy_slice_from(T1225 C,T1225 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FAST_ARRAY[CODE]]*/T1226 r1226realloc(T1226 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE]]*/void r1226copy_from(T1226 C,T1226 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE]]*/void r1226clear(T1226 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE]]*/void r1226clear_all(T1226 C,T2 a1);
/*NATIVE_ARRAY[FAST_ARRAY[CODE]]*/void r1226copy_slice_from(T1226 C,T1226 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CODE]*/T1227 r1227realloc(T1227 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CODE]*/void r1227copy_from(T1227 C,T1227 a1,T2 a2);
/*NATIVE_ARRAY[CODE]*/void r1227clear(T1227 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CODE]*/void r1227clear_all(T1227 C,T2 a1);
/*NATIVE_ARRAY[CODE]*/void r1227copy_slice_from(T1227 C,T1227 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]]*/void r1228clear_all(T1228 C,T2 a1);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/T1231 r1231realloc(T1231 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1231copy_from(T1231 C,T1231 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1231clear(T1231 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1231clear_all(T1231 C,T2 a1);
/*NATIVE_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1231copy_slice_from(T1231 C,T1231 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]]*/void r1235clear_all(T1235 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[ABSOLUTE_FEATURE_NAME]]*/void r1236clear_all(T1236 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]]*/void r1241clear_all(T1241 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,TYPE]]*/void r1244clear_all(T1244 C,T2 a1);
/*NATIVE_ARRAY[ARRAY[INTEGER_8]]*/void r1245set_slice_with(T1245 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[ARRAY[INTEGER_8]]*/void r1245clear_all(T1245 C,T2 a1);
/*NATIVE_ARRAY[ARRAY[INTEGER_8]]*/void r1245set_all_with(T1245 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_8]*/void r1246set_slice_with(T1246 C,T1 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTEGER_8]*/void r1246clear_all(T1246 C,T2 a1);
/*NATIVE_ARRAY[INTEGER_8]*/void r1246set_all_with(T1246 C,T1 a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]]*/void r1249clear_all(T1249 C,T2 a1);
/*NATIVE_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/T1251 r1251realloc(T1251 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/void r1251copy_from(T1251 C,T1251 a1,T2 a2);
/*NATIVE_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/T6 r1251safe_equal(T0*a1,T0*a2);
/*NATIVE_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/void r1251clear_all(T1251 C,T2 a1);
/*NATIVE_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/T2 r1251first_index_of(T1251 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/void r1251copy_slice_from(T1251 C,T1251 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[ABSTRACT_STRING]*/T1252 r1252realloc(T1252 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ABSTRACT_STRING]*/void r1252copy_from(T1252 C,T1252 a1,T2 a2);
/*NATIVE_ARRAY[ABSTRACT_STRING]*/void r1252clear(T1252 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ABSTRACT_STRING]*/void r1252clear_all(T1252 C,T2 a1);
/*NATIVE_ARRAY[ABSTRACT_STRING]*/void r1252copy_slice_from(T1252 C,T1252 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CECIL_ENTRY]*/T1258 r1258realloc(T1258 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CECIL_ENTRY]*/void r1258copy_from(T1258 C,T1258 a1,T2 a2);
/*NATIVE_ARRAY[CECIL_ENTRY]*/void r1258clear(T1258 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CECIL_ENTRY]*/void r1258clear_all(T1258 C,T2 a1);
/*NATIVE_ARRAY[CECIL_ENTRY]*/void r1258copy_slice_from(T1258 C,T1258 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[SE_CONFIG]*/T1260 r1260realloc(T1260 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[SE_CONFIG]*/void r1260copy_from(T1260 C,T1260 a1,T2 a2);
/*NATIVE_ARRAY[SE_CONFIG]*/void r1260set_slice_with(T1260 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[SE_CONFIG]*/void r1260clear_all(T1260 C,T2 a1);
/*NATIVE_ARRAY[SE_CONFIG]*/void r1260set_all_with(T1260 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[SE_CONFIG]*/void r1260copy_slice_from(T1260 C,T1260 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[STRING_RECYCLING_ITEM]*/T1261 r1261realloc(T1261 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING_RECYCLING_ITEM]*/void r1261copy_from(T1261 C,T1261 a1,T2 a2);
/*NATIVE_ARRAY[STRING_RECYCLING_ITEM]*/void r1261clear_all(T1261 C,T2 a1);
/*NATIVE_ARRAY[STRING_RECYCLING_ITEM]*/void r1261slice_copy(T1261 C,T2 a1,T1261 a2,T2 a3,T2 a4);
/*NATIVE_ARRAY[STRING_RECYCLING_ITEM]*/void r1261copy_slice_from(T1261 C,T1261 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[SE_C_MODE,STRING]]*/void r1264clear_all(T1264 C,T2 a1);
/*NATIVE_ARRAY[PROCEDURE[TUPLE]]*/void r1266set_slice_with(T1266 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[PROCEDURE[TUPLE]]*/void r1266clear_all(T1266 C,T2 a1);
/*NATIVE_ARRAY[PROCEDURE[TUPLE]]*/void r1266set_all_with(T1266 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[ORDERED_DICTIONARY[STRING,STRING],STRING]]*/void r1267clear_all(T1267 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLUSTER,STRING]]*/void r1274clear_all(T1274 C,T2 a1);
/*NATIVE_ARRAY[TEXT_FILE_READ]*/void r1276clear_all(T1276 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TEXT_FILE_READ,STRING]]*/void r1279clear_all(T1279 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLUSTER_CLASS,HASHED_STRING]]*/void r1280clear_all(T1280 C,T2 a1);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/T1284 r1284realloc(T1284 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/void r1284copy_from(T1284 C,T1284 a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/void r1284set_slice_with(T1284 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/void r1284clear_all(T1284 C,T2 a1);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/void r1284set_all_with(T1284 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[FORMAL_GENERIC_ARG]*/void r1284copy_slice_from(T1284 C,T1284 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TYPE_MARK,TYPE]]*/void r1287clear_all(T1287 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[FEATURE_STAMP,TYPE]]*/void r1290clear_all(T1290 C,T2 a1);
/*NATIVE_ARRAY[REQUIRE_ASSERTION]*/T1292 r1292realloc(T1292 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[REQUIRE_ASSERTION]*/void r1292copy_from(T1292 C,T1292 a1,T2 a2);
/*NATIVE_ARRAY[REQUIRE_ASSERTION]*/void r1292clear(T1292 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[REQUIRE_ASSERTION]*/void r1292clear_all(T1292 C,T2 a1);
/*NATIVE_ARRAY[REQUIRE_ASSERTION]*/void r1292copy_slice_from(T1292 C,T1292 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[IFTHEN]*/T1293 r1293realloc(T1293 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN]*/void r1293copy_from(T1293 C,T1293 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN]*/void r1293clear(T1293 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN]*/void r1293clear_all(T1293 C,T2 a1);
/*NATIVE_ARRAY[IFTHEN]*/void r1293remove(T1293 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN]*/void r1293remove_first(T1293 C,T2 a1);
/*NATIVE_ARRAY[IFTHEN]*/void r1293copy_slice_from(T1293 C,T1293 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[WHEN_ITEM]*/T1294 r1294realloc(T1294 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_ITEM]*/void r1294copy_from(T1294 C,T1294 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_ITEM]*/void r1294clear(T1294 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[WHEN_ITEM]*/void r1294clear_all(T1294 C,T2 a1);
/*NATIVE_ARRAY[WHEN_ITEM]*/void r1294copy_slice_from(T1294 C,T1294 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INSTRUCTION]*/T1295 r1295realloc(T1295 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INSTRUCTION]*/void r1295copy_from(T1295 C,T1295 a1,T2 a2);
/*NATIVE_ARRAY[INSTRUCTION]*/void r1295clear(T1295 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INSTRUCTION]*/void r1295clear_all(T1295 C,T2 a1);
/*NATIVE_ARRAY[INSTRUCTION]*/void r1295remove_first(T1295 C,T2 a1);
/*NATIVE_ARRAY[INSTRUCTION]*/void r1295copy_slice_from(T1295 C,T1295 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[OPEN_OPERAND]*/T1296 r1296realloc(T1296 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[OPEN_OPERAND]*/void r1296copy_from(T1296 C,T1296 a1,T2 a2);
/*NATIVE_ARRAY[OPEN_OPERAND]*/void r1296clear(T1296 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[OPEN_OPERAND]*/void r1296clear_all(T1296 C,T2 a1);
/*NATIVE_ARRAY[OPEN_OPERAND]*/void r1296copy_slice_from(T1296 C,T1296 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CLOSED_OPERAND]*/T1297 r1297realloc(T1297 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLOSED_OPERAND]*/void r1297copy_from(T1297 C,T1297 a1,T2 a2);
/*NATIVE_ARRAY[CLOSED_OPERAND]*/void r1297clear(T1297 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CLOSED_OPERAND]*/void r1297clear_all(T1297 C,T2 a1);
/*NATIVE_ARRAY[CLOSED_OPERAND]*/void r1297copy_slice_from(T1297 C,T1297 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[IFTHEN_EXP]*/T1298 r1298realloc(T1298 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN_EXP]*/void r1298copy_from(T1298 C,T1298 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN_EXP]*/void r1298clear(T1298 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN_EXP]*/void r1298clear_all(T1298 C,T2 a1);
/*NATIVE_ARRAY[IFTHEN_EXP]*/void r1298remove(T1298 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[IFTHEN_EXP]*/void r1298remove_first(T1298 C,T2 a1);
/*NATIVE_ARRAY[IFTHEN_EXP]*/void r1298copy_slice_from(T1298 C,T1298 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[CLIENT_LIST,FEATURE_NAME]]*/void r1301clear_all(T1301 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/T1302 r1302realloc(T1302 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/void r1302copy_from(T1302 C,T1302 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/void r1302clear(T1302 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/void r1302clear_all(T1302 C,T2 a1);
/*NATIVE_ARRAY[FEATURE_CLAUSE]*/void r1302copy_slice_from(T1302 C,T1302 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/T1303 r1303realloc(T1303 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/void r1303copy_from(T1303 C,T1303 a1,T2 a2);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/void r1303clear(T1303 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/void r1303clear_all(T1303 C,T2 a1);
/*NATIVE_ARRAY[CREATION_CLAUSE]*/void r1303copy_slice_from(T1303 C,T1303 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[EXPRESSION,TYPE]]*/void r1305clear_all(T1305 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]]*/void r1307clear_all(T1307 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/T1310 r1310realloc(T1310 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1310copy_from(T1310 C,T1310 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1310clear(T1310 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1310set_slice_with(T1310 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1310clear_all(T1310 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1310set_all_with(T1310 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_2]*/void r1310copy_slice_from(T1310 C,T1310 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/T1311 r1311realloc(T1311 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/void r1311copy_from(T1311 C,T1311 a1,T2 a2);
/*NATIVE_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/void r1311clear(T1311 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/void r1311clear_all(T1311 C,T2 a1);
/*NATIVE_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/void r1311copy_slice_from(T1311 C,T1311 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]]*/void r1314clear_all(T1314 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[GRAPH_NODE]]*/void r1317clear_all(T1317 C,T2 a1);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/T1323 r1323realloc(T1323 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/void r1323copy_from(T1323 C,T1323 a1,T2 a2);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/void r1323clear(T1323 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/void r1323clear_all(T1323 C,T2 a1);
/*NATIVE_ARRAY[INDEX_CLAUSE]*/void r1323copy_slice_from(T1323 C,T1323 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[RENAME_PAIR]*/T1324 r1324realloc(T1324 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RENAME_PAIR]*/void r1324copy_from(T1324 C,T1324 a1,T2 a2);
/*NATIVE_ARRAY[RENAME_PAIR]*/void r1324clear(T1324 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RENAME_PAIR]*/void r1324clear_all(T1324 C,T2 a1);
/*NATIVE_ARRAY[RENAME_PAIR]*/void r1324copy_slice_from(T1324 C,T1324 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[PROCESS_POSIX,INTEGER_32]]*/void r1326clear_all(T1326 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[PROCESS_WIN32,INTEGER_32]]*/void r1329clear_all(T1329 C,T2 a1);
/*NATIVE_ARRAY[AGENT_CREATION]*/T1358 r1358realloc(T1358 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AGENT_CREATION]*/T2 r1358fast_index_of(T1358 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[AGENT_CREATION]*/void r1358copy_from(T1358 C,T1358 a1,T2 a2);
/*NATIVE_ARRAY[AGENT_CREATION]*/void r1358clear(T1358 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AGENT_CREATION]*/void r1358clear_all(T1358 C,T2 a1);
/*NATIVE_ARRAY[AGENT_CREATION]*/void r1358copy_slice_from(T1358 C,T1358 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TUPLE[TYPE,TYPE],TYPE]]*/void r1362clear_all(T1362 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TYPE,TYPE]]*/void r1366clear_all(T1366 C,T2 a1);
/*NATIVE_ARRAY[HASHED_SET_NODE[NATIVE_PLUG_IN]]*/void r1368clear_all(T1368 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[DICTIONARY[PLUGIN,STRING],STRING]]*/void r1373clear_all(T1373 C,T2 a1);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[PLUGIN,STRING]]*/void r1376clear_all(T1376 C,T2 a1);
/*NATIVE_ARRAY[INLINE_MEMO]*/T1377 r1377realloc(T1377 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INLINE_MEMO]*/void r1377copy_from(T1377 C,T1377 a1,T2 a2);
/*NATIVE_ARRAY[INLINE_MEMO]*/void r1377clear(T1377 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INLINE_MEMO]*/void r1377clear_all(T1377 C,T2 a1);
/*NATIVE_ARRAY[INLINE_MEMO]*/void r1377copy_slice_from(T1377 C,T1377 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FAST_ARRAY[E_OLD]]*/T1381 r1381realloc(T1381 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[E_OLD]]*/void r1381copy_from(T1381 C,T1381 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[E_OLD]]*/void r1381clear(T1381 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[E_OLD]]*/void r1381clear_all(T1381 C,T2 a1);
/*NATIVE_ARRAY[FAST_ARRAY[E_OLD]]*/void r1381copy_slice_from(T1381 C,T1381 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[E_OLD]*/T1382 r1382realloc(T1382 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[E_OLD]*/void r1382copy_from(T1382 C,T1382 a1,T2 a2);
/*NATIVE_ARRAY[E_OLD]*/void r1382clear(T1382 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[E_OLD]*/void r1382clear_all(T1382 C,T2 a1);
/*NATIVE_ARRAY[E_OLD]*/void r1382copy_slice_from(T1382 C,T1382 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_SET_NODE[FEATURE_STAMP]]*/void r1383clear_all(T1383 C,T2 a1);
/*NATIVE_ARRAY[ADDRESS_OF]*/T1386 r1386realloc(T1386 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ADDRESS_OF]*/void r1386copy_from(T1386 C,T1386 a1,T2 a2);
/*NATIVE_ARRAY[ADDRESS_OF]*/void r1386clear(T1386 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ADDRESS_OF]*/void r1386clear_all(T1386 C,T2 a1);
/*NATIVE_ARRAY[ADDRESS_OF]*/void r1386copy_slice_from(T1386 C,T1386 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[POINTER]*/void r1387clear_all(T1387 C,T2 a1);
/*NATIVE_ARRAY[AVL_SET_NODE[POSITION]]*/void r1388clear(T1388 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AVL_SET_NODE[POSITION]]*/void r1388clear_all(T1388 C,T2 a1);
/*NATIVE_ARRAY[LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]]*/void r1402clear_all(T1402 C,T2 a1);
/*NATIVE_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/T1403 r1403realloc(T1403 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1403copy_from(T1403 C,T1403 a1,T2 a2);
/*NATIVE_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1403clear(T1403 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1403clear_all(T1403 C,T2 a1);
/*NATIVE_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1403copy_slice_from(T1403 C,T1403 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]]*/void r1406clear_all(T1406 C,T2 a1);
/*NATIVE_ARRAY[CODE_CONTEXT]*/T1439 r1439realloc(T1439 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CODE_CONTEXT]*/void r1439copy_from(T1439 C,T1439 a1,T2 a2);
/*NATIVE_ARRAY[CODE_CONTEXT]*/void r1439clear(T1439 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CODE_CONTEXT]*/void r1439clear_all(T1439 C,T2 a1);
/*NATIVE_ARRAY[CODE_CONTEXT]*/void r1439copy_slice_from(T1439 C,T1439 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/T1440 r1440realloc(T1440 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1440copy_from(T1440 C,T1440 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1440move(T1440 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1440clear(T1440 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1440set_slice_with(T1440 C,T0*a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1440clear_all(T1440 C,T2 a1);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1440set_all_with(T1440 C,T0*a1,T2 a2);
/*NATIVE_ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1440copy_slice_from(T1440 C,T1440 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/T1441 r1441realloc(T1441 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/void r1441copy_from(T1441 C,T1441 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/void r1441clear(T1441 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/void r1441clear_all(T1441 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE_6]*/void r1441copy_slice_from(T1441 C,T1441 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[AGENT_ARGS,STRING]]*/void r1443clear_all(T1443 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/T1445 r1445realloc(T1445 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/void r1445copy_from(T1445 C,T1445 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/void r1445clear(T1445 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/void r1445clear_all(T1445 C,T2 a1);
/*NATIVE_ARRAY[RUN_FEATURE_5]*/void r1445copy_slice_from(T1445 C,T1445 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/T1446 r1446realloc(T1446 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/void r1446copy_from(T1446 C,T1446 a1,T2 a2);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/void r1446clear(T1446 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/void r1446clear_all(T1446 C,T2 a1);
/*NATIVE_ARRAY[INTERNAL_C_LOCAL]*/void r1446copy_slice_from(T1446 C,T1446 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[HASHED_DICTIONARY_NODE[TAGGED_INTEGER,INTEGER_32]]*/void r1465clear_all(T1465 C,T2 a1);
/*STRING*/T2 r7first_index_of(T7*C,T3 a1);
/*STRING*/T0*r7out(T7*C);
/*STRING*/void r7copy(T7*C,T0*a1);
/*STRING*/T0*r7substring(T7*C,T2 a1,T2 a2);
/*STRING*/T2 r7occurrences(T7*C,T3 a1);
/*STRING*/T0*r7standard_twin(T7*C);
/*STRING*/void r7remove_prefix(T7*C,T0*a1);
/*STRING*/T2 r7reverse_index_of(T7*C,T3 a1,T2 a2);
/*STRING*/T0*r7intern(T7*C);
/*STRING*/void r7lock_tagged_out(void);
/*STRING*/void r7remove_first(T7*C);
/*STRING*/T3 r7last(T7*C);
/*STRING*/T2 r7first_substring_index(T7*C,T0*a1);
/*STRING*/void r7remove_suffix(T7*C,T0*a1);
/*STRING*/T2 r7upper(T7*C);
/*STRING*/void r7put(T7*C,T3 a1,T2 a2);
/*STRING*/void r7unlock_tagged_out(void);
/*STRING*/void r7remove_between(T7*C,T2 a1,T2 a2);
/*STRING*/T6 r7is_equal(T7*C,T0*a1);
/*STRING*/T0*r7_ix_35(T7*C,T0*a1);
/*STRING*/void r7insert_character(T7*C,T3 a1,T2 a2);
extern T0*oBC40interned;
extern int fBC40interned;
/*STRING*/T0*r7interned(void);
/*STRING*/T3 r7item(T7*C,T2 a1);
extern T0*oBC40string_buffer;
extern int fBC40string_buffer;
/*STRING*/T0*r7string_buffer(void);
/*STRING*/T0*r7_ix_43(T7*C,T0*a1);
extern T0*oBC40split_buffer;
extern int fBC40split_buffer;
/*STRING*/T0*r7split_buffer(void);
/*STRING*/T0*r7split(T7*C);
/*STRING*/T6 r7valid_index(T7*C,T2 a1);
extern T0*oBC17tagged_out_memory_pool;
extern int fBC17tagged_out_memory_pool;
/*STRING*/T0*r7tagged_out_memory_pool(void);
/*STRING*/void r7append(T7*C,T0*a1);
/*STRING*/void r7print_on(T7*C,T0*a1);
/*STRING*/T6 r7_ix_60(T7*C,T0*a1);
/*STRING*/void r7replacing_in(T7*C,T0*a1,T0*a2,T0*a3);
/*STRING*/void r7make_from_string(T7*C,T0*a1);
/*STRING*/T6 r7has_substring(T7*C,T0*a1);
/*STRING*/void r7copy_slice_to_native(T7*C,T2 a1,T2 a2,T9 a3,T2 a4);
/*STRING*/T2 r7index_of(T7*C,T3 a1,T2 a2);
/*STRING*/void r7out_in_tagged_out_memory(T7*C);
/*STRING*/void r7make_empty(T7*C);
/*STRING*/void r7slice_copy(T7*C,T2 a1,T0*a2,T2 a3,T2 a4);
/*STRING*/T6 r7has_suffix(T7*C,T0*a1);
/*STRING*/T6 r7is_integer(T7*C);
/*STRING*/void r7remove_tail(T7*C,T2 a1);
/*STRING*/void r7make(T7*C,T2 a1);
/*STRING*/T6 r7has_prefix(T7*C,T0*a1);
/*STRING*/void r7clear_count(T7*C);
/*STRING*/void r7append_string(T7*C,T0*a1);
/*STRING*/void r7make_filled(T7*C,T3 a1,T2 a2);
/*STRING*/void r7remove(T7*C,T2 a1);
/*STRING*/void r7append_substring(T7*C,T0*a1,T2 a2,T2 a3);
extern T0*oBC17tagged_out_memories;
extern int fBC17tagged_out_memories;
/*STRING*/T0*r7tagged_out_memories(void);
/*STRING*/void r7from_external_sized(T7*C,T8 a1,T2 a2);
/*STRING*/void r7extend(T7*C,T3 a1);
/*STRING*/void r7remove_last(T7*C);
/*STRING*/T6 r7has(T7*C,T3 a1);
/*STRING*/void r7keep_head(T7*C,T2 a1);
/*STRING*/T2 r7to_integer(T7*C);
extern T0*oBC17tagged_out_memory_ref;
/*STRING*/void r7fill_with(T7*C,T3 a1);
/*STRING*/T6 r7same_as(T7*C,T0*a1);
/*STRING*/void r7extend_unless(T7*C,T3 a1);
/*STRING*/void r7add_last(T7*C,T3 a1);
/*STRING*/T3 r7first(T7*C);
/*STRING*/void r7shrink(T7*C,T2 a1,T2 a2);
/*STRING*/void r7resize(T7*C,T2 a1);
/*STRING*/void r7to_upper(T7*C);
/*STRING*/T2 r7substring_index(T7*C,T0*a1,T2 a2);
/*STRING*/void r7ensure_capacity(T7*C,T2 a1);
/*STRING*/void r7from_external_copy(T7*C,T8 a1);
/*STRING*/T2 r7computed_hash_code(T7*C);
/*STRING*/T6 r7is_integer_64(T7*C);
/*STRING*/T8 r7to_external(T7*C);
/*STRING*/void r7extend_multiple(T7*C,T3 a1,T2 a2);
/*STRING*/void r7to_lower(T7*C);
/*STRING*/T2 r7last_index_of(T7*C,T3 a1);
/*STRING*/T0*r7twin(T7*C);
/*STRING*/void r7from_external_sized_copy(T7*C,T8 a1,T2 a2);
/*STRING*/void r7with_capacity(T7*C,T2 a1);
/*STRING*/void r7extend_to_count(T7*C,T3 a1,T2 a2);
/*STRING*/void r7remove_head(T7*C,T2 a1);
/*STRING*/void r7next_generation(T7*C);
/*STRING*/T11 r7to_integer_64(T7*C);
/*STRING*/void r7split_in(T7*C,T0*a1);
/*STRING*/void r7swap(T7*C,T2 a1,T2 a2);
/*FAST_ARRAY[STRING]*/void r909swap(T909*C,T2 a1,T2 a2);
/*FAST_ARRAY[STRING]*/void r909make(T909*C,T2 a1);
/*FAST_ARRAY[STRING]*/void r909put(T909*C,T0*a1,T2 a2);
/*FAST_ARRAY[STRING]*/void r909manifest_put(T909*C,T2 a1,T0*a2);
/*FAST_ARRAY[STRING]*/void r909add(T909*C,T0*a1,T2 a2);
/*FAST_ARRAY[STRING]*/void r909move(T909*C,T2 a1,T2 a2,T2 a3);
/*FAST_ARRAY[STRING]*/T0*r909new_iterator(T909*C);
/*FAST_ARRAY[STRING]*/T2 r909fast_first_index_of(T909*C,T0*a1);
/*FAST_ARRAY[STRING]*/void r909add_last(T909*C,T0*a1);
/*FAST_ARRAY[STRING]*/void r909clear_count(T909*C);
/*FAST_ARRAY[STRING]*/T6 r909is_empty(T909*C);
/*FAST_ARRAY[STRING]*/void r909manifest_make(T909*C,T2 a1);
/*FAST_ARRAY[STRING]*/T6 r909valid_index(T909*C,T2 a1);
/*FAST_ARRAY[STRING]*/T6 r909fast_has(T909*C,T0*a1);
/*FAST_ARRAY[STRING]*/void r909from_collection(T909*C,T0*a1);
/*FAST_ARRAY[STRING]*/T2 r909first_index_of(T909*C,T0*a1);
/*FAST_ARRAY[STRING]*/void r909with_capacity(T909*C,T2 a1);
/*FAST_ARRAY[STRING]*/void r909next_generation(T909*C);
/*FAST_ARRAY[STRING]*/T2 r909count(T909*C);
/*FAST_ARRAY[STRING]*/T6 r909has(T909*C,T0*a1);
/*FAST_ARRAY[HASHED_STRING]*/void r914add_last(T914*C,T0*a1);
/*FAST_ARRAY[HASHED_STRING]*/T2 r914fast_first_index_of(T914*C,T0*a1);
/*FAST_ARRAY[HASHED_STRING]*/T6 r914is_empty(T914*C);
/*FAST_ARRAY[HASHED_STRING]*/T6 r914valid_index(T914*C,T2 a1);
/*FAST_ARRAY[HASHED_STRING]*/T6 r914fast_has(T914*C,T0*a1);
/*FAST_ARRAY[HASHED_STRING]*/void r914with_capacity(T914*C,T2 a1);
/*FAST_ARRAY[HASHED_STRING]*/void r914next_generation(T914*C);
/*FAST_ARRAY[HASHED_STRING]*/T2 r914count(T914*C);
/*ARRAY[STRING]*/void r915swap(T915*C,T2 a1,T2 a2);
/*ARRAY[STRING]*/T0*r915first(T915*C);
/*ARRAY[STRING]*/void r915put(T915*C,T0*a1,T2 a2);
/*ARRAY[STRING]*/void r915ensure_capacity_and_bounds(T915*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[STRING]*/void r915add(T915*C,T0*a1,T2 a2);
/*ARRAY[STRING]*/void r915move(T915*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[STRING]*/void r915copy(T915*C,T0*a1);
/*ARRAY[STRING]*/void r915add_last(T915*C,T0*a1);
/*ARRAY[STRING]*/T0*r915item(T915*C,T2 a1);
/*ARRAY[STRING]*/void r915clear_all(T915*C);
/*ARRAY[STRING]*/void r915remove(T915*C,T2 a1);
/*ARRAY[STRING]*/void r915clear_count(T915*C);
/*ARRAY[STRING]*/T6 r915is_empty(T915*C);
/*ARRAY[STRING]*/T0*r915twin(T915*C);
/*ARRAY[STRING]*/void r915set_all_with(T915*C,T0*a1);
/*ARRAY[STRING]*/T6 r915valid_index(T915*C,T2 a1);
/*ARRAY[STRING]*/void r915with_capacity(T915*C,T2 a1,T2 a2);
/*ARRAY[STRING]*/void r915next_generation(T915*C);
/*ARRAY[STRING]*/T2 r915count(T915*C);
/*FAST_ARRAY[CLUSTER]*/void r916make(T916*C,T2 a1);
/*FAST_ARRAY[CLUSTER]*/T0*r916first(T916*C);
/*FAST_ARRAY[CLUSTER]*/void r916put(T916*C,T0*a1,T2 a2);
/*FAST_ARRAY[CLUSTER]*/void r916add(T916*C,T0*a1,T2 a2);
/*FAST_ARRAY[CLUSTER]*/void r916move(T916*C,T2 a1,T2 a2,T2 a3);
/*FAST_ARRAY[CLUSTER]*/void r916add_last(T916*C,T0*a1);
/*FAST_ARRAY[CLUSTER]*/void r916clear_count(T916*C);
/*FAST_ARRAY[CLUSTER]*/T6 r916is_empty(T916*C);
/*FAST_ARRAY[CLUSTER]*/void r916next_generation(T916*C);
/*FAST_ARRAY[CLUSTER]*/T2 r916count(T916*C);
/*FAST_ARRAY[INTEGER_32]*/void r921swap(T921*C,T2 a1,T2 a2);
/*FAST_ARRAY[INTEGER_32]*/void r921make(T921*C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/T2 r921first(T921*C);
/*FAST_ARRAY[INTEGER_32]*/void r921remove_last(T921*C);
/*FAST_ARRAY[INTEGER_32]*/void r921put(T921*C,T2 a1,T2 a2);
/*FAST_ARRAY[INTEGER_32]*/void r921add(T921*C,T2 a1,T2 a2);
/*FAST_ARRAY[INTEGER_32]*/void r921move(T921*C,T2 a1,T2 a2,T2 a3);
/*FAST_ARRAY[INTEGER_32]*/T2 r921last(T921*C);
/*FAST_ARRAY[INTEGER_32]*/T2 r921fast_first_index_of(T921*C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r921add_last(T921*C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r921remove(T921*C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r921clear_count(T921*C);
/*FAST_ARRAY[INTEGER_32]*/void r921set_all_with(T921*C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/T6 r921valid_index(T921*C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/T6 r921fast_has(T921*C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r921with_capacity(T921*C,T2 a1);
/*FAST_ARRAY[INTEGER_32]*/void r921next_generation(T921*C);
/*FAST_ARRAY[INTEGER_32]*/T2 r921count(T921*C);
/*ARRAY[TYPE_MARK]*/void r923make(T923*C,T2 a1,T2 a2);
/*ARRAY[TYPE_MARK]*/T0*r923first(T923*C);
/*ARRAY[TYPE_MARK]*/void r923put(T923*C,T0*a1,T2 a2);
/*ARRAY[TYPE_MARK]*/void r923ensure_capacity_and_bounds(T923*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[TYPE_MARK]*/void r923manifest_put(T923*C,T2 a1,T0*a2);
/*ARRAY[TYPE_MARK]*/void r923copy(T923*C,T0*a1);
/*ARRAY[TYPE_MARK]*/T0*r923last(T923*C);
/*ARRAY[TYPE_MARK]*/void r923add_last(T923*C,T0*a1);
/*ARRAY[TYPE_MARK]*/T0*r923item(T923*C,T2 a1);
/*ARRAY[TYPE_MARK]*/void r923clear_all(T923*C);
/*ARRAY[TYPE_MARK]*/void r923manifest_make(T923*C,T2 a1,T2 a2);
/*ARRAY[TYPE_MARK]*/T0*r923twin(T923*C);
/*ARRAY[TYPE_MARK]*/void r923set_all_with(T923*C,T0*a1);
/*ARRAY[TYPE_MARK]*/T6 r923valid_index(T923*C,T2 a1);
/*ARRAY[TYPE_MARK]*/void r923with_capacity(T923*C,T2 a1,T2 a2);
/*ARRAY[TYPE_MARK]*/void r923next_generation(T923*C);
/*ARRAY[TYPE_MARK]*/T2 r923count(T923*C);
/*ARRAY[INTEGER_32]*/void r925resize(T925*C,T2 a1,T2 a2);
/*ARRAY[INTEGER_32]*/void r925put(T925*C,T2 a1,T2 a2);
/*ARRAY[INTEGER_32]*/void r925ensure_capacity_and_bounds(T925*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[INTEGER_32]*/void r925add_last(T925*C,T2 a1);
/*ARRAY[INTEGER_32]*/T2 r925item(T925*C,T2 a1);
/*ARRAY[INTEGER_32]*/void r925clear_all(T925*C);
/*ARRAY[INTEGER_32]*/void r925set_all_with(T925*C,T2 a1);
/*ARRAY[INTEGER_32]*/void r925force(T925*C,T2 a1,T2 a2);
/*ARRAY[INTEGER_32]*/T6 r925valid_index(T925*C,T2 a1);
/*ARRAY[INTEGER_32]*/void r925with_capacity(T925*C,T2 a1,T2 a2);
/*ARRAY[INTEGER_32]*/void r925next_generation(T925*C);
/*ARRAY[INTEGER_32]*/T2 r925count(T925*C);
/*FAST_ARRAY[LIVE_TYPE]*/void r926swap(T926*C,T2 a1,T2 a2);
/*FAST_ARRAY[LIVE_TYPE]*/void r926put(T926*C,T0*a1,T2 a2);
/*FAST_ARRAY[LIVE_TYPE]*/T2 r926fast_first_index_of(T926*C,T0*a1);
/*FAST_ARRAY[LIVE_TYPE]*/void r926add_last(T926*C,T0*a1);
/*FAST_ARRAY[LIVE_TYPE]*/void r926for_each(T926*C,T0*a1);
/*FAST_ARRAY[LIVE_TYPE]*/T6 r926valid_index(T926*C,T2 a1);
/*FAST_ARRAY[LIVE_TYPE]*/T6 r926fast_has(T926*C,T0*a1);
/*FAST_ARRAY[LIVE_TYPE]*/void r926with_capacity(T926*C,T2 a1);
/*FAST_ARRAY[LIVE_TYPE]*/void r926next_generation(T926*C);
/*FAST_ARRAY[LIVE_TYPE]*/T2 r926count(T926*C);
/*FAST_ARRAY[POSITION]*/void r935swap(T935*C,T2 a1,T2 a2);
/*FAST_ARRAY[POSITION]*/T351 r935first(T935*C);
/*FAST_ARRAY[POSITION]*/void r935remove_last(T935*C);
/*FAST_ARRAY[POSITION]*/void r935put(T935*C,T351 a1,T2 a2);
/*FAST_ARRAY[POSITION]*/void r935copy(T935*C,T0*a1);
/*FAST_ARRAY[POSITION]*/T351 r935last(T935*C);
/*FAST_ARRAY[POSITION]*/void r935add_last(T935*C,T351 a1);
/*FAST_ARRAY[POSITION]*/T351 r935item(T935*C,T2 a1);
/*FAST_ARRAY[POSITION]*/void r935clear_count(T935*C);
/*FAST_ARRAY[POSITION]*/T6 r935is_empty(T935*C);
/*FAST_ARRAY[POSITION]*/T0*r935twin(T935*C);
/*FAST_ARRAY[POSITION]*/void r935with_capacity(T935*C,T2 a1);
/*FAST_ARRAY[POSITION]*/void r935next_generation(T935*C);
/*FAST_ARRAY[POSITION]*/T2 r935count(T935*C);
/*FAST_ARRAY[FIXED_STRING]*/void r938swap(T938*C,T2 a1,T2 a2);
/*FAST_ARRAY[FIXED_STRING]*/void r938put(T938*C,T0*a1,T2 a2);
/*FAST_ARRAY[FIXED_STRING]*/void r938add_last(T938*C,T0*a1);
/*FAST_ARRAY[FIXED_STRING]*/T2 r938fast_first_index_of(T938*C,T0*a1);
/*FAST_ARRAY[FIXED_STRING]*/void r938remove(T938*C,T2 a1);
/*FAST_ARRAY[FIXED_STRING]*/T6 r938valid_index(T938*C,T2 a1);
/*FAST_ARRAY[FIXED_STRING]*/T2 r938first_index_of(T938*C,T0*a1);
/*FAST_ARRAY[FIXED_STRING]*/void r938with_capacity(T938*C,T2 a1);
/*FAST_ARRAY[FIXED_STRING]*/void r938next_generation(T938*C);
/*FAST_ARRAY[FIXED_STRING]*/T2 r938count(T938*C);
/*FAST_ARRAY[FEATURE_NAME]*/void r955make(T955*C,T2 a1);
/*FAST_ARRAY[FEATURE_NAME]*/T0*r955first(T955*C);
/*FAST_ARRAY[FEATURE_NAME]*/void r955put(T955*C,T0*a1,T2 a2);
/*FAST_ARRAY[FEATURE_NAME]*/void r955add_last(T955*C,T0*a1);
/*FAST_ARRAY[FEATURE_NAME]*/void r955clear_count(T955*C);
/*FAST_ARRAY[FEATURE_NAME]*/T6 r955valid_index(T955*C,T2 a1);
/*FAST_ARRAY[FEATURE_NAME]*/void r955with_capacity(T955*C,T2 a1);
/*FAST_ARRAY[FEATURE_NAME]*/void r955next_generation(T955*C);
/*FAST_ARRAY[FEATURE_NAME]*/T2 r955count(T955*C);
/*FAST_ARRAY[CLASSES]*/void r959put(T959*C,T0*a1,T2 a2);
/*FAST_ARRAY[CLASSES]*/void r959add(T959*C,T0*a1,T2 a2);
/*FAST_ARRAY[CLASSES]*/void r959move(T959*C,T2 a1,T2 a2,T2 a3);
/*FAST_ARRAY[CLASSES]*/void r959add_last(T959*C,T0*a1);
/*FAST_ARRAY[CLASSES]*/T6 r959is_empty(T959*C);
/*FAST_ARRAY[CLASSES]*/void r959with_capacity(T959*C,T2 a1);
/*FAST_ARRAY[CLASSES]*/void r959next_generation(T959*C);
/*FAST_ARRAY[INTEGER_16]*/void r962make(T962*C,T2 a1);
/*FAST_ARRAY[INTEGER_16]*/void r962add_last(T962*C,T10 a1);
/*FAST_ARRAY[INTEGER_16]*/void r962next_generation(T962*C);
/*FAST_ARRAY[INTEGER_16]*/T2 r962count(T962*C);
/*FAST_ARRAY[FEATURE_TEXT]*/void r975copy(T975*C,T0*a1);
/*FAST_ARRAY[FEATURE_TEXT]*/void r975add_last(T975*C,T0*a1);
/*FAST_ARRAY[FEATURE_TEXT]*/void r975clear_count(T975*C);
/*FAST_ARRAY[FEATURE_TEXT]*/T6 r975is_empty(T975*C);
/*FAST_ARRAY[FEATURE_TEXT]*/T0*r975twin(T975*C);
/*FAST_ARRAY[FEATURE_TEXT]*/void r975with_capacity(T975*C,T2 a1);
/*FAST_ARRAY[FEATURE_TEXT]*/void r975next_generation(T975*C);
/*FAST_ARRAY[PARENT_EDGE]*/void r976swap(T976*C,T2 a1,T2 a2);
/*FAST_ARRAY[PARENT_EDGE]*/void r976make(T976*C,T2 a1);
/*FAST_ARRAY[PARENT_EDGE]*/T2 r976fast_index_of(T976*C,T0*a1,T2 a2);
/*FAST_ARRAY[PARENT_EDGE]*/void r976put(T976*C,T0*a1,T2 a2);
/*FAST_ARRAY[PARENT_EDGE]*/T0*r976last(T976*C);
/*FAST_ARRAY[PARENT_EDGE]*/T2 r976fast_first_index_of(T976*C,T0*a1);
/*FAST_ARRAY[PARENT_EDGE]*/void r976add_last(T976*C,T0*a1);
/*FAST_ARRAY[PARENT_EDGE]*/void r976remove(T976*C,T2 a1);
/*FAST_ARRAY[PARENT_EDGE]*/void r976clear_count(T976*C);
/*FAST_ARRAY[PARENT_EDGE]*/T6 r976is_empty(T976*C);
/*FAST_ARRAY[PARENT_EDGE]*/T6 r976valid_index(T976*C,T2 a1);
/*FAST_ARRAY[PARENT_EDGE]*/T6 r976fast_has(T976*C,T0*a1);
/*FAST_ARRAY[PARENT_EDGE]*/void r976with_capacity(T976*C,T2 a1);
/*FAST_ARRAY[PARENT_EDGE]*/void r976next_generation(T976*C);
/*FAST_ARRAY[PARENT_EDGE]*/T2 r976count(T976*C);
/*FAST_ARRAY[EXPRESSION]*/void r977make(T977*C,T2 a1);
/*FAST_ARRAY[EXPRESSION]*/T0*r977first(T977*C);
/*FAST_ARRAY[EXPRESSION]*/void r977put(T977*C,T0*a1,T2 a2);
/*FAST_ARRAY[EXPRESSION]*/void r977copy(T977*C,T0*a1);
/*FAST_ARRAY[EXPRESSION]*/void r977add_last(T977*C,T0*a1);
/*FAST_ARRAY[EXPRESSION]*/T0*r977twin(T977*C);
/*FAST_ARRAY[EXPRESSION]*/void r977remove_tail(T977*C,T2 a1);
/*FAST_ARRAY[EXPRESSION]*/void r977with_capacity(T977*C,T2 a1);
/*FAST_ARRAY[EXPRESSION]*/void r977next_generation(T977*C);
/*FAST_ARRAY[EXPRESSION]*/T2 r977count(T977*C);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979make(T979*C,T2 a1,T2 a2);
/*ARRAY[ARGUMENT_NAME_DEF]*/T0*r979first(T979*C);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979put(T979*C,T0*a1,T2 a2);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979ensure_capacity_and_bounds(T979*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979add_last(T979*C,T0*a1);
/*ARRAY[ARGUMENT_NAME_DEF]*/T0*r979item(T979*C,T2 a1);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979clear_all(T979*C);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979set_all_with(T979*C,T0*a1);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979from_collection(T979*C,T0*a1);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979with_capacity(T979*C,T2 a1,T2 a2);
/*ARRAY[ARGUMENT_NAME_DEF]*/void r979next_generation(T979*C);
/*ARRAY[ARGUMENT_NAME_DEF]*/T2 r979count(T979*C);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/T0*r980first(T980*C);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/void r980put(T980*C,T0*a1,T2 a2);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/void r980ensure_capacity_and_bounds(T980*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/T0*r980item(T980*C,T2 a1);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/void r980clear_all(T980*C);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/void r980set_all_with(T980*C,T0*a1);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/void r980from_collection(T980*C,T0*a1);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/void r980with_capacity(T980*C,T2 a1,T2 a2);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/void r980next_generation(T980*C);
/*ARRAY[LOCAL_ARGUMENT_DEF]*/T2 r980count(T980*C);
/*ARRAY[DECLARATION]*/void r981make(T981*C,T2 a1,T2 a2);
/*ARRAY[DECLARATION]*/void r981put(T981*C,T0*a1,T2 a2);
/*ARRAY[DECLARATION]*/void r981ensure_capacity_and_bounds(T981*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[DECLARATION]*/void r981manifest_put(T981*C,T2 a1,T0*a2);
/*ARRAY[DECLARATION]*/void r981add_last(T981*C,T0*a1);
/*ARRAY[DECLARATION]*/T0*r981item(T981*C,T2 a1);
/*ARRAY[DECLARATION]*/void r981clear_all(T981*C);
/*ARRAY[DECLARATION]*/T6 r981is_empty(T981*C);
/*ARRAY[DECLARATION]*/void r981manifest_make(T981*C,T2 a1,T2 a2);
/*ARRAY[DECLARATION]*/void r981set_all_with(T981*C,T0*a1);
/*ARRAY[DECLARATION]*/void r981from_collection(T981*C,T0*a1);
/*ARRAY[DECLARATION]*/void r981with_capacity(T981*C,T2 a1,T2 a2);
/*ARRAY[DECLARATION]*/void r981next_generation(T981*C);
/*ARRAY[DECLARATION]*/T2 r981count(T981*C);
/*FAST_ARRAY[ASSERTION]*/void r982put(T982*C,T0*a1,T2 a2);
/*FAST_ARRAY[ASSERTION]*/void r982copy(T982*C,T0*a1);
/*FAST_ARRAY[ASSERTION]*/void r982add_last(T982*C,T0*a1);
/*FAST_ARRAY[ASSERTION]*/void r982for_each(T982*C,T0*a1);
/*FAST_ARRAY[ASSERTION]*/void r982clear_count(T982*C);
/*FAST_ARRAY[ASSERTION]*/T6 r982is_empty(T982*C);
/*FAST_ARRAY[ASSERTION]*/T0*r982twin(T982*C);
/*FAST_ARRAY[ASSERTION]*/void r982with_capacity(T982*C,T2 a1);
/*FAST_ARRAY[ASSERTION]*/void r982next_generation(T982*C);
/*FAST_ARRAY[ASSERTION]*/T2 r982count(T982*C);
/*ARRAY[LOCAL_NAME_DEF]*/void r983make(T983*C,T2 a1,T2 a2);
/*ARRAY[LOCAL_NAME_DEF]*/T0*r983first(T983*C);
/*ARRAY[LOCAL_NAME_DEF]*/void r983put(T983*C,T0*a1,T2 a2);
/*ARRAY[LOCAL_NAME_DEF]*/void r983ensure_capacity_and_bounds(T983*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[LOCAL_NAME_DEF]*/void r983add_last(T983*C,T0*a1);
/*ARRAY[LOCAL_NAME_DEF]*/T0*r983item(T983*C,T2 a1);
/*ARRAY[LOCAL_NAME_DEF]*/void r983clear_all(T983*C);
/*ARRAY[LOCAL_NAME_DEF]*/void r983set_all_with(T983*C,T0*a1);
/*ARRAY[LOCAL_NAME_DEF]*/void r983from_collection(T983*C,T0*a1);
/*ARRAY[LOCAL_NAME_DEF]*/void r983with_capacity(T983*C,T2 a1,T2 a2);
/*ARRAY[LOCAL_NAME_DEF]*/void r983next_generation(T983*C);
/*ARRAY[LOCAL_NAME_DEF]*/T2 r983count(T983*C);
/*FAST_ARRAY[MANIFEST_STRING]*/void r984add_last(T984*C,T0*a1);
/*FAST_ARRAY[MANIFEST_STRING]*/T6 r984is_empty(T984*C);
/*FAST_ARRAY[MANIFEST_STRING]*/void r984with_capacity(T984*C,T2 a1);
/*FAST_ARRAY[MANIFEST_STRING]*/void r984next_generation(T984*C);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985make(T985*C,T2 a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985swap(T985*C,T2 a1,T2 a2);
/*FAST_ARRAY[WHEN_CLAUSE]*/T0*r985first(T985*C);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985put(T985*C,T0*a1,T2 a2);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985copy(T985*C,T0*a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985add_last(T985*C,T0*a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985remove(T985*C,T2 a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985clear_count(T985*C);
/*FAST_ARRAY[WHEN_CLAUSE]*/T6 r985is_empty(T985*C);
/*FAST_ARRAY[WHEN_CLAUSE]*/T0*r985twin(T985*C);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985remove_tail(T985*C,T2 a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985with_capacity(T985*C,T2 a1);
/*FAST_ARRAY[WHEN_CLAUSE]*/void r985next_generation(T985*C);
/*FAST_ARRAY[WHEN_CLAUSE]*/T2 r985count(T985*C);
/*ARRAY[EXPORT_ITEM]*/void r988put(T988*C,T0*a1,T2 a2);
/*ARRAY[EXPORT_ITEM]*/void r988ensure_capacity_and_bounds(T988*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[EXPORT_ITEM]*/void r988add_last(T988*C,T0*a1);
/*ARRAY[EXPORT_ITEM]*/T0*r988item(T988*C,T2 a1);
/*ARRAY[EXPORT_ITEM]*/void r988clear_all(T988*C);
/*ARRAY[EXPORT_ITEM]*/void r988set_all_with(T988*C,T0*a1);
/*ARRAY[EXPORT_ITEM]*/void r988with_capacity(T988*C,T2 a1,T2 a2);
/*ARRAY[EXPORT_ITEM]*/void r988next_generation(T988*C);
/*ARRAY[EXPORT_ITEM]*/T2 r988count(T988*C);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/void r993add_last(T993*C,T0*a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/T2 r993fast_first_index_of(T993*C,T0*a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/T6 r993valid_index(T993*C,T2 a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/T6 r993fast_has(T993*C,T0*a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/void r993with_capacity(T993*C,T2 a1);
/*FAST_ARRAY[EXTERNAL_ROUTINE]*/void r993next_generation(T993*C);
/*FAST_ARRAY[INTEGER_64]*/void r997make(T997*C,T2 a1);
/*FAST_ARRAY[INTEGER_64]*/void r997resize(T997*C,T2 a1);
/*FAST_ARRAY[INTEGER_64]*/void r997add_last(T997*C,T11 a1);
/*FAST_ARRAY[INTEGER_64]*/void r997force(T997*C,T11 a1,T2 a2);
/*FAST_ARRAY[INTEGER_64]*/void r997next_generation(T997*C);
/*FAST_ARRAY[INTEGER_64]*/T2 r997count(T997*C);
/*ARRAY[TYPE]*/T0*r1002first(T1002*C);
/*ARRAY[TYPE]*/void r1002put(T1002*C,T0*a1,T2 a2);
/*ARRAY[TYPE]*/void r1002ensure_capacity_and_bounds(T1002*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[TYPE]*/void r1002add_last(T1002*C,T0*a1);
/*ARRAY[TYPE]*/T0*r1002item(T1002*C,T2 a1);
/*ARRAY[TYPE]*/void r1002clear_all(T1002*C);
/*ARRAY[TYPE]*/void r1002set_all_with(T1002*C,T0*a1);
/*ARRAY[TYPE]*/void r1002with_capacity(T1002*C,T2 a1,T2 a2);
/*ARRAY[TYPE]*/void r1002next_generation(T1002*C);
/*ARRAY[TYPE]*/T2 r1002count(T1002*C);
/*FAST_ARRAY[RUN_FEATURE]*/void r1004add_last(T1004*C,T0*a1);
/*FAST_ARRAY[RUN_FEATURE]*/T2 r1004fast_first_index_of(T1004*C,T0*a1);
/*FAST_ARRAY[RUN_FEATURE]*/void r1004for_each(T1004*C,T0*a1);
/*FAST_ARRAY[RUN_FEATURE]*/T6 r1004valid_index(T1004*C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE]*/void r1004with_capacity(T1004*C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE]*/void r1004next_generation(T1004*C);
/*FAST_ARRAY[RUN_FEATURE]*/T2 r1004count(T1004*C);
/*FAST_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/void r1005make(T1005*C,T2 a1);
/*FAST_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/void r1005add_last(T1005*C,T0*a1);
/*FAST_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/void r1005for_each(T1005*C,T0*a1);
/*FAST_ARRAY[LIVE_TYPE_EXTRA_COLLECTOR]*/void r1005next_generation(T1005*C);
/*FAST_ARRAY[TYPE]*/void r1017make(T1017*C,T2 a1);
/*FAST_ARRAY[TYPE]*/T0*r1017first(T1017*C);
/*FAST_ARRAY[TYPE]*/void r1017resize(T1017*C,T2 a1);
/*FAST_ARRAY[TYPE]*/void r1017remove_last(T1017*C);
/*FAST_ARRAY[TYPE]*/T0*r1017last(T1017*C);
/*FAST_ARRAY[TYPE]*/T2 r1017fast_first_index_of(T1017*C,T0*a1);
/*FAST_ARRAY[TYPE]*/void r1017add_last(T1017*C,T0*a1);
/*FAST_ARRAY[TYPE]*/void r1017remove(T1017*C,T2 a1);
/*FAST_ARRAY[TYPE]*/void r1017clear_count(T1017*C);
/*FAST_ARRAY[TYPE]*/T6 r1017valid_index(T1017*C,T2 a1);
/*FAST_ARRAY[TYPE]*/T6 r1017fast_has(T1017*C,T0*a1);
/*FAST_ARRAY[TYPE]*/void r1017with_capacity(T1017*C,T2 a1);
/*FAST_ARRAY[TYPE]*/void r1017next_generation(T1017*C);
/*FAST_ARRAY[TYPE]*/T2 r1017count(T1017*C);
/*FAST_ARRAY[CLASS_TEXT]*/void r1022add_last(T1022*C,T0*a1);
/*FAST_ARRAY[CLASS_TEXT]*/void r1022with_capacity(T1022*C,T2 a1);
/*FAST_ARRAY[CLASS_TEXT]*/void r1022next_generation(T1022*C);
/*FAST_ARRAY[FEATURE_STAMP]*/void r1023make(T1023*C,T2 a1);
/*FAST_ARRAY[FEATURE_STAMP]*/T2 r1023fast_first_index_of(T1023*C,T0*a1);
/*FAST_ARRAY[FEATURE_STAMP]*/void r1023add_last(T1023*C,T0*a1);
/*FAST_ARRAY[FEATURE_STAMP]*/void r1023for_each(T1023*C,T0*a1);
/*FAST_ARRAY[FEATURE_STAMP]*/T6 r1023is_empty(T1023*C);
/*FAST_ARRAY[FEATURE_STAMP]*/T6 r1023valid_index(T1023*C,T2 a1);
/*FAST_ARRAY[FEATURE_STAMP]*/T6 r1023fast_has(T1023*C,T0*a1);
/*FAST_ARRAY[FEATURE_STAMP]*/void r1023with_capacity(T1023*C,T2 a1);
/*FAST_ARRAY[FEATURE_STAMP]*/void r1023next_generation(T1023*C);
/*FAST_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/void r1031remove_last(T1031*C);
/*FAST_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/T0*r1031last(T1031*C);
/*FAST_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/void r1031add_last(T1031*C,T0*a1);
/*FAST_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/T6 r1031is_empty(T1031*C);
/*FAST_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/void r1031with_capacity(T1031*C,T2 a1);
/*FAST_ARRAY[WEAK_REFERENCE[FAST_ARRAY[FIXED_STRING]]]*/void r1031next_generation(T1031*C);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/void r1040add_last(T1040*C,T0*a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/T2 r1040fast_first_index_of(T1040*C,T0*a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/void r1040for_each(T1040*C,T0*a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/void r1040clear_count(T1040*C);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/T6 r1040valid_index(T1040*C,T2 a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/T6 r1040fast_has(T1040*C,T0*a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/void r1040with_capacity(T1040*C,T2 a1);
/*FAST_ARRAY[NON_VOID_NO_DISPATCH]*/void r1040next_generation(T1040*C);
/*FAST_ARRAY[AGENT_CREATION]*/T2 r1042fast_first_index_of(T1042*C,T0*a1);
/*FAST_ARRAY[AGENT_CREATION]*/void r1042add_last(T1042*C,T0*a1);
/*FAST_ARRAY[AGENT_CREATION]*/void r1042clear_count(T1042*C);
/*FAST_ARRAY[AGENT_CREATION]*/T6 r1042valid_index(T1042*C,T2 a1);
/*FAST_ARRAY[AGENT_CREATION]*/T6 r1042fast_has(T1042*C,T0*a1);
/*FAST_ARRAY[AGENT_CREATION]*/void r1042with_capacity(T1042*C,T2 a1);
/*FAST_ARRAY[AGENT_CREATION]*/void r1042next_generation(T1042*C);
/*FAST_ARRAY[AGENT_CREATION]*/T2 r1042count(T1042*C);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/void r1046remove_last(T1046*C);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/T0*r1046last(T1046*C);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/void r1046add_last(T1046*C,T0*a1);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/T6 r1046is_empty(T1046*C);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/void r1046with_capacity(T1046*C,T2 a1);
/*FAST_ARRAY[HASHED_SET[TYPE]]*/void r1046next_generation(T1046*C);
/*FAST_ARRAY[FAST_ARRAY[CODE]]*/void r1051add_last(T1051*C,T0*a1);
/*FAST_ARRAY[FAST_ARRAY[CODE]]*/T6 r1051valid_index(T1051*C,T2 a1);
/*FAST_ARRAY[FAST_ARRAY[CODE]]*/void r1051with_capacity(T1051*C,T2 a1);
/*FAST_ARRAY[FAST_ARRAY[CODE]]*/void r1051next_generation(T1051*C);
/*FAST_ARRAY[FAST_ARRAY[CODE]]*/T2 r1051count(T1051*C);
/*FAST_ARRAY[CODE]*/void r1052make(T1052*C,T2 a1);
/*FAST_ARRAY[CODE]*/T0*r1052first(T1052*C);
/*FAST_ARRAY[CODE]*/void r1052remove_last(T1052*C);
/*FAST_ARRAY[CODE]*/void r1052put(T1052*C,T0*a1,T2 a2);
/*FAST_ARRAY[CODE]*/void r1052manifest_put(T1052*C,T2 a1,T0*a2);
/*FAST_ARRAY[CODE]*/void r1052copy(T1052*C,T0*a1);
/*FAST_ARRAY[CODE]*/T0*r1052last(T1052*C);
/*FAST_ARRAY[CODE]*/void r1052add_last(T1052*C,T0*a1);
/*FAST_ARRAY[CODE]*/void r1052clear_count(T1052*C);
/*FAST_ARRAY[CODE]*/T6 r1052is_empty(T1052*C);
/*FAST_ARRAY[CODE]*/void r1052manifest_make(T1052*C,T2 a1);
/*FAST_ARRAY[CODE]*/T0*r1052twin(T1052*C);
/*FAST_ARRAY[CODE]*/void r1052with_capacity(T1052*C,T2 a1);
/*FAST_ARRAY[CODE]*/void r1052next_generation(T1052*C);
/*FAST_ARRAY[CODE]*/T2 r1052count(T1052*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1054remove_last(T1054*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/T0*r1054last(T1054*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1054add_last(T1054*C,T0*a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1054clear_count(T1054*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/T6 r1054is_empty(T1054*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1054with_capacity(T1054*C,T2 a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE_MIXER]*/void r1054next_generation(T1054*C);
/*ARRAY[ARRAY[INTEGER_8]]*/void r1064make(T1064*C,T2 a1,T2 a2);
/*ARRAY[ARRAY[INTEGER_8]]*/void r1064ensure_capacity_and_bounds(T1064*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[ARRAY[INTEGER_8]]*/void r1064manifest_put(T1064*C,T2 a1,T0*a2);
/*ARRAY[ARRAY[INTEGER_8]]*/T0*r1064item(T1064*C,T2 a1);
/*ARRAY[ARRAY[INTEGER_8]]*/void r1064clear_all(T1064*C);
/*ARRAY[ARRAY[INTEGER_8]]*/void r1064manifest_make(T1064*C,T2 a1,T2 a2);
/*ARRAY[ARRAY[INTEGER_8]]*/void r1064set_all_with(T1064*C,T0*a1);
/*ARRAY[ARRAY[INTEGER_8]]*/void r1064next_generation(T1064*C);
/*ARRAY[INTEGER_8]*/void r1065make(T1065*C,T2 a1,T2 a2);
/*ARRAY[INTEGER_8]*/void r1065ensure_capacity_and_bounds(T1065*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[INTEGER_8]*/void r1065manifest_put(T1065*C,T2 a1,T1 a2);
/*ARRAY[INTEGER_8]*/T1 r1065item(T1065*C,T2 a1);
/*ARRAY[INTEGER_8]*/void r1065clear_all(T1065*C);
/*ARRAY[INTEGER_8]*/void r1065manifest_make(T1065*C,T2 a1,T2 a2);
/*ARRAY[INTEGER_8]*/void r1065set_all_with(T1065*C,T1 a1);
/*ARRAY[INTEGER_8]*/void r1065next_generation(T1065*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r1066make(T1066*C,T2 a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T0*r1066first(T1066*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r1066remove_last(T1066*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T0*r1066last(T1066*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T2 r1066fast_first_index_of(T1066*C,T0*a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r1066add_last(T1066*C,T0*a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r1066clear_count(T1066*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T6 r1066is_empty(T1066*C);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T6 r1066valid_index(T1066*C,T2 a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/T6 r1066fast_has(T1066*C,T0*a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r1066with_capacity(T1066*C,T2 a1);
/*FAST_ARRAY[ANONYMOUS_FEATURE]*/void r1066next_generation(T1066*C);
/*FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/void r1080swap(T1080*C,T2 a1,T2 a2);
/*FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/void r1080make(T1080*C,T2 a1);
/*FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/void r1080put(T1080*C,T0*a1,T2 a2);
/*FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/void r1080add_last(T1080*C,T0*a1);
/*FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/T6 r1080valid_index(T1080*C,T2 a1);
/*FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/T2 r1080first_index_of(T1080*C,T0*a1);
/*FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/void r1080next_generation(T1080*C);
/*FAST_ARRAY[C_GARBAGE_COLLECTOR_TAG]*/T2 r1080count(T1080*C);
/*FAST_ARRAY[ABSTRACT_STRING]*/void r1081add_last(T1081*C,T0*a1);
/*FAST_ARRAY[ABSTRACT_STRING]*/T6 r1081valid_index(T1081*C,T2 a1);
/*FAST_ARRAY[ABSTRACT_STRING]*/void r1081with_capacity(T1081*C,T2 a1);
/*FAST_ARRAY[ABSTRACT_STRING]*/void r1081next_generation(T1081*C);
/*FAST_ARRAY[CECIL_ENTRY]*/void r1089add_last(T1089*C,T0*a1);
/*FAST_ARRAY[CECIL_ENTRY]*/void r1089for_each(T1089*C,T0*a1);
/*FAST_ARRAY[CECIL_ENTRY]*/void r1089with_capacity(T1089*C,T2 a1);
/*FAST_ARRAY[CECIL_ENTRY]*/void r1089next_generation(T1089*C);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/void r1096make(T1096*C,T2 a1);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/void r1096put(T1096*C,T324 a1,T2 a2);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/void r1096add(T1096*C,T324 a1,T2 a2);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/void r1096move(T1096*C,T2 a1,T2 a2,T2 a3);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/void r1096add_last(T1096*C,T324 a1);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/T324 r1096item(T1096*C,T2 a1);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/T6 r1096is_empty(T1096*C);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/T6 r1096valid_index(T1096*C,T2 a1);
/*FAST_ARRAY[STRING_RECYCLING_ITEM]*/void r1096next_generation(T1096*C);
/*FAST_ARRAY[TEXT_FILE_READ]*/void r1110make(T1110*C,T2 a1);
/*FAST_ARRAY[TEXT_FILE_READ]*/void r1110remove_last(T1110*C);
/*FAST_ARRAY[TEXT_FILE_READ]*/T0*r1110last(T1110*C);
/*FAST_ARRAY[TEXT_FILE_READ]*/T6 r1110is_empty(T1110*C);
/*FAST_ARRAY[TEXT_FILE_READ]*/void r1110next_generation(T1110*C);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1128resize(T1128*C,T2 a1);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1128put(T1128*C,T0*a1,T2 a2);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1128copy(T1128*C,T0*a1);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1128add_last(T1128*C,T0*a1);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/T6 r1128is_empty(T1128*C);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/T0*r1128twin(T1128*C);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1128from_collection(T1128*C,T0*a1);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1128with_capacity(T1128*C,T2 a1);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/void r1128next_generation(T1128*C);
/*FAST_ARRAY[FORMAL_ARG_LIST]*/T2 r1128count(T1128*C);
/*FAST_ARRAY[LOCAL_VAR_LIST]*/void r1130put(T1130*C,T0*a1,T2 a2);
/*FAST_ARRAY[LOCAL_VAR_LIST]*/void r1130copy(T1130*C,T0*a1);
/*FAST_ARRAY[LOCAL_VAR_LIST]*/T6 r1130is_empty(T1130*C);
/*FAST_ARRAY[LOCAL_VAR_LIST]*/T0*r1130twin(T1130*C);
/*FAST_ARRAY[LOCAL_VAR_LIST]*/void r1130from_collection(T1130*C,T0*a1);
/*FAST_ARRAY[LOCAL_VAR_LIST]*/void r1130with_capacity(T1130*C,T2 a1);
/*FAST_ARRAY[LOCAL_VAR_LIST]*/void r1130next_generation(T1130*C);
/*FAST_ARRAY[LOCAL_VAR_LIST]*/T2 r1130count(T1130*C);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r1132put(T1132*C,T0*a1,T2 a2);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r1132ensure_capacity_and_bounds(T1132*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r1132add_last(T1132*C,T0*a1);
/*ARRAY[FORMAL_GENERIC_ARG]*/T0*r1132item(T1132*C,T2 a1);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r1132clear_all(T1132*C);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r1132set_all_with(T1132*C,T0*a1);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r1132with_capacity(T1132*C,T2 a1,T2 a2);
/*ARRAY[FORMAL_GENERIC_ARG]*/void r1132next_generation(T1132*C);
/*ARRAY[FORMAL_GENERIC_ARG]*/T2 r1132count(T1132*C);
/*FAST_ARRAY[TYPE_MARK]*/void r1135put(T1135*C,T0*a1,T2 a2);
/*FAST_ARRAY[TYPE_MARK]*/void r1135add_last(T1135*C,T0*a1);
/*FAST_ARRAY[TYPE_MARK]*/T6 r1135valid_index(T1135*C,T2 a1);
/*FAST_ARRAY[TYPE_MARK]*/void r1135from_collection(T1135*C,T0*a1);
/*FAST_ARRAY[TYPE_MARK]*/void r1135with_capacity(T1135*C,T2 a1);
/*FAST_ARRAY[TYPE_MARK]*/void r1135next_generation(T1135*C);
/*FAST_ARRAY[TYPE_MARK]*/T2 r1135count(T1135*C);
/*FAST_ARRAY[REQUIRE_ASSERTION]*/T0*r1142first(T1142*C);
/*FAST_ARRAY[REQUIRE_ASSERTION]*/void r1142put(T1142*C,T0*a1,T2 a2);
/*FAST_ARRAY[REQUIRE_ASSERTION]*/void r1142copy(T1142*C,T0*a1);
/*FAST_ARRAY[REQUIRE_ASSERTION]*/void r1142add_last(T1142*C,T0*a1);
/*FAST_ARRAY[REQUIRE_ASSERTION]*/T0*r1142twin(T1142*C);
/*FAST_ARRAY[REQUIRE_ASSERTION]*/void r1142with_capacity(T1142*C,T2 a1);
/*FAST_ARRAY[REQUIRE_ASSERTION]*/void r1142next_generation(T1142*C);
/*FAST_ARRAY[REQUIRE_ASSERTION]*/T2 r1142count(T1142*C);
/*FAST_ARRAY[IFTHEN]*/T0*r1146first(T1146*C);
/*FAST_ARRAY[IFTHEN]*/void r1146remove_last(T1146*C);
/*FAST_ARRAY[IFTHEN]*/void r1146put(T1146*C,T0*a1,T2 a2);
/*FAST_ARRAY[IFTHEN]*/void r1146copy(T1146*C,T0*a1);
/*FAST_ARRAY[IFTHEN]*/T0*r1146last(T1146*C);
/*FAST_ARRAY[IFTHEN]*/void r1146add_last(T1146*C,T0*a1);
/*FAST_ARRAY[IFTHEN]*/void r1146remove(T1146*C,T2 a1);
/*FAST_ARRAY[IFTHEN]*/T6 r1146is_empty(T1146*C);
/*FAST_ARRAY[IFTHEN]*/T0*r1146twin(T1146*C);
/*FAST_ARRAY[IFTHEN]*/void r1146remove_tail(T1146*C,T2 a1);
/*FAST_ARRAY[IFTHEN]*/void r1146with_capacity(T1146*C,T2 a1);
/*FAST_ARRAY[IFTHEN]*/void r1146next_generation(T1146*C);
/*FAST_ARRAY[IFTHEN]*/void r1146remove_first(T1146*C);
/*FAST_ARRAY[IFTHEN]*/T2 r1146count(T1146*C);
/*FAST_ARRAY[WHEN_ITEM]*/T0*r1148first(T1148*C);
/*FAST_ARRAY[WHEN_ITEM]*/void r1148put(T1148*C,T0*a1,T2 a2);
/*FAST_ARRAY[WHEN_ITEM]*/void r1148copy(T1148*C,T0*a1);
/*FAST_ARRAY[WHEN_ITEM]*/void r1148add_last(T1148*C,T0*a1);
/*FAST_ARRAY[WHEN_ITEM]*/void r1148append_traversable(T1148*C,T0*a1);
/*FAST_ARRAY[WHEN_ITEM]*/T6 r1148is_empty(T1148*C);
/*FAST_ARRAY[WHEN_ITEM]*/T0*r1148twin(T1148*C);
/*FAST_ARRAY[WHEN_ITEM]*/void r1148with_capacity(T1148*C,T2 a1);
/*FAST_ARRAY[WHEN_ITEM]*/void r1148next_generation(T1148*C);
/*FAST_ARRAY[WHEN_ITEM]*/T2 r1148count(T1148*C);
/*FAST_ARRAY[INSTRUCTION]*/void r1149make(T1149*C,T2 a1);
/*FAST_ARRAY[INSTRUCTION]*/T0*r1149first(T1149*C);
/*FAST_ARRAY[INSTRUCTION]*/void r1149put(T1149*C,T0*a1,T2 a2);
/*FAST_ARRAY[INSTRUCTION]*/void r1149copy(T1149*C,T0*a1);
/*FAST_ARRAY[INSTRUCTION]*/T0*r1149last(T1149*C);
/*FAST_ARRAY[INSTRUCTION]*/void r1149add_last(T1149*C,T0*a1);
/*FAST_ARRAY[INSTRUCTION]*/T0*r1149twin(T1149*C);
/*FAST_ARRAY[INSTRUCTION]*/void r1149with_capacity(T1149*C,T2 a1);
/*FAST_ARRAY[INSTRUCTION]*/void r1149next_generation(T1149*C);
/*FAST_ARRAY[INSTRUCTION]*/void r1149remove_first(T1149*C);
/*FAST_ARRAY[INSTRUCTION]*/T2 r1149count(T1149*C);
/*FAST_ARRAY[OPEN_OPERAND]*/void r1150put(T1150*C,T0*a1,T2 a2);
/*FAST_ARRAY[OPEN_OPERAND]*/void r1150add_last(T1150*C,T0*a1);
/*FAST_ARRAY[OPEN_OPERAND]*/void r1150with_capacity(T1150*C,T2 a1);
/*FAST_ARRAY[OPEN_OPERAND]*/void r1150next_generation(T1150*C);
/*FAST_ARRAY[CLOSED_OPERAND]*/void r1151add_last(T1151*C,T0*a1);
/*FAST_ARRAY[CLOSED_OPERAND]*/void r1151with_capacity(T1151*C,T2 a1);
/*FAST_ARRAY[CLOSED_OPERAND]*/void r1151next_generation(T1151*C);
/*FAST_ARRAY[IFTHEN_EXP]*/T0*r1152first(T1152*C);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152remove_last(T1152*C);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152put(T1152*C,T0*a1,T2 a2);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152copy(T1152*C,T0*a1);
/*FAST_ARRAY[IFTHEN_EXP]*/T0*r1152last(T1152*C);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152add_last(T1152*C,T0*a1);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152remove(T1152*C,T2 a1);
/*FAST_ARRAY[IFTHEN_EXP]*/T6 r1152is_empty(T1152*C);
/*FAST_ARRAY[IFTHEN_EXP]*/T0*r1152twin(T1152*C);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152remove_tail(T1152*C,T2 a1);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152with_capacity(T1152*C,T2 a1);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152next_generation(T1152*C);
/*FAST_ARRAY[IFTHEN_EXP]*/void r1152remove_first(T1152*C);
/*FAST_ARRAY[IFTHEN_EXP]*/T2 r1152count(T1152*C);
/*FAST_ARRAY[FEATURE_CLAUSE]*/void r1167add_last(T1167*C,T0*a1);
/*FAST_ARRAY[FEATURE_CLAUSE]*/void r1167with_capacity(T1167*C,T2 a1);
/*FAST_ARRAY[FEATURE_CLAUSE]*/void r1167next_generation(T1167*C);
/*FAST_ARRAY[CREATION_CLAUSE]*/T0*r1168first(T1168*C);
/*FAST_ARRAY[CREATION_CLAUSE]*/void r1168add_last(T1168*C,T0*a1);
/*FAST_ARRAY[CREATION_CLAUSE]*/void r1168with_capacity(T1168*C,T2 a1);
/*FAST_ARRAY[CREATION_CLAUSE]*/void r1168next_generation(T1168*C);
/*FAST_ARRAY[RUN_FEATURE_2]*/void r1250add_last(T1250*C,T0*a1);
/*FAST_ARRAY[RUN_FEATURE_2]*/void r1250clear_count(T1250*C);
/*FAST_ARRAY[RUN_FEATURE_2]*/T6 r1250is_empty(T1250*C);
/*FAST_ARRAY[RUN_FEATURE_2]*/void r1250with_capacity(T1250*C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE_2]*/void r1250next_generation(T1250*C);
/*FAST_ARRAY[RUN_FEATURE_2]*/T2 r1250count(T1250*C);
/*FAST_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/void r1253make(T1253*C,T2 a1);
/*FAST_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/void r1253add_last(T1253*C,T0*a1);
/*FAST_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/void r1253clear_count(T1253*C);
/*FAST_ARRAY[AVL_SET_NODE[LIVE_TYPE]]*/void r1253next_generation(T1253*C);
/*FAST_ARRAY[INDEX_CLAUSE]*/void r1283add_last(T1283*C,T0*a1);
/*FAST_ARRAY[INDEX_CLAUSE]*/void r1283with_capacity(T1283*C,T2 a1);
/*FAST_ARRAY[INDEX_CLAUSE]*/void r1283next_generation(T1283*C);
/*FAST_ARRAY[RENAME_PAIR]*/void r1291add_last(T1291*C,T0*a1);
/*FAST_ARRAY[RENAME_PAIR]*/void r1291with_capacity(T1291*C,T2 a1);
/*FAST_ARRAY[RENAME_PAIR]*/void r1291next_generation(T1291*C);
/*FAST_ARRAY[RENAME_PAIR]*/T2 r1291count(T1291*C);
/*FAST_ARRAY[INLINE_MEMO]*/void r1344remove_last(T1344*C);
/*FAST_ARRAY[INLINE_MEMO]*/T0*r1344last(T1344*C);
/*FAST_ARRAY[INLINE_MEMO]*/void r1344add_last(T1344*C,T0*a1);
/*FAST_ARRAY[INLINE_MEMO]*/T6 r1344is_empty(T1344*C);
/*FAST_ARRAY[INLINE_MEMO]*/void r1344with_capacity(T1344*C,T2 a1);
/*FAST_ARRAY[INLINE_MEMO]*/void r1344next_generation(T1344*C);
/*FAST_ARRAY[FAST_ARRAY[E_OLD]]*/void r1349remove_last(T1349*C);
/*FAST_ARRAY[FAST_ARRAY[E_OLD]]*/void r1349put(T1349*C,T0*a1,T2 a2);
/*FAST_ARRAY[FAST_ARRAY[E_OLD]]*/T0*r1349last(T1349*C);
/*FAST_ARRAY[FAST_ARRAY[E_OLD]]*/void r1349add_last(T1349*C,T0*a1);
/*FAST_ARRAY[FAST_ARRAY[E_OLD]]*/void r1349with_capacity(T1349*C,T2 a1);
/*FAST_ARRAY[FAST_ARRAY[E_OLD]]*/void r1349next_generation(T1349*C);
/*FAST_ARRAY[E_OLD]*/void r1350add_last(T1350*C,T0*a1);
/*FAST_ARRAY[E_OLD]*/void r1350with_capacity(T1350*C,T2 a1);
/*FAST_ARRAY[E_OLD]*/void r1350next_generation(T1350*C);
/*FAST_ARRAY[ADDRESS_OF]*/void r1352add_last(T1352*C,T0*a1);
/*FAST_ARRAY[ADDRESS_OF]*/void r1352for_each(T1352*C,T0*a1);
/*FAST_ARRAY[ADDRESS_OF]*/void r1352with_capacity(T1352*C,T2 a1);
/*FAST_ARRAY[ADDRESS_OF]*/void r1352next_generation(T1352*C);
/*ARRAY[FEATURE_STAMP]*/void r1357put(T1357*C,T0*a1,T2 a2);
/*ARRAY[FEATURE_STAMP]*/void r1357ensure_capacity_and_bounds(T1357*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[FEATURE_STAMP]*/void r1357add_last(T1357*C,T0*a1);
/*ARRAY[FEATURE_STAMP]*/T0*r1357item(T1357*C,T2 a1);
/*ARRAY[FEATURE_STAMP]*/void r1357clear_all(T1357*C);
/*ARRAY[FEATURE_STAMP]*/T6 r1357is_empty(T1357*C);
/*ARRAY[FEATURE_STAMP]*/void r1357set_all_with(T1357*C,T0*a1);
/*ARRAY[FEATURE_STAMP]*/void r1357with_capacity(T1357*C,T2 a1,T2 a2);
/*ARRAY[FEATURE_STAMP]*/void r1357next_generation(T1357*C);
/*ARRAY[FEATURE_STAMP]*/T2 r1357count(T1357*C);
/*ARRAY[RUN_FEATURE_2]*/void r1359swap(T1359*C,T2 a1,T2 a2);
/*ARRAY[RUN_FEATURE_2]*/void r1359put(T1359*C,T0*a1,T2 a2);
/*ARRAY[RUN_FEATURE_2]*/void r1359ensure_capacity_and_bounds(T1359*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[RUN_FEATURE_2]*/void r1359add_last(T1359*C,T0*a1);
/*ARRAY[RUN_FEATURE_2]*/void r1359for_each(T1359*C,T0*a1);
/*ARRAY[RUN_FEATURE_2]*/T0*r1359item(T1359*C,T2 a1);
/*ARRAY[RUN_FEATURE_2]*/void r1359clear_all(T1359*C);
/*ARRAY[RUN_FEATURE_2]*/void r1359set_all_with(T1359*C,T0*a1);
/*ARRAY[RUN_FEATURE_2]*/void r1359with_capacity(T1359*C,T2 a1,T2 a2);
/*ARRAY[RUN_FEATURE_2]*/void r1359next_generation(T1359*C);
/*ARRAY[RUN_FEATURE_2]*/T2 r1359count(T1359*C);
/*FAST_ARRAY[POINTER]*/void r1361make(T1361*C,T2 a1);
/*FAST_ARRAY[POINTER]*/void r1361put(T1361*C,T8 a1,T2 a2);
/*FAST_ARRAY[POINTER]*/void r1361manifest_put(T1361*C,T2 a1,T8 a2);
/*FAST_ARRAY[POINTER]*/void r1361manifest_make(T1361*C,T2 a1);
/*FAST_ARRAY[POINTER]*/void r1361next_generation(T1361*C);
/*FAST_ARRAY[AVL_SET_NODE[POSITION]]*/void r1378make(T1378*C,T2 a1);
/*FAST_ARRAY[AVL_SET_NODE[POSITION]]*/void r1378next_generation(T1378*C);
/*FAST_ARRAY[LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]]*/void r1394make(T1394*C,T2 a1);
/*FAST_ARRAY[LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]]*/void r1394put(T1394*C,T0*a1,T2 a2);
/*FAST_ARRAY[LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]]*/void r1394next_generation(T1394*C);
/*FAST_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1395make(T1395*C,T2 a1);
/*FAST_ARRAY[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1395next_generation(T1395*C);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1409make(T1409*C,T2 a1);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1409resize(T1409*C,T2 a1);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1409remove_last(T1409*C);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1409put(T1409*C,T0*a1,T2 a2);
/*FAST_ARRAY[CODE_CONTEXT]*/T0*r1409last(T1409*C);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1409add_last(T1409*C,T0*a1);
/*FAST_ARRAY[CODE_CONTEXT]*/T6 r1409is_empty(T1409*C);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1409with_capacity(T1409*C,T2 a1);
/*FAST_ARRAY[CODE_CONTEXT]*/void r1409next_generation(T1409*C);
/*FAST_ARRAY[CODE_CONTEXT]*/T2 r1409count(T1409*C);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412make(T1412*C,T2 a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412resize(T1412*C,T2 a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412put(T1412*C,T0*a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412ensure_capacity_and_bounds(T1412*C,T2 a1,T2 a2,T2 a3);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412add_last(T1412*C,T0*a1);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/T0*r1412item(T1412*C,T2 a1);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412clear_all(T1412*C);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412set_all_with(T1412*C,T0*a1);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412force(T1412*C,T0*a1,T2 a2);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/T6 r1412valid_index(T1412*C,T2 a1);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/void r1412next_generation(T1412*C);
/*ARRAY[FAST_ARRAY[CODE_CONTEXT]]*/T2 r1412count(T1412*C);
/*FAST_ARRAY[RUN_FEATURE_6]*/void r1434add_last(T1434*C,T0*a1);
/*FAST_ARRAY[RUN_FEATURE_6]*/void r1434with_capacity(T1434*C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE_6]*/void r1434next_generation(T1434*C);
/*FAST_ARRAY[RUN_FEATURE_5]*/void r1436add_last(T1436*C,T0*a1);
/*FAST_ARRAY[RUN_FEATURE_5]*/void r1436with_capacity(T1436*C,T2 a1);
/*FAST_ARRAY[RUN_FEATURE_5]*/void r1436next_generation(T1436*C);
/*FAST_ARRAY[INTERNAL_C_LOCAL]*/void r1438add_last(T1438*C,T0*a1);
/*FAST_ARRAY[INTERNAL_C_LOCAL]*/void r1438with_capacity(T1438*C,T2 a1);
/*FAST_ARRAY[INTERNAL_C_LOCAL]*/void r1438next_generation(T1438*C);
/*FAST_ARRAY[CHARACTER]*/void r1464make(T1464*C,T2 a1);
/*FAST_ARRAY[CHARACTER]*/void r1464resize(T1464*C,T2 a1);
/*FAST_ARRAY[CHARACTER]*/void r1464put(T1464*C,T3 a1,T2 a2);
/*FAST_ARRAY[CHARACTER]*/void r1464next_generation(T1464*C);
/*FAST_ARRAY[CHARACTER]*/T2 r1464count(T1464*C);
extern T0*oBC308common_free_nodes;
extern int fBC308common_free_nodes;
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911common_free_nodes(void);
/*HASHED_DICTIONARY[STRING,STRING]*/void r911make(T911*C);
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911key(T911*C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/void r911put(T911*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911new_node(T911*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[STRING,STRING]*/void r911add(T911*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911at(T911*C,T0*a1);
/*HASHED_DICTIONARY[STRING,STRING]*/void r911set_cache_user(T911*C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T2 r911prime_capacity(T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911buckets_item(T948 a1,T2 a2);
/*HASHED_DICTIONARY[STRING,STRING]*/T6 r911should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[STRING,STRING]*/T6 r911key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911reference_at(T911*C,T0*a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T2 r911prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911dispose_node(T911*C,T0*a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911item(T911*C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/void r911remove(T911*C,T0*a1);
/*HASHED_DICTIONARY[STRING,STRING]*/void r911create_with_capacity(T911*C,T2 a1);
/*HASHED_DICTIONARY[STRING,STRING]*/void r911increase_capacity(T911*C);
/*HASHED_DICTIONARY[STRING,STRING]*/void r911next_generation(T911*C);
/*HASHED_DICTIONARY[STRING,STRING]*/T2 r911hash_code(T0*a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T6 r911has(T911*C,T0*a1);
/*HASHED_DICTIONARY[STRING,STRING]*/T0*r911new_iterator_on_keys(T911*C);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T0*r917common_free_nodes(void);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/void r917make(T917*C);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T0*r917key(T917*C,T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T0*r917new_node(T917*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/void r917add(T917*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/void r917set_cache_user(T917*C,T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T2 r917prime_capacity(T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T0*r917buckets_item(T996 a1,T2 a2);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T6 r917should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T2 r917prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T0*r917item(T917*C,T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/void r917create_with_capacity(T917*C,T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/void r917increase_capacity(T917*C);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T6 r917fast_has(T917*C,T0*a1);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/void r917next_generation(T917*C);
/*HASHED_DICTIONARY[RUN_FEATURE,NATIVE]*/T2 r917hash_code(T0*a1);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T0*r919common_free_nodes(void);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r919make(T919*C);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r919put(T919*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T0*r919new_node(T919*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T2 r919prime_capacity(T2 a1);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T0*r919buckets_item(T1025 a1,T2 a2);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T6 r919should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T6 r919key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T0*r919reference_at(T919*C,T0*a1);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T2 r919prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r919create_with_capacity(T919*C,T2 a1);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r919increase_capacity(T919*C);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r919next_generation(T919*C);
/*HASHED_DICTIONARY[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/T2 r919hash_code(T0*a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0*r920common_free_nodes(void);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r920make(T920*C);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r920put(T920*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0*r920new_node(T920*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r920add(T920*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r920set_cache_user(T920*C,T2 a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T2 r920prime_capacity(T2 a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0*r920buckets_item(T1028 a1,T2 a2);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T6 r920should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T6 r920key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0*r920reference_at(T920*C,T0*a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T2 r920prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T0*r920item(T920*C,T2 a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r920create_with_capacity(T920*C,T2 a1);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r920increase_capacity(T920*C);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/void r920next_generation(T920*C);
/*HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING]*/T2 r920hash_code(T0*a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r924make(T924*C);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T0*r924common_free_nodes(void);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T0*r924new_node(T924*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r924add(T924*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T2 r924prime_capacity(T2 a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T0*r924buckets_item(T1050 a1,T2 a2);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T6 r924should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T2 r924prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r924create_with_capacity(T924*C,T2 a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r924increase_capacity(T924*C);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T6 r924fast_has(T924*C,T0*a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r924with_capacity(T924*C,T2 a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/void r924next_generation(T924*C);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T2 r924hash_code(T0*a1);
/*HASHED_DICTIONARY[TYPE,HASHED_STRING]*/T0*r924fast_reference_at(T924*C,T0*a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0*r929common_free_nodes(void);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0*r929key(T929*C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0*r929new_node(T929*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r929add(T929*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r929set_cache_user(T929*C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T2 r929prime_capacity(T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0*r929buckets_item(T1070 a1,T2 a2);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T6 r929should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T6 r929key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0*r929reference_at(T929*C,T0*a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T2 r929prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T2 r929upper(T929*C);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T0*r929item(T929*C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r929create_with_capacity(T929*C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r929increase_capacity(T929*C);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r929with_capacity(T929*C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r929next_generation(T929*C);
/*HASHED_DICTIONARY[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/T2 r929hash_code(T0*a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0*r930common_free_nodes(void);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0*r930key(T930*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0*r930fast_key_at(T930*C,T10 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0*r930new_node(T930*C,T10 a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r930add(T930*C,T10 a1,T0*a2);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r930set_cache_user(T930*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T2 r930prime_capacity(T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T0*r930buckets_item(T1073 a1,T2 a2);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T6 r930should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T2 r930prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T10 r930item(T930*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T10 r930fast_at(T930*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r930create_with_capacity(T930*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r930increase_capacity(T930*C);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T6 r930fast_has(T930*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r930with_capacity(T930*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r930next_generation(T930*C);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/void r930fast_put(T930*C,T10 a1,T0*a2);
/*HASHED_DICTIONARY[INTEGER_16,HASHED_STRING]*/T2 r930hash_code(T0*a1);
extern T0*oBC346common_free_nodes;
extern int fBC346common_free_nodes;
/*HASHED_SET[HASHED_STRING]*/T0*r931common_free_nodes(void);
/*HASHED_SET[HASHED_STRING]*/T0*r931new_node(T931*C,T0*a1,T0*a2);
/*HASHED_SET[HASHED_STRING]*/T6 r931safe_equal(T0*a1,T0*a2);
/*HASHED_SET[HASHED_STRING]*/void r931add(T931*C,T0*a1);
/*HASHED_SET[HASHED_STRING]*/void r931manifest_put(T931*C,T2 a1,T0*a2);
/*HASHED_SET[HASHED_STRING]*/T2 r931prime_capacity(T2 a1);
/*HASHED_SET[HASHED_STRING]*/T6 r931should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[HASHED_STRING]*/T0*r931reference_at(T931*C,T0*a1);
/*HASHED_SET[HASHED_STRING]*/T2 r931prime_number_ceiling(T2 a1);
/*HASHED_SET[HASHED_STRING]*/void r931manifest_make(T931*C,T2 a1);
/*HASHED_SET[HASHED_STRING]*/void r931create_with_capacity(T931*C,T2 a1);
/*HASHED_SET[HASHED_STRING]*/void r931increase_capacity(T931*C);
/*HASHED_SET[HASHED_STRING]*/void r931with_capacity(T931*C,T2 a1);
/*HASHED_SET[HASHED_STRING]*/void r931next_generation(T931*C);
/*HASHED_SET[HASHED_STRING]*/T2 r931hash_code(T0*a1);
/*REFERENCE[INTEGER_32]*/void r932set_item(T932*C,T2 a1);
/*RECYCLING_POOL[TAGGED_ERROR]*/void r936make(T936*C);
/*RECYCLING_POOL[TAGGED_ERROR]*/void r936recycle(T936*C,T0*a1);
/*RECYCLING_POOL[TAGGED_ERROR]*/void r936push(T936*C,T0*a1);
/*RECYCLING_POOL[TAGGED_ERROR]*/void r936with_capacity(T936*C,T2 a1);
/*RECYCLING_POOL[TAGGED_ERROR]*/void r936next_generation(T936*C);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T0*r937common_free_nodes(void);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/void r937make(T937*C);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T0*r937new_node(T937*C,T0*a1,T2 a2,T0*a3);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/void r937add(T937*C,T0*a1,T2 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T2 r937prime_capacity(T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T0*r937buckets_item(T1085 a1,T2 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T6 r937should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T6 r937key_safe_equal(T2 a1,T2 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T0*r937reference_at(T937*C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T2 r937prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/void r937create_with_capacity(T937*C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/void r937increase_capacity(T937*C);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/void r937next_generation(T937*C);
/*HASHED_DICTIONARY[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/T2 r937hash_code(T2 a1);
/*RING_ARRAY[TAGGED_ERROR]*/T0*r939first(T939*C);
/*RING_ARRAY[TAGGED_ERROR]*/void r939put(T939*C,T0*a1,T2 a2);
/*RING_ARRAY[TAGGED_ERROR]*/void r939move(T939*C,T2 a1,T2 a2,T2 a3);
/*RING_ARRAY[TAGGED_ERROR]*/T2 r939wrap_point(T939*C);
/*RING_ARRAY[TAGGED_ERROR]*/void r939add_last(T939*C,T0*a1);
/*RING_ARRAY[TAGGED_ERROR]*/void r939make_space_for_one(T939*C);
/*RING_ARRAY[TAGGED_ERROR]*/void r939squeeze_bubble(T939*C,T2 a1,T2 a2,T2 a3,T2 a4);
/*RING_ARRAY[TAGGED_ERROR]*/T0*r939item(T939*C,T2 a1);
/*RING_ARRAY[TAGGED_ERROR]*/T2 r939storage_upper(T939*C);
/*RING_ARRAY[TAGGED_ERROR]*/T6 r939is_empty(T939*C);
/*RING_ARRAY[TAGGED_ERROR]*/T2 r939storage_index(T939*C,T2 a1);
/*RING_ARRAY[TAGGED_ERROR]*/void r939with_capacity(T939*C,T2 a1,T2 a2);
/*RING_ARRAY[TAGGED_ERROR]*/void r939next_generation(T939*C);
/*RING_ARRAY[TAGGED_ERROR]*/void r939remove_first(T939*C);
/*RING_ARRAY[TAGGED_ERROR]*/T2 r939count(T939*C);
/*REVERSE_COLLECTION_SORTER[POSITION]*/void r940quick_sort_region(T0*a1,T2 a2,T2 a3);
/*REVERSE_COLLECTION_SORTER[POSITION]*/T6 r940lt(T351 a1,T351 a2);
/*REVERSE_COLLECTION_SORTER[POSITION]*/void r940quick_sort(T0*a1);
/*REVERSE_COLLECTION_SORTER[POSITION]*/T6 r940lte(T351 a1,T351 a2);
/*REVERSE_COLLECTION_SORTER[POSITION]*/void r940sort(T0*a1);
/*REVERSE_COLLECTION_SORTER[POSITION]*/T6 r940is_sorted(T0*a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T0*r943common_free_nodes(void);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r943make(T943*C);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T0*r943key(T943*C,T2 a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T0*r943new_node(T943*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r943add(T943*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r943set_cache_user(T943*C,T2 a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T2 r943prime_capacity(T2 a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T0*r943buckets_item(T1092 a1,T2 a2);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r943for_each(T943*C,T0*a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T6 r943should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T6 r943key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T2 r943prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T0*r943item(T943*C,T2 a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r943create_with_capacity(T943*C,T2 a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r943increase_capacity(T943*C);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/void r943next_generation(T943*C);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T2 r943hash_code(T0*a1);
/*HASHED_DICTIONARY[CECIL_FILE,STRING]*/T6 r943has(T943*C,T0*a1);
/*COLLECTION_SORTER[STRING]*/void r944add(T0*a1,T0*a2);
/*COLLECTION_SORTER[STRING]*/void r944quick_sort_region(T0*a1,T2 a2,T2 a3);
/*COLLECTION_SORTER[STRING]*/T2 r944insert_index(T0*a1,T0*a2);
/*COLLECTION_SORTER[STRING]*/T6 r944lt(T0*a1,T0*a2);
/*COLLECTION_SORTER[STRING]*/void r944quick_sort(T0*a1);
/*COLLECTION_SORTER[STRING]*/T6 r944lte(T0*a1,T0*a2);
/*COLLECTION_SORTER[STRING]*/void r944sort(T0*a1);
/*COLLECTION_SORTER[STRING]*/T6 r944is_sorted(T0*a1);
/*STACK[STRING]*/void r945make(T945*C);
/*STACK[STRING]*/void r945push(T945*C,T0*a1);
/*STACK[STRING]*/void r945pop(T945*C);
/*STACK[STRING]*/T0*r945top(T945*C);
/*STACK[STRING]*/void r945with_capacity(T945*C,T2 a1);
/*STACK[STRING]*/void r945next_generation(T945*C);
/*HASHED_DICTIONARY_NODE[STRING,STRING]*/void r947make(T947*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r953make(T953*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T0*r954new_node(T954*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r954add(T954*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T2 r954prime_capacity(T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T0*r954buckets_item(T1100 a1,T2 a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T6 r954should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r954special_common_dictionary(T954*C,T0*a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T2 r954prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r954increase_capacity(T954*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/void r954next_generation(T954*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T2 r954hash_code(T0*a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_DICTIONARY_NODE],STRING]*/T0*r954fast_reference_at(T954*C,T0*a1);
/*COLLECTION_SORTER[FIXED_STRING]*/void r957quick_sort_region(T0*a1,T2 a2,T2 a3);
/*COLLECTION_SORTER[FIXED_STRING]*/T6 r957lt(T0*a1,T0*a2);
/*COLLECTION_SORTER[FIXED_STRING]*/void r957quick_sort(T0*a1);
/*COLLECTION_SORTER[FIXED_STRING]*/T6 r957lte(T0*a1,T0*a2);
/*COLLECTION_SORTER[FIXED_STRING]*/void r957sort(T0*a1);
/*COLLECTION_SORTER[FIXED_STRING]*/T6 r957is_sorted(T0*a1);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T0*r964common_free_nodes(void);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r964make(T964*C);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T0*r964new_node(T964*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r964add(T964*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T2 r964prime_capacity(T2 a1);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T0*r964buckets_item(T1114 a1,T2 a2);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T6 r964should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T6 r964key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T0*r964reference_at(T964*C,T0*a1);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T2 r964prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r964create_with_capacity(T964*C,T2 a1);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r964increase_capacity(T964*C);
/*HASHED_DICTIONARY[CLASSES,STRING]*/void r964next_generation(T964*C);
/*HASHED_DICTIONARY[CLASSES,STRING]*/T2 r964hash_code(T0*a1);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T0*r966common_free_nodes(void);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r966make(T966*C);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T0*r966new_node(T966*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r966add(T966*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T2 r966prime_capacity(T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T0*r966buckets_item(T1117 a1,T2 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T6 r966should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T6 r966key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T0*r966reference_at(T966*C,T0*a1);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T2 r966prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r966create_with_capacity(T966*C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r966increase_capacity(T966*C);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/void r966next_generation(T966*C);
/*HASHED_DICTIONARY[FAST_ARRAY[STRING],CLASS_NAME]*/T2 r966hash_code(T0*a1);
/*HASHED_SET[CLASS_NAME]*/T0*r968common_free_nodes(void);
/*HASHED_SET[CLASS_NAME]*/void r968make(T968*C);
/*HASHED_SET[CLASS_NAME]*/T0*r968new_node(T968*C,T0*a1,T0*a2);
/*HASHED_SET[CLASS_NAME]*/void r968add(T968*C,T0*a1);
/*HASHED_SET[CLASS_NAME]*/T6 r968safe_equal(T0*a1,T0*a2);
/*HASHED_SET[CLASS_NAME]*/T2 r968prime_capacity(T2 a1);
/*HASHED_SET[CLASS_NAME]*/T6 r968should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[CLASS_NAME]*/T2 r968prime_number_ceiling(T2 a1);
/*HASHED_SET[CLASS_NAME]*/T0*r968dispose_node(T968*C,T0*a1);
/*HASHED_SET[CLASS_NAME]*/void r968clear_count(T968*C);
/*HASHED_SET[CLASS_NAME]*/void r968create_with_capacity(T968*C,T2 a1);
/*HASHED_SET[CLASS_NAME]*/void r968increase_capacity(T968*C);
/*HASHED_SET[CLASS_NAME]*/void r968next_generation(T968*C);
/*HASHED_SET[CLASS_NAME]*/T2 r968hash_code(T0*a1);
/*HASHED_SET[CLASS_NAME]*/T6 r968has(T968*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T0*r970common_free_nodes(void);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r970make(T970*C);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r970put(T970*C,T2 a1,T0*a2);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T0*r970new_node(T970*C,T2 a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T2 r970at(T970*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T0*r970internal_key(T970*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T2 r970prime_capacity(T2 a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T0*r970buckets_item(T1123 a1,T2 a2);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T6 r970should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T6 r970key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T2 r970prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r970create_with_capacity(T970*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r970increase_capacity(T970*C);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/void r970next_generation(T970*C);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T2 r970hash_code(T0*a1);
/*HASHED_DICTIONARY[INTEGER_32,CLASS_NAME]*/T6 r970has(T970*C,T0*a1);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973add_first(T973*C,T0*a1);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973put(T973*C,T0*a1,T2 a2);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973move(T973*C,T2 a1,T2 a2,T2 a3);
/*RING_ARRAY[FORMAL_ARG_LIST]*/T2 r973wrap_point(T973*C);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973make_space_for_one(T973*C);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973squeeze_bubble(T973*C,T2 a1,T2 a2,T2 a3,T2 a4);
/*RING_ARRAY[FORMAL_ARG_LIST]*/T0*r973item(T973*C,T2 a1);
/*RING_ARRAY[FORMAL_ARG_LIST]*/T2 r973storage_upper(T973*C);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973clear_count(T973*C);
/*RING_ARRAY[FORMAL_ARG_LIST]*/T6 r973is_empty(T973*C);
/*RING_ARRAY[FORMAL_ARG_LIST]*/T2 r973storage_index(T973*C,T2 a1);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973with_capacity(T973*C,T2 a1,T2 a2);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973next_generation(T973*C);
/*RING_ARRAY[FORMAL_ARG_LIST]*/void r973remove_first(T973*C);
/*RING_ARRAY[FORMAL_ARG_LIST]*/T2 r973count(T973*C);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974add_first(T974*C,T0*a1);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974put(T974*C,T0*a1,T2 a2);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974move(T974*C,T2 a1,T2 a2,T2 a3);
/*RING_ARRAY[LOCAL_VAR_LIST]*/T2 r974wrap_point(T974*C);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974make_space_for_one(T974*C);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974squeeze_bubble(T974*C,T2 a1,T2 a2,T2 a3,T2 a4);
/*RING_ARRAY[LOCAL_VAR_LIST]*/T0*r974item(T974*C,T2 a1);
/*RING_ARRAY[LOCAL_VAR_LIST]*/T2 r974storage_upper(T974*C);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974clear_count(T974*C);
/*RING_ARRAY[LOCAL_VAR_LIST]*/T6 r974is_empty(T974*C);
/*RING_ARRAY[LOCAL_VAR_LIST]*/T2 r974storage_index(T974*C,T2 a1);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974with_capacity(T974*C,T2 a1,T2 a2);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974next_generation(T974*C);
/*RING_ARRAY[LOCAL_VAR_LIST]*/void r974remove_first(T974*C);
/*RING_ARRAY[LOCAL_VAR_LIST]*/T2 r974count(T974*C);
/*STACK[TMP_FEATURE]*/void r978make(T978*C);
/*STACK[TMP_FEATURE]*/void r978push(T978*C,T0*a1);
/*STACK[TMP_FEATURE]*/T6 r978is_empty(T978*C);
/*STACK[TMP_FEATURE]*/void r978pop(T978*C);
/*STACK[TMP_FEATURE]*/T0*r978top(T978*C);
/*STACK[TMP_FEATURE]*/void r978with_capacity(T978*C,T2 a1);
/*STACK[TMP_FEATURE]*/void r978next_generation(T978*C);
/*HASHED_SET[LIVE_TYPE]*/void r989make(T989*C);
/*HASHED_SET[LIVE_TYPE]*/T0*r989common_free_nodes(void);
/*HASHED_SET[LIVE_TYPE]*/T0*r989new_node(T989*C,T0*a1,T0*a2);
/*HASHED_SET[LIVE_TYPE]*/void r989set_cache_user(T989*C,T2 a1);
/*HASHED_SET[LIVE_TYPE]*/T2 r989prime_capacity(T2 a1);
/*HASHED_SET[LIVE_TYPE]*/T6 r989should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[LIVE_TYPE]*/T2 r989prime_number_ceiling(T2 a1);
/*HASHED_SET[LIVE_TYPE]*/T0*r989dispose_node(T989*C,T0*a1);
/*HASHED_SET[LIVE_TYPE]*/T0*r989item(T989*C,T2 a1);
/*HASHED_SET[LIVE_TYPE]*/void r989clear_count(T989*C);
/*HASHED_SET[LIVE_TYPE]*/void r989create_with_capacity(T989*C,T2 a1);
/*HASHED_SET[LIVE_TYPE]*/void r989increase_capacity(T989*C);
/*HASHED_SET[LIVE_TYPE]*/T6 r989fast_has(T989*C,T0*a1);
/*HASHED_SET[LIVE_TYPE]*/void r989with_capacity(T989*C,T2 a1);
/*HASHED_SET[LIVE_TYPE]*/void r989next_generation(T989*C);
/*HASHED_SET[LIVE_TYPE]*/T2 r989hash_code(T0*a1);
/*HASHED_SET[LIVE_TYPE]*/void r989fast_add(T989*C,T0*a1);
typedef struct _se_agenT990f817l57c25 se_agenT990f817l57c25;
struct _se_agenT990f817l57c25{Tid id;
int creation_mold_id;
T6(*afp)(se_agenT990f817l57c25*,T0*,T0*);
int (*eq)(se_agent*,se_agent*);
T6 R;
};
/*agent creation*/T0*agenT990f817l57c25(void);
/*COMPARATOR_COLLECTION_SORTER[RUN_FEATURE_2]*/void r990default_create(T990*C);
/*COMPARATOR_COLLECTION_SORTER[RUN_FEATURE_2]*/void r990quick_sort_region(T990*C,T0*a1,T2 a2,T2 a3);
/*COMPARATOR_COLLECTION_SORTER[RUN_FEATURE_2]*/T6 r990lt(T990*C,T0*a1,T0*a2);
/*COMPARATOR_COLLECTION_SORTER[RUN_FEATURE_2]*/void r990quick_sort(T990*C,T0*a1);
/*COMPARATOR_COLLECTION_SORTER[RUN_FEATURE_2]*/T6 r990lte(T990*C,T0*a1,T0*a2);
/*COMPARATOR_COLLECTION_SORTER[RUN_FEATURE_2]*/void r990sort(T990*C,T0*a1);
/*COMPARATOR_COLLECTION_SORTER[RUN_FEATURE_2]*/T6 r990is_sorted(T990*C,T0*a1);
/*HASHED_DICTIONARY_NODE[RUN_FEATURE,NATIVE]*/void r995make(T995*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T0*r998common_free_nodes(void);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T0*r998new_node(T998*C,T1 a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/void r998add(T998*C,T1 a1,T0*a2);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T2 r998prime_capacity(T2 a1);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T0*r998buckets_item(T1161 a1,T2 a2);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T6 r998should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T2 r998prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T1 r998fast_at(T998*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/void r998create_with_capacity(T998*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/void r998increase_capacity(T998*C);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T6 r998fast_has(T998*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/void r998with_capacity(T998*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/void r998next_generation(T998*C);
/*HASHED_DICTIONARY[INTEGER_8,CLASS_TEXT]*/T2 r998hash_code(T0*a1);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/T0*r999common_free_nodes(void);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/void r999make(T999*C);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/T0*r999new_node(T999*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/void r999add(T999*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/T2 r999prime_capacity(T2 a1);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/T0*r999buckets_item(T1164 a1,T2 a2);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/T6 r999should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/T2 r999prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/void r999create_with_capacity(T999*C,T2 a1);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/void r999increase_capacity(T999*C);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/void r999next_generation(T999*C);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/T2 r999hash_code(T0*a1);
/*HASHED_DICTIONARY[TAGGED_DATA,FIXED_STRING]*/T0*r999fast_reference_at(T999*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0*r1000common_free_nodes(void);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r1000make(T1000*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0*r1000key(T1000*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0*r1000new_node(T1000*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r1000add(T1000*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0*r1000at(T1000*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r1000set_cache_user(T1000*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0*r1000internal_key(T1000*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T2 r1000prime_capacity(T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0*r1000buckets_item(T1171 a1,T2 a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T6 r1000should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0*r1000reference_at(T1000*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T6 r1000key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T2 r1000prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T0*r1000item(T1000*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r1000create_with_capacity(T1000*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r1000increase_capacity(T1000*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r1000next_generation(T1000*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T2 r1000hash_code(T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_NAME]*/T6 r1000has(T1000*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0*r1001common_free_nodes(void);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0*r1001key(T1001*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0*r1001new_node(T1001*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001fast_remove(T1001*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001add(T1001*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001set_cache_user(T1001*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T2 r1001prime_capacity(T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0*r1001buckets_item(T1174 a1,T2 a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T6 r1001should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T6 r1001key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T2 r1001prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T2 r1001upper(T1001*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0*r1001dispose_node(T1001*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0*r1001item(T1001*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T0*r1001fast_at(T1001*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001remove(T1001*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001clear_count(T1001*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001create_with_capacity(T1001*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001increase_capacity(T1001*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T6 r1001fast_has(T1001*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001with_capacity(T1001*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001next_generation(T1001*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1001fast_put(T1001*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,FEATURE_STAMP]*/T2 r1001hash_code(T0*a1);
/*STACK[ANONYMOUS_FEATURE]*/void r1010push(T1010*C,T0*a1);
/*STACK[ANONYMOUS_FEATURE]*/T6 r1010is_empty(T1010*C);
/*STACK[ANONYMOUS_FEATURE]*/void r1010pop(T1010*C);
/*STACK[ANONYMOUS_FEATURE]*/T0*r1010top(T1010*C);
/*STACK[ANONYMOUS_FEATURE]*/void r1010with_capacity(T1010*C,T2 a1);
/*STACK[ANONYMOUS_FEATURE]*/void r1010next_generation(T1010*C);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0*r1011common_free_nodes(void);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0*r1011new_node(T1011*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r1011add(T1011*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r1011set_cache_user(T1011*C,T2 a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T2 r1011prime_capacity(T2 a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0*r1011buckets_item(T1181 a1,T2 a2);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T6 r1011should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T2 r1011prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0*r1011item(T1011*C,T2 a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r1011create_with_capacity(T1011*C,T2 a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r1011increase_capacity(T1011*C);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r1011with_capacity(T1011*C,T2 a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/void r1011next_generation(T1011*C);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T2 r1011hash_code(T0*a1);
/*HASHED_DICTIONARY[GRAPH_NODE,TYPE]*/T0*r1011fast_reference_at(T1011*C,T0*a1);
/*HASHED_SET[TYPE]*/T0*r1013common_free_nodes(void);
/*HASHED_SET[TYPE]*/void r1013make(T1013*C);
/*HASHED_SET[TYPE]*/T0*r1013new_node(T1013*C,T0*a1,T0*a2);
/*HASHED_SET[TYPE]*/T6 r1013safe_equal(T0*a1,T0*a2);
/*HASHED_SET[TYPE]*/void r1013add(T1013*C,T0*a1);
/*HASHED_SET[TYPE]*/void r1013set_cache_user(T1013*C,T2 a1);
/*HASHED_SET[TYPE]*/T2 r1013prime_capacity(T2 a1);
/*HASHED_SET[TYPE]*/T6 r1013should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[TYPE]*/T2 r1013prime_number_ceiling(T2 a1);
/*HASHED_SET[TYPE]*/T0*r1013dispose_node(T1013*C,T0*a1);
/*HASHED_SET[TYPE]*/T0*r1013item(T1013*C,T2 a1);
/*HASHED_SET[TYPE]*/void r1013remove(T1013*C,T0*a1);
/*HASHED_SET[TYPE]*/void r1013clear_count(T1013*C);
/*HASHED_SET[TYPE]*/void r1013create_with_capacity(T1013*C,T2 a1);
/*HASHED_SET[TYPE]*/void r1013increase_capacity(T1013*C);
/*HASHED_SET[TYPE]*/T6 r1013fast_has(T1013*C,T0*a1);
/*HASHED_SET[TYPE]*/void r1013next_generation(T1013*C);
/*HASHED_SET[TYPE]*/T2 r1013hash_code(T0*a1);
/*HASHED_SET[TYPE]*/T6 r1013has(T1013*C,T0*a1);
/*HASHED_SET[TYPE]*/void r1013fast_add(T1013*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T0*r1014common_free_nodes(void);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T0*r1014new_node(T1014*C,T1 a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/void r1014add(T1014*C,T1 a1,T0*a2);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T2 r1014prime_capacity(T2 a1);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T0*r1014buckets_item(T1187 a1,T2 a2);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T6 r1014should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T2 r1014prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T1 r1014fast_at(T1014*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/void r1014create_with_capacity(T1014*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/void r1014increase_capacity(T1014*C);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T6 r1014fast_has(T1014*C,T0*a1);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/void r1014with_capacity(T1014*C,T2 a1);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/void r1014next_generation(T1014*C);
/*HASHED_DICTIONARY[INTEGER_8,TYPE]*/T2 r1014hash_code(T0*a1);
extern T0*oBC715common_free_nodes;
extern int fBC715common_free_nodes;
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1018common_free_nodes(void);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1018key(T1018*C,T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1018fast_key_at(T1018*C,T0*a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1018new_node(T1018*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1018add(T1018*C,T0*a1,T0*a2);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1018set_cache_user(T1018*C,T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1018internal_key(T1018*C,T0*a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T2 r1018prime_capacity(T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T6 r1018should_increase_capacity(T2 a1,T2 a2);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T6 r1018key_safe_equal(T0*a1,T0*a2);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1018reference_at(T1018*C,T0*a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T2 r1018prime_number_ceiling(T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1018item(T1018*C,T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1018increase_capacity(T1018*C);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1018with_capacity(T1018*C,T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1018next_generation(T1018*C);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1018basic_make(T1018*C,T2 a1);
/*HASHED_BIJECTIVE_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T6 r1018has(T1018*C,T0*a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T0*r1021common_free_nodes(void);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T0*r1021new_node(T1021*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/void r1021add(T1021*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T2 r1021prime_capacity(T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T0*r1021buckets_item(T1200 a1,T2 a2);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T6 r1021should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T2 r1021prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/void r1021create_with_capacity(T1021*C,T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/void r1021increase_capacity(T1021*C);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T6 r1021fast_has(T1021*C,T0*a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/void r1021with_capacity(T1021*C,T2 a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/void r1021next_generation(T1021*C);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T2 r1021hash_code(T0*a1);
/*HASHED_DICTIONARY[RUN_FEATURE,TYPE]*/T0*r1021fast_reference_at(T1021*C,T0*a1);
/*HASHED_DICTIONARY_NODE[HASHED_DICTIONARY[CLASS_TEXT,HASHED_STRING],STRING]*/void r1024make(T1024*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[CLASS_TEXT,HASHED_STRING]*/void r1027make(T1027*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET[STRING]*/void r1036make(T1036*C);
/*HASHED_SET[STRING]*/T0*r1036common_free_nodes(void);
/*HASHED_SET[STRING]*/T0*r1036new_node(T1036*C,T0*a1,T0*a2);
/*HASHED_SET[STRING]*/T6 r1036safe_equal(T0*a1,T0*a2);
/*HASHED_SET[STRING]*/void r1036add(T1036*C,T0*a1);
/*HASHED_SET[STRING]*/void r1036manifest_put(T1036*C,T2 a1,T0*a2);
/*HASHED_SET[STRING]*/T2 r1036prime_capacity(T2 a1);
/*HASHED_SET[STRING]*/T6 r1036should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[STRING]*/T2 r1036prime_number_ceiling(T2 a1);
/*HASHED_SET[STRING]*/T0*r1036dispose_node(T1036*C,T0*a1);
/*HASHED_SET[STRING]*/void r1036clear_count(T1036*C);
/*HASHED_SET[STRING]*/void r1036manifest_make(T1036*C,T2 a1);
/*HASHED_SET[STRING]*/void r1036create_with_capacity(T1036*C,T2 a1);
/*HASHED_SET[STRING]*/void r1036increase_capacity(T1036*C);
/*HASHED_SET[STRING]*/T6 r1036fast_has(T1036*C,T0*a1);
/*HASHED_SET[STRING]*/void r1036with_capacity(T1036*C,T2 a1);
/*HASHED_SET[STRING]*/void r1036next_generation(T1036*C);
/*HASHED_SET[STRING]*/T2 r1036hash_code(T0*a1);
/*HASHED_SET[STRING]*/T6 r1036has(T1036*C,T0*a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0*r1037common_free_nodes(void);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r1037put(T1037*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0*r1037new_node(T1037*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r1037set_cache_user(T1037*C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T2 r1037prime_capacity(T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0*r1037buckets_item(T1208 a1,T2 a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T6 r1037should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T6 r1037key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T2 r1037prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0*r1037dispose_node(T1037*C,T0*a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T0*r1037item(T1037*C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r1037clear_count(T1037*C);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r1037create_with_capacity(T1037*C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r1037increase_capacity(T1037*C);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r1037with_capacity(T1037*C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/void r1037next_generation(T1037*C);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T2 r1037hash_code(T0*a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,STRING]*/T6 r1037has(T1037*C,T0*a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0*r1038common_free_nodes(void);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r1038put(T1038*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0*r1038new_node(T1038*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r1038set_cache_user(T1038*C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T2 r1038prime_capacity(T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0*r1038buckets_item(T1211 a1,T2 a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T6 r1038should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T6 r1038key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0*r1038reference_at(T1038*C,T0*a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T2 r1038prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0*r1038dispose_node(T1038*C,T0*a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T0*r1038item(T1038*C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r1038clear_count(T1038*C);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r1038create_with_capacity(T1038*C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r1038increase_capacity(T1038*C);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r1038with_capacity(T1038*C,T2 a1);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/void r1038next_generation(T1038*C);
/*HASHED_DICTIONARY[MANIFEST_STRING,MANIFEST_STRING]*/T2 r1038hash_code(T0*a1);
/*HASHED_SET[MANIFEST_GENERIC]*/T0*r1039common_free_nodes(void);
/*HASHED_SET[MANIFEST_GENERIC]*/void r1039make(T1039*C);
/*HASHED_SET[MANIFEST_GENERIC]*/T0*r1039new_node(T1039*C,T0*a1,T0*a2);
/*HASHED_SET[MANIFEST_GENERIC]*/T6 r1039safe_equal(T0*a1,T0*a2);
/*HASHED_SET[MANIFEST_GENERIC]*/void r1039add(T1039*C,T0*a1);
/*HASHED_SET[MANIFEST_GENERIC]*/void r1039set_cache_user(T1039*C,T2 a1);
/*HASHED_SET[MANIFEST_GENERIC]*/T2 r1039prime_capacity(T2 a1);
/*HASHED_SET[MANIFEST_GENERIC]*/void r1039for_each(T1039*C,T0*a1);
/*HASHED_SET[MANIFEST_GENERIC]*/T6 r1039should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[MANIFEST_GENERIC]*/T2 r1039prime_number_ceiling(T2 a1);
/*HASHED_SET[MANIFEST_GENERIC]*/T0*r1039dispose_node(T1039*C,T0*a1);
/*HASHED_SET[MANIFEST_GENERIC]*/T0*r1039item(T1039*C,T2 a1);
/*HASHED_SET[MANIFEST_GENERIC]*/void r1039clear_count(T1039*C);
/*HASHED_SET[MANIFEST_GENERIC]*/void r1039create_with_capacity(T1039*C,T2 a1);
/*HASHED_SET[MANIFEST_GENERIC]*/void r1039increase_capacity(T1039*C);
/*HASHED_SET[MANIFEST_GENERIC]*/void r1039next_generation(T1039*C);
/*HASHED_SET[MANIFEST_GENERIC]*/T2 r1039hash_code(T0*a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0*r1041common_free_nodes(void);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r1041make(T1041*C);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0*r1041key(T1041*C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0*r1041new_node(T1041*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r1041add(T1041*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r1041set_cache_user(T1041*C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T2 r1041prime_capacity(T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0*r1041buckets_item(T1217 a1,T2 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T6 r1041should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T6 r1041key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0*r1041reference_at(T1041*C,T0*a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T2 r1041prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T0*r1041item(T1041*C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r1041create_with_capacity(T1041*C,T2 a1);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r1041increase_capacity(T1041*C);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r1041next_generation(T1041*C);
/*HASHED_DICTIONARY[FAST_ARRAY[AGENT_CREATION],TYPE]*/T2 r1041hash_code(T0*a1);
/*HASHED_SET[AGENT_ARGS]*/T0*r1044common_free_nodes(void);
/*HASHED_SET[AGENT_ARGS]*/void r1044make(T1044*C);
/*HASHED_SET[AGENT_ARGS]*/T0*r1044new_node(T1044*C,T0*a1,T0*a2);
/*HASHED_SET[AGENT_ARGS]*/T6 r1044safe_equal(T0*a1,T0*a2);
/*HASHED_SET[AGENT_ARGS]*/void r1044add(T1044*C,T0*a1);
/*HASHED_SET[AGENT_ARGS]*/void r1044set_cache_user(T1044*C,T2 a1);
/*HASHED_SET[AGENT_ARGS]*/T2 r1044prime_capacity(T2 a1);
/*HASHED_SET[AGENT_ARGS]*/T6 r1044should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[AGENT_ARGS]*/T2 r1044prime_number_ceiling(T2 a1);
/*HASHED_SET[AGENT_ARGS]*/T0*r1044dispose_node(T1044*C,T0*a1);
/*HASHED_SET[AGENT_ARGS]*/T0*r1044item(T1044*C,T2 a1);
/*HASHED_SET[AGENT_ARGS]*/void r1044clear_count(T1044*C);
/*HASHED_SET[AGENT_ARGS]*/void r1044create_with_capacity(T1044*C,T2 a1);
/*HASHED_SET[AGENT_ARGS]*/void r1044increase_capacity(T1044*C);
/*HASHED_SET[AGENT_ARGS]*/void r1044next_generation(T1044*C);
/*HASHED_SET[AGENT_ARGS]*/T2 r1044hash_code(T0*a1);
/*HASHED_SET[AGENT_ARGS]*/T6 r1044has(T1044*C,T0*a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0*r1045common_free_nodes(void);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r1045make(T1045*C);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0*r1045key(T1045*C,T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0*r1045new_node(T1045*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r1045set_cache_user(T1045*C,T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T2 r1045prime_capacity(T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0*r1045buckets_item(T1223 a1,T2 a2);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T6 r1045should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T2 r1045prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0*r1045dispose_node(T1045*C,T0*a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0*r1045item(T1045*C,T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r1045clear_count(T1045*C);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r1045create_with_capacity(T1045*C,T2 a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r1045increase_capacity(T1045*C);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r1045next_generation(T1045*C);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/void r1045fast_put(T1045*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T2 r1045hash_code(T0*a1);
/*HASHED_DICTIONARY[HASHED_SET[TYPE],TYPE]*/T0*r1045fast_reference_at(T1045*C,T0*a1);
/*HASHED_DICTIONARY_NODE[TYPE,HASHED_STRING]*/void r1049make(T1049*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1053common_free_nodes(void);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1053new_node(T1053*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1053add(T1053*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1053set_cache_user(T1053*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T2 r1053prime_capacity(T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1053buckets_item(T1228 a1,T2 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T6 r1053should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T6 r1053key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1053reference_at(T1053*C,T0*a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T2 r1053prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T0*r1053item(T1053*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1053create_with_capacity(T1053*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1053increase_capacity(T1053*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1053with_capacity(T1053*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/void r1053next_generation(T1053*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,FEATURE_NAME]*/T2 r1053hash_code(T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0*r1055common_free_nodes(void);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0*r1055new_node(T1055*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r1055add(T1055*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T2 r1055prime_capacity(T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0*r1055buckets_item(T1235 a1,T2 a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T6 r1055should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T6 r1055key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0*r1055reference_at(T1055*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T2 r1055prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T0*r1055dispose_node(T1055*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r1055clear_count(T1055*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r1055create_with_capacity(T1055*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r1055increase_capacity(T1055*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r1055with_capacity(T1055*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r1055next_generation(T1055*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T2 r1055hash_code(T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/T6 r1055has(T1055*C,T0*a1);
/*QUEUE[TYPE]*/T0*r1056first(T1056*C);
/*QUEUE[TYPE]*/void r1056put(T1056*C,T0*a1,T2 a2);
/*QUEUE[TYPE]*/void r1056add(T1056*C,T0*a1);
/*QUEUE[TYPE]*/void r1056move(T1056*C,T2 a1,T2 a2,T2 a3);
/*QUEUE[TYPE]*/void r1056collection_with_capacity(T1056*C,T2 a1,T2 a2);
/*QUEUE[TYPE]*/T2 r1056wrap_point(T1056*C);
/*QUEUE[TYPE]*/void r1056make_space_for_one(T1056*C);
/*QUEUE[TYPE]*/void r1056squeeze_bubble(T1056*C,T2 a1,T2 a2,T2 a3,T2 a4);
/*QUEUE[TYPE]*/T0*r1056item(T1056*C,T2 a1);
/*QUEUE[TYPE]*/T2 r1056storage_upper(T1056*C);
/*QUEUE[TYPE]*/void r1056remove(T1056*C);
/*QUEUE[TYPE]*/T6 r1056is_empty(T1056*C);
/*QUEUE[TYPE]*/T2 r1056storage_index(T1056*C,T2 a1);
/*QUEUE[TYPE]*/void r1056with_capacity(T1056*C,T2 a1);
/*QUEUE[TYPE]*/void r1056next_generation(T1056*C);
/*QUEUE[TYPE]*/T2 r1056count(T1056*C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T0*r1057common_free_nodes(void);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r1057make(T1057*C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T0*r1057new_node(T1057*C,T348 a1,T0*a2);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T6 r1057safe_equal(T348 a1,T348 a2);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r1057add(T1057*C,T348 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r1057set_cache_user(T1057*C,T2 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T2 r1057prime_capacity(T2 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T6 r1057should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T2 r1057prime_number_ceiling(T2 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T0*r1057dispose_node(T1057*C,T0*a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T348 r1057item(T1057*C,T2 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r1057clear_count(T1057*C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r1057create_with_capacity(T1057*C,T2 a1);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r1057increase_capacity(T1057*C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/void r1057next_generation(T1057*C);
/*HASHED_SET[ABSOLUTE_FEATURE_NAME]*/T2 r1057hash_code(T348 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0*r1058common_free_nodes(void);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058make(T1058*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T348 r1058key(T1058*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058put(T1058*C,T0*a1,T348 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0*r1058new_node(T1058*C,T0*a1,T348 a2,T0*a3);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058add(T1058*C,T0*a1,T348 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0*r1058at(T1058*C,T348 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058set_cache_user(T1058*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T2 r1058prime_capacity(T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0*r1058buckets_item(T1241 a1,T2 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T6 r1058should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T6 r1058key_safe_equal(T348 a1,T348 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0*r1058reference_at(T1058*C,T348 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T2 r1058prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0*r1058dispose_node(T1058*C,T0*a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T0*r1058item(T1058*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058remove(T1058*C,T348 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058clear_count(T1058*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058create_with_capacity(T1058*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058increase_capacity(T1058*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1058next_generation(T1058*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T2 r1058hash_code(T348 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/T6 r1058has(T1058*C,T348 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r1063make(T1063*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0*r1063common_free_nodes(void);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r1063put(T1063*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0*r1063new_node(T1063*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r1063add(T1063*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T2 r1063prime_capacity(T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0*r1063buckets_item(T1244 a1,T2 a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T6 r1063should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T6 r1063key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T2 r1063prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0*r1063fast_at(T1063*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r1063create_with_capacity(T1063*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r1063increase_capacity(T1063*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T6 r1063fast_has(T1063*C,T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r1063with_capacity(T1063*C,T2 a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r1063next_generation(T1063*C);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/void r1063fast_put(T1063*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T2 r1063hash_code(T0*a1);
/*HASHED_DICTIONARY[ANONYMOUS_FEATURE,TYPE]*/T0*r1063fast_reference_at(T1063*C,T0*a1);
/*HASHED_DICTIONARY_NODE[DICTIONARY[INTEGER_16,HASHED_STRING],STRING]*/void r1069make(T1069*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[INTEGER_16,HASHED_STRING]*/void r1072make(T1072*C,T10 a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[HASHED_STRING]*/void r1075make(T1075*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T0*r1079common_free_nodes(void);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r1079make(T1079*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T0*r1079new_node(T1079*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r1079add(T1079*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T2 r1079prime_capacity(T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T0*r1079buckets_item(T1249 a1,T2 a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T6 r1079should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T2 r1079prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r1079create_with_capacity(T1079*C,T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r1079increase_capacity(T1079*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r1079next_generation(T1079*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T2 r1079hash_code(T0*a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/T0*r1079fast_reference_at(T1079*C,T0*a1);
/*AVL_SET[LIVE_TYPE]*/T0*r1084a_new_node(void);
/*AVL_SET[LIVE_TYPE]*/void r1084make(T1084*C);
/*AVL_SET[LIVE_TYPE]*/T0*r1084fast_do_insert(T1084*C,T0*a1);
/*AVL_SET[LIVE_TYPE]*/T0*r1084new_node(T1084*C);
/*AVL_SET[LIVE_TYPE]*/T0*r1084left_grown(T1084*C,T0*a1);
/*AVL_SET[LIVE_TYPE]*/void r1084for_each(T1084*C,T0*a1);
/*AVL_SET[LIVE_TYPE]*/void r1084build_map(T1084*C);
/*AVL_SET[LIVE_TYPE]*/void r1084set_item(T1084*C,T0*a1);
/*AVL_SET[LIVE_TYPE]*/T0*r1084item(T1084*C,T2 a1);
/*AVL_SET[LIVE_TYPE]*/T0*r1084right_grown(T1084*C,T0*a1);
/*AVL_SET[LIVE_TYPE]*/void r1084clear_count(T1084*C);
/*AVL_SET[LIVE_TYPE]*/void r1084clear_nodes(T1084*C,T0*a1);
/*AVL_SET[LIVE_TYPE]*/T6 r1084fast_has(T1084*C,T0*a1);
/*AVL_SET[LIVE_TYPE]*/T0*r1084lost_nodes(T1084*C);
/*AVL_SET[LIVE_TYPE]*/void r1084next_generation(T1084*C);
extern T0*oBC724lost_nodes_pool;
extern int fBC724lost_nodes_pool;
/*AVL_SET[LIVE_TYPE]*/T0*r1084lost_nodes_pool(void);
/*AVL_SET[LIVE_TYPE]*/T6 r1084ordered(T0*a1,T0*a2);
/*AVL_SET[LIVE_TYPE]*/void r1084fast_add(T1084*C,T0*a1);
/*HASHED_DICTIONARY_NODE[FAST_ARRAY[FIXED_STRING],INTEGER_32]*/void r1086make(T1086*C,T0*a1,T2 a2,T0*a3);
/*HASHED_DICTIONARY_NODE[CECIL_FILE,STRING]*/void r1091make(T1091*C,T0*a1,T0*a2,T0*a3);
/*RING_ARRAY[SE_CONFIG]*/void r1095make(T1095*C,T2 a1,T2 a2);
/*RING_ARRAY[SE_CONFIG]*/void r1095add_first(T1095*C,T0*a1);
/*RING_ARRAY[SE_CONFIG]*/void r1095put(T1095*C,T0*a1,T2 a2);
/*RING_ARRAY[SE_CONFIG]*/void r1095move(T1095*C,T2 a1,T2 a2,T2 a3);
/*RING_ARRAY[SE_CONFIG]*/T2 r1095wrap_point(T1095*C);
/*RING_ARRAY[SE_CONFIG]*/void r1095make_space_for_one(T1095*C);
/*RING_ARRAY[SE_CONFIG]*/void r1095squeeze_bubble(T1095*C,T2 a1,T2 a2,T2 a3,T2 a4);
/*RING_ARRAY[SE_CONFIG]*/T0*r1095item(T1095*C,T2 a1);
/*RING_ARRAY[SE_CONFIG]*/T2 r1095storage_upper(T1095*C);
/*RING_ARRAY[SE_CONFIG]*/void r1095clear_all(T1095*C);
/*RING_ARRAY[SE_CONFIG]*/T6 r1095is_empty(T1095*C);
/*RING_ARRAY[SE_CONFIG]*/T2 r1095storage_index(T1095*C,T2 a1);
/*RING_ARRAY[SE_CONFIG]*/void r1095set_all_with(T1095*C,T0*a1);
/*RING_ARRAY[SE_CONFIG]*/void r1095next_generation(T1095*C);
/*RING_ARRAY[SE_CONFIG]*/T2 r1095count(T1095*C);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T0*r1098common_free_nodes(void);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r1098make(T1098*C);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r1098put(T1098*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T0*r1098new_node(T1098*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T2 r1098prime_capacity(T2 a1);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T0*r1098buckets_item(T1264 a1,T2 a2);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T6 r1098should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T0*r1098reference_at(T1098*C,T0*a1);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T6 r1098key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T2 r1098prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r1098create_with_capacity(T1098*C,T2 a1);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r1098increase_capacity(T1098*C);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/void r1098next_generation(T1098*C);
/*HASHED_DICTIONARY[SE_C_MODE,STRING]*/T2 r1098hash_code(T0*a1);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/void r1101make(T1101*C,T2 a1,T2 a2);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/T0*r1101first(T1101*C);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/T2 r1101storage_upper(T1101*C);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/void r1101clear_all(T1101*C);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/T6 r1101is_empty(T1101*C);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/T2 r1101storage_index(T1101*C,T2 a1);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/void r1101set_all_with(T1101*C,T0*a1);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/void r1101next_generation(T1101*C);
/*RING_ARRAY[PROCEDURE[TUPLE]]*/void r1101remove_first(T1101*C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0*r1105common_free_nodes(void);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105make(T1105*C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0*r1105new_node(T1105*C,T0*a1,T0*a2,T0*a3);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105add(T1105*C,T0*a1,T0*a2);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0*r1105at(T1105*C,T0*a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T2 r1105prime_capacity(T2 a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0*r1105buckets_item(T1267 a1,T2 a2);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T6 r1105should_increase_capacity(T2 a1,T2 a2);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0*r1105reference_at(T1105*C,T0*a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T6 r1105key_safe_equal(T0*a1,T0*a2);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T2 r1105prime_number_ceiling(T2 a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0*r1105dispose_node(T1105*C,T0*a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105clear_count(T1105*C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105create_with_capacity(T1105*C,T2 a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105increase_capacity(T1105*C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105next_generation(T1105*C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T2 r1105hash_code(T0*a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T0*r1105new_iterator_on_keys(T1105*C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/T6 r1105has(T1105*C,T0*a1);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105_P_308_add(T1105*C,T0*a1,T0*a2);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105_P_308_clear_count(T1105*C);
/*ORDERED_DICTIONARY[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1105_P_308_create_with_capacity(T1105*C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T1106*create1106make(void);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106common_free_nodes(void);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106make(T1106*C);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106key(T1106*C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106put(T1106*C,T0*a1,T0*a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106new_node(T1106*C,T0*a1,T0*a2,T0*a3);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106add(T1106*C,T0*a1,T0*a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106set_cache_user(T1106*C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106at(T1106*C,T0*a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T2 r1106prime_capacity(T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106buckets_item(T948 a1,T2 a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/T6 r1106should_increase_capacity(T2 a1,T2 a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/T6 r1106key_safe_equal(T0*a1,T0*a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106reference_at(T1106*C,T0*a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T2 r1106prime_number_ceiling(T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106dispose_node(T1106*C,T0*a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106item(T1106*C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106remove(T1106*C,T0*a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106clear_count(T1106*C);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106create_with_capacity(T1106*C,T2 a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106increase_capacity(T1106*C);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106next_generation(T1106*C);
/*ORDERED_DICTIONARY[STRING,STRING]*/T2 r1106hash_code(T0*a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/T0*r1106new_iterator_on_keys(T1106*C);
/*ORDERED_DICTIONARY[STRING,STRING]*/T6 r1106has(T1106*C,T0*a1);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106_P_308_put(T1106*C,T0*a1,T0*a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106_P_308_add(T1106*C,T0*a1,T0*a2);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106_P_308_clear_count(T1106*C);
/*ORDERED_DICTIONARY[STRING,STRING]*/void r1106_P_308_create_with_capacity(T1106*C,T2 a1);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T0*r1108common_free_nodes(void);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/void r1108make(T1108*C);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T0*r1108key(T1108*C,T2 a1);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T0*r1108new_node(T1108*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/void r1108add(T1108*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/void r1108set_cache_user(T1108*C,T2 a1);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T2 r1108prime_capacity(T2 a1);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T0*r1108buckets_item(T1274 a1,T2 a2);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T6 r1108should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T6 r1108key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T0*r1108reference_at(T1108*C,T0*a1);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T2 r1108prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T0*r1108item(T1108*C,T2 a1);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/void r1108create_with_capacity(T1108*C,T2 a1);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/void r1108increase_capacity(T1108*C);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/void r1108next_generation(T1108*C);
/*HASHED_DICTIONARY[CLUSTER,STRING]*/T2 r1108hash_code(T0*a1);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T0*r1111common_free_nodes(void);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r1111make(T1111*C);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r1111put(T1111*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T0*r1111new_node(T1111*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T2 r1111prime_capacity(T2 a1);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T0*r1111buckets_item(T1279 a1,T2 a2);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T6 r1111should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T6 r1111key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T2 r1111prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r1111create_with_capacity(T1111*C,T2 a1);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r1111increase_capacity(T1111*C);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/void r1111next_generation(T1111*C);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T2 r1111hash_code(T0*a1);
/*HASHED_DICTIONARY[TEXT_FILE_READ,STRING]*/T6 r1111has(T1111*C,T0*a1);
/*HASHED_DICTIONARY_NODE[CLASSES,STRING]*/void r1113make(T1113*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[FAST_ARRAY[STRING],CLASS_NAME]*/void r1116make(T1116*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[CLASS_NAME]*/void r1119make(T1119*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[INTEGER_32,CLASS_NAME]*/void r1122make(T1122*C,T2 a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T0*r1124common_free_nodes(void);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r1124make(T1124*C);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T0*r1124new_node(T1124*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r1124add(T1124*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T2 r1124prime_capacity(T2 a1);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T0*r1124buckets_item(T1280 a1,T2 a2);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T6 r1124should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T2 r1124prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r1124create_with_capacity(T1124*C,T2 a1);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r1124increase_capacity(T1124*C);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T6 r1124fast_has(T1124*C,T0*a1);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/void r1124next_generation(T1124*C);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T2 r1124hash_code(T0*a1);
/*HASHED_DICTIONARY[CLUSTER_CLASS,HASHED_STRING]*/T0*r1124fast_reference_at(T1124*C,T0*a1);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T0*r1133common_free_nodes(void);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T0*r1133new_node(T1133*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T2 r1133prime_capacity(T2 a1);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T0*r1133buckets_item(T1287 a1,T2 a2);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T6 r1133should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T2 r1133prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/void r1133create_with_capacity(T1133*C,T2 a1);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/void r1133increase_capacity(T1133*C);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/void r1133with_capacity(T1133*C,T2 a1);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/void r1133next_generation(T1133*C);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/void r1133fast_put(T1133*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T2 r1133hash_code(T0*a1);
/*HASHED_DICTIONARY[TYPE_MARK,TYPE]*/T0*r1133fast_reference_at(T1133*C,T0*a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0*r1134common_free_nodes(void);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134make(T1134*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0*r1134key(T1134*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134put(T1134*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0*r1134new_node(T1134*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134add(T1134*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134set_cache_user(T1134*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134copy(T1134*C,T0*a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T2 r1134prime_capacity(T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0*r1134buckets_item(T1290 a1,T2 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T6 r1134should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T6 r1134key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T2 r1134prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0*r1134dispose_node(T1134*C,T0*a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0*r1134item(T1134*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134clear_count(T1134*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0*r1134twin(T1134*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134create_with_capacity(T1134*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134increase_capacity(T1134*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134with_capacity(T1134*C,T2 a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134next_generation(T1134*C);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/void r1134fast_put(T1134*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T2 r1134hash_code(T0*a1);
/*HASHED_DICTIONARY[FEATURE_STAMP,TYPE]*/T0*r1134fast_reference_at(T1134*C,T0*a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0*r1153common_free_nodes(void);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r1153put(T1153*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0*r1153new_node(T1153*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r1153add(T1153*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0*r1153internal_key(T1153*C,T0*a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T2 r1153prime_capacity(T2 a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0*r1153buckets_item(T1301 a1,T2 a2);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T6 r1153should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T6 r1153key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T0*r1153reference_at(T1153*C,T0*a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T2 r1153prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r1153create_with_capacity(T1153*C,T2 a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r1153increase_capacity(T1153*C);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r1153with_capacity(T1153*C,T2 a1);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/void r1153next_generation(T1153*C);
/*HASHED_DICTIONARY[CLIENT_LIST,FEATURE_NAME]*/T2 r1153hash_code(T0*a1);
/*HASHED_SET_NODE[LIVE_TYPE]*/void r1157make(T1157*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[INTEGER_8,CLASS_TEXT]*/void r1162make(T1162*C,T1 a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[TAGGED_DATA,FIXED_STRING]*/void r1165make(T1165*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_NAME]*/void r1170make(T1170*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,FEATURE_STAMP]*/void r1173make(T1173*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T0*r1176common_free_nodes(void);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/void r1176make(T1176*C);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T0*r1176key(T1176*C,T2 a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/void r1176put(T1176*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T0*r1176new_node(T1176*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/void r1176add(T1176*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/void r1176set_cache_user(T1176*C,T2 a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T2 r1176prime_capacity(T2 a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T0*r1176buckets_item(T1305 a1,T2 a2);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T6 r1176should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T6 r1176key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T0*r1176reference_at(T1176*C,T0*a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T2 r1176prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T0*r1176item(T1176*C,T2 a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T0*r1176fast_at(T1176*C,T0*a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/void r1176create_with_capacity(T1176*C,T2 a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/void r1176increase_capacity(T1176*C);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T6 r1176fast_has(T1176*C,T0*a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/void r1176next_generation(T1176*C);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/void r1176fast_put(T1176*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T2 r1176hash_code(T0*a1);
/*HASHED_DICTIONARY[EXPRESSION,TYPE]*/T0*r1176fast_reference_at(T1176*C,T0*a1);
/*HASHED_DICTIONARY_NODE[GRAPH_NODE,TYPE]*/void r1180make(T1180*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[TYPE]*/void r1185make(T1185*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[INTEGER_8,TYPE]*/void r1188make(T1188*C,T1 a1,T0*a2,T0*a3);
/*HASHED_BIJECTIVE_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]*/void r1193make(T1193*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T0*r1196common_free_nodes(void);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r1196make(T1196*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T0*r1196new_node(T1196*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r1196add(T1196*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T2 r1196prime_capacity(T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T0*r1196buckets_item(T1307 a1,T2 a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T6 r1196should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T2 r1196prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r1196create_with_capacity(T1196*C,T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r1196increase_capacity(T1196*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r1196next_generation(T1196*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T2 r1196hash_code(T0*a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/T0*r1196fast_reference_at(T1196*C,T0*a1);
/*HASHED_DICTIONARY_NODE[RUN_FEATURE,TYPE]*/void r1199make(T1199*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[STRING]*/void r1204make(T1204*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[MANIFEST_STRING,STRING]*/void r1207make(T1207*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[MANIFEST_STRING,MANIFEST_STRING]*/void r1210make(T1210*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[MANIFEST_GENERIC]*/void r1213make(T1213*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[FAST_ARRAY[AGENT_CREATION],TYPE]*/void r1216make(T1216*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[AGENT_ARGS]*/void r1220make(T1220*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[HASHED_SET[TYPE],TYPE]*/void r1222make(T1222*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[FEATURE_STAMP,FEATURE_NAME]*/void r1229make(T1229*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE_MIXER,FEATURE_NAME]*/void r1234make(T1234*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[ABSOLUTE_FEATURE_NAME]*/void r1237make(T1237*C,T348 a1,T0*a2);
/*HASHED_DICTIONARY_NODE[FEATURE_STAMP,ABSOLUTE_FEATURE_NAME]*/void r1240make(T1240*C,T0*a1,T348 a2,T0*a3);
/*HASHED_DICTIONARY_NODE[ANONYMOUS_FEATURE,TYPE]*/void r1243make(T1243*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_SET_NODE],STRING]*/void r1248make(T1248*C,T0*a1,T0*a2,T0*a3);
/*AVL_SET_NODE[LIVE_TYPE]*/T0*r1254rotate_left(T1254*C);
/*AVL_SET_NODE[LIVE_TYPE]*/void r1254set(T1254*C,T0*a1);
/*AVL_SET_NODE[LIVE_TYPE]*/T0*r1254rotate_right(T1254*C);
/*AVL_SET_NODE[LIVE_TYPE]*/void r1254recycle(T1254*C);
/*AVL_SET_NODE[LIVE_TYPE]*/T6 r1254fast_has(T1254*C,T0*a1);
/*AVL_SET_NODE[LIVE_TYPE]*/T6 r1254ordered(T0*a1,T0*a2);
/*AVL_SET_NODE[LIVE_TYPE]*/void r1254map_in(T1254*C,T0*a1);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/void r1255make(T1255*C);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/void r1255recycle(T1255*C,T0*a1);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/void r1255push(T1255*C,T0*a1);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/T0*r1255item(T1255*C);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/T6 r1255is_empty(T1255*C);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/void r1255pop(T1255*C);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/T0*r1255top(T1255*C);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/void r1255with_capacity(T1255*C,T2 a1);
/*RECYCLING_POOL[AVL_SET_NODE[LIVE_TYPE]]*/void r1255next_generation(T1255*C);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/T0*r1256common_free_nodes(void);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/void r1256make(T1256*C);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/T0*r1256new_node(T1256*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/void r1256add(T1256*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/T2 r1256prime_capacity(T2 a1);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/T0*r1256buckets_item(T1314 a1,T2 a2);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/T6 r1256should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/T2 r1256prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/void r1256create_with_capacity(T1256*C,T2 a1);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/void r1256increase_capacity(T1256*C);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/void r1256next_generation(T1256*C);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/T2 r1256hash_code(T0*a1);
/*HASHED_DICTIONARY[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/T0*r1256fast_reference_at(T1256*C,T0*a1);
/*HASHED_SET[GRAPH_NODE]*/T0*r1259common_free_nodes(void);
/*HASHED_SET[GRAPH_NODE]*/void r1259make(T1259*C);
/*HASHED_SET[GRAPH_NODE]*/T0*r1259new_node(T1259*C,T0*a1,T0*a2);
/*HASHED_SET[GRAPH_NODE]*/void r1259set_cache_user(T1259*C,T2 a1);
/*HASHED_SET[GRAPH_NODE]*/T2 r1259prime_capacity(T2 a1);
/*HASHED_SET[GRAPH_NODE]*/T6 r1259should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[GRAPH_NODE]*/T2 r1259prime_number_ceiling(T2 a1);
/*HASHED_SET[GRAPH_NODE]*/T0*r1259dispose_node(T1259*C,T0*a1);
/*HASHED_SET[GRAPH_NODE]*/T0*r1259item(T1259*C,T2 a1);
/*HASHED_SET[GRAPH_NODE]*/void r1259clear_count(T1259*C);
/*HASHED_SET[GRAPH_NODE]*/void r1259create_with_capacity(T1259*C,T2 a1);
/*HASHED_SET[GRAPH_NODE]*/void r1259increase_capacity(T1259*C);
/*HASHED_SET[GRAPH_NODE]*/void r1259next_generation(T1259*C);
/*HASHED_SET[GRAPH_NODE]*/T2 r1259hash_code(T0*a1);
/*HASHED_SET[GRAPH_NODE]*/void r1259fast_add(T1259*C,T0*a1);
/*HASHED_DICTIONARY_NODE[SE_C_MODE,STRING]*/void r1263make(T1263*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[ORDERED_DICTIONARY[STRING,STRING],STRING]*/void r1268make(T1268*C,T0*a1,T0*a2,T0*a3);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/void r1269make(T1269*C,T0*a1);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/T6 r1269is_off(T1269*C);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/void r1269next(T1269*C);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/T2 r1269iterable_generation(T1269*C);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/T0*r1269item(T1269*C);
/*ITERATOR_ON_TRAVERSABLE[STRING]*/void r1269start(T1269*C);
/*HASHED_DICTIONARY_NODE[CLUSTER,STRING]*/void r1273make(T1273*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[TEXT_FILE_READ,STRING]*/void r1278make(T1278*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[CLUSTER_CLASS,HASHED_STRING]*/void r1281make(T1281*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[TYPE_MARK,TYPE]*/void r1286make(T1286*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[FEATURE_STAMP,TYPE]*/void r1289make(T1289*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[CLIENT_LIST,FEATURE_NAME]*/void r1300make(T1300*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[EXPRESSION,TYPE]*/void r1304make(T1304*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_HASHED_BIJECTIVE_DICTIONARY_NODE],STRING]*/void r1308make(T1308*C,T0*a1,T0*a2,T0*a3);
/*SAFE_EQUAL[LIVE_TYPE]*/T6 r1312test(T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[RECYCLING_POOL[AVL_TREE_NODE_ANY],FIXED_STRING]*/void r1315make(T1315*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[GRAPH_NODE]*/void r1318make(T1318*C,T0*a1,T0*a2);
/*RING_ARRAY[INTEGER_32]*/void r1320make(T1320*C,T2 a1,T2 a2);
/*RING_ARRAY[INTEGER_32]*/void r1320resize(T1320*C,T2 a1,T2 a2);
/*RING_ARRAY[INTEGER_32]*/void r1320clear_slice(T1320*C,T2 a1,T2 a2);
/*RING_ARRAY[INTEGER_32]*/void r1320put(T1320*C,T2 a1,T2 a2);
/*RING_ARRAY[INTEGER_32]*/void r1320move(T1320*C,T2 a1,T2 a2,T2 a3);
/*RING_ARRAY[INTEGER_32]*/T2 r1320wrap_point(T1320*C);
/*RING_ARRAY[INTEGER_32]*/void r1320squeeze_bubble(T1320*C,T2 a1,T2 a2,T2 a3,T2 a4);
/*RING_ARRAY[INTEGER_32]*/T2 r1320item(T1320*C,T2 a1);
/*RING_ARRAY[INTEGER_32]*/T2 r1320storage_upper(T1320*C);
/*RING_ARRAY[INTEGER_32]*/void r1320clear_all(T1320*C);
/*RING_ARRAY[INTEGER_32]*/T6 r1320is_empty(T1320*C);
/*RING_ARRAY[INTEGER_32]*/T2 r1320storage_index(T1320*C,T2 a1);
/*RING_ARRAY[INTEGER_32]*/void r1320set_all_with(T1320*C,T2 a1);
/*RING_ARRAY[INTEGER_32]*/void r1320next_generation(T1320*C);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T0*r1321common_free_nodes(void);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1321make(T1321*C);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1321put(T1321*C,T0*a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T0*r1321new_node(T1321*C,T0*a1,T2 a2,T0*a3);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T2 r1321prime_capacity(T2 a1);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T0*r1321buckets_item(T1326 a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T6 r1321should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T6 r1321key_safe_equal(T2 a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T2 r1321prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T0*r1321dispose_node(T1321*C,T0*a1);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1321remove(T1321*C,T2 a1);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1321create_with_capacity(T1321*C,T2 a1);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1321increase_capacity(T1321*C);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/void r1321next_generation(T1321*C);
/*HASHED_DICTIONARY[PROCESS_POSIX,INTEGER_32]*/T2 r1321hash_code(T2 a1);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T0*r1322common_free_nodes(void);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1322make(T1322*C);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1322put(T1322*C,T0*a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T0*r1322new_node(T1322*C,T0*a1,T2 a2,T0*a3);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T2 r1322prime_capacity(T2 a1);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T0*r1322buckets_item(T1329 a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T6 r1322should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T6 r1322key_safe_equal(T2 a1,T2 a2);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T2 r1322prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T0*r1322dispose_node(T1322*C,T0*a1);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1322remove(T1322*C,T2 a1);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1322create_with_capacity(T1322*C,T2 a1);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1322increase_capacity(T1322*C);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/void r1322next_generation(T1322*C);
/*HASHED_DICTIONARY[PROCESS_WIN32,INTEGER_32]*/T2 r1322hash_code(T2 a1);
/*HASHED_DICTIONARY_NODE[PROCESS_POSIX,INTEGER_32]*/void r1325make(T1325*C,T0*a1,T2 a2,T0*a3);
/*HASHED_DICTIONARY_NODE[PROCESS_WIN32,INTEGER_32]*/void r1328make(T1328*C,T0*a1,T2 a2,T0*a3);
/*COLLECTION_SORTER[INTEGER_32]*/T2 r1331insert_index(T0*a1,T2 a2);
/*COLLECTION_SORTER[INTEGER_32]*/T6 r1331lt(T2 a1,T2 a2);
/*COLLECTION_SORTER[INTEGER_32]*/T6 r1331lte(T2 a1,T2 a2);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T0*r1335common_free_nodes(void);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/void r1335make(T1335*C);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T0*r1335new_node(T1335*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/void r1335add(T1335*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T2 r1335prime_capacity(T2 a1);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T0*r1335buckets_item(T1362 a1,T2 a2);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T6 r1335should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T2 r1335prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T0*r1335fast_at(T1335*C,T0*a1);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/void r1335create_with_capacity(T1335*C,T2 a1);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/void r1335increase_capacity(T1335*C);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/void r1335next_generation(T1335*C);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/void r1335fast_put(T1335*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T2 r1335hash_code(T0*a1);
/*HASHED_DICTIONARY[TUPLE[TYPE,TYPE],TYPE]*/T0*r1335fast_reference_at(T1335*C,T0*a1);
/*TUPLE[TYPE,TYPE]*/T1336*create1336make_2(T0*a1,T0*a2);
/*TUPLE[TYPE,TYPE]*/void r1336make_2(T1336*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0*r1337common_free_nodes(void);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r1337make(T1337*C);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r1337put(T1337*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0*r1337new_node(T1337*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r1337add(T1337*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T2 r1337prime_capacity(T2 a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0*r1337buckets_item(T1366 a1,T2 a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T6 r1337should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T6 r1337key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0*r1337reference_at(T1337*C,T0*a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T2 r1337prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r1337create_with_capacity(T1337*C,T2 a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r1337increase_capacity(T1337*C);
/*HASHED_DICTIONARY[TYPE,TYPE]*/void r1337next_generation(T1337*C);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T2 r1337hash_code(T0*a1);
/*HASHED_DICTIONARY[TYPE,TYPE]*/T0*r1337fast_reference_at(T1337*C,T0*a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/T0*r1338common_free_nodes(void);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1338make(T1338*C);
/*HASHED_SET[NATIVE_PLUG_IN]*/T0*r1338new_node(T1338*C,T0*a1,T0*a2);
/*HASHED_SET[NATIVE_PLUG_IN]*/T6 r1338safe_equal(T0*a1,T0*a2);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1338add(T1338*C,T0*a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1338set_cache_user(T1338*C,T2 a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/T2 r1338prime_capacity(T2 a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1338for_each(T1338*C,T0*a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/T6 r1338should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[NATIVE_PLUG_IN]*/T2 r1338prime_number_ceiling(T2 a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/T0*r1338dispose_node(T1338*C,T0*a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/T0*r1338item(T1338*C,T2 a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1338clear_count(T1338*C);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1338create_with_capacity(T1338*C,T2 a1);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1338increase_capacity(T1338*C);
/*HASHED_SET[NATIVE_PLUG_IN]*/void r1338next_generation(T1338*C);
/*HASHED_SET[NATIVE_PLUG_IN]*/T2 r1338hash_code(T0*a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0*r1340common_free_nodes(void);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1340make(T1340*C);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0*r1340new_node(T1340*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1340add(T1340*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1340set_cache_user(T1340*C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T2 r1340prime_capacity(T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0*r1340buckets_item(T1373 a1,T2 a2);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T6 r1340should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T6 r1340key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0*r1340reference_at(T1340*C,T0*a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T2 r1340prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T0*r1340item(T1340*C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1340create_with_capacity(T1340*C,T2 a1);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1340increase_capacity(T1340*C);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/void r1340next_generation(T1340*C);
/*HASHED_DICTIONARY[DICTIONARY[PLUGIN,STRING],STRING]*/T2 r1340hash_code(T0*a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0*r1343common_free_nodes(void);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1343make(T1343*C);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0*r1343new_node(T1343*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1343add(T1343*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1343set_cache_user(T1343*C,T2 a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T2 r1343prime_capacity(T2 a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0*r1343buckets_item(T1376 a1,T2 a2);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T6 r1343should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T6 r1343key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0*r1343reference_at(T1343*C,T0*a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T2 r1343prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T0*r1343item(T1343*C,T2 a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1343create_with_capacity(T1343*C,T2 a1);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1343increase_capacity(T1343*C);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/void r1343next_generation(T1343*C);
/*HASHED_DICTIONARY[PLUGIN,STRING]*/T2 r1343hash_code(T0*a1);
/*STACK[AGENT_CREATION]*/void r1345make(T1345*C);
/*STACK[AGENT_CREATION]*/void r1345push(T1345*C,T0*a1);
/*STACK[AGENT_CREATION]*/T6 r1345is_empty(T1345*C);
/*STACK[AGENT_CREATION]*/void r1345pop(T1345*C);
/*STACK[AGENT_CREATION]*/T0*r1345top(T1345*C);
/*STACK[AGENT_CREATION]*/void r1345with_capacity(T1345*C,T2 a1);
/*STACK[AGENT_CREATION]*/void r1345next_generation(T1345*C);
/*AVL_SET[POSITION]*/T0*r1346a_new_node(void);
/*AVL_SET[POSITION]*/void r1346make(T1346*C);
/*AVL_SET[POSITION]*/T0*r1346new_node(T1346*C);
/*AVL_SET[POSITION]*/void r1346add(T1346*C,T351 a1);
/*AVL_SET[POSITION]*/T0*r1346left_grown(T1346*C,T0*a1);
/*AVL_SET[POSITION]*/void r1346set_item(T1346*C,T0*a1);
/*AVL_SET[POSITION]*/T0*r1346do_insert(T1346*C,T0*a1);
/*AVL_SET[POSITION]*/T0*r1346right_grown(T1346*C,T0*a1);
/*AVL_SET[POSITION]*/T0*r1346lost_nodes(T1346*C);
/*AVL_SET[POSITION]*/void r1346next_generation(T1346*C);
/*AVL_SET[POSITION]*/T0*r1346lost_nodes_pool(void);
/*AVL_SET[POSITION]*/T6 r1346ordered(T351 a1,T351 a2);
/*AVL_SET[POSITION]*/T6 r1346has(T1346*C,T351 a1);
/*REFERENCE[E_OLD]*/void r1348clear(T1348*C);
/*HASHED_SET[FEATURE_STAMP]*/T0*r1351common_free_nodes(void);
/*HASHED_SET[FEATURE_STAMP]*/void r1351make(T1351*C);
/*HASHED_SET[FEATURE_STAMP]*/T0*r1351new_node(T1351*C,T0*a1,T0*a2);
/*HASHED_SET[FEATURE_STAMP]*/void r1351add(T1351*C,T0*a1);
/*HASHED_SET[FEATURE_STAMP]*/T6 r1351safe_equal(T0*a1,T0*a2);
/*HASHED_SET[FEATURE_STAMP]*/T2 r1351prime_capacity(T2 a1);
/*HASHED_SET[FEATURE_STAMP]*/T6 r1351should_increase_capacity(T2 a1,T2 a2);
/*HASHED_SET[FEATURE_STAMP]*/T2 r1351prime_number_ceiling(T2 a1);
/*HASHED_SET[FEATURE_STAMP]*/T0*r1351dispose_node(T1351*C,T0*a1);
/*HASHED_SET[FEATURE_STAMP]*/void r1351clear_count(T1351*C);
/*HASHED_SET[FEATURE_STAMP]*/void r1351create_with_capacity(T1351*C,T2 a1);
/*HASHED_SET[FEATURE_STAMP]*/void r1351increase_capacity(T1351*C);
/*HASHED_SET[FEATURE_STAMP]*/void r1351next_generation(T1351*C);
/*HASHED_SET[FEATURE_STAMP]*/T2 r1351hash_code(T0*a1);
/*HASHED_SET[FEATURE_STAMP]*/T6 r1351has(T1351*C,T0*a1);
/*SAFE_EQUAL[STRING]*/T6 r1360test(T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[TUPLE[TYPE,TYPE],TYPE]*/void r1363make(T1363*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[TYPE,TYPE]*/void r1365make(T1365*C,T0*a1,T0*a2,T0*a3);
/*HASHED_SET_NODE[NATIVE_PLUG_IN]*/void r1369make(T1369*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY_NODE[DICTIONARY[PLUGIN,STRING],STRING]*/void r1372make(T1372*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY_NODE[PLUGIN,STRING]*/void r1375make(T1375*C,T0*a1,T0*a2,T0*a3);
/*AVL_SET_NODE[POSITION]*/T0*r1379rotate_left(T1379*C);
/*AVL_SET_NODE[POSITION]*/void r1379set(T1379*C,T351 a1);
/*AVL_SET_NODE[POSITION]*/T0*r1379rotate_right(T1379*C);
/*AVL_SET_NODE[POSITION]*/void r1379set_item(T1379*C,T351 a1);
/*AVL_SET_NODE[POSITION]*/T6 r1379ordered(T351 a1,T351 a2);
/*AVL_SET_NODE[POSITION]*/T6 r1379has(T1379*C,T351 a1);
/*RECYCLING_POOL[AVL_SET_NODE[POSITION]]*/void r1380make(T1380*C);
/*RECYCLING_POOL[AVL_SET_NODE[POSITION]]*/T0*r1380item(T1380*C);
/*RECYCLING_POOL[AVL_SET_NODE[POSITION]]*/T6 r1380is_empty(T1380*C);
/*RECYCLING_POOL[AVL_SET_NODE[POSITION]]*/void r1380pop(T1380*C);
/*RECYCLING_POOL[AVL_SET_NODE[POSITION]]*/T0*r1380top(T1380*C);
/*RECYCLING_POOL[AVL_SET_NODE[POSITION]]*/void r1380with_capacity(T1380*C,T2 a1);
/*RECYCLING_POOL[AVL_SET_NODE[POSITION]]*/void r1380next_generation(T1380*C);
/*HASHED_SET_NODE[FEATURE_STAMP]*/void r1384make(T1384*C,T0*a1,T0*a2);
/*SAFE_EQUAL[POSITION]*/T6 r1389test(T351 a1,T351 a2);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0*r1390a_new_node(void);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1390make(T1390*C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0*r1390fast_do_insert(T1390*C,T0*a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1390set_value(T1390*C,T0*a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0*r1390new_node(T1390*C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1390set_value_and_key(T1390*C,T0*a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0*r1390left_grown(T1390*C,T0*a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T2 r1390fast_at(T1390*C,T2 a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0*r1390right_grown(T1390*C,T0*a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1390clear_count(T1390*C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1390clear_nodes(T1390*C,T0*a1);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0*r1390lost_nodes(T1390*C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1390next_generation(T1390*C);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/void r1390fast_put(T1390*C,T2 a1,T2 a2);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T0*r1390lost_nodes_pool(void);
/*AVL_DICTIONARY[INTEGER_32,INTEGER_32]*/T6 r1390ordered(T2 a1,T2 a2);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T1392*create1392make(void);
extern T0*oBC821common_free_nodes;
extern int fBC821common_free_nodes;
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T0*r1392common_free_nodes(void);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1392make(T1392*C);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T0*r1392new_node(T1392*C,T0*a1,T0*a2);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1392go_item(T1392*C,T2 a1);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1392add_last(T1392*C,T0*a1);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T0*r1392dispose_node(T1392*C,T0*a1);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/T0*r1392item(T1392*C,T2 a1);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1392clear_count(T1392*C);
/*LINKED_LIST[TUPLE[CHARACTER,INTEGER_32]]*/void r1392next_generation(T1392*C);
/*TUPLE[CHARACTER,INTEGER_32]*/T1393*create1393make_2(T3 a1,T2 a2);
/*TUPLE[CHARACTER,INTEGER_32]*/void r1393make_2(T1393*C,T3 a1,T2 a2);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/T0*r1396rotate_left(T1396*C);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/void r1396set(T1396*C,T2 a1,T2 a2);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/T0*r1396rotate_right(T1396*C);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/void r1396recycle(T1396*C);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/T0*r1396fast_at(T1396*C,T2 a1);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/T6 r1396ordered(T2 a1,T2 a2);
/*AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]*/void r1396_P_832_recycle(T1396*C);
/*LINKED_LIST_NODE[TUPLE[CHARACTER,INTEGER_32]]*/void r1400make(T1400*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T0*r1401common_free_nodes(void);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1401make(T1401*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T0*r1401new_node(T1401*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1401add(T1401*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T2 r1401prime_capacity(T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T0*r1401buckets_item(T1406 a1,T2 a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T6 r1401should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T2 r1401prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1401create_with_capacity(T1401*C,T2 a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1401increase_capacity(T1401*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1401next_generation(T1401*C);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T2 r1401hash_code(T0*a1);
/*HASHED_DICTIONARY[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/T0*r1401fast_reference_at(T1401*C,T0*a1);
/*HASHED_DICTIONARY_NODE[WEAK_REFERENCE[ANY_LINKED_LIST_NODE],STRING]*/void r1405make(T1405*C,T0*a1,T0*a2,T0*a3);
/*COLLECTION_SORTER[LIVE_TYPE]*/void r1420quick_sort_region(T0*a1,T2 a2,T2 a3);
/*COLLECTION_SORTER[LIVE_TYPE]*/T6 r1420lt(T0*a1,T0*a2);
/*COLLECTION_SORTER[LIVE_TYPE]*/void r1420quick_sort(T0*a1);
/*COLLECTION_SORTER[LIVE_TYPE]*/T6 r1420lte(T0*a1,T0*a2);
/*COLLECTION_SORTER[LIVE_TYPE]*/void r1420sort(T0*a1);
/*COLLECTION_SORTER[LIVE_TYPE]*/T6 r1420is_sorted(T0*a1);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/void r1426make(T1426*C,T0*a1);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/T6 r1426is_off(T1426*C);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/void r1426next(T1426*C);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/T2 r1426iterable_generation(T1426*C);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/T0*r1426item(T1426*C);
/*ITERATOR_ON_DICTIONARY_KEYS[STRING,STRING]*/void r1426start(T1426*C);
/*REVERSE_COLLECTION_SORTER[INTEGER_32]*/T2 r1427insert_index(T0*a1,T2 a2);
/*REVERSE_COLLECTION_SORTER[INTEGER_32]*/T6 r1427lt(T2 a1,T2 a2);
/*REVERSE_COLLECTION_SORTER[INTEGER_32]*/T6 r1427lte(T2 a1,T2 a2);
/*COLLECTION_SORTER[C_GARBAGE_COLLECTOR_TAG]*/void r1432quick_sort_region(T0*a1,T2 a2,T2 a3);
/*COLLECTION_SORTER[C_GARBAGE_COLLECTOR_TAG]*/T6 r1432lt(T0*a1,T0*a2);
/*COLLECTION_SORTER[C_GARBAGE_COLLECTOR_TAG]*/void r1432quick_sort(T0*a1);
/*COLLECTION_SORTER[C_GARBAGE_COLLECTOR_TAG]*/T6 r1432lte(T0*a1,T0*a2);
/*COLLECTION_SORTER[C_GARBAGE_COLLECTOR_TAG]*/void r1432sort(T0*a1);
/*COLLECTION_SORTER[C_GARBAGE_COLLECTOR_TAG]*/T6 r1432is_sorted(T0*a1);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T0*r1435common_free_nodes(void);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1435make(T1435*C);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1435put(T1435*C,T0*a1,T0*a2);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T0*r1435new_node(T1435*C,T0*a1,T0*a2,T0*a3);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T2 r1435prime_capacity(T2 a1);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T0*r1435buckets_item(T1443 a1,T2 a2);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T6 r1435should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T6 r1435key_safe_equal(T0*a1,T0*a2);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T0*r1435reference_at(T1435*C,T0*a1);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T2 r1435prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1435create_with_capacity(T1435*C,T2 a1);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1435increase_capacity(T1435*C);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/void r1435next_generation(T1435*C);
/*HASHED_DICTIONARY[AGENT_ARGS,STRING]*/T2 r1435hash_code(T0*a1);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1437make(T1437*C);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1437recycle(T1437*C,T0*a1);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1437push(T1437*C,T0*a1);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/T0*r1437item(T1437*C);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/T6 r1437is_empty(T1437*C);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1437pop(T1437*C);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/T0*r1437top(T1437*C);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1437with_capacity(T1437*C,T2 a1);
/*RECYCLING_POOL[AVL_DICTIONARY_NODE[INTEGER_32,INTEGER_32]]*/void r1437next_generation(T1437*C);
/*HASHED_DICTIONARY_NODE[AGENT_ARGS,STRING]*/void r1442make(T1442*C,T0*a1,T0*a2,T0*a3);
/*STACK[EXPRESSION]*/void r1461make(T1461*C);
/*STACK[EXPRESSION]*/void r1461push(T1461*C,T0*a1);
/*STACK[EXPRESSION]*/void r1461pop(T1461*C);
/*STACK[EXPRESSION]*/T0*r1461top(T1461*C);
/*STACK[EXPRESSION]*/void r1461with_capacity(T1461*C,T2 a1);
/*STACK[EXPRESSION]*/void r1461next_generation(T1461*C);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/T0*r1462common_free_nodes(void);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/void r1462make(T1462*C);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/T0*r1462new_node(T1462*C,T0*a1,T2 a2,T0*a3);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/void r1462add(T1462*C,T0*a1,T2 a2);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/T2 r1462prime_capacity(T2 a1);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/T0*r1462buckets_item(T1465 a1,T2 a2);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/T6 r1462should_increase_capacity(T2 a1,T2 a2);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/T2 r1462prime_number_ceiling(T2 a1);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/void r1462create_with_capacity(T1462*C,T2 a1);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/void r1462increase_capacity(T1462*C);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/void r1462next_generation(T1462*C);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/T2 r1462hash_code(T2 a1);
/*HASHED_DICTIONARY[TAGGED_INTEGER,INTEGER_32]*/T0*r1462fast_reference_at(T1462*C,T2 a1);
/*SAFE_EQUAL[INTEGER_32]*/T6 r1463test(T2 a1,T2 a2);
/*HASHED_DICTIONARY_NODE[TAGGED_INTEGER,INTEGER_32]*/void r1466make(T1466*C,T0*a1,T2 a2,T0*a3);
/*COMPILE_TO_C*/T6 r29is_version_flag(T29*C,T0*a1);
extern T0*oBC32eiffel_parser;
extern int fBC32eiffel_parser;
/*COMPILE_TO_C*/T0*r29eiffel_parser(void);
/*COMPILE_TO_C*/T6 r29is_style_warning_flag(T0*a1);
/*COMPILE_TO_C*/T6 r29is_output_error_warning_on_flag(T29*C,T0*a1,T2 a2);
/*COMPILE_TO_C*/T6 r29is_version_flag_no_exit(T29*C,T0*a1);
/*COMPILE_TO_C*/T6 r29is_relax_flag(T0*a1);
/*COMPILE_TO_C*/T6 r29is_flat_check_flag(T0*a1);
extern T0*oBC32smart_eiffel;
/*COMPILE_TO_C*/T6 r29is_flymake_mode_flag(T0*a1);
extern T0*oBC32system_tools;
extern int fBC32system_tools;
/*COMPILE_TO_C*/T0*r29system_tools(void);
/*COMPILE_TO_C*/T6 r29is_cecil_flag(T29*C,T0*a1,T2 a2);
extern T0*oBC31command_arguments;
extern int fBC31command_arguments;
/*COMPILE_TO_C*/T0*r29command_arguments(void);
/*COMPILE_TO_C*/T6 r29ace_file_mode(T29*C);
/*COMPILE_TO_C*/T2 r29argument_count(void);
extern T0*oBC32cpp;
extern int fBC32cpp;
/*COMPILE_TO_C*/T0*r29cpp(void);
extern T0*oBC32cecil_pool_memory;
/*COMPILE_TO_C*/T6 r29flag_match(T0*a1,T0*a2);
/*COMPILE_TO_C*/T6 r29valid_arg_index(T2 a1);
/*COMPILE_TO_C*/T6 r29is_trace_flag(T0*a1);
/*COMPILE_TO_C*/T6 r29is_o_flag(T29*C,T0*a1,T2 a2);
/*COMPILE_TO_C*/void r29make(T29*C);
/*COMPILE_TO_C*/void r29parse_command_line(T29*C,T2 a1);
extern T0*oBC32echo;
extern int fBC32echo;
/*COMPILE_TO_C*/T0*r29echo(void);
/*COMPILE_TO_C*/T6 r29is_verbose_flag(T0*a1);
/*COMPILE_TO_C*/T0*r29search_for_echo_redirect_flag(T29*C);
extern T0*oBC32string_aliaser;
/*COMPILE_TO_C*/T6 r29is_help_flag(T29*C,T0*a1);
/*COMPILE_TO_C*/T6 r29is_no_rescue_flag(T0*a1);
/*COMPILE_TO_C*/T6 r29is_debug_flag(T0*a1);
extern T0*oBC32ace;
/*COMPILE_TO_C*/T6 r29is_high_memory_compiler(T0*a1);
/*COMPILE_TO_C*/T6 r29is_no_warning_flag(T0*a1);
/*COMPILE_TO_C*/T6 r29is_safety_check_flag(T0*a1);
/*COMPILE_TO_C*/T6 r29is_profile(T0*a1);
/*COMPILE_TO_C*/T6 r29is_case_insensitive_flag(T0*a1);
/*COMPILE_TO_C*/T6 r29is_valid_argument_for_ace_mode(T29*C,T0*a1);
/*COMPILE_TO_C*/T6 r29is_manifest_string_trace_flag(T0*a1);
/*COMPILE_TO_C*/void r29search_for_cc_flag(void);
/*COMPILE_TO_C*/T6 r29is_a_compilation_level_flag(T29*C,T0*a1);
extern T0*oBC32id_provider;
extern int fBC32id_provider;
/*COMPILE_TO_C*/T0*r29id_provider(void);
/*COMPILE_TO_C*/void r29search_for_verbose_flag(void);
extern T0*oBC32error_handler;
extern int fBC32error_handler;
/*COMPILE_TO_C*/T0*r29error_handler(void);
/*COMPILE_TO_C*/void r29check_for_level(T29*C,T0*a1);
extern int fBC32set_cecil_pool;
/*COMPILE_TO_C*/void r29set_cecil_pool(void);
/*STRING_COMMAND_LINE*/T6 r296is_profile(T0*a1);
/*STRING_COMMAND_LINE*/void r296parse(T0*a1);
extern T0*oBC296command_line_buffer;
extern int fBC296command_line_buffer;
/*STRING_COMMAND_LINE*/T0*r296command_line_buffer(void);
/*STRING_COMMAND_LINE*/T6 r296is_trace_flag(T0*a1);
/*STRING_COMMAND_LINE*/T0*r296echo(void);
/*STRING_COMMAND_LINE*/void r296next_option(void);
extern T0*oBC296option_buffer;
extern int fBC296option_buffer;
/*STRING_COMMAND_LINE*/T0*r296option_buffer(void);
/*STRING_COMMAND_LINE*/T0*r296system_tools(void);
/*STRING_COMMAND_LINE*/T6 r296flag_match(T0*a1,T0*a2);
extern T0*oBC113object_suffix;
extern int fBC113object_suffix;
/*SYSTEM_TOOLS*/T0*r113object_suffix(T113*C);
/*SYSTEM_TOOLS*/T0*r113path_c(T113*C);
extern T0*oBC113c_mode_memory;
extern int fBC113c_mode_memory;
/*SYSTEM_TOOLS*/T0*r113c_mode_memory(void);
/*SYSTEM_TOOLS*/T0*r113path_h(T113*C);
/*SYSTEM_TOOLS*/T6 r113is_linking_mandatory(void);
/*SYSTEM_TOOLS*/T6 r113is_install(void);
extern T0*oBC32install_memory;
/*SYSTEM_TOOLS*/void r113fill_path(T113*C,T0*a1,T0*a2);
extern T0*oBC113token_buffer;
extern int fBC113token_buffer;
/*SYSTEM_TOOLS*/T0*r113token_buffer(void);
/*SYSTEM_TOOLS*/T0*r113strip_path_or_default(T113*C,T0*a1);
/*SYSTEM_TOOLS*/T0*r113linker_command(T113*C,T0*a1,T0*a2);
/*SYSTEM_TOOLS*/T0*r113plugin(T113*C,T0*a1,T0*a2,T351 a3);
/*SYSTEM_TOOLS*/T0*r113absolute_path(T351 a1,T0*a2);
/*SYSTEM_TOOLS*/T0*r113strip_executable(T113*C);
/*SYSTEM_TOOLS*/void r113main_function_return_type_in(T113*C,T0*a1);
/*SYSTEM_TOOLS*/T6 r113is_c_plus_plus_file_path(T0*a1);
/*SYSTEM_TOOLS*/void r113set_alternate_c_mode(T113*C,T0*a1);
/*SYSTEM_TOOLS*/void r113environment_variable_substitution(T113*C,T0*a1,T0*a2);
extern int fBC113check_c_plus_plus;
/*SYSTEM_TOOLS*/void r113check_c_plus_plus(T113*C);
extern T0*oBC113compiler_list;
extern int fBC113compiler_list;
/*SYSTEM_TOOLS*/T0*r113compiler_list(void);
/*SYSTEM_TOOLS*/void r113append_if_not_already(T0*a1,T0*a2);
/*SYSTEM_TOOLS*/T0*r113path_make(T113*C);
/*SYSTEM_TOOLS*/void r113verify_system_name(T113*C);
/*SYSTEM_TOOLS*/void r113add_external_header_path(T0*a1);
/*SYSTEM_TOOLS*/void r113bad_use_exit(T113*C,T0*a1,T0*a2);
/*SYSTEM_TOOLS*/T2 r113nb_errors(void);
/*SYSTEM_TOOLS*/T0*r113linker_path_of(T0*a1);
/*SYSTEM_TOOLS*/void r113set_c_mode(T113*C,T0*a1);
/*SYSTEM_TOOLS*/T0*r113compiler_path_of(T0*a1);
/*SYSTEM_TOOLS*/void r113set_system_name(T113*C,T0*a1);
extern int fBC113add_lib_math;
/*SYSTEM_TOOLS*/void r113add_lib_math(T113*C);
/*SYSTEM_TOOLS*/void r113subdirectory(T113*C,T0*a1,T0*a2);
/*SYSTEM_TOOLS*/T6 r113precompile_header_supported(T113*C);
extern int fBC113set_basic_directory_notation;
/*SYSTEM_TOOLS*/void r113set_basic_directory_notation(T113*C);
/*SYSTEM_TOOLS*/void r113sys_runtime(T113*C,T0*a1,T3 a2);
extern T0*oBC113make_suffix;
extern int fBC113make_suffix;
/*SYSTEM_TOOLS*/T0*r113make_suffix(T113*C);
extern T0*oBC113precompiled_header_suffix;
extern int fBC113precompiled_header_suffix;
/*SYSTEM_TOOLS*/T0*r113precompiled_header_suffix(T113*C);
/*SYSTEM_TOOLS*/T0*r113h_precompiler_command(T113*C,T0*a1);
/*SYSTEM_TOOLS*/void r113next_path(T113*C);
/*SYSTEM_TOOLS*/void r113system_name_in(T113*C,T0*a1);
/*SYSTEM_TOOLS*/T0*r113echo(void);
extern T0*oBC113external_lib_paths;
extern int fBC113external_lib_paths;
/*SYSTEM_TOOLS*/T0*r113external_lib_paths(void);
extern T0*oBC32tmp_path;
extern int fBC32tmp_path;
/*SYSTEM_TOOLS*/T0*r113tmp_path(void);
extern int fBC113add_lib_profile;
/*SYSTEM_TOOLS*/void r113add_lib_profile(T113*C);
/*SYSTEM_TOOLS*/void r113add_lib_math_do_it_again(T113*C);
extern int fBC113include_config_loadpaths;
/*SYSTEM_TOOLS*/void r113include_config_loadpaths(T113*C);
extern T6 oBC113Scoptions_exists;
extern int fBC113Scoptions_exists;
/*SYSTEM_TOOLS*/T6 r113Scoptions_exists(void);
/*SYSTEM_TOOLS*/void r113set_external_header_path(T0*a1);
/*SYSTEM_TOOLS*/void r113add_smarteiffel_c_mode_options(T113*C);
/*SYSTEM_TOOLS*/void r113append_tokens(T0*a1,T0*a2);
/*SYSTEM_TOOLS*/void r113add_x_suffix(T113*C,T0*a1);
extern T0*oBC113id_file_path;
extern int fBC113id_file_path;
/*SYSTEM_TOOLS*/T0*r113id_file_path(T113*C);
extern T0*oBC17io;
/*SYSTEM_TOOLS*/T0*r113c_compiler_command(T113*C,T0*a1);
/*SYSTEM_TOOLS*/T2 r113extra_arg(T113*C,T0*a1,T2 a2,T0*a3);
/*SYSTEM_TOOLS*/void r113mandatory_sys_runtime(T113*C,T0*a1,T3 a2);
/*SYSTEM_TOOLS*/void r113sys_runtime_(T113*C,T0*a1,T3 a2);
/*SYSTEM_TOOLS*/void r113add_loadpath_file(T113*C,T0*a1);
/*SYSTEM_TOOLS*/void r113read_loadpath_files(T113*C);
/*SYSTEM_TOOLS*/void r113add_pthread_lib(T113*C);
/*SYSTEM_TOOLS*/void r113add_config_loadpath_file(T113*C,T0*a1,T0*a2);
/*SYSTEM_TOOLS*/void r113auto_init_plugins(T113*C);
/*SYSTEM_TOOLS*/void r113add_libraries_from_compiler_options(T113*C);
/*SYSTEM_TOOLS*/void r113add_executable_name(T113*C,T0*a1);
/*SYSTEM_TOOLS*/T0*r113environment(T113*C,T0*a1);
extern T0*oBC32tmp_file_read;
/*SYSTEM_TOOLS*/void r113set_automatic_system_name(T113*C);
/*SYSTEM_TOOLS*/void r113set_c_compiler(T113*C,T0*a1);
/*SYSTEM_TOOLS*/void r113get_started(T113*C);
/*SYSTEM_TOOLS*/void r113file_path(T113*C,T0*a1,T0*a2);
/*SYSTEM_TOOLS*/T0*r113loaded_plugin(T113*C,T0*a1,T0*a2);
extern T0*oBC113c_plus_plus_compiler_list;
extern int fBC113c_plus_plus_compiler_list;
/*SYSTEM_TOOLS*/T0*r113c_plus_plus_compiler_list(void);
extern int fBC113set_config;
/*SYSTEM_TOOLS*/void r113set_config(T113*C);
/*SYSTEM_TOOLS*/void r113set_default_c_mode(T113*C,T0*a1);
/*SYSTEM_TOOLS*/void r113append_token(T0*a1,T0*a2);
/*SYSTEM_TOOLS*/void r113show_compiler_list_then_exit(T113*C,T0*a1);
/*SYSTEM_TOOLS*/void r113make(T113*C);
/*SYSTEM_TOOLS*/void r113main_function_exit_in(T113*C,T0*a1);
/*SYSTEM_TOOLS*/T0*r113sas_c_compiler_options(T6 a1);
extern T0*oBC113x_suffix;
extern int fBC113x_suffix;
/*SYSTEM_TOOLS*/T0*r113x_suffix(T113*C);
/*SYSTEM_TOOLS*/void r113external_c_files_for_lcc_win32(T113*C,T0*a1);
/*SYSTEM_TOOLS*/T0*r113error_handler(void);
extern T0*oBC113external_libs;
extern int fBC113external_libs;
/*SYSTEM_TOOLS*/T0*r113external_libs(void);
extern T0*oBC113system_list;
extern int fBC113system_list;
/*SYSTEM_TOOLS*/T0*r113system_list(void);
/*SYSTEM_TOOLS*/void r113add_external_lib_path(T113*C,T0*a1);
/*SYSTEM_TOOLS*/void r113parent_directory(T113*C,T0*a1);
/*SYSTEM_TOOLS*/void r113add_external_lib(T113*C,T0*a1);
/*ECHO*/void r126put_line(T126*C,T0*a1);
/*ECHO*/void r126make(T126*C);
/*ECHO*/void r126tfr_connect_or_exit(T126*C,T0*a1,T0*a2);
/*ECHO*/void r126before_exit_close(T126*C);
/*ECHO*/void r126w_put_string(T126*C,T0*a1);
/*ECHO*/void r126file_renaming(T126*C,T0*a1,T0*a2);
/*ECHO*/void r126tfr_connect(T126*C,T0*a1,T0*a2);
/*ECHO*/void r126put_time(T126*C,T11 a1);
extern T0*oBC17std_output;
extern int fBC17std_output;
/*ECHO*/T0*r126std_output(void);
/*ECHO*/void r126put_padded_num(T126*C,T11 a1,T2 a2);
/*ECHO*/void r126print_count(T126*C,T0*a1,T2 a2);
/*ECHO*/T0*r126getenv(T126*C,T0*a1,T0*a2);
/*ECHO*/void r126tfw_connect(T126*C,T0*a1,T0*a2);
/*ECHO*/void r126w_put_character(T126*C,T3 a1);
/*ECHO*/void r126put_new_line(T126*C);
/*ECHO*/void r126put_string(T126*C,T0*a1);
/*ECHO*/T0*r126system_tools(void);
/*ECHO*/void r126put_real_format(T126*C,T5 a1,T2 a2);
/*ECHO*/void r126w_put_line(T126*C,T0*a1);
/*ECHO*/void r126put_integer(T126*C,T2 a1);
extern T0*oBC17std_error;
/*ECHO*/void r126file_removing(T126*C,T0*a1);
/*ECHO*/void r126w_put_integer(T126*C,T2 a1);
/*ECHO*/void r126redirect_output_on(T126*C,T0*a1);
/*ECHO*/void r126put_character(T126*C,T3 a1);
/*C_PLUGIN_FACTORY*/T903*create903(void);
/*C_PLUGIN_FACTORY*/T0*r903new(T351 a1,T0*a2,T0*a3);
/*EIFFEL_PARSER*/T6 r104a_parent_edge(T104*C,T6 a1);
extern T0*oBC104and_name;
extern int fBC104and_name;
/*EIFFEL_PARSER*/T0*r104and_name(void);
extern T0*oBC105buffer;
extern int fBC105buffer;
/*EIFFEL_PARSER*/T0*r104buffer(void);
/*EIFFEL_PARSER*/T6 r104a_instruction(T104*C);
/*EIFFEL_PARSER*/T0*r104parse_type_mark(T104*C);
/*EIFFEL_PARSER*/T0*r104a_then_exp(T104*C);
/*EIFFEL_PARSER*/T6 r104a_function_call(T104*C);
/*EIFFEL_PARSER*/void r104a_new_export_list(T104*C);
/*EIFFEL_PARSER*/T6 r104a_conditional(T104*C);
/*EIFFEL_PARSER*/T0*r104connect_to_cecil(T104*C,T0*a1);
/*EIFFEL_PARSER*/T6 r104skip1(T104*C,T3 a1);
/*EIFFEL_PARSER*/T6 r104skip2(T104*C,T3 a1,T3 a2);
/*EIFFEL_PARSER*/T6 r104skip3(T104*C,T3 a1,T3 a2,T3 a3);
extern T0*oBC104not_name;
extern int fBC104not_name;
/*EIFFEL_PARSER*/T0*r104not_name(void);
/*EIFFEL_PARSER*/T6 r104a_index_clause(T104*C,T0*a1,T0*a2);
/*EIFFEL_PARSER*/T6 r104a_keyword_true(T104*C);
extern T0*oBC104minus_name;
extern int fBC104minus_name;
/*EIFFEL_PARSER*/T0*r104minus_name(void);
/*EIFFEL_PARSER*/T6 r104a_argument_(T104*C,T0*a1,T2 a2);
/*EIFFEL_PARSER*/T0*r104a_external(T104*C);
/*EIFFEL_PARSER*/void r104next_char(T104*C);
/*EIFFEL_PARSER*/void r104check_local_var_rank_and_closure(T104*C,T0*a1);
/*EIFFEL_PARSER*/T0*r104a_external_specification(T104*C);
/*EIFFEL_PARSER*/T0*r104parse_feature_name(T104*C);
/*EIFFEL_PARSER*/T6 r104a_inspect(T104*C);
/*EIFFEL_PARSER*/void r104a_conversion_clause(T104*C);
/*EIFFEL_PARSER*/T6 r104a_prefix(T104*C);
extern T0*oBC104implies_name;
extern int fBC104implies_name;
/*EIFFEL_PARSER*/T0*r104implies_name(void);
/*EIFFEL_PARSER*/void r104a_indexing(T104*C,T0*a1,T0*a2);
/*EIFFEL_PARSER*/T6 r104a_free_operator_usage(T104*C,T1 a1);
/*EIFFEL_PARSER*/T6 r104a_free_operator_definition(T104*C,T1 a1,T351 a2);
/*EIFFEL_PARSER*/T0*r104get_comment(T104*C);
/*EIFFEL_PARSER*/T6 r104a_keyword_false(T104*C);
/*EIFFEL_PARSER*/T0*r104predefined_type_mark(T0*a1,T351 a2);
/*EIFFEL_PARSER*/T0*r104error_handler(void);
/*EIFFEL_PARSER*/void r104integer_overflow_error(T104*C,T2 a1,T2 a2,T0*a3);
/*EIFFEL_PARSER*/T6 r104check_name_rank(T0*a1,T0*a2,T0*a3);
/*EIFFEL_PARSER*/T6 r104a_keyword_void(T104*C);
/*EIFFEL_PARSER*/T0*r104parse_c_name(T104*C);
extern T0*oBC104inline_agents;
extern int fBC104inline_agents;
/*EIFFEL_PARSER*/T0*r104inline_agents(void);
extern T6 oBC104no_static_simplify;
extern int fBC104no_static_simplify;
/*EIFFEL_PARSER*/T6 r104no_static_simplify(void);
/*EIFFEL_PARSER*/T6 r104a_rename_pair(T104*C);
/*EIFFEL_PARSER*/void r104void_current_comparison_check_(T0*a1,T0*a2);
/*EIFFEL_PARSER*/T6 r104a_procedure_call(T104*C);
/*EIFFEL_PARSER*/T6 r104a_class_name(T104*C);
/*EIFFEL_PARSER*/T6 r104a_keyword_precursor(T104*C);
/*EIFFEL_PARSER*/T6 r104a_writable(T104*C);
/*EIFFEL_PARSER*/void r104void_current_comparison_check(T0*a1,T0*a2);
extern T0*oBC104a_assertion_buffer;
extern int fBC104a_assertion_buffer;
/*EIFFEL_PARSER*/T0*r104a_assertion_buffer(void);
extern T0*oBC104gt_name;
extern int fBC104gt_name;
/*EIFFEL_PARSER*/T0*r104gt_name(void);
/*EIFFEL_PARSER*/void r104inside_function_precursor_check(T104*C,T0*a1);
extern T0*oBC32or_else_name;
extern int fBC32or_else_name;
/*EIFFEL_PARSER*/T0*r104or_else_name(void);
/*EIFFEL_PARSER*/void r104no_void_after_elseif_check(T0*a1);
/*EIFFEL_PARSER*/T6 r104a_binary(T104*C,T351 a1);
extern T0*oBC104parentheses_name;
extern int fBC104parentheses_name;
/*EIFFEL_PARSER*/T0*r104parentheses_name(void);
extern T0*oBC105lcs;
extern int fBC105lcs;
/*EIFFEL_PARSER*/T0*r104lcs(void);
/*EIFFEL_PARSER*/T2 r104a_when_part(T104*C,T2 a1,T0*a2);
extern T0*oBC104unused_tmp_features;
extern int fBC104unused_tmp_features;
/*EIFFEL_PARSER*/T0*r104unused_tmp_features(void);
/*EIFFEL_PARSER*/void r104show_nb_errors(void);
/*EIFFEL_PARSER*/void r104a_feature_clause(T104*C);
/*EIFFEL_PARSER*/void r104unknown_external_language(T0*a1);
/*EIFFEL_PARSER*/T0*r104to_call(T0*a1,T0*a2,T0*a3);
/*EIFFEL_PARSER*/T6 r104a_infix(T104*C);
/*EIFFEL_PARSER*/T6 r104a_keyword_result(T104*C);
extern T0*oBC104ge_name;
extern int fBC104ge_name;
/*EIFFEL_PARSER*/T0*r104ge_name(void);
/*EIFFEL_PARSER*/T6 r104an_allowed_expression_in_when_of_inspect(T104*C);
/*EIFFEL_PARSER*/T351 r104current_position(T104*C);
/*EIFFEL_PARSER*/T6 r104a_feature_name_list(T104*C);
/*EIFFEL_PARSER*/void r104a_base_class_name_def(T104*C);
/*EIFFEL_PARSER*/T6 r104a_r10(T104*C,T6 a1,T0*a2,T0*a3,T0*a4);
extern T0*oBC104muls_name;
extern int fBC104muls_name;
/*EIFFEL_PARSER*/T0*r104muls_name(void);
/*EIFFEL_PARSER*/T0*r104a_type_mark_list(T104*C);
extern T0*oBC104sharp_muls_name;
extern int fBC104sharp_muls_name;
/*EIFFEL_PARSER*/T0*r104sharp_muls_name(void);
/*EIFFEL_PARSER*/void r104create_infix_prefix(T104*C,T1 a1,T2 a2,T2 a3);
/*EIFFEL_PARSER*/T6 r104a_local_name_ref_(T104*C,T0*a1,T2 a2);
/*EIFFEL_PARSER*/T6 r104a_alias_parentheses(T104*C,T6 a1,T0*a2);
/*EIFFEL_PARSER*/void r104show_nb_warnings(void);
/*EIFFEL_PARSER*/T6 r104a_check(T104*C);
/*EIFFEL_PARSER*/T6 r104a_feature_name(T104*C);
/*EIFFEL_PARSER*/T6 r104a_character_constant(T104*C,T1 a1);
/*EIFFEL_PARSER*/void r104a_conversion_list(T104*C);
/*EIFFEL_PARSER*/T6 r104a_local_name_def(T104*C);
/*EIFFEL_PARSER*/T6 r104a_manifest_string(T104*C,T6 a1);
/*EIFFEL_PARSER*/T6 r104a_loop(T104*C);
/*EIFFEL_PARSER*/T6 r104a_index_value(T104*C);
/*EIFFEL_PARSER*/T0*r104a_precursor_type_mark(T104*C,T351 a1);
/*EIFFEL_PARSER*/T0*r104a_actuals(T104*C);
/*EIFFEL_PARSER*/T0*r104a_external_name(T104*C);
extern T0*oBC104pow_name;
extern int fBC104pow_name;
/*EIFFEL_PARSER*/T0*r104pow_name(void);
/*EIFFEL_PARSER*/T6 r104a_manifest_or_type_test(T104*C,T1 a1);
/*EIFFEL_PARSER*/void r104echo_information(T104*C);
/*EIFFEL_PARSER*/T0*r104echo(void);
/*EIFFEL_PARSER*/void r104go_back_at(T104*C,T2 a1,T2 a2);
/*EIFFEL_PARSER*/T6 r104a_address_of(T104*C);
/*EIFFEL_PARSER*/T6 r104a_feature_declaration(T104*C);
/*EIFFEL_PARSER*/T6 r104a_formal_generic_type_mark(T104*C);
/*EIFFEL_PARSER*/T6 r104a_keyword_current(T104*C);
/*EIFFEL_PARSER*/T0*r104a_routine_body(T104*C,T6 a1);
/*EIFFEL_PARSER*/T0*r104a_exp2(T104*C,T0*a1,T0*a2);
/*EIFFEL_PARSER*/T2 r104nb_warnings(void);
/*EIFFEL_PARSER*/T6 r104a_static_type_mark(T104*C,T6 a1);
extern T0*oBC104inline_agent_no_name;
extern int fBC104inline_agent_no_name;
/*EIFFEL_PARSER*/T0*r104inline_agent_no_name(void);
/*EIFFEL_PARSER*/T351 r104pos(T104*C,T2 a1,T2 a2);
/*EIFFEL_PARSER*/T6 r104a_assignment_call_assigner(T104*C,T6 a1);
/*EIFFEL_PARSER*/T0*r104a_routine(T104*C,T6 a1);
/*EIFFEL_PARSER*/void r104a_class_declaration(T104*C);
/*EIFFEL_PARSER*/T6 r104a_expression(T104*C);
extern T0*oBC104slash_slash_name;
extern int fBC104slash_slash_name;
/*EIFFEL_PARSER*/T0*r104slash_slash_name(void);
/*EIFFEL_PARSER*/T6 r104a_alias(T104*C,T0*a1);
/*EIFFEL_PARSER*/T0*r104mandatory_writable(T104*C);
extern T0*oBC32parser_buffer;
extern int fBC32parser_buffer;
/*EIFFEL_PARSER*/T0*r104parser_buffer(void);
/*EIFFEL_PARSER*/T6 r104a_e1(T104*C);
/*EIFFEL_PARSER*/T6 r104a_e2(T104*C);
/*EIFFEL_PARSER*/T6 r104a_e3(T104*C);
/*EIFFEL_PARSER*/T6 r104a_e4(T104*C);
/*EIFFEL_PARSER*/T6 r104a_e5(T104*C);
/*EIFFEL_PARSER*/T6 r104a_e6(T104*C);
/*EIFFEL_PARSER*/T6 r104a_e7(T104*C);
/*EIFFEL_PARSER*/void r104a_rename_list(T104*C);
/*EIFFEL_PARSER*/T6 r104a_e8(T104*C);
/*EIFFEL_PARSER*/T0*r104a_clients(T104*C);
/*EIFFEL_PARSER*/T6 r104a_e9(T104*C);
extern T0*oBC104faof;
extern int fBC104faof;
/*EIFFEL_PARSER*/T0*r104faof(void);
/*EIFFEL_PARSER*/T6 r104a_assignment_or_procedure_call(T104*C);
extern T0*oBC32mini_buffer;
/*EIFFEL_PARSER*/T6 r104a_c_inline_c(T104*C);
/*EIFFEL_PARSER*/void r104no_void_check(T0*a1,T0*a2);
/*EIFFEL_PARSER*/T6 r104a_c_inline_h(T104*C);
extern T0*oBC105unicode_string_buffer;
extern int fBC105unicode_string_buffer;
/*EIFFEL_PARSER*/T0*r104unicode_string_buffer(void);
/*EIFFEL_PARSER*/T6 r104a_keyword(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_parent_list(T104*C);
/*EIFFEL_PARSER*/T0*r104to_proc_call(T104*C,T0*a1,T0*a2,T0*a3);
/*EIFFEL_PARSER*/T0*r104analyse_class(T104*C,T0*a1,T0*a2);
/*EIFFEL_PARSER*/T0*r104a_actuals_until(T104*C,T3 a1,T6 a2);
/*EIFFEL_PARSER*/T0*r104a_then_compound(T104*C);
/*EIFFEL_PARSER*/T2 r104nb_errors(void);
/*EIFFEL_PARSER*/T6 r104a_conditional_exp(T104*C);
/*EIFFEL_PARSER*/void r104a_r1(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_r2(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_r3(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_r4(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_r5(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_r6(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_r7(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_r8(T104*C,T0*a1);
/*EIFFEL_PARSER*/T6 r104a_is(T104*C);
/*EIFFEL_PARSER*/T6 r104a_retry(T104*C);
/*EIFFEL_PARSER*/void r104make(T104*C);
/*EIFFEL_PARSER*/void r104anchored_creation_check(T0*a1);
/*EIFFEL_PARSER*/T6 r104a_create_expression(T104*C);
extern T0*oBC104or_name;
extern int fBC104or_name;
/*EIFFEL_PARSER*/T0*r104or_name(void);
/*EIFFEL_PARSER*/T6 r104a_conversion_query(T104*C);
/*EIFFEL_PARSER*/void r104check_name_rank_and_closure(T104*C,T0*a1);
/*EIFFEL_PARSER*/T6 r104a_debug(T104*C);
/*EIFFEL_PARSER*/void r104check_alias(T104*C);
/*EIFFEL_PARSER*/void r104err_exp(T351 a1,T6 a2,T0*a3);
/*EIFFEL_PARSER*/T0*r104a_inline_agent(T104*C);
/*EIFFEL_PARSER*/void r104show_nb(T2 a1,T0*a2);
/*EIFFEL_PARSER*/T6 r104a_type_mark_inside_client_list(T104*C);
/*EIFFEL_PARSER*/T6 r104a_formal_arg_list(T104*C);
/*EIFFEL_PARSER*/T6 r104a_boolean_constant(T104*C);
/*EIFFEL_PARSER*/T0*r104a_creation_clause(T104*C,T351 a1,T6 a2);
/*EIFFEL_PARSER*/T0*r104id_provider(void);
extern T0*oBC104plus_name;
extern int fBC104plus_name;
/*EIFFEL_PARSER*/T0*r104plus_name(void);
/*EIFFEL_PARSER*/T6 r104a_conversion_procedure(T104*C);
/*EIFFEL_PARSER*/T6 r104a_ordinary_feature_name_or_local_name(T104*C);
extern T0*oBC104backslash_backslash_name;
extern int fBC104backslash_backslash_name;
/*EIFFEL_PARSER*/T0*r104backslash_backslash_name(void);
extern T0*oBC104sharp_plus_name;
extern int fBC104sharp_plus_name;
/*EIFFEL_PARSER*/T0*r104sharp_plus_name(void);
/*EIFFEL_PARSER*/T0*r104analyse_buffer(T104*C);
/*EIFFEL_PARSER*/T0*r104a_assertion(T104*C);
extern T0*oBC32omitted_client_list;
/*EIFFEL_PARSER*/T0*r104expression_with_comment(T104*C,T0*a1);
/*EIFFEL_PARSER*/void r104a_local_var_list(T104*C);
/*EIFFEL_PARSER*/T6 r104a_non_allowed_very_strange_identifier(T104*C);
/*EIFFEL_PARSER*/T6 r104a_old_creation(T104*C);
/*EIFFEL_PARSER*/T6 r104a_tag_mark(T104*C);
/*EIFFEL_PARSER*/T6 r104a_creation_keyword(T104*C);
/*EIFFEL_PARSER*/T6 r104a_create_instruction(T104*C);
extern T0*oBC104xor_name;
extern int fBC104xor_name;
/*EIFFEL_PARSER*/T0*r104xor_name(void);
/*EIFFEL_PARSER*/T6 r104a_possibly_frozen_feature_name(T104*C);
extern T0*oBC104lt_name;
extern int fBC104lt_name;
/*EIFFEL_PARSER*/T0*r104lt_name(void);
extern T0*oBC104slash_name;
extern int fBC104slash_name;
/*EIFFEL_PARSER*/T0*r104slash_name(void);
/*EIFFEL_PARSER*/T6 r104a_alias_brackets(T104*C,T6 a1,T0*a2);
/*EIFFEL_PARSER*/T6 r104a_base_class_name(T104*C);
extern T0*oBC104sharp_minus_name;
extern int fBC104sharp_minus_name;
/*EIFFEL_PARSER*/T0*r104sharp_minus_name(void);
extern T0*oBC32and_then_name;
extern int fBC32and_then_name;
/*EIFFEL_PARSER*/T0*r104and_then_name(void);
/*EIFFEL_PARSER*/T0*r104a_compound1(T104*C);
/*EIFFEL_PARSER*/T0*r104a_compound2(T104*C,T0*a1,T0*a2);
/*EIFFEL_PARSER*/void r104a_formal_generic_list(T104*C);
/*EIFFEL_PARSER*/void r104disconnect(T104*C);
extern T0*oBC104le_name;
extern int fBC104le_name;
/*EIFFEL_PARSER*/T0*r104le_name(void);
/*EIFFEL_PARSER*/void r104a_convert_clause(T104*C,T351 a1);
/*EIFFEL_PARSER*/T6 r104a_type_mark(T104*C,T6 a1);
/*EIFFEL_PARSER*/T6 r104a_e10(T104*C);
/*EIFFEL_PARSER*/void r104show_total_time(T104*C);
/*EIFFEL_PARSER*/T6 r104manifest_just_after_a_dot(T104*C,T3 a1,T6 a2,T0*a3);
/*EIFFEL_PARSER*/void r104update_last_manifest_string(T104*C,T351 a1,T6 a2,T6 a3,T0*a4,T0*a5);
/*EIFFEL_PARSER*/T6 r104a_local_name_ref(T104*C);
/*EIFFEL_PARSER*/void r104unused_once_warning_check(T104*C);
/*EIFFEL_PARSER*/T6 r104skip1unless2(T104*C,T3 a1,T3 a2);
/*EIFFEL_PARSER*/void r104valid_parent_edge_type_check(T0*a1);
extern T0*oBC104brackets_name;
extern int fBC104brackets_name;
/*EIFFEL_PARSER*/T0*r104brackets_name(void);
/*EIFFEL_PARSER*/void r104skip_comments(T104*C);
/*EIFFEL_PARSER*/T6 r104just_after_a_dot(T104*C,T6 a1,T0*a2);
/*EIFFEL_PARSER*/T6 r104a_unary(T104*C,T351 a1);
/*EIFFEL_PARSER*/T6 r104a_argument(T104*C);
/*EIFFEL_PARSER*/T0*r104static_simplify(T0*a1);
/*ACE*/T351 r283current_position(T283*C);
/*ACE*/T0*r283cecil_pool(void);
/*ACE*/T2 r283root_count(void);
extern T0*oBC283clusters_;
extern int fBC283clusters_;
/*ACE*/T0*r283clusters_(void);
/*ACE*/T6 r283has_root(T283*C);
/*ACE*/void r283go_back_at(T283*C,T2 a1,T2 a2);
/*ACE*/T6 r283no_check(T283*C);
/*ACE*/T2 r283class_text_count(void);
/*ACE*/T6 r283a_yes_no_all_inside(T283*C);
extern T0*oBC283root_class_names;
extern int fBC283root_class_names;
/*ACE*/T0*r283root_class_names(void);
/*ACE*/T6 r283all_check(T283*C);
/*ACE*/T0*r283buffer(void);
/*ACE*/T0*r283a_string(T283*C);
extern T0*oBC283root_procedure_names;
extern int fBC283root_procedure_names;
/*ACE*/T0*r283root_procedure_names(void);
/*ACE*/T6 r283a_manifest_string(T283*C,T6 a1);
/*ACE*/void r283fatal_error_in(T283*C,T0*a1);
/*ACE*/void r283parse_include(T283*C);
/*ACE*/void r283set_highest_encountered_level(T283*C,T2 a1);
/*ACE*/T0*r283a_identifier(T283*C);
/*ACE*/T0*r283class_text(T0*a1,T6 a2,T0*a3);
/*ACE*/T0*r283a_debug_key(T283*C);
/*ACE*/T0*r283a_split_key(T283*C);
/*ACE*/T6 r283a_cluster_clause_list(T283*C);
/*ACE*/void r283add_loadpath(T0*a1,T0*a2,T2 a3,T6 a4);
/*ACE*/T6 r283a_keyword(T283*C,T0*a1);
/*ACE*/T0*r283a_cecil_file(T283*C);
/*ACE*/void r283skip_comments(T283*C);
/*ACE*/void r283set_root_class_name_using(T283*C,T0*a1);
extern T0*oBC283pov_classes;
extern int fBC283pov_classes;
/*ACE*/T0*r283pov_classes(void);
/*ACE*/T6 r283a_option_in_cluster_properties(T283*C);
/*ACE*/T6 r283default_debug(T283*C,T0*a1);
extern T0*oBC283no_pov_classes;
extern int fBC283no_pov_classes;
/*ACE*/T0*r283no_pov_classes(void);
/*ACE*/void r283may_expand_var(T283*C);
/*ACE*/T0*r283parser_buffer(void);
/*ACE*/void r283new_universe_entry(T2 a1,T0*a2,T0*a3);
/*ACE*/void r283a_generate(T283*C);
/*ACE*/T0*r283root_class_name(T283*C);
/*ACE*/T6 r283require_check(T283*C);
/*ACE*/void r283a_collect_value(T283*C);
/*ACE*/void r283set_root_procedure_name(T283*C,T0*a1);
/*ACE*/void r283set_default_trace(T283*C);
/*ACE*/T0*r283splitter(T283*C);
/*ACE*/void r283set_debug_check(T283*C);
/*ACE*/void r283set_root_class_name(T283*C,T0*a1);
/*ACE*/T0*r283echo(void);
/*ACE*/T6 r283skip1(T283*C,T3 a1);
/*ACE*/void r283view_in(T283*C,T0*a1);
/*ACE*/T0*r283class_name_using(T0*a1);
/*ACE*/T0*r283system_tools(void);
/*ACE*/void r283next_char(T283*C);
extern T0*oBC32is_launcher_memory;
/*ACE*/T0*r283cluster_of(T0*a1,T0*a2);
/*ACE*/T0*r283lcs(void);
/*ACE*/T6 r283trace_of(T283*C,T0*a1);
/*ACE*/T2 r283a_assertion_level(T283*C);
/*ACE*/T6 r283is_debug_checked(T283*C,T0*a1,T0*a2);
/*ACE*/T6 r283a_yes_no_all(T283*C);
/*ACE*/T0*r283find_class_text(T0*a1,T6 a2,T0*a3);
/*ACE*/T2 r283cluster_count(void);
/*ACE*/void r283add_default_debug_key(T283*C,T0*a1);
/*ACE*/T6 r283is_launcher(void);
/*ACE*/T0*r283level_name(T2 a1);
/*ACE*/void r283analyse_ace_file(T283*C,T0*a1);
/*ACE*/void r283set_no_split(T283*C,T6 a1);
/*ACE*/void r283set_split(T283*C,T0*a1);
/*ACE*/void r283a_external(T283*C);
/*ACE*/T0*r283best_cluster_of(T0*a1,T0*a2,T0*a3);
/*ACE*/T6 r283ensure_check(T283*C);
/*ACE*/T0*r283unicode_string_buffer(void);
/*ACE*/void r283a_cluster_mark(T283*C);
extern T0*oBC283universe;
extern int fBC283universe;
/*ACE*/T0*r283universe(void);
extern T0*oBC283distances_;
extern int fBC283distances_;
/*ACE*/T0*r283distances_(void);
/*ACE*/void r283set_default_level(T283*C);
/*ACE*/void r283set_command_line_debug(T283*C);
/*ACE*/void r283set_executable_name(T283*C,T0*a1);
/*ACE*/T0*r283eiffel_parser(void);
/*ACE*/void r283get_started(T283*C);
/*ACE*/T6 r283a_system_level_defaults(T283*C);
/*ACE*/T0*r283executable_name(T283*C);
/*ACE*/void r283set_default_c_mode(T283*C);
/*ACE*/void r283a_cluster_properties(T283*C);
/*ACE*/T6 r283a_class_name(T283*C);
extern T0*oBC283new_clusters;
extern int fBC283new_clusters;
/*ACE*/T0*r283new_clusters(void);
/*ACE*/void r283command_line_parsed(T283*C,T0*a1);
/*ACE*/T0*r283root_procedure_name(T283*C);
/*ACE*/T351 r283pos(T2 a1,T2 a2);
/*ACE*/T6 r283match_debug_keys(T0*a1,T0*a2);
/*ACE*/T2 r283assertion_level_of(T283*C,T0*a1);
/*ACE*/void r283next_root(T283*C);
/*ACE*/T0*r283error_handler(void);
/*ACE*/T6 r283sedb(T283*C);
/*ACE*/T6 r283a_cluster_clause(T283*C);
extern T0*oBC283executable_names;
extern int fBC283executable_names;
/*ACE*/T0*r283executable_names(void);
typedef struct _se_agenT117f117l4348c33 se_agenT117f117l4348c33;
struct _se_agenT117f117l4348c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l4348c33*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a1;
};
/*agent creation*/T0*agenT117f117l4348c33(T0*closed_C,T0*closed_a1);
typedef struct _se_agenT117f117l4337c30 se_agenT117f117l4337c30;
struct _se_agenT117f117l4337c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l4337c30*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT117f117l4337c30(T0*closed_C);
typedef struct _se_agenT117f117l4074c47 se_agenT117f117l4074c47;
struct _se_agenT117f117l4074c47{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l4074c47*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT117f117l4074c47(T0*closed_C);
typedef struct _se_agenT117f117l605c22 se_agenT117f117l605c22;
struct _se_agenT117f117l605c22{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l605c22*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT117f117l605c22(void);
typedef struct _se_agenT117f117l662c22 se_agenT117f117l662c22;
struct _se_agenT117f117l662c22{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l662c22*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT117f117l662c22(void);
typedef struct _se_agenT117f117l4093c55 se_agenT117f117l4093c55;
struct _se_agenT117f117l4093c55{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l4093c55*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a2;
};
/*agent creation*/T0*agenT117f117l4093c55(T0*closed_C,T0*closed_a2);
typedef struct _se_agenT117f117l4033c48 se_agenT117f117l4033c48;
struct _se_agenT117f117l4033c48{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l4033c48*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT117f117l4033c48(void);
typedef struct _se_agenT117f117l4054c48 se_agenT117f117l4054c48;
struct _se_agenT117f117l4054c48{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l4054c48*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT117f117l4054c48(void);
typedef struct _se_agenT117f117l3847c41 se_agenT117f117l3847c41;
struct _se_agenT117f117l3847c41{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l3847c41*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT117f117l3847c41(T0*closed_C);
typedef struct _se_agenT117f117l3764c40 se_agenT117f117l3764c40;
struct _se_agenT117f117l3764c40{Tid id;
int creation_mold_id;
void(*afp)(se_agenT117f117l3764c40*,T0*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT117f117l3764c40(T0*closed_C);
/*C_PRETTY_PRINTER*/T0*r117cecil_pool(void);
extern T0*oBC117c_code;
extern int fBC117c_code;
/*C_PRETTY_PRINTER*/T0*r117c_code(void);
extern T0*oBC117defined_agent_creation;
extern int fBC117defined_agent_creation;
/*C_PRETTY_PRINTER*/T0*r117defined_agent_creation(void);
/*C_PRETTY_PRINTER*/T0*r117stack_top(T117*C);
/*C_PRETTY_PRINTER*/void r117c_init_closure_locals(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117put_target_as_target(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117c_plus_plus_register(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117print_argument(T2 a1);
/*C_PRETTY_PRINTER*/T6 r117manifest_string_trace(T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/T2 r117class_invariant_call_opening(T117*C,T0*a1,T6 a2);
/*C_PRETTY_PRINTER*/void r117target_position_in_error_handler(T117*C);
/*C_PRETTY_PRINTER*/void r117put_arguments(T117*C,T2 a1);
/*C_PRETTY_PRINTER*/void r117c_test_o_flag(T0*a1);
/*C_PRETTY_PRINTER*/void r117crash(T117*C);
/*C_PRETTY_PRINTER*/void r117print_local(T0*a1);
/*C_PRETTY_PRINTER*/void r117initialize_size_table(T117*C);
/*C_PRETTY_PRINTER*/void r117split_c_file_now(T117*C,T2 a1);
/*C_PRETTY_PRINTER*/void r117put_monomorphic_or_void_call(T117*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*C_PRETTY_PRINTER*/void r117customize_thread_pool_runtime(T117*C);
/*C_PRETTY_PRINTER*/void r117inspect_local_compile_to_c(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117c_define_assignment_test_functions(T117*C);
/*C_PRETTY_PRINTER*/T0*r117reserve_context(T117*C,T2 a1);
/*C_PRETTY_PRINTER*/T0*r117run_features(void);
/*C_PRETTY_PRINTER*/T6 r117target_cannot_be_dropped(T117*C);
/*C_PRETTY_PRINTER*/void r117get_started(T117*C);
/*C_PRETTY_PRINTER*/void r117c_test_o_flag_recursion(T0*a1);
/*C_PRETTY_PRINTER*/void r117define_agent_launcher_heading(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117se_evobt(T117*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*C_PRETTY_PRINTER*/T0*r117cpp(void);
/*C_PRETTY_PRINTER*/void r117compile_routines(T117*C);
/*C_PRETTY_PRINTER*/void r117set_dump_stack_top_for(T0*a1,T0*a2,T0*a3);
/*C_PRETTY_PRINTER*/void r117put_c_inline_h(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/T0*r117tmp_path(void);
/*C_PRETTY_PRINTER*/T6 r117agent_pool_has_only_one_case_for(T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117put_file(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117cecil_define_users_for_file(T117*C,T0*a1);
extern T0*oBC117fs_status_name;
extern int fBC117fs_status_name;
/*C_PRETTY_PRINTER*/T0*r117fs_status_name(void);
/*C_PRETTY_PRINTER*/void r117initialize_generating_type(void);
/*C_PRETTY_PRINTER*/T0*r117agent_switches(void);
/*C_PRETTY_PRINTER*/void r117stop_recursive_assertion_opening(T6 a1);
/*C_PRETTY_PRINTER*/void r117add_first_include(T0*a1);
/*C_PRETTY_PRINTER*/void r117cecil_define_users_for_entry(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117put_target_generating_type(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117class_invariant_call_closing(T2 a1,T6 a2);
extern T0*oBC118context_stack;
extern int fBC118context_stack;
/*C_PRETTY_PRINTER*/T0*r117context_stack(void);
/*C_PRETTY_PRINTER*/void r117current_class_invariant(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117push_create_expression(T117*C,T0*a1,T0*a2,T0*a3);
/*C_PRETTY_PRINTER*/void r117add_include(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117recompilation_comment(T0*a1);
/*C_PRETTY_PRINTER*/void r117macro_def(T117*C,T0*a1,T2 a2);
/*C_PRETTY_PRINTER*/void r117sys_runtime_h_and_c(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/T0*r117error_handler(void);
/*C_PRETTY_PRINTER*/void r117se_ms_c_call_in(T0*a1,T0*a2);
extern T0*oBC117pending_c_function_body;
extern int fBC117pending_c_function_body;
/*C_PRETTY_PRINTER*/T0*r117pending_c_function_body(void);
/*C_PRETTY_PRINTER*/void r117start_profile(T0*a1);
/*C_PRETTY_PRINTER*/void r117c_register(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117prepare_c_function(T117*C);
/*C_PRETTY_PRINTER*/void r117c_frame_descriptor_in(T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117va_type_in(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/T0*r117class_invariants(void);
/*C_PRETTY_PRINTER*/void r117initialize_path_table(T117*C);
/*C_PRETTY_PRINTER*/void r117define_initialize_eiffel_runtime(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117c_test_o_flag_introspect(T0*a1);
/*C_PRETTY_PRINTER*/void r117initialize_generator(void);
/*C_PRETTY_PRINTER*/void r117inspect_local_type(T0*a1);
/*C_PRETTY_PRINTER*/void r117begin_c_file(T117*C);
/*C_PRETTY_PRINTER*/void r117stop_recursive_assertion_closing(T6 a1);
/*C_PRETTY_PRINTER*/void r117push_inside_some_wrapper(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117right_hand_side_can_only_be_void(void);
/*C_PRETTY_PRINTER*/void r117check_assertion(T117*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*C_PRETTY_PRINTER*/T0*r117live_type_map(void);
/*C_PRETTY_PRINTER*/void r117put_target_as_value(T117*C);
/*C_PRETTY_PRINTER*/void r117c_define1_manifest_string_pool(T117*C);
/*C_PRETTY_PRINTER*/void r117put_error0(T0*a1);
/*C_PRETTY_PRINTER*/void r117end_c_file(void);
/*C_PRETTY_PRINTER*/void r117begin_c_linkage(T0*a1);
/*C_PRETTY_PRINTER*/T6 r117arguments_cannot_be_dropped(T117*C);
extern T0*oBC117internal_c_local_stamps_stack;
extern int fBC117internal_c_local_stamps_stack;
/*C_PRETTY_PRINTER*/T0*r117internal_c_local_stamps_stack(void);
/*C_PRETTY_PRINTER*/void r117connect_cecil_out_h(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117customize_runtime(T117*C);
/*C_PRETTY_PRINTER*/void r117really_define_c_main(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117push_direct(T117*C,T0*a1,T0*a2,T0*a3,T0*a4);
extern T0*oBC117pending_c_function_signature;
extern int fBC117pending_c_function_signature;
/*C_PRETTY_PRINTER*/T0*r117pending_c_function_signature(void);
/*C_PRETTY_PRINTER*/void r117cecil_define(T117*C);
/*C_PRETTY_PRINTER*/T6 r117once_flag(T117*C,T0*a1);
extern T0*oBC117internal_c_local_list;
/*C_PRETTY_PRINTER*/void r117string_to_c_code(T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117show_profile(void);
/*C_PRETTY_PRINTER*/void r117common_put_target(T117*C);
/*C_PRETTY_PRINTER*/void r117free_context(T117*C,T0*a1);
extern T0*oBC117out_make;
extern int fBC117out_make;
/*C_PRETTY_PRINTER*/T0*r117out_make(void);
extern T0*oBC117inspect_local_stack;
extern int fBC117inspect_local_stack;
/*C_PRETTY_PRINTER*/T0*r117inspect_local_stack(void);
/*C_PRETTY_PRINTER*/void r117put_position(T351 a1);
/*C_PRETTY_PRINTER*/void r117write_out_h_buffer(T117*C);
/*C_PRETTY_PRINTER*/void r117incr_real_procedure_count(T117*C);
/*C_PRETTY_PRINTER*/void r117echo_information(T117*C);
/*C_PRETTY_PRINTER*/void r117c_code_for_precomputable_routines(T117*C);
/*C_PRETTY_PRINTER*/void r117variant_check(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/T0*r117echo(void);
/*C_PRETTY_PRINTER*/void r117write_out_c_buffer(void);
/*C_PRETTY_PRINTER*/void r117c_define_manifest_generic_functions(T117*C);
extern T0*oBC32manifest_string_pool;
/*C_PRETTY_PRINTER*/T6 r117use_c_function_call_for_attribute_read(T117*C);
/*C_PRETTY_PRINTER*/void r117prepare_memory(T117*C);
/*C_PRETTY_PRINTER*/void r117put_ith_argument(T117*C,T2 a1);
/*C_PRETTY_PRINTER*/void r117add_include_on(T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117push_create_instruction(T117*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*C_PRETTY_PRINTER*/void r117pop(T117*C);
/*C_PRETTY_PRINTER*/void r117se_string(T0*a1);
/*C_PRETTY_PRINTER*/void r117put_trace_switch(T117*C);
/*C_PRETTY_PRINTER*/void r117c_code_for_precomputable_routine(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117external_prototype_in(T117*C,T0*a1,T0*a2,T0*a3);
/*C_PRETTY_PRINTER*/T0*r117pending_c_function_lock_local(T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117args_compile_to_c_ith(T117*C,T0*a1,T0*a2,T0*a3,T2 a4);
/*C_PRETTY_PRINTER*/void r117define_main(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117incr_procedure_count(T117*C);
extern T0*oBC32agent_pool;
/*C_PRETTY_PRINTER*/T6 r117cannot_drop_all(T117*C);
/*C_PRETTY_PRINTER*/void r117push_precursor(T117*C,T0*a1,T0*a2,T0*a3);
/*C_PRETTY_PRINTER*/void r117agent_pool_switch_in(T117*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*C_PRETTY_PRINTER*/void r117c_define_o_flag(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117incr_real_function_count(T117*C);
/*C_PRETTY_PRINTER*/void r117put_object_size(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117start_profile_class_invariant(T0*a1);
extern T0*oBC117out_c_buffer;
extern int fBC117out_c_buffer;
/*C_PRETTY_PRINTER*/T0*r117out_c_buffer(void);
/*C_PRETTY_PRINTER*/void r117put_direct(T117*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*C_PRETTY_PRINTER*/void r117c_define_for_native_array(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117c_pre_compute_once_function(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117c_frame_descriptor_closure_in(T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117incr_function_count(T117*C);
/*C_PRETTY_PRINTER*/void r117put_banner(T0*a1);
/*C_PRETTY_PRINTER*/void r117put_c_file(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117c_define_o_result_for(T117*C,T0*a1);
extern T0*oBC117out_h_buffer;
extern int fBC117out_h_buffer;
/*C_PRETTY_PRINTER*/T0*r117out_h_buffer(void);
/*C_PRETTY_PRINTER*/T2 r117nb_errors(void);
/*C_PRETTY_PRINTER*/void r117stack_overflow(T117*C);
/*C_PRETTY_PRINTER*/void r117end_assignment(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117h_connect(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117compile(T117*C);
/*C_PRETTY_PRINTER*/void r117customize_agent_pool_runtime_1(T117*C);
/*C_PRETTY_PRINTER*/void r117customize_agent_pool_runtime_2(T117*C);
/*C_PRETTY_PRINTER*/void r117c_declare_local(T117*C,T0*a1,T0*a2,T6 a3);
/*C_PRETTY_PRINTER*/void r117character_to_c_code(T3 a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117initialize_path_table_of(T0*a1);
/*C_PRETTY_PRINTER*/void r117native_array_to_c_code(T2 a1,T9 a2,T0*a3);
/*C_PRETTY_PRINTER*/void r117c_call_initialize_manifest_strings(void);
/*C_PRETTY_PRINTER*/void r117se_ums_c_call_in(T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117start_profile_agent_switch(T0*a1);
/*C_PRETTY_PRINTER*/void r117make(T117*C);
/*C_PRETTY_PRINTER*/void r117array_access(T3 a1,T2 a2);
/*C_PRETTY_PRINTER*/void r117write_extern_2(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117write_extern_1(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117write_extern_0(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117stack_push(T117*C,T2 a1);
/*C_PRETTY_PRINTER*/T0*r117out_c(void);
/*C_PRETTY_PRINTER*/void r117write_make_file(T117*C);
/*C_PRETTY_PRINTER*/void r117start_profile_agent_creation(T0*a1);
/*C_PRETTY_PRINTER*/void r117define_extern_tables(T117*C);
/*C_PRETTY_PRINTER*/void r117c_define_for_user_generic(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117c_init_closure_local(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117start_assignment(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/T0*r117agent_creations(void);
/*C_PRETTY_PRINTER*/T0*r117id_provider(void);
/*C_PRETTY_PRINTER*/T0*r117system_tools(void);
/*C_PRETTY_PRINTER*/void r117prepare_introspection(T117*C);
/*C_PRETTY_PRINTER*/T0*r117need_invariant(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117agent_pool_call_in(T117*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*C_PRETTY_PRINTER*/void r117initialize_profile(void);
/*C_PRETTY_PRINTER*/void r117put_position_comment(T351 a1);
/*C_PRETTY_PRINTER*/void r117inside_twin(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117c_declare_locals(T117*C,T0*a1,T0*a2,T6 a3);
/*C_PRETTY_PRINTER*/void r117set_live_type(T0*a1);
extern T0*oBC32once_routine_pool;
/*C_PRETTY_PRINTER*/void r117push_cecil_create(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117include_register(T117*C,T351 a1,T0*a2);
/*C_PRETTY_PRINTER*/T6 r117c_plus_plus_registered(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117define_agent_launcher_args(T117*C,T0*a1);
extern T0*oBC32assignment_test_pool;
/*C_PRETTY_PRINTER*/void r117initialize_generator_of(T0*a1);
/*C_PRETTY_PRINTER*/void r117put_target_generator(T117*C,T0*a1);
extern T0*oBC117c_inline_h_mem;
extern int fBC117c_inline_h_mem;
/*C_PRETTY_PRINTER*/T0*r117c_inline_h_mem(void);
/*C_PRETTY_PRINTER*/void r117c_variables_for_precomputable_routines(T117*C);
/*C_PRETTY_PRINTER*/void r117c_define_manifest_generic_for(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117dump_pending_c_function(T117*C,T6 a1);
extern T0*oBC117tmp_string;
extern int fBC117tmp_string;
/*C_PRETTY_PRINTER*/T0*r117tmp_string(void);
/*C_PRETTY_PRINTER*/void r117c_plus_plus_definitions(T117*C);
/*C_PRETTY_PRINTER*/void r117c_define_assignment_test_for(T117*C,T0*a1,T0*a2);
/*C_PRETTY_PRINTER*/void r117put_position_comment_on(T0*a1,T351 a2);
/*C_PRETTY_PRINTER*/void r117c_define2_manifest_string_pool(T117*C);
extern T0*oBC32pretty_printer;
/*C_PRETTY_PRINTER*/void r117write_extern_array_1(T117*C,T0*a1,T2 a2,T0*a3);
/*C_PRETTY_PRINTER*/void r117write_extern_array_2(T117*C,T0*a1,T2 a2);
extern T0*oBC32manifest_generic_pool;
extern T0*oBC32exceptions_handler;
/*C_PRETTY_PRINTER*/void r117put_h_file(T117*C,T0*a1);
/*C_PRETTY_PRINTER*/void r117put_position_in_ds(T351 a1);
/*C_PRETTY_PRINTER*/void r117end_c_linkage(T0*a1);
/*C_PRETTY_PRINTER*/T0*r117new_context(T2 a1);
/*C_PRETTY_PRINTER*/void r117put_position_comment_in(T0*a1,T351 a2);
/*C_PRETTY_PRINTER*/void r117put_sedb_breakpoint(T117*C);
/*C_PRETTY_PRINTER*/void r117c_define_o_result(T117*C,T0*a1);
extern T0*oBC32thread_pool;
/*C_PRETTY_PRINTER*/void r117do_write_make_file(T117*C);
typedef struct _se_agenT111f111l488c40 se_agenT111f111l488c40;
struct _se_agenT111f111l488c40{Tid id;
int creation_mold_id;
void(*afp)(se_agenT111f111l488c40*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT111f111l488c40(void);
/*SMART_EIFFEL*/void r111polymorphic_procedure_call_count_increment(T111*C,T2 a1);
/*SMART_EIFFEL*/T0*r111old_list_stack_pop(void);
/*SMART_EIFFEL*/void r111id_extra_information(T0*a1,T0*a2,T0*a3);
extern T0*oBC111old_list_stack;
extern int fBC111old_list_stack;
/*SMART_EIFFEL*/T0*r111old_list_stack(void);
/*SMART_EIFFEL*/T0*r111type_real_32(T111*C);
/*SMART_EIFFEL*/T0*r111feature_stamp(T0*a1,T0*a2);
/*SMART_EIFFEL*/T0*r111cecil_pool(void);
/*SMART_EIFFEL*/void r111register_class_invariant(T111*C,T0*a1);
/*SMART_EIFFEL*/void r111inline_dynamic_dispatch(T111*C,T0*a1,T0*a2);
/*SMART_EIFFEL*/T0*r111loaded_class_text(T0*a1);
/*SMART_EIFFEL*/T6 r111is_at_run_time(T0*a1);
/*SMART_EIFFEL*/T0*r111long_type_name(T0*a1,T0*a2);
/*SMART_EIFFEL*/T0*r111cluster_named(T0*a1);
/*SMART_EIFFEL*/T0*r111type_string(T111*C);
/*SMART_EIFFEL*/T0*r111type_natural_16(T111*C);
/*SMART_EIFFEL*/T0*r111context_feature(void);
/*SMART_EIFFEL*/T0*r111type_natural_32(T111*C);
/*SMART_EIFFEL*/void r111sort_live_type_map(T111*C);
/*SMART_EIFFEL*/void r111very_last_information(void);
/*SMART_EIFFEL*/T2 r111class_text_count(void);
/*SMART_EIFFEL*/T0*r111type_natural_64(T111*C);
/*SMART_EIFFEL*/void r111run_back_end(T111*C,T0*a1);
/*SMART_EIFFEL*/T0*r111get_type(T0*a1,T6 a2);
/*SMART_EIFFEL*/T0*r111type_internals_handler_if_exists(void);
/*SMART_EIFFEL*/void r111update_polymorphic_distribution(T111*C,T2 a1);
/*SMART_EIFFEL*/void r111expanded_target_procedure_call_count_increment(T111*C);
/*SMART_EIFFEL*/void r111expanded_target_function_call_count_increment(T111*C);
extern T0*oBC111copyright;
extern int fBC111copyright;
/*SMART_EIFFEL*/T0*r111copyright(T111*C);
/*SMART_EIFFEL*/void r111register_run_feature(T111*C,T0*a1);
/*SMART_EIFFEL*/T0*r111create_type(T0*a1,T6 a2);
/*SMART_EIFFEL*/void r111do_adapt(T111*C,T0*a1,T0*a2);
/*SMART_EIFFEL*/T0*r111type_natural_8(T111*C);
/*SMART_EIFFEL*/T0*r111get_inline_memo(void);
/*SMART_EIFFEL*/void r111parse_include(T0*a1);
/*SMART_EIFFEL*/void r111void_target_procedure_call_count_increment(T111*C);
/*SMART_EIFFEL*/void r111echo_magic_count(T111*C,T0*a1);
/*SMART_EIFFEL*/T0*r111get_type_for_non_generic(T0*a1,T6 a2);
extern T0*oBC111type_dictionary;
extern int fBC111type_dictionary;
/*SMART_EIFFEL*/T0*r111type_dictionary(void);
/*SMART_EIFFEL*/void r111register_old(T0*a1);
/*SMART_EIFFEL*/void r111do_collect(T111*C,T0*a1,T0*a2);
/*SMART_EIFFEL*/void r111simplify(T111*C);
/*SMART_EIFFEL*/void r111collect_se_atexit(T111*C,T0*a1);
/*SMART_EIFFEL*/void r111do_front_end(T0*a1,T0*a2);
/*SMART_EIFFEL*/T0*r111type_integer_16(T111*C);
/*SMART_EIFFEL*/T0*r111type_native_array_character(T111*C);
/*SMART_EIFFEL*/T0*r111class_text(T0*a1);
/*SMART_EIFFEL*/T0*r111type_integer_32(T111*C);
extern T0*oBC32se_atexit_name;
extern int fBC32se_atexit_name;
/*SMART_EIFFEL*/T0*r111se_atexit_name(void);
extern T0*oBC111agent_creation_error_trap;
extern int fBC111agent_creation_error_trap;
/*SMART_EIFFEL*/T0*r111agent_creation_error_trap(void);
/*SMART_EIFFEL*/T2 r111nb_errors(void);
extern T0*oBC111manifest_creation_name;
extern int fBC111manifest_creation_name;
/*SMART_EIFFEL*/T0*r111manifest_creation_name(T111*C);
/*SMART_EIFFEL*/T0*r111type_integer_64(T111*C);
/*SMART_EIFFEL*/T0*r111parser_buffer(void);
/*SMART_EIFFEL*/void r111polymorphic_function_call_count_increment(T111*C,T2 a1);
/*SMART_EIFFEL*/void r111register_agent_switch(T111*C,T0*a1);
/*SMART_EIFFEL*/T0*r111type_pointer(T111*C);
/*SMART_EIFFEL*/void r111collect_precomputable(T111*C,T0*a1,T0*a2);
/*SMART_EIFFEL*/T0*r111analyze_class(T0*a1,T0*a2);
/*SMART_EIFFEL*/void r111print_version(T111*C);
/*SMART_EIFFEL*/void r111collect_external_function(T111*C,T0*a1,T0*a2,T0*a3);
/*SMART_EIFFEL*/void r111collect_local_expanded(T111*C,T0*a1);
/*SMART_EIFFEL*/void r111monomorphic_function_call_count_increment(T111*C);
/*SMART_EIFFEL*/void r111register_type(T0*a1);
/*SMART_EIFFEL*/T0*r111echo(void);
/*SMART_EIFFEL*/void r111tuple_class_not_found_fatal_error(T0*a1);
/*SMART_EIFFEL*/void r111do_one_collect_cycle(T111*C);
/*SMART_EIFFEL*/void r111customize_runtime(void);
/*SMART_EIFFEL*/void r111set_specializing_feature_variables(T111*C,T0*a1,T0*a2);
/*SMART_EIFFEL*/void r111simplify_and_optimize(T111*C,T0*a1,T0*a2);
/*SMART_EIFFEL*/void r111run_adapt(T111*C);
extern T0*oBC111collected_external_functions;
extern int fBC111collected_external_functions;
/*SMART_EIFFEL*/T0*r111collected_external_functions(void);
/*SMART_EIFFEL*/T0*r111cluster_of(T0*a1);
extern T0*oBC111free_inline_memo;
extern int fBC111free_inline_memo;
/*SMART_EIFFEL*/T0*r111free_inline_memo(void);
/*SMART_EIFFEL*/void r111vffd7_fatal_error(T351 a1);
/*SMART_EIFFEL*/T0*r111command_arguments(void);
/*SMART_EIFFEL*/void r111covariance_check(T351 a1,T0*a2,T0*a3);
/*SMART_EIFFEL*/T0*r111collect(T111*C,T0*a1,T0*a2,T6 a3);
/*SMART_EIFFEL*/void r111show_live_types(T111*C);
/*SMART_EIFFEL*/T0*r111type_unicode_string(T111*C);
/*SMART_EIFFEL*/T6 r111is_ready(void);
/*SMART_EIFFEL*/T6 r111is_tagged(T111*C,T0*a1);
extern T0*oBC32introspection_handler;
/*SMART_EIFFEL*/void r111register_agent_creation(T111*C,T0*a1);
/*SMART_EIFFEL*/void r111collect_deep_features(T111*C);
extern T0*oBC32feature_accumulator;
extern int fBC32feature_accumulator;
/*SMART_EIFFEL*/T0*r111feature_accumulator(void);
/*SMART_EIFFEL*/T0*r111type_any(T111*C);
extern T0*oBC111status;
extern int fBC111status;
/*SMART_EIFFEL*/T0*r111status(void);
/*SMART_EIFFEL*/T0*r111type_integer_8(T111*C);
/*SMART_EIFFEL*/void r111collect_generic(T111*C,T0*a1);
/*SMART_EIFFEL*/void r111register_plug_in(T0*a1);
/*SMART_EIFFEL*/void r111run_collect(T111*C);
/*SMART_EIFFEL*/void r111run_front_end(T111*C);
/*SMART_EIFFEL*/void r111monomorphic_procedure_call_count_increment(T111*C);
/*SMART_EIFFEL*/void r111do_back_end(T111*C,T0*a1,T0*a2,T0*a3);
/*SMART_EIFFEL*/void r111unknown_feature_fatal_error(T0*a1,T0*a2,T0*a3);
extern T0*oBC111memory_dispose_stamp;
extern int fBC111memory_dispose_stamp;
/*SMART_EIFFEL*/T0*r111memory_dispose_stamp(void);
/*SMART_EIFFEL*/T0*r111type_boolean(T111*C);
/*SMART_EIFFEL*/T0*r111root_class_text(T0*a1);
/*SMART_EIFFEL*/void r111compile(T111*C,T0*a1);
extern T0*oBC111collected_plug_in;
extern int fBC111collected_plug_in;
/*SMART_EIFFEL*/T0*r111collected_plug_in(void);
extern T0*oBC111cwd_cluster;
extern int fBC111cwd_cluster;
/*SMART_EIFFEL*/T0*r111cwd_cluster(void);
/*SMART_EIFFEL*/void r111clear_agent_creation_error_trap(T0*a1);
extern T0*oBC111context_feature_stack;
extern int fBC111context_feature_stack;
/*SMART_EIFFEL*/T0*r111context_feature_stack(void);
/*SMART_EIFFEL*/T0*r111eiffel_parser(void);
/*SMART_EIFFEL*/void r111set_specializing_feature_arguments(T111*C,T0*a1,T0*a2);
/*SMART_EIFFEL*/void r111collect_from_root(T111*C,T0*a1,T0*a2);
/*SMART_EIFFEL*/void r111collect_external(T111*C,T0*a1);
extern T0*oBC111code_accumulator;
extern int fBC111code_accumulator;
/*SMART_EIFFEL*/T0*r111code_accumulator(void);
/*SMART_EIFFEL*/T0*r111command_name(void);
/*SMART_EIFFEL*/T0*r111type_real_extended(T111*C);
/*SMART_EIFFEL*/void r111void_target_function_call_count_increment(T111*C);
/*SMART_EIFFEL*/void r111echo_polymorphic_inspect_distribution(T111*C,T0*a1);
/*SMART_EIFFEL*/void r111safety_check(T111*C);
extern T0*oBC112short_copyright;
extern int fBC112short_copyright;
/*SMART_EIFFEL*/T0*r111short_copyright(void);
extern int fBC111initialize_any_tuple;
/*SMART_EIFFEL*/void r111initialize_any_tuple(T111*C);
/*SMART_EIFFEL*/T6 r111try_agent_creation_error_trap(T0*a1);
/*SMART_EIFFEL*/T0*r111type_character(T111*C);
/*SMART_EIFFEL*/void r111magic_count_increment(T111*C);
/*SMART_EIFFEL*/void r111pop_context(T0*a1);
/*SMART_EIFFEL*/T0*r111collect_one_type(T111*C,T0*a1,T6 a2);
extern T0*oBC32assignment_handler;
/*SMART_EIFFEL*/T0*r111std_output(void);
/*SMART_EIFFEL*/T0*r111error_handler(void);
/*SMART_EIFFEL*/void r111inspect_when_merge_counter_increment(T111*C);
/*SMART_EIFFEL*/void r111collect_create(T111*C,T0*a1);
/*SMART_EIFFEL*/T0*r111simplify_integer_infix_power(T351 a1,T0*a2,T0*a3);
/*SMART_EIFFEL*/void r111collect_constant(T111*C,T0*a1);
/*SMART_EIFFEL*/T0*r111type_real_64(T111*C);
extern T0*oBC112copyright;
extern int fBC112copyright;
/*SMART_EIFFEL*/T0*r111_P_112_copyright(void);
/*ID_PROVIDER*/void r291too_many_live_types_error(void);
/*ID_PROVIDER*/void r291make(T291*C);
/*ID_PROVIDER*/T0*r291alias_of(T10 a1);
extern T0*oBC291id_memory;
extern int fBC291id_memory;
/*ID_PROVIDER*/T0*r291id_memory(void);
/*ID_PROVIDER*/T0*r291echo(void);
extern T0*oBC291per_cluster_id_memory;
extern int fBC291per_cluster_id_memory;
/*ID_PROVIDER*/T0*r291per_cluster_id_memory(void);
/*ID_PROVIDER*/T0*r291cluster_id_memory(T0*a1);
/*ID_PROVIDER*/T10 r291high_item(T291*C,T0*a1);
/*ID_PROVIDER*/void r291cluster_id_memory_add(T10 a1,T0*a2,T0*a3);
/*ID_PROVIDER*/T0*r291class_name_of(T0*a1);
/*ID_PROVIDER*/T10 r291item(T291*C,T0*a1,T0*a2);
extern T0*oBC291temporary_type_name;
extern int fBC291temporary_type_name;
/*ID_PROVIDER*/T0*r291temporary_type_name(void);
/*ID_PROVIDER*/void r291disk_save(T291*C);
/*ID_PROVIDER*/T0*r291system_tools(void);
/*ID_PROVIDER*/void r291disk_save_ids(T291*C,T0*a1,T0*a2,T0*a3);
/*ID_PROVIDER*/void r291disk_restore(T291*C);
/*ID_PROVIDER*/T0*r291error_handler(void);
/*ID_PROVIDER*/void r291id_memory_add(T10 a1,T0*a2,T6 a3);
/*ID_PROVIDER*/T6 r291is_valid_type_mark(T0*a1);
/*STRING_ALIASER*/T6 r281registered_one(T0*a1);
/*STRING_ALIASER*/T0*r281hashed_string(T0*a1);
/*STRING_ALIASER*/T0*r281create_hashed_string(T0*a1);
extern T0*oBC281memory;
extern int fBC281memory;
/*STRING_ALIASER*/T0*r281memory(void);
/*STRING_ALIASER*/T0*r281string(T0*a1);
/*STRING_ALIASER*/void r281echo_information(void);
/*STRING_ALIASER*/T0*r281echo(void);
extern T0*oBC281tuple_name;
extern int fBC281tuple_name;
/*STRING_ALIASER*/T0*r281tuple_name(void);
extern T0*oBC281hashed_string_buffer;
extern int fBC281hashed_string_buffer;
/*STRING_ALIASER*/T0*r281hashed_string_buffer(void);
extern T0*oBC297info;
/*MEMORY_HANDLER_FACTORY*/T0*r297create_memory_handler(void);
/*MEMORY_HANDLER_FACTORY*/void r297set_bdw_gc(void);
extern T0*oBC297mode;
/*MEMORY_HANDLER_FACTORY*/void r297set_no_gc(void);
/*MEMORY_HANDLER_FACTORY*/T6 r297is_no_gc(void);
/*ERROR_HANDLER*/void r293put_arrows_into(T0*a1,T0*a2);
/*ERROR_HANDLER*/void r293print_as_error(T293*C);
/*ERROR_HANDLER*/void r293get_positions_on_same_line(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293emit_all_warnings(T293*C);
/*ERROR_HANDLER*/void r293cancel(T293*C);
/*ERROR_HANDLER*/void r293print_spaces(T2 a1);
/*ERROR_HANDLER*/void r293save_error(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293default_create(T293*C);
/*ERROR_HANDLER*/T0*r293echo(void);
/*ERROR_HANDLER*/void r293do_print_standard(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293print_live_warnings(T293*C);
/*ERROR_HANDLER*/void r293add_position(T293*C,T351 a1);
/*ERROR_HANDLER*/T2 r293detab_line(T0*a1);
/*ERROR_HANDLER*/void r293print_as_style_warning(T293*C);
/*ERROR_HANDLER*/void r293add_expression(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293add_raw_code(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293emit_error(T293*C,T0*a1,T0*a2);
/*ERROR_HANDLER*/void r293print_as_fatal_error(T293*C);
/*ERROR_HANDLER*/void r293do_print(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293do_print_flymake(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293print_as_warning(T293*C);
/*ERROR_HANDLER*/void r293add_type(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293add_type_mark(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293add_context_info(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293append_integer_64(T293*C,T11 a1);
/*ERROR_HANDLER*/T6 r293is_empty(T293*C);
/*ERROR_HANDLER*/void r293emit_warnings(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293add_feature_name(T293*C,T0*a1);
/*ERROR_HANDLER*/void r293crash(T293*C);
/*ERROR_HANDLER*/void r293append_integer(T293*C,T2 a1);
/*ERROR_HANDLER*/T0*r293new_error(T293*C);
/*ERROR_HANDLER*/void r293print_as_internal_error(T293*C);
/*ERROR_HANDLER*/void r293print_error_header(T0*a1,T0*a2,T2 a3,T0*a4);
/*ERROR_HANDLER*/void r293display_lines(T293*C);
/*ERROR_HANDLER*/T0*r293get_line(T0*a1,T2 a2);
/*CECIL_POOL*/T86*create86(void);
/*CECIL_POOL*/T0*r86echo(void);
/*CECIL_POOL*/void r86parse_cecil_files(T86*C);
/*CECIL_POOL*/void r86for_each(T86*C,T0*a1);
/*CECIL_POOL*/void r86collect(T86*C);
/*CECIL_POOL*/void r86add_cecil_file(T86*C,T0*a1);
/*CECIL_POOL*/void r86adapt(T86*C);
/*CECIL_POOL*/void r86inline_dynamic_dispatch(T86*C,T0*a1,T0*a2);
/*FILE_TOOLS*/T295 create295(void);
extern T0*oBC295tfr1;
extern T0*oBC295tfr2;
/*FILE_TOOLS*/T6 r295same_files(T0*a1,T0*a2);
/*FILE_TOOLS*/T6 r295is_readable(T0*a1);
/*FILE_TOOLS*/T6 r295file_exists(T0*a1);
/*FILE_TOOLS*/void r295delete(T295*C,T0*a1);
/*FILE_TOOLS*/T6 r295is_empty(T0*a1);
/*FILE_TOOLS*/T6 r295is_file(T0*a1);
/*FILE_TOOLS*/T6 r295is_directory(T0*a1);
/*FILE_TOOLS*/void r295rename_to(T295*C,T0*a1,T0*a2);
/*FILE_TOOLS*/T6 r295same_physical_file(T0*a1,T0*a2);
/*SERC_FACTORY*/void r554add_to_chain(T0*a1,T0*a2,T0*a3);
extern T0*oBC554config;
extern int fBC554config;
/*SERC_FACTORY*/T0*r554config(T0*a1);
extern T0*oBC554seconf_env;
extern int fBC554seconf_env;
/*SERC_FACTORY*/T0*r554seconf_env(void);
/*SERC_FACTORY*/T0*r554echo(void);
extern T0*oBC554userprofile_env;
extern int fBC554userprofile_env;
/*SERC_FACTORY*/T0*r554userprofile_env(void);
extern T0*oBC554home_env;
extern int fBC554home_env;
/*SERC_FACTORY*/T0*r554home_env(void);
/*SERC_FACTORY*/T0*r554parser_buffer(void);
/*SERC_FACTORY*/T0*r554env(T0*a1);
extern T0*oBC554allusersprofile_env;
extern int fBC554allusersprofile_env;
/*SERC_FACTORY*/T0*r554allusersprofile_env(void);
/*BASIC_DIRECTORY*/void r546compute_file_path_with(T0*a1,T0*a2);
/*BASIC_DIRECTORY*/T6 r546macintosh_notation(void);
/*BASIC_DIRECTORY*/void r546compute_parent_directory_of(T0*a1);
/*BASIC_DIRECTORY*/T6 r546openvms_notation(void);
/*BASIC_DIRECTORY*/T6 r546unix_notation(void);
/*BASIC_DIRECTORY*/void r546compute_absolute_file_path_with(T0*a1);
/*BASIC_DIRECTORY*/void r546connect_to_current_working_directory(T546*C);
/*BASIC_DIRECTORY*/T6 r546windows_notation(void);
/*BASIC_DIRECTORY*/T6 r546amiga_notation(void);
/*BASIC_DIRECTORY*/void r546set_notation_using(T0*a1);
/*BASIC_DIRECTORY*/void r546compute_short_name_of(T0*a1);
/*BASIC_DIRECTORY*/T6 r546cygwin_notation(void);
extern T0*oBC546last_entry;
extern int fBC546last_entry;
/*BASIC_DIRECTORY*/T0*r546last_entry(void);
/*BASIC_DIRECTORY*/T0*r546current_working_directory(void);
/*BASIC_DIRECTORY*/T0*r546system_notation(void);
/*BASIC_DIRECTORY*/void r546compute_subdirectory_with(T0*a1,T0*a2);
extern int fBC546ensure_system_notation;
/*BASIC_DIRECTORY*/void r546ensure_system_notation(void);
/*BASIC_DIRECTORY*/void r546connect_to(T546*C,T0*a1);
/*BASIC_DIRECTORY*/void r546read_entry(T546*C);
extern T6 oBC546require_system_notation;
extern int fBC546require_system_notation;
/*BASIC_DIRECTORY*/T6 r546require_system_notation(void);
/*BASIC_DIRECTORY*/void r546disconnect(T546*C);
extern T0*oBC546system_notation_buffer;
/*STD_INPUT_OUTPUT*/void r78put_line(T78*C,T0*a1);
extern T0*oBC17std_input;
extern int fBC17std_input;
/*STD_INPUT_OUTPUT*/T0*r78std_input(void);
/*STD_INPUT_OUTPUT*/T0*r78std_output(void);
/*STD_INPUT_OUTPUT*/T6 r78is_connected(void);
/*STD_INPUT_OUTPUT*/void r78flush(T78*C);
/*STD_INPUT_OUTPUT*/void r78put_string(T78*C,T0*a1);
extern T0*oBC72tmp_string;
extern int fBC72tmp_string;
/*STD_INPUT_OUTPUT*/T0*r78tmp_string(void);
/*STD_INPUT_OUTPUT*/void r78put_real_format(T78*C,T5 a1,T2 a2);
/*STD_INPUT_OUTPUT*/void r78put_integer(T78*C,T11 a1);
/*STD_INPUT_OUTPUT*/void r78put_abstract_string(T0*a1);
/*STD_INPUT_OUTPUT*/void r78disconnect(void);
/*STD_INPUT_OUTPUT*/T0*r78as_output_stream(T78*C);
/*UNIX_DIRECTORY_NOTATION*/T557*create557(void);
/*UNIX_DIRECTORY_NOTATION*/void r557to_subpath_with(T0*a1,T0*a2);
/*UNIX_DIRECTORY_NOTATION*/T0*r557from_path_name(T0*a1);
/*UNIX_DIRECTORY_NOTATION*/void r557to_subdirectory_with(T0*a1,T0*a2);
/*UNIX_DIRECTORY_NOTATION*/void r557start_join(T557*C,T0*a1,T2 a2);
/*UNIX_DIRECTORY_NOTATION*/void r557to_root(T0*a1,T0*a2);
/*UNIX_DIRECTORY_NOTATION*/void r557join_element(T557*C,T0*a1);
/*UNIX_DIRECTORY_NOTATION*/void r557to_directory_path(T0*a1);
/*UNIX_DIRECTORY_NOTATION*/void r557to_short_name_in(T0*a1,T0*a2);
/*UNIX_DIRECTORY_NOTATION*/void r557to_current_directory(T0*a1);
/*UNIX_DIRECTORY_NOTATION*/void r557to_file_path_with(T0*a1,T0*a2);
/*UNIX_DIRECTORY_NOTATION*/void r557from_notation(T557*C,T0*a1,T0*a2);
/*UNIX_DIRECTORY_NOTATION*/void r557to_absolute_path_in(T0*a1,T0*a2);
/*UNIX_DIRECTORY_NOTATION*/void r557to_parent_directory(T0*a1);
/*UNIX_DIRECTORY_NOTATION*/void r557join_directory(T557*C,T0*a1);
/*UNIX_DIRECTORY_NOTATION*/T6 r557is_absolute_path(T0*a1);
/*UNIX_DIRECTORY_NOTATION*/T0*r557to_notation(T557*C,T0*a1,T0*a2);
/*UNIX_DIRECTORY_NOTATION*/void r557join_up(T557*C);
/*UNIX_DIRECTORY_NOTATION*/void r557to_default_root(T0*a1);
extern T0*oBC557tmp1;
extern int fBC557tmp1;
/*UNIX_DIRECTORY_NOTATION*/T0*r557tmp1(void);
extern T0*oBC557tmp2;
extern int fBC557tmp2;
/*UNIX_DIRECTORY_NOTATION*/T0*r557tmp2(void);
/*WINDOWS_DIRECTORY_NOTATION*/T561*create561(void);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_subpath_with(T0*a1,T0*a2);
/*WINDOWS_DIRECTORY_NOTATION*/T0*r561from_path_name(T0*a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_subdirectory_with(T0*a1,T0*a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r561start_join(T561*C,T0*a1,T2 a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_root(T0*a1,T0*a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r561join_element(T561*C,T0*a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_directory_path(T0*a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_short_name_in(T0*a1,T0*a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_current_directory(T0*a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_file_path_with(T0*a1,T0*a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r561from_notation(T561*C,T0*a1,T0*a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_absolute_path_in(T0*a1,T0*a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_parent_directory(T0*a1);
/*WINDOWS_DIRECTORY_NOTATION*/void r561join_directory(T561*C,T0*a1);
/*WINDOWS_DIRECTORY_NOTATION*/T6 r561is_absolute_path(T0*a1);
/*WINDOWS_DIRECTORY_NOTATION*/T0*r561to_notation(T561*C,T0*a1,T0*a2);
/*WINDOWS_DIRECTORY_NOTATION*/void r561join_up(T561*C);
/*WINDOWS_DIRECTORY_NOTATION*/void r561to_default_root(T0*a1);
extern T0*oBC561tmp1;
extern int fBC561tmp1;
/*WINDOWS_DIRECTORY_NOTATION*/T0*r561tmp1(void);
extern T0*oBC561tmp2;
extern int fBC561tmp2;
/*WINDOWS_DIRECTORY_NOTATION*/T0*r561tmp2(void);
/*MACINTOSH_DIRECTORY_NOTATION*/T562*create562(void);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_subpath_with(T0*a1,T0*a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_subdirectory_with(T0*a1,T0*a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_directory_path(T0*a1);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_short_name_in(T0*a1,T0*a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_current_directory(T562*C,T0*a1);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_file_path_with(T0*a1,T0*a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562from_notation(T562*C,T0*a1,T0*a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_absolute_path_in(T562*C,T0*a1,T0*a2);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_parent_directory(T0*a1);
/*MACINTOSH_DIRECTORY_NOTATION*/T6 r562is_absolute_path(T562*C,T0*a1);
/*MACINTOSH_DIRECTORY_NOTATION*/T0*r562to_notation(T562*C,T0*a1,T0*a2);
/*MACINTOSH_DIRECTORY_NOTATION*/T6 r562is_valid_path(T0*a1);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562to_default_root(T562*C,T0*a1);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562crash(T562*C);
/*MACINTOSH_DIRECTORY_NOTATION*/void r562not_yet_implemented(T562*C);
/*AMIGA_DIRECTORY_NOTATION*/T563*create563(void);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_subpath_with(T0*a1,T0*a2);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_subdirectory_with(T0*a1,T0*a2);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_directory_path(T0*a1);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_short_name_in(T0*a1,T0*a2);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_current_directory(T563*C,T0*a1);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_file_path_with(T0*a1,T0*a2);
/*AMIGA_DIRECTORY_NOTATION*/void r563from_notation(T563*C,T0*a1,T0*a2);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_absolute_path_in(T563*C,T0*a1,T0*a2);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_parent_directory(T0*a1);
/*AMIGA_DIRECTORY_NOTATION*/T6 r563is_absolute_path(T563*C,T0*a1);
/*AMIGA_DIRECTORY_NOTATION*/T0*r563to_notation(T563*C,T0*a1,T0*a2);
/*AMIGA_DIRECTORY_NOTATION*/T6 r563is_valid_path(T0*a1);
/*AMIGA_DIRECTORY_NOTATION*/void r563to_default_root(T563*C,T0*a1);
/*AMIGA_DIRECTORY_NOTATION*/void r563crash(T563*C);
/*AMIGA_DIRECTORY_NOTATION*/void r563not_yet_implemented(T563*C);
/*OPENVMS_DIRECTORY_NOTATION*/T564*create564(void);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_subpath_with(T564*C,T0*a1,T0*a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_subdirectory_with(T0*a1,T0*a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_directory_path(T564*C,T0*a1);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_short_name_in(T564*C,T0*a1,T0*a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_current_directory(T564*C,T0*a1);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_file_path_with(T0*a1,T0*a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r564from_notation(T564*C,T0*a1,T0*a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_absolute_path_in(T564*C,T0*a1,T0*a2);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_parent_directory(T0*a1);
/*OPENVMS_DIRECTORY_NOTATION*/T6 r564is_absolute_path(T564*C,T0*a1);
/*OPENVMS_DIRECTORY_NOTATION*/T0*r564to_notation(T564*C,T0*a1,T0*a2);
/*OPENVMS_DIRECTORY_NOTATION*/T6 r564is_valid_path(T0*a1);
/*OPENVMS_DIRECTORY_NOTATION*/void r564to_default_root(T564*C,T0*a1);
/*OPENVMS_DIRECTORY_NOTATION*/void r564crash(T564*C);
/*OPENVMS_DIRECTORY_NOTATION*/void r564not_yet_implemented(T564*C);
/*CYGWIN_DIRECTORY_NOTATION*/T565*create565(void);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_subpath_with(T0*a1,T0*a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_subdirectory_with(T0*a1,T0*a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_directory_path(T0*a1);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_short_name_in(T0*a1,T0*a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_current_directory(T0*a1);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_file_path_with(T0*a1,T0*a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r565from_notation(T565*C,T0*a1,T0*a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_absolute_path_in(T0*a1,T0*a2);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_parent_directory(T0*a1);
/*CYGWIN_DIRECTORY_NOTATION*/T6 r565is_absolute_path(T0*a1);
/*CYGWIN_DIRECTORY_NOTATION*/T0*r565to_notation(T565*C,T0*a1,T0*a2);
/*CYGWIN_DIRECTORY_NOTATION*/T6 r565is_valid_path(T0*a1);
/*CYGWIN_DIRECTORY_NOTATION*/void r565to_default_root(T0*a1);
/*CYGWIN_DIRECTORY_NOTATION*/void r565crash(T565*C);
/*CYGWIN_DIRECTORY_NOTATION*/void r565not_yet_implemented(T565*C);
/*TEXT_FILE_READ*/void r102unlock_tagged_out(void);
/*TEXT_FILE_READ*/T0*r102tagged_out_memory_pool(void);
/*TEXT_FILE_READ*/void r102filtered_read_character(T102*C);
/*TEXT_FILE_READ*/void r102lock_tagged_out(void);
/*TEXT_FILE_READ*/void r102filtered_read_line_in(T102*C,T0*a1);
/*TEXT_FILE_READ*/void r102set_path(T102*C,T0*a1);
/*TEXT_FILE_READ*/void r102read_line(T102*C);
/*TEXT_FILE_READ*/void r102fill_buffer(T102*C);
/*TEXT_FILE_READ*/T6 r102same_as(T102*C,T0*a1);
/*TEXT_FILE_READ*/void r102connect_to(T102*C,T0*a1);
extern T0*oBC66last_string;
extern int fBC66last_string;
/*TEXT_FILE_READ*/T0*r102last_string(void);
/*TEXT_FILE_READ*/void r102dispose(T102*C);
/*TEXT_FILE_READ*/void r102disconnect(T102*C);
/*TEXT_FILE_READ*/T0*r102tagged_out_memories(void);
/*SE_C_MODE*/void r556make(T556*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T0*a9,T0*a10,T0*a11,T0*a12,T0*a13);
/*SYSTEM*/T0*r545get_environment_variable(T0*a1);
/*SYSTEM*/T6 r545get_environment_variable_in(T0*a1,T0*a2);
/*TEXT_FILE_WRITE*/void r464put_line(T464*C,T0*a1);
/*TEXT_FILE_WRITE*/T11 r464character_count(T464*C);
/*TEXT_FILE_WRITE*/void r464make(T464*C);
/*TEXT_FILE_WRITE*/void r464unlock_tagged_out(void);
/*TEXT_FILE_WRITE*/T0*r464tagged_out_memory_pool(void);
/*TEXT_FILE_WRITE*/void r464filtered_put_character(T464*C,T3 a1);
/*TEXT_FILE_WRITE*/void r464lock_tagged_out(void);
/*TEXT_FILE_WRITE*/void r464set_path(T464*C,T0*a1);
/*TEXT_FILE_WRITE*/T6 r464is_connected(T464*C);
/*TEXT_FILE_WRITE*/void r464flush(T464*C);
/*TEXT_FILE_WRITE*/void r464put_string(T464*C,T0*a1);
/*TEXT_FILE_WRITE*/T0*r464tmp_string(void);
/*TEXT_FILE_WRITE*/void r464put_real_format(T464*C,T5 a1,T2 a2);
/*TEXT_FILE_WRITE*/void r464put_integer(T464*C,T11 a1);
/*TEXT_FILE_WRITE*/void r464connect_to(T464*C,T0*a1);
/*TEXT_FILE_WRITE*/void r464filtered_flush(T464*C);
/*TEXT_FILE_WRITE*/void r464put_abstract_string(T464*C,T0*a1);
/*TEXT_FILE_WRITE*/void r464dispose(T464*C);
/*TEXT_FILE_WRITE*/void r464disconnect(T464*C);
/*TEXT_FILE_WRITE*/T0*r464tagged_out_memories(void);
/*TEXT_FILE_WRITE*/T0*r464as_output_stream(T464*C);
/*TEXT_FILE_WRITE*/void r464write_buffer(T464*C);
/*LINES_OUTPUT_STREAM*/void r665put_line(T665*C,T0*a1);
/*LINES_OUTPUT_STREAM*/void r665filtered_put_character(T665*C,T3 a1);
/*LINES_OUTPUT_STREAM*/T6 r665can_disconnect(T665*C);
/*LINES_OUTPUT_STREAM*/T6 r665is_connected(T665*C);
/*LINES_OUTPUT_STREAM*/void r665flush(T665*C);
/*LINES_OUTPUT_STREAM*/void r665put_string(T665*C,T0*a1);
/*LINES_OUTPUT_STREAM*/T0*r665tmp_string(void);
/*LINES_OUTPUT_STREAM*/void r665put_real_format(T665*C,T5 a1,T2 a2);
/*LINES_OUTPUT_STREAM*/void r665put_integer(T665*C,T11 a1);
/*LINES_OUTPUT_STREAM*/void r665connect_to(T665*C,T0*a1);
/*LINES_OUTPUT_STREAM*/void r665filtered_flush(T665*C);
/*LINES_OUTPUT_STREAM*/void r665put_abstract_string(T665*C,T0*a1);
/*LINES_OUTPUT_STREAM*/void r665dispose(T665*C);
/*LINES_OUTPUT_STREAM*/void r665disconnect(T665*C);
/*LINES_OUTPUT_STREAM*/T0*r665as_output_stream(T665*C);
/*STD_ERROR*/void r81put_line(T81*C,T0*a1);
/*STD_ERROR*/void r81put_natively_stored_string(T0*a1);
/*STD_ERROR*/T0*r81std_output(void);
/*STD_ERROR*/void r81flush(T81*C);
/*STD_ERROR*/void r81put_string(T81*C,T0*a1);
/*STD_ERROR*/T0*r81tmp_string(void);
/*STD_ERROR*/void r81put_real_format(T81*C,T5 a1,T2 a2);
/*STD_ERROR*/void r81put_integer(T81*C,T11 a1);
/*STD_ERROR*/void r81filtered_flush(void);
/*STD_ERROR*/void r81put_abstract_string(T0*a1);
/*STD_ERROR*/T0*r81as_output_stream(T81*C);
/*STD_OUTPUT*/void r69put_line(T69*C,T0*a1);
/*STD_OUTPUT*/void r69make(T69*C);
/*STD_OUTPUT*/void r69filtered_put_character(T69*C,T3 a1);
/*STD_OUTPUT*/void r69put_natively_stored_string(T69*C,T0*a1);
/*STD_OUTPUT*/T0*r69std_output(void);
/*STD_OUTPUT*/void r69flush(T69*C);
/*STD_OUTPUT*/void r69put_string(T69*C,T0*a1);
/*STD_OUTPUT*/T0*r69tmp_string(void);
/*STD_OUTPUT*/void r69put_real_format(T69*C,T5 a1,T2 a2);
/*STD_OUTPUT*/void r69put_integer(T69*C,T11 a1);
/*STD_OUTPUT*/void r69se_atexit(void);
/*STD_OUTPUT*/void r69filtered_flush(T69*C);
/*STD_OUTPUT*/void r69put_abstract_string(T69*C,T0*a1);
/*STD_OUTPUT*/T0*r69as_output_stream(T69*C);
/*STD_OUTPUT*/void r69write_buffer(T69*C);
/*TMP_FEATURE*/T0*r467as_character_constant(T467*C,T0*a1);
/*TMP_FEATURE*/T0*r467n(T467*C);
/*TMP_FEATURE*/T0*r467as_once_routine(T467*C);
/*TMP_FEATURE*/T0*r467as_deferred_routine(T467*C);
/*TMP_FEATURE*/void r467constant_attribute_common_checks(T467*C,T0*a1);
/*TMP_FEATURE*/T0*r467as_writable_attribute(T467*C);
/*TMP_FEATURE*/void r467initialize(T467*C);
/*TMP_FEATURE*/T0*r467as_string_constant(T467*C,T0*a1);
/*TMP_FEATURE*/void r467set_require(T467*C,T351 a1,T6 a2,T0*a3,T0*a4);
/*TMP_FEATURE*/T0*r467as_constant(T467*C,T0*a1);
/*TMP_FEATURE*/T0*r467as_procedure_or_function(T467*C);
/*TMP_FEATURE*/T0*r467as_unique_constant(T467*C);
/*TMP_FEATURE*/T0*r467as_external_routine(T467*C,T0*a1,T0*a2);
/*TMP_FEATURE*/T0*r467error_handler(void);
/*TMP_FEATURE*/void r467add_index_clause(T467*C,T0*a1);
/*TMP_FEATURE*/T0*r467as_boolean_constant(T467*C,T0*a1);
/*PARSER_BUFFER*/void r123make(T123*C);
/*PARSER_BUFFER*/void r123release(T123*C);
/*PARSER_BUFFER*/void r123load_file(T123*C,T0*a1);
/*PARSER_BUFFER*/T0*r123error_handler(void);
/*PARSER_BUFFER*/T0*r123empty_line_at(T123*C,T2 a1);
/*C_SPLITTER_NO_SPLIT*/void r708make(void);
/*C_SPLITTER_NO_SPLIT*/void r708connect(T708*C,T0*a1);
/*C_SPLITTER_NO_SPLIT*/void r708split_now(T708*C);
/*C_SPLITTER_NO_SPLIT*/void r708connect_out_c(T708*C);
/*C_SPLITTER_NO_SPLIT*/T0*r708echo(void);
/*C_SPLITTER_NO_SPLIT*/void r708c_connect(T708*C,T0*a1);
/*C_SPLITTER_NO_SPLIT*/T0*r708cpp(void);
/*C_SPLITTER_NO_SPLIT*/T0*r708system_tools(void);
extern T0*oBC703out_c;
extern int fBC703out_c;
/*C_SPLITTER_NO_SPLIT*/T0*r708out_c(void);
/*C_SPLITTER_NO_SPLIT*/T6 r708write_make_file(T708*C,T0*a1);
/*C_SPLITTER_NO_SPLIT*/T0*r708linker_command(T708*C,T0*a1);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709make(T709*C);
/*C_SPLITTER_BY_LIVE_TYPE*/T6 r709should_split(T709*C,T2 a1);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709connect(T709*C,T0*a1);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709split_now(T709*C);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709connect_out_c(T709*C);
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709echo(void);
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709c_files_suffixes(T709*C);
/*C_SPLITTER_BY_LIVE_TYPE*/T2 r709current_id(T709*C);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709c_connect(T709*C,T0*a1);
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709cpp(void);
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709current_c_file_suffix(T709*C);
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709tmp_path(void);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709backup_tfw_connect(T709*C,T0*a1);
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709system_tools(void);
extern T0*oBC705tmp_string;
extern int fBC705tmp_string;
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709tmp_string(void);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709do_split(T709*C);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709path_in(T709*C,T0*a1,T0*a2,T0*a3);
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709out_c(void);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709set_live_type(T709*C,T0*a1);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709append_suffix(T709*C);
/*C_SPLITTER_BY_LIVE_TYPE*/T6 r709write_make_file(T709*C,T0*a1);
/*C_SPLITTER_BY_LIVE_TYPE*/T0*r709linker_command(T709*C,T0*a1);
/*C_SPLITTER_BY_LIVE_TYPE*/void r709_P_703_connect(T709*C,T0*a1);
/*C_SPLITTER_LEGACY*/void r704make(T704*C);
/*C_SPLITTER_LEGACY*/void r704add_objects_(T0*a1,T0*a2,T2 a3,T2 a4);
/*C_SPLITTER_LEGACY*/T6 r704should_split(T704*C,T2 a1);
/*C_SPLITTER_LEGACY*/void r704connect(T704*C,T0*a1);
/*C_SPLITTER_LEGACY*/void r704split_now(T704*C);
/*C_SPLITTER_LEGACY*/void r704connect_out_c(T704*C);
/*C_SPLITTER_LEGACY*/T0*r704echo(void);
/*C_SPLITTER_LEGACY*/T0*r704c_files_suffixes(T704*C);
/*C_SPLITTER_LEGACY*/void r704c_connect(T704*C,T0*a1);
/*C_SPLITTER_LEGACY*/T0*r704cpp(void);
/*C_SPLITTER_LEGACY*/T0*r704current_c_file_suffix(T704*C);
/*C_SPLITTER_LEGACY*/void r704add_objects(T704*C,T0*a1);
/*C_SPLITTER_LEGACY*/T0*r704tmp_path(void);
/*C_SPLITTER_LEGACY*/void r704backup_tfw_connect(T704*C,T0*a1);
/*C_SPLITTER_LEGACY*/T0*r704system_tools(void);
/*C_SPLITTER_LEGACY*/T0*r704tmp_string(void);
/*C_SPLITTER_LEGACY*/void r704do_split(T704*C);
/*C_SPLITTER_LEGACY*/void r704path_in(T704*C,T0*a1,T0*a2,T0*a3);
/*C_SPLITTER_LEGACY*/T0*r704out_c(void);
/*C_SPLITTER_LEGACY*/T6 r704write_make_file(T704*C,T0*a1);
/*C_SPLITTER_LEGACY*/T0*r704linker_command(T704*C,T0*a1);
/*HASHED_STRING*/T6 r107is_equal(T107*C,T0*a1);
/*HASHED_STRING*/void r107make(T107*C,T0*a1,T2 a2);
/*HASHED_STRING*/void r107set(T107*C,T0*a1);
/*HASHED_STRING*/T6 r107is_tuple_related(T107*C);
/*DIRECTORY*/T0*r566connect_directory(T566*C,T0*a1);
/*DIRECTORY*/void r566scan(T566*C,T0*a1);
/*UNIVERSE*/void r710make(T710*C);
/*UNIVERSE*/void r710add_classes(T710*C,T0*a1);
/*UNIVERSE*/void r710for_all(T710*C,T0*a1);
/*UNIVERSE*/T2 r710cluster_count(T710*C);
extern T0*oBC707classes_notation;
/*UNIVERSE*/T6 r710has_physical_cluster(T710*C,T0*a1);
/*UNIVERSE*/T0*r710echo(void);
/*UNIVERSE*/T0*r710cluster_named(T710*C,T0*a1);
/*UNIVERSE*/T6 r710is_system_path(T710*C,T0*a1);
/*UNIVERSE*/void r710get_started(T710*C,T2 a1);
/*UNIVERSE*/T0*r710system_path_to_classes_path(T710*C,T0*a1);
/*UNIVERSE*/void r710clusters_of(T710*C,T0*a1,T0*a2,T0*a3,T0*a4,T2 a5);
/*UNIVERSE*/void r710add_entry(T710*C,T2 a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*UNIVERSE*/void r710view_in(T710*C,T0*a1);
/*UNIVERSE*/T0*r710cluster_by_directory_path(T710*C,T0*a1);
extern T0*oBC707system_notation;
extern int fBC707system_notation;
/*UNIVERSE*/T0*r710system_notation(T710*C);
/*UNIVERSE*/T2 r710loaded_class_count(T710*C);
/*UNIVERSE*/void r710show_tabs(T2 a1);
/*UNIVERSE*/void r710parse_include(T710*C);
/*UNIVERSE*/T0*r710find_physical_cluster(T710*C,T0*a1);
/*UNIVERSE*/void r710show(T710*C,T2 a1);
/*POSITION*/T6 r351is_equal(T351*C,T351 a1);
/*POSITION*/void r351set(T351*C,T2 a1,T2 a2,T10 a3,T0*a4);
/*POSITION*/void r351default_create(T351*C);
/*POSITION*/T6 r351sedb_trace(T351*C);
/*POSITION*/T6 r351same_line_as(T351*C,T351 a1);
extern T0*oBC32plugin_config;
/*POSITION*/T0*r351path(T351*C);
/*POSITION*/T10 r351id(T351*C);
/*POSITION*/void r351set_in_ace_file(T351*C,T2 a1,T2 a2);
/*POSITION*/T0*r351class_text_name(T351*C);
/*POSITION*/T0*r351id_provider(void);
extern T960 oBC351class_text_storage;
extern T0*oBC32ini_parser;
/*POSITION*/void r351set_in_ini_file(T351*C,T2 a1,T2 a2,T10 a3);
/*POSITION*/T6 r351_ix_60(T351*C,T351 a1);
/*POSITION*/T0*r351class_text(T351*C);
/*POSITION*/T351 r351twin(T351*C);
/*POSITION*/T2 r351column(T351*C);
/*POSITION*/T2 r351line(T351*C);
/*POSITION*/T6 r351before(T351*C,T351 a1);
/*COMMENT*/T0*r437to_expression(T437*C);
/*COMMENT*/void r437make(T437*C,T351 a1,T0*a2);
/*COMMENT*/void r437pretty(T437*C,T2 a1);
/*COMMENT*/T0*r437simplify(T0*a1);
/*COMMENT*/void r437good_end_warning_check(T437*C,T0*a1);
/*COMMENT*/T6 r437is_dummy_feature_end(T437*C,T0*a1);
/*COMMENT*/void r437add_last(T437*C,T0*a1);
/*COMMENT*/void r437append(T437*C,T0*a1);
/*COMMENT*/T6 r437use_current(T0*a1);
/*COMMENT*/T6 r437side_effect_free(T0*a1);
/*COMMENT*/T0*r437error_handler(void);
/*COMMENT*/T0*r437inline_dynamic_dispatch(T0*a1,T0*a2);
/*COMMENT*/T2 r437count(T437*C);
/*COMMENT*/T0*r437to_instruction(T437*C);
/*UNICODE_STRING*/void r333make(T333*C,T2 a1);
/*UNICODE_STRING*/void r333make_empty(T333*C);
/*UNICODE_STRING*/T6 r333valid_unicode(T2 a1);
/*UNICODE_STRING*/void r333utf8_character_in(T2 a1,T0*a2);
/*UNICODE_STRING*/void r333extend(T333*C,T2 a1);
/*UNICODE_STRING*/void r333add_last(T333*C,T2 a1);
/*UNICODE_STRING*/T10 r333low_surrogate_value(T333*C,T2 a1);
/*UNICODE_STRING*/T2 r333item(T333*C,T2 a1);
/*UNICODE_STRING*/void r333clear_count(T333*C);
/*UNICODE_STRING*/void r333utf8_encode_in(T333*C,T0*a1);
/*UNICODE_STRING*/void r333next_generation(T333*C);
/*UNICODE_STRING*/void r333_P_45_next_generation(T333*C);
extern T0*oBC711classes_memory;
extern int fBC711classes_memory;
/*CLASSES_TREE_FACTORY*/T0*r711classes_memory(void);
/*CLASSES_TREE_FACTORY*/T0*r711classes(T711*C,T2 a1,T0*a2,T0*a3,T0*a4,T0*a5,T6 a6);
/*CLASSES_TREE_FACTORY*/T0*r711error_handler(void);
extern T0*oBC711universe;
extern int fBC711universe;
/*CLASSES_TREE_FACTORY*/T0*r711universe(void);
/*CLUSTER*/void r447register_class_text(T447*C,T0*a1);
extern T0*oBC447file_name_buffer;
extern int fBC447file_name_buffer;
/*CLUSTER*/T0*r447file_name_buffer(void);
/*CLUSTER*/void r447exclude_add_last(T447*C,T0*a1);
/*CLUSTER*/void r447include_add_last(T447*C,T0*a1);
/*CLUSTER*/void r447read_classes(T447*C);
/*CLUSTER*/T6 r447trace(T447*C,T0*a1);
/*CLUSTER*/void r447include_parsing(T447*C);
/*CLUSTER*/T0*r447system_tools(void);
/*CLUSTER*/T6 r447debug_check(T447*C,T0*a1,T0*a2);
extern T0*oBC447path_buffer;
extern int fBC447path_buffer;
/*CLUSTER*/T0*r447path_buffer(void);
/*CLUSTER*/T2 r447class_text_count(T447*C);
/*CLUSTER*/void r447add_default_debug_key(T447*C,T0*a1);
/*CLUSTER*/T2 r447assertion_level_of(T447*C,T0*a1);
/*CLUSTER*/T0*r447parser_buffer(void);
/*CLUSTER*/T6 r447parser_buffer_load(T447*C);
/*CLUSTER*/void r447show(T447*C);
/*CLUSTER*/void r447make(T447*C,T0*a1,T0*a2,T0*a3);
/*CLUSTER*/T0*r447echo(void);
/*CLUSTER*/T2 r447loaded_class_count(T447*C);
/*CLUSTER*/void r447init(T447*C,T0*a1,T2 a2);
/*CLUSTER*/T6 r447parser_buffer_for(T447*C,T0*a1,T6 a2);
/*CLUSTER*/T0*r447level_name(T2 a1);
/*CLUSTER*/T6 r447match_debug_keys(T0*a1,T0*a2);
/*CLUSTER*/T6 r447default_trace_or_ace_default_trace(T447*C);
/*CLUSTER*/void r447set_option_assertion_level(T447*C,T0*a1,T2 a2);
/*CLUSTER*/void r447for_all(T447*C,T0*a1);
/*CLUSTER*/T0*r447class_text(T447*C,T0*a1,T6 a2);
/*CLUSTER*/T0*r447error_handler(void);
/*CLUSTER*/void r447set_default_trace(T447*C,T6 a1);
/*CLUSTER*/void r447add_option_trace(T447*C,T0*a1);
/*CLUSTER*/void r447get_started(T447*C,T2 a1);
/*CLUSTER*/void r447view_in(T447*C,T0*a1);
/*CLUSTER*/T6 r447prepare_parser_buffer_for(T447*C,T0*a1);
/*CLUSTER*/void r447add_option_debug_key(T447*C,T0*a1,T0*a2);
/*TOKEN_BUFFER*/T0*r790to_class_name(T790*C,T6 a1);
/*TOKEN_BUFFER*/T0*r790eiffel_parser(void);
/*TOKEN_BUFFER*/T0*r790to_local_name_def(T790*C);
/*TOKEN_BUFFER*/T0*r790to_feature_name(T790*C);
/*TOKEN_BUFFER*/T0*r790to_tag_name(T790*C);
/*TOKEN_BUFFER*/void r790extend(T3 a1);
/*TOKEN_BUFFER*/T6 r790isa_keyword(void);
/*TOKEN_BUFFER*/T0*r790to_argument_name_ref(T790*C,T0*a1,T2 a2,T2 a3);
/*TOKEN_BUFFER*/T0*r790hashed_string(T790*C);
/*TOKEN_BUFFER*/T351 r790start_position(T790*C);
/*TOKEN_BUFFER*/T0*r790to_manifest_string(T790*C);
/*TOKEN_BUFFER*/T0*r790to_writable_attribute_name(T790*C);
/*TOKEN_BUFFER*/T0*r790to_local_name_ref(T790*C,T0*a1,T2 a2,T2 a3);
/*TOKEN_BUFFER*/void r790append(T0*a1);
/*TOKEN_BUFFER*/void r790reset(T790*C,T2 a1,T2 a2);
/*TOKEN_BUFFER*/T0*r790to_argument_name_def(T790*C);
typedef struct _se_agenT588f588l40c32 se_agenT588f588l40c32;
struct _se_agenT588f588l40c32{Tid id;
int creation_mold_id;
T6(*afp)(se_agenT588f588l40c32*,T0*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T6 R;
};
/*agent creation*/T0*agenT588f588l40c32(T0*closed_C);
typedef struct _se_agenT588f589l25c46 se_agenT588f589l25c46;
struct _se_agenT588f589l25c46{Tid id;
int creation_mold_id;
void(*afp)(se_agenT588f589l25c46*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT588f589l25c46(T0*closed_C);
/*C_HEADER_PASS_0*/void r588visit_empty_tuple_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588make(T588*C);
/*C_HEADER_PASS_0*/void r588visit_string_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_real_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588compile_live_type(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_native_array_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_natural_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_weak_reference_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_user_generic_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_pointer_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_agent_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_any_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/T0*r588cpp(void);
/*C_HEADER_PASS_0*/void r588visit_character_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588do_compile(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588compile(T588*C);
/*C_HEADER_PASS_0*/void r588visit_boolean_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588flush_out_h(void);
/*C_HEADER_PASS_0*/void r588visit_array_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_integer_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/T6 r588compare_priorities(T588*C,T0*a1,T0*a2);
/*C_HEADER_PASS_0*/void r588visit_class_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588visit_non_empty_tuple_type_mark(T588*C,T0*a1);
/*C_HEADER_PASS_0*/void r588_P_618_make(T588*C);
typedef struct _se_agenT621f589l25c46 se_agenT621f589l25c46;
struct _se_agenT621f589l25c46{Tid id;
int creation_mold_id;
void(*afp)(se_agenT621f589l25c46*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT621f589l25c46(T0*closed_C);
/*C_HEADER_PASS_1*/void r621make(T621*C);
/*C_HEADER_PASS_1*/void r621compile_live_type(T621*C,T0*a1);
/*C_HEADER_PASS_1*/void r621visit_native_array_type_mark(T621*C,T0*a1);
/*C_HEADER_PASS_1*/void r621visit_natural_type_mark(T0*a1);
/*C_HEADER_PASS_1*/void r621visit_weak_reference_type_mark(T621*C,T0*a1);
/*C_HEADER_PASS_1*/void r621standard_c_typedef(T0*a1);
/*C_HEADER_PASS_1*/void r621pre_compile(void);
/*C_HEADER_PASS_1*/void r621visit_agent_type_mark(T0*a1);
/*C_HEADER_PASS_1*/T0*r621cpp(void);
/*C_HEADER_PASS_1*/void r621do_compile(T621*C,T0*a1);
/*C_HEADER_PASS_1*/void r621compile(T621*C);
/*C_HEADER_PASS_1*/void r621flush_out_h(void);
/*C_HEADER_PASS_1*/void r621visit_class_type_mark(T0*a1);
typedef struct _se_agenT622f589l25c46 se_agenT622f589l25c46;
struct _se_agenT622f589l25c46{Tid id;
int creation_mold_id;
void(*afp)(se_agenT622f589l25c46*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT622f589l25c46(T0*closed_C);
/*C_HEADER_PASS_2*/void r622make(T622*C);
/*C_HEADER_PASS_2*/void r622compile_live_type(T622*C,T0*a1);
/*C_HEADER_PASS_2*/void r622visit_native_array_type_mark(T622*C,T0*a1);
/*C_HEADER_PASS_2*/void r622visit_weak_reference_type_mark(T622*C,T0*a1);
/*C_HEADER_PASS_2*/void r622standard_c_typedef(T0*a1);
/*C_HEADER_PASS_2*/T0*r622cpp(void);
/*C_HEADER_PASS_2*/void r622do_compile(T622*C,T0*a1);
/*C_HEADER_PASS_2*/void r622compile(T622*C);
/*C_HEADER_PASS_2*/void r622native_array_type_in(T0*a1,T0*a2);
/*C_HEADER_PASS_2*/void r622flush_out_h(void);
typedef struct _se_agenT623f623l22c52 se_agenT623f623l22c52;
struct _se_agenT623f623l22c52{Tid id;
int creation_mold_id;
void(*afp)(se_agenT623f623l22c52*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT623f623l22c52(T0*closed_C);
typedef struct _se_agenT623f589l25c46 se_agenT623f589l25c46;
struct _se_agenT623f589l25c46{Tid id;
int creation_mold_id;
void(*afp)(se_agenT623f589l25c46*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT623f589l25c46(T0*closed_C);
/*C_HEADER_PASS_3*/void r623make(T623*C);
/*C_HEADER_PASS_3*/void r623standard_c_object_model(T0*a1);
/*C_HEADER_PASS_3*/void r623compile_expanded(T623*C,T0*a1);
/*C_HEADER_PASS_3*/void r623compile_live_type(T623*C,T0*a1);
/*C_HEADER_PASS_3*/void r623c_object_model_in(T0*a1);
/*C_HEADER_PASS_3*/void r623visit_weak_reference_type_mark(T0*a1);
/*C_HEADER_PASS_3*/void r623visit_user_generic_type_mark(T0*a1);
/*C_HEADER_PASS_3*/T0*r623cpp(void);
/*C_HEADER_PASS_3*/void r623do_compile(T623*C,T0*a1);
/*C_HEADER_PASS_3*/void r623compile(T623*C);
/*C_HEADER_PASS_3*/void r623flush_out_h(void);
/*C_HEADER_PASS_3*/void r623standard_c_struct(T0*a1);
/*C_HEADER_PASS_3*/void r623visit_class_type_mark(T0*a1);
typedef struct _se_agenT624f589l25c46 se_agenT624f589l25c46;
struct _se_agenT624f589l25c46{Tid id;
int creation_mold_id;
void(*afp)(se_agenT624f589l25c46*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT624f589l25c46(T0*closed_C);
/*C_HEADER_PASS_4*/void r624visit_empty_tuple_type_mark(T0*a1);
/*C_HEADER_PASS_4*/void r624make(T624*C);
/*C_HEADER_PASS_4*/void r624visit_string_type_mark(T0*a1);
/*C_HEADER_PASS_4*/void r624standard_c_object_model(T0*a1);
/*C_HEADER_PASS_4*/void r624compile_live_type(T624*C,T0*a1);
/*C_HEADER_PASS_4*/void r624visit_natural_type_mark(T0*a1);
/*C_HEADER_PASS_4*/void r624c_object_model_in(T0*a1);
/*C_HEADER_PASS_4*/void r624visit_user_generic_type_mark(T0*a1);
/*C_HEADER_PASS_4*/void r624c_print_function(T0*a1);
/*C_HEADER_PASS_4*/void r624visit_any_type_mark(T0*a1);
/*C_HEADER_PASS_4*/T0*r624cpp(void);
/*C_HEADER_PASS_4*/void r624do_compile(T624*C,T0*a1);
/*C_HEADER_PASS_4*/void r624compile(T624*C);
/*C_HEADER_PASS_4*/void r624standard_c_print_function(T0*a1);
/*C_HEADER_PASS_4*/void r624flush_out_h(void);
/*C_HEADER_PASS_4*/void r624visit_array_type_mark(T0*a1);
/*C_HEADER_PASS_4*/void r624standard_c_struct(T0*a1);
/*C_HEADER_PASS_4*/void r624visit_class_type_mark(T0*a1);
/*C_HEADER_PASS_4*/void r624visit_non_empty_tuple_type_mark(T0*a1);
typedef struct _se_agenT625f625l584c33 se_agenT625f625l584c33;
struct _se_agenT625f625l584c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l584c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
T0* closed_a2;
};
/*agent creation*/T0*agenT625f625l584c33(T0*closed_a2);
typedef struct _se_agenT625f625l600c30 se_agenT625f625l600c30;
struct _se_agenT625f625l600c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l600c30*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_a2;
};
/*agent creation*/T0*agenT625f625l600c30(T0*closed_a2);
typedef struct _se_agenT625f625l256c33 se_agenT625f625l256c33;
struct _se_agenT625f625l256c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l256c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
T0* closed_a2;
};
/*agent creation*/T0*agenT625f625l256c33(T0*closed_a2);
typedef struct _se_agenT625f625l276c30 se_agenT625f625l276c30;
struct _se_agenT625f625l276c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l276c30*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_a2;
};
/*agent creation*/T0*agenT625f625l276c30(T0*closed_a2);
typedef struct _se_agenT625f625l357c33 se_agenT625f625l357c33;
struct _se_agenT625f625l357c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l357c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
T0* closed_a2;
};
/*agent creation*/T0*agenT625f625l357c33(T0*closed_a2);
typedef struct _se_agenT625f625l375c30 se_agenT625f625l375c30;
struct _se_agenT625f625l375c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l375c30*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_a2;
};
/*agent creation*/T0*agenT625f625l375c30(T0*closed_a2);
typedef struct _se_agenT625f625l424c33 se_agenT625f625l424c33;
struct _se_agenT625f625l424c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l424c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT625f625l424c33(void);
typedef struct _se_agenT625f625l437c30 se_agenT625f625l437c30;
struct _se_agenT625f625l437c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l437c30*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT625f625l437c30(void);
typedef struct _se_agenT625f625l447c72 se_agenT625f625l447c72;
struct _se_agenT625f625l447c72{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l447c72*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_a2;
};
/*agent creation*/T0*agenT625f625l447c72(T0*closed_a2);
typedef struct _se_agenT625f625l81c56 se_agenT625f625l81c56;
struct _se_agenT625f625l81c56{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l81c56*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_a1;
};
/*agent creation*/T0*agenT625f625l81c56(T0*closed_a1);
typedef struct _se_agenT625f625l108c55 se_agenT625f625l108c55;
struct _se_agenT625f625l108c55{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l108c55*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_a1;
};
/*agent creation*/T0*agenT625f625l108c55(T0*closed_a1);
typedef struct _se_agenT625f625l119c20 se_agenT625f625l119c20;
struct _se_agenT625f625l119c20{Tid id;
int creation_mold_id;
void(*afp)(se_agenT625f625l119c20*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT625f625l119c20(void);
/*C_LIVE_TYPE_COMPILER*/void r625create_function_define(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/void r625set_pending_c_function_counter_tag(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625for_all_argument_names(T0*a1,T0*a2,T0*a3);
/*C_LIVE_TYPE_COMPILER*/void r625for_all_locals__(T0*a1,T0*a2,T0*a3);
extern T0*oBC625c_frame_descriptor_format;
extern int fBC625c_frame_descriptor_format;
/*C_LIVE_TYPE_COMPILER*/T0*r625c_frame_descriptor_format(void);
/*C_LIVE_TYPE_COMPILER*/T0*r625internal_c_local_tag(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625set_internal_c_local_tag(T0*a1,T0*a2);
extern T0*oBC619pending_c_function_counter_tag_key;
extern int fBC619pending_c_function_counter_tag_key;
/*C_LIVE_TYPE_COMPILER*/T0*r625pending_c_function_counter_tag_key(void);
/*C_LIVE_TYPE_COMPILER*/void r625define_agent_creation_for(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625put_c_field_name(T0*a1);
/*C_LIVE_TYPE_COMPILER*/T6 r625rf7_does_need_c_wrapper(T0*a1);
extern T0*oBC619pending_c_function_counter_tag_values;
extern int fBC619pending_c_function_counter_tag_values;
/*C_LIVE_TYPE_COMPILER*/T0*r625pending_c_function_counter_tag_values(void);
/*C_LIVE_TYPE_COMPILER*/void r625_inline_agent25(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/void r625_inline_agent19(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/void r625_inline_agent24(T0*a1,T0*a2,T2 a3);
/*C_LIVE_TYPE_COMPILER*/void r625_inline_agent23(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625_inline_agent18(T0*a1,T0*a2,T2 a3);
extern T0*oBC619internal_c_local_tag_key;
extern int fBC619internal_c_local_tag_key;
/*C_LIVE_TYPE_COMPILER*/T0*r625internal_c_local_tag_key(void);
/*C_LIVE_TYPE_COMPILER*/void r625_inline_agent22(T0*a1,T2 a2);
/*C_LIVE_TYPE_COMPILER*/void r625_inline_agent21(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/void r625_inline_agent20(T0*a1,T0*a2,T2 a3);
extern T0*oBC625c_frame_descriptor_locals;
extern int fBC625c_frame_descriptor_locals;
/*C_LIVE_TYPE_COMPILER*/T0*r625c_frame_descriptor_locals(void);
/*C_LIVE_TYPE_COMPILER*/void r625closure_args_compile_to_c_in(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/T0*r625cpp(void);
/*C_LIVE_TYPE_COMPILER*/void r625define_c_signature(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625is_equal_agent_creation_define_function(T0*a1,T0*a2);
extern T0*oBC625is_equal_agent_creation_type_generated;
extern int fBC625is_equal_agent_creation_type_generated;
/*C_LIVE_TYPE_COMPILER*/T0*r625is_equal_agent_creation_type_generated(void);
/*C_LIVE_TYPE_COMPILER*/void r625rank_name_in(T2 a1,T0*a2,T0*a3);
/*C_LIVE_TYPE_COMPILER*/void r625compile_live_type(T625*C,T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625put_c_name_tag(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625visit_run_feature_2(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625visit_run_feature_3(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625visit_run_feature_4(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625c_frame_descriptor(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625visit_run_feature_5(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625define_agent_creation_function(T0*a1,T0*a2,T0*a3,T2 a4);
/*C_LIVE_TYPE_COMPILER*/void r625visit_run_feature_6(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625make(T625*C);
/*C_LIVE_TYPE_COMPILER*/void r625visit_run_feature_7(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625args_c_frame_descriptor(T0*a1,T0*a2,T6 a3,T2 a4);
/*C_LIVE_TYPE_COMPILER*/void r625visit_run_feature_8(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625visit_run_feature_9(T0*a1);
/*C_LIVE_TYPE_COMPILER*/T0*r625echo(void);
/*C_LIVE_TYPE_COMPILER*/T6 r625rf8_does_need_c_wrapper(T0*a1);
extern T0*oBC625agent_address_of_c_define;
extern int fBC625agent_address_of_c_define;
/*C_LIVE_TYPE_COMPILER*/T0*r625agent_address_of_c_define(void);
/*C_LIVE_TYPE_COMPILER*/void r625is_equal_agent_creation_define_type_for(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/void r625compile(T625*C,T0*a1,T2 a2);
/*C_LIVE_TYPE_COMPILER*/void r625is_equal_mold_id_in(T0*a1,T0*a2,T0*a3);
/*C_LIVE_TYPE_COMPILER*/void r625c_define_opening(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625args_compile_to_c_in(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/void r625for_all_arguments__(T0*a1,T0*a2,T0*a3,T2 a4);
/*C_LIVE_TYPE_COMPILER*/void r625open_operand_name_in(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/T2 r625pending_c_function_counter_tag(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625for_all_local_names(T0*a1,T0*a2,T0*a3);
/*C_LIVE_TYPE_COMPILER*/void r625do_compile(T625*C,T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625define_check_class_invariant_c_function(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625initialize_expanded(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/void r625address_of_c_define(T0*a1);
/*C_LIVE_TYPE_COMPILER*/void r625compile_to_c_old_memory(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/T0*r625error_handler(void);
/*C_LIVE_TYPE_COMPILER*/void r625c_initialize_frame_information(T0*a1,T2 a2);
/*C_LIVE_TYPE_COMPILER*/T0*r625define_agent_creation_type(T0*a1,T0*a2,T6 a3,T0*a4,T2 a5);
extern T0*oBC625is_equal_agent_creation_function_generated;
extern int fBC625is_equal_agent_creation_function_generated;
/*C_LIVE_TYPE_COMPILER*/T0*r625is_equal_agent_creation_function_generated(void);
/*C_LIVE_TYPE_COMPILER*/void r625closed_operand_name_in(T0*a1,T0*a2);
/*C_LIVE_TYPE_COMPILER*/void r625c_define_closing(T0*a1);
/*C_MAPPER*/void r637visit_run_feature_7(T0*a1);
/*C_MAPPER*/void r637visit_run_feature_8(T0*a1);
/*C_MAPPER*/void r637visit_run_feature_9(T0*a1);
/*C_MAPPER*/void r637put_c_field_name(T0*a1);
/*C_MAPPER*/void r637default_mapping_function(T0*a1);
/*C_MAPPER*/T6 r637rf8_does_need_c_wrapper(T0*a1);
/*C_MAPPER*/void r637default_mapping_procedure(T0*a1);
/*C_MAPPER*/T6 r637rf7_does_need_c_wrapper(T0*a1);
/*C_MAPPER*/T0*r637cpp(void);
/*C_MAPPER*/void r637compile(T637*C,T0*a1);
/*C_MAPPER*/T0*r637error_handler(void);
/*C_MAPPER*/void r637visit_run_feature_1(T0*a1);
/*C_MAPPER*/void r637default_mapping_arg(T0*a1,T6 a2,T6 a3,T6 a4);
/*C_MAPPER*/void r637visit_run_feature_2(T0*a1);
/*C_MAPPER*/void r637visit_run_feature_3(T0*a1);
/*C_MAPPER*/void r637visit_run_feature_4(T0*a1);
/*C_MAPPER*/void r637visit_run_feature_5(T0*a1);
/*C_MAPPER*/void r637visit_run_feature_6(T0*a1);
/*C_INITIALIZER*/void r638visit_empty_tuple_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_string_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_like_feature_type_mark(T638*C,T0*a1);
/*C_INITIALIZER*/void r638visit_real_type_mark(T0*a1);
/*C_INITIALIZER*/T0*r638for(T638*C,T0*a1);
/*C_INITIALIZER*/void r638visit_native_array_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_natural_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_like_current_type_mark(T638*C,T0*a1);
/*C_INITIALIZER*/void r638visit_weak_reference_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_like_argument_type_mark(T638*C,T0*a1);
/*C_INITIALIZER*/void r638visit_user_generic_type_mark(T638*C,T0*a1);
/*C_INITIALIZER*/void r638visit_pointer_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_any_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_agent_type_mark(T0*a1);
/*C_INITIALIZER*/T0*r638cpp(void);
/*C_INITIALIZER*/void r638visit_character_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_formal_generic_type_mark(T638*C,T0*a1);
/*C_INITIALIZER*/void r638c_initialize_user_expanded(T638*C,T0*a1);
/*C_INITIALIZER*/void r638visit_boolean_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_array_type_mark(T0*a1);
/*C_INITIALIZER*/void r638crash(T638*C);
/*C_INITIALIZER*/void r638visit_integer_type_mark(T0*a1);
/*C_INITIALIZER*/void r638visit_class_type_mark(T638*C,T0*a1);
/*C_INITIALIZER*/void r638visit_non_empty_tuple_type_mark(T0*a1);
typedef struct _se_agenT639f640l132c33 se_agenT639f640l132c33;
struct _se_agenT639f640l132c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT639f640l132c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a2;
};
/*agent creation*/T0*agenT639f640l132c33(T0*closed_C,T0*closed_a2);
typedef struct _se_agenT639f640l152c30 se_agenT639f640l152c30;
struct _se_agenT639f640l152c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT639f640l152c30*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT639f640l152c30(void);
/*C_TARGET_MAPPER*/void r639set_pending_c_function_counter_tag(T0*a1);
/*C_TARGET_MAPPER*/void r639for_all_argument_names(T0*a1,T0*a2,T0*a3);
/*C_TARGET_MAPPER*/void r639visit_void_call(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639for_all_locals__(T0*a1,T0*a2,T0*a3);
/*C_TARGET_MAPPER*/void r639visit_create_expression(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639compile_feature_call(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_fake_tuple(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_e_false(T0*a1);
/*C_TARGET_MAPPER*/void r639visit_call_infix_ge(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_native_array_item(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_implicit_cast(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_integer_constant(T0*a1);
/*C_TARGET_MAPPER*/void r639not_yet_implemented(T639*C);
/*C_TARGET_MAPPER*/T0*r639internal_c_local_tag(T0*a1);
/*C_TARGET_MAPPER*/void r639visit_compound_expression(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639set_internal_c_local_tag(T0*a1,T0*a2);
/*C_TARGET_MAPPER*/void r639visit_dynamic_dispatch_temporary1_id(T639*C,T0*a1);
/*C_TARGET_MAPPER*/T0*r639pending_c_function_counter_tag_key(void);
/*C_TARGET_MAPPER*/void r639visit_old_manifest_array(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_call_infix_gt(T639*C,T0*a1);
/*C_TARGET_MAPPER*/T0*r639pending_c_function_counter_tag_values(void);
/*C_TARGET_MAPPER*/void r639_inline_agent27(T0*a1);
/*C_TARGET_MAPPER*/void r639_inline_agent26(T0*a1,T0*a2,T2 a3);
/*C_TARGET_MAPPER*/void r639compile_expression(T639*C,T0*a1);
/*C_TARGET_MAPPER*/T0*r639internal_c_local_tag_key(void);
/*C_TARGET_MAPPER*/void r639visit_call_infix_le(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_call_prefix_not(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639manifest_generic(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_call_infix_lt(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_implicit_current(T0*a1);
/*C_TARGET_MAPPER*/T0*r639cpp(void);
/*C_TARGET_MAPPER*/void r639args_compile_to_c(T639*C,T0*a1,T0*a2);
/*C_TARGET_MAPPER*/void r639visit_ifthen_exp(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_ifthenelse_exp(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_real_constant(T0*a1);
/*C_TARGET_MAPPER*/void r639visit_agent_creation(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_static_call_0_c(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_no_dispatch(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_character_constant(T0*a1);
/*C_TARGET_MAPPER*/void r639visit_dynamic_dispatch_temporary1(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_null_pointer(T0*a1);
/*C_TARGET_MAPPER*/void r639visit_dynamic_dispatch_temporary2(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_e_true(T0*a1);
/*C_TARGET_MAPPER*/void r639crash(T639*C);
/*C_TARGET_MAPPER*/void r639visit_natural_constant(T0*a1);
/*C_TARGET_MAPPER*/void r639compile_(T639*C,T0*a1,T0*a2);
/*C_TARGET_MAPPER*/void r639visit_assignment_test(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639create_expression_support(T639*C,T0*a1,T0*a2);
/*C_TARGET_MAPPER*/void r639visit_written_current(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639compile(T639*C,T0*a1,T0*a2,T0*a3);
/*C_TARGET_MAPPER*/void r639visit_expression_with_comment(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_assertion(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_manifest_string(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639for_all_arguments__(T0*a1,T0*a2,T0*a3,T2 a4);
/*C_TARGET_MAPPER*/void r639c2c_cast_op(T639*C,T0*a1,T0*a2,T0*a3);
/*C_TARGET_MAPPER*/void r639visit_non_void_no_dispatch(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_manifest_tuple(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_closed_operand(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639cmp_user_expanded(T639*C,T0*a1,T0*a2);
/*C_TARGET_MAPPER*/T2 r639pending_c_function_counter_tag(T0*a1);
/*C_TARGET_MAPPER*/void r639manifest_generic_args(T639*C,T0*a1,T2 a2,T2 a3);
/*C_TARGET_MAPPER*/void r639for_all_local_names(T0*a1,T0*a2,T0*a3);
/*C_TARGET_MAPPER*/void r639visit_create_writable(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639standard_mapping_c_target(T639*C,T0*a1,T6 a2);
/*C_TARGET_MAPPER*/void r639visit_writable_attribute_name(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_internal_local2(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_address_of(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_fake_argument(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_e_void(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639compile_character(T3 a1);
/*C_TARGET_MAPPER*/void r639visit_loop_variant(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639cmp_expanded_with_void(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639visit_manifest_generic(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639compile_arg(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639cmp_reference(T639*C,T0*a1,T0*a2,T0*a3);
/*C_TARGET_MAPPER*/void r639visit_built_in_eq_neq(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639cmp_basic_eiffel_expanded(T639*C,T0*a1,T0*a2,T0*a3);
/*C_TARGET_MAPPER*/void r639_P_640_compile_feature_call(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639_P_640_visit_native_array_item(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639_P_640_visit_no_dispatch(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639_P_640_visit_assignment_test(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639_P_640_visit_manifest_string(T0*a1);
/*C_TARGET_MAPPER*/void r639_P_640_visit_non_void_no_dispatch(T0*a1);
/*C_TARGET_MAPPER*/void r639_P_640_visit_manifest_tuple(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639_P_640_visit_internal_local2(T639*C,T0*a1);
/*C_TARGET_MAPPER*/void r639_P_640_visit_manifest_generic(T639*C,T0*a1);
typedef struct _se_agenT641f640l132c33 se_agenT641f640l132c33;
struct _se_agenT641f640l132c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT641f640l132c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a2;
};
/*agent creation*/T0*agenT641f640l132c33(T0*closed_C,T0*closed_a2);
typedef struct _se_agenT641f640l152c30 se_agenT641f640l152c30;
struct _se_agenT641f640l152c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT641f640l152c30*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT641f640l152c30(void);
/*C_ARG_MAPPER*/void r641not_yet_implemented(T641*C);
/*C_ARG_MAPPER*/void r641_inline_agent27(T0*a1);
/*C_ARG_MAPPER*/void r641_inline_agent26(T0*a1,T0*a2,T2 a3);
/*C_ARG_MAPPER*/void r641visit_e_void(T0*a1);
/*C_ARG_MAPPER*/void r641compile_code(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_old_manifest_array(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641compile_feature_call(T641*C,T0*a1);
/*C_ARG_MAPPER*/T0*r641cpp(void);
/*C_ARG_MAPPER*/void r641visit_manifest_generic(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_fake_target(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_real_constant(T0*a1);
/*C_ARG_MAPPER*/void r641visit_no_dispatch(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_ifthenelse_exp(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_local_name_ref(T0*a1);
/*C_ARG_MAPPER*/T0*r641pending_c_function_counter_tag_values(void);
/*C_ARG_MAPPER*/void r641visit_natural_constant(T0*a1);
/*C_ARG_MAPPER*/void r641visit_address_of(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_create_writable(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_e_false(T0*a1);
/*C_ARG_MAPPER*/void r641visit_manifest_string(T0*a1);
/*C_ARG_MAPPER*/void r641visit_writable_attribute_name(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_call_prefix_not(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641compile_arg(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_assignment_test(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_implicit_cast(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_internal_local2(T641*C,T0*a1);
/*C_ARG_MAPPER*/T2 r641pending_c_function_counter_tag(T0*a1);
/*C_ARG_MAPPER*/void r641open_operand_name_in(T0*a1,T0*a2);
/*C_ARG_MAPPER*/void r641compile_expression(T641*C,T0*a1);
/*C_ARG_MAPPER*/T0*r641pending_c_function_counter_tag_key(void);
/*C_ARG_MAPPER*/void r641visit_create_expression(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_e_true(T0*a1);
/*C_ARG_MAPPER*/void r641compile_precursor(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641set_internal_c_local_tag(T0*a1,T0*a2);
/*C_ARG_MAPPER*/void r641manifest_generic(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641cmp_expanded_with_void(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_built_in_eq_neq(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641rank_name_in(T2 a1,T0*a2,T0*a3);
/*C_ARG_MAPPER*/void r641visit_result(T0*a1);
/*C_ARG_MAPPER*/void r641set_pending_c_function_counter_tag(T0*a1);
/*C_ARG_MAPPER*/void r641visit_dynamic_dispatch_temporary1(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641cmp_user_expanded(T641*C,T0*a1,T0*a2);
/*C_ARG_MAPPER*/void r641visit_dynamic_dispatch_temporary2(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_manifest_tuple(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641for_all_locals__(T0*a1,T0*a2,T0*a3);
/*C_ARG_MAPPER*/void r641compile_character(T3 a1);
/*C_ARG_MAPPER*/void r641visit_fake_tuple(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641create_expression_support(T641*C,T0*a1,T0*a2);
/*C_ARG_MAPPER*/void r641visit_character_constant(T0*a1);
/*C_ARG_MAPPER*/void r641visit_integer_constant(T0*a1);
/*C_ARG_MAPPER*/void r641visit_closed_operand(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_abstract_current(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641for_all_argument_names(T0*a1,T0*a2,T0*a3);
/*C_ARG_MAPPER*/void r641visit_void_call(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_generator_generating_type(T0*a1);
/*C_ARG_MAPPER*/void r641args_compile_to_c(T641*C,T0*a1,T0*a2);
/*C_ARG_MAPPER*/void r641visit_null_pointer(T0*a1);
/*C_ARG_MAPPER*/void r641visit_native_array_item(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_e_old(T0*a1);
/*C_ARG_MAPPER*/void r641visit_non_void_no_dispatch(T0*a1);
/*C_ARG_MAPPER*/void r641visit_agent_creation(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_dynamic_dispatch_temporary1_id(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641crash(T641*C);
/*C_ARG_MAPPER*/void r641for_all_arguments__(T0*a1,T0*a2,T0*a3,T2 a4);
/*C_ARG_MAPPER*/void r641for_all_local_names(T0*a1,T0*a2,T0*a3);
/*C_ARG_MAPPER*/void r641visit_assertion(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_argument_name_ref(T0*a1);
/*C_ARG_MAPPER*/void r641compile(T641*C,T0*a1,T0*a2);
/*C_ARG_MAPPER*/void r641compile_agent_definition_call(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_call_infix_ge(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_compound_expression(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641compile_agent_void_call(T641*C,T0*a1,T351 a2,T0*a3);
/*C_ARG_MAPPER*/void r641visit_agent_expression(T641*C,T0*a1);
/*C_ARG_MAPPER*/T0*r641internal_c_local_tag(T0*a1);
/*C_ARG_MAPPER*/T0*r641internal_c_local_tag_key(void);
/*C_ARG_MAPPER*/void r641visit_call_infix_gt(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_open_operand(T0*a1);
/*C_ARG_MAPPER*/void r641closed_operand_name_in(T0*a1,T0*a2);
/*C_ARG_MAPPER*/void r641visit_call_infix_le(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_loop_variant(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641c2c_cast_op(T641*C,T0*a1,T0*a2,T0*a3);
/*C_ARG_MAPPER*/void r641visit_static_call_0_c(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_fake_argument(T0*a1);
/*C_ARG_MAPPER*/void r641cmp_reference(T641*C,T0*a1,T0*a2,T0*a3);
/*C_ARG_MAPPER*/void r641visit_call_infix_lt(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641manifest_generic_args(T641*C,T0*a1,T2 a2,T2 a3);
/*C_ARG_MAPPER*/void r641visit_expression_with_comment(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641visit_ifthen_exp(T641*C,T0*a1);
/*C_ARG_MAPPER*/void r641cmp_basic_eiffel_expanded(T641*C,T0*a1,T0*a2,T0*a3);
typedef struct _se_agenT642f642l80c35 se_agenT642f642l80c35;
struct _se_agenT642f642l80c35{Tid id;
int creation_mold_id;
void(*afp)(se_agenT642f642l80c35*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT642f642l80c35(T0*closed_C);
typedef struct _se_agenT642f642l1106c37 se_agenT642f642l1106c37;
struct _se_agenT642f642l1106c37{Tid id;
int creation_mold_id;
void(*afp)(se_agenT642f642l1106c37*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT642f642l1106c37(T0*closed_C);
typedef struct _se_agenT642f642l61c35 se_agenT642f642l61c35;
struct _se_agenT642f642l61c35{Tid id;
int creation_mold_id;
void(*afp)(se_agenT642f642l61c35*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT642f642l61c35(T0*closed_C);
typedef struct _se_agenT642f642l1081c39 se_agenT642f642l1081c39;
struct _se_agenT642f642l1081c39{Tid id;
int creation_mold_id;
void(*afp)(se_agenT642f642l1081c39*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT642f642l1081c39(T0*closed_C);
typedef struct _se_agenT642f642l1089c34 se_agenT642f642l1089c34;
struct _se_agenT642f642l1089c34{Tid id;
int creation_mold_id;
void(*afp)(se_agenT642f642l1089c34*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT642f642l1089c34(T0*closed_C);
typedef struct _se_agenT642f642l1036c37 se_agenT642f642l1036c37;
struct _se_agenT642f642l1036c37{Tid id;
int creation_mold_id;
void(*afp)(se_agenT642f642l1036c37*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT642f642l1036c37(T0*closed_C);
typedef struct _se_agenT642f640l132c33 se_agenT642f640l132c33;
struct _se_agenT642f640l132c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT642f640l132c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a2;
};
/*agent creation*/T0*agenT642f640l132c33(T0*closed_C,T0*closed_a2);
typedef struct _se_agenT642f640l152c30 se_agenT642f640l152c30;
struct _se_agenT642f640l152c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT642f640l152c30*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT642f640l152c30(void);
/*C_CODE_COMPILER*/void r642compile_as_require_n(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_compound(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642not_yet_implemented(T642*C);
/*C_CODE_COMPILER*/void r642visit_check_compound(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_inspect_as_switch(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642_inline_agent27(T0*a1);
/*C_CODE_COMPILER*/void r642_inline_agent26(T0*a1,T0*a2,T2 a3);
/*C_CODE_COMPILER*/void r642visit_e_void(T0*a1);
/*C_CODE_COMPILER*/void r642compile_code(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_old_manifest_array(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_class_invariant(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_inspect_statement(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_as_check_compound(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_feature_call(T642*C,T0*a1);
/*C_CODE_COMPILER*/T0*r642cpp(void);
/*C_CODE_COMPILER*/void r642visit_manifest_generic(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_run_time_error_instruction(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_assertion(T642*C,T0*a1,T0*a2);
/*C_CODE_COMPILER*/void r642visit_fake_target(T0*a1);
/*C_CODE_COMPILER*/void r642visit_real_constant(T0*a1);
/*C_CODE_COMPILER*/void r642visit_no_dispatch(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_ifthenelse_exp(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_local_name_ref(T0*a1);
/*C_CODE_COMPILER*/void r642compile_as_require_1(T642*C,T0*a1);
/*C_CODE_COMPILER*/T0*r642pending_c_function_counter_tag_values(void);
/*C_CODE_COMPILER*/void r642visit_natural_constant(T0*a1);
/*C_CODE_COMPILER*/void r642visit_address_of(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_create_writable(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_inspect_as_ifthenelse(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_assertion_list(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_retry_instruction(T0*a1);
/*C_CODE_COMPILER*/void r642visit_e_false(T0*a1);
/*C_CODE_COMPILER*/void r642visit_manifest_string(T0*a1);
/*C_CODE_COMPILER*/void r642visit_writable_attribute_name(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_c_inline(T0*a1);
/*C_CODE_COMPILER*/void r642visit_call_prefix_not(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_arg(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_assignment_test(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_implicit_cast(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_no_invariant_wrapper(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_internal_local2(T642*C,T0*a1);
/*C_CODE_COMPILER*/T2 r642pending_c_function_counter_tag(T0*a1);
/*C_CODE_COMPILER*/void r642open_operand_name_in(T0*a1,T0*a2);
/*C_CODE_COMPILER*/void r642visit_ensure_assertion(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_expression(T642*C,T0*a1);
/*C_CODE_COMPILER*/T0*r642pending_c_function_counter_tag_key(void);
/*C_CODE_COMPILER*/void r642visit_create_expression(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_e_true(T0*a1);
/*C_CODE_COMPILER*/void r642compile_precursor(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642set_internal_c_local_tag(T0*a1,T0*a2);
/*C_CODE_COMPILER*/void r642manifest_generic(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642unlock_internal_c_local_tag(T0*a1);
/*C_CODE_COMPILER*/void r642visit_when_clause(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642cmp_expanded_with_void(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_sedb(T0*a1);
/*C_CODE_COMPILER*/void r642visit_built_in_eq_neq(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642rank_name_in(T2 a1,T0*a2,T0*a3);
/*C_CODE_COMPILER*/void r642compile_assertion_as_require_n(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_when_clause_as_switch(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642put_start_position(T0*a1);
/*C_CODE_COMPILER*/void r642visit_result(T0*a1);
/*C_CODE_COMPILER*/void r642set_pending_c_function_counter_tag(T0*a1);
/*C_CODE_COMPILER*/void r642visit_dynamic_dispatch_temporary1(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642cmp_user_expanded(T642*C,T0*a1,T0*a2);
/*C_CODE_COMPILER*/void r642visit_dynamic_dispatch_temporary2(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_manifest_tuple(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642for_all_locals__(T0*a1,T0*a2,T0*a3);
/*C_CODE_COMPILER*/void r642compile_character(T3 a1);
/*C_CODE_COMPILER*/void r642compile_as_require(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_fake_tuple(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_debug_compound(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642create_expression_support(T642*C,T0*a1,T0*a2);
/*C_CODE_COMPILER*/void r642visit_character_constant(T0*a1);
/*C_CODE_COMPILER*/void r642visit_integer_constant(T0*a1);
/*C_CODE_COMPILER*/void r642visit_closed_operand(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_agent_instruction(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_abstract_current(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642for_all_argument_names(T0*a1,T0*a2,T0*a3);
/*C_CODE_COMPILER*/void r642visit_void_call(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_code_as_expression(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_generator_generating_type(T0*a1);
/*C_CODE_COMPILER*/void r642args_compile_to_c(T642*C,T0*a1,T0*a2);
/*C_CODE_COMPILER*/void r642put_c_field_name(T0*a1);
/*C_CODE_COMPILER*/void r642visit_unused_expression(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_null_pointer(T0*a1);
/*C_CODE_COMPILER*/void r642visit_native_array_item(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_e_old(T0*a1);
/*C_CODE_COMPILER*/void r642visit_non_void_no_dispatch(T0*a1);
/*C_CODE_COMPILER*/void r642visit_agent_creation(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_dynamic_dispatch_temporary1_id(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642crash(T642*C);
/*C_CODE_COMPILER*/void r642for_all_arguments__(T0*a1,T0*a2,T0*a3,T2 a4);
/*C_CODE_COMPILER*/void r642visit_ifthenelse(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642for_all_local_names(T0*a1,T0*a2,T0*a3);
/*C_CODE_COMPILER*/void r642visit_create_instruction(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_assertion(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_manifest_string_inspector(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_loop_instruction(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_argument_name_ref(T0*a1);
/*C_CODE_COMPILER*/void r642compile(T642*C,T0*a1,T0*a2);
/*C_CODE_COMPILER*/void r642visit_ifthen(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_agent_definition_call(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_require_assertion(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_call_infix_ge(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_compound_expression(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642compile_agent_void_call(T642*C,T0*a1,T351 a2,T0*a3);
/*C_CODE_COMPILER*/void r642visit_agent_expression(T642*C,T0*a1);
/*C_CODE_COMPILER*/T0*r642internal_c_local_tag(T0*a1);
/*C_CODE_COMPILER*/T0*r642internal_c_local_tag_key(void);
/*C_CODE_COMPILER*/void r642compile_as_loop_invariant(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_call_infix_gt(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_open_operand(T0*a1);
/*C_CODE_COMPILER*/void r642closed_operand_name_in(T0*a1,T0*a2);
/*C_CODE_COMPILER*/void r642visit_void_proc_call(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_call_infix_le(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_loop_variant(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642c2c_cast_op(T642*C,T0*a1,T0*a2,T0*a3);
/*C_CODE_COMPILER*/void r642visit_assignment_attempt(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_static_call_0_c(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_fake_argument(T0*a1);
/*C_CODE_COMPILER*/void r642cmp_reference(T642*C,T0*a1,T0*a2,T0*a3);
/*C_CODE_COMPILER*/void r642visit_call_infix_lt(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642manifest_generic_args(T642*C,T0*a1,T2 a2,T2 a3);
/*C_CODE_COMPILER*/void r642visit_expression_with_comment(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_ifthen_exp(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642visit_assignment(T642*C,T0*a1);
/*C_CODE_COMPILER*/void r642cmp_basic_eiffel_expanded(T642*C,T0*a1,T0*a2,T0*a3);
/*C_CODE_COMPILER*/void r642visit_raw_create_instruction(T642*C,T0*a1);
typedef struct _se_agenT646f640l132c33 se_agenT646f640l132c33;
struct _se_agenT646f640l132c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT646f640l132c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a2;
};
/*agent creation*/T0*agenT646f640l132c33(T0*closed_C,T0*closed_a2);
typedef struct _se_agenT646f640l152c30 se_agenT646f640l152c30;
struct _se_agenT646f640l152c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT646f640l152c30*,T0*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT646f640l152c30(void);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_or(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_inline_agent27(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_inline_agent26(T0*a1,T0*a2,T2 a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_e_void(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_code(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_old_manifest_array(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_function_call_0(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_function_call_1(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_(T646*C,T0*a1,T0*a2);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_feature_call(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/T0*r646cpp(void);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_manifest_generic(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_fake_target(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_real_constant(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_no_dispatch(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_ifthenelse_exp(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_local_name_ref(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_and_then(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/T0*r646pending_c_function_counter_tag_values(void);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_natural_constant(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_address_of(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_create_writable(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_function_call_n(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_xor(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_e_false(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_manifest_string(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_writable_attribute_name(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_prefix_not(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_arg(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_assignment_test(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_implicit_cast(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_internal_local2(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/T2 r646pending_c_function_counter_tag(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_expression_(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646open_operand_name_in(T0*a1,T0*a2);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_expression(T646*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*C_COMPOUND_EXPRESSION_COMPILER*/T0*r646pending_c_function_counter_tag_key(void);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_create_expression(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_e_true(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_precursor(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646set_internal_c_local_tag(T0*a1,T0*a2);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646manifest_generic(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646cmp_expanded_with_void(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_built_in_eq_neq(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_plus(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_prefix_freeop(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646rank_name_in(T2 a1,T0*a2,T0*a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_result(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646set_pending_c_function_counter_tag(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_dynamic_dispatch_temporary1(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646cmp_user_expanded(T646*C,T0*a1,T0*a2);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_dynamic_dispatch_temporary2(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_manifest_tuple(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646for_all_locals__(T0*a1,T0*a2,T0*a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_character(T3 a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646do_compile(T646*C,T0*a1,T0*a2,T6 a3,T0*a4,T0*a5);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_fake_tuple(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646create_expression_support(T646*C,T0*a1,T0*a2);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_character_constant(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_integer_constant(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_closed_operand(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_abstract_current(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646for_all_argument_names(T0*a1,T0*a2,T0*a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_freeop(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_div(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_void_call(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_code_as_expression(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_prefix_minus(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_generator_generating_type(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646args_compile_to_c(T646*C,T0*a1,T0*a2);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646put_c_field_name(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_null_pointer(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_native_array_item(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_e_old(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_non_void_no_dispatch(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_agent_creation(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_dynamic_dispatch_temporary1_id(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_int_rem(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646crash(T646*C);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646for_all_arguments__(T0*a1,T0*a2,T0*a3,T2 a4);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_power(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646for_all_local_names(T0*a1,T0*a2,T0*a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_assertion(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_and(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_argument_name_ref(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile(T646*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_or_else(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_minus(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_agent_definition_call(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_implies(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_times(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_int_div(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_ge(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_compound_expression(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646compile_agent_void_call(T646*C,T0*a1,T351 a2,T0*a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_agent_expression(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/T0*r646internal_c_local_tag(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/T0*r646internal_c_local_tag_key(void);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_gt(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_open_operand(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646closed_operand_name_in(T0*a1,T0*a2);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_le(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_loop_variant(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646c2c_cast_op(T646*C,T0*a1,T0*a2,T0*a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_prefix_plus(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_static_call_0_c(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_fake_argument(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646cmp_reference(T646*C,T0*a1,T0*a2,T0*a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_call_infix_lt(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_precursor_expression(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646manifest_generic_args(T646*C,T0*a1,T2 a2,T2 a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_expression_with_comment(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646visit_ifthen_exp(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646cmp_basic_eiffel_expanded(T646*C,T0*a1,T0*a2,T0*a3);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_or(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_e_void(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_old_manifest_array(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_function_call_0(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_function_call_1(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_manifest_generic(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_fake_target(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_real_constant(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_no_dispatch(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_ifthenelse_exp(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_local_name_ref(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_and_then(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_natural_constant(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_address_of(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_create_writable(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_function_call_n(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_xor(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_e_false(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_manifest_string(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_writable_attribute_name(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_prefix_not(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_assignment_test(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_implicit_cast(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_internal_local2(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_create_expression(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_e_true(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_built_in_eq_neq(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_plus(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_prefix_freeop(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_result(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_dynamic_dispatch_temporary1(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_dynamic_dispatch_temporary2(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_manifest_tuple(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_fake_tuple(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_character_constant(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_integer_constant(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_closed_operand(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_abstract_current(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_freeop(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_div(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_void_call(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_prefix_minus(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_generator_generating_type(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_null_pointer(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_native_array_item(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_e_old(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_non_void_no_dispatch(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_agent_creation(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_dynamic_dispatch_temporary1_id(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_int_rem(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_power(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_assertion(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_and(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_argument_name_ref(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_or_else(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_minus(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_implies(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_times(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_int_div(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_ge(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_agent_expression(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_gt(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_open_operand(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_le(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_loop_variant(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_prefix_plus(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_static_call_0_c(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_fake_argument(T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_call_infix_lt(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_precursor_expression(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_expression_with_comment(T646*C,T0*a1);
/*C_COMPOUND_EXPRESSION_COMPILER*/void r646_P_640_visit_ifthen_exp(T646*C,T0*a1);
typedef struct _se_agenT647f647l691c61 se_agenT647f647l691c61;
struct _se_agenT647f647l691c61{Tid id;
int creation_mold_id;
void(*afp)(se_agenT647f647l691c61*);
int (*eq)(se_agent*,se_agent*);
};
/*agent creation*/T0*agenT647f647l691c61(void);
typedef struct _se_agenT647f647l707c61 se_agenT647f647l707c61;
struct _se_agenT647f647l707c61{Tid id;
int creation_mold_id;
void(*afp)(se_agenT647f647l707c61*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
};
/*agent creation*/T0*agenT647f647l707c61(T0*closed_C);
extern T0*oBC32capacity_name;
extern int fBC32capacity_name;
/*C_NATIVE_FUNCTION_MAPPER*/T0*r647capacity_name(void);
/*C_NATIVE_FUNCTION_MAPPER*/void r647c_mapping_native_array_function(T647*C);
/*C_NATIVE_FUNCTION_MAPPER*/T6 r647expanded_initializer(T0*a1);
/*C_NATIVE_FUNCTION_MAPPER*/void r647not_yet_implemented(T647*C);
/*C_NATIVE_FUNCTION_MAPPER*/void r647visit_native_plug_in(T647*C,T0*a1);
/*C_NATIVE_FUNCTION_MAPPER*/T0*r647cpp(void);
/*C_NATIVE_FUNCTION_MAPPER*/void r647c_deep_twin_body(T0*a1);
/*C_NATIVE_FUNCTION_MAPPER*/void r647visit_native_built_in(T647*C,T0*a1);
/*C_NATIVE_FUNCTION_MAPPER*/void r647c_modular_computation(T2 a1,T3 a2);
/*C_NATIVE_FUNCTION_MAPPER*/void r647extra_c_prototype_in_cpp_out_h_buffer(T351 a1,T0*a2,T0*a3);
/*C_NATIVE_FUNCTION_MAPPER*/void r647c_mapping_standard_twin(T647*C);
/*C_NATIVE_FUNCTION_MAPPER*/void r647c_mapping_integer_function(T647*C);
/*C_NATIVE_FUNCTION_MAPPER*/void r647c_field_access(T0*a1,T0*a2,T0*a3);
/*C_NATIVE_FUNCTION_MAPPER*/void r647is_deep_equal_c_code(T0*a1);
/*C_NATIVE_FUNCTION_MAPPER*/T0*r647echo(void);
/*C_NATIVE_FUNCTION_MAPPER*/T0*r647system_tools(void);
/*C_NATIVE_FUNCTION_MAPPER*/void r647crash(T647*C);
/*C_NATIVE_FUNCTION_MAPPER*/void r647c_mapping_natural_function(T647*C);
/*C_NATIVE_FUNCTION_MAPPER*/void r647extra_c_prototype(T351 a1,T0*a2,T0*a3);
/*C_NATIVE_FUNCTION_MAPPER*/void r647mapping_plug_in(T0*a1,T0*a2);
/*C_NATIVE_FUNCTION_MAPPER*/void r647compile(T647*C,T0*a1);
/*C_NATIVE_FUNCTION_MAPPER*/void r647visit_native_c_plus_plus(T647*C,T0*a1);
/*C_NATIVE_FUNCTION_MAPPER*/void r647c_mapping_real(T647*C);
/*C_NATIVE_FUNCTION_MAPPER*/void r647visit_native_c(T647*C,T0*a1);
/*C_NATIVE_FUNCTION_MAPPER*/void r647wrapped_external_call_in(T0*a1,T0*a2,T0*a3,T2 a4);
/*C_NATIVE_FUNCTION_MAPPER*/T0*r647error_handler(void);
/*C_NATIVE_FUNCTION_MAPPER*/void r647mapping_c(T0*a1,T0*a2,T6 a3,T6 a4,T2 a5);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648c_mapping_integer_procedure(T648*C);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648not_yet_implemented(T648*C);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648visit_native_built_in(T648*C,T0*a1);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648mapping_plug_in(T0*a1,T0*a2);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648extra_c_prototype_in_cpp_out_h_buffer(T351 a1,T0*a2,T0*a3);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648extra_c_prototype(T351 a1,T0*a2,T0*a3);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648visit_native_c_plus_plus(T648*C,T0*a1);
/*C_NATIVE_PROCEDURE_MAPPER*/T0*r648cpp(void);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648mapping_c(T0*a1,T0*a2,T6 a3,T6 a4,T2 a5);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648visit_native_c(T648*C,T0*a1);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648c_mapping_thread_lock_proc(T648*C);
/*C_NATIVE_PROCEDURE_MAPPER*/T0*r648echo(void);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648crash(T648*C);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648visit_native_plug_in(T648*C,T0*a1);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648compile(T648*C,T0*a1);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648c_mapping_native_array_procedure(T648*C);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648c_mapping_thread_context_proc(T648*C);
/*C_NATIVE_PROCEDURE_MAPPER*/T0*r648error_handler(void);
/*C_NATIVE_PROCEDURE_MAPPER*/void r648wrapped_external_call_in(T0*a1,T0*a2,T0*a3,T2 a4);
/*C_NATIVE_C_DEFINITION*/void r649make(T649*C);
/*C_NATIVE_C_DEFINITION*/void r649c_plus_plus_procedure_definition(T649*C,T0*a1);
/*C_NATIVE_C_DEFINITION*/T0*r649cpp(void);
/*C_NATIVE_C_DEFINITION*/void r649compile(T649*C,T0*a1,T0*a2);
/*C_NATIVE_C_DEFINITION*/void r649extra_c_prototype_in_cpp_out_h_buffer(T351 a1,T0*a2,T0*a3);
/*C_NATIVE_C_DEFINITION*/void r649visit_native_c_plus_plus(T649*C,T0*a1);
/*C_NATIVE_C_DEFINITION*/void r649c_plus_plus_function_definition(T649*C,T0*a1);
/*C_INTROSPECTION_FUNCTION*/void r650put_c_field_name(T0*a1);
/*C_INTROSPECTION_FUNCTION*/T0*r650c_pointer_to_type(T0*a1);
/*C_INTROSPECTION_FUNCTION*/void r650mapping_c_inside_introspect(T0*a1);
/*C_INTROSPECTION_FUNCTION*/T0*r650cpp(void);
/*C_INTROSPECTION_FUNCTION*/void r650compile(T650*C,T0*a1);
/*C_INTROSPECTION_FUNCTION*/void r650c_return_introspect(T0*a1,T0*a2,T0*a3);
/*C_INTROSPECTION_FUNCTION*/void r650visit_live_type(T650*C,T0*a1);
/*C_INTROSPECTION_FUNCTION*/void r650visit_run_feature_2(T650*C,T0*a1);
/*C_INTROSPECTION_FUNCTION*/void r650visit_run_feature_6(T650*C,T0*a1);
/*C_INTROSPECTION_DISPLAY*/T0*r651cpp(void);
/*C_INTROSPECTION_DISPLAY*/void r651compile(T651*C,T0*a1);
/*C_INTROSPECTION_DISPLAY*/void r651visit_live_type(T651*C,T0*a1);
/*C_INTROSPECTION_DISPLAY*/void r651visit_run_feature_2(T651*C,T0*a1);
/*C_INTROSPECTION_DISPLAY*/void r651visit_run_feature_6(T651*C,T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_string_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_like_feature_type_mark(T652*C,T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_real_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/T0*r652for(T652*C,T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_native_array_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_natural_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_like_current_type_mark(T652*C,T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_weak_reference_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_like_argument_type_mark(T652*C,T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_user_generic_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_pointer_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_any_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_agent_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_character_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_formal_generic_type_mark(T652*C,T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_boolean_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_array_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652crash(T652*C);
/*C_TYPE_FOR_TARGET*/void r652visit_integer_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_class_type_mark(T0*a1);
/*C_TYPE_FOR_TARGET*/void r652visit_non_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_string_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_like_feature_type_mark(T654*C,T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_real_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/T0*r654for(T654*C,T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_native_array_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_natural_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_like_current_type_mark(T654*C,T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_weak_reference_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_like_argument_type_mark(T654*C,T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_user_generic_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_pointer_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_any_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_agent_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_character_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_formal_generic_type_mark(T654*C,T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_boolean_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_array_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654crash(T654*C);
/*C_TYPE_FOR_RESULT*/void r654visit_integer_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_class_type_mark(T0*a1);
/*C_TYPE_FOR_RESULT*/void r654visit_non_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_string_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_like_feature_type_mark(T655*C,T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_real_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/T0*r655for(T655*C,T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_native_array_type_mark(T655*C,T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_natural_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_like_current_type_mark(T655*C,T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_weak_reference_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_like_argument_type_mark(T655*C,T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_user_generic_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_pointer_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_any_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_agent_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_character_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_formal_generic_type_mark(T655*C,T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_boolean_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_array_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655crash(T655*C);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_integer_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_class_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/void r655visit_non_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_EXTERNAL*/T0*r655_P_653_for(T655*C,T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_string_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_like_feature_type_mark(T653*C,T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_real_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/T0*r653for(T653*C,T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_native_array_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_natural_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_like_current_type_mark(T653*C,T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_weak_reference_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_like_argument_type_mark(T653*C,T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_user_generic_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_pointer_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_any_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_agent_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_character_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_formal_generic_type_mark(T653*C,T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_boolean_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_array_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653crash(T653*C);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_integer_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_class_type_mark(T0*a1);
/*C_TYPE_FOR_ARGUMENT*/void r653visit_non_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_empty_tuple_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_string_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_like_feature_type_mark(T656*C,T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_real_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/T0*r656for(T656*C,T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_native_array_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_natural_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_like_current_type_mark(T656*C,T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_weak_reference_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_like_argument_type_mark(T656*C,T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_user_generic_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_pointer_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_any_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_agent_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_character_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_formal_generic_type_mark(T656*C,T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_boolean_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_array_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656crash(T656*C);
/*C_TYPE_FOR_VA_ARG*/void r656visit_integer_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_class_type_mark(T0*a1);
/*C_TYPE_FOR_VA_ARG*/void r656visit_non_empty_tuple_type_mark(T0*a1);
/*C_NEED_STRUCT*/void r657visit_empty_tuple_type_mark(T657*C,T0*a1);
/*C_NEED_STRUCT*/void r657visit_string_type_mark(T657*C,T0*a1);
/*C_NEED_STRUCT*/void r657visit_like_feature_type_mark(T657*C,T0*a1);
/*C_NEED_STRUCT*/T6 r657for(T657*C,T0*a1);
/*C_NEED_STRUCT*/void r657visit_like_current_type_mark(T657*C,T0*a1);
/*C_NEED_STRUCT*/void r657visit_weak_reference_type_mark(T657*C,T0*a1);
/*C_NEED_STRUCT*/void r657visit_like_argument_type_mark(T657*C,T0*a1);
/*C_NEED_STRUCT*/void r657set_flag_for(T657*C,T0*a1);
/*C_NEED_STRUCT*/T0*r657cpp(void);
/*C_NEED_STRUCT*/void r657visit_formal_generic_type_mark(T657*C,T0*a1);
/*C_NEED_STRUCT*/void r657visit_array_type_mark(T657*C,T0*a1);
/*C_NEED_STRUCT*/void r657crash(T657*C);
/*C_NEED_STRUCT*/void r657visit_non_empty_tuple_type_mark(T657*C,T0*a1);
/*C_NATIVE_NEED_WRAPPER*/void r658visit_native_c(T658*C,T0*a1);
/*C_NATIVE_NEED_WRAPPER*/T6 r658for(T658*C,T0*a1,T0*a2,T0*a3);
/*C_NATIVE_NEED_WRAPPER*/T6 r658expanded_initializer(T0*a1);
/*C_NATIVE_NEED_WRAPPER*/void r658visit_native_built_in(T658*C,T0*a1);
/*C_NATIVE_NEED_WRAPPER*/void r658visit_native_c_plus_plus(T658*C,T0*a1);
/*C_NATIVE_NEED_WRAPPER*/T6 r658for_rf7(T658*C,T0*a1);
/*C_NATIVE_NEED_WRAPPER*/T6 r658for_rf8(T658*C,T0*a1);
/*STATUS*/void r552echo_phase_information(T552*C,T0*a1,T2 a2);
/*STATUS*/void r552make(T552*C);
/*STATUS*/void r552push_phase(T552*C,T2 a1);
/*STATUS*/void r552pop_phase(T552*C);
/*STATUS*/T0*r552echo(void);
/*STATUS*/void r552end_specializing_and_checking(T552*C,T0*a1);
/*STATUS*/void r552set_collecting(T552*C);
/*STATUS*/void r552set_inlining_dynamic_dispatch(T552*C);
/*STATUS*/void r552echo_information(T552*C);
/*STATUS*/void r552set_phase_(T552*C,T2 a1);
/*STATUS*/void r552start_specializing(T552*C,T0*a1);
/*STATUS*/T0*r552error_handler(void);
/*STATUS*/void r552start_specializing_and_checking(T552*C,T0*a1);
extern T0*oBC552internal_phase_stack;
extern int fBC552internal_phase_stack;
/*STATUS*/T0*r552internal_phase_stack(void);
/*STATUS*/void r552end_specializing(T552*C,T0*a1);
/*CLASS_TEXT*/void r97id_extra_information(T97*C,T0*a1);
/*CLASS_TEXT*/void r97create_parent_lists_using(T97*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*CLASS_TEXT*/T0*r97proper_name_get(T97*C,T0*a1);
/*CLASS_TEXT*/T0*r97declaration_type_of_like_current(T97*C);
extern T0*oBC97fn_buffer;
extern int fBC97fn_buffer;
/*CLASS_TEXT*/T0*r97fn_buffer(void);
/*CLASS_TEXT*/T6 r97has_creation_check(T97*C,T0*a1,T351 a2,T0*a3,T0*a4);
/*CLASS_TEXT*/T0*r97next_tuple(T97*C);
/*CLASS_TEXT*/T0*r97constraints_generic_list(T97*C);
/*CLASS_TEXT*/void r97add_creation_clause(T97*C,T0*a1);
/*CLASS_TEXT*/void r97set_invariant(T97*C,T351 a1,T0*a2,T0*a3);
extern T0*oBC32default_create_name;
extern int fBC32default_create_name;
/*CLASS_TEXT*/T0*r97default_create_name(void);
/*CLASS_TEXT*/T6 r97all_check(T97*C);
/*CLASS_TEXT*/void r97set_is_expanded(T97*C);
/*CLASS_TEXT*/T0*r97default_root_procedure_name(T97*C);
/*CLASS_TEXT*/void r97fatal_error_when_no_creation_clause(T97*C);
/*CLASS_TEXT*/void r97fatal_undefine(T97*C,T0*a1);
/*CLASS_TEXT*/T0*r97any_twin_feature(T97*C);
/*CLASS_TEXT*/T0*r97any_is_equal_feature(T97*C);
/*CLASS_TEXT*/T0*r97proper_get(T97*C,T0*a1);
/*CLASS_TEXT*/T6 r97proper_has(T97*C,T0*a1);
/*CLASS_TEXT*/T0*r97declaration_type_of_like_current_(T97*C,T351 a1);
/*CLASS_TEXT*/T1 r97insert_inherit_test(T97*C,T0*a1);
/*CLASS_TEXT*/T6 r97require_check(T97*C);
/*CLASS_TEXT*/void r97set_is_deferred(T97*C);
/*CLASS_TEXT*/void r97set_tag(T97*C,T0*a1,T0*a2);
/*CLASS_TEXT*/void r97formal_generic_list_count_check(T97*C,T351 a1,T0*a2);
/*CLASS_TEXT*/T0*r97any_copy_feature(T97*C);
/*CLASS_TEXT*/T6 r97inherits_from(T97*C,T0*a1);
/*CLASS_TEXT*/T0*r97user_expanded_default_create_stamp(T97*C,T0*a1);
/*CLASS_TEXT*/void r97initialize_and_check_level_1(T97*C);
/*CLASS_TEXT*/T0*r97root_creation_search(T97*C,T0*a1);
/*CLASS_TEXT*/T6 r97loop_check(T97*C);
/*CLASS_TEXT*/T0*r97level_name(T2 a1);
/*CLASS_TEXT*/void r97finish_create(T97*C);
/*CLASS_TEXT*/void r97extra_expanded_check(T97*C,T0*a1);
/*CLASS_TEXT*/T6 r97ensure_check(T97*C);
/*CLASS_TEXT*/void r97add_feature_clause(T97*C,T0*a1);
/*CLASS_TEXT*/T6 r97obvious_resolve_static_binding(T97*C,T0*a1,T6 a2);
/*CLASS_TEXT*/void r97check_level_2(T97*C,T0*a1);
/*CLASS_TEXT*/T0*r97non_written(T97*C,T0*a1,T0*a2);
/*CLASS_TEXT*/T0*r97id_provider(void);
/*CLASS_TEXT*/void r97make(T97*C,T0*a1,T0*a2,T0*a3,T10 a4);
/*CLASS_TEXT*/T6 r97invariant_check(T97*C);
/*CLASS_TEXT*/void r97creation_list_check(T97*C,T0*a1);
/*CLASS_TEXT*/void r97add_index_clause(T97*C,T0*a1);
/*CLASS_TEXT*/void r97error_vtec1(T97*C);
extern T0*oBC32any_default_create_fs;
extern int fBC32any_default_create_fs;
/*CLASS_TEXT*/T0*r97any_default_create_fs(void);
/*CLASS_TEXT*/void r97obsolete_warning_check(T97*C,T351 a1);
/*CLASS_TEXT*/T0*r97error_handler(void);
/*CLASS_TEXT*/T0*r97tag(T97*C,T0*a1);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_attribute_generating_type(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_na_type_item_generator(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_na_object_attribute(T91*C);
/*INTROSPECTION_HANDLER*/T6 r91is_introspectable_static_type(T0*a1);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_typed_internals(T91*C,T0*a1,T0*a2);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_valid_generating_type_for_na_internals(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_na_set_object_attribute(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_object_attribute(T91*C);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_internals_handler(T91*C,T0*a1,T0*a2,T0*a3);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_na_internals_from_generating_type(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_na_type_can_be_assigned_to_item(T91*C);
/*INTROSPECTION_HANDLER*/T0*r91create_blank_internals_instruction_for(T91*C,T0*a1);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_na_type_item_is_expanded(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_attribute_count(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_na_type_item_generating_type(T91*C);
/*INTROSPECTION_HANDLER*/void r91collect_internals_from_generating_type(T91*C,T0*a1,T351 a2,T0*a3);
/*INTROSPECTION_HANDLER*/void r91collect_native_array_internals_from_generating_type(T91*C,T0*a1,T351 a2,T0*a3,T0*a4);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_type_attribute_count(T91*C);
/*INTROSPECTION_HANDLER*/void r91start_new_body_for(T91*C,T0*a1,T0*a2,T6 a3);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_make_blank(T91*C);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_to_internals(T91*C,T0*a1,T0*a2);
/*INTROSPECTION_HANDLER*/T0*r91specialize_body_for_any_to_internals(T91*C,T0*a1,T0*a2,T6 a3);
/*INTROSPECTION_HANDLER*/T0*r91internals_of(T91*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*INTROSPECTION_HANDLER*/T0*r91arguments(T91*C);
/*INTROSPECTION_HANDLER*/T0*r91specialize_body_for_internals_handler(T91*C,T0*a1,T0*a2,T6 a3);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_attribute_is_expanded(T91*C);
/*INTROSPECTION_HANDLER*/T0*r91specialize_body_for_native_array_internals(T91*C,T0*a1,T0*a2,T6 a3);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_attribute_generator(T91*C);
/*INTROSPECTION_HANDLER*/T6 r91is_introspectable_dynamic_type(T0*a1);
/*INTROSPECTION_HANDLER*/T0*r91simplify_and_wrap(T91*C,T0*a1);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_native_array_internals(T91*C,T0*a1,T0*a2);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_set_object_attribute(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_na_attribute_count(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_is_equal(T91*C);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_internals_from_generating_type(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_can_be_assigned_to_attribute(T91*C);
/*INTROSPECTION_HANDLER*/void r91collect_internals_handler(T91*C);
/*INTROSPECTION_HANDLER*/T6 r91is_internals_from_generating_type_used(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_generator(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_na_make_blank(T91*C);
/*INTROSPECTION_HANDLER*/void r91collect_internals_handler_for(T91*C,T0*a1,T0*a2);
/*INTROSPECTION_HANDLER*/T0*r91specialize_body_for_typed_internals(T91*C,T0*a1,T0*a2,T6 a3);
/*INTROSPECTION_HANDLER*/T0*r91specialize_and_check_body(T91*C,T0*a1);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_attribute_name(T91*C);
/*INTROSPECTION_HANDLER*/T0*r91error_handler(void);
/*INTROSPECTION_HANDLER*/void r91set_and_specialize_body(T91*C,T0*a1,T0*a2);
/*INTROSPECTION_HANDLER*/T0*r91wrap(T0*a1);
/*INTROSPECTION_HANDLER*/T0*r91finalized_body_for_valid_generating_type_for_internals(T91*C);
/*INTROSPECTION_HANDLER*/T6 r91create_blank_internals_used_by(T91*C,T0*a1);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_is_expanded(T91*C);
/*INTROSPECTION_HANDLER*/T351 r91start_position(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_object_as_pointer(T91*C);
/*INTROSPECTION_HANDLER*/void r91specialize_body_for_type_generating_type(T91*C);
/*INTROSPECTION_HANDLER*/T6 r91is_introspectable_attribute_type(T91*C,T0*a1);
typedef struct _se_agenT383f383l155c38 se_agenT383f383l155c38;
struct _se_agenT383f383l155c38{Tid id;
int creation_mold_id;
void(*afp)(se_agenT383f383l155c38*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a1;
};
/*agent creation*/T0*agenT383f383l155c38(T0*closed_C,T0*closed_a1);
typedef struct _se_agenT383f383l474c46 se_agenT383f383l474c46;
struct _se_agenT383f383l474c46{Tid id;
int creation_mold_id;
void(*afp)(se_agenT383f383l474c46*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_a1;
};
/*agent creation*/T0*agenT383f383l474c46(T0*closed_a1);
/*LIVE_TYPE*/T0*r383tag(T383*C,T0*a1);
/*LIVE_TYPE*/void r383create_function_register(T383*C,T0*a1);
/*LIVE_TYPE*/void r383sort_wam(T0*a1);
/*LIVE_TYPE*/T6 r383generating_type_used(T383*C);
/*LIVE_TYPE*/T0*r383at(T383*C,T0*a1);
/*LIVE_TYPE*/void r383collect(T383*C,T0*a1);
extern T0*oBC32deep_memcmp_name;
extern int fBC32deep_memcmp_name;
/*LIVE_TYPE*/T0*r383deep_memcmp_name(void);
/*LIVE_TYPE*/void r383collect_is_deep_equal(T383*C);
/*LIVE_TYPE*/T6 r383is_native_array(T383*C);
/*LIVE_TYPE*/void r383simplify(T383*C);
/*LIVE_TYPE*/T6 r383generator_used(T383*C);
/*LIVE_TYPE*/T0*r383dynamic_feature(T383*C,T0*a1);
/*LIVE_TYPE*/T6 r383no_dispatch_collect(T383*C,T0*a1);
/*LIVE_TYPE*/void r383propagate_features(T383*C);
/*LIVE_TYPE*/T2 r383feature_count(T383*C);
/*LIVE_TYPE*/void r383do_collect(T383*C);
/*LIVE_TYPE*/T6 r383side_effect_free_default_create(T383*C);
/*LIVE_TYPE*/T6 r383gt(T0*a1,T0*a2);
/*LIVE_TYPE*/T0*r383get_memory_dispose(T383*C);
/*LIVE_TYPE*/void r383safety_check(T383*C);
/*LIVE_TYPE*/void r383make_run_features(T383*C);
/*LIVE_TYPE*/T6 r383_ix_60(T383*C,T0*a1);
/*LIVE_TYPE*/T6 r383is_empty_expanded(T383*C);
/*LIVE_TYPE*/T6 r383can_be_assigned_to(T383*C,T0*a1);
extern T0*oBC383empty_create_function_list;
extern int fBC383empty_create_function_list;
/*LIVE_TYPE*/T0*r383empty_create_function_list(void);
/*LIVE_TYPE*/void r383make(T383*C,T0*a1);
/*LIVE_TYPE*/void r383collect_sub_type(T383*C,T0*a1,T0*a2);
/*LIVE_TYPE*/T0*r383echo(void);
/*LIVE_TYPE*/T0*r383copy_run_feature(T383*C);
/*LIVE_TYPE*/void r383allow_collecting(T383*C,T0*a1);
/*LIVE_TYPE*/void r383adapt_run_features_and_class_invariant(T383*C);
extern T0*oBC32is_deep_equal_name;
extern int fBC32is_deep_equal_name;
/*LIVE_TYPE*/T0*r383is_deep_equal_name(void);
/*LIVE_TYPE*/void r383collect_deep_twin(T383*C);
/*LIVE_TYPE*/void r383set_at_run_time(T383*C);
/*LIVE_TYPE*/T0*r383precursor_run_feature(T383*C,T0*a1,T0*a2);
/*LIVE_TYPE*/void r383set_generator_used(T383*C);
/*LIVE_TYPE*/void r383forbid_collecting(T383*C,T0*a1);
extern T0*oBC32any_is_deep_equal_fs;
extern int fBC32any_is_deep_equal_fs;
/*LIVE_TYPE*/T0*r383any_is_deep_equal_fs(void);
/*LIVE_TYPE*/T6 r383is_reference(T383*C);
/*LIVE_TYPE*/T0*r383default_create_run_feature(T383*C);
extern T0*oBC32deep_twin_from_name;
extern int fBC32deep_twin_from_name;
/*LIVE_TYPE*/T0*r383deep_twin_from_name(void);
/*LIVE_TYPE*/void r383inline_dynamic_dispatch(T383*C,T0*a1);
extern T0*oBC383new_features;
extern int fBC383new_features;
/*LIVE_TYPE*/T0*r383new_features(void);
extern T0*oBC32any_deep_twin_fs;
extern int fBC32any_deep_twin_fs;
/*LIVE_TYPE*/T0*r383any_deep_twin_fs(void);
/*LIVE_TYPE*/T0*r383structure_signature(T383*C);
/*LIVE_TYPE*/T0*r383writable_attributes(T383*C);
/*LIVE_TYPE*/void r383set_tag(T383*C,T0*a1,T0*a2);
/*LIVE_TYPE*/T0*r383id_provider(void);
/*LIVE_TYPE*/void r383id_extra_information(T383*C,T0*a1);
extern T0*oBC32deep_twin_name;
extern int fBC32deep_twin_name;
/*LIVE_TYPE*/T0*r383deep_twin_name(void);
/*LIVE_TYPE*/void r383do_collect_is_deep_equal(T383*C);
extern T0*oBC32live_type_extra_collectors;
extern int fBC32live_type_extra_collectors;
/*LIVE_TYPE*/T0*r383live_type_extra_collectors(void);
/*LIVE_TYPE*/T0*r383error_handler(void);
/*LIVE_TYPE*/void r383accept(T383*C,T0*a1);
/*LIVE_TYPE*/void r383forget_previous_collect(T383*C);
/*LIVE_TYPE*/T6 r383is_tagged(T383*C);
/*LIVE_TYPE*/void r383merge_features_from(T383*C,T0*a1);
/*LIVE_TYPE*/T6 r383collected(T383*C,T0*a1);
/*ASSIGNMENT_HANDLER*/void r110recompute_all_run_time_sets(void);
/*ASSIGNMENT_HANDLER*/T0*r110echo(void);
extern T0*oBC110external_types;
extern int fBC110external_types;
/*ASSIGNMENT_HANDLER*/T0*r110external_types(void);
/*ASSIGNMENT_HANDLER*/void r110from_external(T110*C,T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_HANDLER*/T0*r110implicit_cast(T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_HANDLER*/T0*r110graph_node_for(T0*a1);
/*ASSIGNMENT_HANDLER*/void r110collect_force(T110*C,T0*a1,T0*a2);
/*ASSIGNMENT_HANDLER*/void r110id_extra_information(T0*a1,T0*a2);
/*ASSIGNMENT_HANDLER*/void r110from_external_(T110*C,T0*a1,T0*a2);
/*ASSIGNMENT_HANDLER*/void r110echo_information(void);
extern T0*oBC110graph_node_dictionary;
extern int fBC110graph_node_dictionary;
/*ASSIGNMENT_HANDLER*/T0*r110graph_node_dictionary(void);
/*ASSIGNMENT_HANDLER*/void r110reset(void);
/*ASSIGNMENT_HANDLER*/T0*r110implicit_cast_(T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_HANDLER*/void r110collect_normal(T110*C,T0*a1,T0*a2);
/*CLASS_NAME*/T95*create95unknown_position(T0*a1,T6 a2);
/*CLASS_NAME*/T95*create95make(T0*a1,T351 a2,T6 a3);
/*CLASS_NAME*/T6 r95is_equal(T95*C,T0*a1);
/*CLASS_NAME*/void r95make(T95*C,T0*a1,T351 a2,T6 a3);
extern T0*oBC95class_name_cache;
extern int fBC95class_name_cache;
/*CLASS_NAME*/T0*r95class_name_cache(void);
/*CLASS_NAME*/T0*r95try_class_text(T95*C);
/*CLASS_NAME*/void r95set_hashed_name(T95*C,T0*a1);
/*CLASS_NAME*/void r95unknown_position(T95*C,T0*a1,T6 a2);
/*CLASS_NAME*/void r95set_accurate_position(T95*C,T351 a1);
/*CLASS_NAME*/T0*r95class_text(T95*C);
/*CLASS_NAME*/T0*r95twin(T95*C);
/*CLASS_NAME*/T6 r95get_export_permission_of(T95*C,T0*a1);
/*CLASS_NAME*/T0*r95error_handler(void);
/*CLASS_NAME*/T2 r95tuple_count(T95*C);
extern T0*oBC32any_default_rescue_fs;
extern int fBC32any_default_rescue_fs;
/*TYPE*/T0*r286any_default_rescue_fs(void);
/*TYPE*/T6 r286has_simple_feature_name(T286*C,T0*a1);
/*TYPE*/T0*r286name_from_string(T286*C,T0*a1);
/*TYPE*/T0*r286twin_stamp(T286*C);
/*TYPE*/T6 r286is_agent(T286*C);
/*TYPE*/T0*r286long_name(T286*C);
/*TYPE*/void r286add_parent(T286*C,T0*a1);
/*TYPE*/T0*r286expanded_default_create_stamp(T286*C);
/*TYPE*/void r286collect_features(T286*C);
/*TYPE*/T6 r286is_native_array(T286*C);
/*TYPE*/T2 r286id(T286*C);
/*TYPE*/T6 r286is_pointer(T286*C);
/*TYPE*/void r286collect_default_rescue(T286*C,T0*a1);
/*TYPE*/T0*r286parent_edge_load(T286*C,T2 a1);
/*TYPE*/void r286do_collect(T286*C);
/*TYPE*/T2 r286parents_count(T286*C);
/*TYPE*/T1 r286insert_inherit_test(T286*C,T0*a1);
/*TYPE*/T0*r286has_only_one_conformant_parent(T286*C);
/*TYPE*/T6 r286is_real(T286*C);
/*TYPE*/T0*r286feature_stamp_of(T286*C,T0*a1);
/*TYPE*/T6 r286is_fixed_string(T286*C);
/*TYPE*/T6 r286is_empty_expanded(T286*C);
/*TYPE*/T0*r286find_manifest_expression_for(T286*C,T0*a1,T0*a2);
/*TYPE*/void r286specialize_and_check(T286*C);
/*TYPE*/T0*r286feature_accumulator(void);
/*TYPE*/T6 r286can_be_assigned_to(T286*C,T0*a1);
/*TYPE*/T6 r286is_natural(T286*C);
/*TYPE*/T6 r286print_feature_hierarchy(T286*C,T0*a1,T348 a2,T6 a3);
/*TYPE*/void r286node_init(T286*C,T0*a1);
/*TYPE*/T6 r286is_integer(T286*C);
/*TYPE*/void r286make(T286*C,T0*a1,T6 a2);
/*TYPE*/T6 r286is_character(T286*C);
/*TYPE*/T6 r286is_expanded(T286*C);
/*TYPE*/T0*r286copy_stamp(T286*C);
/*TYPE*/T6 r286is_kernel_expanded(T286*C);
/*TYPE*/void r286adapt_class_invariant(T286*C);
/*TYPE*/void r286add_feature(T286*C,T0*a1,T0*a2);
/*TYPE*/T6 r286is_reference(T286*C);
/*TYPE*/void r286build_actual_invariant(T286*C);
/*TYPE*/void r286inline_dynamic_dispatch_for_class_invariant(T286*C,T0*a1);
/*TYPE*/void r286do_all_address_of(T286*C,T0*a1);
extern T0*oBC32default_rescue_name;
extern int fBC32default_rescue_name;
/*TYPE*/T0*r286default_rescue_name(void);
/*TYPE*/T6 r286inherits_from(T286*C,T0*a1);
/*TYPE*/void r286deconnect_current(T286*C);
/*TYPE*/T0*r286open_arguments(T286*C);
/*TYPE*/void r286collect_local_features(T286*C);
/*TYPE*/T0*r286writable_attributes(T286*C);
/*TYPE*/T0*r286find_anonymous_feature_for(T286*C,T0*a1,T0*a2);
/*TYPE*/T6 r286is_user_expanded(T286*C);
/*TYPE*/T0*r286error_handler(void);
/*TYPE*/T2 r286collected_feature_count(T286*C);
/*TYPE*/T6 r286is_boolean(T286*C);
/*TYPE*/T0*r286is_equal_stamp(T286*C);
/*TYPE*/void r286collect_one_feature(T286*C,T0*a1,T2 a2);
/*TYPE*/void r286add_seeds(T286*C,T0*a1,T0*a2,T6 a3);
/*TYPE*/T6 r286direct_non_void_call_flag(T286*C);
/*TYPE*/T6 r286is_string(T286*C);
/*TYPE*/T6 r286is_tuple(T286*C);
/*TYPE*/void r286print_graph_cycle(T286*C,T0*a1);
/*TYPE*/T0*r286agent_result(T286*C);
/*TYPE*/T6 r286is_always_void(T286*C);
/*TYPE*/void r286inheritance_cycle_check(T286*C);
/*TYPE*/void r286address_of_register(T286*C,T0*a1);
/*TYPE*/void r286_P_287_add_parent(T286*C,T0*a1);
/*TYPE*/void r286_P_288_make(T286*C,T0*a1);
/*TYPE*/void r286_P_288_add_parent(T286*C,T0*a1);
/*FEATURE_STAMP*/void r89specialize_and_check(T89*C,T0*a1);
/*FEATURE_STAMP*/void r89add_anonymous_feature(T89*C,T0*a1,T0*a2);
/*FEATURE_STAMP*/void r89make(T89*C,T0*a1);
/*FEATURE_STAMP*/T0*r89simplify(T89*C,T0*a1);
/*FEATURE_STAMP*/T6 r89has_run_feature_for(T89*C,T0*a1);
/*FEATURE_STAMP*/T0*r89run_feature_for(T89*C,T0*a1);
/*FEATURE_STAMP*/T6 r89has_anonymous_feature_for(T89*C,T0*a1);
/*FEATURE_STAMP*/void r89rename_notify(T89*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_STAMP*/T0*r89specialize_thru(T89*C,T0*a1,T0*a2,T0*a3);
/*FEATURE_STAMP*/void r89update_anonymous_feature(T89*C,T0*a1,T0*a2);
/*FEATURE_STAMP*/T6 r89has_type(T89*C,T0*a1);
/*FEATURE_STAMP*/void r89register_type(T89*C,T0*a1);
/*FEATURE_STAMP*/T0*r89resolve_static_binding_for_insert(T89*C,T0*a1,T0*a2);
/*FEATURE_STAMP*/T0*r89fake_feature_call(T89*C,T351 a1,T0*a2,T0*a3);
/*FEATURE_STAMP*/T6 r89print_feature_hierarchy(T89*C,T0*a1,T0*a2,T348 a3,T6 a4);
/*FEATURE_STAMP*/void r89rename_down_notify(T89*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_STAMP*/T6 r89add_seeds(T89*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*FEATURE_STAMP*/T0*r89feature_accumulator(void);
/*FEATURE_STAMP*/T0*r89resolve_static_binding_for_inherit(T89*C,T0*a1,T0*a2);
/*FEATURE_STAMP*/void r89make_run_feature(T89*C,T0*a1,T0*a2);
/*FEATURE_STAMP*/T0*r89fake_effective_arg_list(T351 a1,T0*a2,T0*a3);
/*FEATURE_STAMP*/T0*r89error_handler(void);
/*FEATURE_STAMP*/T0*r89anonymous_feature_if_exist(T89*C,T0*a1);
/*FEATURE_STAMP*/T0*r89resolve_static_binding_for(T89*C,T0*a1,T0*a2);
/*FEATURE_STAMP*/T0*r89anonymous_feature(T89*C,T0*a1);
/*FIXED_STRING*/T6 r306is_equal(T306*C,T0*a1);
/*FIXED_STRING*/T0*r306intern(T306*C);
/*FIXED_STRING*/void r306unlock_tagged_out(void);
/*FIXED_STRING*/T3 r306first(T306*C);
/*FIXED_STRING*/T0*r306tagged_out_memory_pool(void);
/*FIXED_STRING*/void r306fill_tagged_out_memory(T306*C);
/*FIXED_STRING*/void r306lock_tagged_out(void);
extern T0*oBC306weakrefs;
extern int fBC306weakrefs;
/*FIXED_STRING*/T0*r306weakrefs(void);
/*FIXED_STRING*/void r306make_from_string(T306*C,T0*a1);
/*FIXED_STRING*/T0*r306new_holders(T306*C);
/*FIXED_STRING*/T0*r306_ix_35(T306*C,T0*a1);
/*FIXED_STRING*/T6 r306is_shared(T306*C);
/*FIXED_STRING*/void r306unshare(T306*C);
/*FIXED_STRING*/T8 r306to_external(T306*C);
/*FIXED_STRING*/T2 r306computed_hash_code(T306*C);
/*FIXED_STRING*/T2 r306upper(T306*C);
/*FIXED_STRING*/T3 r306item(T306*C,T2 a1);
/*FIXED_STRING*/T6 r306_ix_60(T306*C,T0*a1);
/*FIXED_STRING*/T6 r306same_as(T306*C,T0*a1);
/*FIXED_STRING*/T0*r306interned(void);
/*FIXED_STRING*/T0*r306tagged_out_memory(void);
extern T0*oBC306holders_memory;
extern int fBC306holders_memory;
/*FIXED_STRING*/T0*r306holders_memory(void);
/*FIXED_STRING*/void r306do_intern(T306*C,T0*a1);
/*FIXED_STRING*/T0*r306out(T306*C);
/*FIXED_STRING*/void r306copy_slice_to_native(T306*C,T2 a1,T2 a2,T9 a3,T2 a4);
/*FIXED_STRING*/T0*r306tagged_out_memories(void);
/*FIXED_STRING*/void r306print_on(T306*C,T0*a1);
/*FIXED_STRING*/T6 r306has(T306*C,T3 a1);
typedef struct _se_agenT108f108l185c20 se_agenT108f108l185c20;
struct _se_agenT108f108l185c20{Tid id;
int creation_mold_id;
T6(*afp)(se_agenT108f108l185c20*,T0*);
int (*eq)(se_agent*,se_agent*);
T6 R;
};
/*agent creation*/T0*agenT108f108l185c20(void);
typedef struct _se_agenT108f108l175c20 se_agenT108f108l175c20;
struct _se_agenT108f108l175c20{Tid id;
int creation_mold_id;
T6(*afp)(se_agenT108f108l175c20*,T0*);
int (*eq)(se_agent*,se_agent*);
T6 R;
};
/*agent creation*/T0*agenT108f108l175c20(void);
/*MANIFEST_STRING_POOL*/void r108collect_string(T108*C,T0*a1);
/*MANIFEST_STRING_POOL*/T0*r108se_ums(T108*C);
extern T0*oBC108agent_exists_in_collected_storage_id_set;
extern int fBC108agent_exists_in_collected_storage_id_set;
/*MANIFEST_STRING_POOL*/T0*r108agent_exists_in_collected_storage_id_set(void);
/*MANIFEST_STRING_POOL*/void r108make_unique(T0*a1,T0*a2);
/*MANIFEST_STRING_POOL*/T0*r108se_ms(T108*C);
extern T0*oBC32calloc_name;
extern int fBC32calloc_name;
/*MANIFEST_STRING_POOL*/T0*r108calloc_name(void);
extern T0*oBC32count_name;
extern int fBC32count_name;
/*MANIFEST_STRING_POOL*/T0*r108count_name(void);
/*MANIFEST_STRING_POOL*/T2 r108storage_alias_count(void);
extern T0*oBC32storage_lower_name;
extern int fBC32storage_lower_name;
/*MANIFEST_STRING_POOL*/T0*r108storage_lower_name(void);
/*MANIFEST_STRING_POOL*/T2 r108collected_once_count(void);
extern T0*oBC108agent_exists_in_collected_once_variables;
extern int fBC108agent_exists_in_collected_once_variables;
/*MANIFEST_STRING_POOL*/T0*r108agent_exists_in_collected_once_variables(void);
extern T0*oBC32from_external_sized_copy_name;
extern int fBC32from_external_sized_copy_name;
/*MANIFEST_STRING_POOL*/T0*r108from_external_sized_copy_name(void);
extern T0*oBC108collected_once_variables;
extern int fBC108collected_once_variables;
/*MANIFEST_STRING_POOL*/T0*r108collected_once_variables(void);
/*MANIFEST_STRING_POOL*/T0*r108collect(T108*C,T0*a1,T6 a2,T6 a3,T0*a4);
extern T0*oBC108storage_alias;
extern int fBC108storage_alias;
/*MANIFEST_STRING_POOL*/T0*r108storage_alias(void);
extern T0*oBC32manifest_initialize_name;
extern int fBC32manifest_initialize_name;
/*MANIFEST_STRING_POOL*/T0*r108manifest_initialize_name(void);
/*MANIFEST_STRING_POOL*/T0*r108capacity_name(void);
/*MANIFEST_STRING_POOL*/void r108reset(T108*C);
/*MANIFEST_STRING_POOL*/T6 r108exists_in_collected_storage_id_set(T0*a1);
/*MANIFEST_STRING_POOL*/T0*r108storage_alias_item(T2 a1);
/*MANIFEST_STRING_POOL*/T6 r108exists_in_collected_once_variables(T0*a1);
extern T0*oBC32storage_name;
extern int fBC32storage_name;
/*MANIFEST_STRING_POOL*/T0*r108storage_name(void);
/*MANIFEST_STRING_POOL*/void r108append_once_variable_index(T0*a1,T2 a2);
/*MANIFEST_STRING_POOL*/T0*r108collected_once_item(T2 a1);
extern T0*oBC108collected_storage_id_set;
extern int fBC108collected_storage_id_set;
/*MANIFEST_STRING_POOL*/T0*r108collected_storage_id_set(void);
extern T0*oBC116collected_manifest_generic;
extern int fBC116collected_manifest_generic;
/*MANIFEST_GENERIC_POOL*/T0*r116collected_manifest_generic(void);
extern T0*oBC125function_list;
extern int fBC125function_list;
/*ONCE_ROUTINE_POOL*/T0*r125function_list(void);
/*ONCE_ROUTINE_POOL*/T6 r125is_precomputed(T0*a1);
extern T0*oBC32precomputable_routine_detector;
/*ONCE_ROUTINE_POOL*/void r125unique_result_in(T0*a1,T0*a2);
/*ONCE_ROUTINE_POOL*/T0*r125non_void_no_dispatch_for(T0*a1,T0*a2,T0*a3);
/*ONCE_ROUTINE_POOL*/T0*r125o_flag(T0*a1);
/*ONCE_ROUTINE_POOL*/void r125collect_precomputable_function(T0*a1,T0*a2,T0*a3);
/*ONCE_ROUTINE_POOL*/T0*r125precomputable_function(T0*a1,T0*a2,T0*a3);
extern T0*oBC125precomputable_function_list;
extern int fBC125precomputable_function_list;
/*ONCE_ROUTINE_POOL*/T0*r125precomputable_function_list(void);
/*ONCE_ROUTINE_POOL*/void r125do_all_precomputed_ordered(T0*a1);
extern T0*oBC125collected_precomputable_function;
extern int fBC125collected_precomputable_function;
/*ONCE_ROUTINE_POOL*/T0*r125collected_precomputable_function(void);
/*ONCE_ROUTINE_POOL*/void r125unique_id_in(T0*a1,T0*a2);
extern T0*oBC125procedure_list;
extern int fBC125procedure_list;
/*ONCE_ROUTINE_POOL*/T0*r125procedure_list(void);
extern T0*oBC124creation_collected_memory;
extern int fBC124creation_collected_memory;
/*AGENT_POOL*/T0*r124creation_collected_memory(void);
extern T0*oBC124launcher_collected_memory;
extern int fBC124launcher_collected_memory;
/*AGENT_POOL*/T0*r124launcher_collected_memory(void);
/*AGENT_POOL*/T0*r124agent_launcher_collect(T0*a1);
/*AGENT_POOL*/void r124notify_assignment_handler_with(T0*a1,T0*a2);
extern T0*oBC124agent_definition_set;
extern int fBC124agent_definition_set;
/*AGENT_POOL*/T0*r124agent_definition_set(void);
/*AGENT_POOL*/void r124agent_creation_collect(T124*C,T0*a1,T0*a2,T0*a3);
/*AGENT_POOL*/void r124reset(T124*C);
extern T0*oBC124launcher_memory;
extern int fBC124launcher_memory;
/*AGENT_POOL*/T0*r124launcher_memory(void);
extern T0*oBC127map;
extern int fBC127map;
/*ASSIGNMENT_TEST_POOL*/T0*r127map(void);
/*ASSIGNMENT_TEST_POOL*/T0*r127new_empty_set(void);
/*ASSIGNMENT_TEST_POOL*/void r127signature_add_last(T0*a1,T0*a2);
/*ASSIGNMENT_TEST_POOL*/void r127for_each(T0*a1);
/*ASSIGNMENT_TEST_POOL*/void r127collect(T0*a1,T0*a2);
/*ASSIGNMENT_TEST_POOL*/void r127reset(void);
extern T0*oBC127free_set_list;
extern int fBC127free_set_list;
/*ASSIGNMENT_TEST_POOL*/T0*r127free_set_list(void);
/*ASSIGNMENT_TEST_POOL*/void r127function_name_in(T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_TEST_POOL*/T2 r127count(void);
/*STRING_TYPE_MARK*/T452*create452make(T351 a1);
/*STRING_TYPE_MARK*/T6 r452is_equal(T452*C,T0*a1);
/*STRING_TYPE_MARK*/T6 r452is_tuple(void);
/*STRING_TYPE_MARK*/void r452make(T452*C,T351 a1);
/*STRING_TYPE_MARK*/T0*r452generic_list(void);
/*STRING_TYPE_MARK*/T6 r452is_anchored(void);
/*STRING_TYPE_MARK*/T6 r452is_character(void);
/*STRING_TYPE_MARK*/T0*r452written_mark(void);
extern T0*oBC452written_name;
extern int fBC452written_name;
/*STRING_TYPE_MARK*/T0*r452written_name(void);
/*STRING_TYPE_MARK*/T6 r452is_native_array(void);
/*STRING_TYPE_MARK*/T0*r452at(T452*C,T351 a1);
/*STRING_TYPE_MARK*/T0*r452try_class_text(T452*C);
extern T0*oBC452long_name;
extern int fBC452long_name;
/*STRING_TYPE_MARK*/T0*r452long_name(void);
/*STRING_TYPE_MARK*/T0*r452specialize_thru(T452*C,T0*a1,T0*a2,T0*a3);
/*STRING_TYPE_MARK*/T6 r452is_boolean(void);
/*STRING_TYPE_MARK*/T0*r452typed_internals_type_mark(T452*C,T351 a1);
/*STRING_TYPE_MARK*/T0*r452to_static(T452*C,T0*a1,T6 a2);
/*STRING_TYPE_MARK*/void r452accept(T452*C,T0*a1);
/*STRING_TYPE_MARK*/T6 r452same_signature_type(T452*C,T0*a1,T0*a2);
/*STRING_TYPE_MARK*/T0*r452type(void);
/*STRING_TYPE_MARK*/T0*r452signature_resolve_in(T0*a1);
/*STRING_TYPE_MARK*/T6 r452is_natural(void);
/*STRING_TYPE_MARK*/T0*r452default_expression(T351 a1);
/*STRING_TYPE_MARK*/void r452id_extra_information(T0*a1);
/*STRING_TYPE_MARK*/T0*r452declaration_type(T452*C);
/*STRING_TYPE_MARK*/T6 r452is_pointer(void);
/*STRING_TYPE_MARK*/T351 r452start_position(T452*C);
/*STRING_TYPE_MARK*/T6 r452is_kernel_expanded(void);
/*STRING_TYPE_MARK*/void r452set_start_position(T452*C,T351 a1);
/*STRING_TYPE_MARK*/T6 r452is_fixed_string(void);
/*STRING_TYPE_MARK*/T0*r452class_text(T452*C);
/*STRING_TYPE_MARK*/T0*r452twin(T452*C);
/*STRING_TYPE_MARK*/T6 r452is_real(void);
/*STRING_TYPE_MARK*/T6 r452is_integer(void);
/*STRING_TYPE_MARK*/void r452pretty_in(T0*a1);
/*STRING_TYPE_MARK*/T0*r452weak_reference_argument(T452*C,T0*a1);
/*STRING_TYPE_MARK*/T0*r452error_handler(void);
/*STRING_TYPE_MARK*/T0*r452resolve_in(T0*a1);
/*STRING_TYPE_MARK*/T6 r452is_agent(void);
/*CODE_ACCUMULATOR*/void r341make(T341*C);
/*CODE_ACCUMULATOR*/void r341open_new_context(T341*C);
/*CODE_ACCUMULATOR*/T0*r341current_context_to_instruction(T341*C);
/*CODE_ACCUMULATOR*/T0*r341echo(void);
/*CODE_ACCUMULATOR*/void r341add_sedb(T341*C,T351 a1,T3 a2);
/*CODE_ACCUMULATOR*/T0*r341current_context_to_expression(T341*C);
/*CODE_ACCUMULATOR*/void r341echo_information(T341*C);
/*CODE_ACCUMULATOR*/T0*r341current_context_to_code(T341*C);
/*CODE_ACCUMULATOR*/void r341close_current_context(T341*C);
/*FEATURE_ACCUMULATOR*/void r120make(T120*C);
/*FEATURE_ACCUMULATOR*/void r120finalize(T120*C);
/*FEATURE_ACCUMULATOR*/void r120finish_insert_seeds(T120*C);
/*FEATURE_ACCUMULATOR*/T0*r120echo(void);
/*FEATURE_ACCUMULATOR*/void r120collect_assigner(T120*C,T0*a1);
/*FEATURE_ACCUMULATOR*/void r120collect_assigner_(T120*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_ACCUMULATOR*/void r120do_pending_types(T120*C);
/*FEATURE_ACCUMULATOR*/T1 r120next_state(T120*C,T1 a1,T1 a2,T0*a3,T0*a4,T0*a5);
/*FEATURE_ACCUMULATOR*/void r120add_local_definition(T120*C,T0*a1);
extern T0*oBC120transitions;
extern int fBC120transitions;
/*FEATURE_ACCUMULATOR*/T0*r120transitions(void);
/*FEATURE_ACCUMULATOR*/T6 r120is_known(T120*C,T0*a1);
/*FEATURE_ACCUMULATOR*/void r120new_incomplete_type(T120*C);
/*FEATURE_ACCUMULATOR*/void r120start(T120*C,T0*a1);
/*FEATURE_ACCUMULATOR*/T0*r120anonymous_feature_for(T120*C,T0*a1);
/*FEATURE_ACCUMULATOR*/T0*r120feature_stamp_of(T120*C,T0*a1);
/*FEATURE_ACCUMULATOR*/void r120echo_information(T120*C);
/*FEATURE_ACCUMULATOR*/void r120register(T120*C,T0*a1);
/*FEATURE_ACCUMULATOR*/void r120new_feature(T120*C,T0*a1);
/*FEATURE_ACCUMULATOR*/void r120to_feature(T120*C,T0*a1);
/*FEATURE_ACCUMULATOR*/void r120add_parent_definition(T120*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_ACCUMULATOR*/T0*r120error_handler(void);
/*FEATURE_ACCUMULATOR*/void r120check_and_merge_seeds(T120*C);
/*FEATURE_ACCUMULATOR*/T1 r120transition_index(T120*C,T0*a1,T0*a2,T0*a3);
/*FEATURE_ACCUMULATOR*/T0*r120find_type_for(T120*C,T0*a1);
/*FEATURE_NAME*/T290*create290simple_feature_name(T0*a1,T351 a2);
/*FEATURE_NAME*/T290*create290infix_name(T0*a1,T351 a2);
/*FEATURE_NAME*/T6 r290is_equal(T290*C,T0*a1);
/*FEATURE_NAME*/T6 r290is_infix_name(T290*C);
/*FEATURE_NAME*/void r290pretty(T290*C,T2 a1);
/*FEATURE_NAME*/T6 r290is_alias_name(T290*C);
/*FEATURE_NAME*/void r290ordinary_name(T290*C,T0*a1,T351 a2);
/*FEATURE_NAME*/void r290set_plus_minus_prefix(T290*C);
/*FEATURE_NAME*/T6 r290is_frozen(T290*C);
/*FEATURE_NAME*/void r290special_pretty_print(T290*C,T6 a1);
/*FEATURE_NAME*/void r290basic_create_1(T290*C,T2 a1,T0*a2,T351 a3);
/*FEATURE_NAME*/void r290basic_create_0(T290*C,T2 a1,T0*a2,T351 a3);
/*FEATURE_NAME*/T0*r290infix_or_prefix(T290*C);
/*FEATURE_NAME*/void r290unknown_position(T290*C,T0*a1);
/*FEATURE_NAME*/void r290alias_name(T290*C,T0*a1,T351 a2);
/*FEATURE_NAME*/void r290infix_name(T290*C,T0*a1,T351 a2);
/*FEATURE_NAME*/void r290declaration_in(T290*C,T0*a1);
/*FEATURE_NAME*/void r290set_start_position(T290*C,T351 a1);
/*FEATURE_NAME*/T0*r290twin(T290*C);
/*FEATURE_NAME*/T6 r290is_simple_feature_name(T290*C);
/*FEATURE_NAME*/void r290complete_name_in(T290*C,T0*a1);
/*FEATURE_NAME*/void r290simple_feature_name(T290*C,T0*a1,T351 a2);
/*FEATURE_NAME*/void r290set_is_frozen(T290*C);
/*FEATURE_NAME*/T2 r290hash_code(T290*C);
/*FEATURE_NAME*/void r290prefix_name(T290*C,T0*a1,T351 a2);
/*FEATURE_NAME*/void r290mapping_c_in(T290*C,T0*a1);
/*FEATURE_NAME*/T6 r290is_prefix_name(T290*C);
/*ANY_TYPE_MARK*/T441*create441make(T351 a1);
/*ANY_TYPE_MARK*/T6 r441is_equal(T441*C,T0*a1);
/*ANY_TYPE_MARK*/T6 r441is_tuple(void);
/*ANY_TYPE_MARK*/void r441make(T441*C,T351 a1);
/*ANY_TYPE_MARK*/T0*r441generic_list(void);
/*ANY_TYPE_MARK*/T6 r441is_anchored(void);
/*ANY_TYPE_MARK*/T6 r441is_character(void);
/*ANY_TYPE_MARK*/T0*r441written_mark(T441*C);
/*ANY_TYPE_MARK*/T0*r441written_name(T441*C);
/*ANY_TYPE_MARK*/T6 r441is_native_array(void);
/*ANY_TYPE_MARK*/T0*r441at(T441*C,T351 a1);
/*ANY_TYPE_MARK*/T0*r441try_class_text(T441*C);
extern T0*oBC441long_name;
extern int fBC441long_name;
/*ANY_TYPE_MARK*/T0*r441long_name(void);
/*ANY_TYPE_MARK*/T0*r441specialize_thru(T441*C,T0*a1,T0*a2,T0*a3);
/*ANY_TYPE_MARK*/T6 r441is_boolean(void);
/*ANY_TYPE_MARK*/T0*r441typed_internals_type_mark(T441*C,T351 a1);
/*ANY_TYPE_MARK*/T0*r441to_static(T441*C,T0*a1,T6 a2);
/*ANY_TYPE_MARK*/T2 r441id(T441*C);
/*ANY_TYPE_MARK*/void r441accept(T441*C,T0*a1);
/*ANY_TYPE_MARK*/T6 r441same_signature_type(T441*C,T0*a1,T0*a2);
/*ANY_TYPE_MARK*/T0*r441type(void);
/*ANY_TYPE_MARK*/T0*r441signature_resolve_in(T0*a1);
/*ANY_TYPE_MARK*/T6 r441is_natural(void);
/*ANY_TYPE_MARK*/T0*r441default_expression(T351 a1);
/*ANY_TYPE_MARK*/void r441id_extra_information(T0*a1);
/*ANY_TYPE_MARK*/T0*r441declaration_type(T441*C);
/*ANY_TYPE_MARK*/T6 r441is_pointer(void);
/*ANY_TYPE_MARK*/T351 r441start_position(T441*C);
/*ANY_TYPE_MARK*/T6 r441is_kernel_expanded(void);
/*ANY_TYPE_MARK*/void r441set_start_position(T441*C,T351 a1);
/*ANY_TYPE_MARK*/T6 r441is_fixed_string(T441*C);
/*ANY_TYPE_MARK*/T0*r441class_text(T441*C);
/*ANY_TYPE_MARK*/T0*r441twin(T441*C);
/*ANY_TYPE_MARK*/T6 r441is_real(void);
/*ANY_TYPE_MARK*/T6 r441is_integer(void);
/*ANY_TYPE_MARK*/void r441pretty_in(T441*C,T0*a1);
/*ANY_TYPE_MARK*/T0*r441weak_reference_argument(T441*C,T0*a1);
/*ANY_TYPE_MARK*/T0*r441error_handler(void);
/*ANY_TYPE_MARK*/T0*r441resolve_in(T0*a1);
/*ANY_TYPE_MARK*/T6 r441is_agent(void);
extern T0*oBC587integer_alias;
extern int fBC587integer_alias;
/*TYPE_ALIASING*/T0*r587integer_alias(void);
/*TYPE_ALIASING*/T0*r587alias_of(T0*a1);
extern T0*oBC587real_alias;
extern int fBC587real_alias;
/*TYPE_ALIASING*/T0*r587real_alias(void);
extern T0*oBC587natural_alias;
extern int fBC587natural_alias;
/*TYPE_ALIASING*/T0*r587natural_alias(void);
/*NO_GC*/void r727gc_info_before_exit(T727*C);
/*NO_GC*/void r727weak_set_item(T0*a1);
/*NO_GC*/void r727initialize_user_expanded_attributes(T0*a1,T0*a2);
/*NO_GC*/T0*r727echo(void);
/*NO_GC*/void r727calloc(T0*a1,T0*a2);
/*NO_GC*/void r727put_ref_in_native_array(T0*a1);
/*NO_GC*/void r727malloc(T0*a1);
/*NO_GC*/T0*r727cpp(void);
/*NO_GC*/void r727allocation_of(T0*a1,T0*a2);
/*NO_GC*/void r727malloc_closure(T0*a1);
/*NO_GC*/void r727weak_item(T0*a1);
/*NO_GC*/void r727manifest_string_in(T0*a1);
/*NO_GC*/void r727mark_item(T0*a1);
/*BDW_GC*/void r728manifest_string_mark(T2 a1,T2 a2);
/*BDW_GC*/void r728make(T728*C);
/*BDW_GC*/void r728gc_info_before_exit(T728*C);
/*BDW_GC*/void r728weak_set_item(T0*a1);
/*BDW_GC*/void r728pre_customize_c_runtime(void);
/*BDW_GC*/void r728add_extra_collectors(T728*C);
/*BDW_GC*/void r728initialize_user_expanded_attributes(T0*a1,T0*a2);
/*BDW_GC*/T0*r728echo(void);
/*BDW_GC*/void r728calloc(T0*a1,T0*a2);
/*BDW_GC*/void r728put_ref_in_native_array(T0*a1);
/*BDW_GC*/void r728malloc(T0*a1);
/*BDW_GC*/void r728extra_c_struct(T728*C,T0*a1);
/*BDW_GC*/T0*r728cpp(void);
/*BDW_GC*/T0*r728live_type_extra_collectors(void);
/*BDW_GC*/void r728allocation_of(T0*a1,T0*a2);
/*BDW_GC*/void r728define_gc_start(T0*a1,T0*a2);
/*BDW_GC*/void r728malloc_closure(T0*a1);
/*BDW_GC*/T0*r728system_tools(void);
/*BDW_GC*/T0*r728get_memory_dispose(T0*a1);
/*BDW_GC*/void r728manifest_string_mark_signature(T2 a1);
/*BDW_GC*/void r728define2(T728*C);
/*BDW_GC*/void r728weak_item(T0*a1);
/*BDW_GC*/void r728generate_dispose(T0*a1,T0*a2,T0*a3);
/*BDW_GC*/void r728manifest_string_in(T0*a1);
/*BDW_GC*/void r728define_manifest_string_mark(void);
/*BDW_GC*/void r728assigned_native_array(T728*C,T0*a1,T0*a2);
/*BDW_GC*/void r728extra_c_model(T728*C,T0*a1);
/*BDW_GC*/void r728mark_item(T0*a1);
typedef struct _se_agenT729f729l536c33 se_agenT729f729l536c33;
struct _se_agenT729f729l536c33{Tid id;
int creation_mold_id;
void(*afp)(se_agenT729f729l536c33*,T0*,T2);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a2;
};
/*agent creation*/T0*agenT729f729l536c33(T0*closed_C,T0*closed_a2);
typedef struct _se_agenT729f729l558c30 se_agenT729f729l558c30;
struct _se_agenT729f729l558c30{Tid id;
int creation_mold_id;
void(*afp)(se_agenT729f729l558c30*,T0*);
int (*eq)(se_agent*,se_agent*);
T0* closed_C;
T0* closed_a2;
};
/*agent creation*/T0*agenT729f729l558c30(T0*closed_C,T0*closed_a2);
/*GC_HANDLER*/void r729store_left_in(T0*a1,T0*a2,T6 a3);
/*GC_HANDLER*/void r729for_all_argument_names(T0*a1,T0*a2,T0*a3);
/*GC_HANDLER*/void r729just_before_mark(T729*C,T0*a1);
/*GC_HANDLER*/void r729c_dicho(T0*a1,T2 a2,T2 a3);
/*GC_HANDLER*/void r729for_all_locals__(T0*a1,T0*a2,T0*a3);
/*GC_HANDLER*/void r729register_wa_list(T729*C,T0*a1);
/*GC_HANDLER*/void r729weak_item(T0*a1);
/*GC_HANDLER*/void r729manifest_string_in(T0*a1);
/*GC_HANDLER*/void r729mark_in(T0*a1,T0*a2,T6 a3);
/*GC_HANDLER*/void r729_inline_agent29(T729*C,T0*a1,T0*a2,T2 a3);
/*GC_HANDLER*/void r729_inline_agent30(T729*C,T0*a1,T0*a2);
/*GC_HANDLER*/void r729align_mark_in(T0*a1,T0*a2,T6 a3);
/*GC_HANDLER*/void r729memory_dispose(T729*C,T0*a1,T0*a2);
/*GC_HANDLER*/void r729generate_dispose(T0*a1,T0*a2,T0*a3);
/*GC_HANDLER*/void r729cecil_define(void);
/*GC_HANDLER*/void r729switch_for(T0*a1);
/*GC_HANDLER*/void r729post_cecil_define(void);
/*GC_HANDLER*/void r729compute_ceils(void);
/*GC_HANDLER*/void r729put_ref_in_native_array(T0*a1);
/*GC_HANDLER*/void r729add_extra_collectors(T729*C);
/*GC_HANDLER*/void r729generate_agent_data(T729*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*GC_HANDLER*/T0*r729cpp(void);
/*GC_HANDLER*/void r729malloc(T0*a1);
/*GC_HANDLER*/void r729weak_set_item(T0*a1);
/*GC_HANDLER*/void r729checkpoint(void);
/*GC_HANDLER*/void r729calloc(T0*a1,T0*a2);
/*GC_HANDLER*/void r729store_chunk_in(T0*a1,T0*a2,T6 a3);
/*GC_HANDLER*/void r729make(T729*C);
/*GC_HANDLER*/void r729customize_c_runtime(void);
/*GC_HANDLER*/void r729pre_customize_c_runtime(void);
/*GC_HANDLER*/T0*r729echo(void);
/*GC_HANDLER*/void r729manifest_string_mark_signature(T2 a1);
/*GC_HANDLER*/void r729na_env_in(T0*a1,T0*a2);
/*GC_HANDLER*/void r729define_gc_start(T729*C,T0*a1,T0*a2);
/*GC_HANDLER*/void r729initialize_runtime(void);
/*GC_HANDLER*/void r729mark_item(T0*a1);
/*GC_HANDLER*/void r729allocation_of(T0*a1,T0*a2);
/*GC_HANDLER*/void r729pre_cecil_define(void);
/*GC_HANDLER*/void r729define1(void);
/*GC_HANDLER*/void r729define2(T729*C);
/*GC_HANDLER*/void r729initialize_user_expanded_attributes(T0*a1,T0*a2);
/*GC_HANDLER*/void r729define_manifest_string_mark(void);
/*GC_HANDLER*/void r729for_all_arguments__(T0*a1,T0*a2,T0*a3,T2 a4);
/*GC_HANDLER*/void r729free_in(T0*a1,T0*a2,T6 a3);
/*GC_HANDLER*/void r729info_nb_in(T0*a1,T0*a2,T6 a3);
/*GC_HANDLER*/void r729for_all_local_names(T0*a1,T0*a2,T0*a3);
extern T0*oBC729c_struct_signature_tag;
extern int fBC729c_struct_signature_tag;
/*GC_HANDLER*/T0*r729c_struct_signature_tag(void);
/*GC_HANDLER*/void r729gc_info_before_exit(T729*C);
/*GC_HANDLER*/void r729sweep_in(T0*a1,T0*a2,T6 a3);
extern T0*oBC729special_tag;
/*GC_HANDLER*/void r729store_in(T0*a1,T0*a2,T6 a3);
/*GC_HANDLER*/void r729malloc_closure(T0*a1);
/*GC_HANDLER*/void r729manifest_string_mark(T2 a1,T2 a2);
/*GC_HANDLER*/void r729assign_agent_data(T0*a1);
/*GC_HANDLER*/T0*r729live_type_extra_collectors(void);
/*GC_HANDLER*/void r729define_agent_data(T0*a1);
/*GC_HANDLER*/void r729mark_once_routines(T729*C);
extern T0*oBC729switch_list;
extern int fBC729switch_list;
/*GC_HANDLER*/T0*r729switch_list(void);
/*GC_HANDLER*/void r729mark_for(T0*a1,T0*a2,T6 a3);
/*GC_HANDLER*/void r729agent_pool_gc_info(void);
/*GC_HANDLER*/void r729define_gc_info(T729*C,T0*a1);
/*GC_HANDLER*/void r729echo_information(T729*C);
/*PARTIALLY_FILLED_STRING*/void r318unlock_tagged_out(void);
/*PARTIALLY_FILLED_STRING*/T0*r318tagged_out_memory_pool(void);
/*PARTIALLY_FILLED_STRING*/void r318lock_tagged_out(void);
/*PARTIALLY_FILLED_STRING*/void r318put_arg(T318*C,T0*a1);
/*PARTIALLY_FILLED_STRING*/T0*r318_ix_35(T318*C,T0*a1);
/*PARTIALLY_FILLED_STRING*/T2 r318upper(T318*C);
/*PARTIALLY_FILLED_STRING*/T3 r318item(T318*C,T2 a1);
/*PARTIALLY_FILLED_STRING*/void r318out_in_tagged_out_memory(T318*C);
/*PARTIALLY_FILLED_STRING*/T0*r318memory(T318*C);
/*PARTIALLY_FILLED_STRING*/void r318parse_template(T318*C);
/*PARTIALLY_FILLED_STRING*/T0*r318tagged_out_memory(void);
/*PARTIALLY_FILLED_STRING*/T0*r318out(T318*C);
/*PARTIALLY_FILLED_STRING*/void r318from_string_and_arg(T318*C,T0*a1,T0*a2);
/*PARTIALLY_FILLED_STRING*/void r318copy_slice_to_native(T318*C,T2 a1,T2 a2,T9 a3,T2 a4);
/*PARTIALLY_FILLED_STRING*/T0*r318tagged_out_memories(void);
/*PARTIALLY_FILLED_STRING*/void r318print_on(T318*C,T0*a1);
/*PARTIALLY_FILLED_STRING*/T2 r318count(T318*C);
/*TAGGED_ERROR*/void r719make(T719*C,T0*a1,T0*a2);
/*TAGGED_ERROR*/void r719recycle(T719*C);
/*RUN_TIME_SET*/void r551make(T551*C,T0*a1);
/*RUN_TIME_SET*/T2 r551add_set(T551*C,T0*a1);
/*RUN_TIME_SET*/void r551id_extra_information(T551*C,T0*a1);
/*RUN_TIME_SET*/T6 r551is_empty(T551*C);
/*RUN_TIME_SET*/T2 r551count(T551*C);
/*TAGGED_ERRORS*/void r720make(T720*C);
/*CECIL_FILE*/void r340parse(T340*C);
/*CECIL_FILE*/void r340make(T340*C,T0*a1);
/*CECIL_FILE*/T0*r340eiffel_parser(void);
/*CECIL_FILE*/T0*r340echo(void);
/*CECIL_FILE*/void r340adapt_for(T340*C,T0*a1);
/*CECIL_FILE*/void r340collect(T340*C,T0*a1);
/*CECIL_FILE*/T0*r340error_handler(void);
/*CECIL_FILE*/void r340inline_dynamic_dispatch(T340*C,T0*a1,T0*a2);
typedef struct _se_agenT807f807l126c52 se_agenT807f807l126c52;
struct _se_agenT807f807l126c52{Tid id;
int creation_mold_id;
T0*(*afp)(se_agenT807f807l126c52*);
int (*eq)(se_agent*,se_agent*);
int closed_C;
T0* R;
};
/*agent creation*/T0*agenT807f807l126c52(int closed_C);
extern T0*oBC807home;
extern int fBC807home;
/*XDG*/T0*r807home(T807 C);
/*XDG*/T0*r807package(void);
/*XDG*/T0*r807getenv(T807 C,T0*a1,T0*a2,T0*a3);
extern T0*oBC807package_name;
extern T0*oBC807config_home;
extern int fBC807config_home;
/*XDG*/T0*r807config_home(T807 C);
/*XDG*/T0*r807_inline_agent36(T807 C);
extern int fBC807set_package;
/*XDG*/void r807set_package(T0*a1);
extern T0*oBC807config_home_;
extern int fBC807config_home_;
/*XDG*/T0*r807config_home_(T807 C);
/*SERC_CHAIN*/void r804make(T804*C);
/*SERC_CHAIN*/T0*r804sys(T804*C);
/*SERC_CHAIN*/void r804loadpaths_in(T804*C,T0*a1);
/*SERC_CHAIN*/T0*r804flavor(T804*C);
/*SERC_CHAIN*/T0*r804environment(T804*C,T0*a1);
/*SERC_CHAIN*/T0*r804short(T804*C);
/*SERC_CHAIN*/T0*r804bin(T804*C);
/*SERC_CHAIN*/T0*r804c_mode(T804*C,T0*a1);
/*SERC_CHAIN*/T0*r804os(T804*C);
/*SERC_DEFAULTS*/void r806make(T806*C);
/*SERC_DEFAULTS*/T0*r806environment(T0*a1);
/*STRING_RECYCLING_POOL*/void r59make(T59*C);
/*STRING_RECYCLING_POOL*/void r59recycle(T59*C,T0*a1);
/*STRING_RECYCLING_POOL*/T0*r59new_twin(T59*C,T0*a1);
/*STRING_RECYCLING_POOL*/T0*r59best_fit(T59*C,T2 a1);
/*SERC*/void r805make(T805*C);
/*SERC*/void r805add_all(T805*C,T0*a1,T0*a2,T0*a3);
/*SERC*/T0*r805echo(void);
/*SERC*/void r805loadpaths_in(T805*C,T0*a1);
/*SERC*/T0*r805parser_buffer(void);
extern T0*oBC80is_running_memory;
/*AT_EXIT*/void r80run(void);
extern T0*oBC80actions;
extern int fBC80actions;
/*AT_EXIT*/T0*r80actions(void);
/*INI_PARSER*/void r106goto_next_line(T106*C);
/*INI_PARSER*/T6 r106section_has(T106*C,T0*a1,T0*a2);
/*INI_PARSER*/void r106serc(T106*C);
/*INI_PARSER*/T0*r106lcs(void);
/*INI_PARSER*/T0*r106buffer(void);
/*INI_PARSER*/T6 r106a_section(T106*C);
extern T0*oBC32strings;
extern int fBC32strings;
/*INI_PARSER*/T0*r106strings(void);
/*INI_PARSER*/T0*r106unicode_string_buffer(void);
/*INI_PARSER*/T6 r106is_install(void);
/*INI_PARSER*/void r106a_keys(T106*C);
/*INI_PARSER*/T0*r106parser_buffer(void);
/*INI_PARSER*/void r106a_sections(T106*C);
/*INI_PARSER*/void r106go_back_at(T106*C,T2 a1,T2 a2);
/*INI_PARSER*/T6 r106skip1(T106*C,T3 a1);
/*INI_PARSER*/T6 r106a_string(T106*C);
/*INI_PARSER*/T351 r106current_position(T106*C);
/*INI_PARSER*/T6 r106a_keyword(T106*C,T0*a1);
/*INI_PARSER*/T0*r106echo(void);
/*INI_PARSER*/T6 r106a_identifier(T106*C);
/*INI_PARSER*/T6 r106a_manifest_string(T106*C,T6 a1);
/*INI_PARSER*/void r106fatal_error_except_for_install(T106*C,T0*a1);
/*INI_PARSER*/void r106a_inifile(T106*C);
/*INI_PARSER*/void r106may_expand_var_into(T106*C,T0*a1);
/*INI_PARSER*/T6 r106has(T106*C,T0*a1);
/*INI_PARSER*/void r106skip_comments(T106*C);
/*INI_PARSER*/void r106plugin(T106*C);
/*INI_PARSER*/T0*r106sections_iterator(T106*C);
/*INI_PARSER*/T0*r106section_item(T106*C,T0*a1,T0*a2);
/*INI_PARSER*/void r106next_char(T106*C);
/*INI_PARSER*/T6 r106a_key(T106*C);
/*INI_PARSER*/void r106update_last_manifest_string(T106*C,T351 a1,T6 a2,T6 a3,T0*a4,T0*a5);
/*INI_PARSER*/T0*r106section_key_iterator(T106*C,T0*a1);
/*INI_PARSER*/void r106set_value(T106*C,T0*a1);
/*INI_PARSER*/void r106may_expand_var(T106*C);
/*INI_PARSER*/T0*r106error_handler(void);
/*INI_PARSER*/T0*r106key_iterator(T106*C);
/*INI_PARSER*/T0*r106last_value(T106*C);
/*INI_PARSER*/T6 r106skip_spaces(T106*C);
/*INI_PARSER*/T351 r106pos(T106*C,T2 a1,T2 a2);
/*CLASSES_TREE*/T0*r783system_cluster(T783*C,T0*a1,T0*a2);
/*CLASSES_TREE*/void r783make(T783*C,T2 a1,T0*a2,T0*a3,T0*a4);
extern T0*oBC783system_clusters;
extern int fBC783system_clusters;
/*CLASSES_TREE*/T0*r783system_clusters(void);
/*CLASSES_TREE*/void r783for_all(T783*C,T0*a1);
/*CLASSES_TREE*/T2 r783cluster_count(T783*C);
/*CLASSES_TREE*/T0*r783echo(void);
/*CLASSES_TREE*/T0*r783cluster_named(T783*C,T0*a1);
/*CLASSES_TREE*/void r783show_name(T783*C);
/*CLASSES_TREE*/T0*r783classes_path_to_system_path(T783*C,T0*a1);
/*CLASSES_TREE*/void r783get_started(T783*C,T2 a1);
/*CLASSES_TREE*/void r783clusters_of(T783*C,T0*a1,T0*a2,T0*a3,T0*a4,T2 a5);
/*CLASSES_TREE*/void r783view_in(T783*C,T0*a1);
/*CLASSES_TREE*/T0*r783cluster_by_directory_path(T783*C,T0*a1);
/*CLASSES_TREE*/T0*r783system_notation(T783*C);
/*CLASSES_TREE*/T2 r783loaded_class_count(T783*C);
/*CLASSES_TREE*/void r783show_tabs(T2 a1);
/*CLASSES_TREE*/T0*r783to_string(T783*C);
/*CLASSES_TREE*/void r783parse_include(T783*C);
/*CLASSES_TREE*/T0*r783find_physical_cluster(T783*C,T0*a1);
/*CLASSES_TREE*/void r783show(T783*C,T2 a1);
/*CLASSES_TREE*/void r783_P_706_for_all(T783*C,T0*a1);
/*CLASSES_TREE*/T2 r783_P_706_cluster_count(T783*C);
/*CLASSES_TREE*/T0*r783_P_706_cluster_named(T783*C,T0*a1);
/*CLASSES_TREE*/void r783_P_706_get_started(T783*C,T2 a1);
/*CLASSES_TREE*/void r783_P_706_clusters_of(T783*C,T0*a1,T0*a2,T0*a3,T0*a4,T2 a5);
/*CLASSES_TREE*/void r783_P_706_view_in(T783*C,T0*a1);
/*CLASSES_TREE*/T0*r783_P_706_cluster_by_directory_path(T783*C,T0*a1);
/*CLASSES_TREE*/T2 r783_P_706_loaded_class_count(T783*C);
/*CLASSES_TREE*/void r783_P_706_parse_include(T783*C);
/*CLASSES_TREE*/T0*r783_P_706_find_physical_cluster(T783*C,T0*a1);
/*LOADPATH*/void r825make(T825*C,T2 a1,T0*a2,T0*a3,T0*a4,T0*a5,T6 a6);
/*LOADPATH*/T0*r825connect(T825*C,T0*a1,T0*a2);
/*LOADPATH*/void r825add_classes(T825*C,T0*a1);
/*LOADPATH*/void r825for_all(T825*C,T0*a1);
/*LOADPATH*/T2 r825cluster_count(T825*C);
/*LOADPATH*/void r825show_cycle(T825*C,T0*a1);
/*LOADPATH*/T0*r825echo(void);
/*LOADPATH*/void r825error_cycle(T825*C);
/*LOADPATH*/T0*r825cluster_named(T825*C,T0*a1);
extern T0*oBC825connected;
extern int fBC825connected;
/*LOADPATH*/T0*r825connected(void);
/*LOADPATH*/T0*r825strings(void);
/*LOADPATH*/void r825create_subtree(T825*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*LOADPATH*/void r825show_name(T825*C);
/*LOADPATH*/T0*r825classes_path_to_system_path(T825*C,T0*a1);
/*LOADPATH*/void r825get_started(T825*C,T2 a1);
/*LOADPATH*/T0*r825system_path_to_classes_path(T825*C,T0*a1);
/*LOADPATH*/void r825clusters_of(T825*C,T0*a1,T0*a2,T0*a3,T0*a4,T2 a5);
/*LOADPATH*/void r825view_in(T825*C,T0*a1);
/*LOADPATH*/T0*r825cluster_by_directory_path(T825*C,T0*a1);
/*LOADPATH*/T0*r825system_tools(void);
/*LOADPATH*/T0*r825system_notation(T825*C);
/*LOADPATH*/T2 r825loaded_class_count(T825*C);
/*LOADPATH*/void r825show_tabs(T2 a1);
extern T0*oBC825files;
extern int fBC825files;
/*LOADPATH*/T0*r825files(void);
/*LOADPATH*/T0*r825to_string(T825*C);
/*LOADPATH*/void r825parse_include(T825*C);
/*LOADPATH*/T0*r825error_handler(void);
/*LOADPATH*/T0*r825find_physical_cluster(T825*C,T0*a1);
/*LOADPATH*/void r825show(T825*C,T2 a1);
/*LOADPATH*/T0*r825new_path(T0*a1,T0*a2,T0*a3);
/*LOADPATH*/T0*r825new_name(T825*C,T0*a1,T2 a2);
/*CLUSTER_POOL_DATA*/void r785make(T785*C,T0*a1);
/*CLUSTER_POOL_DATA*/void r785add_cluster_class(T785*C,T0*a1,T0*a2);
/*CLUSTER_POOL_DATA*/T0*r785cluster_class(T785*C,T0*a1);
extern T0*oBC785hash_tuple;
extern int fBC785hash_tuple;
/*CLUSTER_POOL_DATA*/T0*r785hash_tuple(void);
/*CLUSTER_POOL_DATA*/T2 r785class_count(T785*C);
/*CLUSTER_POOL_DATA*/T6 r785has(T785*C,T0*a1);
/*MICROSECOND_TIME*/T11 r491timestamp(T491*C);
/*MICROSECOND_TIME*/void r491update(T491*C);
/*FORMAL_ARG_LIST*/void r367make(T367*C,T351 a1,T0*a2);
/*FORMAL_ARG_LIST*/void r367pretty(T367*C,T2 a1);
/*FORMAL_ARG_LIST*/T0*r367specialize_in(T367*C,T0*a1);
/*FORMAL_ARG_LIST*/void r367add_last(T367*C,T0*a1);
/*FORMAL_ARG_LIST*/T2 r367rank_of(T367*C,T0*a1);
/*FORMAL_ARG_LIST*/T0*r367specialize_thru(T367*C,T0*a1,T0*a2,T0*a3);
/*FORMAL_ARG_LIST*/T0*r367name(T367*C,T2 a1);
/*FORMAL_ARG_LIST*/T0*r367adapt_for(T367*C,T0*a1);
/*FORMAL_ARG_LIST*/T2 r367fast_rank_of(T367*C,T0*a1);
/*FORMAL_ARG_LIST*/void r367name_clash_check(T367*C,T0*a1);
/*FORMAL_ARG_LIST*/T2 r367compute_flat_list_count_by_using_list(T367*C);
/*FORMAL_ARG_LIST*/T0*r367twin(T367*C);
/*FORMAL_ARG_LIST*/T0*r367type_mark(T367*C,T2 a1);
/*FORMAL_ARG_LIST*/T0*r367error_handler(void);
/*FORMAL_ARG_LIST*/T0*r367omitted_open_arguments(T367*C,T0*a1,T0*a2,T351 a3);
/*FORMAL_ARG_LIST*/T2 r367count(T367*C);
/*LOCAL_VAR_LIST*/void r407make(T407*C,T351 a1,T0*a2);
/*LOCAL_VAR_LIST*/void r407pretty(T407*C);
/*LOCAL_VAR_LIST*/T0*r407specialize_in(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/T2 r407rank_of(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/void r407add_last(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/T0*r407specialize_thru(T407*C,T0*a1,T0*a2,T0*a3);
/*LOCAL_VAR_LIST*/T0*r407name(T407*C,T2 a1);
/*LOCAL_VAR_LIST*/void r407accept(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/T0*r407adapt_for(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/T2 r407fast_rank_of(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/void r407name_clash_check(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/T2 r407compute_flat_list_count_by_using_list(T407*C);
/*LOCAL_VAR_LIST*/void r407collect(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/T0*r407twin(T407*C);
/*LOCAL_VAR_LIST*/T0*r407type_mark(T407*C,T2 a1);
/*LOCAL_VAR_LIST*/T6 r407side_effect_free(T407*C,T0*a1);
/*LOCAL_VAR_LIST*/T0*r407error_handler(void);
/*LOCAL_VAR_LIST*/T2 r407count(T407*C);
/*FEATURE_TEXT*/void r462character_constant(T462*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_TEXT*/void r462string_constant(T462*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_TEXT*/void r462once_function(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T0*a9,T0*a10,T6 a11);
/*FEATURE_TEXT*/void r462set_ensure_assertion(T462*C,T0*a1);
/*FEATURE_TEXT*/void r462set_rescue_compound(T462*C,T0*a1);
/*FEATURE_TEXT*/void r462real_constant(T462*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_TEXT*/void r462inline_agent_pretty(T462*C,T2 a1);
/*FEATURE_TEXT*/void r462non_written_one(T462*C,T0*a1,T0*a2,T0*a3);
/*FEATURE_TEXT*/void r462set_inline_agent(T462*C,T0*a1,T0*a2);
/*FEATURE_TEXT*/void r462boolean_constant(T462*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_TEXT*/void r462set_header_comment(T462*C,T0*a1);
/*FEATURE_TEXT*/void r462deferred_function(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7);
/*FEATURE_TEXT*/void r462external_procedure(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T0*a9);
/*FEATURE_TEXT*/void r462add_into(T462*C,T0*a1,T0*a2);
/*FEATURE_TEXT*/void r462e_procedure(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T0*a9,T6 a10);
/*FEATURE_TEXT*/T0*r462error_handler(void);
/*FEATURE_TEXT*/void r462integer_constant(T462*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_TEXT*/void r462external_function(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T0*a9);
/*FEATURE_TEXT*/void r462writable_attribute(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*FEATURE_TEXT*/void r462set_sedb_trace_before_exit(T462*C,T351 a1);
/*FEATURE_TEXT*/void r462e_function(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T0*a9,T0*a10,T6 a11);
/*FEATURE_TEXT*/void r462deferred_procedure(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7);
/*FEATURE_TEXT*/void r462once_procedure(T462*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T0*a9,T6 a10);
/*FEATURE_TEXT*/void r462unique_constant(T462*C,T0*a1,T0*a2,T0*a3);
/*INDEX_CLAUSE*/void r433pretty(T433*C,T2 a1);
/*INDEX_CLAUSE*/void r433add_last(T433*C,T0*a1);
/*INDEX_CLAUSE*/void r433with_tag(T433*C,T0*a1,T0*a2);
/*INDEX_CLAUSE*/void r433without_tag(T433*C,T0*a1,T0*a2);
/*MANIFEST_STRING*/T0*r395specialize_and_check(T395*C,T0*a1);
/*MANIFEST_STRING*/T6 r395is_equal(T395*C,T0*a1);
/*MANIFEST_STRING*/T0*r395to_expression(T395*C);
/*MANIFEST_STRING*/void r395make(T395*C,T351 a1,T6 a2,T6 a3,T0*a4);
/*MANIFEST_STRING*/void r395pretty(T395*C,T2 a1);
/*MANIFEST_STRING*/T0*r395static_simplify(T395*C);
/*MANIFEST_STRING*/void r395inline_dynamic_dispatch_(T395*C,T0*a1,T0*a2);
/*MANIFEST_STRING*/T6 r395is_static(T395*C);
/*MANIFEST_STRING*/void r395storage_alias_of(T395*C,T0*a1);
/*MANIFEST_STRING*/T6 r395is_stored_in_some_local_variable(void);
/*MANIFEST_STRING*/void r395accept(T395*C,T0*a1);
/*MANIFEST_STRING*/T0*r395declaration_type(T395*C);
/*MANIFEST_STRING*/T0*r395collect(T395*C,T0*a1);
/*MANIFEST_STRING*/void r395pretty_target(T395*C,T2 a1);
/*MANIFEST_STRING*/void r395from_identifier(T395*C,T351 a1,T0*a2);
/*MANIFEST_STRING*/void r395pretty_without_once(T395*C,T2 a1);
/*MANIFEST_STRING*/T0*r395twin(T395*C);
/*MANIFEST_STRING*/T0*r395written_declaration_type_mark(T395*C);
/*MANIFEST_STRING*/T6 r395use_current(T0*a1);
/*MANIFEST_STRING*/void r395bracketed_pretty(T395*C,T2 a1);
/*MANIFEST_STRING*/T0*r395non_void_no_dispatch_type(T395*C,T0*a1);
/*MANIFEST_STRING*/T6 r395side_effect_free(T395*C,T0*a1);
/*MANIFEST_STRING*/T0*r395error_handler(void);
/*MANIFEST_STRING*/T2 r395hash_code(T395*C);
/*MANIFEST_STRING*/T2 r395count(T395*C);
/*MANIFEST_STRING*/T0*r395resolve_in(T395*C,T0*a1);
/*MANIFEST_STRING*/T0*r395to_instruction(T395*C);
/*FORMAL_GENERIC_LIST*/void r439make(T439*C,T351 a1);
/*FORMAL_GENERIC_LIST*/void r439generic_formal_arguments_check(T439*C);
/*FORMAL_GENERIC_LIST*/void r439constraint_genericity_check(T439*C,T0*a1,T0*a2,T351 a3);
/*FORMAL_GENERIC_LIST*/void r439add_last(T439*C,T0*a1);
/*FORMAL_GENERIC_LIST*/T0*r439error_handler(void);
/*FORMAL_GENERIC_LIST*/T2 r439count(T439*C);
/*FORMAL_GENERIC_ARG*/void r440substitute(T0*a1,T0*a2,T2 a3,T0*a4);
/*FORMAL_GENERIC_ARG*/void r440make(T440*C,T0*a1,T0*a2);
extern T0*oBC440class_name_cache;
extern int fBC440class_name_cache;
/*FORMAL_GENERIC_ARG*/T0*r440class_name_cache(void);
/*FORMAL_GENERIC_ARG*/void r440generic_formal_arguments_check(T440*C);
/*FORMAL_GENERIC_ARG*/T351 r440start_position(T440*C);
/*FORMAL_GENERIC_ARG*/T0*r440error_handler(void);
/*FORMAL_GENERIC_ARG*/void r440constraint_substitution(T440*C,T0*a1,T2 a2);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505declaration_type(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_agent(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505generic_list(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505long_name(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505written_mark(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505resolve_in(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505at(T505*C,T351 a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505class_text_name(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_equal(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/void r505specialize_in(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_native_array(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505type(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_pointer(void);
/*FORMAL_GENERIC_TYPE_MARK*/T2 r505id(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505specialize_thru(T505*C,T0*a1,T0*a2,T0*a3);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_real(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_fixed_string(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_empty_expanded(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505try_class_text(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505same_signature_type(T505*C,T0*a1,T0*a2);
/*FORMAL_GENERIC_TYPE_MARK*/void r505err_nonstatic(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_anchored(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_natural(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_integer(void);
/*FORMAL_GENERIC_TYPE_MARK*/void r505make(T505*C,T0*a1,T0*a2,T2 a3);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_character(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_expanded(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_kernel_expanded(void);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505default_expression(T505*C,T351 a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505to_static(T505*C,T0*a1,T6 a2);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_reference(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505signature_resolve_in(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_generic(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505twin(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/void r505id_extra_information(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505weak_reference_argument(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_user_expanded(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/void r505set_start_position(T505*C,T351 a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505class_text(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505error_handler(void);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_boolean(void);
/*FORMAL_GENERIC_TYPE_MARK*/void r505accept(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505typed_internals_type_mark(T505*C,T351 a1);
/*FORMAL_GENERIC_TYPE_MARK*/T6 r505is_tuple(void);
/*FORMAL_GENERIC_TYPE_MARK*/void r505pretty_in(T505*C,T0*a1);
/*FORMAL_GENERIC_TYPE_MARK*/T0*r505formal_generic_creation(T505*C);
/*FORMAL_GENERIC_TYPE_MARK*/T351 r505start_position(T505*C);
/*LIKE_CURRENT_TYPE_MARK*/T514*create514make(T351 a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_equal(T514*C,T0*a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_tuple(void);
/*LIKE_CURRENT_TYPE_MARK*/void r514make(T514*C,T351 a1);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514generic_list(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_anchored(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_character(void);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514written_mark(void);
extern T0*oBC514written_name;
extern int fBC514written_name;
/*LIKE_CURRENT_TYPE_MARK*/T0*r514written_name(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_native_array(void);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514at(T514*C,T351 a1);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514try_class_text(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514long_name(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_expanded(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_boolean(void);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514typed_internals_type_mark(T514*C,T351 a1);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514to_static(T0*a1,T6 a2);
/*LIKE_CURRENT_TYPE_MARK*/T2 r514id(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/void r514accept(T514*C,T0*a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_reference(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514same_signature_type(T514*C,T0*a1,T0*a2);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514type(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514signature_resolve_in(T0*a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_natural(void);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514default_expression(T514*C,T351 a1);
/*LIKE_CURRENT_TYPE_MARK*/void r514err_nonstatic(T514*C,T0*a1);
/*LIKE_CURRENT_TYPE_MARK*/void r514id_extra_information(T514*C,T0*a1);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514declaration_type(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514class_text_name(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_pointer(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_user_expanded(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_kernel_expanded(void);
/*LIKE_CURRENT_TYPE_MARK*/void r514set_start_position(T514*C,T351 a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_fixed_string(void);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514class_text(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514twin(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_real(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_integer(void);
/*LIKE_CURRENT_TYPE_MARK*/void r514pretty_in(T0*a1);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514weak_reference_argument(T514*C,T0*a1);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514error_handler(void);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_generic(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_empty_expanded(T514*C);
/*LIKE_CURRENT_TYPE_MARK*/T0*r514resolve_in(T0*a1);
/*LIKE_CURRENT_TYPE_MARK*/T6 r514is_agent(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_agent(void);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516generic_list(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516long_name(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516written_mark(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516resolve_in(T516*C,T0*a1);
/*LIKE_FEATURE_TYPE_MARK*/void r516twin_feature_stamp_memory(T516*C,T0*a1,T0*a2);
extern T0*oBC515written_mark_buffer;
extern int fBC515written_mark_buffer;
/*LIKE_FEATURE_TYPE_MARK*/T0*r516written_mark_buffer(void);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516at(T516*C,T351 a1);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516class_text_name(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_equal(T516*C,T0*a1);
/*LIKE_FEATURE_TYPE_MARK*/void r516specialize_in(T516*C,T0*a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_native_array(void);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516type(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_pointer(void);
/*LIKE_FEATURE_TYPE_MARK*/T2 r516id(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516specialize_thru(T516*C,T0*a1,T0*a2,T0*a3);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_real(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_fixed_string(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_empty_expanded(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516try_class_text(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516feature_accumulator(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516same_signature_type(T516*C,T0*a1,T0*a2);
/*LIKE_FEATURE_TYPE_MARK*/void r516err_nonstatic(T516*C,T0*a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_anchored(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_natural(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_integer(void);
/*LIKE_FEATURE_TYPE_MARK*/void r516make(T516*C,T351 a1,T0*a2);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_character(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_expanded(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_kernel_expanded(void);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516default_expression(T516*C,T351 a1);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516to_static(T516*C,T0*a1,T6 a2);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_reference(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516signature_resolve_in(T516*C,T0*a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_generic(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516twin(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/void r516id_extra_information(T516*C,T0*a1);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516weak_reference_argument(T516*C,T0*a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_user_expanded(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/void r516set_start_position(T516*C,T351 a1);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516class_text(T516*C);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516error_handler(void);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_boolean(void);
/*LIKE_FEATURE_TYPE_MARK*/void r516accept(T516*C,T0*a1);
/*LIKE_FEATURE_TYPE_MARK*/T0*r516typed_internals_type_mark(T516*C,T351 a1);
/*LIKE_FEATURE_TYPE_MARK*/T6 r516is_tuple(void);
/*LIKE_FEATURE_TYPE_MARK*/void r516pretty_in(T516*C,T0*a1);
/*PRETTY_PRINTER*/void r121make(T121*C);
/*PRETTY_PRINTER*/void r121prepare_for_same_line_comment(void);
/*PRETTY_PRINTER*/T6 r121print_end_of_statement(T121*C);
/*PRETTY_PRINTER*/void r121put_type_mark(T0*a1);
/*PRETTY_PRINTER*/void r121keyword(T0*a1);
extern T0*oBC121buffer;
extern int fBC121buffer;
/*PRETTY_PRINTER*/T0*r121buffer(void);
/*PRETTY_PRINTER*/void r121put_one_line_comment(T2 a1,T0*a2);
/*PRETTY_PRINTER*/void r121expression_in(T0*a1,T0*a2);
/*PRETTY_PRINTER*/void r121put_end_of(T0*a1);
extern T0*oBC121pretty_buffer;
extern int fBC121pretty_buffer;
/*PRETTY_PRINTER*/T0*r121pretty_buffer(void);
/*PRETTY_PRINTER*/void r121erase_everything_after(T2 a1);
/*PRETTY_PRINTER*/void r121set_semi_colon_flag(T121*C,T6 a1);
/*PRETTY_PRINTER*/void r121put_string(T0*a1);
/*PRETTY_PRINTER*/void r121left_margin_in(T0*a1);
/*PRETTY_PRINTER*/T6 r121is_opening_bracket_after(T2 a1);
/*PRETTY_PRINTER*/T3 r121last_non_blank_character(void);
/*PRETTY_PRINTER*/void r121code_in(T0*a1,T0*a2);
/*PRETTY_PRINTER*/T2 r121column(void);
/*PRETTY_PRINTER*/void r121erase_separators_after(T2 a1);
/*PRETTY_PRINTER*/void r121set_indent_level(T2 a1);
/*PRETTY_PRINTER*/T2 r121index_of_last_character(void);
/*PRETTY_PRINTER*/void r121put_character(T3 a1);
/*PRETTY_PRINTER*/void r121skip_one_line(void);
/*PRETTY_PRINTER*/T6 r121print_end_of_feature(T121*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517declaration_type(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_agent(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517generic_list(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517long_name(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517written_mark(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517resolve_in(T517*C,T0*a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517written_mark_buffer(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517at(T517*C,T351 a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517class_text_name(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_equal(T517*C,T0*a1);
/*LIKE_ARGUMENT_TYPE_MARK*/void r517specialize_in(T517*C,T0*a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_native_array(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517type(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_pointer(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T2 r517id(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517specialize_thru(T517*C,T0*a1,T0*a2,T0*a3);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_real(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_fixed_string(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_empty_expanded(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517try_class_text(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517same_signature_type(T517*C,T0*a1,T0*a2);
/*LIKE_ARGUMENT_TYPE_MARK*/void r517err_nonstatic(T517*C,T0*a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_anchored(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_natural(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_integer(void);
/*LIKE_ARGUMENT_TYPE_MARK*/void r517make(T517*C,T351 a1,T0*a2);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_character(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_expanded(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_kernel_expanded(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517default_expression(T517*C,T351 a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517to_static(T517*C,T0*a1,T6 a2);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_reference(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517signature_resolve_in(T517*C,T0*a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_generic(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517twin(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/void r517id_extra_information(T517*C,T0*a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517weak_reference_argument(T517*C,T0*a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_user_expanded(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/void r517set_start_position(T517*C,T351 a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517class_text(T517*C);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517error_handler(void);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_boolean(void);
/*LIKE_ARGUMENT_TYPE_MARK*/void r517accept(T517*C,T0*a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T0*r517typed_internals_type_mark(T517*C,T351 a1);
/*LIKE_ARGUMENT_TYPE_MARK*/T6 r517is_tuple(void);
/*LIKE_ARGUMENT_TYPE_MARK*/void r517pretty_in(T517*C,T0*a1);
/*ARRAY_TYPE_MARK*/void r458set_generic_list(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/T0*r458new_static_type_in(T458*C,T0*a1,T6 a2);
/*ARRAY_TYPE_MARK*/T0*r458declaration_type(T458*C);
/*ARRAY_TYPE_MARK*/T6 r458is_agent(void);
/*ARRAY_TYPE_MARK*/T0*r458long_name(T458*C);
/*ARRAY_TYPE_MARK*/T0*r458written_mark(T458*C);
/*ARRAY_TYPE_MARK*/T0*r458resolve_in(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/T0*r458at(T458*C,T351 a1);
/*ARRAY_TYPE_MARK*/T0*r458strings(void);
/*ARRAY_TYPE_MARK*/void r458set_generic_list_with(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/T6 r458is_equal(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/void r458specialize_in(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/T6 r458is_native_array(void);
/*ARRAY_TYPE_MARK*/T6 r458is_static(T458*C);
/*ARRAY_TYPE_MARK*/T0*r458type(T458*C);
/*ARRAY_TYPE_MARK*/T6 r458is_pointer(void);
/*ARRAY_TYPE_MARK*/T2 r458id(T458*C);
/*ARRAY_TYPE_MARK*/void r458recompute_declaration_type(T458*C);
/*ARRAY_TYPE_MARK*/T0*r458specialize_thru(T458*C,T0*a1,T0*a2,T0*a3);
/*ARRAY_TYPE_MARK*/T6 r458is_real(void);
/*ARRAY_TYPE_MARK*/T6 r458is_fixed_string(T458*C);
/*ARRAY_TYPE_MARK*/T0*r458try_class_text(T458*C);
/*ARRAY_TYPE_MARK*/T6 r458same_signature_type(T458*C,T0*a1,T0*a2);
/*ARRAY_TYPE_MARK*/T6 r458is_anchored(void);
/*ARRAY_TYPE_MARK*/T6 r458is_natural(void);
/*ARRAY_TYPE_MARK*/T6 r458is_integer(void);
/*ARRAY_TYPE_MARK*/void r458make(T458*C,T351 a1,T0*a2);
/*ARRAY_TYPE_MARK*/T6 r458is_character(void);
/*ARRAY_TYPE_MARK*/T6 r458is_kernel_expanded(void);
/*ARRAY_TYPE_MARK*/T0*r458written_name(T458*C);
/*ARRAY_TYPE_MARK*/T0*r458default_expression(T351 a1);
extern T0*oBC458array_name;
extern int fBC458array_name;
/*ARRAY_TYPE_MARK*/T0*r458array_name(void);
/*ARRAY_TYPE_MARK*/T0*r458to_static(T458*C,T0*a1,T6 a2);
/*ARRAY_TYPE_MARK*/T0*r458signature_resolve_in(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/T0*r458twin(T458*C);
/*ARRAY_TYPE_MARK*/void r458id_extra_information(T0*a1);
/*ARRAY_TYPE_MARK*/T0*r458weak_reference_argument(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/void r458set_start_position(T458*C,T351 a1);
/*ARRAY_TYPE_MARK*/T0*r458class_text(T458*C);
/*ARRAY_TYPE_MARK*/T0*r458error_handler(void);
/*ARRAY_TYPE_MARK*/T6 r458is_boolean(void);
/*ARRAY_TYPE_MARK*/void r458accept(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/void r458set_static_generic_list(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/void r458update_static_memory(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/T0*r458typed_internals_type_mark(T458*C,T351 a1);
/*ARRAY_TYPE_MARK*/T6 r458is_tuple(void);
/*ARRAY_TYPE_MARK*/void r458pretty_in(T458*C,T0*a1);
/*ARRAY_TYPE_MARK*/T351 r458start_position(T458*C);
/*NATIVE_ARRAY_TYPE_MARK*/void r423set_generic_list(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423new_static_type_in(T423*C,T0*a1,T6 a2);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423declaration_type(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_agent(void);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423long_name(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423written_mark(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423resolve_in(T423*C,T0*a1);
extern T0*oBC423native_array_name;
extern int fBC423native_array_name;
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423native_array_name(void);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423at(T423*C,T351 a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423strings(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_equal(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r423specialize_in(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_native_array(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_static(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423type(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_pointer(void);
/*NATIVE_ARRAY_TYPE_MARK*/T2 r423id(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423elements_type(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/void r423recompute_declaration_type(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423specialize_thru(T423*C,T0*a1,T0*a2,T0*a3);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_real(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_fixed_string(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423try_class_text(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423same_signature_type(T423*C,T0*a1,T0*a2);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_anchored(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_natural(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_integer(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r423make(T423*C,T351 a1,T0*a2);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_character(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_kernel_expanded(void);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423written_name(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423default_expression(T423*C,T351 a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423to_static(T423*C,T0*a1,T6 a2);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423signature_resolve_in(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423twin(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/void r423id_extra_information(T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423weak_reference_argument(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r423set_start_position(T423*C,T351 a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423class_text(T423*C);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423error_handler(void);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_boolean(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r423accept(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r423set_static_generic_list(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/void r423update_static_memory(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/T0*r423typed_internals_type_mark(T423*C,T351 a1);
/*NATIVE_ARRAY_TYPE_MARK*/T6 r423is_tuple(void);
/*NATIVE_ARRAY_TYPE_MARK*/void r423pretty_in(T423*C,T0*a1);
/*NATIVE_ARRAY_TYPE_MARK*/T351 r423start_position(T423*C);
/*WEAK_REFERENCE_TYPE_MARK*/void r480set_generic_list(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480new_static_type_in(T480*C,T0*a1,T6 a2);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480declaration_type(T480*C);
extern T0*oBC480weak_reference_name;
extern int fBC480weak_reference_name;
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480weak_reference_name(void);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_agent(void);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480long_name(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480written_mark(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480resolve_in(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480at(T480*C,T351 a1);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480strings(void);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_equal(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/void r480specialize_in(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_native_array(void);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_static(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480type(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_pointer(void);
/*WEAK_REFERENCE_TYPE_MARK*/T2 r480id(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/void r480recompute_declaration_type(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480specialize_thru(T480*C,T0*a1,T0*a2,T0*a3);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_real(void);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_fixed_string(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480try_class_text(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/void r480special_weak_reference_extra_check(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480same_signature_type(T480*C,T0*a1,T0*a2);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_anchored(void);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_natural(void);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_integer(void);
/*WEAK_REFERENCE_TYPE_MARK*/void r480make(T480*C,T351 a1,T0*a2);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_character(void);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_kernel_expanded(void);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480written_name(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480default_expression(T351 a1);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480to_static(T480*C,T0*a1,T6 a2);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480signature_resolve_in(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480twin(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/void r480id_extra_information(T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480weak_reference_argument(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/void r480set_start_position(T480*C,T351 a1);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480class_text(T480*C);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480error_handler(void);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_boolean(void);
/*WEAK_REFERENCE_TYPE_MARK*/void r480accept(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/void r480set_static_generic_list(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/void r480update_static_memory(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/T0*r480typed_internals_type_mark(T480*C,T351 a1);
/*WEAK_REFERENCE_TYPE_MARK*/T6 r480is_tuple(void);
/*WEAK_REFERENCE_TYPE_MARK*/void r480pretty_in(T480*C,T0*a1);
/*WEAK_REFERENCE_TYPE_MARK*/T351 r480start_position(T480*C);
/*CLASS_TYPE_MARK*/T418*create418make(T0*a1);
/*CLASS_TYPE_MARK*/T0*r418declaration_type(T418*C);
/*CLASS_TYPE_MARK*/T6 r418is_agent(void);
/*CLASS_TYPE_MARK*/T0*r418generic_list(void);
/*CLASS_TYPE_MARK*/T0*r418canonical_long_name(T418*C);
/*CLASS_TYPE_MARK*/T0*r418written_mark(T418*C);
/*CLASS_TYPE_MARK*/T0*r418resolve_in(T418*C,T0*a1);
/*CLASS_TYPE_MARK*/T0*r418at(T418*C,T351 a1);
/*CLASS_TYPE_MARK*/T6 r418is_equal(T418*C,T0*a1);
/*CLASS_TYPE_MARK*/T6 r418is_native_array(void);
/*CLASS_TYPE_MARK*/T0*r418type(T418*C);
/*CLASS_TYPE_MARK*/T6 r418is_pointer(void);
/*CLASS_TYPE_MARK*/T2 r418id(T418*C);
/*CLASS_TYPE_MARK*/T0*r418specialize_thru(T418*C,T0*a1,T0*a2,T0*a3);
/*CLASS_TYPE_MARK*/T6 r418is_real(void);
/*CLASS_TYPE_MARK*/T6 r418is_fixed_string(T418*C);
/*CLASS_TYPE_MARK*/T0*r418try_class_text(T418*C);
/*CLASS_TYPE_MARK*/T6 r418is_user_empty_expanded(T418*C);
/*CLASS_TYPE_MARK*/T6 r418same_signature_type(T418*C,T0*a1,T0*a2);
/*CLASS_TYPE_MARK*/T6 r418is_anchored(void);
/*CLASS_TYPE_MARK*/T6 r418is_natural(void);
/*CLASS_TYPE_MARK*/T6 r418is_integer(void);
/*CLASS_TYPE_MARK*/void r418make(T418*C,T0*a1);
/*CLASS_TYPE_MARK*/T6 r418is_character(void);
/*CLASS_TYPE_MARK*/T6 r418is_expanded(T418*C);
/*CLASS_TYPE_MARK*/T6 r418is_kernel_expanded(void);
/*CLASS_TYPE_MARK*/T0*r418written_name(T418*C);
/*CLASS_TYPE_MARK*/T0*r418default_expression(T418*C,T351 a1);
/*CLASS_TYPE_MARK*/T0*r418to_static(T418*C,T0*a1,T6 a2);
/*CLASS_TYPE_MARK*/T6 r418is_reference(T418*C);
/*CLASS_TYPE_MARK*/T0*r418signature_resolve_in(T418*C,T0*a1);
/*CLASS_TYPE_MARK*/T0*r418twin(T418*C);
/*CLASS_TYPE_MARK*/T6 r418is_user_expanded(T418*C);
/*CLASS_TYPE_MARK*/void r418id_extra_information(T418*C,T0*a1);
/*CLASS_TYPE_MARK*/T0*r418weak_reference_argument(T418*C,T0*a1);
/*CLASS_TYPE_MARK*/void r418set_start_position(T418*C,T351 a1);
/*CLASS_TYPE_MARK*/T0*r418class_text(T418*C);
/*CLASS_TYPE_MARK*/T0*r418error_handler(void);
/*CLASS_TYPE_MARK*/T6 r418is_boolean(void);
/*CLASS_TYPE_MARK*/void r418accept(T418*C,T0*a1);
/*CLASS_TYPE_MARK*/T0*r418typed_internals_type_mark(T418*C,T351 a1);
/*CLASS_TYPE_MARK*/T6 r418is_tuple(void);
/*CLASS_TYPE_MARK*/void r418pretty_in(T418*C,T0*a1);
/*CLASS_TYPE_MARK*/T351 r418start_position(T418*C);
/*REAL_TYPE_MARK*/T449*create449real_32(T351 a1);
/*REAL_TYPE_MARK*/T449*create449real_extended(T351 a1);
/*REAL_TYPE_MARK*/T449*create449real(T351 a1);
/*REAL_TYPE_MARK*/T0*r449declaration_type(T449*C);
/*REAL_TYPE_MARK*/T6 r449is_agent(void);
/*REAL_TYPE_MARK*/T0*r449generic_list(void);
extern T0*oBC449real_80_name;
extern int fBC449real_80_name;
/*REAL_TYPE_MARK*/T0*r449real_80_name(void);
/*REAL_TYPE_MARK*/T0*r449written_mark(T449*C);
/*REAL_TYPE_MARK*/T0*r449resolve_in(T449*C,T0*a1);
/*REAL_TYPE_MARK*/T0*r449at(T449*C,T351 a1);
/*REAL_TYPE_MARK*/T6 r449is_equal(T449*C,T0*a1);
/*REAL_TYPE_MARK*/T6 r449is_native_array(void);
/*REAL_TYPE_MARK*/T3 r449structure_mark(T449*C);
extern T0*oBC449real_64_name;
extern int fBC449real_64_name;
/*REAL_TYPE_MARK*/T0*r449real_64_name(void);
/*REAL_TYPE_MARK*/T0*r449type(T449*C);
/*REAL_TYPE_MARK*/T6 r449is_pointer(void);
/*REAL_TYPE_MARK*/T2 r449id(T449*C);
extern T0*oBC449real_128_name;
extern int fBC449real_128_name;
/*REAL_TYPE_MARK*/T0*r449real_128_name(void);
/*REAL_TYPE_MARK*/T0*r449specialize_thru(T449*C,T0*a1,T0*a2,T0*a3);
/*REAL_TYPE_MARK*/T6 r449is_real(void);
/*REAL_TYPE_MARK*/T6 r449is_fixed_string(T449*C);
/*REAL_TYPE_MARK*/T0*r449try_class_text(T449*C);
/*REAL_TYPE_MARK*/T6 r449same_signature_type(T449*C,T0*a1,T0*a2);
/*REAL_TYPE_MARK*/T6 r449is_anchored(void);
/*REAL_TYPE_MARK*/T6 r449can_be_assigned_to(T449*C,T0*a1);
/*REAL_TYPE_MARK*/T6 r449is_natural(void);
extern T0*oBC449real_name;
extern int fBC449real_name;
/*REAL_TYPE_MARK*/T0*r449real_name(void);
/*REAL_TYPE_MARK*/T6 r449is_integer(void);
extern T0*oBC449real_32_name;
extern int fBC449real_32_name;
/*REAL_TYPE_MARK*/T0*r449real_32_name(void);
/*REAL_TYPE_MARK*/T6 r449is_character(void);
/*REAL_TYPE_MARK*/T6 r449is_kernel_expanded(void);
/*REAL_TYPE_MARK*/T0*r449written_name(T449*C);
/*REAL_TYPE_MARK*/T0*r449default_expression(T449*C,T351 a1);
/*REAL_TYPE_MARK*/void r449real_32(T449*C,T351 a1);
/*REAL_TYPE_MARK*/T0*r449to_static(T449*C,T0*a1,T6 a2);
/*REAL_TYPE_MARK*/void r449real_64(T449*C,T351 a1);
/*REAL_TYPE_MARK*/T0*r449signature_resolve_in(T449*C,T0*a1);
/*REAL_TYPE_MARK*/void r449real_80(T449*C,T351 a1);
extern T0*oBC449real_extended_name;
extern int fBC449real_extended_name;
/*REAL_TYPE_MARK*/T0*r449real_extended_name(void);
/*REAL_TYPE_MARK*/void r449real_extended(T449*C,T351 a1);
/*REAL_TYPE_MARK*/T0*r449twin(T449*C);
/*REAL_TYPE_MARK*/void r449id_extra_information(T0*a1);
/*REAL_TYPE_MARK*/T0*r449weak_reference_argument(T449*C,T0*a1);
/*REAL_TYPE_MARK*/void r449set_start_position(T449*C,T351 a1);
/*REAL_TYPE_MARK*/T0*r449class_text(T449*C);
/*REAL_TYPE_MARK*/T0*r449error_handler(void);
/*REAL_TYPE_MARK*/T6 r449is_boolean(void);
/*REAL_TYPE_MARK*/void r449accept(T449*C,T0*a1);
/*REAL_TYPE_MARK*/T0*r449typed_internals_type_mark(T449*C,T351 a1);
/*REAL_TYPE_MARK*/T6 r449is_tuple(void);
/*REAL_TYPE_MARK*/void r449pretty_in(T449*C,T0*a1);
/*REAL_TYPE_MARK*/T351 r449start_position(T449*C);
/*REAL_TYPE_MARK*/void r449real_128(T449*C,T351 a1);
/*REAL_TYPE_MARK*/void r449real(T449*C,T351 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455set_generic_list(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455new_static_type_in(T455*C,T0*a1,T6 a2);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455declaration_type(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_agent(void);
extern T0*oBC454canonical_long_name;
extern int fBC454canonical_long_name;
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455canonical_long_name(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455long_name(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455written_mark(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455resolve_in(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T2 r455count(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455at(T455*C,T351 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455strings(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_equal(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455specialize_in(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_native_array(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_static(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455type(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_pointer(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T2 r455id(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455recompute_declaration_type(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455specialize_thru(T455*C,T0*a1,T0*a2,T0*a3);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_real(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_fixed_string(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455try_class_text(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455same_signature_type(T455*C,T0*a1,T0*a2);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_anchored(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_natural(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_integer(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455make(T455*C,T351 a1,T0*a2);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_character(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_kernel_expanded(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455written_name(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455default_expression(T351 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455to_static(T455*C,T0*a1,T6 a2);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455signature_resolve_in(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455twin(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455id_extra_information(T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455weak_reference_argument(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455set_start_position(T455*C,T351 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455class_text(T455*C);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455error_handler(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T6 r455is_boolean(void);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455accept(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455set_static_generic_list(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455update_static_memory(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T0*r455typed_internals_type_mark(T455*C,T351 a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/void r455pretty_in(T455*C,T0*a1);
/*NON_EMPTY_TUPLE_TYPE_MARK*/T351 r455start_position(T455*C);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_equal(T453*C,T0*a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r453make(T453*C,T351 a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453generic_list(void);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_anchored(void);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_character(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453written_mark(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453canonical_long_name(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453written_name(void);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_native_array(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453at(T453*C,T351 a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453try_class_text(T453*C);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453specialize_thru(T453*C,T0*a1,T0*a2,T0*a3);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_boolean(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453typed_internals_type_mark(T453*C,T351 a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453to_static(T453*C,T0*a1,T6 a2);
/*EMPTY_TUPLE_TYPE_MARK*/T2 r453id(T453*C);
/*EMPTY_TUPLE_TYPE_MARK*/void r453accept(T453*C,T0*a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453same_signature_type(T453*C,T0*a1,T0*a2);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453type(T453*C);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453signature_resolve_in(T453*C,T0*a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_natural(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453default_expression(T351 a1);
/*EMPTY_TUPLE_TYPE_MARK*/void r453id_extra_information(T0*a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453declaration_type(T453*C);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_pointer(void);
/*EMPTY_TUPLE_TYPE_MARK*/T351 r453start_position(T453*C);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_kernel_expanded(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r453set_start_position(T453*C,T351 a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_fixed_string(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453class_text(T453*C);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453twin(T453*C);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_real(void);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_integer(void);
/*EMPTY_TUPLE_TYPE_MARK*/void r453pretty_in(T0*a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453weak_reference_argument(T453*C,T0*a1);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453error_handler(void);
/*EMPTY_TUPLE_TYPE_MARK*/T0*r453resolve_in(T453*C,T0*a1);
/*EMPTY_TUPLE_TYPE_MARK*/T6 r453is_agent(void);
/*AGENT_TYPE_MARK*/void r456set_generic_list(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/T0*r456new_static_type_in(T456*C,T0*a1,T6 a2);
/*AGENT_TYPE_MARK*/T0*r456declaration_type(T456*C);
/*AGENT_TYPE_MARK*/T6 r456is_agent(void);
/*AGENT_TYPE_MARK*/T0*r456canonical_long_name(T456*C);
/*AGENT_TYPE_MARK*/T0*r456long_name(T456*C);
/*AGENT_TYPE_MARK*/T0*r456written_mark(T456*C);
/*AGENT_TYPE_MARK*/T0*r456resolve_in(T456*C,T0*a1);
extern T0*oBC456function_name;
extern int fBC456function_name;
/*AGENT_TYPE_MARK*/T0*r456function_name(void);
/*AGENT_TYPE_MARK*/T0*r456at(T456*C,T351 a1);
/*AGENT_TYPE_MARK*/void r456common_make(T456*C,T2 a1,T0*a2,T0*a3);
/*AGENT_TYPE_MARK*/T0*r456written_open(T456*C);
/*AGENT_TYPE_MARK*/T0*r456strings(void);
/*AGENT_TYPE_MARK*/void r456procedure(T456*C,T351 a1,T0*a2);
/*AGENT_TYPE_MARK*/T6 r456is_equal(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/void r456specialize_in(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/T6 r456is_native_array(void);
extern T0*oBC456routine_name;
extern int fBC456routine_name;
/*AGENT_TYPE_MARK*/T0*r456routine_name(void);
/*AGENT_TYPE_MARK*/T6 r456is_static(T456*C);
/*AGENT_TYPE_MARK*/T0*r456type(T456*C);
/*AGENT_TYPE_MARK*/T6 r456is_pointer(void);
/*AGENT_TYPE_MARK*/T2 r456id(T456*C);
/*AGENT_TYPE_MARK*/void r456recompute_declaration_type(T456*C);
/*AGENT_TYPE_MARK*/T0*r456specialize_thru(T456*C,T0*a1,T0*a2,T0*a3);
/*AGENT_TYPE_MARK*/T6 r456is_real(void);
/*AGENT_TYPE_MARK*/T6 r456is_fixed_string(T456*C);
/*AGENT_TYPE_MARK*/T0*r456try_class_text(T456*C);
/*AGENT_TYPE_MARK*/T6 r456same_signature_type(T456*C,T0*a1,T0*a2);
/*AGENT_TYPE_MARK*/T6 r456is_anchored(void);
/*AGENT_TYPE_MARK*/T6 r456is_natural(void);
/*AGENT_TYPE_MARK*/T6 r456is_integer(void);
/*AGENT_TYPE_MARK*/T6 r456is_character(void);
/*AGENT_TYPE_MARK*/T0*r456result_type(T456*C);
/*AGENT_TYPE_MARK*/void r456predicate(T456*C,T351 a1,T0*a2);
/*AGENT_TYPE_MARK*/T6 r456is_kernel_expanded(void);
/*AGENT_TYPE_MARK*/void r456routine(T456*C,T351 a1,T0*a2);
/*AGENT_TYPE_MARK*/T0*r456written_name(T456*C);
/*AGENT_TYPE_MARK*/T0*r456default_expression(T351 a1);
/*AGENT_TYPE_MARK*/T0*r456to_static(T456*C,T0*a1,T6 a2);
extern T0*oBC456procedure_name;
extern int fBC456procedure_name;
/*AGENT_TYPE_MARK*/T0*r456procedure_name(void);
/*AGENT_TYPE_MARK*/void r456open_check(T456*C,T0*a1,T0*a2);
/*AGENT_TYPE_MARK*/T0*r456signature_resolve_in(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/T0*r456twin(T456*C);
/*AGENT_TYPE_MARK*/void r456id_extra_information(T0*a1);
/*AGENT_TYPE_MARK*/T0*r456weak_reference_argument(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/void r456set_start_position(T456*C,T351 a1);
/*AGENT_TYPE_MARK*/T0*r456class_text(T456*C);
/*AGENT_TYPE_MARK*/void r456function(T456*C,T351 a1,T0*a2,T0*a3);
/*AGENT_TYPE_MARK*/T0*r456error_handler(void);
/*AGENT_TYPE_MARK*/T6 r456is_boolean(void);
/*AGENT_TYPE_MARK*/void r456accept(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/void r456set_static_generic_list(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/void r456update_static_memory(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/T0*r456typed_internals_type_mark(T456*C,T351 a1);
/*AGENT_TYPE_MARK*/T6 r456is_tuple(void);
/*AGENT_TYPE_MARK*/void r456pretty_in(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/T351 r456start_position(T456*C);
/*AGENT_TYPE_MARK*/void r456_P_424_specialize_in(T456*C,T0*a1);
/*AGENT_TYPE_MARK*/T0*r456_P_424_specialize_thru(T456*C,T0*a1,T0*a2,T0*a3);
/*BOOLEAN_TYPE_MARK*/T396*create396make(T351 a1);
/*BOOLEAN_TYPE_MARK*/T6 r396is_equal(T396*C,T0*a1);
/*BOOLEAN_TYPE_MARK*/T6 r396is_tuple(void);
/*BOOLEAN_TYPE_MARK*/void r396make(T396*C,T351 a1);
/*BOOLEAN_TYPE_MARK*/T0*r396generic_list(void);
/*BOOLEAN_TYPE_MARK*/T6 r396is_anchored(void);
/*BOOLEAN_TYPE_MARK*/T6 r396is_character(void);
/*BOOLEAN_TYPE_MARK*/T0*r396written_mark(void);
extern T0*oBC396written_name;
extern int fBC396written_name;
/*BOOLEAN_TYPE_MARK*/T0*r396written_name(void);
/*BOOLEAN_TYPE_MARK*/T6 r396is_native_array(void);
/*BOOLEAN_TYPE_MARK*/T0*r396at(T396*C,T351 a1);
/*BOOLEAN_TYPE_MARK*/T0*r396try_class_text(T396*C);
extern T0*oBC396long_name;
extern int fBC396long_name;
/*BOOLEAN_TYPE_MARK*/T0*r396long_name(void);
/*BOOLEAN_TYPE_MARK*/T0*r396specialize_thru(T396*C,T0*a1,T0*a2,T0*a3);
/*BOOLEAN_TYPE_MARK*/T6 r396is_boolean(void);
/*BOOLEAN_TYPE_MARK*/T0*r396typed_internals_type_mark(T396*C,T351 a1);
/*BOOLEAN_TYPE_MARK*/T0*r396to_static(T396*C,T0*a1,T6 a2);
/*BOOLEAN_TYPE_MARK*/void r396accept(T396*C,T0*a1);
/*BOOLEAN_TYPE_MARK*/T6 r396same_signature_type(T396*C,T0*a1,T0*a2);
/*BOOLEAN_TYPE_MARK*/T0*r396type(void);
/*BOOLEAN_TYPE_MARK*/T0*r396signature_resolve_in(T0*a1);
/*BOOLEAN_TYPE_MARK*/T6 r396is_natural(void);
/*BOOLEAN_TYPE_MARK*/T0*r396default_expression(T351 a1);
/*BOOLEAN_TYPE_MARK*/void r396id_extra_information(T0*a1);
/*BOOLEAN_TYPE_MARK*/T0*r396declaration_type(T396*C);
/*BOOLEAN_TYPE_MARK*/T6 r396is_pointer(void);
/*BOOLEAN_TYPE_MARK*/T351 r396start_position(T396*C);
/*BOOLEAN_TYPE_MARK*/T6 r396is_kernel_expanded(void);
/*BOOLEAN_TYPE_MARK*/void r396set_start_position(T396*C,T351 a1);
/*BOOLEAN_TYPE_MARK*/T6 r396is_fixed_string(void);
/*BOOLEAN_TYPE_MARK*/T0*r396class_text(T396*C);
/*BOOLEAN_TYPE_MARK*/T0*r396twin(T396*C);
/*BOOLEAN_TYPE_MARK*/T6 r396is_real(void);
/*BOOLEAN_TYPE_MARK*/T6 r396is_integer(void);
/*BOOLEAN_TYPE_MARK*/void r396pretty_in(T0*a1);
/*BOOLEAN_TYPE_MARK*/T0*r396weak_reference_argument(T396*C,T0*a1);
/*BOOLEAN_TYPE_MARK*/T0*r396error_handler(void);
/*BOOLEAN_TYPE_MARK*/T0*r396resolve_in(T0*a1);
/*BOOLEAN_TYPE_MARK*/T6 r396is_agent(void);
/*CHARACTER_TYPE_MARK*/T450*create450make(T351 a1);
/*CHARACTER_TYPE_MARK*/T6 r450is_equal(T450*C,T0*a1);
/*CHARACTER_TYPE_MARK*/T6 r450is_tuple(void);
/*CHARACTER_TYPE_MARK*/void r450make(T450*C,T351 a1);
/*CHARACTER_TYPE_MARK*/T0*r450generic_list(void);
/*CHARACTER_TYPE_MARK*/T6 r450is_anchored(void);
/*CHARACTER_TYPE_MARK*/T6 r450is_character(void);
/*CHARACTER_TYPE_MARK*/T0*r450written_mark(void);
extern T0*oBC450written_name;
extern int fBC450written_name;
/*CHARACTER_TYPE_MARK*/T0*r450written_name(void);
/*CHARACTER_TYPE_MARK*/T6 r450is_native_array(void);
/*CHARACTER_TYPE_MARK*/T0*r450at(T450*C,T351 a1);
/*CHARACTER_TYPE_MARK*/T0*r450try_class_text(T450*C);
extern T0*oBC450long_name;
extern int fBC450long_name;
/*CHARACTER_TYPE_MARK*/T0*r450long_name(void);
/*CHARACTER_TYPE_MARK*/T0*r450specialize_thru(T450*C,T0*a1,T0*a2,T0*a3);
/*CHARACTER_TYPE_MARK*/T6 r450is_boolean(void);
/*CHARACTER_TYPE_MARK*/T0*r450typed_internals_type_mark(T450*C,T351 a1);
/*CHARACTER_TYPE_MARK*/T0*r450to_static(T450*C,T0*a1,T6 a2);
/*CHARACTER_TYPE_MARK*/void r450accept(T450*C,T0*a1);
/*CHARACTER_TYPE_MARK*/T6 r450same_signature_type(T450*C,T0*a1,T0*a2);
/*CHARACTER_TYPE_MARK*/T0*r450type(void);
/*CHARACTER_TYPE_MARK*/T0*r450signature_resolve_in(T0*a1);
/*CHARACTER_TYPE_MARK*/T6 r450is_natural(void);
/*CHARACTER_TYPE_MARK*/T0*r450default_expression(T351 a1);
/*CHARACTER_TYPE_MARK*/void r450id_extra_information(T0*a1);
/*CHARACTER_TYPE_MARK*/T0*r450declaration_type(T450*C);
/*CHARACTER_TYPE_MARK*/T6 r450is_pointer(void);
/*CHARACTER_TYPE_MARK*/T351 r450start_position(T450*C);
/*CHARACTER_TYPE_MARK*/T6 r450is_kernel_expanded(void);
/*CHARACTER_TYPE_MARK*/void r450set_start_position(T450*C,T351 a1);
/*CHARACTER_TYPE_MARK*/T6 r450is_fixed_string(void);
/*CHARACTER_TYPE_MARK*/T0*r450class_text(T450*C);
/*CHARACTER_TYPE_MARK*/T0*r450twin(T450*C);
/*CHARACTER_TYPE_MARK*/T6 r450is_real(void);
/*CHARACTER_TYPE_MARK*/T6 r450is_integer(void);
/*CHARACTER_TYPE_MARK*/void r450pretty_in(T0*a1);
/*CHARACTER_TYPE_MARK*/T0*r450weak_reference_argument(T450*C,T0*a1);
/*CHARACTER_TYPE_MARK*/T0*r450error_handler(void);
/*CHARACTER_TYPE_MARK*/T0*r450resolve_in(T0*a1);
/*CHARACTER_TYPE_MARK*/T6 r450is_agent(void);
/*INTEGER_TYPE_MARK*/T422*create422integer_16(T351 a1);
/*INTEGER_TYPE_MARK*/T422*create422integer(T351 a1);
/*INTEGER_TYPE_MARK*/T422*create422integer_64(T351 a1);
/*INTEGER_TYPE_MARK*/T422*create422integer_8(T351 a1);
/*INTEGER_TYPE_MARK*/T422*create422integer_32(T351 a1);
/*INTEGER_TYPE_MARK*/T0*r422declaration_type(T422*C);
/*INTEGER_TYPE_MARK*/T6 r422is_agent(void);
/*INTEGER_TYPE_MARK*/T0*r422generic_list(void);
/*INTEGER_TYPE_MARK*/T0*r422written_mark(T422*C);
/*INTEGER_TYPE_MARK*/T0*r422resolve_in(T422*C,T0*a1);
/*INTEGER_TYPE_MARK*/T0*r422at(T422*C,T351 a1);
/*INTEGER_TYPE_MARK*/T6 r422is_equal(T422*C,T0*a1);
/*INTEGER_TYPE_MARK*/T6 r422is_native_array(void);
/*INTEGER_TYPE_MARK*/T3 r422structure_mark(T422*C);
/*INTEGER_TYPE_MARK*/T0*r422type(T422*C);
/*INTEGER_TYPE_MARK*/T6 r422is_pointer(void);
/*INTEGER_TYPE_MARK*/T2 r422id(T422*C);
/*INTEGER_TYPE_MARK*/void r422integer_16(T422*C,T351 a1);
/*INTEGER_TYPE_MARK*/void r422integer_32(T422*C,T351 a1);
/*INTEGER_TYPE_MARK*/T0*r422specialize_thru(T422*C,T0*a1,T0*a2,T0*a3);
/*INTEGER_TYPE_MARK*/T6 r422is_real(void);
/*INTEGER_TYPE_MARK*/T6 r422is_fixed_string(T422*C);
/*INTEGER_TYPE_MARK*/T0*r422try_class_text(T422*C);
extern T0*oBC422integer_64_name;
extern int fBC422integer_64_name;
/*INTEGER_TYPE_MARK*/T0*r422integer_64_name(void);
/*INTEGER_TYPE_MARK*/void r422integer(T422*C,T351 a1);
/*INTEGER_TYPE_MARK*/T6 r422same_signature_type(T422*C,T0*a1,T0*a2);
/*INTEGER_TYPE_MARK*/void r422integer_64(T422*C,T351 a1);
/*INTEGER_TYPE_MARK*/T6 r422is_anchored(void);
/*INTEGER_TYPE_MARK*/T6 r422can_be_assigned_to(T422*C,T0*a1);
/*INTEGER_TYPE_MARK*/T6 r422is_natural(void);
/*INTEGER_TYPE_MARK*/void r422integer_8(T422*C,T351 a1);
/*INTEGER_TYPE_MARK*/T6 r422is_integer(void);
extern T0*oBC422integer_name;
extern int fBC422integer_name;
/*INTEGER_TYPE_MARK*/T0*r422integer_name(void);
/*INTEGER_TYPE_MARK*/T6 r422is_character(void);
/*INTEGER_TYPE_MARK*/T6 r422is_kernel_expanded(void);
extern T0*oBC422integer_8_name;
extern int fBC422integer_8_name;
/*INTEGER_TYPE_MARK*/T0*r422integer_8_name(void);
/*INTEGER_TYPE_MARK*/T0*r422written_name(T422*C);
/*INTEGER_TYPE_MARK*/T0*r422default_expression(T422*C,T351 a1);
extern T0*oBC422integer_32_name;
extern int fBC422integer_32_name;
/*INTEGER_TYPE_MARK*/T0*r422integer_32_name(void);
/*INTEGER_TYPE_MARK*/T0*r422to_static(T422*C,T0*a1,T6 a2);
/*INTEGER_TYPE_MARK*/T0*r422signature_resolve_in(T422*C,T0*a1);
extern T0*oBC422integer_16_name;
extern int fBC422integer_16_name;
/*INTEGER_TYPE_MARK*/T0*r422integer_16_name(void);
/*INTEGER_TYPE_MARK*/T0*r422twin(T422*C);
/*INTEGER_TYPE_MARK*/void r422id_extra_information(T0*a1);
/*INTEGER_TYPE_MARK*/T0*r422weak_reference_argument(T422*C,T0*a1);
/*INTEGER_TYPE_MARK*/void r422set_start_position(T422*C,T351 a1);
/*INTEGER_TYPE_MARK*/T0*r422class_text(T422*C);
/*INTEGER_TYPE_MARK*/T0*r422error_handler(void);
/*INTEGER_TYPE_MARK*/T6 r422is_boolean(void);
/*INTEGER_TYPE_MARK*/void r422accept(T422*C,T0*a1);
/*INTEGER_TYPE_MARK*/T0*r422typed_internals_type_mark(T422*C,T351 a1);
/*INTEGER_TYPE_MARK*/T6 r422is_tuple(void);
/*INTEGER_TYPE_MARK*/void r422pretty_in(T422*C,T0*a1);
/*INTEGER_TYPE_MARK*/T351 r422start_position(T422*C);
/*INTEGER_TYPE_MARK*/T0*r422_P_379_class_text(T422*C);
/*NATURAL_TYPE_MARK*/T448*create448natural_16(T351 a1);
/*NATURAL_TYPE_MARK*/T448*create448natural_32(T351 a1);
/*NATURAL_TYPE_MARK*/T448*create448natural_64(T351 a1);
/*NATURAL_TYPE_MARK*/T448*create448natural_8(T351 a1);
/*NATURAL_TYPE_MARK*/T0*r448declaration_type(T448*C);
extern T0*oBC448natural_32_name;
extern int fBC448natural_32_name;
/*NATURAL_TYPE_MARK*/T0*r448natural_32_name(void);
/*NATURAL_TYPE_MARK*/T6 r448is_agent(void);
/*NATURAL_TYPE_MARK*/T0*r448generic_list(void);
/*NATURAL_TYPE_MARK*/T0*r448written_mark(T448*C);
/*NATURAL_TYPE_MARK*/T0*r448resolve_in(T448*C,T0*a1);
/*NATURAL_TYPE_MARK*/T0*r448at(T448*C,T351 a1);
/*NATURAL_TYPE_MARK*/T6 r448is_equal(T448*C,T0*a1);
/*NATURAL_TYPE_MARK*/T6 r448is_native_array(void);
/*NATURAL_TYPE_MARK*/T3 r448structure_mark(T448*C);
extern T0*oBC448natural_name;
extern int fBC448natural_name;
/*NATURAL_TYPE_MARK*/T0*r448natural_name(void);
/*NATURAL_TYPE_MARK*/T0*r448type(T448*C);
/*NATURAL_TYPE_MARK*/T6 r448is_pointer(void);
/*NATURAL_TYPE_MARK*/T2 r448id(T448*C);
/*NATURAL_TYPE_MARK*/void r448natural_8(T448*C,T351 a1);
extern T0*oBC448natural_64_name;
extern int fBC448natural_64_name;
/*NATURAL_TYPE_MARK*/T0*r448natural_64_name(void);
/*NATURAL_TYPE_MARK*/void r448natural(T448*C,T351 a1);
extern T0*oBC448natural_8_name;
extern int fBC448natural_8_name;
/*NATURAL_TYPE_MARK*/T0*r448natural_8_name(void);
/*NATURAL_TYPE_MARK*/T0*r448specialize_thru(T448*C,T0*a1,T0*a2,T0*a3);
/*NATURAL_TYPE_MARK*/T6 r448is_real(void);
/*NATURAL_TYPE_MARK*/T6 r448is_fixed_string(T448*C);
/*NATURAL_TYPE_MARK*/T0*r448try_class_text(T448*C);
/*NATURAL_TYPE_MARK*/T6 r448same_signature_type(T448*C,T0*a1,T0*a2);
/*NATURAL_TYPE_MARK*/T6 r448is_anchored(void);
/*NATURAL_TYPE_MARK*/T6 r448can_be_assigned_to(T448*C,T0*a1);
/*NATURAL_TYPE_MARK*/T6 r448is_natural(void);
/*NATURAL_TYPE_MARK*/void r448natural_16(T448*C,T351 a1);
/*NATURAL_TYPE_MARK*/T6 r448is_integer(void);
/*NATURAL_TYPE_MARK*/void r448natural_32(T448*C,T351 a1);
/*NATURAL_TYPE_MARK*/T6 r448is_character(void);
/*NATURAL_TYPE_MARK*/void r448natural_64(T448*C,T351 a1);
/*NATURAL_TYPE_MARK*/T6 r448is_kernel_expanded(void);
/*NATURAL_TYPE_MARK*/T0*r448written_name(T448*C);
/*NATURAL_TYPE_MARK*/T0*r448default_expression(T448*C,T351 a1);
/*NATURAL_TYPE_MARK*/T0*r448to_static(T448*C,T0*a1,T6 a2);
/*NATURAL_TYPE_MARK*/T0*r448signature_resolve_in(T448*C,T0*a1);
/*NATURAL_TYPE_MARK*/T0*r448twin(T448*C);
/*NATURAL_TYPE_MARK*/void r448id_extra_information(T0*a1);
/*NATURAL_TYPE_MARK*/T0*r448weak_reference_argument(T448*C,T0*a1);
/*NATURAL_TYPE_MARK*/void r448set_start_position(T448*C,T351 a1);
/*NATURAL_TYPE_MARK*/T0*r448class_text(T448*C);
/*NATURAL_TYPE_MARK*/T0*r448error_handler(void);
/*NATURAL_TYPE_MARK*/T6 r448is_boolean(void);
extern T0*oBC448natural_16_name;
extern int fBC448natural_16_name;
/*NATURAL_TYPE_MARK*/T0*r448natural_16_name(void);
/*NATURAL_TYPE_MARK*/void r448accept(T448*C,T0*a1);
/*NATURAL_TYPE_MARK*/T0*r448typed_internals_type_mark(T448*C,T351 a1);
/*NATURAL_TYPE_MARK*/T6 r448is_tuple(void);
/*NATURAL_TYPE_MARK*/void r448pretty_in(T448*C,T0*a1);
/*NATURAL_TYPE_MARK*/T351 r448start_position(T448*C);
/*NATURAL_TYPE_MARK*/T0*r448_P_379_class_text(T448*C);
/*POINTER_TYPE_MARK*/T451*create451make(T351 a1);
/*POINTER_TYPE_MARK*/T6 r451is_equal(T451*C,T0*a1);
/*POINTER_TYPE_MARK*/T6 r451is_tuple(void);
/*POINTER_TYPE_MARK*/void r451make(T451*C,T351 a1);
/*POINTER_TYPE_MARK*/T0*r451generic_list(void);
/*POINTER_TYPE_MARK*/T6 r451is_anchored(void);
/*POINTER_TYPE_MARK*/T6 r451is_character(void);
/*POINTER_TYPE_MARK*/T0*r451written_mark(void);
extern T0*oBC451written_name;
extern int fBC451written_name;
/*POINTER_TYPE_MARK*/T0*r451written_name(void);
/*POINTER_TYPE_MARK*/T6 r451is_native_array(void);
/*POINTER_TYPE_MARK*/T0*r451at(T451*C,T351 a1);
/*POINTER_TYPE_MARK*/T0*r451try_class_text(T451*C);
extern T0*oBC451long_name;
extern int fBC451long_name;
/*POINTER_TYPE_MARK*/T0*r451long_name(void);
/*POINTER_TYPE_MARK*/T0*r451specialize_thru(T451*C,T0*a1,T0*a2,T0*a3);
/*POINTER_TYPE_MARK*/T6 r451is_boolean(void);
/*POINTER_TYPE_MARK*/T0*r451typed_internals_type_mark(T451*C,T351 a1);
/*POINTER_TYPE_MARK*/T0*r451to_static(T451*C,T0*a1,T6 a2);
/*POINTER_TYPE_MARK*/void r451accept(T451*C,T0*a1);
/*POINTER_TYPE_MARK*/T6 r451same_signature_type(T451*C,T0*a1,T0*a2);
/*POINTER_TYPE_MARK*/T0*r451type(void);
/*POINTER_TYPE_MARK*/T0*r451signature_resolve_in(T0*a1);
/*POINTER_TYPE_MARK*/T6 r451is_natural(void);
/*POINTER_TYPE_MARK*/T0*r451default_expression(T451*C,T351 a1);
/*POINTER_TYPE_MARK*/void r451id_extra_information(T0*a1);
/*POINTER_TYPE_MARK*/T0*r451declaration_type(T451*C);
/*POINTER_TYPE_MARK*/T6 r451is_pointer(void);
/*POINTER_TYPE_MARK*/T351 r451start_position(T451*C);
/*POINTER_TYPE_MARK*/T6 r451is_kernel_expanded(void);
/*POINTER_TYPE_MARK*/void r451set_start_position(T451*C,T351 a1);
/*POINTER_TYPE_MARK*/T6 r451is_fixed_string(void);
/*POINTER_TYPE_MARK*/T0*r451class_text(T451*C);
/*POINTER_TYPE_MARK*/T0*r451twin(T451*C);
/*POINTER_TYPE_MARK*/T6 r451is_real(void);
/*POINTER_TYPE_MARK*/T6 r451is_integer(void);
/*POINTER_TYPE_MARK*/void r451pretty_in(T0*a1);
/*POINTER_TYPE_MARK*/T0*r451weak_reference_argument(T451*C,T0*a1);
/*POINTER_TYPE_MARK*/T0*r451error_handler(void);
/*POINTER_TYPE_MARK*/T0*r451resolve_in(T0*a1);
/*POINTER_TYPE_MARK*/T6 r451is_agent(void);
/*USER_GENERIC_TYPE_MARK*/void r459set_generic_list(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/T0*r459new_static_type_in(T459*C,T0*a1,T6 a2);
/*USER_GENERIC_TYPE_MARK*/T0*r459declaration_type(T459*C);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_agent(void);
/*USER_GENERIC_TYPE_MARK*/T0*r459canonical_long_name(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459long_name(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459written_mark(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459resolve_in(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/T0*r459at(T459*C,T351 a1);
/*USER_GENERIC_TYPE_MARK*/T0*r459strings(void);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_equal(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/void r459specialize_in(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_native_array(void);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_static(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459type(T459*C);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_pointer(void);
/*USER_GENERIC_TYPE_MARK*/T2 r459id(T459*C);
/*USER_GENERIC_TYPE_MARK*/void r459recompute_declaration_type(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459specialize_thru(T459*C,T0*a1,T0*a2,T0*a3);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_real(void);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_fixed_string(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459try_class_text(T459*C);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_user_empty_expanded(T459*C);
/*USER_GENERIC_TYPE_MARK*/T6 r459same_signature_type(T459*C,T0*a1,T0*a2);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_anchored(void);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_natural(void);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_integer(void);
/*USER_GENERIC_TYPE_MARK*/void r459make(T459*C,T0*a1,T0*a2);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_character(void);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_expanded(T459*C);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_kernel_expanded(void);
/*USER_GENERIC_TYPE_MARK*/T0*r459written_name(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459default_expression(T459*C,T351 a1);
/*USER_GENERIC_TYPE_MARK*/T0*r459to_static(T459*C,T0*a1,T6 a2);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_reference(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459signature_resolve_in(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/T0*r459twin(T459*C);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_user_expanded(T459*C);
/*USER_GENERIC_TYPE_MARK*/void r459id_extra_information(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/T0*r459weak_reference_argument(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/void r459set_start_position(T459*C,T351 a1);
/*USER_GENERIC_TYPE_MARK*/T0*r459class_text(T459*C);
/*USER_GENERIC_TYPE_MARK*/T0*r459error_handler(void);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_boolean(void);
/*USER_GENERIC_TYPE_MARK*/void r459accept(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/void r459set_static_generic_list(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/void r459update_static_memory(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/T0*r459typed_internals_type_mark(T459*C,T351 a1);
/*USER_GENERIC_TYPE_MARK*/T6 r459is_tuple(void);
/*USER_GENERIC_TYPE_MARK*/void r459pretty_in(T459*C,T0*a1);
/*USER_GENERIC_TYPE_MARK*/T351 r459start_position(T459*C);
/*CLIENT_TYPE_MARK*/T6 r518is_agent(void);
/*CLIENT_TYPE_MARK*/T0*r518generic_list(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518canonical_long_name(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518written_mark(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518resolve_in(T518*C,T0*a1);
/*CLIENT_TYPE_MARK*/T0*r518at(T518*C,T351 a1);
/*CLIENT_TYPE_MARK*/T0*r518class_text_name(void);
/*CLIENT_TYPE_MARK*/T6 r518is_equal(T518*C,T0*a1);
/*CLIENT_TYPE_MARK*/void r518specialize_in(T518*C,T0*a1);
/*CLIENT_TYPE_MARK*/T6 r518is_native_array(void);
/*CLIENT_TYPE_MARK*/T0*r518type(T518*C);
/*CLIENT_TYPE_MARK*/T6 r518is_pointer(void);
/*CLIENT_TYPE_MARK*/T2 r518id(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518specialize_thru(T518*C,T0*a1,T0*a2,T0*a3);
/*CLIENT_TYPE_MARK*/T6 r518is_real(void);
/*CLIENT_TYPE_MARK*/T6 r518is_fixed_string(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518try_class_text(T518*C);
/*CLIENT_TYPE_MARK*/T6 r518same_signature_type(T518*C,T0*a1,T0*a2);
/*CLIENT_TYPE_MARK*/T6 r518is_anchored(void);
/*CLIENT_TYPE_MARK*/T6 r518is_natural(void);
/*CLIENT_TYPE_MARK*/T6 r518is_integer(void);
/*CLIENT_TYPE_MARK*/void r518make(T518*C,T0*a1);
/*CLIENT_TYPE_MARK*/T6 r518is_character(void);
/*CLIENT_TYPE_MARK*/T6 r518is_expanded(T518*C);
/*CLIENT_TYPE_MARK*/T6 r518is_kernel_expanded(void);
/*CLIENT_TYPE_MARK*/T0*r518written_name(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518default_expression(T518*C,T351 a1);
/*CLIENT_TYPE_MARK*/T0*r518to_static(T518*C,T0*a1,T6 a2);
/*CLIENT_TYPE_MARK*/T6 r518is_reference(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518signature_resolve_in(T0*a1);
/*CLIENT_TYPE_MARK*/T6 r518is_generic(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518twin(T518*C);
/*CLIENT_TYPE_MARK*/T6 r518is_user_expanded(T518*C);
/*CLIENT_TYPE_MARK*/void r518id_extra_information(T518*C,T0*a1);
/*CLIENT_TYPE_MARK*/T0*r518weak_reference_argument(T518*C,T0*a1);
/*CLIENT_TYPE_MARK*/T0*r518class_text(T518*C);
/*CLIENT_TYPE_MARK*/T0*r518error_handler(void);
/*CLIENT_TYPE_MARK*/T6 r518is_boolean(void);
/*CLIENT_TYPE_MARK*/void r518accept(T518*C,T0*a1);
/*CLIENT_TYPE_MARK*/T0*r518typed_internals_type_mark(T518*C,T351 a1);
/*CLIENT_TYPE_MARK*/T6 r518is_tuple(void);
/*CLIENT_TYPE_MARK*/void r518pretty_in(T518*C,T0*a1);
/*CLIENT_TYPE_MARK*/T351 r518start_position(T518*C);
/*TYPE_MARK_LIST*/void r504make(T504*C,T0*a1,T0*a2);
/*TYPE_MARK_LIST*/T6 r504wider_than(T504*C,T0*a1);
/*TYPE_MARK_LIST*/void r504specialize_in(T504*C,T0*a1);
/*TYPE_MARK_LIST*/void r504merge(T504*C,T0*a1,T0*a2);
/*TYPE_MARK_LIST*/void r504add_last(T504*C,T0*a1);
/*TYPE_MARK_LIST*/T0*r504specialize_thru(T504*C,T0*a1,T0*a2,T0*a3);
/*TYPE_MARK_LIST*/T0*r504item(T504*C,T2 a1);
/*TYPE_MARK_LIST*/T2 r504index_of(T504*C,T0*a1);
/*TYPE_MARK_LIST*/T0*r504error_handler(void);
/*TYPE_MARK_LIST*/void r504locate_in_error_handler(T504*C);
/*TYPE_MARK_LIST*/T6 r504gives_permission_to(T504*C,T0*a1,T0*a2);
/*TYPE_MARK_LIST*/void r504make_1(T504*C,T0*a1);
/*TYPE_MARK_LIST*/void r504append_in(T504*C,T0*a1);
/*TYPE_MARK_LIST*/T2 r504count(T504*C);
/*TYPE_MARK_LIST*/T6 r504gives_permission_to_any(T504*C);
/*CLIENT_LIST*/T292*create292make(T351 a1,T0*a2);
/*CLIENT_LIST*/void r292make(T292*C,T351 a1,T0*a2);
/*CLIENT_LIST*/T6 r292wider_than(T292*C,T0*a1);
/*CLIENT_LIST*/void r292specialize_in(T292*C,T0*a1);
/*CLIENT_LIST*/void r292merge(T292*C,T351 a1,T0*a2,T0*a3);
/*CLIENT_LIST*/T0*r292specialize_thru(T292*C,T0*a1,T0*a2,T0*a3);
/*CLIENT_LIST*/T0*r292eiffel_view(T292*C);
/*CLIENT_LIST*/T6 r292is_omitted(T292*C);
/*CLIENT_LIST*/T6 r292gives_no_permission(T292*C);
/*CLIENT_LIST*/T0*r292error_handler(void);
/*CLIENT_LIST*/void r292locate_in_error_handler(T292*C);
/*CLIENT_LIST*/T6 r292gives_permission_to(T292*C,T0*a1,T0*a2);
/*CLIENT_LIST*/T0*r292merge_with(T292*C,T0*a1);
/*CLIENT_LIST*/void r292append_in(T292*C,T0*a1);
/*CLIENT_LIST*/T6 r292gives_permission_to_any(T292*C);
/*FEATURE_NAME_LIST*/void r461fe_multiple(T0*a1,T0*a2);
/*FEATURE_NAME_LIST*/void r461all_positions_in_error_handler(T461*C);
/*FEATURE_NAME_LIST*/T0*r461internal_name(T461*C,T0*a1);
/*FEATURE_NAME_LIST*/void r461add_last(T461*C,T0*a1);
/*FEATURE_NAME_LIST*/T0*r461item(T461*C,T2 a1);
/*FEATURE_NAME_LIST*/void r461make_n(T461*C,T0*a1);
/*FEATURE_NAME_LIST*/T2 r461index_of(T461*C,T0*a1);
/*FEATURE_NAME_LIST*/T0*r461root_creation_search(T461*C,T0*a1);
/*FEATURE_NAME_LIST*/T0*r461error_handler(void);
/*FEATURE_NAME_LIST*/T6 r461has_make(T461*C);
/*FEATURE_NAME_LIST*/void r461make_1(T461*C,T0*a1);
/*FEATURE_NAME_LIST*/T2 r461count(T461*C);
/*FEATURE_NAME_LIST*/T6 r461has(T461*C,T0*a1);
/*CREATION_CLAUSE*/void r436make(T436*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*CREATION_CLAUSE*/void r436check_manifest_semicolon_check(T436*C,T0*a1,T0*a2);
/*CREATION_CLAUSE*/T0*r436default_root(T436*C);
extern T0*oBC32manifest_make_name;
extern int fBC32manifest_make_name;
/*CREATION_CLAUSE*/T0*r436manifest_make_name(void);
/*CREATION_CLAUSE*/void r436check_manifest_make(T0*a1,T0*a2);
/*CREATION_CLAUSE*/T0*r436extra_expanded_check(T436*C,T0*a1,T0*a2);
/*CREATION_CLAUSE*/void r436check_manifest_put(T0*a1,T0*a2);
extern T0*oBC32manifest_semicolon_check_name;
extern int fBC32manifest_semicolon_check_name;
/*CREATION_CLAUSE*/T0*r436manifest_semicolon_check_name(void);
/*CREATION_CLAUSE*/void r436check_for(T436*C,T0*a1);
/*CREATION_CLAUSE*/T0*r436error_handler(void);
extern T0*oBC32manifest_put_name;
extern int fBC32manifest_put_name;
/*CREATION_CLAUSE*/T0*r436manifest_put_name(void);
/*CREATION_CLAUSE*/T0*r436user_expanded_default_create_stamp(T436*C,T0*a1);
/*MINI_BUFFER*/T6 r282is_off(T282*C);
/*MINI_BUFFER*/T0*r282a_include(T282*C);
/*MINI_BUFFER*/void r282next(T282*C);
/*MINI_BUFFER*/T0*r282a_file_or_directory_path(T282*C);
/*MINI_BUFFER*/T0*r282a_type_cast(T282*C);
/*MINI_BUFFER*/T6 r282a_keyword(T282*C,T0*a1);
/*MINI_BUFFER*/void r282skip_separators(T282*C);
/*MINI_BUFFER*/T3 r282item(T282*C);
/*MINI_BUFFER*/T0*r282system_tools(void);
/*MINI_BUFFER*/T0*r282a_signature(T282*C);
/*MINI_BUFFER*/T0*r282error_handler(void);
/*MINI_BUFFER*/T0*r282an_identifier(T282*C);
/*MINI_BUFFER*/void r282start_with(T282*C,T0*a1);
/*MINI_BUFFER*/void r282show_position_with_fatal_error(T282*C,T0*a1);
/*MINI_BUFFER*/T6 r282a_word(T282*C,T0*a1);
/*NATIVE_BUILT_IN*/void r486make(T486*C,T0*a1);
/*NATIVE_BUILT_IN*/void r486pretty(T486*C,T2 a1,T6 a2);
/*NATIVE_BUILT_IN*/void r486collect_fs(T0*a1,T0*a2);
extern T0*oBC486is_finished;
extern int fBC486is_finished;
/*NATIVE_BUILT_IN*/T0*r486is_finished(void);
extern T0*oBC486native_data;
extern int fBC486native_data;
/*NATIVE_BUILT_IN*/T0*r486native_data(void);
extern T0*oBC486thread;
extern int fBC486thread;
/*NATIVE_BUILT_IN*/T0*r486thread(void);
/*NATIVE_BUILT_IN*/void r486parse_external_type(T486*C,T0*a1,T0*a2);
extern T0*oBC486is_started;
extern int fBC486is_started;
/*NATIVE_BUILT_IN*/T0*r486is_started(void);
extern T0*oBC486status;
extern int fBC486status;
/*NATIVE_BUILT_IN*/T0*r486status(void);
/*NATIVE_BUILT_IN*/void r486accept(T486*C,T0*a1);
/*NATIVE_BUILT_IN*/void r486collect(T0*a1,T0*a2);
/*NATIVE_BUILT_IN*/T351 r486start_position(T486*C);
/*NATIVE_BUILT_IN*/T6 r486use_current(T0*a1);
/*NATIVE_BUILT_IN*/void r486crash(T486*C);
/*NATIVE_BUILT_IN*/T6 r486side_effect_free(T0*a1,T0*a2);
/*NATIVE_BUILT_IN*/void r486not_yet_implemented(T486*C);
/*NATIVE_BUILT_IN*/T2 r486hash_code(T486*C);
/*NATIVE_PLUG_IN*/T6 r488is_equal(T488*C,T0*a1);
/*NATIVE_PLUG_IN*/void r488make(T488*C,T0*a1);
/*NATIVE_PLUG_IN*/void r488pretty(T488*C,T2 a1,T6 a2);
/*NATIVE_PLUG_IN*/void r488parse_external_type(T488*C,T0*a1,T0*a2);
/*NATIVE_PLUG_IN*/void r488parse_alias_string(T488*C,T0*a1);
/*NATIVE_PLUG_IN*/void r488accept(T488*C,T0*a1);
/*NATIVE_PLUG_IN*/void r488do_collect(T488*C);
/*NATIVE_PLUG_IN*/T0*r488required_key(T488*C,T0*a1);
/*NATIVE_PLUG_IN*/void r488check_unused_keys(T488*C);
/*NATIVE_PLUG_IN*/void r488collect(T488*C,T0*a1,T0*a2);
/*NATIVE_PLUG_IN*/T351 r488start_position(T488*C);
/*NATIVE_PLUG_IN*/T0*r488system_tools(void);
/*NATIVE_PLUG_IN*/void r488customize_runtime(T488*C);
/*NATIVE_PLUG_IN*/T0*r488error_handler(void);
/*NATIVE_C_PLUS_PLUS*/void r489make(T489*C,T0*a1);
/*NATIVE_C_PLUS_PLUS*/void r489pretty(T489*C,T2 a1,T6 a2);
/*NATIVE_C_PLUS_PLUS*/T2 r489parse_args_in(T489*C,T0*a1,T2 a2,T0*a3,T2 a4,T2 a5);
/*NATIVE_C_PLUS_PLUS*/void r489parse_external_type(T489*C,T0*a1,T0*a2);
/*NATIVE_C_PLUS_PLUS*/T0*r489cpp(void);
/*NATIVE_C_PLUS_PLUS*/void r489accept(T489*C,T0*a1);
/*NATIVE_C_PLUS_PLUS*/T2 r489error_at(T489*C,T2 a1,T0*a2,T2 a3);
/*NATIVE_C_PLUS_PLUS*/void r489notify_external_assignments(T0*a1,T0*a2);
/*NATIVE_C_PLUS_PLUS*/void r489collect(T0*a1,T0*a2);
/*NATIVE_C_PLUS_PLUS*/T351 r489start_position(T489*C);
/*NATIVE_C_PLUS_PLUS*/T2 r489parse_cpp_class_in(T489*C,T0*a1,T2 a2,T0*a3);
/*NATIVE_C_PLUS_PLUS*/void r489crash(T489*C);
/*NATIVE_C_PLUS_PLUS*/T2 r489parse_include(T489*C,T2 a1,T0*a2);
/*NATIVE_C_PLUS_PLUS*/T0*r489error_handler(void);
extern T0*oBC489include_memory;
extern int fBC489include_memory;
/*NATIVE_C_PLUS_PLUS*/T0*r489include_memory(void);
/*NATIVE_C_PLUS_PLUS*/void r489parse_external_in(T489*C,T0*a1,T2 a2,T0*a3,T0*a4);
/*NATIVE_C_PLUS_PLUS*/void r489not_yet_implemented(T489*C);
/*NATIVE_C_PLUS_PLUS*/T2 r489hash_code(T489*C);
/*NATIVE_C*/void r490make(T490*C,T0*a1);
/*NATIVE_C*/void r490pretty(T490*C,T2 a1,T6 a2);
/*NATIVE_C*/void r490parse_external_type(T490*C,T0*a1,T0*a2);
/*NATIVE_C*/T0*r490cpp(void);
/*NATIVE_C*/void r490accept(T490*C,T0*a1);
/*NATIVE_C*/void r490notify_external_assignments(T0*a1,T0*a2);
/*NATIVE_C*/void r490parse_external_tag(T490*C);
/*NATIVE_C*/void r490collect(T0*a1,T0*a2);
/*NATIVE_C*/T351 r490start_position(T490*C);
/*NATIVE_C*/void r490crash(T490*C);
/*NATIVE_C*/T0*r490error_handler(void);
/*NATIVE_C*/void r490not_yet_implemented(T490*C);
/*NATIVE_C*/T2 r490hash_code(T490*C);
/*NATIVE_C*/void r490bad_external(T490*C,T0*a1);
/*EXTERNAL_TYPE*/T438*create438make(T0*a1,T0*a2,T351 a3);
/*EXTERNAL_TYPE*/void r438make(T438*C,T0*a1,T0*a2,T351 a3);
/*EXTERNAL_TYPE*/void r438set(T438*C,T0*a1,T0*a2);
/*EXTERNAL_TYPE*/void r438collect(T438*C);
/*PARENT_EDGE*/T289*create289make(T6 a1,T0*a2);
/*PARENT_EDGE*/void r289check_level_2(T289*C,T0*a1);
/*PARENT_EDGE*/void r289make(T289*C,T6 a1,T0*a2);
/*PARENT_EDGE*/T0*r289exports_for(T289*C,T0*a1);
/*PARENT_EDGE*/void r289add_rename(T289*C,T0*a1);
/*PARENT_EDGE*/T6 r289is_target_of_rename(T289*C,T0*a1);
extern T0*oBC289forbidden_parent_list;
extern int fBC289forbidden_parent_list;
/*PARENT_EDGE*/T0*r289forbidden_parent_list(void);
/*PARENT_EDGE*/void r289initialize_and_check_level_1(T289*C,T0*a1);
/*PARENT_EDGE*/T2 r289rename_count(T289*C);
/*PARENT_EDGE*/void r289id_extra_information(T289*C,T0*a1);
/*PARENT_EDGE*/T0*r289get_name_in_child(T289*C,T0*a1);
/*PARENT_EDGE*/T0*r289exports_for_all(T289*C);
/*PARENT_EDGE*/T351 r289start_position(T289*C);
/*PARENT_EDGE*/T0*r289do_rename(T289*C,T0*a1);
/*PARENT_EDGE*/T0*r289error_handler(void);
/*PARENT_EDGE*/T0*r289get_undefine(T289*C,T0*a1);
/*PARENT_EDGE*/T0*r289get_redefine(T289*C,T0*a1);
/*RENAME_PAIR*/void r497make(T497*C,T0*a1,T0*a2);
/*RENAME_PAIR*/T0*r497error_handler(void);
/*OLD_MANIFEST_ARRAY*/T0*r538specialize_and_check(T538*C,T0*a1);
/*OLD_MANIFEST_ARRAY*/T0*r538to_expression(T538*C);
/*OLD_MANIFEST_ARRAY*/void r538make(T538*C,T351 a1,T0*a2);
/*OLD_MANIFEST_ARRAY*/void r538pretty(T538*C,T2 a1);
/*OLD_MANIFEST_ARRAY*/T0*r538static_simplify(T538*C);
/*OLD_MANIFEST_ARRAY*/T0*r538specialize_in(T538*C,T0*a1);
extern T0*oBC538type_set_buffer;
extern int fBC538type_set_buffer;
/*OLD_MANIFEST_ARRAY*/T0*r538type_set_buffer(void);
/*OLD_MANIFEST_ARRAY*/T0*r538specialize_thru(T538*C,T0*a1,T0*a2,T0*a3);
/*OLD_MANIFEST_ARRAY*/T6 r538is_stored_in_some_local_variable(void);
/*OLD_MANIFEST_ARRAY*/void r538accept(T538*C,T0*a1);
/*OLD_MANIFEST_ARRAY*/void r538pretty_target(T538*C,T2 a1);
/*OLD_MANIFEST_ARRAY*/T0*r538twin(T538*C);
/*OLD_MANIFEST_ARRAY*/T0*r538written_declaration_type_mark(void);
/*OLD_MANIFEST_ARRAY*/T6 r538use_current(T0*a1);
/*OLD_MANIFEST_ARRAY*/void r538bracketed_pretty(T538*C,T2 a1);
/*OLD_MANIFEST_ARRAY*/T0*r538non_void_no_dispatch_type(T0*a1);
/*OLD_MANIFEST_ARRAY*/T6 r538side_effect_free(T0*a1);
/*OLD_MANIFEST_ARRAY*/T0*r538error_handler(void);
/*OLD_MANIFEST_ARRAY*/T0*r538smallest_ancestor_from_type_set_buffer(void);
/*OLD_MANIFEST_ARRAY*/T0*r538resolve_in(T0*a1);
/*OLD_MANIFEST_ARRAY*/T0*r538to_instruction(T538*C);
/*CALL_PREFIX_NOT*/T0*r507declaration_type(T507*C);
/*CALL_PREFIX_NOT*/T0*r507adapt_for(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507resolve_in(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507eiffel_parser(void);
extern T0*oBC358use_current_stack;
extern int fBC358use_current_stack;
/*CALL_PREFIX_NOT*/T0*r507use_current_stack(void);
/*CALL_PREFIX_NOT*/T0*r507collect(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507specialize_in(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507written_declaration_type_mark(T507*C);
/*CALL_PREFIX_NOT*/T0*r507simplify(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507arguments(void);
/*CALL_PREFIX_NOT*/void r507pretty_target(T507*C,T2 a1);
/*CALL_PREFIX_NOT*/void r507safety_check(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507to_expression(T507*C);
/*CALL_PREFIX_NOT*/T0*r507specialize_thru(T507*C,T0*a1,T0*a2,T0*a3);
/*CALL_PREFIX_NOT*/T0*r507manifest_expression(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507feature_accumulator(void);
/*CALL_PREFIX_NOT*/T0*r507specialize_and_check(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T6 r507simplify_limit_reached(T507*C);
/*CALL_PREFIX_NOT*/void r507inline_dynamic_dispatch_(T507*C,T0*a1,T0*a2);
/*CALL_PREFIX_NOT*/T0*r507to_instruction(T507*C);
/*CALL_PREFIX_NOT*/T0*r507current_or_twin_init(T507*C,T0*a1,T0*a2);
/*CALL_PREFIX_NOT*/void r507standard_check_export_and_obsolete_calls(T507*C,T0*a1,T0*a2,T0*a3);
/*CALL_PREFIX_NOT*/void r507make(T507*C,T351 a1,T0*a2);
/*CALL_PREFIX_NOT*/T0*r507echo(void);
/*CALL_PREFIX_NOT*/void r507type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_PREFIX_NOT*/void r507non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_PREFIX_NOT*/T6 r507use_current(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507static_simplify(T507*C);
/*CALL_PREFIX_NOT*/T0*r507extra_local_expanded(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T6 r507function_check(T507*C,T0*a1,T0*a2);
/*CALL_PREFIX_NOT*/void r507pretty(T507*C,T2 a1);
/*CALL_PREFIX_NOT*/T6 r507side_effect_free(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507non_void_no_dispatch_type(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507inline_with(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T0*r507twin(T507*C);
/*CALL_PREFIX_NOT*/void r507bracketed_pretty(T507*C,T2 a1);
/*CALL_PREFIX_NOT*/T0*r507error_handler(void);
/*CALL_PREFIX_NOT*/void r507accept(T507*C,T0*a1);
/*CALL_PREFIX_NOT*/T351 r507start_position(T507*C);
/*CALL_PREFIX_NOT*/T6 r507is_stored_in_some_local_variable(void);
/*ASSIGNMENT_TEST*/T416*create416make(T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_TEST*/T0*r416specialize_and_check(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/T0*r416to_expression(T416*C);
/*ASSIGNMENT_TEST*/void r416make(T416*C,T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_TEST*/void r416pretty(T416*C,T2 a1);
/*ASSIGNMENT_TEST*/T0*r416simplify(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/T0*r416static_simplify(T416*C);
/*ASSIGNMENT_TEST*/T0*r416specialize_in(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/void r416inline_dynamic_dispatch_(T416*C,T0*a1,T0*a2);
/*ASSIGNMENT_TEST*/void r416safety_check(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/T6 r416static_left_type_mark(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/T0*r416specialize_thru(T416*C,T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_TEST*/void r416with_writable(T416*C,T0*a1,T0*a2);
/*ASSIGNMENT_TEST*/T6 r416is_stored_in_some_local_variable(void);
/*ASSIGNMENT_TEST*/void r416accept(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/T0*r416adapt_for(T416*C,T0*a1);
extern T0*oBC416declaration_type;
extern int fBC416declaration_type;
/*ASSIGNMENT_TEST*/T0*r416declaration_type(void);
/*ASSIGNMENT_TEST*/T0*r416collect(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/void r416pretty_target(T416*C,T2 a1);
/*ASSIGNMENT_TEST*/T351 r416start_position(T416*C);
/*ASSIGNMENT_TEST*/T0*r416twin(T416*C);
extern T0*oBC416written_declaration_type_mark;
extern int fBC416written_declaration_type_mark;
/*ASSIGNMENT_TEST*/T0*r416written_declaration_type_mark(void);
/*ASSIGNMENT_TEST*/T6 r416use_current(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/void r416bracketed_pretty(T416*C,T2 a1);
/*ASSIGNMENT_TEST*/T0*r416non_void_no_dispatch_type(T0*a1);
/*ASSIGNMENT_TEST*/T6 r416side_effect_free(T416*C,T0*a1);
/*ASSIGNMENT_TEST*/T0*r416error_handler(void);
/*ASSIGNMENT_TEST*/void r416with_type_mark(T416*C,T0*a1,T0*a2);
/*ASSIGNMENT_TEST*/T0*r416resolve_in(T0*a1);
/*ASSIGNMENT_TEST*/T0*r416to_instruction(T416*C);
/*OPEN_OPERAND*/T0*r493to_expression(T493*C);
/*OPEN_OPERAND*/void r493question_mark(T493*C,T351 a1);
/*OPEN_OPERAND*/void r493pretty(T493*C,T2 a1);
/*OPEN_OPERAND*/T0*r493static_simplify(T493*C);
/*OPEN_OPERAND*/T0*r493specialize_in(T493*C,T0*a1);
/*OPEN_OPERAND*/void r493inline_dynamic_dispatch_(T493*C,T0*a1,T0*a2);
/*OPEN_OPERAND*/void r493type_holder(T493*C,T351 a1,T0*a2);
/*OPEN_OPERAND*/T0*r493specialize_thru(T493*C,T0*a1,T0*a2,T0*a3);
/*OPEN_OPERAND*/void r493update_resolved_memory(T493*C,T0*a1,T0*a2);
/*OPEN_OPERAND*/T6 r493is_stored_in_some_local_variable(void);
/*OPEN_OPERAND*/void r493accept(T493*C,T0*a1);
/*OPEN_OPERAND*/T0*r493declaration_type(T493*C);
/*OPEN_OPERAND*/void r493pretty_target(T493*C,T2 a1);
/*OPEN_OPERAND*/T0*r493twin(T493*C);
/*OPEN_OPERAND*/T0*r493written_declaration_type_mark(T493*C);
/*OPEN_OPERAND*/T6 r493use_current(T0*a1);
/*OPEN_OPERAND*/void r493bracketed_pretty(T493*C,T2 a1);
/*OPEN_OPERAND*/T0*r493non_void_no_dispatch_type(T0*a1);
/*OPEN_OPERAND*/T6 r493side_effect_free(T0*a1);
/*OPEN_OPERAND*/T0*r493error_handler(void);
/*OPEN_OPERAND*/T0*r493resolve_in(T493*C,T0*a1);
/*OPEN_OPERAND*/T0*r493to_instruction(T493*C);
/*OPEN_OPERAND*/T0*r493current_or_twin_init(T493*C,T0*a1);
/*INTEGER_CONSTANT*/T386*create386make(T11 a1,T351 a2);
/*INTEGER_CONSTANT*/T386*create386with(T11 a1,T351 a2,T0*a3);
/*INTEGER_CONSTANT*/void r386hexadecimal(T386*C,T351 a1,T0*a2,T1 a3,T6 a4,T11 a5);
/*INTEGER_CONSTANT*/T0*r386to_expression(T386*C);
/*INTEGER_CONSTANT*/void r386make(T386*C,T11 a1,T351 a2);
/*INTEGER_CONSTANT*/T0*r386to_real_constant(T386*C);
/*INTEGER_CONSTANT*/void r386pretty(T386*C,T2 a1);
/*INTEGER_CONSTANT*/T0*r386simplify(T386*C,T0*a1);
/*INTEGER_CONSTANT*/T6 r386extra_bracket_flag(T386*C);
/*INTEGER_CONSTANT*/void r386set_value(T386*C,T11 a1);
/*INTEGER_CONSTANT*/T0*r386static_simplify(T386*C);
/*INTEGER_CONSTANT*/void r386inline_dynamic_dispatch_(T386*C,T0*a1,T0*a2);
/*INTEGER_CONSTANT*/void r386special(T386*C,T351 a1,T0*a2,T0*a3,T11 a4);
/*INTEGER_CONSTANT*/T6 r386is_stored_in_some_local_variable(void);
/*INTEGER_CONSTANT*/void r386accept(T386*C,T0*a1);
/*INTEGER_CONSTANT*/void r386with(T386*C,T11 a1,T351 a2,T0*a3);
/*INTEGER_CONSTANT*/T0*r386result_type(T386*C);
/*INTEGER_CONSTANT*/T0*r386declaration_type(T386*C);
/*INTEGER_CONSTANT*/T0*r386collect(T386*C,T0*a1);
/*INTEGER_CONSTANT*/void r386pretty_target(T386*C,T2 a1);
/*INTEGER_CONSTANT*/T0*r386twin(T386*C);
/*INTEGER_CONSTANT*/T0*r386written_declaration_type_mark(T386*C);
/*INTEGER_CONSTANT*/T6 r386use_current(T0*a1);
/*INTEGER_CONSTANT*/void r386bracketed_pretty(T386*C,T2 a1);
/*INTEGER_CONSTANT*/T0*r386non_void_no_dispatch_type(T386*C,T0*a1);
/*INTEGER_CONSTANT*/T0*r386to_string(T386*C);
/*INTEGER_CONSTANT*/T6 r386side_effect_free(T0*a1);
/*INTEGER_CONSTANT*/T0*r386error_handler(void);
/*INTEGER_CONSTANT*/void r386append_in(T386*C,T0*a1);
/*INTEGER_CONSTANT*/T0*r386resolve_in(T386*C,T0*a1);
/*INTEGER_CONSTANT*/T0*r386to_instruction(T386*C);
/*INTEGER_CONSTANT*/void r386_P_387_pretty_target(T386*C,T2 a1);
/*REAL_CONSTANT*/T0*r494to_expression(T494*C);
/*REAL_CONSTANT*/void r494make(T494*C,T351 a1,T0*a2,T0*a3);
/*REAL_CONSTANT*/void r494pretty(T494*C,T2 a1);
/*REAL_CONSTANT*/T0*r494simplify(T494*C,T0*a1);
/*REAL_CONSTANT*/T0*r494static_simplify(T494*C);
/*REAL_CONSTANT*/void r494inline_dynamic_dispatch_(T494*C,T0*a1,T0*a2);
/*REAL_CONSTANT*/T0*r494normalized_view(T494*C);
/*REAL_CONSTANT*/T6 r494is_stored_in_some_local_variable(void);
/*REAL_CONSTANT*/void r494accept(T494*C,T0*a1);
/*REAL_CONSTANT*/T0*r494declaration_type(T494*C);
/*REAL_CONSTANT*/T0*r494collect(T494*C,T0*a1);
/*REAL_CONSTANT*/void r494pretty_target(T494*C,T2 a1);
/*REAL_CONSTANT*/T0*r494twin(T494*C);
/*REAL_CONSTANT*/T0*r494written_declaration_type_mark(T494*C);
/*REAL_CONSTANT*/T6 r494use_current(T0*a1);
/*REAL_CONSTANT*/void r494bracketed_pretty(T494*C,T2 a1);
/*REAL_CONSTANT*/T0*r494non_void_no_dispatch_type(T494*C,T0*a1);
/*REAL_CONSTANT*/T6 r494side_effect_free(T0*a1);
/*REAL_CONSTANT*/T0*r494error_handler(void);
/*REAL_CONSTANT*/T0*r494resolve_in(T494*C,T0*a1);
/*REAL_CONSTANT*/T0*r494to_instruction(T494*C);
/*MANIFEST_GENERIC*/T6 r495use_current_of(T0*a1,T0*a2);
/*MANIFEST_GENERIC*/T0*r495declaration_type(T495*C);
/*MANIFEST_GENERIC*/T0*r495adapt_for(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495resolve_in(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495optional_arguments_specialize_and_check(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495collect(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495manifest_make_name(void);
/*MANIFEST_GENERIC*/T6 r495is_equal(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495specialize_in(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495inline_dynamic_dispatch_of(T0*a1,T0*a2,T0*a3);
/*MANIFEST_GENERIC*/T0*r495written_declaration_type_mark(T495*C);
/*MANIFEST_GENERIC*/T0*r495simplify(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495manifest_semicolon_check_name(void);
/*MANIFEST_GENERIC*/void r495pretty_target(T495*C,T2 a1);
/*MANIFEST_GENERIC*/void r495safety_check(T495*C,T0*a1);
/*MANIFEST_GENERIC*/void r495specialize_and_check_from_old_manifest_array(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495to_expression(T495*C);
/*MANIFEST_GENERIC*/T0*r495specialize_thru(T495*C,T0*a1,T0*a2,T0*a3);
/*MANIFEST_GENERIC*/T0*r495specialize_and_check(T495*C,T0*a1);
/*MANIFEST_GENERIC*/void r495inline_dynamic_dispatch_(T495*C,T0*a1,T0*a2);
/*MANIFEST_GENERIC*/T0*r495to_instruction(T495*C);
/*MANIFEST_GENERIC*/void r495make(T495*C,T351 a1,T0*a2,T0*a3,T0*a4,T2 a5,T351 a6);
/*MANIFEST_GENERIC*/T0*r495calloc_name(void);
/*MANIFEST_GENERIC*/T2 r495hash_code(T495*C);
/*MANIFEST_GENERIC*/T0*r495simplify_of(T0*a1,T0*a2);
/*MANIFEST_GENERIC*/T6 r495use_current(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495static_simplify(T495*C);
/*MANIFEST_GENERIC*/void r495init(T495*C,T0*a1,T0*a2);
/*MANIFEST_GENERIC*/T0*r495specialize_in_of(T0*a1,T0*a2);
/*MANIFEST_GENERIC*/void r495pretty(T495*C,T2 a1);
/*MANIFEST_GENERIC*/T0*r495manifest_put_name(void);
/*MANIFEST_GENERIC*/T6 r495side_effect_free(T0*a1);
/*MANIFEST_GENERIC*/T0*r495specialize_thru_of(T0*a1,T0*a2,T0*a3,T0*a4);
/*MANIFEST_GENERIC*/T0*r495non_void_no_dispatch_type(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495twin(T495*C);
/*MANIFEST_GENERIC*/T0*r495specialize_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*MANIFEST_GENERIC*/T0*r495item_list_specialize_and_check(T495*C,T0*a1);
/*MANIFEST_GENERIC*/T0*r495adapt_of(T0*a1,T0*a2);
/*MANIFEST_GENERIC*/T0*r495error_handler(void);
/*MANIFEST_GENERIC*/void r495safety_check_of(T0*a1,T0*a2);
/*MANIFEST_GENERIC*/void r495accept(T495*C,T0*a1);
extern T0*oBC32put_name;
extern int fBC32put_name;
/*MANIFEST_GENERIC*/T0*r495put_name(void);
/*MANIFEST_GENERIC*/T6 r495is_stored_in_some_local_variable(void);
/*EFFECTIVE_ARG_LIST_N*/T370*create370make_1(T351 a1,T0*a2);
/*EFFECTIVE_ARG_LIST_N*/T370*create370make_2(T351 a1,T0*a2,T0*a3);
/*EFFECTIVE_ARG_LIST_N*/T0*r370specialize_and_check(T370*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*EFFECTIVE_ARG_LIST_N*/T0*r370to_fake_tuple(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/void r370pretty(T370*C,T2 a1);
/*EFFECTIVE_ARG_LIST_N*/void r370unused_expression_inline(T370*C,T0*a1,T0*a2);
/*EFFECTIVE_ARG_LIST_N*/T0*r370simplify(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/void r370set_end_position(T370*C,T351 a1);
/*EFFECTIVE_ARG_LIST_N*/void r370replace_item(T370*C,T2 a1,T0*a2);
/*EFFECTIVE_ARG_LIST_N*/void r370put(T370*C,T0*a1,T2 a2);
/*EFFECTIVE_ARG_LIST_N*/void r370static_simplify(T370*C);
/*EFFECTIVE_ARG_LIST_N*/T0*r370specialize_in(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/T0*r370expression(T370*C,T2 a1);
/*EFFECTIVE_ARG_LIST_N*/void r370safety_check(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/T0*r370specialize_and_check_on_expressions(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/T0*r370specialize_and_check_basic(T370*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5,T0*a6);
extern T0*oBC370collecting_formal_sub_type;
extern int fBC370collecting_formal_sub_type;
/*EFFECTIVE_ARG_LIST_N*/T0*r370collecting_formal_sub_type(void);
/*EFFECTIVE_ARG_LIST_N*/T0*r370specialize_thru(T370*C,T0*a1,T0*a2,T0*a3);
/*EFFECTIVE_ARG_LIST_N*/T6 r370is_static(T370*C);
/*EFFECTIVE_ARG_LIST_N*/void r370accept(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/T0*r370synthetize_tuple(T370*C,T0*a1,T0*a2,T0*a3);
/*EFFECTIVE_ARG_LIST_N*/T0*r370adapt_for(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/T0*r370create_inline(T370*C);
/*EFFECTIVE_ARG_LIST_N*/T0*r370item(T370*C,T2 a1);
/*EFFECTIVE_ARG_LIST_N*/void r370make_n(T370*C,T351 a1,T0*a2,T0*a3);
/*EFFECTIVE_ARG_LIST_N*/void r370unused_expression_in(T370*C,T0*a1,T0*a2);
/*EFFECTIVE_ARG_LIST_N*/void r370collect(T370*C,T0*a1,T0*a2,T0*a3);
/*EFFECTIVE_ARG_LIST_N*/void r370simple_collect(T370*C,T0*a1,T0*a2);
/*EFFECTIVE_ARG_LIST_N*/T0*r370synthetic_tuple_arg(T370*C,T2 a1,T0*a2,T0*a3,T0*a4);
/*EFFECTIVE_ARG_LIST_N*/T0*r370twin(T370*C);
/*EFFECTIVE_ARG_LIST_N*/T6 r370use_current(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/T6 r370side_effect_free(T370*C,T0*a1);
/*EFFECTIVE_ARG_LIST_N*/T0*r370error_handler(void);
/*EFFECTIVE_ARG_LIST_N*/T0*r370inline_dynamic_dispatch(T370*C,T0*a1,T0*a2);
/*EFFECTIVE_ARG_LIST_N*/void r370specialize_check_count(T370*C,T0*a1,T0*a2,T0*a3);
/*EFFECTIVE_ARG_LIST_N*/void r370make_1(T370*C,T351 a1,T0*a2);
/*EFFECTIVE_ARG_LIST_N*/void r370make_2(T370*C,T351 a1,T0*a2,T0*a3);
/*EFFECTIVE_ARG_LIST_N*/T2 r370count(T370*C);
extern T0*oBC370collecting_formal;
extern int fBC370collecting_formal;
/*EFFECTIVE_ARG_LIST_N*/T0*r370collecting_formal(void);
/*FUNCTION_CALL_0*/T0*r361declaration_type(T361*C);
/*FUNCTION_CALL_0*/T0*r361adapt_for(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361resolve_in(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361use_current_stack(void);
/*FUNCTION_CALL_0*/T0*r361collect(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361specialize_in(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361written_declaration_type_mark(T361*C);
/*FUNCTION_CALL_0*/T0*r361simplify(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361arguments(void);
/*FUNCTION_CALL_0*/void r361pretty_target(T361*C,T2 a1);
/*FUNCTION_CALL_0*/void r361safety_check(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361to_expression(T361*C);
/*FUNCTION_CALL_0*/T0*r361specialize_thru(T361*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_0*/T0*r361manifest_expression(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361feature_accumulator(void);
/*FUNCTION_CALL_0*/T0*r361specialize_and_check(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T6 r361simplify_limit_reached(T361*C);
/*FUNCTION_CALL_0*/void r361inline_dynamic_dispatch_(T361*C,T0*a1,T0*a2);
/*FUNCTION_CALL_0*/T0*r361to_instruction(T361*C);
/*FUNCTION_CALL_0*/T0*r361current_or_twin_init(T361*C,T0*a1,T0*a2);
/*FUNCTION_CALL_0*/void r361standard_check_export_and_obsolete_calls(T361*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_0*/void r361make(T361*C,T0*a1,T0*a2);
/*FUNCTION_CALL_0*/T0*r361echo(void);
/*FUNCTION_CALL_0*/void r361type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*FUNCTION_CALL_0*/void r361non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*FUNCTION_CALL_0*/T6 r361use_current(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361static_simplify(T361*C);
/*FUNCTION_CALL_0*/T0*r361extra_local_expanded(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T6 r361function_check(T361*C,T0*a1,T0*a2);
/*FUNCTION_CALL_0*/void r361pretty(T361*C,T2 a1);
/*FUNCTION_CALL_0*/T6 r361side_effect_free(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361non_void_no_dispatch_type(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361inline_with(T361*C,T0*a1);
/*FUNCTION_CALL_0*/T0*r361twin(T361*C);
/*FUNCTION_CALL_0*/void r361bracketed_pretty(T361*C,T2 a1);
/*FUNCTION_CALL_0*/T0*r361error_handler(void);
/*FUNCTION_CALL_0*/void r361accept(T361*C,T0*a1);
/*FUNCTION_CALL_0*/void r361make_specialized(T361*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_0*/T351 r361start_position(T361*C);
/*FUNCTION_CALL_0*/T6 r361is_stored_in_some_local_variable(void);
/*FUNCTION_CALL_1*/T6 r364is_balanced_operator(T0*a1);
/*FUNCTION_CALL_1*/T0*r364declaration_type(T364*C);
/*FUNCTION_CALL_1*/T0*r364adapt_for(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364resolve_in(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364eiffel_parser(void);
/*FUNCTION_CALL_1*/T0*r364use_current_stack(void);
/*FUNCTION_CALL_1*/T0*r364collect(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364parentheses_feature_name(T364*C);
/*FUNCTION_CALL_1*/T0*r364specialize_in(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364written_declaration_type_mark(T364*C);
/*FUNCTION_CALL_1*/T0*r364simplify(T364*C,T0*a1);
/*FUNCTION_CALL_1*/void r364pretty_target(T364*C,T2 a1);
/*FUNCTION_CALL_1*/void r364safety_check(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364to_expression(T364*C);
/*FUNCTION_CALL_1*/T0*r364specialize_thru(T364*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_1*/T0*r364feature_accumulator(void);
/*FUNCTION_CALL_1*/T0*r364specialize_and_check(T364*C,T0*a1);
/*FUNCTION_CALL_1*/void r364inline_dynamic_dispatch_(T364*C,T0*a1,T0*a2);
/*FUNCTION_CALL_1*/T0*r364to_instruction(T364*C);
/*FUNCTION_CALL_1*/T0*r364current_or_twin_init(T364*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_1*/void r364standard_check_export_and_obsolete_calls(T364*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_1*/void r364make(T364*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_1*/T0*r364arg1(T364*C);
/*FUNCTION_CALL_1*/void r364type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*FUNCTION_CALL_1*/void r364non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*FUNCTION_CALL_1*/T6 r364use_current(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364static_simplify(T364*C);
/*FUNCTION_CALL_1*/void r364init(T364*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_1*/T0*r364extra_local_expanded(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T6 r364function_check(T364*C,T0*a1,T0*a2);
/*FUNCTION_CALL_1*/void r364pretty(T364*C,T2 a1);
/*FUNCTION_CALL_1*/T6 r364side_effect_free(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364non_void_no_dispatch_type(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364run_feature_for(T364*C,T0*a1);
/*FUNCTION_CALL_1*/T0*r364inline_with(T364*C,T0*a1,T0*a2);
/*FUNCTION_CALL_1*/T0*r364twin(T364*C);
/*FUNCTION_CALL_1*/void r364bracketed_pretty(T364*C,T2 a1);
/*FUNCTION_CALL_1*/T0*r364error_handler(void);
/*FUNCTION_CALL_1*/T6 r364is_question_mark_open_operand(T0*a1);
/*FUNCTION_CALL_1*/void r364accept(T364*C,T0*a1);
/*FUNCTION_CALL_1*/void r364make_specialized(T364*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FUNCTION_CALL_1*/T351 r364start_position(T364*C);
/*FUNCTION_CALL_1*/T6 r364is_stored_in_some_local_variable(void);
/*FUNCTION_CALL_1*/T0*r364_P_363_declaration_type(T364*C);
/*FUNCTION_CALL_N*/T0*r366declaration_type(T366*C);
/*FUNCTION_CALL_N*/T0*r366adapt_for(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366resolve_in(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366eiffel_parser(void);
/*FUNCTION_CALL_N*/T0*r366use_current_stack(void);
/*FUNCTION_CALL_N*/T0*r366collect(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366parentheses_feature_name(T366*C);
/*FUNCTION_CALL_N*/T0*r366specialize_in(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366written_declaration_type_mark(T366*C);
/*FUNCTION_CALL_N*/T0*r366simplify(T366*C,T0*a1);
/*FUNCTION_CALL_N*/void r366pretty_target(T366*C,T2 a1);
/*FUNCTION_CALL_N*/void r366safety_check(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366to_expression(T366*C);
/*FUNCTION_CALL_N*/T0*r366specialize_thru(T366*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_N*/T0*r366feature_accumulator(void);
/*FUNCTION_CALL_N*/T0*r366specialize_and_check(T366*C,T0*a1);
/*FUNCTION_CALL_N*/void r366inline_dynamic_dispatch_(T366*C,T0*a1,T0*a2);
/*FUNCTION_CALL_N*/T0*r366to_instruction(T366*C);
/*FUNCTION_CALL_N*/void r366standard_check_export_and_obsolete_calls(T366*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_N*/void r366make(T366*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_N*/void r366type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*FUNCTION_CALL_N*/void r366non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*FUNCTION_CALL_N*/T6 r366use_current(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366static_simplify(T366*C);
/*FUNCTION_CALL_N*/void r366init(T366*C,T0*a1,T0*a2,T0*a3);
/*FUNCTION_CALL_N*/T0*r366extra_local_expanded(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T6 r366function_check(T366*C,T0*a1,T0*a2);
/*FUNCTION_CALL_N*/void r366pretty(T366*C,T2 a1);
/*FUNCTION_CALL_N*/T6 r366side_effect_free(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366non_void_no_dispatch_type(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366run_feature_for(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T0*r366twin(T366*C);
/*FUNCTION_CALL_N*/void r366bracketed_pretty(T366*C,T2 a1);
/*FUNCTION_CALL_N*/T0*r366error_handler(void);
/*FUNCTION_CALL_N*/T2 r366arg_count(T366*C);
/*FUNCTION_CALL_N*/void r366accept(T366*C,T0*a1);
/*FUNCTION_CALL_N*/T351 r366start_position(T366*C);
/*FUNCTION_CALL_N*/T6 r366is_stored_in_some_local_variable(void);
/*PROCEDURE_CALL_0*/T0*r355specialize_and_check(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/T0*r355to_expression(T355*C);
/*PROCEDURE_CALL_0*/void r355make(T355*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_0*/void r355pretty(T355*C,T2 a1);
/*PROCEDURE_CALL_0*/T0*r355simplify(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/void r355non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*PROCEDURE_CALL_0*/void r355standard_check_export_and_obsolete_calls(T355*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_0*/T0*r355specialize_in(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/void r355inline_dynamic_dispatch_(T355*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_0*/void r355safety_check(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/T0*r355run_feature_for(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/T0*r355specialize_thru(T355*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_0*/void r355accept(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/T0*r355simplify_arguments(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/T0*r355adapt_for(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/T0*r355collect(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/T351 r355start_position(T355*C);
/*PROCEDURE_CALL_0*/T0*r355use_current_stack(void);
/*PROCEDURE_CALL_0*/T0*r355twin(T355*C);
/*PROCEDURE_CALL_0*/T6 r355use_current(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/void r355type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*PROCEDURE_CALL_0*/void r355procedure_check(T355*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_0*/T6 r355side_effect_free(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/T0*r355arguments(void);
/*PROCEDURE_CALL_0*/T0*r355error_handler(void);
/*PROCEDURE_CALL_0*/T0*r355inline_dynamic_dispatch(T355*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_0*/T0*r355inline_with(T355*C,T0*a1);
/*PROCEDURE_CALL_0*/void r355collect_create(T355*C,T0*a1,T0*a2,T351 a3);
/*PROCEDURE_CALL_0*/T0*r355to_instruction(T355*C);
/*PROCEDURE_CALL_1*/T0*r359specialize_and_check(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/T0*r359to_expression(T359*C);
/*PROCEDURE_CALL_1*/void r359make(T359*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_1*/T0*r359eiffel_parser(void);
/*PROCEDURE_CALL_1*/void r359pretty(T359*C,T2 a1);
/*PROCEDURE_CALL_1*/T0*r359simplify(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/void r359non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*PROCEDURE_CALL_1*/void r359standard_check_export_and_obsolete_calls(T359*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_1*/T0*r359specialize_in(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/void r359inline_dynamic_dispatch_(T359*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_1*/T0*r359arg1(T359*C);
/*PROCEDURE_CALL_1*/void r359safety_check(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/T0*r359run_feature_for(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/T0*r359parentheses_feature_name(T359*C);
/*PROCEDURE_CALL_1*/void r359init(T359*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_1*/T0*r359specialize_thru(T359*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_1*/void r359accept(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/T0*r359simplify_arguments(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/T0*r359adapt_for(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/T0*r359collect(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/T351 r359start_position(T359*C);
/*PROCEDURE_CALL_1*/T0*r359use_current_stack(void);
/*PROCEDURE_CALL_1*/T0*r359twin(T359*C);
/*PROCEDURE_CALL_1*/T6 r359use_current(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/void r359type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*PROCEDURE_CALL_1*/void r359procedure_check(T359*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_1*/T6 r359side_effect_free(T359*C,T0*a1);
/*PROCEDURE_CALL_1*/T0*r359error_handler(void);
/*PROCEDURE_CALL_1*/T0*r359inline_dynamic_dispatch(T359*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_1*/T0*r359inline_with(T359*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_1*/void r359collect_create(T359*C,T0*a1,T0*a2,T351 a3);
/*PROCEDURE_CALL_1*/T0*r359to_instruction(T359*C);
/*PROCEDURE_CALL_N*/T0*r360specialize_and_check(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/T0*r360to_expression(T360*C);
/*PROCEDURE_CALL_N*/T2 r360arg_count(T360*C);
/*PROCEDURE_CALL_N*/void r360make(T360*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_N*/T0*r360eiffel_parser(void);
/*PROCEDURE_CALL_N*/void r360pretty(T360*C,T2 a1);
/*PROCEDURE_CALL_N*/T0*r360simplify(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/void r360non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*PROCEDURE_CALL_N*/void r360standard_check_export_and_obsolete_calls(T360*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_N*/T0*r360specialize_in(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/void r360inline_dynamic_dispatch_(T360*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_N*/void r360safety_check(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/T0*r360run_feature_for(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/T0*r360parentheses_feature_name(T360*C);
/*PROCEDURE_CALL_N*/void r360init(T360*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_N*/T0*r360specialize_thru(T360*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_N*/void r360accept(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/T0*r360inline_2(T360*C,T0*a1,T0*a2,T0*a3);
/*PROCEDURE_CALL_N*/T0*r360simplify_arguments(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/T0*r360adapt_for(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/T0*r360collect(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/T351 r360start_position(T360*C);
/*PROCEDURE_CALL_N*/T0*r360use_current_stack(void);
/*PROCEDURE_CALL_N*/T0*r360twin(T360*C);
/*PROCEDURE_CALL_N*/T6 r360use_current(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/void r360type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*PROCEDURE_CALL_N*/void r360procedure_check(T360*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_N*/T6 r360side_effect_free(T360*C,T0*a1);
/*PROCEDURE_CALL_N*/T0*r360error_handler(void);
/*PROCEDURE_CALL_N*/T0*r360inline_dynamic_dispatch(T360*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_N*/T0*r360inline_with(T360*C,T0*a1,T0*a2);
/*PROCEDURE_CALL_N*/void r360collect_create(T360*C,T0*a1,T0*a2,T351 a3);
/*PROCEDURE_CALL_N*/T0*r360to_instruction(T360*C);
/*CALL_PREFIX_PLUS*/T0*r509declaration_type(T509*C);
/*CALL_PREFIX_PLUS*/T0*r509adapt_for(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509resolve_in(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509eiffel_parser(void);
/*CALL_PREFIX_PLUS*/T0*r509use_current_stack(void);
/*CALL_PREFIX_PLUS*/T0*r509collect(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509specialize_in(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509written_declaration_type_mark(T509*C);
/*CALL_PREFIX_PLUS*/T0*r509simplify(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509arguments(void);
/*CALL_PREFIX_PLUS*/void r509pretty_target(T509*C,T2 a1);
/*CALL_PREFIX_PLUS*/void r509safety_check(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509to_expression(T509*C);
/*CALL_PREFIX_PLUS*/T0*r509specialize_thru(T509*C,T0*a1,T0*a2,T0*a3);
/*CALL_PREFIX_PLUS*/T0*r509manifest_expression(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509feature_accumulator(void);
/*CALL_PREFIX_PLUS*/T0*r509specialize_and_check(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T6 r509simplify_limit_reached(T509*C);
/*CALL_PREFIX_PLUS*/void r509inline_dynamic_dispatch_(T509*C,T0*a1,T0*a2);
/*CALL_PREFIX_PLUS*/T0*r509to_instruction(T509*C);
/*CALL_PREFIX_PLUS*/T0*r509current_or_twin_init(T509*C,T0*a1,T0*a2);
/*CALL_PREFIX_PLUS*/void r509standard_check_export_and_obsolete_calls(T509*C,T0*a1,T0*a2,T0*a3);
/*CALL_PREFIX_PLUS*/void r509make(T509*C,T351 a1,T0*a2);
/*CALL_PREFIX_PLUS*/T0*r509echo(void);
/*CALL_PREFIX_PLUS*/void r509type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_PREFIX_PLUS*/void r509non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_PREFIX_PLUS*/T6 r509use_current(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509static_simplify(T509*C);
/*CALL_PREFIX_PLUS*/T0*r509extra_local_expanded(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T6 r509function_check(T509*C,T0*a1,T0*a2);
/*CALL_PREFIX_PLUS*/void r509pretty(T509*C,T2 a1);
/*CALL_PREFIX_PLUS*/T6 r509side_effect_free(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509non_void_no_dispatch_type(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509inline_with(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T0*r509twin(T509*C);
/*CALL_PREFIX_PLUS*/void r509bracketed_pretty(T509*C,T2 a1);
/*CALL_PREFIX_PLUS*/T0*r509error_handler(void);
/*CALL_PREFIX_PLUS*/void r509accept(T509*C,T0*a1);
/*CALL_PREFIX_PLUS*/T351 r509start_position(T509*C);
/*CALL_PREFIX_PLUS*/T6 r509is_stored_in_some_local_variable(void);
/*CALL_PREFIX_MINUS*/T0*r510declaration_type(T510*C);
/*CALL_PREFIX_MINUS*/T0*r510adapt_for(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510resolve_in(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510eiffel_parser(void);
/*CALL_PREFIX_MINUS*/T0*r510use_current_stack(void);
/*CALL_PREFIX_MINUS*/T0*r510collect(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510specialize_in(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510written_declaration_type_mark(T510*C);
/*CALL_PREFIX_MINUS*/T0*r510simplify(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510arguments(void);
/*CALL_PREFIX_MINUS*/void r510pretty_target(T510*C,T2 a1);
/*CALL_PREFIX_MINUS*/void r510safety_check(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510to_expression(T510*C);
/*CALL_PREFIX_MINUS*/T0*r510specialize_thru(T510*C,T0*a1,T0*a2,T0*a3);
/*CALL_PREFIX_MINUS*/T0*r510manifest_expression(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510feature_accumulator(void);
/*CALL_PREFIX_MINUS*/T0*r510specialize_and_check(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T6 r510simplify_limit_reached(T510*C);
/*CALL_PREFIX_MINUS*/void r510inline_dynamic_dispatch_(T510*C,T0*a1,T0*a2);
/*CALL_PREFIX_MINUS*/T0*r510to_instruction(T510*C);
/*CALL_PREFIX_MINUS*/T0*r510current_or_twin_init(T510*C,T0*a1,T0*a2);
/*CALL_PREFIX_MINUS*/void r510standard_check_export_and_obsolete_calls(T510*C,T0*a1,T0*a2,T0*a3);
/*CALL_PREFIX_MINUS*/void r510make(T510*C,T351 a1,T0*a2);
/*CALL_PREFIX_MINUS*/T0*r510echo(void);
/*CALL_PREFIX_MINUS*/void r510type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_PREFIX_MINUS*/void r510non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_PREFIX_MINUS*/T6 r510use_current(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510static_simplify(T510*C);
/*CALL_PREFIX_MINUS*/T0*r510extra_local_expanded(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T6 r510function_check(T510*C,T0*a1,T0*a2);
/*CALL_PREFIX_MINUS*/void r510pretty(T510*C,T2 a1);
/*CALL_PREFIX_MINUS*/T6 r510side_effect_free(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510non_void_no_dispatch_type(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510inline_with(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T0*r510twin(T510*C);
/*CALL_PREFIX_MINUS*/void r510bracketed_pretty(T510*C,T2 a1);
/*CALL_PREFIX_MINUS*/T0*r510error_handler(void);
/*CALL_PREFIX_MINUS*/void r510accept(T510*C,T0*a1);
/*CALL_PREFIX_MINUS*/T351 r510start_position(T510*C);
/*CALL_PREFIX_MINUS*/T6 r510is_stored_in_some_local_variable(void);
/*CALL_PREFIX_FREEOP*/T0*r511declaration_type(T511*C);
/*CALL_PREFIX_FREEOP*/T0*r511adapt_for(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511resolve_in(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511use_current_stack(void);
/*CALL_PREFIX_FREEOP*/T0*r511collect(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511specialize_in(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511written_declaration_type_mark(T511*C);
/*CALL_PREFIX_FREEOP*/T0*r511simplify(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511arguments(void);
/*CALL_PREFIX_FREEOP*/void r511pretty_target(T511*C,T2 a1);
/*CALL_PREFIX_FREEOP*/void r511safety_check(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511to_expression(T511*C);
/*CALL_PREFIX_FREEOP*/T0*r511specialize_thru(T511*C,T0*a1,T0*a2,T0*a3);
/*CALL_PREFIX_FREEOP*/T0*r511manifest_expression(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511feature_accumulator(void);
/*CALL_PREFIX_FREEOP*/T0*r511specialize_and_check(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T6 r511simplify_limit_reached(T511*C);
/*CALL_PREFIX_FREEOP*/void r511inline_dynamic_dispatch_(T511*C,T0*a1,T0*a2);
/*CALL_PREFIX_FREEOP*/T0*r511to_instruction(T511*C);
/*CALL_PREFIX_FREEOP*/T0*r511current_or_twin_init(T511*C,T0*a1,T0*a2);
/*CALL_PREFIX_FREEOP*/void r511standard_check_export_and_obsolete_calls(T511*C,T0*a1,T0*a2,T0*a3);
/*CALL_PREFIX_FREEOP*/void r511make(T511*C,T0*a1,T0*a2);
/*CALL_PREFIX_FREEOP*/T0*r511echo(void);
/*CALL_PREFIX_FREEOP*/void r511type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_PREFIX_FREEOP*/void r511non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_PREFIX_FREEOP*/T6 r511use_current(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511static_simplify(T511*C);
/*CALL_PREFIX_FREEOP*/T0*r511extra_local_expanded(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T6 r511function_check(T511*C,T0*a1,T0*a2);
/*CALL_PREFIX_FREEOP*/void r511pretty(T511*C,T2 a1);
/*CALL_PREFIX_FREEOP*/T6 r511side_effect_free(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511non_void_no_dispatch_type(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511inline_with(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T0*r511twin(T511*C);
/*CALL_PREFIX_FREEOP*/void r511bracketed_pretty(T511*C,T2 a1);
/*CALL_PREFIX_FREEOP*/T0*r511error_handler(void);
/*CALL_PREFIX_FREEOP*/void r511accept(T511*C,T0*a1);
/*CALL_PREFIX_FREEOP*/T351 r511start_position(T511*C);
/*CALL_PREFIX_FREEOP*/T6 r511is_stored_in_some_local_variable(void);
/*MANIFEST_TUPLE*/T0*r499specialize_and_check(T499*C,T0*a1);
/*MANIFEST_TUPLE*/T0*r499to_expression(T499*C);
/*MANIFEST_TUPLE*/void r499make(T499*C,T351 a1,T0*a2);
/*MANIFEST_TUPLE*/void r499pretty(T499*C,T2 a1);
/*MANIFEST_TUPLE*/T0*r499simplify(T499*C,T0*a1);
/*MANIFEST_TUPLE*/T0*r499create_expression_for(T499*C,T0*a1,T0*a2);
/*MANIFEST_TUPLE*/T0*r499static_simplify(T499*C);
/*MANIFEST_TUPLE*/T0*r499specialize_in(T499*C,T0*a1);
/*MANIFEST_TUPLE*/void r499safety_check(T499*C,T0*a1);
/*MANIFEST_TUPLE*/void r499init(T499*C,T0*a1,T0*a2);
/*MANIFEST_TUPLE*/T0*r499specialize_thru(T499*C,T0*a1,T0*a2,T0*a3);
/*MANIFEST_TUPLE*/T6 r499is_stored_in_some_local_variable(void);
/*MANIFEST_TUPLE*/void r499accept(T499*C,T0*a1);
/*MANIFEST_TUPLE*/T0*r499adapt_for(T499*C,T0*a1);
/*MANIFEST_TUPLE*/void r499pretty_target(T499*C,T2 a1);
/*MANIFEST_TUPLE*/T0*r499twin(T499*C);
/*MANIFEST_TUPLE*/T0*r499written_declaration_type_mark(T499*C);
/*MANIFEST_TUPLE*/T6 r499use_current(T499*C,T0*a1);
/*MANIFEST_TUPLE*/void r499bracketed_pretty(T499*C,T2 a1);
/*MANIFEST_TUPLE*/T0*r499non_void_no_dispatch_type(T499*C,T0*a1);
/*MANIFEST_TUPLE*/T6 r499side_effect_free(T0*a1);
/*MANIFEST_TUPLE*/T0*r499error_handler(void);
/*MANIFEST_TUPLE*/T0*r499resolve_in(T499*C,T0*a1);
/*MANIFEST_TUPLE*/T0*r499to_instruction(T499*C);
/*MANIFEST_TUPLE*/T0*r499current_or_twin_init(T499*C,T0*a1,T0*a2);
/*E_TRUE*/T400*create400make(T351 a1);
/*E_TRUE*/T0*r400to_expression(T400*C);
/*E_TRUE*/void r400make(T400*C,T351 a1);
/*E_TRUE*/void r400pretty(T2 a1);
/*E_TRUE*/T0*r400simplify(T400*C,T0*a1);
/*E_TRUE*/T0*r400static_simplify(T400*C);
/*E_TRUE*/void r400inline_dynamic_dispatch_(T400*C,T0*a1,T0*a2);
/*E_TRUE*/T6 r400is_stored_in_some_local_variable(void);
/*E_TRUE*/void r400accept(T400*C,T0*a1);
extern T0*oBC401declaration_type;
extern int fBC401declaration_type;
/*E_TRUE*/T0*r400declaration_type(void);
/*E_TRUE*/T0*r400collect(T0*a1);
/*E_TRUE*/void r400pretty_target(T2 a1);
/*E_TRUE*/T0*r400twin(T400*C);
/*E_TRUE*/T0*r400written_declaration_type_mark(void);
/*E_TRUE*/T6 r400use_current(T0*a1);
/*E_TRUE*/void r400bracketed_pretty(T2 a1);
/*E_TRUE*/T0*r400non_void_no_dispatch_type(T0*a1);
/*E_TRUE*/T6 r400side_effect_free(T0*a1);
/*E_TRUE*/T0*r400resolve_in(T0*a1);
/*E_TRUE*/T0*r400to_instruction(T400*C);
/*E_FALSE*/T471*create471make(T351 a1);
/*E_FALSE*/T0*r471to_expression(T471*C);
/*E_FALSE*/void r471make(T471*C,T351 a1);
/*E_FALSE*/void r471pretty(T2 a1);
/*E_FALSE*/T0*r471simplify(T471*C,T0*a1);
/*E_FALSE*/T0*r471static_simplify(T471*C);
/*E_FALSE*/void r471inline_dynamic_dispatch_(T471*C,T0*a1,T0*a2);
/*E_FALSE*/T6 r471is_stored_in_some_local_variable(void);
/*E_FALSE*/void r471accept(T471*C,T0*a1);
/*E_FALSE*/T0*r471declaration_type(void);
/*E_FALSE*/T0*r471collect(T0*a1);
/*E_FALSE*/void r471pretty_target(T2 a1);
/*E_FALSE*/T0*r471twin(T471*C);
/*E_FALSE*/T0*r471written_declaration_type_mark(void);
/*E_FALSE*/T6 r471use_current(T0*a1);
/*E_FALSE*/void r471bracketed_pretty(T2 a1);
/*E_FALSE*/T0*r471non_void_no_dispatch_type(T0*a1);
/*E_FALSE*/T6 r471side_effect_free(T0*a1);
/*E_FALSE*/T0*r471resolve_in(T0*a1);
/*E_FALSE*/T0*r471to_instruction(T471*C);
/*CHARACTER_CONSTANT*/T481*create481with(T351 a1,T3 a2);
/*CHARACTER_CONSTANT*/T0*r481to_expression(T481*C);
/*CHARACTER_CONSTANT*/void r481make(T481*C,T351 a1,T3 a2,T0*a3);
/*CHARACTER_CONSTANT*/void r481character_coding(T3 a1,T0*a2);
/*CHARACTER_CONSTANT*/void r481pretty(T481*C,T2 a1);
/*CHARACTER_CONSTANT*/T0*r481simplify(T481*C,T0*a1);
/*CHARACTER_CONSTANT*/T0*r481static_simplify(T481*C);
/*CHARACTER_CONSTANT*/void r481inline_dynamic_dispatch_(T481*C,T0*a1,T0*a2);
/*CHARACTER_CONSTANT*/T6 r481is_stored_in_some_local_variable(void);
/*CHARACTER_CONSTANT*/void r481accept(T481*C,T0*a1);
/*CHARACTER_CONSTANT*/void r481with(T481*C,T351 a1,T3 a2);
extern T0*oBC481declaration_type;
extern int fBC481declaration_type;
/*CHARACTER_CONSTANT*/T0*r481declaration_type(void);
/*CHARACTER_CONSTANT*/T0*r481collect(T0*a1);
/*CHARACTER_CONSTANT*/void r481pretty_target(T481*C,T2 a1);
/*CHARACTER_CONSTANT*/T0*r481twin(T481*C);
/*CHARACTER_CONSTANT*/T0*r481written_declaration_type_mark(void);
/*CHARACTER_CONSTANT*/T6 r481use_current(T0*a1);
/*CHARACTER_CONSTANT*/void r481bracketed_pretty(T481*C,T2 a1);
/*CHARACTER_CONSTANT*/T0*r481non_void_no_dispatch_type(T0*a1);
/*CHARACTER_CONSTANT*/T0*r481to_string(T481*C);
/*CHARACTER_CONSTANT*/T6 r481side_effect_free(T0*a1);
/*CHARACTER_CONSTANT*/T0*r481resolve_in(T0*a1);
/*CHARACTER_CONSTANT*/T0*r481to_instruction(T481*C);
/*PRECURSOR_EXPRESSION*/T0*r500specialize_and_check(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/T0*r500to_expression(T500*C);
/*PRECURSOR_EXPRESSION*/void r500make(T500*C,T351 a1,T0*a2,T0*a3);
/*PRECURSOR_EXPRESSION*/T0*r500simplify(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/T0*r500static_simplify(T500*C);
/*PRECURSOR_EXPRESSION*/T0*r500specialize_in(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/void r500inline_dynamic_dispatch_(T500*C,T0*a1,T0*a2);
/*PRECURSOR_EXPRESSION*/void r500safety_check(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/void r500init(T500*C,T0*a1,T0*a2);
/*PRECURSOR_EXPRESSION*/void r500pretty_(T500*C,T2 a1);
/*PRECURSOR_EXPRESSION*/T0*r500specialize_thru(T500*C,T0*a1,T0*a2,T0*a3);
/*PRECURSOR_EXPRESSION*/T6 r500is_stored_in_some_local_variable(void);
/*PRECURSOR_EXPRESSION*/void r500accept(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/T0*r500adapt_for(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/T0*r500declaration_type(T500*C);
/*PRECURSOR_EXPRESSION*/T0*r500feature_accumulator(void);
/*PRECURSOR_EXPRESSION*/T0*r500collect(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/void r500pretty_target(T500*C,T2 a1);
/*PRECURSOR_EXPRESSION*/T0*r500twin(T500*C);
/*PRECURSOR_EXPRESSION*/T0*r500written_declaration_type_mark(T500*C);
/*PRECURSOR_EXPRESSION*/T6 r500use_current(T0*a1);
/*PRECURSOR_EXPRESSION*/T0*r500non_void_no_dispatch_type(T0*a1);
/*PRECURSOR_EXPRESSION*/T6 r500side_effect_free(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/T0*r500error_handler(void);
/*PRECURSOR_EXPRESSION*/T0*r500resolve_in(T500*C,T0*a1);
/*PRECURSOR_EXPRESSION*/T0*r500to_instruction(T500*C);
/*PRECURSOR_EXPRESSION*/T0*r500current_or_twin_init(T500*C,T0*a1,T0*a2);
/*FAKE_TARGET*/T0*r535to_expression(T535*C);
/*FAKE_TARGET*/void r535make(T535*C,T351 a1,T0*a2);
/*FAKE_TARGET*/void r535pretty(T535*C,T2 a1);
/*FAKE_TARGET*/T0*r535static_simplify(T535*C);
/*FAKE_TARGET*/T0*r535specialize_in(T535*C,T0*a1);
/*FAKE_TARGET*/void r535inline_dynamic_dispatch_(T535*C,T0*a1,T0*a2);
/*FAKE_TARGET*/T0*r535specialize_thru(T535*C,T0*a1,T0*a2,T0*a3);
/*FAKE_TARGET*/T6 r535is_stored_in_some_local_variable(void);
/*FAKE_TARGET*/void r535accept(T535*C,T0*a1);
/*FAKE_TARGET*/T0*r535adapt_for(T535*C,T0*a1);
/*FAKE_TARGET*/T0*r535declaration_type(T535*C);
/*FAKE_TARGET*/void r535pretty_target(T535*C,T2 a1);
/*FAKE_TARGET*/T0*r535twin(T535*C);
/*FAKE_TARGET*/T0*r535written_declaration_type_mark(T535*C);
/*FAKE_TARGET*/T6 r535use_current(T0*a1);
/*FAKE_TARGET*/void r535bracketed_pretty(T535*C,T2 a1);
/*FAKE_TARGET*/T0*r535non_void_no_dispatch_type(T0*a1);
/*FAKE_TARGET*/T6 r535side_effect_free(T0*a1);
/*FAKE_TARGET*/T0*r535resolve_in(T535*C,T0*a1);
/*FAKE_TARGET*/T0*r535to_instruction(T535*C);
/*FAKE_TARGET*/T0*r535current_or_twin_init(T535*C,T0*a1);
/*CREATE_EXPRESSION*/T0*r536specialize_and_check(T536*C,T0*a1);
/*CREATE_EXPRESSION*/T0*r536to_expression(T536*C);
/*CREATE_EXPRESSION*/void r536make(T536*C,T351 a1,T0*a2,T0*a3);
/*CREATE_EXPRESSION*/T0*r536created_type(T536*C,T0*a1);
/*CREATE_EXPRESSION*/void r536pretty(T536*C,T2 a1);
/*CREATE_EXPRESSION*/T0*r536simplify(T536*C,T0*a1);
/*CREATE_EXPRESSION*/void r536default_user_expanded(T536*C,T351 a1,T0*a2);
/*CREATE_EXPRESSION*/T0*r536static_simplify(T536*C);
/*CREATE_EXPRESSION*/T0*r536specialize_in(T536*C,T0*a1);
/*CREATE_EXPRESSION*/void r536inline_dynamic_dispatch_(T536*C,T0*a1,T0*a2);
/*CREATE_EXPRESSION*/void r536safety_check(T536*C,T0*a1);
/*CREATE_EXPRESSION*/void r536init(T536*C,T0*a1,T0*a2);
/*CREATE_EXPRESSION*/T0*r536extra_local_expanded(T536*C,T0*a1);
/*CREATE_EXPRESSION*/void r536specialize_checks(T536*C,T0*a1);
/*CREATE_EXPRESSION*/T0*r536specialize_thru(T536*C,T0*a1,T0*a2,T0*a3);
/*CREATE_EXPRESSION*/T6 r536is_stored_in_some_local_variable(void);
/*CREATE_EXPRESSION*/void r536accept(T536*C,T0*a1);
/*CREATE_EXPRESSION*/T0*r536adapt_for(T536*C,T0*a1);
/*CREATE_EXPRESSION*/T0*r536declaration_type(T536*C);
/*CREATE_EXPRESSION*/T0*r536default_create_name(void);
/*CREATE_EXPRESSION*/T0*r536collect(T536*C,T0*a1);
/*CREATE_EXPRESSION*/void r536pretty_target(T536*C,T2 a1);
/*CREATE_EXPRESSION*/T0*r536any_default_create_fs(void);
/*CREATE_EXPRESSION*/T0*r536twin(T536*C);
/*CREATE_EXPRESSION*/T0*r536written_declaration_type_mark(T536*C);
/*CREATE_EXPRESSION*/T0*r536creation_procedure(T536*C,T0*a1);
/*CREATE_EXPRESSION*/T6 r536use_current(T536*C,T0*a1);
/*CREATE_EXPRESSION*/void r536bracketed_pretty(T536*C,T2 a1);
/*CREATE_EXPRESSION*/T0*r536non_void_no_dispatch_type(T536*C,T0*a1);
/*CREATE_EXPRESSION*/T6 r536side_effect_free(T0*a1);
/*CREATE_EXPRESSION*/T0*r536arguments(T536*C);
/*CREATE_EXPRESSION*/T0*r536error_handler(void);
/*CREATE_EXPRESSION*/T0*r536resolve_in(T536*C,T0*a1);
/*CREATE_EXPRESSION*/T0*r536to_instruction(T536*C);
/*CREATE_EXPRESSION*/T0*r536current_or_twin_init(T536*C,T0*a1,T0*a2);
/*ARGUMENT_NAME_DEF*/void r468make(T468*C,T351 a1,T0*a2);
/*ARGUMENT_NAME_DEF*/T6 r468is_outside(T468*C,T0*a1);
/*ARGUMENT_NAME_DEF*/T0*r468specialize_in(T468*C,T0*a1);
/*ARGUMENT_NAME_DEF*/T6 r468is_used(T0*a1);
/*ARGUMENT_NAME_DEF*/T0*r468specialize_thru(T468*C,T0*a1,T0*a2,T0*a3);
/*ARGUMENT_NAME_DEF*/T0*r468adapt_for(T468*C,T0*a1);
/*ARGUMENT_NAME_DEF*/T0*r468collect(T468*C,T0*a1);
/*ARGUMENT_NAME_DEF*/T0*r468twin(T468*C);
/*ARGUMENT_NAME_DEF*/void r468set_outside(T468*C,T0*a1);
/*ARGUMENT_NAME_DEF*/T0*r468error_handler(void);
/*ARGUMENT_NAME_DEF*/T0*r468resolve_in(T468*C,T0*a1);
/*ARGUMENT_NAME_DEF*/void r468name_clash_check_(T468*C,T0*a1,T0*a2);
/*DECLARATION_GROUP*/void r469make(T469*C,T0*a1,T0*a2);
/*DECLARATION_GROUP*/T0*r469specialize_in(T469*C,T0*a1);
/*DECLARATION_GROUP*/void r469append_in_local_var_list(T469*C,T0*a1);
/*DECLARATION_GROUP*/T0*r469specialize_thru(T469*C,T0*a1,T0*a2,T0*a3);
/*DECLARATION_GROUP*/void r469append_in_formal_arg_list(T469*C,T0*a1);
/*DECLARATION_GROUP*/T0*r469twin(T469*C);
/*DECLARATION_GROUP*/void r469pretty_in(T469*C,T0*a1);
/*DECLARATION_GROUP*/T2 r469count(T469*C);
/*DECLARATION_1*/T406*create406make(T0*a1,T0*a2);
/*DECLARATION_1*/void r406make(T406*C,T0*a1,T0*a2);
/*DECLARATION_1*/T0*r406specialize_in(T406*C,T0*a1);
/*DECLARATION_1*/void r406append_in_local_var_list(T406*C,T0*a1);
/*DECLARATION_1*/T0*r406specialize_thru(T406*C,T0*a1,T0*a2,T0*a3);
/*DECLARATION_1*/void r406append_in_formal_arg_list(T406*C,T0*a1);
/*DECLARATION_1*/T0*r406twin(T406*C);
/*DECLARATION_1*/void r406pretty_in(T406*C,T0*a1);
/*REQUIRE_ASSERTION*/T0*r684specialize_and_check(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/T0*r684to_expression(T684*C);
/*REQUIRE_ASSERTION*/void r684make(T684*C,T351 a1,T6 a2,T0*a3,T0*a4);
/*REQUIRE_ASSERTION*/void r684pretty(T684*C,T2 a1);
/*REQUIRE_ASSERTION*/T0*r684simplify(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/T0*r684specialize_in(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/void r684inline_dynamic_dispatch_(T684*C,T0*a1,T0*a2);
/*REQUIRE_ASSERTION*/void r684add_parent_require(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/T6 r684is_always_true(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/void r684safety_check(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/void r684from_parents(T684*C,T0*a1,T0*a2);
/*REQUIRE_ASSERTION*/T6 r684has_item_located_at(T684*C,T351 a1);
/*REQUIRE_ASSERTION*/T0*r684specialize_thru(T684*C,T0*a1,T0*a2,T0*a3);
/*REQUIRE_ASSERTION*/void r684accept(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/T0*r684adapt_for(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/T0*r684item(T684*C,T2 a1);
/*REQUIRE_ASSERTION*/T0*r684collect(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/T351 r684start_position(T684*C);
/*REQUIRE_ASSERTION*/T0*r684twin(T684*C);
/*REQUIRE_ASSERTION*/T6 r684use_current(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/void r684crash(T684*C);
/*REQUIRE_ASSERTION*/T6 r684side_effect_free(T684*C,T0*a1);
/*REQUIRE_ASSERTION*/T0*r684inline_dynamic_dispatch(T684*C,T0*a1,T0*a2);
/*REQUIRE_ASSERTION*/void r684not_yet_implemented(T684*C);
/*REQUIRE_ASSERTION*/T2 r684count(T684*C);
/*REQUIRE_ASSERTION*/T0*r684to_instruction(T684*C);
/*ASSERTION*/T0*r435specialize_and_check(T435*C,T0*a1);
/*ASSERTION*/T0*r435to_expression(T435*C);
/*ASSERTION*/void r435make(T435*C,T0*a1,T0*a2,T0*a3);
/*ASSERTION*/void r435pretty(T435*C,T2 a1);
/*ASSERTION*/T0*r435static_simplify(T435*C);
/*ASSERTION*/T0*r435specialize_in(T435*C,T0*a1);
/*ASSERTION*/void r435inline_dynamic_dispatch_(T435*C,T0*a1,T0*a2);
/*ASSERTION*/T6 r435is_always_true(T435*C,T0*a1);
/*ASSERTION*/void r435safety_check(T435*C,T0*a1);
/*ASSERTION*/T0*r435specialize_thru(T435*C,T0*a1,T0*a2,T0*a3);
/*ASSERTION*/T6 r435is_static(T435*C);
/*ASSERTION*/void r435specialize_check(T435*C,T0*a1);
/*ASSERTION*/T6 r435is_stored_in_some_local_variable(void);
/*ASSERTION*/void r435accept(T435*C,T0*a1);
/*ASSERTION*/T0*r435adapt_for(T435*C,T0*a1);
/*ASSERTION*/T0*r435collect(T435*C,T0*a1);
/*ASSERTION*/T351 r435start_position(T435*C);
/*ASSERTION*/T0*r435twin(T435*C);
/*ASSERTION*/T0*r435written_declaration_type_mark(void);
/*ASSERTION*/T6 r435use_current(T435*C,T0*a1);
/*ASSERTION*/T0*r435non_void_no_dispatch_type(T0*a1);
/*ASSERTION*/T6 r435side_effect_free(T435*C,T0*a1);
/*ASSERTION*/T0*r435error_handler(void);
/*ASSERTION*/T0*r435resolve_in(T0*a1);
/*ASSERTION*/T0*r435to_instruction(T435*C);
/*ASSERTION*/T0*r435current_or_twin_init(T435*C,T0*a1);
/*LOCAL_NAME_DEF*/void r403make(T403*C,T351 a1,T0*a2);
/*LOCAL_NAME_DEF*/T6 r403is_outside(T403*C,T0*a1);
/*LOCAL_NAME_DEF*/T0*r403specialize_in(T403*C,T0*a1);
/*LOCAL_NAME_DEF*/void r403parsing_reference_counter_increment(T403*C);
/*LOCAL_NAME_DEF*/void r403live_reference_counter_increment(T403*C);
/*LOCAL_NAME_DEF*/T6 r403is_used(T403*C,T0*a1);
/*LOCAL_NAME_DEF*/T0*r403specialize_thru(T403*C,T0*a1,T0*a2,T0*a3);
/*LOCAL_NAME_DEF*/T0*r403adapt_for(T403*C,T0*a1);
/*LOCAL_NAME_DEF*/T0*r403collect(T403*C,T0*a1);
/*LOCAL_NAME_DEF*/T0*r403twin(T403*C);
/*LOCAL_NAME_DEF*/void r403usage_warning_check(T403*C,T0*a1);
/*LOCAL_NAME_DEF*/void r403set_outside(T403*C,T0*a1);
/*LOCAL_NAME_DEF*/T0*r403error_handler(void);
/*LOCAL_NAME_DEF*/T0*r403resolve_in(T403*C,T0*a1);
/*LOCAL_NAME_DEF*/void r403name_clash_check_(T403*C,T0*a1,T0*a2);
/*CHECK_COMPOUND*/T0*r537specialize_and_check(T537*C,T0*a1);
/*CHECK_COMPOUND*/T0*r537to_expression(T537*C);
/*CHECK_COMPOUND*/void r537make(T537*C,T351 a1,T0*a2,T0*a3);
/*CHECK_COMPOUND*/void r537pretty(T537*C,T2 a1);
/*CHECK_COMPOUND*/T0*r537simplify(T537*C,T0*a1);
/*CHECK_COMPOUND*/void r537pretty_index(T537*C,T2 a1,T0*a2);
/*CHECK_COMPOUND*/T0*r537specialize_in(T537*C,T0*a1);
/*CHECK_COMPOUND*/void r537inline_dynamic_dispatch_(T537*C,T0*a1,T0*a2);
/*CHECK_COMPOUND*/void r537safety_check(T537*C,T0*a1);
/*CHECK_COMPOUND*/T0*r537specialize_thru(T537*C,T0*a1,T0*a2,T0*a3);
/*CHECK_COMPOUND*/T6 r537must_be_generated(T537*C,T0*a1);
/*CHECK_COMPOUND*/void r537accept(T537*C,T0*a1);
/*CHECK_COMPOUND*/T0*r537adapt_for(T537*C,T0*a1);
/*CHECK_COMPOUND*/T0*r537collect(T537*C,T0*a1);
/*CHECK_COMPOUND*/T351 r537start_position(T537*C);
/*CHECK_COMPOUND*/T0*r537twin(T537*C);
/*CHECK_COMPOUND*/T6 r537use_current(T537*C,T0*a1);
/*CHECK_COMPOUND*/T6 r537side_effect_free(T0*a1);
/*CHECK_COMPOUND*/T0*r537inline_dynamic_dispatch(T537*C,T0*a1,T0*a2);
/*CHECK_COMPOUND*/void r537add_index_clause(T537*C,T0*a1);
/*CHECK_COMPOUND*/T0*r537to_instruction(T537*C);
/*CHECK_COMPOUND*/T0*r537current_or_twin_init(T537*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496specialize_and_check(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496to_expression(T496*C);
/*DEBUG_COMPOUND*/void r496make(T496*C,T351 a1,T0*a2,T0*a3);
/*DEBUG_COMPOUND*/void r496pretty(T496*C,T2 a1);
/*DEBUG_COMPOUND*/T0*r496simplify(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496specialize_in(T496*C,T0*a1);
/*DEBUG_COMPOUND*/void r496inline_dynamic_dispatch_(T496*C,T0*a1,T0*a2);
/*DEBUG_COMPOUND*/void r496safety_check(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496specialize_thru(T496*C,T0*a1,T0*a2,T0*a3);
/*DEBUG_COMPOUND*/T6 r496must_be_generated(T496*C,T0*a1);
/*DEBUG_COMPOUND*/void r496accept(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496adapt_for(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496collect(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496twin(T496*C);
/*DEBUG_COMPOUND*/T6 r496use_current(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T6 r496side_effect_free(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496inline_dynamic_dispatch(T496*C,T0*a1,T0*a2);
/*DEBUG_COMPOUND*/T6 r496match_debug_key(T496*C,T0*a1);
/*DEBUG_COMPOUND*/T0*r496to_instruction(T496*C);
/*DEBUG_COMPOUND*/T0*r496current_or_twin_init(T496*C,T0*a1);
/*IFTHEN*/T427*create427make(T351 a1,T0*a2,T0*a3);
/*IFTHEN*/T0*r427specialize_and_check(T427*C,T0*a1);
/*IFTHEN*/T0*r427to_expression(T427*C);
/*IFTHEN*/void r427make(T427*C,T351 a1,T0*a2,T0*a3);
/*IFTHEN*/void r427pretty(T427*C,T2 a1);
/*IFTHEN*/T0*r427simplify(T427*C,T0*a1);
/*IFTHEN*/void r427specialize_check_(T427*C,T0*a1);
/*IFTHEN*/void r427pretty_end_if(T2 a1);
/*IFTHEN*/T0*r427specialize_in(T427*C,T0*a1);
/*IFTHEN*/void r427inline_dynamic_dispatch_(T427*C,T0*a1,T0*a2);
/*IFTHEN*/void r427safety_check(T427*C,T0*a1);
/*IFTHEN*/void r427init(T427*C,T0*a1,T0*a2);
/*IFTHEN*/void r427pretty_(T427*C,T2 a1,T0*a2);
/*IFTHEN*/T0*r427specialize_thru(T427*C,T0*a1,T0*a2,T0*a3);
/*IFTHEN*/void r427accept(T427*C,T0*a1);
/*IFTHEN*/T0*r427adapt_for(T427*C,T0*a1);
/*IFTHEN*/T0*r427collect(T427*C,T0*a1);
/*IFTHEN*/T0*r427twin(T427*C);
/*IFTHEN*/T6 r427use_current(T427*C,T0*a1);
/*IFTHEN*/T6 r427side_effect_free(T0*a1);
/*IFTHEN*/T0*r427error_handler(void);
/*IFTHEN*/T0*r427inline_dynamic_dispatch(T427*C,T0*a1,T0*a2);
/*IFTHEN*/T0*r427to_instruction(T427*C);
/*IFTHEN*/T0*r427current_or_twin_init(T427*C,T0*a1,T0*a2);
/*IFTHENELSE*/T0*r413specialize_and_check(T413*C,T0*a1);
/*IFTHENELSE*/T0*r413to_expression(T413*C);
/*IFTHENELSE*/void r413pretty(T413*C,T2 a1);
/*IFTHENELSE*/T0*r413simplify(T413*C,T0*a1);
/*IFTHENELSE*/void r413inline_dd(T413*C,T0*a1,T0*a2,T0*a3,T2 a4);
/*IFTHENELSE*/void r413specialize_check_(T413*C,T0*a1);
/*IFTHENELSE*/void r413pretty_end_if(T2 a1);
/*IFTHENELSE*/T0*r413specialize_in(T413*C,T0*a1);
/*IFTHENELSE*/void r413inline_dynamic_dispatch_(T413*C,T0*a1,T0*a2);
/*IFTHENELSE*/void r413safety_check(T413*C,T0*a1);
/*IFTHENELSE*/void r413init(T413*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*IFTHENELSE*/void r413pretty_(T413*C,T2 a1,T0*a2);
/*IFTHENELSE*/T0*r413specialize_thru(T413*C,T0*a1,T0*a2,T0*a3);
/*IFTHENELSE*/T0*r413simplify_elseif_list(T0*a1,T6 a2,T0*a3);
/*IFTHENELSE*/void r413specialize_check(T413*C,T0*a1);
/*IFTHENELSE*/void r413accept(T413*C,T0*a1);
/*IFTHENELSE*/T0*r413adapt_for(T413*C,T0*a1);
/*IFTHENELSE*/T0*r413collect(T413*C,T0*a1);
/*IFTHENELSE*/T0*r413twin(T413*C);
/*IFTHENELSE*/T6 r413use_current(T413*C,T0*a1);
/*IFTHENELSE*/T6 r413side_effect_free(T0*a1);
/*IFTHENELSE*/void r413with_else(T413*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*IFTHENELSE*/void r413with_elseif(T413*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*IFTHENELSE*/T0*r413error_handler(void);
/*IFTHENELSE*/T0*r413inline_dynamic_dispatch(T413*C,T0*a1,T0*a2);
/*IFTHENELSE*/void r413with_elseif_and_else(T413*C,T351 a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*IFTHENELSE*/T0*r413to_instruction(T413*C);
/*IFTHENELSE*/T0*r413current_or_twin_init(T413*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*WHEN_CLAUSE*/T0*r371adapt_for(T371*C,T0*a1);
/*WHEN_CLAUSE*/void r371not_yet_implemented(T371*C);
/*WHEN_CLAUSE*/T0*r371collect(T371*C,T0*a1);
/*WHEN_CLAUSE*/T0*r371specialize_in(T371*C,T0*a1);
/*WHEN_CLAUSE*/T6 r371validity_check_continued(T371*C,T0*a1,T0*a2,T0*a3);
/*WHEN_CLAUSE*/void r371make_dynamic_dispatch(T371*C,T0*a1,T351 a2,T0*a3);
/*WHEN_CLAUSE*/T0*r371simplify(T371*C,T0*a1);
/*WHEN_CLAUSE*/T6 r371match_value(T371*C,T2 a1);
/*WHEN_CLAUSE*/T0*r371specialize_and_check_integer(T371*C,T0*a1);
/*WHEN_CLAUSE*/void r371safety_check(T371*C,T0*a1);
/*WHEN_CLAUSE*/void r371force_internal_character_values(T371*C,T0*a1);
/*WHEN_CLAUSE*/T0*r371to_expression(T371*C);
/*WHEN_CLAUSE*/void r371add_value(T371*C,T0*a1);
/*WHEN_CLAUSE*/T0*r371specialize_thru(T371*C,T0*a1,T0*a2,T0*a3);
/*WHEN_CLAUSE*/T0*r371specialize_and_check(T371*C,T0*a1);
/*WHEN_CLAUSE*/T0*r371specialize_and_check_when_items_integer(T371*C,T0*a1,T0*a2);
/*WHEN_CLAUSE*/void r371inline_dynamic_dispatch_(T371*C,T0*a1,T0*a2);
/*WHEN_CLAUSE*/T0*r371to_instruction(T371*C);
/*WHEN_CLAUSE*/void r371make(T371*C,T0*a1,T351 a2,T0*a3);
/*WHEN_CLAUSE*/void r371make_strippable(T371*C,T0*a1,T0*a2);
/*WHEN_CLAUSE*/T6 r371is_live(T371*C,T0*a1);
/*WHEN_CLAUSE*/void r371no_manifest_string_slice_check(T0*a1);
/*WHEN_CLAUSE*/T0*r371specialize_and_check_character(T371*C,T0*a1);
/*WHEN_CLAUSE*/void r371crash(T371*C);
/*WHEN_CLAUSE*/T6 r371is_more_complex_than(T371*C,T0*a1);
/*WHEN_CLAUSE*/void r371force_internal_integer_values(T371*C,T0*a1);
/*WHEN_CLAUSE*/T2 r371parser_add_value(T371*C,T2 a1,T0*a2);
/*WHEN_CLAUSE*/T6 r371use_current(T371*C,T0*a1);
/*WHEN_CLAUSE*/void r371init(T371*C,T0*a1,T0*a2);
/*WHEN_CLAUSE*/void r371validity_check(T371*C,T0*a1,T0*a2,T0*a3);
/*WHEN_CLAUSE*/T0*r371specialize_and_check_string(T371*C,T0*a1);
/*WHEN_CLAUSE*/void r371parser_make(T371*C,T351 a1,T0*a2);
/*WHEN_CLAUSE*/void r371pretty(T371*C,T2 a1);
/*WHEN_CLAUSE*/T0*r371strip_or_set_value(T371*C,T2 a1,T0*a2,T0*a3);
/*WHEN_CLAUSE*/T0*r371inline_dynamic_dispatch(T371*C,T0*a1,T0*a2);
/*WHEN_CLAUSE*/T6 r371side_effect_free(T371*C,T0*a1);
/*WHEN_CLAUSE*/T0*r371twin(T371*C);
/*WHEN_CLAUSE*/void r371compute_values(T371*C,T0*a1);
/*WHEN_CLAUSE*/T2 r371largest_range_of_values(T371*C);
/*WHEN_CLAUSE*/void r371add_slice(T371*C,T0*a1,T0*a2);
/*WHEN_CLAUSE*/T0*r371error_handler(void);
/*WHEN_CLAUSE*/void r371accept(T371*C,T0*a1);
/*WHEN_CLAUSE*/T0*r371create_merged_with(T371*C,T0*a1);
/*IMPLICIT_CURRENT*/T384*create384make(T351 a1);
/*IMPLICIT_CURRENT*/T0*r384to_expression(T384*C);
/*IMPLICIT_CURRENT*/void r384make(T384*C,T351 a1);
/*IMPLICIT_CURRENT*/void r384pretty(T2 a1);
/*IMPLICIT_CURRENT*/T0*r384simplify(T384*C,T0*a1);
/*IMPLICIT_CURRENT*/T0*r384static_simplify(T384*C);
/*IMPLICIT_CURRENT*/T0*r384specialize_in(T384*C,T0*a1);
/*IMPLICIT_CURRENT*/void r384inline_dynamic_dispatch_(T384*C,T0*a1,T0*a2);
/*IMPLICIT_CURRENT*/T6 r384is_stored_in_some_local_variable(void);
/*IMPLICIT_CURRENT*/void r384accept(T384*C,T0*a1);
/*IMPLICIT_CURRENT*/T0*r384collect(T0*a1);
/*IMPLICIT_CURRENT*/T0*r384twin(T384*C);
/*IMPLICIT_CURRENT*/T6 r384use_current(T0*a1);
/*IMPLICIT_CURRENT*/void r384bracketed_pretty(T2 a1);
/*IMPLICIT_CURRENT*/T0*r384non_void_no_dispatch_type(T0*a1);
/*IMPLICIT_CURRENT*/T6 r384side_effect_free(T0*a1);
/*IMPLICIT_CURRENT*/T0*r384resolve_in(T0*a1);
/*IMPLICIT_CURRENT*/T0*r384to_instruction(T384*C);
/*OTHER_INSPECT_STATEMENT*/T0*r376specialize_and_check(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/void r376make_strippable(T376*C,T351 a1,T0*a2,T0*a3);
/*OTHER_INSPECT_STATEMENT*/T0*r376to_expression(T376*C);
/*OTHER_INSPECT_STATEMENT*/void r376make(T376*C,T351 a1,T0*a2);
/*OTHER_INSPECT_STATEMENT*/void r376with_when_list(T376*C,T351 a1,T0*a2,T0*a3);
extern T0*oBC32is_empty_name;
extern int fBC32is_empty_name;
/*OTHER_INSPECT_STATEMENT*/T0*r376is_empty_name(void);
/*OTHER_INSPECT_STATEMENT*/void r376pretty(T376*C,T2 a1);
/*OTHER_INSPECT_STATEMENT*/T0*r376simplify(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/void r376force_internal_values(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/void r376validity_check(T376*C,T0*a1,T0*a2);
/*OTHER_INSPECT_STATEMENT*/T0*r376specialize_in(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/void r376inline_dynamic_dispatch_(T376*C,T0*a1,T0*a2);
/*OTHER_INSPECT_STATEMENT*/T6 r376same_compound(T0*a1,T0*a2,T0*a3);
/*OTHER_INSPECT_STATEMENT*/void r376safety_check(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/T0*r376is_empty_call(T376*C,T0*a1,T0*a2);
/*OTHER_INSPECT_STATEMENT*/void r376init(T376*C,T0*a1,T0*a2,T0*a3);
/*OTHER_INSPECT_STATEMENT*/T0*r376count_call(T376*C,T0*a1,T0*a2);
/*OTHER_INSPECT_STATEMENT*/void r376set_else_compound(T376*C,T351 a1,T0*a2);
/*OTHER_INSPECT_STATEMENT*/T0*r376specialize_thru(T376*C,T0*a1,T0*a2,T0*a3);
extern T0*oBC377code_comparator;
/*OTHER_INSPECT_STATEMENT*/T0*r376count_name(void);
/*OTHER_INSPECT_STATEMENT*/void r376accept(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/void r376validity_check_continued(T376*C,T0*a1,T0*a2,T0*a3);
/*OTHER_INSPECT_STATEMENT*/void r376add_when(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/T0*r376adapt_for(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/T2 r376largest_range_of_values(T376*C);
/*OTHER_INSPECT_STATEMENT*/T6 r376use_c_switch_statement(T376*C);
/*OTHER_INSPECT_STATEMENT*/T0*r376collect(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/T0*r376item_call(T376*C,T0*a1,T0*a2);
/*OTHER_INSPECT_STATEMENT*/T0*r376twin(T376*C);
/*OTHER_INSPECT_STATEMENT*/T6 r376use_current(T376*C,T0*a1);
extern T0*oBC32item_name;
extern int fBC32item_name;
/*OTHER_INSPECT_STATEMENT*/T0*r376item_name(void);
/*OTHER_INSPECT_STATEMENT*/T6 r376side_effect_free(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/T0*r376error_handler(void);
/*OTHER_INSPECT_STATEMENT*/T0*r376inline_dynamic_dispatch(T376*C,T0*a1,T0*a2);
/*OTHER_INSPECT_STATEMENT*/void r376compute_values(T376*C,T0*a1);
/*OTHER_INSPECT_STATEMENT*/T0*r376to_instruction(T376*C);
/*OTHER_INSPECT_STATEMENT*/T0*r376current_or_twin_init(T376*C,T0*a1,T0*a2,T0*a3);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498specialize_and_check(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498to_expression(T498*C);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498with_when_list(T498*C,T351 a1,T0*a2,T0*a3);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498is_empty_name(void);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498pretty(T498*C,T2 a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498simplify(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498validity_check(T498*C,T0*a1,T0*a2);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498specialize_in(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498inline_dynamic_dispatch_(T498*C,T0*a1,T0*a2);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T6 r498same_compound(T0*a1,T0*a2,T0*a3);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498safety_check(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498is_empty_call(T498*C,T0*a1,T0*a2);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498init(T498*C,T0*a1,T0*a2,T0*a3);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498count_call(T498*C,T0*a1,T0*a2);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498set_else_compound(T498*C,T351 a1,T0*a2);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498specialize_thru(T498*C,T0*a1,T0*a2,T0*a3);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498count_name(void);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498accept(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498validity_check_continued(T498*C,T0*a1,T0*a2,T0*a3);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498add_when(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498adapt_for(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T2 r498largest_range_of_values(T498*C);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T6 r498use_c_switch_statement(T498*C);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498collect(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498item_call(T498*C,T0*a1,T0*a2);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498twin(T498*C);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T6 r498use_current(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498item_name(void);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T6 r498side_effect_free(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498error_handler(void);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498inline_dynamic_dispatch(T498*C,T0*a1,T0*a2);
/*MANIFEST_STRING_INSPECT_STATEMENT*/void r498compute_values(T498*C,T0*a1);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498to_instruction(T498*C);
/*MANIFEST_STRING_INSPECT_STATEMENT*/T0*r498current_or_twin_init(T498*C,T0*a1,T0*a2,T0*a3);
/*ASSERTION_LIST*/T0*r443specialize_and_check(T443*C,T0*a1);
/*ASSERTION_LIST*/T0*r443to_expression(T443*C);
/*ASSERTION_LIST*/void r443make(T443*C,T351 a1,T0*a2,T0*a3);
/*ASSERTION_LIST*/void r443pretty(T443*C,T2 a1);
/*ASSERTION_LIST*/T0*r443simplify(T443*C,T0*a1);
/*ASSERTION_LIST*/T0*r443specialize_in(T443*C,T0*a1);
/*ASSERTION_LIST*/void r443inline_dynamic_dispatch_(T443*C,T0*a1,T0*a2);
/*ASSERTION_LIST*/T6 r443is_always_true(T443*C,T0*a1);
/*ASSERTION_LIST*/void r443safety_check(T443*C,T0*a1);
/*ASSERTION_LIST*/void r443for_each(T443*C,T0*a1);
/*ASSERTION_LIST*/void r443set_list(T443*C,T0*a1);
/*ASSERTION_LIST*/T0*r443specialize_thru(T443*C,T0*a1,T0*a2,T0*a3);
/*ASSERTION_LIST*/void r443pretty_as_loop_invariant(T443*C,T2 a1);
/*ASSERTION_LIST*/T2 r443upper(T443*C);
/*ASSERTION_LIST*/void r443accept(T443*C,T0*a1);
/*ASSERTION_LIST*/void r443set_eiffel_parser_stamp(T443*C,T2 a1);
/*ASSERTION_LIST*/T0*r443adapt_for(T443*C,T0*a1);
/*ASSERTION_LIST*/T0*r443item(T443*C,T2 a1);
/*ASSERTION_LIST*/T0*r443collect(T443*C,T0*a1);
/*ASSERTION_LIST*/void r443pretty_print_with_tag(T443*C,T2 a1,T0*a2);
/*ASSERTION_LIST*/T6 r443is_empty(T443*C);
/*ASSERTION_LIST*/T0*r443twin(T443*C);
/*ASSERTION_LIST*/void r443pretty_as_check_compound(T443*C,T2 a1,T0*a2);
/*ASSERTION_LIST*/T6 r443use_current(T443*C,T0*a1);
/*ASSERTION_LIST*/void r443crash(T443*C);
/*ASSERTION_LIST*/void r443breakpoint(T443*C);
/*ASSERTION_LIST*/T6 r443side_effect_free(T443*C,T0*a1);
/*ASSERTION_LIST*/T0*r443inline_dynamic_dispatch(T443*C,T0*a1,T0*a2);
/*ASSERTION_LIST*/void r443not_yet_implemented(T443*C);
/*ASSERTION_LIST*/T2 r443lower(T443*C);
/*ASSERTION_LIST*/T0*r443to_instruction(T443*C);
/*ASSERTION_LIST*/T0*r443specialize_without_checks(T443*C,T0*a1);
/*LOOP_VARIANT*/T0*r484specialize_and_check(T484*C,T0*a1);
/*LOOP_VARIANT*/T0*r484to_expression(T484*C);
/*LOOP_VARIANT*/void r484make(T484*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*LOOP_VARIANT*/void r484pretty(T484*C,T2 a1);
/*LOOP_VARIANT*/T0*r484simplify(T484*C,T0*a1);
/*LOOP_VARIANT*/T0*r484static_simplify(T484*C);
/*LOOP_VARIANT*/T0*r484specialize_in(T484*C,T0*a1);
/*LOOP_VARIANT*/void r484inline_dynamic_dispatch_(T484*C,T0*a1,T0*a2);
/*LOOP_VARIANT*/void r484safety_check(T484*C,T0*a1);
/*LOOP_VARIANT*/T0*r484specialize_thru(T484*C,T0*a1,T0*a2,T0*a3);
/*LOOP_VARIANT*/void r484specialize_check(T484*C,T0*a1);
/*LOOP_VARIANT*/T6 r484is_stored_in_some_local_variable(void);
/*LOOP_VARIANT*/void r484accept(T484*C,T0*a1);
/*LOOP_VARIANT*/T0*r484declaration_type(T484*C);
/*LOOP_VARIANT*/T0*r484collect(T484*C,T0*a1);
/*LOOP_VARIANT*/T351 r484start_position(T484*C);
/*LOOP_VARIANT*/T0*r484twin(T484*C);
/*LOOP_VARIANT*/T0*r484written_declaration_type_mark(T484*C);
/*LOOP_VARIANT*/T6 r484use_current(T484*C,T0*a1);
/*LOOP_VARIANT*/T0*r484non_void_no_dispatch_type(T0*a1);
/*LOOP_VARIANT*/T6 r484side_effect_free(T484*C,T0*a1);
/*LOOP_VARIANT*/T0*r484error_handler(void);
/*LOOP_VARIANT*/T0*r484resolve_in(T484*C,T0*a1);
/*LOOP_VARIANT*/T0*r484to_instruction(T484*C);
/*LOOP_INSTRUCTION*/T0*r485specialize_and_check(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/T0*r485to_expression(T485*C);
/*LOOP_INSTRUCTION*/void r485make(T485*C,T351 a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*LOOP_INSTRUCTION*/void r485pretty(T485*C,T2 a1);
/*LOOP_INSTRUCTION*/T0*r485simplify(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/T0*r485specialize_in(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/void r485inline_dynamic_dispatch_(T485*C,T0*a1,T0*a2);
/*LOOP_INSTRUCTION*/void r485safety_check(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/T0*r485specialize_thru(T485*C,T0*a1,T0*a2,T0*a3);
/*LOOP_INSTRUCTION*/void r485specialize_check(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/void r485accept(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/T0*r485adapt_for(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/T0*r485collect(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/T6 r485use_current(T485*C,T0*a1);
/*LOOP_INSTRUCTION*/T6 r485side_effect_free(T0*a1);
/*LOOP_INSTRUCTION*/T0*r485error_handler(void);
/*LOOP_INSTRUCTION*/T0*r485inline_dynamic_dispatch(T485*C,T0*a1,T0*a2);
/*LOOP_INSTRUCTION*/T0*r485to_instruction(T485*C);
/*LOOP_INSTRUCTION*/T6 r485loop_check(T0*a1);
/*RESULT*/T0*r378to_expression(T378*C);
/*RESULT*/void r378make(T378*C,T351 a1);
/*RESULT*/void r378pretty(T2 a1);
/*RESULT*/T0*r378simplify(T378*C,T0*a1);
/*RESULT*/void r378validity_check(T378*C,T0*a1);
/*RESULT*/T0*r378static_simplify(T378*C);
/*RESULT*/T0*r378specialize_in(T378*C,T0*a1);
/*RESULT*/void r378inline_dynamic_dispatch_(T378*C,T0*a1,T0*a2);
/*RESULT*/void r378set_enclosing_function(T378*C,T0*a1);
/*RESULT*/T0*r378specialize_thru(T378*C,T0*a1,T0*a2,T0*a3);
/*RESULT*/void r378set_type_mark_memory(T378*C,T0*a1);
/*RESULT*/T6 r378is_stored_in_some_local_variable(void);
/*RESULT*/void r378accept(T378*C,T0*a1);
/*RESULT*/T0*r378adapt_for(T378*C,T0*a1);
/*RESULT*/T0*r378feature_accumulator(void);
/*RESULT*/T0*r378collect(T0*a1);
/*RESULT*/void r378pretty_target(T2 a1);
/*RESULT*/T0*r378twin(T378*C);
/*RESULT*/T6 r378use_current(T0*a1);
/*RESULT*/void r378bracketed_pretty(T2 a1);
/*RESULT*/T0*r378non_void_no_dispatch_type(T378*C,T0*a1);
/*RESULT*/T6 r378side_effect_free(T0*a1);
/*RESULT*/T0*r378error_handler(void);
/*RESULT*/T0*r378resolve_in(T378*C,T0*a1);
/*RESULT*/T0*r378to_instruction(T378*C);
/*RESULT*/T0*r378current_or_twin_init(T378*C,T0*a1);
/*CREATE_INSTRUCTION*/T0*r419specialize_and_check(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/T0*r419to_expression(T419*C);
/*CREATE_INSTRUCTION*/void r419make(T419*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*CREATE_INSTRUCTION*/T0*r419created_type(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/void r419typed_internals(T419*C,T351 a1,T0*a2);
/*CREATE_INSTRUCTION*/void r419pretty(T419*C,T2 a1);
/*CREATE_INSTRUCTION*/T0*r419simplify(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/T0*r419specialize_in(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/void r419inline_dynamic_dispatch_(T419*C,T0*a1,T0*a2);
/*CREATE_INSTRUCTION*/void r419safety_check(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/void r419set_call(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/void r419init(T419*C,T0*a1,T0*a2,T0*a3);
/*CREATE_INSTRUCTION*/void r419specialize_checks(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/T0*r419specialize_thru(T419*C,T0*a1,T0*a2,T0*a3);
/*CREATE_INSTRUCTION*/void r419accept(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/void r419set_eiffel_parser_stamp(T419*C,T2 a1);
/*CREATE_INSTRUCTION*/T0*r419adapt_for(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/T0*r419default_create_name(void);
/*CREATE_INSTRUCTION*/T0*r419collect(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/T0*r419any_default_create_fs(void);
/*CREATE_INSTRUCTION*/T0*r419twin(T419*C);
/*CREATE_INSTRUCTION*/T0*r419creation_procedure(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/T6 r419use_current(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/T6 r419side_effect_free(T0*a1);
/*CREATE_INSTRUCTION*/T0*r419arguments(T419*C);
/*CREATE_INSTRUCTION*/T0*r419error_handler(void);
/*CREATE_INSTRUCTION*/T0*r419inline_dynamic_dispatch(T419*C,T0*a1,T0*a2);
/*CREATE_INSTRUCTION*/void r419make_specialized(T419*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*CREATE_INSTRUCTION*/T0*r419to_instruction(T419*C);
/*CREATE_INSTRUCTION*/T0*r419specialize_without_checks(T419*C,T0*a1);
/*CREATE_INSTRUCTION*/T0*r419current_or_twin_init(T419*C,T0*a1,T0*a2,T0*a3);
/*C_INLINE*/T0*r482specialize_and_check(T482*C,T0*a1);
/*C_INLINE*/T0*r482to_expression(T482*C);
/*C_INLINE*/void r482pretty(T482*C,T2 a1);
/*C_INLINE*/T0*r482simplify(T482*C,T0*a1);
/*C_INLINE*/void r482inline_dynamic_dispatch_(T482*C,T0*a1,T0*a2);
/*C_INLINE*/void r482accept(T482*C,T0*a1);
/*C_INLINE*/void r482make_c_inline_h(T482*C,T351 a1,T0*a2);
/*C_INLINE*/void r482make_c_inline_c(T482*C,T351 a1,T0*a2);
/*C_INLINE*/T6 r482use_current(T482*C,T0*a1);
/*C_INLINE*/T6 r482side_effect_free(T0*a1);
/*C_INLINE*/T0*r482inline_dynamic_dispatch(T482*C,T0*a1,T0*a2);
/*C_INLINE*/T0*r482to_instruction(T482*C);
/*PRECURSOR_INSTRUCTION*/T0*r513specialize_and_check(T513*C,T0*a1);
/*PRECURSOR_INSTRUCTION*/T0*r513to_expression(T513*C);
/*PRECURSOR_INSTRUCTION*/void r513make(T513*C,T351 a1,T0*a2,T0*a3);
/*PRECURSOR_INSTRUCTION*/void r513pretty(T513*C,T2 a1);
/*PRECURSOR_INSTRUCTION*/T0*r513simplify(T513*C,T0*a1);
/*PRECURSOR_INSTRUCTION*/T0*r513specialize_in(T513*C,T0*a1);
/*PRECURSOR_INSTRUCTION*/void r513inline_dynamic_dispatch_(T513*C,T0*a1,T0*a2);
/*PRECURSOR_INSTRUCTION*/void r513safety_check(T513*C,T0*a1);
/*PRECURSOR_INSTRUCTION*/void r513init(T513*C,T0*a1,T0*a2);
/*PRECURSOR_INSTRUCTION*/void r513pretty_(T513*C,T2 a1);
/*PRECURSOR_INSTRUCTION*/T0*r513specialize_thru(T513*C,T0*a1,T0*a2,T0*a3);
/*PRECURSOR_INSTRUCTION*/void r513accept(T513*C,T0*a1);
/*PRECURSOR_INSTRUCTION*/T0*r513adapt_for(T513*C,T0*a1);
/*PRECURSOR_INSTRUCTION*/T0*r513feature_accumulator(void);
/*PRECURSOR_INSTRUCTION*/T0*r513collect(T513*C,T0*a1);
/*PRECURSOR_INSTRUCTION*/T0*r513twin(T513*C);
/*PRECURSOR_INSTRUCTION*/T6 r513use_current(T0*a1);
/*PRECURSOR_INSTRUCTION*/T6 r513side_effect_free(T513*C,T0*a1);
/*PRECURSOR_INSTRUCTION*/T0*r513error_handler(void);
/*PRECURSOR_INSTRUCTION*/T0*r513inline_dynamic_dispatch(T513*C,T0*a1,T0*a2);
/*PRECURSOR_INSTRUCTION*/T0*r513to_instruction(T513*C);
/*PRECURSOR_INSTRUCTION*/T0*r513current_or_twin_init(T513*C,T0*a1,T0*a2);
/*WRITTEN_CURRENT*/T503*create503make(T351 a1);
/*WRITTEN_CURRENT*/T0*r503to_expression(T503*C);
/*WRITTEN_CURRENT*/void r503make(T503*C,T351 a1);
/*WRITTEN_CURRENT*/void r503pretty(T2 a1);
/*WRITTEN_CURRENT*/T0*r503simplify(T503*C,T0*a1);
/*WRITTEN_CURRENT*/T0*r503static_simplify(T503*C);
/*WRITTEN_CURRENT*/T0*r503specialize_in(T503*C,T0*a1);
/*WRITTEN_CURRENT*/void r503inline_dynamic_dispatch_(T503*C,T0*a1,T0*a2);
/*WRITTEN_CURRENT*/T6 r503is_stored_in_some_local_variable(void);
/*WRITTEN_CURRENT*/void r503accept(T503*C,T0*a1);
/*WRITTEN_CURRENT*/T0*r503collect(T0*a1);
/*WRITTEN_CURRENT*/void r503pretty_target(T2 a1);
/*WRITTEN_CURRENT*/T0*r503twin(T503*C);
/*WRITTEN_CURRENT*/T6 r503use_current(T0*a1);
/*WRITTEN_CURRENT*/void r503bracketed_pretty(T2 a1);
/*WRITTEN_CURRENT*/T0*r503non_void_no_dispatch_type(T0*a1);
/*WRITTEN_CURRENT*/T6 r503side_effect_free(T0*a1);
/*WRITTEN_CURRENT*/T0*r503resolve_in(T0*a1);
/*WRITTEN_CURRENT*/T0*r503to_instruction(T503*C);
/*ASSIGNMENT*/T381*create381inline_make(T0*a1,T0*a2);
/*ASSIGNMENT*/T381*create381make(T0*a1,T0*a2);
/*ASSIGNMENT*/T0*r381specialize_and_check(T381*C,T0*a1);
/*ASSIGNMENT*/T0*r381to_expression(T381*C);
/*ASSIGNMENT*/void r381make(T381*C,T0*a1,T0*a2);
/*ASSIGNMENT*/void r381fatal_error_for(T381*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*ASSIGNMENT*/void r381pretty(T381*C,T2 a1);
/*ASSIGNMENT*/T0*r381simplify(T381*C,T0*a1);
/*ASSIGNMENT*/T0*r381specialize_in(T381*C,T0*a1);
/*ASSIGNMENT*/void r381inline_dynamic_dispatch_(T381*C,T0*a1,T0*a2);
/*ASSIGNMENT*/void r381safety_check(T381*C,T0*a1);
/*ASSIGNMENT*/T0*r381specialize_thru(T381*C,T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT*/T6 r381reset_default_value_in_local_or_result(T381*C,T0*a1);
/*ASSIGNMENT*/void r381inline_make(T381*C,T0*a1,T0*a2);
/*ASSIGNMENT*/void r381accept(T381*C,T0*a1);
/*ASSIGNMENT*/T0*r381adapt_for(T381*C,T0*a1);
/*ASSIGNMENT*/T0*r381collect(T381*C,T0*a1);
/*ASSIGNMENT*/T351 r381start_position(T381*C);
/*ASSIGNMENT*/T6 r381use_current(T381*C,T0*a1);
/*ASSIGNMENT*/T6 r381side_effect_free(T0*a1);
/*ASSIGNMENT*/T0*r381error_handler(void);
/*ASSIGNMENT*/T0*r381inline_dynamic_dispatch(T381*C,T0*a1,T0*a2);
/*ASSIGNMENT*/T0*r381to_instruction(T381*C);
/*ASSIGNMENT_ATTEMPT*/T409*create409make(T0*a1,T0*a2,T6 a3);
/*ASSIGNMENT_ATTEMPT*/T0*r409specialize_and_check(T409*C,T0*a1);
/*ASSIGNMENT_ATTEMPT*/T0*r409to_expression(T409*C);
/*ASSIGNMENT_ATTEMPT*/void r409make(T409*C,T0*a1,T0*a2,T6 a3);
/*ASSIGNMENT_ATTEMPT*/void r409pretty(T409*C,T2 a1);
/*ASSIGNMENT_ATTEMPT*/T0*r409simplify(T409*C,T0*a1);
/*ASSIGNMENT_ATTEMPT*/T0*r409specialize_in(T409*C,T0*a1);
/*ASSIGNMENT_ATTEMPT*/void r409inline_dynamic_dispatch_(T409*C,T0*a1,T0*a2);
/*ASSIGNMENT_ATTEMPT*/void r409safety_check(T409*C,T0*a1);
/*ASSIGNMENT_ATTEMPT*/T0*r409specialize_thru(T409*C,T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_ATTEMPT*/void r409accept(T409*C,T0*a1);
/*ASSIGNMENT_ATTEMPT*/T0*r409adapt_for(T409*C,T0*a1);
/*ASSIGNMENT_ATTEMPT*/T0*r409collect(T409*C,T0*a1);
/*ASSIGNMENT_ATTEMPT*/T351 r409start_position(T409*C);
/*ASSIGNMENT_ATTEMPT*/T6 r409use_current(T409*C,T0*a1);
/*ASSIGNMENT_ATTEMPT*/T6 r409side_effect_free(T0*a1);
/*ASSIGNMENT_ATTEMPT*/T0*r409error_handler(void);
/*ASSIGNMENT_ATTEMPT*/T0*r409inline_dynamic_dispatch(T409*C,T0*a1,T0*a2);
/*ASSIGNMENT_ATTEMPT*/T0*r409to_instruction(T409*C);
/*ASSIGNMENT_CALL_ASSIGNER*/T0*r483specialize_and_check(T483*C,T0*a1);
/*ASSIGNMENT_CALL_ASSIGNER*/T0*r483to_expression(T483*C);
/*ASSIGNMENT_CALL_ASSIGNER*/void r483make(T483*C,T0*a1,T0*a2);
/*ASSIGNMENT_CALL_ASSIGNER*/void r483pretty(T483*C,T2 a1);
/*ASSIGNMENT_CALL_ASSIGNER*/T0*r483echo(void);
/*ASSIGNMENT_CALL_ASSIGNER*/T0*r483specialize_in(T483*C,T0*a1);
/*ASSIGNMENT_CALL_ASSIGNER*/T0*r483specialize_thru(T483*C,T0*a1,T0*a2,T0*a3);
/*ASSIGNMENT_CALL_ASSIGNER*/void r483accept(T483*C,T0*a1);
/*ASSIGNMENT_CALL_ASSIGNER*/T351 r483start_position(T483*C);
/*ASSIGNMENT_CALL_ASSIGNER*/T6 r483use_current(T483*C,T0*a1);
/*ASSIGNMENT_CALL_ASSIGNER*/T6 r483side_effect_free(T0*a1);
/*ASSIGNMENT_CALL_ASSIGNER*/T0*r483error_handler(void);
/*ASSIGNMENT_CALL_ASSIGNER*/T0*r483inline_dynamic_dispatch(T0*a1,T0*a2);
/*ASSIGNMENT_CALL_ASSIGNER*/T0*r483to_instruction(T483*C);
/*RETRY_INSTRUCTION*/T0*r477to_expression(T477*C);
/*RETRY_INSTRUCTION*/void r477make(T477*C,T351 a1);
/*RETRY_INSTRUCTION*/void r477pretty(T2 a1);
/*RETRY_INSTRUCTION*/T0*r477simplify(T477*C,T0*a1);
/*RETRY_INSTRUCTION*/void r477inline_dynamic_dispatch_(T477*C,T0*a1,T0*a2);
/*RETRY_INSTRUCTION*/void r477accept(T477*C,T0*a1);
/*RETRY_INSTRUCTION*/T6 r477use_current(T0*a1);
/*RETRY_INSTRUCTION*/T6 r477side_effect_free(T0*a1);
/*RETRY_INSTRUCTION*/T0*r477inline_dynamic_dispatch(T477*C,T0*a1,T0*a2);
/*RETRY_INSTRUCTION*/T0*r477to_instruction(T477*C);
/*COMPOUND*/T410*create410make_2(T0*a1,T0*a2);
/*COMPOUND*/void r410simplify_add(T0*a1,T0*a2);
/*COMPOUND*/T0*r410specialize_and_check(T410*C,T0*a1);
/*COMPOUND*/T0*r410to_expression(T410*C);
/*COMPOUND*/T0*r410first(T410*C);
/*COMPOUND*/void r410pretty(T410*C,T2 a1);
/*COMPOUND*/T0*r410simplify(T410*C,T0*a1);
/*COMPOUND*/T0*r410twin_remove_first(T410*C);
/*COMPOUND*/T0*r410specialize_in(T410*C,T0*a1);
/*COMPOUND*/void r410inline_dynamic_dispatch_(T410*C,T0*a1,T0*a2);
/*COMPOUND*/void r410safety_check(T410*C,T0*a1);
/*COMPOUND*/void r410set_list(T410*C,T0*a1);
/*COMPOUND*/T0*r410specialize_thru(T410*C,T0*a1,T0*a2,T0*a3);
/*COMPOUND*/T2 r410upper(T410*C);
/*COMPOUND*/void r410accept(T410*C,T0*a1);
/*COMPOUND*/T0*r410adapt_for(T410*C,T0*a1);
/*COMPOUND*/void r410from_list(T410*C,T0*a1);
/*COMPOUND*/void r410make_n(T410*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*COMPOUND*/T0*r410collect(T410*C,T0*a1);
/*COMPOUND*/T6 r410is_a_comment(T0*a1);
/*COMPOUND*/T351 r410start_position(T410*C);
/*COMPOUND*/T0*r410twin(T410*C);
/*COMPOUND*/T6 r410use_current(T410*C,T0*a1);
/*COMPOUND*/T6 r410side_effect_free(T410*C,T0*a1);
/*COMPOUND*/T0*r410inline_dynamic_dispatch(T410*C,T0*a1,T0*a2);
/*COMPOUND*/void r410make_2(T410*C,T0*a1,T0*a2);
/*COMPOUND*/void r410make_3(T410*C,T0*a1,T0*a2,T0*a3);
/*COMPOUND*/T2 r410count(T410*C);
/*COMPOUND*/void r410make_4(T410*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*COMPOUND*/T0*r410to_instruction(T410*C);
/*ENSURE_ASSERTION*/T680*create680make(T351 a1,T6 a2,T0*a3,T0*a4);
/*ENSURE_ASSERTION*/T0*r680specialize_and_check(T680*C,T0*a1);
/*ENSURE_ASSERTION*/T0*r680to_expression(T680*C);
/*ENSURE_ASSERTION*/void r680make(T680*C,T351 a1,T6 a2,T0*a3,T0*a4);
/*ENSURE_ASSERTION*/T6 r680has_assertion_located_at(T680*C,T351 a1);
/*ENSURE_ASSERTION*/void r680pretty(T680*C,T2 a1);
/*ENSURE_ASSERTION*/T0*r680simplify(T680*C,T0*a1);
/*ENSURE_ASSERTION*/T0*r680specialize_in(T680*C,T0*a1);
/*ENSURE_ASSERTION*/void r680inline_dynamic_dispatch_(T680*C,T0*a1,T0*a2);
/*ENSURE_ASSERTION*/T6 r680is_always_true(T680*C,T0*a1);
/*ENSURE_ASSERTION*/void r680safety_check(T680*C,T0*a1);
/*ENSURE_ASSERTION*/void r680set_list(T680*C,T0*a1);
/*ENSURE_ASSERTION*/void r680for_each(T680*C,T0*a1);
/*ENSURE_ASSERTION*/T0*r680specialize_thru(T680*C,T0*a1,T0*a2,T0*a3);
/*ENSURE_ASSERTION*/void r680pretty_as_loop_invariant(T680*C,T2 a1);
/*ENSURE_ASSERTION*/void r680assertion_list_make(T680*C,T351 a1,T0*a2,T0*a3);
/*ENSURE_ASSERTION*/T2 r680upper(T680*C);
/*ENSURE_ASSERTION*/void r680accept(T680*C,T0*a1);
/*ENSURE_ASSERTION*/void r680set_eiffel_parser_stamp(T680*C,T2 a1);
/*ENSURE_ASSERTION*/T0*r680adapt_for(T680*C,T0*a1);
/*ENSURE_ASSERTION*/T0*r680item(T680*C,T2 a1);
/*ENSURE_ASSERTION*/T0*r680add_items_from(T680*C,T0*a1);
/*ENSURE_ASSERTION*/T0*r680collect(T680*C,T0*a1);
/*ENSURE_ASSERTION*/void r680pretty_print_with_tag(T680*C,T2 a1,T0*a2);
/*ENSURE_ASSERTION*/T6 r680is_empty(T680*C);
/*ENSURE_ASSERTION*/T0*r680twin(T680*C);
/*ENSURE_ASSERTION*/void r680pretty_as_check_compound(T680*C,T2 a1,T0*a2);
/*ENSURE_ASSERTION*/T6 r680use_current(T680*C,T0*a1);
/*ENSURE_ASSERTION*/void r680breakpoint(T680*C);
/*ENSURE_ASSERTION*/void r680crash(T680*C);
/*ENSURE_ASSERTION*/T6 r680side_effect_free(T680*C,T0*a1);
/*ENSURE_ASSERTION*/T0*r680inline_dynamic_dispatch(T680*C,T0*a1,T0*a2);
/*ENSURE_ASSERTION*/void r680not_yet_implemented(T680*C);
/*ENSURE_ASSERTION*/T2 r680count(T680*C);
/*ENSURE_ASSERTION*/T0*r680specialize_without_checks(T680*C,T0*a1);
/*ENSURE_ASSERTION*/T0*r680to_instruction(T680*C);
/*ENSURE_ASSERTION*/T2 r680lower(T680*C);
/*AGENT_CREATION*/T0*r502declaration_type(T502*C);
/*AGENT_CREATION*/T0*r502adapt_for(T502*C,T0*a1);
/*AGENT_CREATION*/T0*r502resolve_in(T502*C,T0*a1);
/*AGENT_CREATION*/T0*r502collect(T502*C,T0*a1);
/*AGENT_CREATION*/T0*r502specialize_in(T502*C,T0*a1);
/*AGENT_CREATION*/T0*r502written_declaration_type_mark(T502*C);
/*AGENT_CREATION*/T0*r502simplify(T502*C,T0*a1);
/*AGENT_CREATION*/T0*r502specialize_and_check_function(T502*C,T0*a1);
/*AGENT_CREATION*/void r502pretty_target(T502*C,T2 a1);
/*AGENT_CREATION*/void r502mold_id_in(T502*C,T0*a1,T0*a2);
/*AGENT_CREATION*/void r502safety_check(T502*C,T0*a1);
/*AGENT_CREATION*/T0*r502to_expression(T502*C);
/*AGENT_CREATION*/T0*r502specialize_thru(T502*C,T0*a1,T0*a2,T0*a3);
extern T0*oBC32is_equal_name;
extern int fBC32is_equal_name;
/*AGENT_CREATION*/T0*r502is_equal_name(void);
/*AGENT_CREATION*/T0*r502specialize_and_check(T502*C,T0*a1);
/*AGENT_CREATION*/void r502inline_dynamic_dispatch_(T502*C,T0*a1,T0*a2);
/*AGENT_CREATION*/T0*r502to_instruction(T502*C);
/*AGENT_CREATION*/void r502make(T502*C,T351 a1,T0*a2,T0*a3);
/*AGENT_CREATION*/T6 r502is_equal_used_in(T0*a1);
/*AGENT_CREATION*/T0*r502specialize_and_check_procedure(T502*C,T0*a1);
/*AGENT_CREATION*/void r502omitted_open_arguments_update(T502*C,T0*a1);
/*AGENT_CREATION*/T6 r502use_current(T502*C,T0*a1);
/*AGENT_CREATION*/T0*r502static_simplify(T502*C);
/*AGENT_CREATION*/T6 r502stored_closed_operand(T502*C,T0*a1,T0*a2);
/*AGENT_CREATION*/void r502pretty(T502*C,T2 a1);
/*AGENT_CREATION*/void r502warn_omitted_open_arguments(T502*C);
/*AGENT_CREATION*/T6 r502side_effect_free(T0*a1);
/*AGENT_CREATION*/void r502set_inside_agent_launcher_flag(T502*C,T6 a1);
/*AGENT_CREATION*/T0*r502non_void_no_dispatch_type(T502*C,T0*a1);
extern T0*oBC32any_is_equal_fs;
extern int fBC32any_is_equal_fs;
/*AGENT_CREATION*/T0*r502any_is_equal_fs(void);
/*AGENT_CREATION*/T0*r502twin(T502*C);
/*AGENT_CREATION*/void r502bracketed_pretty(T502*C,T2 a1);
/*AGENT_CREATION*/T0*r502error_handler(void);
/*AGENT_CREATION*/void r502accept(T502*C,T0*a1);
/*AGENT_CREATION*/T6 r502same_mold_id_as(T502*C,T0*a1);
/*AGENT_CREATION*/T6 r502is_stored_in_some_local_variable(void);
/*EXPRESSION_WITH_COMMENT*/T0*r472specialize_and_check(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T0*r472to_expression(T472*C);
/*EXPRESSION_WITH_COMMENT*/void r472make(T472*C,T0*a1,T0*a2);
/*EXPRESSION_WITH_COMMENT*/void r472pretty(T472*C,T2 a1);
/*EXPRESSION_WITH_COMMENT*/T0*r472simplify(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T6 r472extra_bracket_flag(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472static_simplify(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472specialize_in(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/void r472inline_dynamic_dispatch_(T472*C,T0*a1,T0*a2);
/*EXPRESSION_WITH_COMMENT*/void r472safety_check(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T6 r472is_writable(T472*C);
/*EXPRESSION_WITH_COMMENT*/T6 r472is_result(T472*C);
/*EXPRESSION_WITH_COMMENT*/T2 r472precedence(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472specialize_thru(T472*C,T0*a1,T0*a2,T0*a3);
/*EXPRESSION_WITH_COMMENT*/T6 r472is_static(T472*C);
/*EXPRESSION_WITH_COMMENT*/T6 r472is_stored_in_some_local_variable(void);
/*EXPRESSION_WITH_COMMENT*/void r472accept(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T0*r472adapt_for(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T0*r472declaration_type(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472collect(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T6 r472is_current(T472*C);
/*EXPRESSION_WITH_COMMENT*/void r472pretty_target(T472*C,T2 a1);
/*EXPRESSION_WITH_COMMENT*/T351 r472start_position(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472twin(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472written_declaration_type_mark(T472*C);
/*EXPRESSION_WITH_COMMENT*/T6 r472use_current(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/void r472bracketed_pretty(T472*C,T2 a1);
/*EXPRESSION_WITH_COMMENT*/T6 r472is_void(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472non_void_no_dispatch_type(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T6 r472side_effect_free(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T6 r472is_manifest_string(T472*C);
/*EXPRESSION_WITH_COMMENT*/T6 r472is_implicit_current(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472resolve_in(T472*C,T0*a1);
/*EXPRESSION_WITH_COMMENT*/T0*r472to_instruction(T472*C);
/*EXPRESSION_WITH_COMMENT*/T0*r472current_or_twin_init(T472*C,T0*a1);
/*E_VOID*/T411*create411make(T351 a1);
/*E_VOID*/T0*r411to_expression(T411*C);
/*E_VOID*/void r411make(T411*C,T351 a1);
/*E_VOID*/void r411pretty(T2 a1);
/*E_VOID*/T0*r411static_simplify(T411*C);
/*E_VOID*/void r411inline_dynamic_dispatch_(T411*C,T0*a1,T0*a2);
/*E_VOID*/T6 r411is_stored_in_some_local_variable(void);
/*E_VOID*/void r411accept(T411*C,T0*a1);
/*E_VOID*/T0*r411collect(T411*C,T0*a1);
/*E_VOID*/T0*r411twin(T411*C);
/*E_VOID*/T0*r411written_declaration_type_mark(void);
/*E_VOID*/T6 r411use_current(T0*a1);
/*E_VOID*/void r411bracketed_pretty(T2 a1);
/*E_VOID*/T0*r411non_void_no_dispatch_type(T0*a1);
/*E_VOID*/T6 r411side_effect_free(T0*a1);
/*E_VOID*/T0*r411error_handler(void);
/*E_VOID*/T0*r411resolve_in(T411*C,T0*a1);
/*E_VOID*/T0*r411to_instruction(T411*C);
/*IFTHEN_EXP*/T473*create473make(T351 a1,T0*a2,T0*a3);
/*IFTHEN_EXP*/T0*r473specialize_and_check(T473*C,T0*a1);
/*IFTHEN_EXP*/T0*r473to_expression(T473*C);
/*IFTHEN_EXP*/void r473make(T473*C,T351 a1,T0*a2,T0*a3);
/*IFTHEN_EXP*/void r473pretty(T473*C,T2 a1);
/*IFTHEN_EXP*/T0*r473simplify(T473*C,T0*a1);
/*IFTHEN_EXP*/void r473specialize_check_(T473*C,T0*a1);
/*IFTHEN_EXP*/void r473pretty_end_if(T2 a1);
/*IFTHEN_EXP*/T0*r473static_simplify(T473*C);
/*IFTHEN_EXP*/T0*r473specialize_in(T473*C,T0*a1);
/*IFTHEN_EXP*/void r473inline_dynamic_dispatch_(T473*C,T0*a1,T0*a2);
/*IFTHEN_EXP*/void r473safety_check(T473*C,T0*a1);
/*IFTHEN_EXP*/void r473init(T473*C,T0*a1,T0*a2);
/*IFTHEN_EXP*/void r473pretty_(T473*C,T2 a1,T0*a2);
/*IFTHEN_EXP*/T0*r473specialize_thru(T473*C,T0*a1,T0*a2,T0*a3);
/*IFTHEN_EXP*/T6 r473is_stored_in_some_local_variable(void);
/*IFTHEN_EXP*/void r473accept(T473*C,T0*a1);
/*IFTHEN_EXP*/T0*r473adapt_for(T473*C,T0*a1);
/*IFTHEN_EXP*/T0*r473declaration_type(T473*C);
/*IFTHEN_EXP*/T0*r473collect(T473*C,T0*a1);
/*IFTHEN_EXP*/T0*r473twin(T473*C);
/*IFTHEN_EXP*/T0*r473written_declaration_type_mark(T473*C);
/*IFTHEN_EXP*/T6 r473use_current(T473*C,T0*a1);
/*IFTHEN_EXP*/T0*r473non_void_no_dispatch_type(T0*a1);
/*IFTHEN_EXP*/T6 r473side_effect_free(T0*a1);
/*IFTHEN_EXP*/T0*r473error_handler(void);
/*IFTHEN_EXP*/T0*r473resolve_in(T0*a1);
/*IFTHEN_EXP*/T0*r473to_instruction(T473*C);
/*IFTHEN_EXP*/T0*r473current_or_twin_init(T473*C,T0*a1,T0*a2);
/*IFTHENELSE_EXP*/T0*r475specialize_and_check(T475*C,T0*a1);
/*IFTHENELSE_EXP*/T0*r475to_expression(T475*C);
/*IFTHENELSE_EXP*/void r475pretty(T475*C,T2 a1);
/*IFTHENELSE_EXP*/T0*r475simplify(T475*C,T0*a1);
/*IFTHENELSE_EXP*/void r475inline_dd(T475*C,T0*a1,T0*a2,T0*a3,T2 a4);
/*IFTHENELSE_EXP*/void r475specialize_check_(T475*C,T0*a1);
extern T0*oBC475resolve_set;
extern int fBC475resolve_set;
/*IFTHENELSE_EXP*/T0*r475resolve_set(void);
/*IFTHENELSE_EXP*/void r475pretty_end_if(T2 a1);
/*IFTHENELSE_EXP*/T0*r475static_simplify(T475*C);
/*IFTHENELSE_EXP*/T0*r475specialize_in(T475*C,T0*a1);
/*IFTHENELSE_EXP*/void r475inline_dynamic_dispatch_(T475*C,T0*a1,T0*a2);
/*IFTHENELSE_EXP*/void r475safety_check(T475*C,T0*a1);
/*IFTHENELSE_EXP*/void r475init(T475*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*IFTHENELSE_EXP*/void r475pretty_(T475*C,T2 a1,T0*a2);
/*IFTHENELSE_EXP*/T0*r475resolve_resolve_set_(void);
/*IFTHENELSE_EXP*/T0*r475specialize_thru(T475*C,T0*a1,T0*a2,T0*a3);
/*IFTHENELSE_EXP*/T0*r475simplify_elseif_list(T0*a1,T6 a2,T0*a3);
/*IFTHENELSE_EXP*/void r475specialize_check(T475*C,T0*a1);
/*IFTHENELSE_EXP*/T6 r475is_stored_in_some_local_variable(void);
/*IFTHENELSE_EXP*/void r475accept(T475*C,T0*a1);
/*IFTHENELSE_EXP*/T0*r475adapt_for(T475*C,T0*a1);
/*IFTHENELSE_EXP*/T0*r475declaration_type(T475*C);
/*IFTHENELSE_EXP*/T0*r475collect(T475*C,T0*a1);
/*IFTHENELSE_EXP*/void r475pretty_target(T475*C,T2 a1);
/*IFTHENELSE_EXP*/T0*r475resolve_resolve_set(T475*C);
/*IFTHENELSE_EXP*/T0*r475twin(T475*C);
/*IFTHENELSE_EXP*/T0*r475written_declaration_type_mark(T475*C);
/*IFTHENELSE_EXP*/T6 r475use_current(T475*C,T0*a1);
/*IFTHENELSE_EXP*/void r475bracketed_pretty(T475*C,T2 a1);
/*IFTHENELSE_EXP*/T0*r475non_void_no_dispatch_type(T475*C,T0*a1);
/*IFTHENELSE_EXP*/T6 r475side_effect_free(T0*a1);
/*IFTHENELSE_EXP*/void r475with_else(T475*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*IFTHENELSE_EXP*/void r475with_elseif(T475*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*IFTHENELSE_EXP*/T0*r475error_handler(void);
/*IFTHENELSE_EXP*/T0*r475resolve_in(T475*C,T0*a1);
/*IFTHENELSE_EXP*/void r475with_elseif_and_else(T475*C,T351 a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*IFTHENELSE_EXP*/T0*r475to_instruction(T475*C);
/*IFTHENELSE_EXP*/T0*r475current_or_twin_init(T475*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*E_OLD*/T0*r512specialize_and_check(T512*C,T0*a1);
/*E_OLD*/T0*r512to_expression(T512*C);
/*E_OLD*/void r512make(T512*C,T351 a1,T0*a2);
extern T0*oBC512vaol_check_memory;
/*E_OLD*/void r512pretty(T512*C,T2 a1);
/*E_OLD*/T0*r512simplify(T512*C,T0*a1);
/*E_OLD*/void r512set_tag(T512*C,T0*a1,T0*a2);
/*E_OLD*/T0*r512static_simplify(T512*C);
/*E_OLD*/T0*r512specialize_in(T512*C,T0*a1);
/*E_OLD*/void r512inline_dynamic_dispatch_(T512*C,T0*a1,T0*a2);
/*E_OLD*/void r512safety_check(T512*C,T0*a1);
/*E_OLD*/T0*r512specialize_thru(T512*C,T0*a1,T0*a2,T0*a3);
/*E_OLD*/T6 r512is_stored_in_some_local_variable(void);
/*E_OLD*/void r512accept(T512*C,T0*a1);
/*E_OLD*/T0*r512adapt_for(T512*C,T0*a1);
/*E_OLD*/T0*r512declaration_type(T512*C);
/*E_OLD*/T0*r512collect(T512*C,T0*a1);
/*E_OLD*/void r512pretty_target(T512*C,T2 a1);
/*E_OLD*/T0*r512twin(T512*C);
/*E_OLD*/T0*r512written_declaration_type_mark(T512*C);
/*E_OLD*/T6 r512use_current(T512*C,T0*a1);
/*E_OLD*/void r512bracketed_pretty(T512*C,T2 a1);
/*E_OLD*/void r512crash(T512*C);
/*E_OLD*/T0*r512non_void_no_dispatch_type(T512*C,T0*a1);
/*E_OLD*/T6 r512side_effect_free(T0*a1);
/*E_OLD*/T0*r512error_handler(void);
/*E_OLD*/void r512not_yet_implemented(T512*C);
/*E_OLD*/T0*r512tag(T512*C,T0*a1);
/*E_OLD*/T0*r512resolve_in(T512*C,T0*a1);
/*E_OLD*/T0*r512to_instruction(T512*C);
/*E_OLD*/T0*r512current_or_twin_init(T512*C,T0*a1);
/*CALL_INFIX_FREEOP*/T6 r534is_balanced_operator(T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534declaration_type(T534*C);
/*CALL_INFIX_FREEOP*/T0*r534adapt_for(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534resolve_in(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534eiffel_parser(void);
/*CALL_INFIX_FREEOP*/T0*r534use_current_stack(void);
/*CALL_INFIX_FREEOP*/T0*r534collect(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534parentheses_feature_name(T534*C);
/*CALL_INFIX_FREEOP*/T0*r534specialize_in(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534written_declaration_type_mark(T534*C);
/*CALL_INFIX_FREEOP*/T0*r534simplify(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/void r534pretty_target(T534*C,T2 a1);
/*CALL_INFIX_FREEOP*/void r534safety_check(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534to_expression(T534*C);
/*CALL_INFIX_FREEOP*/T0*r534specialize_thru(T534*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_FREEOP*/T0*r534feature_accumulator(void);
/*CALL_INFIX_FREEOP*/T0*r534specialize_and_check(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/void r534inline_dynamic_dispatch_(T534*C,T0*a1,T0*a2);
/*CALL_INFIX_FREEOP*/T0*r534to_instruction(T534*C);
/*CALL_INFIX_FREEOP*/T0*r534current_or_twin_init(T534*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_FREEOP*/void r534standard_check_export_and_obsolete_calls(T534*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_FREEOP*/void r534make(T534*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_FREEOP*/T0*r534arg1(T534*C);
/*CALL_INFIX_FREEOP*/void r534type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_FREEOP*/void r534non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_FREEOP*/T6 r534use_current(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534static_simplify(T534*C);
/*CALL_INFIX_FREEOP*/void r534init(T534*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_FREEOP*/T0*r534extra_local_expanded(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T6 r534function_check(T534*C,T0*a1,T0*a2);
/*CALL_INFIX_FREEOP*/void r534pretty(T534*C,T2 a1);
/*CALL_INFIX_FREEOP*/T6 r534side_effect_free(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534non_void_no_dispatch_type(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534run_feature_for(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T0*r534inline_with(T534*C,T0*a1,T0*a2);
/*CALL_INFIX_FREEOP*/T0*r534twin(T534*C);
/*CALL_INFIX_FREEOP*/void r534bracketed_pretty(T534*C,T2 a1);
/*CALL_INFIX_FREEOP*/T0*r534error_handler(void);
/*CALL_INFIX_FREEOP*/T6 r534is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_FREEOP*/void r534accept(T534*C,T0*a1);
/*CALL_INFIX_FREEOP*/T351 r534start_position(T534*C);
/*CALL_INFIX_FREEOP*/T6 r534is_stored_in_some_local_variable(void);
/*CALL_INFIX_FREEOP*/T0*r534_P_363_declaration_type(T534*C);
/*CALL_INFIX_POWER*/T6 r533is_balanced_operator(T0*a1);
/*CALL_INFIX_POWER*/T0*r533declaration_type(T533*C);
/*CALL_INFIX_POWER*/T0*r533adapt_for(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533resolve_in(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533eiffel_parser(void);
/*CALL_INFIX_POWER*/T0*r533use_current_stack(void);
/*CALL_INFIX_POWER*/T0*r533collect(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533parentheses_feature_name(T533*C);
/*CALL_INFIX_POWER*/T0*r533specialize_in(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533written_declaration_type_mark(T533*C);
/*CALL_INFIX_POWER*/T0*r533simplify(T533*C,T0*a1);
/*CALL_INFIX_POWER*/void r533pretty_target(T533*C,T2 a1);
/*CALL_INFIX_POWER*/void r533safety_check(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533to_expression(T533*C);
/*CALL_INFIX_POWER*/T0*r533specialize_thru(T533*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_POWER*/T0*r533feature_accumulator(void);
/*CALL_INFIX_POWER*/T0*r533specialize_and_check(T533*C,T0*a1);
/*CALL_INFIX_POWER*/void r533inline_dynamic_dispatch_(T533*C,T0*a1,T0*a2);
/*CALL_INFIX_POWER*/T0*r533to_instruction(T533*C);
/*CALL_INFIX_POWER*/T0*r533current_or_twin_init(T533*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_POWER*/void r533standard_check_export_and_obsolete_calls(T533*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_POWER*/void r533make(T533*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_POWER*/T0*r533arg1(T533*C);
/*CALL_INFIX_POWER*/void r533type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_POWER*/void r533non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_POWER*/T6 r533use_current(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533static_simplify(T533*C);
/*CALL_INFIX_POWER*/void r533init(T533*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_POWER*/T0*r533extra_local_expanded(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T6 r533function_check(T533*C,T0*a1,T0*a2);
/*CALL_INFIX_POWER*/void r533pretty(T533*C,T2 a1);
/*CALL_INFIX_POWER*/T6 r533side_effect_free(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533non_void_no_dispatch_type(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533run_feature_for(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T0*r533inline_with(T533*C,T0*a1,T0*a2);
/*CALL_INFIX_POWER*/T0*r533twin(T533*C);
/*CALL_INFIX_POWER*/void r533bracketed_pretty(T533*C,T2 a1);
/*CALL_INFIX_POWER*/T0*r533error_handler(void);
/*CALL_INFIX_POWER*/T6 r533is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_POWER*/void r533accept(T533*C,T0*a1);
/*CALL_INFIX_POWER*/T351 r533start_position(T533*C);
/*CALL_INFIX_POWER*/T6 r533is_stored_in_some_local_variable(void);
/*CALL_INFIX_POWER*/T0*r533_P_363_declaration_type(T533*C);
/*CALL_INFIX_TIMES*/T6 r529is_balanced_operator(T0*a1);
/*CALL_INFIX_TIMES*/T0*r529declaration_type(T529*C);
/*CALL_INFIX_TIMES*/T0*r529adapt_for(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529resolve_in(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529eiffel_parser(void);
/*CALL_INFIX_TIMES*/T0*r529use_current_stack(void);
/*CALL_INFIX_TIMES*/T0*r529collect(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529parentheses_feature_name(T529*C);
/*CALL_INFIX_TIMES*/T0*r529specialize_in(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529written_declaration_type_mark(T529*C);
/*CALL_INFIX_TIMES*/T0*r529simplify(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/void r529pretty_target(T529*C,T2 a1);
/*CALL_INFIX_TIMES*/void r529safety_check(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529to_expression(T529*C);
/*CALL_INFIX_TIMES*/T0*r529specialize_thru(T529*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_TIMES*/T0*r529feature_accumulator(void);
/*CALL_INFIX_TIMES*/T0*r529specialize_and_check(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/void r529inline_dynamic_dispatch_(T529*C,T0*a1,T0*a2);
/*CALL_INFIX_TIMES*/T0*r529to_instruction(T529*C);
/*CALL_INFIX_TIMES*/T0*r529current_or_twin_init(T529*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_TIMES*/void r529standard_check_export_and_obsolete_calls(T529*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_TIMES*/void r529make(T529*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_TIMES*/T0*r529arg1(T529*C);
/*CALL_INFIX_TIMES*/void r529type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_TIMES*/void r529non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_TIMES*/T6 r529use_current(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529static_simplify(T529*C);
/*CALL_INFIX_TIMES*/void r529init(T529*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_TIMES*/T0*r529extra_local_expanded(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T6 r529function_check(T529*C,T0*a1,T0*a2);
/*CALL_INFIX_TIMES*/void r529pretty(T529*C,T2 a1);
/*CALL_INFIX_TIMES*/T6 r529side_effect_free(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529non_void_no_dispatch_type(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529run_feature_for(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T0*r529inline_with(T529*C,T0*a1,T0*a2);
/*CALL_INFIX_TIMES*/T0*r529twin(T529*C);
/*CALL_INFIX_TIMES*/void r529bracketed_pretty(T529*C,T2 a1);
/*CALL_INFIX_TIMES*/T0*r529error_handler(void);
/*CALL_INFIX_TIMES*/T6 r529is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_TIMES*/void r529accept(T529*C,T0*a1);
/*CALL_INFIX_TIMES*/T351 r529start_position(T529*C);
/*CALL_INFIX_TIMES*/T6 r529is_stored_in_some_local_variable(void);
/*CALL_INFIX_TIMES*/T0*r529_P_363_declaration_type(T529*C);
/*CALL_INFIX_INT_DIV*/T6 r530is_balanced_operator(T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530declaration_type(T530*C);
/*CALL_INFIX_INT_DIV*/T0*r530adapt_for(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530resolve_in(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530eiffel_parser(void);
/*CALL_INFIX_INT_DIV*/T0*r530use_current_stack(void);
/*CALL_INFIX_INT_DIV*/T0*r530collect(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530parentheses_feature_name(T530*C);
/*CALL_INFIX_INT_DIV*/T0*r530specialize_in(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530written_declaration_type_mark(T530*C);
/*CALL_INFIX_INT_DIV*/T0*r530simplify(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/void r530pretty_target(T530*C,T2 a1);
/*CALL_INFIX_INT_DIV*/void r530safety_check(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530to_expression(T530*C);
/*CALL_INFIX_INT_DIV*/T0*r530specialize_thru(T530*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_INT_DIV*/T0*r530feature_accumulator(void);
/*CALL_INFIX_INT_DIV*/T0*r530specialize_and_check(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/void r530inline_dynamic_dispatch_(T530*C,T0*a1,T0*a2);
/*CALL_INFIX_INT_DIV*/T0*r530to_instruction(T530*C);
/*CALL_INFIX_INT_DIV*/T0*r530current_or_twin_init(T530*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_INT_DIV*/void r530standard_check_export_and_obsolete_calls(T530*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_INT_DIV*/void r530make(T530*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_INT_DIV*/T0*r530arg1(T530*C);
/*CALL_INFIX_INT_DIV*/void r530type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_INT_DIV*/void r530non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_INT_DIV*/T6 r530use_current(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530static_simplify(T530*C);
/*CALL_INFIX_INT_DIV*/void r530init(T530*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_INT_DIV*/T0*r530extra_local_expanded(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T6 r530function_check(T530*C,T0*a1,T0*a2);
/*CALL_INFIX_INT_DIV*/void r530pretty(T530*C,T2 a1);
/*CALL_INFIX_INT_DIV*/T6 r530side_effect_free(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530non_void_no_dispatch_type(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530run_feature_for(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T0*r530inline_with(T530*C,T0*a1,T0*a2);
/*CALL_INFIX_INT_DIV*/T0*r530twin(T530*C);
/*CALL_INFIX_INT_DIV*/void r530bracketed_pretty(T530*C,T2 a1);
/*CALL_INFIX_INT_DIV*/T0*r530error_handler(void);
/*CALL_INFIX_INT_DIV*/T6 r530is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_INT_DIV*/void r530accept(T530*C,T0*a1);
/*CALL_INFIX_INT_DIV*/T351 r530start_position(T530*C);
/*CALL_INFIX_INT_DIV*/T6 r530is_stored_in_some_local_variable(void);
/*CALL_INFIX_INT_DIV*/T0*r530_P_363_declaration_type(T530*C);
/*CALL_INFIX_INT_REM*/T6 r531is_balanced_operator(T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531declaration_type(T531*C);
/*CALL_INFIX_INT_REM*/T0*r531adapt_for(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531resolve_in(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531eiffel_parser(void);
/*CALL_INFIX_INT_REM*/T0*r531use_current_stack(void);
/*CALL_INFIX_INT_REM*/T0*r531collect(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531parentheses_feature_name(T531*C);
/*CALL_INFIX_INT_REM*/T0*r531specialize_in(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531written_declaration_type_mark(T531*C);
/*CALL_INFIX_INT_REM*/T0*r531simplify(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/void r531pretty_target(T531*C,T2 a1);
/*CALL_INFIX_INT_REM*/void r531safety_check(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531to_expression(T531*C);
/*CALL_INFIX_INT_REM*/T0*r531specialize_thru(T531*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_INT_REM*/T0*r531feature_accumulator(void);
/*CALL_INFIX_INT_REM*/T0*r531specialize_and_check(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/void r531inline_dynamic_dispatch_(T531*C,T0*a1,T0*a2);
/*CALL_INFIX_INT_REM*/T0*r531to_instruction(T531*C);
/*CALL_INFIX_INT_REM*/T0*r531current_or_twin_init(T531*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_INT_REM*/void r531standard_check_export_and_obsolete_calls(T531*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_INT_REM*/void r531make(T531*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_INT_REM*/T0*r531arg1(T531*C);
/*CALL_INFIX_INT_REM*/void r531type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_INT_REM*/void r531non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_INT_REM*/T6 r531use_current(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531static_simplify(T531*C);
/*CALL_INFIX_INT_REM*/void r531init(T531*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_INT_REM*/T0*r531extra_local_expanded(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T6 r531function_check(T531*C,T0*a1,T0*a2);
/*CALL_INFIX_INT_REM*/void r531pretty(T531*C,T2 a1);
/*CALL_INFIX_INT_REM*/T6 r531side_effect_free(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531non_void_no_dispatch_type(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531run_feature_for(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T0*r531inline_with(T531*C,T0*a1,T0*a2);
/*CALL_INFIX_INT_REM*/T0*r531twin(T531*C);
/*CALL_INFIX_INT_REM*/void r531bracketed_pretty(T531*C,T2 a1);
/*CALL_INFIX_INT_REM*/T0*r531error_handler(void);
/*CALL_INFIX_INT_REM*/T6 r531is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_INT_REM*/void r531accept(T531*C,T0*a1);
/*CALL_INFIX_INT_REM*/T351 r531start_position(T531*C);
/*CALL_INFIX_INT_REM*/T6 r531is_stored_in_some_local_variable(void);
/*CALL_INFIX_INT_REM*/T0*r531_P_363_declaration_type(T531*C);
/*CALL_INFIX_DIV*/T6 r532is_balanced_operator(T0*a1);
/*CALL_INFIX_DIV*/T0*r532declaration_type(T532*C);
/*CALL_INFIX_DIV*/T0*r532adapt_for(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532resolve_in(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532eiffel_parser(void);
/*CALL_INFIX_DIV*/T0*r532use_current_stack(void);
/*CALL_INFIX_DIV*/T0*r532collect(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532parentheses_feature_name(T532*C);
/*CALL_INFIX_DIV*/T0*r532specialize_in(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532written_declaration_type_mark(T532*C);
/*CALL_INFIX_DIV*/T0*r532simplify(T532*C,T0*a1);
/*CALL_INFIX_DIV*/void r532pretty_target(T532*C,T2 a1);
/*CALL_INFIX_DIV*/void r532safety_check(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532to_expression(T532*C);
/*CALL_INFIX_DIV*/T0*r532specialize_thru(T532*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_DIV*/T0*r532feature_accumulator(void);
/*CALL_INFIX_DIV*/T0*r532specialize_and_check(T532*C,T0*a1);
/*CALL_INFIX_DIV*/void r532inline_dynamic_dispatch_(T532*C,T0*a1,T0*a2);
/*CALL_INFIX_DIV*/T0*r532to_instruction(T532*C);
/*CALL_INFIX_DIV*/T0*r532current_or_twin_init(T532*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_DIV*/void r532standard_check_export_and_obsolete_calls(T532*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_DIV*/void r532make(T532*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_DIV*/T0*r532arg1(T532*C);
/*CALL_INFIX_DIV*/void r532type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_DIV*/void r532non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_DIV*/T6 r532use_current(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532static_simplify(T532*C);
/*CALL_INFIX_DIV*/void r532init(T532*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_DIV*/T0*r532extra_local_expanded(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T6 r532function_check(T532*C,T0*a1,T0*a2);
/*CALL_INFIX_DIV*/void r532pretty(T532*C,T2 a1);
/*CALL_INFIX_DIV*/T6 r532side_effect_free(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532non_void_no_dispatch_type(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532run_feature_for(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T0*r532inline_with(T532*C,T0*a1,T0*a2);
/*CALL_INFIX_DIV*/T0*r532twin(T532*C);
/*CALL_INFIX_DIV*/void r532bracketed_pretty(T532*C,T2 a1);
/*CALL_INFIX_DIV*/T0*r532error_handler(void);
/*CALL_INFIX_DIV*/T6 r532is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_DIV*/void r532accept(T532*C,T0*a1);
/*CALL_INFIX_DIV*/T351 r532start_position(T532*C);
/*CALL_INFIX_DIV*/T6 r532is_stored_in_some_local_variable(void);
/*CALL_INFIX_DIV*/T0*r532_P_363_declaration_type(T532*C);
/*CALL_INFIX_PLUS*/T6 r528is_balanced_operator(T0*a1);
/*CALL_INFIX_PLUS*/T0*r528declaration_type(T528*C);
/*CALL_INFIX_PLUS*/T0*r528adapt_for(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528resolve_in(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528eiffel_parser(void);
/*CALL_INFIX_PLUS*/T0*r528use_current_stack(void);
/*CALL_INFIX_PLUS*/T0*r528collect(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528parentheses_feature_name(T528*C);
/*CALL_INFIX_PLUS*/T0*r528specialize_in(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528written_declaration_type_mark(T528*C);
/*CALL_INFIX_PLUS*/T0*r528simplify(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/void r528pretty_target(T528*C,T2 a1);
/*CALL_INFIX_PLUS*/void r528safety_check(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528to_expression(T528*C);
/*CALL_INFIX_PLUS*/T0*r528specialize_thru(T528*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_PLUS*/T0*r528feature_accumulator(void);
/*CALL_INFIX_PLUS*/T0*r528specialize_and_check(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/void r528inline_dynamic_dispatch_(T528*C,T0*a1,T0*a2);
/*CALL_INFIX_PLUS*/T0*r528to_instruction(T528*C);
/*CALL_INFIX_PLUS*/T0*r528current_or_twin_init(T528*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_PLUS*/void r528standard_check_export_and_obsolete_calls(T528*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_PLUS*/void r528make(T528*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_PLUS*/T0*r528arg1(T528*C);
/*CALL_INFIX_PLUS*/void r528type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_PLUS*/void r528non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_PLUS*/T6 r528use_current(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528static_simplify(T528*C);
/*CALL_INFIX_PLUS*/void r528init(T528*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_PLUS*/T0*r528extra_local_expanded(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T6 r528function_check(T528*C,T0*a1,T0*a2);
/*CALL_INFIX_PLUS*/void r528pretty(T528*C,T2 a1);
/*CALL_INFIX_PLUS*/T6 r528side_effect_free(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528non_void_no_dispatch_type(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528run_feature_for(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T0*r528inline_with(T528*C,T0*a1,T0*a2);
/*CALL_INFIX_PLUS*/T0*r528twin(T528*C);
/*CALL_INFIX_PLUS*/void r528bracketed_pretty(T528*C,T2 a1);
/*CALL_INFIX_PLUS*/T0*r528error_handler(void);
/*CALL_INFIX_PLUS*/T6 r528is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_PLUS*/void r528accept(T528*C,T0*a1);
/*CALL_INFIX_PLUS*/T351 r528start_position(T528*C);
/*CALL_INFIX_PLUS*/T6 r528is_stored_in_some_local_variable(void);
/*CALL_INFIX_PLUS*/T0*r528_P_363_declaration_type(T528*C);
/*CALL_INFIX_MINUS*/T6 r389is_balanced_operator(T0*a1);
/*CALL_INFIX_MINUS*/T0*r389declaration_type(T389*C);
/*CALL_INFIX_MINUS*/T0*r389adapt_for(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389resolve_in(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389eiffel_parser(void);
/*CALL_INFIX_MINUS*/T0*r389use_current_stack(void);
/*CALL_INFIX_MINUS*/T0*r389collect(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389parentheses_feature_name(T389*C);
/*CALL_INFIX_MINUS*/T0*r389specialize_in(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389written_declaration_type_mark(T389*C);
/*CALL_INFIX_MINUS*/T0*r389simplify(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/void r389pretty_target(T389*C,T2 a1);
/*CALL_INFIX_MINUS*/void r389safety_check(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389to_expression(T389*C);
/*CALL_INFIX_MINUS*/T0*r389specialize_thru(T389*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_MINUS*/T0*r389feature_accumulator(void);
/*CALL_INFIX_MINUS*/T0*r389specialize_and_check(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/void r389inline_dynamic_dispatch_(T389*C,T0*a1,T0*a2);
/*CALL_INFIX_MINUS*/T0*r389to_instruction(T389*C);
/*CALL_INFIX_MINUS*/T0*r389current_or_twin_init(T389*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_MINUS*/void r389standard_check_export_and_obsolete_calls(T389*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_MINUS*/void r389make(T389*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_MINUS*/T0*r389arg1(T389*C);
/*CALL_INFIX_MINUS*/void r389type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_MINUS*/void r389non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_MINUS*/T6 r389use_current(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389static_simplify(T389*C);
/*CALL_INFIX_MINUS*/void r389init(T389*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_MINUS*/T0*r389extra_local_expanded(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T6 r389function_check(T389*C,T0*a1,T0*a2);
/*CALL_INFIX_MINUS*/void r389pretty(T389*C,T2 a1);
/*CALL_INFIX_MINUS*/T6 r389side_effect_free(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389non_void_no_dispatch_type(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389run_feature_for(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T0*r389inline_with(T389*C,T0*a1,T0*a2);
/*CALL_INFIX_MINUS*/T0*r389twin(T389*C);
/*CALL_INFIX_MINUS*/void r389bracketed_pretty(T389*C,T2 a1);
/*CALL_INFIX_MINUS*/T0*r389error_handler(void);
/*CALL_INFIX_MINUS*/T6 r389is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_MINUS*/void r389accept(T389*C,T0*a1);
/*CALL_INFIX_MINUS*/T351 r389start_position(T389*C);
/*CALL_INFIX_MINUS*/T6 r389is_stored_in_some_local_variable(void);
/*CALL_INFIX_MINUS*/T0*r389_P_363_declaration_type(T389*C);
/*BUILT_IN_EQ_NEQ*/T412*create412make_neq(T0*a1,T351 a2,T0*a3);
/*BUILT_IN_EQ_NEQ*/T412*create412make_eq(T0*a1,T351 a2,T0*a3);
extern T0*oBC412declaration_type;
extern int fBC412declaration_type;
/*BUILT_IN_EQ_NEQ*/T0*r412declaration_type(void);
/*BUILT_IN_EQ_NEQ*/void r412specialize_and_check_standard_comparison_check(T412*C,T0*a1,T0*a2,T0*a3);
/*BUILT_IN_EQ_NEQ*/T0*r412adapt_for(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/T0*r412resolve_in(T0*a1);
/*BUILT_IN_EQ_NEQ*/T0*r412simplify_integer_real(T412*C,T0*a1,T0*a2);
/*BUILT_IN_EQ_NEQ*/T0*r412collect(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/T0*r412specialized(T412*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*BUILT_IN_EQ_NEQ*/T0*r412specialize_in(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/T6 r412is_static(T412*C);
extern T0*oBC412written_declaration_type_mark;
extern int fBC412written_declaration_type_mark;
/*BUILT_IN_EQ_NEQ*/T0*r412written_declaration_type_mark(void);
/*BUILT_IN_EQ_NEQ*/T0*r412simplify(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/void r412pretty_target(T412*C,T2 a1);
/*BUILT_IN_EQ_NEQ*/void r412safety_check(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/T0*r412to_expression(T412*C);
/*BUILT_IN_EQ_NEQ*/T0*r412specialize_thru(T412*C,T0*a1,T0*a2,T0*a3);
/*BUILT_IN_EQ_NEQ*/T0*r412specialize_and_check(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/void r412inline_dynamic_dispatch_(T412*C,T0*a1,T0*a2);
/*BUILT_IN_EQ_NEQ*/T0*r412to_instruction(T412*C);
/*BUILT_IN_EQ_NEQ*/T0*r412current_or_twin_init(T412*C,T0*a1,T0*a2);
/*BUILT_IN_EQ_NEQ*/T0*r412simplify_boolean_constant(T412*C,T0*a1,T0*a2);
/*BUILT_IN_EQ_NEQ*/T0*r412true_or_false(T412*C,T6 a1);
/*BUILT_IN_EQ_NEQ*/T0*r412simplify_null_pointer(T412*C,T0*a1,T0*a2);
/*BUILT_IN_EQ_NEQ*/T0*r412simplify_void(T412*C,T0*a1,T0*a2,T0*a3);
/*BUILT_IN_EQ_NEQ*/void r412make_eq(T412*C,T0*a1,T351 a2,T0*a3);
/*BUILT_IN_EQ_NEQ*/T6 r412use_current(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/T0*r412static_simplify(T412*C);
/*BUILT_IN_EQ_NEQ*/void r412basic_make(T412*C,T6 a1,T0*a2,T351 a3,T0*a4);
/*BUILT_IN_EQ_NEQ*/void r412void_comparison_check(T412*C,T0*a1,T351 a2,T0*a3);
/*BUILT_IN_EQ_NEQ*/void r412pretty(T412*C,T2 a1);
/*BUILT_IN_EQ_NEQ*/T6 r412side_effect_free(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/T0*r412simplify_character_constant(T412*C,T0*a1,T0*a2);
/*BUILT_IN_EQ_NEQ*/T0*r412non_void_no_dispatch_type(T0*a1);
/*BUILT_IN_EQ_NEQ*/T0*r412inline_with(T412*C,T0*a1,T0*a2,T0*a3);
/*BUILT_IN_EQ_NEQ*/T0*r412twin(T412*C);
/*BUILT_IN_EQ_NEQ*/void r412set_left_and_right(T412*C,T0*a1,T0*a2);
/*BUILT_IN_EQ_NEQ*/void r412bracketed_pretty(T412*C,T2 a1);
/*BUILT_IN_EQ_NEQ*/T0*r412error_handler(void);
/*BUILT_IN_EQ_NEQ*/void r412accept(T412*C,T0*a1);
/*BUILT_IN_EQ_NEQ*/void r412make_neq(T412*C,T0*a1,T351 a2,T0*a3);
/*BUILT_IN_EQ_NEQ*/T351 r412start_position(T412*C);
/*BUILT_IN_EQ_NEQ*/T6 r412is_stored_in_some_local_variable(void);
/*CALL_INFIX_LE*/T6 r524is_balanced_operator(T0*a1);
/*CALL_INFIX_LE*/T0*r524declaration_type(T524*C);
/*CALL_INFIX_LE*/T0*r524adapt_for(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524resolve_in(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524eiffel_parser(void);
/*CALL_INFIX_LE*/T0*r524use_current_stack(void);
/*CALL_INFIX_LE*/T0*r524collect(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524parentheses_feature_name(T524*C);
/*CALL_INFIX_LE*/T0*r524specialize_in(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524written_declaration_type_mark(T524*C);
/*CALL_INFIX_LE*/T0*r524simplify(T524*C,T0*a1);
/*CALL_INFIX_LE*/void r524pretty_target(T524*C,T2 a1);
/*CALL_INFIX_LE*/void r524safety_check(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524to_expression(T524*C);
/*CALL_INFIX_LE*/T0*r524specialize_thru(T524*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_LE*/T0*r524feature_accumulator(void);
/*CALL_INFIX_LE*/T0*r524specialize_and_check(T524*C,T0*a1);
/*CALL_INFIX_LE*/void r524inline_dynamic_dispatch_(T524*C,T0*a1,T0*a2);
/*CALL_INFIX_LE*/T0*r524to_instruction(T524*C);
/*CALL_INFIX_LE*/T0*r524current_or_twin_init(T524*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_LE*/void r524standard_check_export_and_obsolete_calls(T524*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_LE*/void r524make(T524*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_LE*/T0*r524arg1(T524*C);
/*CALL_INFIX_LE*/void r524type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_LE*/void r524non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_LE*/T6 r524use_current(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524static_simplify(T524*C);
/*CALL_INFIX_LE*/void r524init(T524*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_LE*/T0*r524extra_local_expanded(T524*C,T0*a1);
/*CALL_INFIX_LE*/T6 r524function_check(T524*C,T0*a1,T0*a2);
/*CALL_INFIX_LE*/void r524pretty(T524*C,T2 a1);
/*CALL_INFIX_LE*/T6 r524side_effect_free(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524non_void_no_dispatch_type(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524run_feature_for(T524*C,T0*a1);
/*CALL_INFIX_LE*/T0*r524inline_with(T524*C,T0*a1,T0*a2);
/*CALL_INFIX_LE*/T0*r524twin(T524*C);
/*CALL_INFIX_LE*/void r524bracketed_pretty(T524*C,T2 a1);
/*CALL_INFIX_LE*/T0*r524error_handler(void);
/*CALL_INFIX_LE*/T6 r524is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_LE*/void r524accept(T524*C,T0*a1);
/*CALL_INFIX_LE*/T351 r524start_position(T524*C);
/*CALL_INFIX_LE*/T6 r524is_stored_in_some_local_variable(void);
/*CALL_INFIX_LE*/T0*r524_P_363_declaration_type(T524*C);
/*CALL_INFIX_GE*/T6 r525is_balanced_operator(T0*a1);
/*CALL_INFIX_GE*/T0*r525declaration_type(T525*C);
/*CALL_INFIX_GE*/T0*r525adapt_for(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525resolve_in(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525eiffel_parser(void);
/*CALL_INFIX_GE*/T0*r525use_current_stack(void);
/*CALL_INFIX_GE*/T0*r525collect(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525parentheses_feature_name(T525*C);
/*CALL_INFIX_GE*/T0*r525specialize_in(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525written_declaration_type_mark(T525*C);
/*CALL_INFIX_GE*/T0*r525simplify(T525*C,T0*a1);
/*CALL_INFIX_GE*/void r525pretty_target(T525*C,T2 a1);
/*CALL_INFIX_GE*/void r525safety_check(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525to_expression(T525*C);
/*CALL_INFIX_GE*/T0*r525specialize_thru(T525*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_GE*/T0*r525feature_accumulator(void);
/*CALL_INFIX_GE*/T0*r525specialize_and_check(T525*C,T0*a1);
/*CALL_INFIX_GE*/void r525inline_dynamic_dispatch_(T525*C,T0*a1,T0*a2);
/*CALL_INFIX_GE*/T0*r525to_instruction(T525*C);
/*CALL_INFIX_GE*/T0*r525current_or_twin_init(T525*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_GE*/void r525standard_check_export_and_obsolete_calls(T525*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_GE*/void r525make(T525*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_GE*/T0*r525arg1(T525*C);
/*CALL_INFIX_GE*/void r525type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_GE*/void r525non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_GE*/T6 r525use_current(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525static_simplify(T525*C);
/*CALL_INFIX_GE*/void r525init(T525*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_GE*/T0*r525extra_local_expanded(T525*C,T0*a1);
/*CALL_INFIX_GE*/T6 r525function_check(T525*C,T0*a1,T0*a2);
/*CALL_INFIX_GE*/void r525pretty(T525*C,T2 a1);
/*CALL_INFIX_GE*/T6 r525side_effect_free(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525non_void_no_dispatch_type(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525run_feature_for(T525*C,T0*a1);
/*CALL_INFIX_GE*/T0*r525inline_with(T525*C,T0*a1,T0*a2);
/*CALL_INFIX_GE*/T0*r525twin(T525*C);
/*CALL_INFIX_GE*/void r525bracketed_pretty(T525*C,T2 a1);
/*CALL_INFIX_GE*/T0*r525error_handler(void);
/*CALL_INFIX_GE*/T6 r525is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_GE*/void r525accept(T525*C,T0*a1);
/*CALL_INFIX_GE*/T351 r525start_position(T525*C);
/*CALL_INFIX_GE*/T6 r525is_stored_in_some_local_variable(void);
/*CALL_INFIX_GE*/T0*r525_P_363_declaration_type(T525*C);
/*CALL_INFIX_LT*/T6 r526is_balanced_operator(T0*a1);
/*CALL_INFIX_LT*/T0*r526declaration_type(T526*C);
/*CALL_INFIX_LT*/T0*r526adapt_for(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526resolve_in(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526eiffel_parser(void);
/*CALL_INFIX_LT*/T0*r526use_current_stack(void);
/*CALL_INFIX_LT*/T0*r526collect(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526parentheses_feature_name(T526*C);
/*CALL_INFIX_LT*/T0*r526specialize_in(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526written_declaration_type_mark(T526*C);
/*CALL_INFIX_LT*/T0*r526simplify(T526*C,T0*a1);
/*CALL_INFIX_LT*/void r526pretty_target(T526*C,T2 a1);
/*CALL_INFIX_LT*/void r526safety_check(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526to_expression(T526*C);
/*CALL_INFIX_LT*/T0*r526specialize_thru(T526*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_LT*/T0*r526feature_accumulator(void);
/*CALL_INFIX_LT*/T0*r526specialize_and_check(T526*C,T0*a1);
/*CALL_INFIX_LT*/void r526inline_dynamic_dispatch_(T526*C,T0*a1,T0*a2);
/*CALL_INFIX_LT*/T0*r526to_instruction(T526*C);
/*CALL_INFIX_LT*/T0*r526current_or_twin_init(T526*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_LT*/void r526standard_check_export_and_obsolete_calls(T526*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_LT*/void r526make(T526*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_LT*/T0*r526arg1(T526*C);
/*CALL_INFIX_LT*/void r526type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_LT*/void r526non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_LT*/T6 r526use_current(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526static_simplify(T526*C);
/*CALL_INFIX_LT*/void r526init(T526*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_LT*/T0*r526extra_local_expanded(T526*C,T0*a1);
/*CALL_INFIX_LT*/T6 r526function_check(T526*C,T0*a1,T0*a2);
/*CALL_INFIX_LT*/void r526pretty(T526*C,T2 a1);
/*CALL_INFIX_LT*/T6 r526side_effect_free(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526non_void_no_dispatch_type(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526run_feature_for(T526*C,T0*a1);
/*CALL_INFIX_LT*/T0*r526inline_with(T526*C,T0*a1,T0*a2);
/*CALL_INFIX_LT*/T0*r526twin(T526*C);
/*CALL_INFIX_LT*/void r526bracketed_pretty(T526*C,T2 a1);
/*CALL_INFIX_LT*/T0*r526error_handler(void);
/*CALL_INFIX_LT*/T6 r526is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_LT*/void r526accept(T526*C,T0*a1);
/*CALL_INFIX_LT*/T351 r526start_position(T526*C);
/*CALL_INFIX_LT*/T6 r526is_stored_in_some_local_variable(void);
/*CALL_INFIX_LT*/T0*r526_P_363_declaration_type(T526*C);
/*CALL_INFIX_GT*/T6 r527is_balanced_operator(T0*a1);
/*CALL_INFIX_GT*/T0*r527declaration_type(T527*C);
/*CALL_INFIX_GT*/T0*r527adapt_for(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527resolve_in(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527eiffel_parser(void);
/*CALL_INFIX_GT*/T0*r527use_current_stack(void);
/*CALL_INFIX_GT*/T0*r527collect(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527parentheses_feature_name(T527*C);
/*CALL_INFIX_GT*/T0*r527specialize_in(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527written_declaration_type_mark(T527*C);
/*CALL_INFIX_GT*/T0*r527simplify(T527*C,T0*a1);
/*CALL_INFIX_GT*/void r527pretty_target(T527*C,T2 a1);
/*CALL_INFIX_GT*/void r527safety_check(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527to_expression(T527*C);
/*CALL_INFIX_GT*/T0*r527specialize_thru(T527*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_GT*/T0*r527feature_accumulator(void);
/*CALL_INFIX_GT*/T0*r527specialize_and_check(T527*C,T0*a1);
/*CALL_INFIX_GT*/void r527inline_dynamic_dispatch_(T527*C,T0*a1,T0*a2);
/*CALL_INFIX_GT*/T0*r527to_instruction(T527*C);
/*CALL_INFIX_GT*/T0*r527current_or_twin_init(T527*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_GT*/void r527standard_check_export_and_obsolete_calls(T527*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_GT*/void r527make(T527*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_GT*/T0*r527arg1(T527*C);
/*CALL_INFIX_GT*/void r527type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_GT*/void r527non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_GT*/T6 r527use_current(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527static_simplify(T527*C);
/*CALL_INFIX_GT*/void r527init(T527*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_GT*/T0*r527extra_local_expanded(T527*C,T0*a1);
/*CALL_INFIX_GT*/T6 r527function_check(T527*C,T0*a1,T0*a2);
/*CALL_INFIX_GT*/void r527pretty(T527*C,T2 a1);
/*CALL_INFIX_GT*/T6 r527side_effect_free(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527non_void_no_dispatch_type(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527run_feature_for(T527*C,T0*a1);
/*CALL_INFIX_GT*/T0*r527inline_with(T527*C,T0*a1,T0*a2);
/*CALL_INFIX_GT*/T0*r527twin(T527*C);
/*CALL_INFIX_GT*/void r527bracketed_pretty(T527*C,T2 a1);
/*CALL_INFIX_GT*/T0*r527error_handler(void);
/*CALL_INFIX_GT*/T6 r527is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_GT*/void r527accept(T527*C,T0*a1);
/*CALL_INFIX_GT*/T351 r527start_position(T527*C);
/*CALL_INFIX_GT*/T6 r527is_stored_in_some_local_variable(void);
/*CALL_INFIX_GT*/T0*r527_P_363_declaration_type(T527*C);
/*CALL_INFIX_AND_THEN*/T6 r417is_balanced_operator(T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417declaration_type(T417*C);
/*CALL_INFIX_AND_THEN*/T0*r417adapt_for(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417resolve_in(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417eiffel_parser(void);
/*CALL_INFIX_AND_THEN*/T0*r417use_current_stack(void);
/*CALL_INFIX_AND_THEN*/T0*r417collect(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417parentheses_feature_name(T417*C);
/*CALL_INFIX_AND_THEN*/T0*r417specialize_in(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417written_declaration_type_mark(T417*C);
/*CALL_INFIX_AND_THEN*/T0*r417simplify(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/void r417pretty_target(T417*C,T2 a1);
/*CALL_INFIX_AND_THEN*/void r417safety_check(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417to_expression(T417*C);
/*CALL_INFIX_AND_THEN*/T0*r417specialize_thru(T417*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_AND_THEN*/T0*r417feature_accumulator(void);
/*CALL_INFIX_AND_THEN*/T0*r417specialize_and_check(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/void r417inline_dynamic_dispatch_(T417*C,T0*a1,T0*a2);
/*CALL_INFIX_AND_THEN*/T0*r417to_instruction(T417*C);
/*CALL_INFIX_AND_THEN*/T0*r417current_or_twin_init(T417*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_AND_THEN*/void r417standard_check_export_and_obsolete_calls(T417*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_AND_THEN*/void r417make(T417*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_AND_THEN*/T0*r417arg1(T417*C);
/*CALL_INFIX_AND_THEN*/T6 r417use_current(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417static_simplify(T417*C);
/*CALL_INFIX_AND_THEN*/void r417init(T417*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_AND_THEN*/T0*r417and_then_name(void);
/*CALL_INFIX_AND_THEN*/T0*r417extra_local_expanded(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T6 r417function_check(T417*C,T0*a1,T0*a2);
/*CALL_INFIX_AND_THEN*/void r417pretty(T417*C,T2 a1);
/*CALL_INFIX_AND_THEN*/T6 r417side_effect_free(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417non_void_no_dispatch_type(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417run_feature_for(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T0*r417inline_with(T417*C,T0*a1,T0*a2);
/*CALL_INFIX_AND_THEN*/T0*r417twin(T417*C);
/*CALL_INFIX_AND_THEN*/void r417bracketed_pretty(T417*C,T2 a1);
/*CALL_INFIX_AND_THEN*/T0*r417error_handler(void);
/*CALL_INFIX_AND_THEN*/T6 r417is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_AND_THEN*/void r417accept(T417*C,T0*a1);
/*CALL_INFIX_AND_THEN*/T351 r417start_position(T417*C);
/*CALL_INFIX_AND_THEN*/T6 r417is_stored_in_some_local_variable(void);
/*CALL_INFIX_AND_THEN*/T0*r417_P_363_declaration_type(T417*C);
/*CALL_INFIX_AND*/T6 r523is_balanced_operator(T0*a1);
/*CALL_INFIX_AND*/T0*r523declaration_type(T523*C);
/*CALL_INFIX_AND*/T0*r523adapt_for(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523resolve_in(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523eiffel_parser(void);
/*CALL_INFIX_AND*/T0*r523use_current_stack(void);
/*CALL_INFIX_AND*/T0*r523collect(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523parentheses_feature_name(T523*C);
/*CALL_INFIX_AND*/T0*r523specialize_in(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523written_declaration_type_mark(T523*C);
/*CALL_INFIX_AND*/T0*r523simplify(T523*C,T0*a1);
/*CALL_INFIX_AND*/void r523pretty_target(T523*C,T2 a1);
/*CALL_INFIX_AND*/void r523safety_check(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523to_expression(T523*C);
/*CALL_INFIX_AND*/T0*r523specialize_thru(T523*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_AND*/T0*r523feature_accumulator(void);
/*CALL_INFIX_AND*/T0*r523specialize_and_check(T523*C,T0*a1);
/*CALL_INFIX_AND*/void r523inline_dynamic_dispatch_(T523*C,T0*a1,T0*a2);
/*CALL_INFIX_AND*/T0*r523to_instruction(T523*C);
/*CALL_INFIX_AND*/T0*r523current_or_twin_init(T523*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_AND*/void r523standard_check_export_and_obsolete_calls(T523*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_AND*/void r523make(T523*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_AND*/T0*r523arg1(T523*C);
/*CALL_INFIX_AND*/void r523type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_AND*/void r523non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_AND*/T6 r523use_current(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523static_simplify(T523*C);
/*CALL_INFIX_AND*/void r523init(T523*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_AND*/T0*r523extra_local_expanded(T523*C,T0*a1);
/*CALL_INFIX_AND*/T6 r523function_check(T523*C,T0*a1,T0*a2);
/*CALL_INFIX_AND*/void r523pretty(T523*C,T2 a1);
/*CALL_INFIX_AND*/T6 r523side_effect_free(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523non_void_no_dispatch_type(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523run_feature_for(T523*C,T0*a1);
/*CALL_INFIX_AND*/T0*r523inline_with(T523*C,T0*a1,T0*a2);
/*CALL_INFIX_AND*/T0*r523twin(T523*C);
/*CALL_INFIX_AND*/void r523bracketed_pretty(T523*C,T2 a1);
/*CALL_INFIX_AND*/T0*r523error_handler(void);
/*CALL_INFIX_AND*/T6 r523is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_AND*/void r523accept(T523*C,T0*a1);
/*CALL_INFIX_AND*/T351 r523start_position(T523*C);
/*CALL_INFIX_AND*/T6 r523is_stored_in_some_local_variable(void);
/*CALL_INFIX_AND*/T0*r523_P_363_declaration_type(T523*C);
/*CALL_INFIX_OR_ELSE*/T6 r520is_balanced_operator(T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520declaration_type(T520*C);
/*CALL_INFIX_OR_ELSE*/T0*r520adapt_for(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520resolve_in(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520eiffel_parser(void);
/*CALL_INFIX_OR_ELSE*/T0*r520use_current_stack(void);
/*CALL_INFIX_OR_ELSE*/T0*r520collect(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520parentheses_feature_name(T520*C);
/*CALL_INFIX_OR_ELSE*/T0*r520specialize_in(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520written_declaration_type_mark(T520*C);
/*CALL_INFIX_OR_ELSE*/T0*r520simplify(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/void r520pretty_target(T520*C,T2 a1);
/*CALL_INFIX_OR_ELSE*/void r520safety_check(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520to_expression(T520*C);
/*CALL_INFIX_OR_ELSE*/T0*r520specialize_thru(T520*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_OR_ELSE*/T0*r520feature_accumulator(void);
/*CALL_INFIX_OR_ELSE*/T0*r520specialize_and_check(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/void r520inline_dynamic_dispatch_(T520*C,T0*a1,T0*a2);
/*CALL_INFIX_OR_ELSE*/T0*r520to_instruction(T520*C);
/*CALL_INFIX_OR_ELSE*/T0*r520current_or_twin_init(T520*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_OR_ELSE*/void r520standard_check_export_and_obsolete_calls(T520*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_OR_ELSE*/void r520make(T520*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_OR_ELSE*/T0*r520arg1(T520*C);
/*CALL_INFIX_OR_ELSE*/T6 r520use_current(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520static_simplify(T520*C);
/*CALL_INFIX_OR_ELSE*/void r520init(T520*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_OR_ELSE*/T0*r520extra_local_expanded(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520or_else_name(void);
/*CALL_INFIX_OR_ELSE*/T6 r520function_check(T520*C,T0*a1,T0*a2);
/*CALL_INFIX_OR_ELSE*/void r520pretty(T520*C,T2 a1);
/*CALL_INFIX_OR_ELSE*/T6 r520side_effect_free(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520non_void_no_dispatch_type(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520run_feature_for(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T0*r520inline_with(T520*C,T0*a1,T0*a2);
/*CALL_INFIX_OR_ELSE*/T0*r520twin(T520*C);
/*CALL_INFIX_OR_ELSE*/void r520bracketed_pretty(T520*C,T2 a1);
/*CALL_INFIX_OR_ELSE*/T0*r520error_handler(void);
/*CALL_INFIX_OR_ELSE*/T6 r520is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_OR_ELSE*/void r520accept(T520*C,T0*a1);
/*CALL_INFIX_OR_ELSE*/T351 r520start_position(T520*C);
/*CALL_INFIX_OR_ELSE*/T6 r520is_stored_in_some_local_variable(void);
/*CALL_INFIX_OR_ELSE*/T0*r520_P_363_declaration_type(T520*C);
/*CALL_INFIX_OR*/T6 r521is_balanced_operator(T0*a1);
/*CALL_INFIX_OR*/T0*r521declaration_type(T521*C);
/*CALL_INFIX_OR*/T0*r521adapt_for(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521resolve_in(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521eiffel_parser(void);
/*CALL_INFIX_OR*/T0*r521use_current_stack(void);
/*CALL_INFIX_OR*/T0*r521collect(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521parentheses_feature_name(T521*C);
/*CALL_INFIX_OR*/T0*r521specialize_in(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521written_declaration_type_mark(T521*C);
/*CALL_INFIX_OR*/T0*r521simplify(T521*C,T0*a1);
/*CALL_INFIX_OR*/void r521pretty_target(T521*C,T2 a1);
/*CALL_INFIX_OR*/void r521safety_check(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521to_expression(T521*C);
/*CALL_INFIX_OR*/T0*r521specialize_thru(T521*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_OR*/T0*r521feature_accumulator(void);
/*CALL_INFIX_OR*/T0*r521specialize_and_check(T521*C,T0*a1);
/*CALL_INFIX_OR*/void r521inline_dynamic_dispatch_(T521*C,T0*a1,T0*a2);
/*CALL_INFIX_OR*/T0*r521to_instruction(T521*C);
/*CALL_INFIX_OR*/T0*r521current_or_twin_init(T521*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_OR*/void r521standard_check_export_and_obsolete_calls(T521*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_OR*/void r521make(T521*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_OR*/T0*r521arg1(T521*C);
/*CALL_INFIX_OR*/void r521type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_OR*/void r521non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_OR*/T6 r521use_current(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521static_simplify(T521*C);
/*CALL_INFIX_OR*/void r521init(T521*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_OR*/T0*r521extra_local_expanded(T521*C,T0*a1);
/*CALL_INFIX_OR*/T6 r521function_check(T521*C,T0*a1,T0*a2);
/*CALL_INFIX_OR*/void r521pretty(T521*C,T2 a1);
/*CALL_INFIX_OR*/T6 r521side_effect_free(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521non_void_no_dispatch_type(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521run_feature_for(T521*C,T0*a1);
/*CALL_INFIX_OR*/T0*r521inline_with(T521*C,T0*a1,T0*a2);
/*CALL_INFIX_OR*/T0*r521twin(T521*C);
/*CALL_INFIX_OR*/void r521bracketed_pretty(T521*C,T2 a1);
/*CALL_INFIX_OR*/T0*r521error_handler(void);
/*CALL_INFIX_OR*/T6 r521is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_OR*/void r521accept(T521*C,T0*a1);
/*CALL_INFIX_OR*/T351 r521start_position(T521*C);
/*CALL_INFIX_OR*/T6 r521is_stored_in_some_local_variable(void);
/*CALL_INFIX_OR*/T0*r521_P_363_declaration_type(T521*C);
/*CALL_INFIX_XOR*/T6 r522is_balanced_operator(T0*a1);
/*CALL_INFIX_XOR*/T0*r522declaration_type(T522*C);
/*CALL_INFIX_XOR*/T0*r522adapt_for(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522resolve_in(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522eiffel_parser(void);
/*CALL_INFIX_XOR*/T0*r522use_current_stack(void);
/*CALL_INFIX_XOR*/T0*r522collect(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522parentheses_feature_name(T522*C);
/*CALL_INFIX_XOR*/T0*r522specialize_in(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522written_declaration_type_mark(T522*C);
/*CALL_INFIX_XOR*/T0*r522simplify(T522*C,T0*a1);
/*CALL_INFIX_XOR*/void r522pretty_target(T522*C,T2 a1);
/*CALL_INFIX_XOR*/void r522safety_check(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522to_expression(T522*C);
/*CALL_INFIX_XOR*/T0*r522specialize_thru(T522*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_XOR*/T0*r522feature_accumulator(void);
/*CALL_INFIX_XOR*/T0*r522specialize_and_check(T522*C,T0*a1);
/*CALL_INFIX_XOR*/void r522inline_dynamic_dispatch_(T522*C,T0*a1,T0*a2);
/*CALL_INFIX_XOR*/T0*r522to_instruction(T522*C);
/*CALL_INFIX_XOR*/T0*r522current_or_twin_init(T522*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_XOR*/void r522standard_check_export_and_obsolete_calls(T522*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_XOR*/void r522make(T522*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_XOR*/T0*r522arg1(T522*C);
/*CALL_INFIX_XOR*/void r522type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_XOR*/void r522non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_XOR*/T6 r522use_current(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522static_simplify(T522*C);
/*CALL_INFIX_XOR*/void r522init(T522*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_XOR*/T0*r522extra_local_expanded(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T6 r522function_check(T522*C,T0*a1,T0*a2);
/*CALL_INFIX_XOR*/void r522pretty(T522*C,T2 a1);
/*CALL_INFIX_XOR*/T6 r522side_effect_free(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522non_void_no_dispatch_type(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522run_feature_for(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T0*r522inline_with(T522*C,T0*a1,T0*a2);
/*CALL_INFIX_XOR*/T0*r522twin(T522*C);
/*CALL_INFIX_XOR*/void r522bracketed_pretty(T522*C,T2 a1);
/*CALL_INFIX_XOR*/T0*r522error_handler(void);
/*CALL_INFIX_XOR*/T6 r522is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_XOR*/void r522accept(T522*C,T0*a1);
/*CALL_INFIX_XOR*/T351 r522start_position(T522*C);
/*CALL_INFIX_XOR*/T6 r522is_stored_in_some_local_variable(void);
/*CALL_INFIX_XOR*/T0*r522_P_363_declaration_type(T522*C);
/*CALL_INFIX_IMPLIES*/T6 r519is_balanced_operator(T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519declaration_type(T519*C);
/*CALL_INFIX_IMPLIES*/T0*r519adapt_for(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519resolve_in(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519eiffel_parser(void);
/*CALL_INFIX_IMPLIES*/T0*r519use_current_stack(void);
/*CALL_INFIX_IMPLIES*/T0*r519collect(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519parentheses_feature_name(T519*C);
/*CALL_INFIX_IMPLIES*/T0*r519specialize_in(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519written_declaration_type_mark(T519*C);
/*CALL_INFIX_IMPLIES*/T0*r519simplify(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/void r519pretty_target(T519*C,T2 a1);
/*CALL_INFIX_IMPLIES*/void r519safety_check(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519to_expression(T519*C);
/*CALL_INFIX_IMPLIES*/T0*r519specialize_thru(T519*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_IMPLIES*/T0*r519feature_accumulator(void);
/*CALL_INFIX_IMPLIES*/T0*r519specialize_and_check(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/void r519inline_dynamic_dispatch_(T519*C,T0*a1,T0*a2);
/*CALL_INFIX_IMPLIES*/T0*r519to_instruction(T519*C);
/*CALL_INFIX_IMPLIES*/T0*r519current_or_twin_init(T519*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_IMPLIES*/void r519standard_check_export_and_obsolete_calls(T519*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_IMPLIES*/void r519make(T519*C,T0*a1,T351 a2,T0*a3);
/*CALL_INFIX_IMPLIES*/T0*r519arg1(T519*C);
/*CALL_INFIX_IMPLIES*/void r519type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_IMPLIES*/void r519non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*CALL_INFIX_IMPLIES*/T6 r519use_current(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519static_simplify(T519*C);
/*CALL_INFIX_IMPLIES*/void r519init(T519*C,T0*a1,T0*a2,T0*a3);
/*CALL_INFIX_IMPLIES*/T0*r519extra_local_expanded(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T6 r519function_check(T519*C,T0*a1,T0*a2);
/*CALL_INFIX_IMPLIES*/void r519pretty(T519*C,T2 a1);
/*CALL_INFIX_IMPLIES*/T6 r519side_effect_free(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519non_void_no_dispatch_type(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519run_feature_for(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T0*r519inline_with(T519*C,T0*a1,T0*a2);
/*CALL_INFIX_IMPLIES*/T0*r519twin(T519*C);
/*CALL_INFIX_IMPLIES*/void r519bracketed_pretty(T519*C,T2 a1);
/*CALL_INFIX_IMPLIES*/T0*r519error_handler(void);
/*CALL_INFIX_IMPLIES*/T6 r519is_question_mark_open_operand(T0*a1);
/*CALL_INFIX_IMPLIES*/void r519accept(T519*C,T0*a1);
/*CALL_INFIX_IMPLIES*/T351 r519start_position(T519*C);
/*CALL_INFIX_IMPLIES*/T6 r519is_stored_in_some_local_variable(void);
/*CALL_INFIX_IMPLIES*/T0*r519_P_363_declaration_type(T519*C);
/*CALL_INFIX_IMPLIES*/void r519_P_363_inline_dynamic_dispatch_(T519*C,T0*a1,T0*a2);
/*ADDRESS_OF*/T0*r476specialize_and_check(T476*C,T0*a1);
/*ADDRESS_OF*/T0*r476to_expression(T476*C);
/*ADDRESS_OF*/void r476pretty(T476*C,T2 a1);
/*ADDRESS_OF*/T0*r476simplify(T476*C,T0*a1);
/*ADDRESS_OF*/T0*r476static_simplify(T476*C);
/*ADDRESS_OF*/T0*r476specialize_in(T476*C,T0*a1);
/*ADDRESS_OF*/void r476inline_dynamic_dispatch_(T476*C,T0*a1,T0*a2);
/*ADDRESS_OF*/void r476safety_check(T476*C,T0*a1);
/*ADDRESS_OF*/T0*r476specialize_thru(T476*C,T0*a1,T0*a2,T0*a3);
/*ADDRESS_OF*/T6 r476is_stored_in_some_local_variable(void);
/*ADDRESS_OF*/void r476accept(T476*C,T0*a1);
/*ADDRESS_OF*/T0*r476adapt_for(T476*C,T0*a1);
extern T0*oBC476declaration_type;
extern int fBC476declaration_type;
/*ADDRESS_OF*/T0*r476declaration_type(void);
/*ADDRESS_OF*/T0*r476collect(T476*C,T0*a1);
/*ADDRESS_OF*/T351 r476start_position(T476*C);
/*ADDRESS_OF*/T0*r476twin(T476*C);
/*ADDRESS_OF*/T0*r476written_declaration_type_mark(void);
/*ADDRESS_OF*/T6 r476use_current(T476*C,T0*a1);
/*ADDRESS_OF*/void r476bracketed_pretty(T476*C,T2 a1);
/*ADDRESS_OF*/T0*r476non_void_no_dispatch_type(T0*a1);
/*ADDRESS_OF*/T6 r476side_effect_free(T0*a1);
/*ADDRESS_OF*/void r476with_local(T476*C,T0*a1);
/*ADDRESS_OF*/T0*r476error_handler(void);
/*ADDRESS_OF*/void r476with_feature_name(T476*C,T0*a1);
/*ADDRESS_OF*/T0*r476resolve_in(T0*a1);
/*ADDRESS_OF*/T0*r476to_instruction(T476*C);
/*EXPORT_LIST*/void r479check_level_2(T479*C,T0*a1,T0*a2);
/*EXPORT_LIST*/void r479make(T479*C,T351 a1,T0*a2);
/*EXPORT_LIST*/T0*r479clients_for(T479*C,T0*a1);
/*EXPORT_LIST*/T0*r479error_handler(void);
/*EXPORT_ITEM*/void r478make(T478*C,T0*a1,T0*a2);
/*EXPORT_ITEM*/void r478make_all(T478*C,T0*a1);
/*FEATURE_CLAUSE*/void r446make(T446*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*FEATURE_CLAUSE*/void r446add_into(T446*C,T0*a1);
/*CLUSTER_CLASS*/void r784make(T784*C,T0*a1,T0*a2,T0*a3);
/*TAG_NAME*/void r470make(T470*C,T0*a1,T351 a2);
/*ARGUMENT_NAME_REF*/T0*r372specialize_and_check(T372*C,T0*a1);
/*ARGUMENT_NAME_REF*/T0*r372to_expression(T372*C);
/*ARGUMENT_NAME_REF*/void r372pretty(T372*C,T2 a1);
/*ARGUMENT_NAME_REF*/T0*r372simplify(T372*C,T0*a1);
/*ARGUMENT_NAME_REF*/T0*r372static_simplify(T372*C);
/*ARGUMENT_NAME_REF*/T0*r372specialize_in(T372*C,T0*a1);
/*ARGUMENT_NAME_REF*/void r372inline_dynamic_dispatch_(T372*C,T0*a1,T0*a2);
/*ARGUMENT_NAME_REF*/T0*r372specialize_thru(T372*C,T0*a1,T0*a2,T0*a3);
/*ARGUMENT_NAME_REF*/T6 r372is_stored_in_some_local_variable(void);
/*ARGUMENT_NAME_REF*/void r372accept(T372*C,T0*a1);
/*ARGUMENT_NAME_REF*/T0*r372adapt_for(T372*C,T0*a1);
/*ARGUMENT_NAME_REF*/T0*r372feature_accumulator(void);
/*ARGUMENT_NAME_REF*/T0*r372collect(T372*C,T0*a1);
/*ARGUMENT_NAME_REF*/void r372pretty_target(T372*C,T2 a1);
/*ARGUMENT_NAME_REF*/T0*r372as_outside(T372*C);
/*ARGUMENT_NAME_REF*/T0*r372twin(T372*C);
/*ARGUMENT_NAME_REF*/T0*r372written_declaration_type_mark(T372*C);
/*ARGUMENT_NAME_REF*/void r372refer_to(T372*C,T351 a1,T0*a2,T2 a3,T2 a4);
/*ARGUMENT_NAME_REF*/T6 r372use_current(T0*a1);
/*ARGUMENT_NAME_REF*/T0*r372non_void_no_dispatch_type(T372*C,T0*a1);
/*ARGUMENT_NAME_REF*/T0*r372to_string(T372*C);
/*ARGUMENT_NAME_REF*/T6 r372side_effect_free(T0*a1);
/*ARGUMENT_NAME_REF*/T0*r372resolve_in(T372*C,T0*a1);
/*ARGUMENT_NAME_REF*/T0*r372to_instruction(T372*C);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425specialize_and_check(T425*C,T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425to_expression(T425*C);
/*WRITABLE_ATTRIBUTE_NAME*/void r425make(T425*C,T0*a1,T351 a2);
/*WRITABLE_ATTRIBUTE_NAME*/void r425pretty(T425*C,T2 a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425simplify(T425*C,T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425static_simplify(T425*C);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425specialize_in(T425*C,T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/void r425inline_dynamic_dispatch_(T425*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425specialize_thru(T425*C,T0*a1,T0*a2,T0*a3);
/*WRITABLE_ATTRIBUTE_NAME*/T6 r425is_stored_in_some_local_variable(void);
/*WRITABLE_ATTRIBUTE_NAME*/void r425accept(T425*C,T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425feature_accumulator(void);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425collect(T425*C,T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/void r425set_feature_stamp_and_type(T425*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE_NAME*/T351 r425start_position(T425*C);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425twin(T425*C);
/*WRITABLE_ATTRIBUTE_NAME*/T6 r425use_current(T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425non_void_no_dispatch_type(T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/T6 r425side_effect_free(T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425error_handler(void);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425resolve_in(T425*C,T0*a1);
/*WRITABLE_ATTRIBUTE_NAME*/T0*r425to_instruction(T425*C);
/*LOCAL_NAME_REF*/T0*r408specialize_and_check(T408*C,T0*a1);
/*LOCAL_NAME_REF*/T0*r408to_expression(T408*C);
/*LOCAL_NAME_REF*/void r408pretty(T408*C,T2 a1);
/*LOCAL_NAME_REF*/T0*r408simplify(T408*C,T0*a1);
/*LOCAL_NAME_REF*/T0*r408static_simplify(T408*C);
/*LOCAL_NAME_REF*/T0*r408specialize_in(T408*C,T0*a1);
/*LOCAL_NAME_REF*/void r408inline_dynamic_dispatch_(T408*C,T0*a1,T0*a2);
/*LOCAL_NAME_REF*/T0*r408specialize_thru(T408*C,T0*a1,T0*a2,T0*a3);
/*LOCAL_NAME_REF*/T6 r408is_stored_in_some_local_variable(void);
/*LOCAL_NAME_REF*/void r408accept(T408*C,T0*a1);
/*LOCAL_NAME_REF*/T0*r408adapt_for(T408*C,T0*a1);
/*LOCAL_NAME_REF*/T0*r408collect(T408*C,T0*a1);
/*LOCAL_NAME_REF*/void r408pretty_target(T408*C,T2 a1);
/*LOCAL_NAME_REF*/T0*r408as_outside(T408*C);
/*LOCAL_NAME_REF*/T0*r408twin(T408*C);
/*LOCAL_NAME_REF*/void r408refer_to(T408*C,T351 a1,T0*a2,T2 a3,T2 a4);
/*LOCAL_NAME_REF*/T6 r408use_current(T0*a1);
/*LOCAL_NAME_REF*/T0*r408non_void_no_dispatch_type(T408*C,T0*a1);
/*LOCAL_NAME_REF*/T0*r408to_string(T408*C);
/*LOCAL_NAME_REF*/T6 r408side_effect_free(T0*a1);
/*LOCAL_NAME_REF*/T0*r408error_handler(void);
/*LOCAL_NAME_REF*/T0*r408resolve_in(T408*C,T0*a1);
/*LOCAL_NAME_REF*/T0*r408to_instruction(T408*C);
/*RUN_FEATURE_2*/void r421for(T421*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_2*/T6 r421need_c_function(T421*C);
/*RUN_FEATURE_2*/void r421accept(T421*C,T0*a1);
/*RUN_FEATURE_2*/void r421set_result_type(T421*C);
/*RUN_FEATURE_2*/T351 r421start_position(T421*C);
/*RUN_FEATURE_2*/T6 r421use_current(T421*C);
/*RUN_FEATURE_2*/void r421mapping_name_in(T421*C,T0*a1);
/*RUN_FEATURE_2*/void r421do_adapt(T421*C);
/*RUN_FEATURE_2*/void r421adapt(T421*C);
/*RUN_FEATURE_2*/T0*r421feature_stamp(T421*C);
/*PARENT_LISTS*/void r463check_level_2(T463*C,T0*a1);
/*PARENT_LISTS*/void r463make(T463*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*PARENT_LISTS*/T0*r463insert_edge(T463*C,T2 a1);
/*PARENT_LISTS*/T0*r463inherit_edge(T463*C,T2 a1);
/*PARENT_LISTS*/void r463initialize_and_check_level_1(T463*C);
/*PARENT_LISTS*/T6 r463get_permission_of(T463*C,T0*a1);
/*PARENT_LISTS*/void r463id_extra_information(T463*C,T0*a1);
/*PARENT_LISTS*/T2 r463inherit_count(T463*C);
/*PARENT_LISTS*/T351 r463undefine_position_of(T463*C,T0*a1);
/*PARENT_LISTS*/void r463set_insert_member(T463*C,T2 a1);
/*PARENT_LISTS*/T2 r463insert_count(T463*C);
/*FEATURE_CLAUSE_LIST*/void r445make(T445*C,T0*a1);
/*FEATURE_CLAUSE_LIST*/void r445get_started(T445*C,T0*a1);
/*CREATION_CLAUSE_LIST*/void r460make(T460*C,T0*a1);
/*CREATION_CLAUSE_LIST*/void r460all_positions_in_error_handler(T460*C);
/*CREATION_CLAUSE_LIST*/T0*r460get_clause(T460*C,T0*a1);
/*CREATION_CLAUSE_LIST*/T0*r460default_root(T460*C);
/*CREATION_CLAUSE_LIST*/void r460extra_expanded_check(T460*C,T0*a1);
/*CREATION_CLAUSE_LIST*/T351 r460start_position(T460*C);
/*CREATION_CLAUSE_LIST*/T0*r460root_creation_search(T460*C,T0*a1);
/*CREATION_CLAUSE_LIST*/void r460check_for(T460*C,T0*a1);
/*CREATION_CLAUSE_LIST*/T0*r460error_handler(void);
/*CREATION_CLAUSE_LIST*/T0*r460user_expanded_default_create_stamp(T460*C,T0*a1);
/*CLASS_INVARIANT*/T0*r442specialize_and_check(T442*C,T0*a1);
/*CLASS_INVARIANT*/T0*r442to_expression(T442*C);
/*CLASS_INVARIANT*/void r442make(T442*C,T351 a1,T0*a2,T0*a3);
/*CLASS_INVARIANT*/T6 r442has_assertion_located_at(T442*C,T351 a1);
/*CLASS_INVARIANT*/void r442pretty(T442*C,T2 a1);
/*CLASS_INVARIANT*/T0*r442simplify(T442*C,T0*a1);
/*CLASS_INVARIANT*/T0*r442specialize_in(T442*C,T0*a1);
/*CLASS_INVARIANT*/void r442inline_dynamic_dispatch_(T442*C,T0*a1,T0*a2);
/*CLASS_INVARIANT*/T6 r442is_always_true(T442*C,T0*a1);
/*CLASS_INVARIANT*/void r442safety_check(T442*C,T0*a1);
/*CLASS_INVARIANT*/void r442set_list(T442*C,T0*a1);
/*CLASS_INVARIANT*/void r442for_each(T442*C,T0*a1);
/*CLASS_INVARIANT*/T0*r442specialize_thru(T442*C,T0*a1,T0*a2,T0*a3);
/*CLASS_INVARIANT*/void r442pretty_as_loop_invariant(T442*C,T2 a1);
/*CLASS_INVARIANT*/T2 r442upper(T442*C);
/*CLASS_INVARIANT*/void r442accept(T442*C,T0*a1);
/*CLASS_INVARIANT*/void r442set_eiffel_parser_stamp(T442*C,T2 a1);
/*CLASS_INVARIANT*/T0*r442adapt_for(T442*C,T0*a1);
/*CLASS_INVARIANT*/T0*r442item(T442*C,T2 a1);
/*CLASS_INVARIANT*/T0*r442add_items_from(T442*C,T0*a1);
/*CLASS_INVARIANT*/T0*r442collect(T442*C,T0*a1);
/*CLASS_INVARIANT*/void r442pretty_print_with_tag(T442*C,T2 a1,T0*a2);
/*CLASS_INVARIANT*/T6 r442is_empty(T442*C);
/*CLASS_INVARIANT*/T0*r442twin(T442*C);
/*CLASS_INVARIANT*/void r442pretty_as_check_compound(T442*C,T2 a1,T0*a2);
/*CLASS_INVARIANT*/T6 r442use_current(T442*C,T0*a1);
/*CLASS_INVARIANT*/void r442breakpoint(T442*C);
/*CLASS_INVARIANT*/void r442crash(T442*C);
/*CLASS_INVARIANT*/T6 r442side_effect_free(T442*C,T0*a1);
/*CLASS_INVARIANT*/T0*r442inline_dynamic_dispatch(T442*C,T0*a1,T0*a2);
/*CLASS_INVARIANT*/void r442not_yet_implemented(T442*C);
/*CLASS_INVARIANT*/T2 r442count(T442*C);
/*CLASS_INVARIANT*/T0*r442specialize_without_checks(T442*C,T0*a1);
/*CLASS_INVARIANT*/T0*r442to_instruction(T442*C);
/*CLASS_INVARIANT*/T2 r442lower(T442*C);
/*EXTERNAL_FUNCTION*/void r415add_into_shared(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/T0*r415inline_expression_1(T415*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6,T0*a7);
/*EXTERNAL_FUNCTION*/T0*r415inline_expression_0(T415*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*EXTERNAL_FUNCTION*/T0*r415specialize_closure_local_var_lists_thru(T415*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_FUNCTION*/void r415inline_dynamic_dispatch(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/T0*r415specialize_signature_in(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415specialize_require_thru(T415*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_FUNCTION*/T0*r415specialize_permissions(T415*C,T0*a1,T6 a2);
/*EXTERNAL_FUNCTION*/T0*r415c_plus_plus_name(T415*C);
/*EXTERNAL_FUNCTION*/T0*r415specialize_permissions_in(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415specialized_ensure_thru(T415*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_FUNCTION*/void r415set_closure(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/T0*r415external_name(T415*C);
/*EXTERNAL_FUNCTION*/T0*r415specialize_ensure_thru(T415*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*EXTERNAL_FUNCTION*/T0*r415specialized_require_thru(T415*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_FUNCTION*/T0*r415true_or_false(T6 a1,T351 a2);
/*EXTERNAL_FUNCTION*/T0*r415try_to_undefine_aux(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/void r415make_external_routine(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/T0*r415specialize_body_thru(T415*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*EXTERNAL_FUNCTION*/T0*r415specialize_body_in(T415*C,T0*a1,T6 a2);
/*EXTERNAL_FUNCTION*/T0*r415integer_constant(T0*a1);
/*EXTERNAL_FUNCTION*/void r415set_rescue_compound(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415specialize_closure_local_var_lists_in(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415simplify(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415specialize_ensure_in(T415*C,T0*a1,T6 a2);
/*EXTERNAL_FUNCTION*/T0*r415first_name(T415*C);
/*EXTERNAL_FUNCTION*/void r415pretty_print_names(T415*C);
/*EXTERNAL_FUNCTION*/void r415add_into(T415*C,T0*a1,T0*a2);
extern T0*oBC32any_copy_fs;
extern int fBC32any_copy_fs;
/*EXTERNAL_FUNCTION*/T0*r415any_copy_fs(void);
/*EXTERNAL_FUNCTION*/T6 r415same_signature(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/T0*r415brand_new_run_feature_for(T415*C,T0*a1,T0*a2,T6 a3);
/*EXTERNAL_FUNCTION*/void r415accept(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415try_to_undefine(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/void r415hook_collect(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/void r415init(T415*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5,T0*a6,T0*a7);
/*EXTERNAL_FUNCTION*/void r415inline_dynamic_dispatch_(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/T0*r415change_ensure(T415*C,T0*a1,T6 a2);
/*EXTERNAL_FUNCTION*/T0*r415specialize_closure_arguments_lists_in(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415names(T415*C);
/*EXTERNAL_FUNCTION*/T0*r415specialize_and_check(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415current_or_twin_init(T415*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5,T0*a6,T0*a7,T6 a8);
/*EXTERNAL_FUNCTION*/T0*r415merge_signature_thru(T415*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*EXTERNAL_FUNCTION*/void r415make_routine(T415*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*EXTERNAL_FUNCTION*/void r415collect(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415specialize_permissions_thru(T415*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_FUNCTION*/T0*r415twin(T415*C);
/*EXTERNAL_FUNCTION*/T6 r415use_current(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T0*r415adapt_routine_body_for(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/void r415collect_internals_handler(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/void r415pretty(T415*C,T2 a1,T6 a2);
/*EXTERNAL_FUNCTION*/T0*r415specialize_signature_thru(T415*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_FUNCTION*/T0*r415new_run_feature_for(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/void r415pretty_index(T415*C,T2 a1,T0*a2);
/*EXTERNAL_FUNCTION*/T6 r415valid_redefinition(T415*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*EXTERNAL_FUNCTION*/T0*r415specialize_closure_arguments_lists_thru(T415*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_FUNCTION*/T0*r415current_or_twin_init_no_body(T415*C,T0*a1,T0*a2,T0*a3,T6 a4,T0*a5,T0*a6,T6 a7);
/*EXTERNAL_FUNCTION*/T0*r415specialize_require_in(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/void r415add_into_(T415*C,T0*a1,T0*a2);
/*EXTERNAL_FUNCTION*/void r415set_arguments(T415*C,T0*a1,T0*a2);
extern T0*oBC32clear_all_name;
extern int fBC32clear_all_name;
/*EXTERNAL_FUNCTION*/T0*r415clear_all_name(void);
/*EXTERNAL_FUNCTION*/void r415collect_body(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/void r415valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*EXTERNAL_FUNCTION*/T0*r415change_require(T415*C,T0*a1,T6 a2);
/*EXTERNAL_FUNCTION*/T2 r415argument_rank_of(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T6 r415same_body_as(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/void r415make(T415*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7);
/*EXTERNAL_FUNCTION*/T6 r415side_effect_free(T415*C,T0*a1);
/*EXTERNAL_FUNCTION*/T351 r415start_position(T415*C);
/*EXTERNAL_FUNCTION*/void r415obsolete_warning_check(T415*C,T0*a1,T351 a2);
extern T0*oBC32copy_name;
extern int fBC32copy_name;
/*EXTERNAL_FUNCTION*/T0*r415copy_name(void);
extern T0*oBC349obsolete_warning_check_memory;
extern int fBC349obsolete_warning_check_memory;
/*EXTERNAL_FUNCTION*/T0*r415obsolete_warning_check_memory(void);
/*EXTERNAL_FUNCTION*/T0*r415error_handler(void);
/*EXTERNAL_FUNCTION*/void r415pretty_print_routine_body(T415*C,T2 a1);
/*THREAD_POOL*/void r101simplify(T101*C,T0*a1);
extern T0*oBC101fn_routine;
extern int fBC101fn_routine;
/*THREAD_POOL*/T0*r101fn_routine(void);
/*THREAD_POOL*/T0*r101echo(void);
extern T0*oBC101fn_args;
extern int fBC101fn_args;
/*THREAD_POOL*/T0*r101fn_args(void);
/*THREAD_POOL*/T0*r101create_call(T0*a1,T351 a2);
/*THREAD_POOL*/T0*r101thread_routine(T351 a1);
/*THREAD_POOL*/void r101collect(T101*C,T0*a1,T351 a2);
extern T0*oBC101fn_thread;
extern int fBC101fn_thread;
/*THREAD_POOL*/T0*r101fn_thread(void);
/*THREAD_POOL*/T0*r101tuple_to_arguments(T0*a1,T351 a2);
extern T0*oBC101fn_item;
extern int fBC101fn_item;
/*THREAD_POOL*/T0*r101fn_item(void);
/*THREAD_POOL*/T0*r101thread_args(T351 a1);
/*THREAD_POOL*/T2 r101count(T101*C);
/*WRITABLE_ATTRIBUTE*/T0*r701specialized_ensure_thru(T701*C,T0*a1,T0*a2,T0*a3);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_signature_in(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/T0*r701try_to_undefine_aux(T701*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE*/void r701collect(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_require_thru(T701*C,T0*a1,T0*a2,T0*a3);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_permissions_thru(T701*C,T0*a1,T0*a2,T0*a3);
/*WRITABLE_ATTRIBUTE*/void r701with(T701*C,T0*a1,T0*a2,T2 a3);
/*WRITABLE_ATTRIBUTE*/T0*r701simplify(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/T0*r701arguments(void);
/*WRITABLE_ATTRIBUTE*/T0*r701specialized_require_thru(T701*C,T0*a1,T0*a2,T0*a3);
/*WRITABLE_ATTRIBUTE*/T0*r701first_name(T701*C);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_and_check(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/T0*r701names(T701*C);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_require_in(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/void r701add_into(T701*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE*/T0*r701merge_signature_thru(T701*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*WRITABLE_ATTRIBUTE*/void r701make(T701*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*WRITABLE_ATTRIBUTE*/T0*r701try_to_undefine(T701*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE*/void r701add_into_(T701*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE*/T0*r701new_run_feature_for(T701*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE*/void r701valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*WRITABLE_ATTRIBUTE*/T6 r701use_current(T0*a1);
/*WRITABLE_ATTRIBUTE*/void r701obsolete_warning_check(T701*C,T0*a1,T351 a2);
/*WRITABLE_ATTRIBUTE*/T0*r701change_ensure(T701*C,T0*a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/T0*r701brand_new_run_feature_for(T701*C,T0*a1,T0*a2,T6 a3);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_permissions_in(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/void r701pretty_print_names(T701*C);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_permissions(T701*C,T0*a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/void r701set_closure(T701*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE*/void r701pretty(T701*C,T2 a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/T6 r701same_body_as(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/void r701inline_dynamic_dispatch(T701*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_body_thru(T701*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*WRITABLE_ATTRIBUTE*/T6 r701same_signature(T701*C,T0*a1,T0*a2);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_signature_thru(T701*C,T0*a1,T0*a2,T0*a3);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_ensure_in(T701*C,T0*a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_ensure_thru(T701*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*WRITABLE_ATTRIBUTE*/T0*r701twin(T701*C);
/*WRITABLE_ATTRIBUTE*/T0*r701error_handler(void);
/*WRITABLE_ATTRIBUTE*/void r701accept(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/T0*r701inline_expression_0(T701*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*WRITABLE_ATTRIBUTE*/T6 r701valid_redefinition(T701*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*WRITABLE_ATTRIBUTE*/T0*r701change_require(T701*C,T0*a1,T6 a2);
/*WRITABLE_ATTRIBUTE*/T0*r701obsolete_warning_check_memory(void);
/*WRITABLE_ATTRIBUTE*/T351 r701start_position(T701*C);
/*WRITABLE_ATTRIBUTE*/void r701set_rescue_compound(T701*C,T0*a1);
/*WRITABLE_ATTRIBUTE*/T0*r701specialize_body_in(T701*C,T0*a1,T6 a2);
/*GRAPH_NODE*/void r543make(T543*C,T0*a1);
/*GRAPH_NODE*/T2 r543recompute_run_time_set(T543*C,T2 a1);
/*GRAPH_NODE*/void r543id_extra_information(T543*C,T0*a1);
/*GRAPH_NODE*/void r543reset(T543*C);
/*GRAPH_NODE*/void r543collect_way_to(T543*C,T0*a1);
/*GRAPH_NODE*/T2 r543destination_count(T543*C);
/*GRAPH_NODE*/T2 r543run_time_set_add(T543*C,T0*a1);
/*NON_VOID_NO_DISPATCH*/T547*create547make(T0*a1,T0*a2,T0*a3);
/*NON_VOID_NO_DISPATCH*/T0*r547specialize_and_check(T547*C,T0*a1);
/*NON_VOID_NO_DISPATCH*/T0*r547to_expression(T547*C);
/*NON_VOID_NO_DISPATCH*/void r547make(T547*C,T0*a1,T0*a2,T0*a3);
/*NON_VOID_NO_DISPATCH*/T0*r547simplify(T547*C,T0*a1);
/*NON_VOID_NO_DISPATCH*/T0*r547once_function(T547*C);
/*NON_VOID_NO_DISPATCH*/T0*r547static_simplify(T547*C);
/*NON_VOID_NO_DISPATCH*/T0*r547specialize_in(T547*C,T0*a1);
/*NON_VOID_NO_DISPATCH*/void r547inline_dynamic_dispatch_(T547*C,T0*a1,T0*a2);
/*NON_VOID_NO_DISPATCH*/T0*r547run_feature(T547*C);
/*NON_VOID_NO_DISPATCH*/T0*r547specialize_thru(T547*C,T0*a1,T0*a2,T0*a3);
/*NON_VOID_NO_DISPATCH*/T6 r547is_stored_in_some_local_variable(void);
/*NON_VOID_NO_DISPATCH*/void r547accept(T547*C,T0*a1);
/*NON_VOID_NO_DISPATCH*/T0*r547collect(T547*C,T0*a1);
/*NON_VOID_NO_DISPATCH*/T351 r547start_position(T547*C);
/*NON_VOID_NO_DISPATCH*/T0*r547twin(T547*C);
/*NON_VOID_NO_DISPATCH*/T0*r547written_declaration_type_mark(T547*C);
/*NON_VOID_NO_DISPATCH*/T6 r547use_current(T0*a1);
/*NON_VOID_NO_DISPATCH*/T0*r547non_void_no_dispatch_type(T547*C,T0*a1);
/*NON_VOID_NO_DISPATCH*/T6 r547side_effect_free(T0*a1);
/*NON_VOID_NO_DISPATCH*/T0*r547external_function(T547*C);
/*NON_VOID_NO_DISPATCH*/T0*r547resolve_in(T547*C,T0*a1);
/*NON_VOID_NO_DISPATCH*/T0*r547to_instruction(T547*C);
/*AGENT_ARGS*/T6 r581is_equal(T581*C,T0*a1);
/*AGENT_ARGS*/void r581make(T581*C,T0*a1,T0*a2);
/*AGENT_ARGS*/T2 r581hash_code(T581*C);
extern T0*oBC660implicit_any;
extern int fBC660implicit_any;
/*ANONYMOUS_FEATURE_MIXER*/T0*r660implicit_any(void);
/*ANONYMOUS_FEATURE_MIXER*/void r660make(T660*C,T0*a1);
/*ANONYMOUS_FEATURE_MIXER*/void r660error_handler_show_resulting_client_list(T0*a1);
/*ANONYMOUS_FEATURE_MIXER*/void r660remove_body(T660*C);
/*ANONYMOUS_FEATURE_MIXER*/void r660specialize_feature(T660*C,T0*a1);
/*ANONYMOUS_FEATURE_MIXER*/T0*r660build_precursor(T660*C,T0*a1,T0*a2);
/*ANONYMOUS_FEATURE_MIXER*/void r660set_body(T660*C,T0*a1,T0*a2,T0*a3);
/*ANONYMOUS_FEATURE_MIXER*/T0*r660closure_formal_arg_list(T660*C,T2 a1);
/*ANONYMOUS_FEATURE_MIXER*/void r660add_local_definition(T660*C,T0*a1);
/*ANONYMOUS_FEATURE_MIXER*/void r660error_handler_add_export_positions(T660*C,T0*a1);
/*ANONYMOUS_FEATURE_MIXER*/void r660add_inherited_definition(T660*C,T0*a1,T0*a2,T0*a3);
/*ANONYMOUS_FEATURE_MIXER*/T0*r660result_type(T660*C,T0*a1);
/*ANONYMOUS_FEATURE_MIXER*/T0*r660specialize_precursor(T660*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*ANONYMOUS_FEATURE_MIXER*/T0*r660formal_arg_list(T660*C);
/*ANONYMOUS_FEATURE_MIXER*/T0*r660error_handler(void);
/*ANONYMOUS_FEATURE_MIXER*/T0*r660export_status_for(T660*C,T0*a1,T0*a2);
/*ANONYMOUS_FEATURE_MIXER*/void r660specialize_signature(T660*C,T0*a1);
/*ABSOLUTE_FEATURE_NAME*/T6 r348is_equal(T348*C,T348 a1);
/*ABSOLUTE_FEATURE_NAME*/void r348make(T348*C,T0*a1,T0*a2);
/*ABSOLUTE_FEATURE_NAME*/T6 r348matches(T348*C,T0*a1,T0*a2);
/*ABSOLUTE_FEATURE_NAME*/T348 r348twin(T348*C);
/*BDW_ASSIGN_NATIVE_ARRAY*/void r842make(T842*C,T0*a1);
/*BDW_ASSIGN_NATIVE_ARRAY*/void r842visit_compound_expression(T842*C,T0*a1);
/*BDW_ASSIGN_NATIVE_ARRAY*/void r842visit_writable_attribute_name(T842*C,T0*a1);
/*BDW_ASSIGN_NATIVE_ARRAY*/void r842for(T842*C,T0*a1,T0*a2);
/*BDW_ASSIGN_NATIVE_ARRAY*/void r842visit_expression_with_comment(T842*C,T0*a1);
/*BDW_ASSIGN_NATIVE_ARRAY*/T0*r842cpp(void);
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/void r843set_tag(T0*a1,T0*a2);
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T0*r843get_tag(T0*a1);
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T0*r843is_enabled(T0*a1);
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T6 r843is_native_array_collector_enabled_(T0*a1);
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T0*r843must_collect(T0*a1);
extern T0*oBC32mark_native_arrays_name;
extern int fBC32mark_native_arrays_name;
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T0*r843mark_native_arrays_name(void);
extern T0*oBC843yes;
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/void r843collect(T0*a1);
extern T0*oBC843tag_key;
extern int fBC843tag_key;
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T0*r843tag_key(void);
extern T0*oBC843no;
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T0*r843error_handler(void);
extern T0*oBC32mark_item_name;
extern int fBC32mark_item_name;
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T0*r843mark_item_name(void);
/*LIVE_TYPE_NATIVE_ARRAY_COLLECTOR*/T6 r843is_native_array_collector_enabled(T0*a1);
/*BDW_GC_DEFINE2*/void r844make(T844*C,T0*a1,T0*a2);
/*BDW_GC_DEFINE2*/void r844visit_string_type_mark(T844*C,T0*a1);
extern int fBC844prepare_weakref_accessors;
/*BDW_GC_DEFINE2*/void r844prepare_weakref_accessors(void);
/*BDW_GC_DEFINE2*/void r844for(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/T6 r844finalize_reference(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/void r844mark_native_arrays(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/void r844put_alloc_function(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/void r844visit_user_generic_type_mark(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/void r844visit_agent_type_mark(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/T0*r844cpp(void);
/*BDW_GC_DEFINE2*/void r844extra_functions(T844*C);
/*BDW_GC_DEFINE2*/void r844prepare_alloc_inner_function(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/T0*r844capacity_name(void);
/*BDW_GC_DEFINE2*/void r844alloc_native_array(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/void r844alloc_weak_reference(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/void r844visit_array_type_mark(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/void r844visit_class_type_mark(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/void r844alloc_reference(T844*C,T0*a1);
/*BDW_GC_DEFINE2*/T6 r844is_na_collector(T844*C);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846make(T846*C);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846visit_like_feature_type_mark(T846*C,T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846visit_native_array_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846visit_like_current_type_mark(T846*C,T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846visit_like_argument_type_mark(T846*C,T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846visit_user_generic_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846gc_kernel_expanded(T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846visit_agent_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/T0*r846cpp(void);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846visit_formal_generic_type_mark(T846*C,T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846ltid_in(T0*a1,T0*a2,T6 a3,T6 a4);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846compile(T846*C,T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/T0*r846memory(void);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846gc_reference_(T0*a1,T6 a2);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846gc_reference(T0*a1);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846crash(T846*C);
/*C_GARBAGE_COLLECTOR_HEADER_COMPILER*/void r846visit_class_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848make(T848*C);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848visit_like_feature_type_mark(T848*C,T0*a1);
extern T0*oBC32from_pointer_name;
extern int fBC32from_pointer_name;
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/T0*r848from_pointer_name(void);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_reference_mark(T848*C,T0*a1,T0*a2,T6 a3);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848visit_native_array_type_mark(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_align_mark_fixed_size(T848*C,T0*a1,T6 a2);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848visit_like_current_type_mark(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848mark_attribute(T0*a1,T0*a2);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_reference_new(T0*a1,T0*a2,T6 a3);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_expanded(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848visit_like_argument_type_mark(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_weak_reference(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848visit_user_generic_type_mark(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_mark_fixed_size(T848*C,T0*a1,T6 a2);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_kernel_expanded(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848visit_agent_type_mark(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_set_fsoh_marked(T0*a1,T6 a2);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/T0*r848cpp(void);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848visit_formal_generic_type_mark(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848ltid_in(T0*a1,T0*a2,T6 a3,T6 a4);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_reference_sweep(T0*a1,T0*a2,T6 a3,T6 a4);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_reference_update_weak_ref_item(T0*a1,T0*a2);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848compile(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/T0*r848memory(void);
extern int fBC848generate_once_gc_update_weak_ref_item_polymorph;
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848generate_once_gc_update_weak_ref_item_polymorph(T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848native_array_type_in(T0*a1,T0*a2);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_reference(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/T6 r848insert_native_array_collector_flag(T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_mark_na(T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_reference_fsoc_model(T0*a1,T0*a2,T6 a3);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848crash(T848*C);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/T0*r848error_handler(void);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848visit_class_type_mark(T848*C,T0*a1);
/*C_GARBAGE_COLLECTOR_FUNCTIONS_COMPILER*/void r848gc_reference_align_mark(T848*C,T0*a1,T0*a2,T6 a3);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849visit_like_feature_type_mark(T849*C,T0*a1);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849visit_native_array_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849visit_like_current_type_mark(T849*C,T0*a1);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849visit_like_argument_type_mark(T849*C,T0*a1);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849visit_user_generic_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/T0*r849cpp(void);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849visit_formal_generic_type_mark(T849*C,T0*a1);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849ltid_in(T0*a1,T0*a2,T6 a3,T6 a4);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849compile(T849*C,T0*a1);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/T0*r849memory(void);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849gc_reference(T0*a1);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849crash(T849*C);
/*C_GARBAGE_COLLECTOR_INFO_COMPILER*/void r849visit_class_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850visit_like_feature_type_mark(T850*C,T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850visit_native_array_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850visit_like_current_type_mark(T850*C,T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850visit_like_argument_type_mark(T850*C,T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850visit_user_generic_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850visit_agent_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/T0*r850cpp(void);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850visit_formal_generic_type_mark(T850*C,T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850compile(T850*C,T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/T0*r850memory(void);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850gc_reference(T0*a1);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850crash(T850*C);
/*C_GARBAGE_COLLECTOR_BEFORE_MARK_COMPILER*/void r850visit_class_type_mark(T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_empty_tuple_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_string_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_like_feature_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/T6 r851for(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_native_array_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_like_current_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_weak_reference_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_like_argument_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_user_generic_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_any_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_agent_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_formal_generic_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851gc_mark_to_follow(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_array_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851crash(T851*C);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_class_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851need_gc_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_NEED_MARK*/void r851visit_non_empty_tuple_type_mark(T851*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAG*/T6 r845is_equal(T845*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAG*/void r845make(T845*C,T0*a1);
extern T0*oBC845id_provider;
/*C_GARBAGE_COLLECTOR_TAG*/T6 r845_ix_60(T845*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAG*/void r845increment(T845*C);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_empty_tuple_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852make(T852*C);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_string_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_like_feature_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_real_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/T0*r852for(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_native_array_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_natural_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_like_current_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_weak_reference_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_like_argument_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852fill_tag(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_user_generic_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_pointer_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_any_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_agent_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_character_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_formal_generic_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_client_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_boolean_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_array_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852crash(T852*C);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_integer_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_class_type_mark(T852*C,T0*a1);
/*C_GARBAGE_COLLECTOR_TAGGER*/void r852visit_non_empty_tuple_type_mark(T852*C,T0*a1);
/*CECIL_ENTRY*/void r583make(T583*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*CECIL_ENTRY*/T0*r583echo(void);
/*CECIL_ENTRY*/void r583on_echo(T583*C,T0*a1);
/*CECIL_ENTRY*/T0*r583run_feature(T583*C);
/*CECIL_ENTRY*/void r583get_started(T583*C,T0*a1);
/*CECIL_ENTRY*/T0*r583adapt_for(T583*C,T0*a1);
/*CECIL_ENTRY*/T0*r583default_create_name(void);
/*CECIL_ENTRY*/T0*r583collect(T583*C,T0*a1);
/*CECIL_ENTRY*/T0*r583any_default_create_fs(void);
/*CECIL_ENTRY*/T0*r583error_handler(void);
/*CECIL_ENTRY*/void r583inline_dynamic_dispatch(T583*C,T0*a1,T0*a2);
/*CECIL_ENTRY*/T0*r583anonymous_feature(T583*C);
/*CECIL_ENTRY*/T0*r583feature_stamp(T583*C);
/*STRING_RECYCLING_ITEM*/void r324copy(T324*C,T324 a1);
/*STRING_RECYCLING_ITEM*/void r324set_item(T324*C,T0*a1);
/*STRING_RECYCLING_ITEM*/T0*r324item(T324*C);
/*STRING_RECYCLING_ITEM*/T324 r324twin(T324*C);
/*STRING_RECYCLING_ITEM_SORTER*/T2 r747insert_index(T0*a1,T324 a2);
/*STRING_RECYCLING_ITEM_SORTER*/T6 r747lt(T324 a1,T324 a2);
/*STRING_RECYCLING_ITEM_SORTER*/T6 r747lte(T324 a1,T324 a2);
/*PROCESS_FACTORY*/void r542default_create(T542*C);
extern T0*oBC542default_group;
extern int fBC542default_group;
/*PROCESS_FACTORY*/T0*r542default_group(T542*C);
/*PROCESS_FACTORY*/T0*r542create_group(T542*C);
/*PROCESS_FACTORY*/void r542crash(T542*C);
/*PROCESS_FACTORY*/void r542not_yet_implemented(T542*C);
/*PROCESS_FACTORY*/T0*r542create_process(T542*C);
/*POSIX_PATH_NAME*/void r809remove_last(T809*C);
/*POSIX_PATH_NAME*/void r809make_empty(T809*C);
/*POSIX_PATH_NAME*/void r809start_join(T809*C,T0*a1,T2 a2);
/*POSIX_PATH_NAME*/void r809join_element(T809*C,T0*a1);
/*POSIX_PATH_NAME*/T2 r809start_join_to(T809*C,T0*a1);
/*POSIX_PATH_NAME*/T0*r809drive_specification(void);
/*POSIX_PATH_NAME*/void r809end_join(T809*C);
/*POSIX_PATH_NAME*/void r809make_from_string(T809*C,T0*a1);
/*POSIX_PATH_NAME*/T0*r809last(T809*C);
/*POSIX_PATH_NAME*/void r809add_last(T809*C,T0*a1);
/*POSIX_PATH_NAME*/T6 r809is_separator(T3 a1);
/*POSIX_PATH_NAME*/T6 r809is_absolute(T809*C);
/*POSIX_PATH_NAME*/void r809go_up(T809*C);
/*POSIX_PATH_NAME*/void r809make_current(T809*C);
/*POSIX_PATH_NAME*/T2 r809scan_element(T809*C,T2 a1,T0*a2);
/*POSIX_PATH_NAME*/T6 r809is_valid_path(T0*a1);
/*POSIX_PATH_NAME*/void r809join_to(T809*C,T0*a1);
/*POSIX_PATH_NAME*/void r809join(T809*C,T0*a1);
/*POSIX_PATH_NAME*/T0*r809short_name(T809*C);
/*POSIX_PATH_NAME*/void r809join_element_to(T0*a1,T0*a2);
/*POSIX_PATH_NAME*/void r809join_directory_to(T0*a1,T0*a2);
/*POSIX_PATH_NAME*/T2 r809count(T809*C);
/*POSIX_PATH_NAME*/void r809make_root(T809*C);
/*CST_ATT_CHARACTER*/T0*r699specialized_ensure_thru(T699*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_CHARACTER*/T0*r699try_to_undefine_aux(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/void r699collect(T699*C,T0*a1);
/*CST_ATT_CHARACTER*/T0*r699specialize_require_thru(T699*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_CHARACTER*/T0*r699specialize_permissions_thru(T699*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_CHARACTER*/T0*r699simplify(T699*C,T0*a1);
/*CST_ATT_CHARACTER*/T0*r699arguments(void);
/*CST_ATT_CHARACTER*/T0*r699specialized_require_thru(T699*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_CHARACTER*/T0*r699first_name(T699*C);
/*CST_ATT_CHARACTER*/T0*r699specialize_and_check(T699*C,T0*a1);
/*CST_ATT_CHARACTER*/void r699collect_body(T699*C,T0*a1);
/*CST_ATT_CHARACTER*/T0*r699names(T699*C);
/*CST_ATT_CHARACTER*/T0*r699specialize_require_in(T699*C,T0*a1);
/*CST_ATT_CHARACTER*/void r699add_into(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/T0*r699merge_signature_thru(T699*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*CST_ATT_CHARACTER*/void r699make(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/T0*r699try_to_undefine(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/void r699add_into_(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/T0*r699new_run_feature_for(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/void r699valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_CHARACTER*/T6 r699use_current(T0*a1);
/*CST_ATT_CHARACTER*/void r699obsolete_warning_check(T699*C,T0*a1,T351 a2);
/*CST_ATT_CHARACTER*/T0*r699change_ensure(T699*C,T0*a1,T6 a2);
/*CST_ATT_CHARACTER*/T0*r699brand_new_run_feature_for(T699*C,T0*a1,T0*a2,T6 a3);
/*CST_ATT_CHARACTER*/T0*r699specialize_permissions_in(T699*C,T0*a1);
/*CST_ATT_CHARACTER*/void r699pretty_print_names(T699*C);
/*CST_ATT_CHARACTER*/T0*r699specialize_permissions(T699*C,T0*a1,T6 a2);
/*CST_ATT_CHARACTER*/void r699set_closure(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/void r699pretty(T699*C,T2 a1,T6 a2);
/*CST_ATT_CHARACTER*/T6 r699same_body_as(T699*C,T0*a1);
/*CST_ATT_CHARACTER*/void r699inline_dynamic_dispatch(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/T6 r699same_signature(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/T0*r699specialize_signature_thru(T699*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_CHARACTER*/T0*r699specialize_ensure_in(T699*C,T0*a1,T6 a2);
/*CST_ATT_CHARACTER*/T0*r699specialize_ensure_thru(T699*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*CST_ATT_CHARACTER*/T0*r699twin(T699*C);
/*CST_ATT_CHARACTER*/void r699add_into_shared(T699*C,T0*a1,T0*a2);
/*CST_ATT_CHARACTER*/T0*r699error_handler(void);
/*CST_ATT_CHARACTER*/T0*r699inline_expression_0(T699*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*CST_ATT_CHARACTER*/T6 r699valid_redefinition(T699*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_CHARACTER*/T0*r699change_require(T699*C,T0*a1,T6 a2);
/*CST_ATT_CHARACTER*/T0*r699obsolete_warning_check_memory(void);
/*CST_ATT_CHARACTER*/T351 r699start_position(T699*C);
/*CST_ATT_CHARACTER*/void r699set_rescue_compound(T699*C,T0*a1);
/*CST_ATT_STRING*/T0*r696specialized_ensure_thru(T696*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_STRING*/T0*r696try_to_undefine_aux(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/void r696collect(T696*C,T0*a1);
/*CST_ATT_STRING*/T0*r696specialize_require_thru(T696*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_STRING*/T0*r696specialize_permissions_thru(T696*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_STRING*/void r696with(T696*C,T0*a1,T0*a2,T2 a3);
/*CST_ATT_STRING*/T0*r696simplify(T696*C,T0*a1);
/*CST_ATT_STRING*/T0*r696arguments(void);
/*CST_ATT_STRING*/T0*r696specialized_require_thru(T696*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_STRING*/T0*r696first_name(T696*C);
/*CST_ATT_STRING*/T0*r696specialize_and_check(T696*C,T0*a1);
/*CST_ATT_STRING*/void r696collect_body(T696*C,T0*a1);
/*CST_ATT_STRING*/T0*r696names(T696*C);
/*CST_ATT_STRING*/T0*r696specialize_require_in(T696*C,T0*a1);
/*CST_ATT_STRING*/void r696add_into(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/T0*r696merge_signature_thru(T696*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*CST_ATT_STRING*/void r696make(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/T0*r696try_to_undefine(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/void r696add_into_(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/T0*r696new_run_feature_for(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/void r696valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_STRING*/T6 r696use_current(T0*a1);
/*CST_ATT_STRING*/void r696obsolete_warning_check(T696*C,T0*a1,T351 a2);
/*CST_ATT_STRING*/T0*r696change_ensure(T696*C,T0*a1,T6 a2);
/*CST_ATT_STRING*/T0*r696brand_new_run_feature_for(T696*C,T0*a1,T0*a2,T6 a3);
/*CST_ATT_STRING*/T0*r696specialize_permissions_in(T696*C,T0*a1);
/*CST_ATT_STRING*/void r696pretty_print_names(T696*C);
/*CST_ATT_STRING*/T0*r696specialize_permissions(T696*C,T0*a1,T6 a2);
/*CST_ATT_STRING*/void r696set_closure(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/void r696pretty(T696*C,T2 a1,T6 a2);
/*CST_ATT_STRING*/T6 r696same_body_as(T696*C,T0*a1);
/*CST_ATT_STRING*/void r696inline_dynamic_dispatch(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/T6 r696same_signature(T696*C,T0*a1,T0*a2);
/*CST_ATT_STRING*/T0*r696specialize_signature_thru(T696*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_STRING*/T0*r696specialize_ensure_in(T696*C,T0*a1,T6 a2);
/*CST_ATT_STRING*/T0*r696specialize_ensure_thru(T696*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*CST_ATT_STRING*/T0*r696twin(T696*C);
/*CST_ATT_STRING*/T0*r696error_handler(void);
/*CST_ATT_STRING*/T0*r696inline_expression_0(T696*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*CST_ATT_STRING*/T6 r696valid_redefinition(T696*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_STRING*/T0*r696change_require(T696*C,T0*a1,T6 a2);
/*CST_ATT_STRING*/T0*r696obsolete_warning_check_memory(void);
/*CST_ATT_STRING*/T351 r696start_position(T696*C);
/*CST_ATT_STRING*/void r696set_rescue_compound(T696*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584specialized_ensure_thru(T584*C,T0*a1,T0*a2,T0*a3);
/*ONCE_FUNCTION*/T0*r584specialize_signature_in(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584try_to_undefine_aux(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/void r584collect(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584specialize_require_thru(T584*C,T0*a1,T0*a2,T0*a3);
/*ONCE_FUNCTION*/void r584pretty_index(T584*C,T2 a1,T0*a2);
/*ONCE_FUNCTION*/T0*r584specialize_permissions_thru(T584*C,T0*a1,T0*a2,T0*a3);
/*ONCE_FUNCTION*/T6 r584empty_body_side_effect_free_effective_routine(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584simplify(T584*C,T0*a1);
/*ONCE_FUNCTION*/void r584pretty_print_routine_body(T584*C,T2 a1);
extern T0*oBC584type_std_output;
extern int fBC584type_std_output;
/*ONCE_FUNCTION*/T0*r584type_std_output(void);
/*ONCE_FUNCTION*/T0*r584specialized_require_thru(T584*C,T0*a1,T0*a2,T0*a3);
/*ONCE_FUNCTION*/void r584pretty_print_rescue(T584*C,T2 a1);
extern T0*oBC32flush_name;
extern int fBC32flush_name;
/*ONCE_FUNCTION*/T0*r584flush_name(void);
/*ONCE_FUNCTION*/T0*r584specialize_closure_arguments_lists_in(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584first_name(T584*C);
/*ONCE_FUNCTION*/T0*r584specialize_and_check(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584rescue_compound_in(T584*C,T0*a1);
/*ONCE_FUNCTION*/void r584collect_body(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584names(T584*C);
/*ONCE_FUNCTION*/T0*r584specialize_require_in(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584remove_first_redundant_initialisation(T0*a1,T0*a2);
/*ONCE_FUNCTION*/void r584inline_dynamic_dispatch_(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/T6 r584no_rescue_no_local_expanded_in(T584*C,T0*a1);
/*ONCE_FUNCTION*/void r584add_into(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/void r584make_effective_routine(T584*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T6 a8);
/*ONCE_FUNCTION*/void r584make_routine(T584*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*ONCE_FUNCTION*/T0*r584merge_signature_thru(T584*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*ONCE_FUNCTION*/void r584make(T584*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T6 a9);
/*ONCE_FUNCTION*/T0*r584try_to_undefine(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/T0*r584specialize_closure_arguments_lists_thru(T584*C,T0*a1,T0*a2,T0*a3);
/*ONCE_FUNCTION*/void r584add_into_(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/T0*r584new_run_feature_for(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/void r584valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*ONCE_FUNCTION*/T6 r584use_current(T584*C,T0*a1);
/*ONCE_FUNCTION*/void r584obsolete_warning_check(T584*C,T0*a1,T351 a2);
/*ONCE_FUNCTION*/void r584init(T584*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*ONCE_FUNCTION*/T0*r584change_ensure(T584*C,T0*a1,T6 a2);
/*ONCE_FUNCTION*/T0*r584brand_new_run_feature_for(T584*C,T0*a1,T0*a2,T6 a3);
/*ONCE_FUNCTION*/void r584set_arguments(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/T0*r584specialize_permissions_in(T584*C,T0*a1);
/*ONCE_FUNCTION*/void r584pretty_print_once_or_do(T2 a1);
/*ONCE_FUNCTION*/void r584pretty_print_names(T584*C);
/*ONCE_FUNCTION*/T0*r584specialize_permissions(T584*C,T0*a1,T6 a2);
/*ONCE_FUNCTION*/void r584set_closure(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/void r584hook_collect(T584*C,T0*a1);
/*ONCE_FUNCTION*/void r584pretty(T584*C,T2 a1,T6 a2);
/*ONCE_FUNCTION*/T6 r584same_body_as(T584*C,T0*a1);
/*ONCE_FUNCTION*/void r584inline_dynamic_dispatch(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/T0*r584specialize_body_thru(T584*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*ONCE_FUNCTION*/T6 r584same_signature(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/T351 r584sedb_trace_before_exit(T584*C);
/*ONCE_FUNCTION*/T0*r584specialize_signature_thru(T584*C,T0*a1,T0*a2,T0*a3);
/*ONCE_FUNCTION*/T0*r584specialize_ensure_in(T584*C,T0*a1,T6 a2);
/*ONCE_FUNCTION*/T0*r584specialize_closure_local_var_lists_thru(T584*C,T0*a1,T0*a2,T0*a3);
/*ONCE_FUNCTION*/T0*r584specialize_ensure_thru(T584*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*ONCE_FUNCTION*/T0*r584twin(T584*C);
/*ONCE_FUNCTION*/void r584add_into_shared(T584*C,T0*a1,T0*a2);
/*ONCE_FUNCTION*/T0*r584error_handler(void);
/*ONCE_FUNCTION*/void r584accept(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584specialize_closure_local_var_lists_in(T584*C,T0*a1);
/*ONCE_FUNCTION*/T0*r584inline_expression_0(T584*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*ONCE_FUNCTION*/T6 r584valid_redefinition(T584*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*ONCE_FUNCTION*/T0*r584change_require(T584*C,T0*a1,T6 a2);
/*ONCE_FUNCTION*/T0*r584obsolete_warning_check_memory(void);
/*ONCE_FUNCTION*/T351 r584start_position(T584*C);
/*ONCE_FUNCTION*/T0*r584specialize_body_in(T584*C,T0*a1,T6 a2);
/*ONCE_FUNCTION*/T6 r584_P_349_same_body_as(T584*C,T0*a1);
/*CST_ATT_REAL*/T0*r700specialized_ensure_thru(T700*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_REAL*/T0*r700try_to_undefine_aux(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/void r700collect(T700*C,T0*a1);
/*CST_ATT_REAL*/T0*r700specialize_require_thru(T700*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_REAL*/T0*r700specialize_permissions_thru(T700*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_REAL*/T0*r700simplify(T700*C,T0*a1);
/*CST_ATT_REAL*/T0*r700arguments(void);
/*CST_ATT_REAL*/T0*r700specialized_require_thru(T700*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_REAL*/T0*r700first_name(T700*C);
/*CST_ATT_REAL*/T0*r700specialize_and_check(T700*C,T0*a1);
/*CST_ATT_REAL*/void r700collect_body(T700*C,T0*a1);
/*CST_ATT_REAL*/T0*r700names(T700*C);
/*CST_ATT_REAL*/T0*r700specialize_require_in(T700*C,T0*a1);
/*CST_ATT_REAL*/void r700add_into(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/T0*r700merge_signature_thru(T700*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*CST_ATT_REAL*/void r700make(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/T0*r700try_to_undefine(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/void r700add_into_(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/T0*r700new_run_feature_for(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/void r700valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_REAL*/T6 r700use_current(T0*a1);
/*CST_ATT_REAL*/void r700obsolete_warning_check(T700*C,T0*a1,T351 a2);
/*CST_ATT_REAL*/T0*r700change_ensure(T700*C,T0*a1,T6 a2);
/*CST_ATT_REAL*/T0*r700brand_new_run_feature_for(T700*C,T0*a1,T0*a2,T6 a3);
/*CST_ATT_REAL*/T0*r700specialize_permissions_in(T700*C,T0*a1);
/*CST_ATT_REAL*/void r700pretty_print_names(T700*C);
/*CST_ATT_REAL*/T0*r700specialize_permissions(T700*C,T0*a1,T6 a2);
/*CST_ATT_REAL*/void r700set_closure(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/void r700pretty(T700*C,T2 a1,T6 a2);
/*CST_ATT_REAL*/T6 r700same_body_as(T700*C,T0*a1);
/*CST_ATT_REAL*/void r700inline_dynamic_dispatch(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/T6 r700same_signature(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/T0*r700specialize_signature_thru(T700*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_REAL*/T0*r700specialize_ensure_in(T700*C,T0*a1,T6 a2);
/*CST_ATT_REAL*/T0*r700specialize_ensure_thru(T700*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*CST_ATT_REAL*/T0*r700twin(T700*C);
/*CST_ATT_REAL*/void r700add_into_shared(T700*C,T0*a1,T0*a2);
/*CST_ATT_REAL*/T0*r700error_handler(void);
/*CST_ATT_REAL*/T0*r700inline_expression_0(T700*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*CST_ATT_REAL*/T6 r700valid_redefinition(T700*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_REAL*/T0*r700change_require(T700*C,T0*a1,T6 a2);
/*CST_ATT_REAL*/T0*r700obsolete_warning_check_memory(void);
/*CST_ATT_REAL*/T351 r700start_position(T700*C);
/*CST_ATT_REAL*/void r700set_rescue_compound(T700*C,T0*a1);
/*CST_ATT_BOOLEAN*/T0*r693specialized_ensure_thru(T693*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_BOOLEAN*/T0*r693try_to_undefine_aux(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/void r693collect(T693*C,T0*a1);
/*CST_ATT_BOOLEAN*/T0*r693specialize_require_thru(T693*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_BOOLEAN*/void r693pretty_constant_value(T693*C,T2 a1);
/*CST_ATT_BOOLEAN*/T0*r693specialize_permissions_thru(T693*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_BOOLEAN*/T0*r693simplify(T693*C,T0*a1);
/*CST_ATT_BOOLEAN*/T0*r693arguments(void);
/*CST_ATT_BOOLEAN*/T0*r693specialized_require_thru(T693*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_BOOLEAN*/T0*r693first_name(T693*C);
/*CST_ATT_BOOLEAN*/T0*r693specialize_and_check(T693*C,T0*a1);
/*CST_ATT_BOOLEAN*/void r693collect_body(T693*C,T0*a1);
/*CST_ATT_BOOLEAN*/T0*r693names(T693*C);
/*CST_ATT_BOOLEAN*/T0*r693specialize_require_in(T693*C,T0*a1);
/*CST_ATT_BOOLEAN*/void r693add_into(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/T0*r693merge_signature_thru(T693*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*CST_ATT_BOOLEAN*/void r693make(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/T0*r693try_to_undefine(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/void r693add_into_(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/T0*r693new_run_feature_for(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/void r693valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_BOOLEAN*/T6 r693use_current(T0*a1);
/*CST_ATT_BOOLEAN*/void r693obsolete_warning_check(T693*C,T0*a1,T351 a2);
/*CST_ATT_BOOLEAN*/T0*r693change_ensure(T693*C,T0*a1,T6 a2);
/*CST_ATT_BOOLEAN*/T0*r693brand_new_run_feature_for(T693*C,T0*a1,T0*a2,T6 a3);
/*CST_ATT_BOOLEAN*/T0*r693specialize_permissions_in(T693*C,T0*a1);
/*CST_ATT_BOOLEAN*/void r693pretty_print_names(T693*C);
/*CST_ATT_BOOLEAN*/T0*r693specialize_permissions(T693*C,T0*a1,T6 a2);
/*CST_ATT_BOOLEAN*/void r693set_closure(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/void r693pretty(T693*C,T2 a1,T6 a2);
/*CST_ATT_BOOLEAN*/T6 r693same_body_as(T693*C,T0*a1);
/*CST_ATT_BOOLEAN*/void r693inline_dynamic_dispatch(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/T6 r693same_signature(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/T0*r693specialize_signature_thru(T693*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_BOOLEAN*/T0*r693specialize_ensure_in(T693*C,T0*a1,T6 a2);
/*CST_ATT_BOOLEAN*/T0*r693specialize_ensure_thru(T693*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*CST_ATT_BOOLEAN*/T0*r693twin(T693*C);
/*CST_ATT_BOOLEAN*/void r693add_into_shared(T693*C,T0*a1,T0*a2);
/*CST_ATT_BOOLEAN*/T0*r693error_handler(void);
/*CST_ATT_BOOLEAN*/T0*r693inline_expression_0(T693*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*CST_ATT_BOOLEAN*/T6 r693valid_redefinition(T693*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_BOOLEAN*/T0*r693change_require(T693*C,T0*a1,T6 a2);
/*CST_ATT_BOOLEAN*/T0*r693obsolete_warning_check_memory(void);
/*CST_ATT_BOOLEAN*/T351 r693start_position(T693*C);
/*CST_ATT_BOOLEAN*/void r693set_rescue_compound(T693*C,T0*a1);
/*DEFERRED_FUNCTION*/T0*r686specialized_ensure_thru(T686*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_FUNCTION*/T0*r686specialize_signature_in(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/T0*r686try_to_undefine_aux(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/void r686collect(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/T0*r686specialize_require_thru(T686*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_FUNCTION*/void r686from_effective(T686*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7);
/*DEFERRED_FUNCTION*/void r686pretty_index(T686*C,T2 a1,T0*a2);
/*DEFERRED_FUNCTION*/T0*r686specialize_permissions_thru(T686*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_FUNCTION*/T0*r686simplify(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/void r686pretty_print_routine_body(T686*C,T2 a1);
/*DEFERRED_FUNCTION*/T0*r686specialized_require_thru(T686*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_FUNCTION*/T0*r686specialize_closure_arguments_lists_in(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/T0*r686first_name(T686*C);
/*DEFERRED_FUNCTION*/T0*r686specialize_and_check(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/T0*r686names(T686*C);
/*DEFERRED_FUNCTION*/T0*r686specialize_require_in(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/void r686add_into(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/void r686make_routine(T686*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*DEFERRED_FUNCTION*/T0*r686merge_signature_thru(T686*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*DEFERRED_FUNCTION*/T0*r686try_to_undefine(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/void r686make(T686*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*DEFERRED_FUNCTION*/T0*r686specialize_closure_arguments_lists_thru(T686*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_FUNCTION*/void r686add_into_(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/T0*r686new_run_feature_for(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/void r686valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*DEFERRED_FUNCTION*/T6 r686use_current(T0*a1);
/*DEFERRED_FUNCTION*/void r686obsolete_warning_check(T686*C,T0*a1,T351 a2);
/*DEFERRED_FUNCTION*/T0*r686change_ensure(T686*C,T0*a1,T6 a2);
/*DEFERRED_FUNCTION*/T0*r686brand_new_run_feature_for(T686*C,T0*a1,T0*a2,T6 a3);
/*DEFERRED_FUNCTION*/void r686set_arguments(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/T0*r686specialize_permissions_in(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/void r686pretty_print_names(T686*C);
/*DEFERRED_FUNCTION*/T0*r686specialize_permissions(T686*C,T0*a1,T6 a2);
/*DEFERRED_FUNCTION*/void r686set_closure(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/void r686pretty(T686*C,T2 a1,T6 a2);
/*DEFERRED_FUNCTION*/T6 r686same_body_as(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/void r686inline_dynamic_dispatch(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/T6 r686same_signature(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/T0*r686specialize_signature_thru(T686*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_FUNCTION*/T0*r686specialize_ensure_in(T686*C,T0*a1,T6 a2);
/*DEFERRED_FUNCTION*/T0*r686specialize_ensure_thru(T686*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*DEFERRED_FUNCTION*/T0*r686twin(T686*C);
/*DEFERRED_FUNCTION*/void r686add_into_shared(T686*C,T0*a1,T0*a2);
/*DEFERRED_FUNCTION*/T0*r686error_handler(void);
/*DEFERRED_FUNCTION*/void r686accept(T686*C,T0*a1);
/*DEFERRED_FUNCTION*/T6 r686valid_redefinition(T686*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*DEFERRED_FUNCTION*/T0*r686change_require(T686*C,T0*a1,T6 a2);
/*DEFERRED_FUNCTION*/T0*r686obsolete_warning_check_memory(void);
/*DEFERRED_FUNCTION*/T351 r686start_position(T686*C);
/*DEFERRED_FUNCTION*/void r686set_rescue_compound(T686*C,T0*a1);
/*EXTERNAL_PROCEDURE*/void r689add_into_shared(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_closure_local_var_lists_thru(T689*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_PROCEDURE*/void r689inline_dynamic_dispatch(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_signature_in(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_require_thru(T689*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_permissions(T689*C,T0*a1,T6 a2);
/*EXTERNAL_PROCEDURE*/T0*r689c_plus_plus_name(T689*C);
/*EXTERNAL_PROCEDURE*/T0*r689collect_slice_copy(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_permissions_in(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689specialized_ensure_thru(T689*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_PROCEDURE*/void r689set_closure(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T0*r689external_name(T689*C);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_ensure_thru(T689*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*EXTERNAL_PROCEDURE*/T0*r689specialized_require_thru(T689*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_PROCEDURE*/T0*r689try_to_undefine_aux(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/void r689make_external_routine(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_body_thru(T689*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_body_in(T689*C,T0*a1,T6 a2);
/*EXTERNAL_PROCEDURE*/void r689set_rescue_compound(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_closure_local_var_lists_in(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689simplify(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_ensure_in(T689*C,T0*a1,T6 a2);
/*EXTERNAL_PROCEDURE*/T0*r689first_name(T689*C);
/*EXTERNAL_PROCEDURE*/void r689pretty_print_names(T689*C);
/*EXTERNAL_PROCEDURE*/void r689add_into(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T6 r689same_signature(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T0*r689brand_new_run_feature_for(T689*C,T0*a1,T0*a2,T6 a3);
/*EXTERNAL_PROCEDURE*/void r689accept(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689try_to_undefine(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/void r689hook_collect(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/void r689init(T689*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5,T0*a6,T0*a7);
/*EXTERNAL_PROCEDURE*/void r689inline_dynamic_dispatch_(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T0*r689change_ensure(T689*C,T0*a1,T6 a2);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_closure_arguments_lists_in(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689names(T689*C);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_and_check(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689current_or_twin_init(T689*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5,T0*a6,T0*a7,T6 a8);
/*EXTERNAL_PROCEDURE*/T0*r689merge_signature_thru(T689*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*EXTERNAL_PROCEDURE*/void r689make_routine(T689*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*EXTERNAL_PROCEDURE*/void r689collect(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_permissions_thru(T689*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_PROCEDURE*/T0*r689twin(T689*C);
/*EXTERNAL_PROCEDURE*/T6 r689use_current(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T0*r689result_type(void);
/*EXTERNAL_PROCEDURE*/T0*r689adapt_routine_body_for(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/void r689pretty(T689*C,T2 a1,T6 a2);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_signature_thru(T689*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_PROCEDURE*/T0*r689new_run_feature_for(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/void r689pretty_index(T689*C,T2 a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T6 r689valid_redefinition(T689*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_closure_arguments_lists_thru(T689*C,T0*a1,T0*a2,T0*a3);
/*EXTERNAL_PROCEDURE*/T0*r689current_or_twin_init_no_body(T689*C,T0*a1,T0*a2,T0*a3,T6 a4,T0*a5,T0*a6,T6 a7);
/*EXTERNAL_PROCEDURE*/T0*r689specialize_require_in(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/void r689add_into_(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/void r689set_arguments(T689*C,T0*a1,T0*a2);
/*EXTERNAL_PROCEDURE*/T0*r689eiffel_parser(void);
/*EXTERNAL_PROCEDURE*/void r689collect_body(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/void r689valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*EXTERNAL_PROCEDURE*/T0*r689change_require(T689*C,T0*a1,T6 a2);
/*EXTERNAL_PROCEDURE*/T2 r689argument_rank_of(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/T6 r689same_body_as(T689*C,T0*a1);
/*EXTERNAL_PROCEDURE*/void r689make(T689*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*EXTERNAL_PROCEDURE*/T351 r689start_position(T689*C);
/*EXTERNAL_PROCEDURE*/void r689obsolete_warning_check(T689*C,T0*a1,T351 a2);
/*EXTERNAL_PROCEDURE*/T0*r689obsolete_warning_check_memory(void);
/*EXTERNAL_PROCEDURE*/T0*r689error_handler(void);
/*EXTERNAL_PROCEDURE*/void r689pretty_print_routine_body(T689*C,T2 a1);
/*E_PROCEDURE*/T0*r691specialized_ensure_thru(T691*C,T0*a1,T0*a2,T0*a3);
/*E_PROCEDURE*/T0*r691specialize_signature_in(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691inline_instruction_n(T691*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*E_PROCEDURE*/T0*r691try_to_undefine_aux(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T0*r691inline_proc_call_1(T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*E_PROCEDURE*/T0*r691inline_proc_call_0(T0*a1,T0*a2,T0*a3,T0*a4);
/*E_PROCEDURE*/void r691collect(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691specialize_require_thru(T691*C,T0*a1,T0*a2,T0*a3);
/*E_PROCEDURE*/void r691pretty_index(T691*C,T2 a1,T0*a2);
/*E_PROCEDURE*/T0*r691specialize_permissions_thru(T691*C,T0*a1,T0*a2,T0*a3);
/*E_PROCEDURE*/T6 r691empty_body_side_effect_free_effective_routine(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691simplify(T691*C,T0*a1);
/*E_PROCEDURE*/void r691pretty_print_routine_body(T691*C,T2 a1);
/*E_PROCEDURE*/T0*r691specialized_require_thru(T691*C,T0*a1,T0*a2,T0*a3);
/*E_PROCEDURE*/void r691pretty_print_rescue(T691*C,T2 a1);
/*E_PROCEDURE*/T0*r691specialize_closure_arguments_lists_in(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691first_name(T691*C);
/*E_PROCEDURE*/T0*r691specialize_and_check(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691inline_instruction_1(T691*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*E_PROCEDURE*/T0*r691inline_instruction_0(T691*C,T0*a1,T0*a2,T0*a3);
/*E_PROCEDURE*/T0*r691rescue_compound_in(T691*C,T0*a1);
/*E_PROCEDURE*/void r691collect_body(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691names(T691*C);
/*E_PROCEDURE*/T0*r691specialize_require_in(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691remove_first_redundant_initialisation(T0*a1,T0*a2);
/*E_PROCEDURE*/void r691inline_dynamic_dispatch_(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T6 r691no_rescue_no_local_expanded_in(T691*C,T0*a1);
/*E_PROCEDURE*/void r691add_into(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/void r691make_routine(T691*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*E_PROCEDURE*/T0*r691merge_signature_thru(T691*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*E_PROCEDURE*/void r691make(T691*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T6 a8);
/*E_PROCEDURE*/T0*r691try_to_undefine(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T0*r691specialize_closure_arguments_lists_thru(T691*C,T0*a1,T0*a2,T0*a3);
/*E_PROCEDURE*/void r691add_into_(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T0*r691new_run_feature_for(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T0*r691result_type(void);
/*E_PROCEDURE*/void r691valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*E_PROCEDURE*/T6 r691use_current(T691*C,T0*a1);
/*E_PROCEDURE*/void r691obsolete_warning_check(T691*C,T0*a1,T351 a2);
/*E_PROCEDURE*/void r691init(T691*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*E_PROCEDURE*/T0*r691change_ensure(T691*C,T0*a1,T6 a2);
/*E_PROCEDURE*/T0*r691brand_new_run_feature_for(T691*C,T0*a1,T0*a2,T6 a3);
/*E_PROCEDURE*/void r691set_arguments(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T0*r691specialize_permissions_in(T691*C,T0*a1);
/*E_PROCEDURE*/void r691pretty_print_once_or_do(T2 a1);
/*E_PROCEDURE*/void r691pretty_print_names(T691*C);
/*E_PROCEDURE*/T0*r691specialize_permissions(T691*C,T0*a1,T6 a2);
/*E_PROCEDURE*/T0*r691left_most_current_direct_call_0_sequence_inline(T0*a1,T0*a2,T0*a3,T0*a4);
/*E_PROCEDURE*/void r691set_closure(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/void r691pretty(T691*C,T2 a1,T6 a2);
/*E_PROCEDURE*/T6 r691same_body_as(T691*C,T0*a1);
/*E_PROCEDURE*/void r691inline_dynamic_dispatch(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T0*r691specialize_body_thru(T691*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*E_PROCEDURE*/T0*r691inline_proc_call_n(T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*E_PROCEDURE*/T6 r691same_signature(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T351 r691sedb_trace_before_exit(T691*C);
/*E_PROCEDURE*/T0*r691specialize_signature_thru(T691*C,T0*a1,T0*a2,T0*a3);
/*E_PROCEDURE*/T0*r691specialize_ensure_in(T691*C,T0*a1,T6 a2);
/*E_PROCEDURE*/T0*r691specialize_closure_local_var_lists_thru(T691*C,T0*a1,T0*a2,T0*a3);
/*E_PROCEDURE*/T0*r691specialize_ensure_thru(T691*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*E_PROCEDURE*/T0*r691twin(T691*C);
/*E_PROCEDURE*/void r691add_into_shared(T691*C,T0*a1,T0*a2);
/*E_PROCEDURE*/T0*r691error_handler(void);
/*E_PROCEDURE*/void r691accept(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691specialize_closure_local_var_lists_in(T691*C,T0*a1);
/*E_PROCEDURE*/T0*r691left_most_current_direct_call_0_sequence(T0*a1,T0*a2);
/*E_PROCEDURE*/T6 r691valid_redefinition(T691*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*E_PROCEDURE*/T0*r691change_require(T691*C,T0*a1,T6 a2);
/*E_PROCEDURE*/T0*r691obsolete_warning_check_memory(void);
/*E_PROCEDURE*/T351 r691start_position(T691*C);
/*E_PROCEDURE*/T0*r691specialize_body_in(T691*C,T0*a1,T6 a2);
/*E_PROCEDURE*/T6 r691_P_349_same_body_as(T691*C,T0*a1);
/*CST_ATT_INTEGER*/T0*r698specialized_ensure_thru(T698*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_INTEGER*/T0*r698try_to_undefine_aux(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/void r698collect(T698*C,T0*a1);
/*CST_ATT_INTEGER*/T0*r698specialize_require_thru(T698*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_INTEGER*/T0*r698specialize_permissions_thru(T698*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_INTEGER*/T0*r698simplify(T698*C,T0*a1);
/*CST_ATT_INTEGER*/T0*r698arguments(void);
/*CST_ATT_INTEGER*/T0*r698specialized_require_thru(T698*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_INTEGER*/T0*r698first_name(T698*C);
/*CST_ATT_INTEGER*/T0*r698specialize_and_check(T698*C,T0*a1);
/*CST_ATT_INTEGER*/void r698collect_body(T698*C,T0*a1);
/*CST_ATT_INTEGER*/T0*r698names(T698*C);
/*CST_ATT_INTEGER*/T0*r698specialize_require_in(T698*C,T0*a1);
/*CST_ATT_INTEGER*/void r698add_into(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/T0*r698merge_signature_thru(T698*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*CST_ATT_INTEGER*/void r698make(T698*C,T0*a1);
/*CST_ATT_INTEGER*/T0*r698try_to_undefine(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/void r698add_into_(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/T0*r698new_run_feature_for(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/void r698valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_INTEGER*/T6 r698use_current(T0*a1);
/*CST_ATT_INTEGER*/void r698obsolete_warning_check(T698*C,T0*a1,T351 a2);
/*CST_ATT_INTEGER*/T0*r698change_ensure(T698*C,T0*a1,T6 a2);
/*CST_ATT_INTEGER*/T0*r698brand_new_run_feature_for(T698*C,T0*a1,T0*a2,T6 a3);
/*CST_ATT_INTEGER*/T0*r698specialize_permissions_in(T698*C,T0*a1);
/*CST_ATT_INTEGER*/void r698pretty_print_names(T698*C);
/*CST_ATT_INTEGER*/T0*r698specialize_permissions(T698*C,T0*a1,T6 a2);
/*CST_ATT_INTEGER*/void r698set_closure(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/void r698pretty(T698*C,T2 a1,T6 a2);
/*CST_ATT_INTEGER*/T6 r698same_body_as(T698*C,T0*a1);
/*CST_ATT_INTEGER*/void r698inline_dynamic_dispatch(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/T6 r698same_signature(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/T0*r698specialize_signature_thru(T698*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_INTEGER*/T0*r698specialize_ensure_in(T698*C,T0*a1,T6 a2);
/*CST_ATT_INTEGER*/T0*r698specialize_ensure_thru(T698*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*CST_ATT_INTEGER*/T0*r698twin(T698*C);
/*CST_ATT_INTEGER*/void r698add_into_shared(T698*C,T0*a1,T0*a2);
/*CST_ATT_INTEGER*/T0*r698error_handler(void);
/*CST_ATT_INTEGER*/T0*r698inline_expression_0(T698*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*CST_ATT_INTEGER*/T6 r698valid_redefinition(T698*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_INTEGER*/T0*r698change_require(T698*C,T0*a1,T6 a2);
/*CST_ATT_INTEGER*/T0*r698obsolete_warning_check_memory(void);
/*CST_ATT_INTEGER*/T351 r698start_position(T698*C);
/*CST_ATT_INTEGER*/void r698set_rescue_compound(T698*C,T0*a1);
/*E_FUNCTION*/T0*r692specialized_ensure_thru(T692*C,T0*a1,T0*a2,T0*a3);
/*E_FUNCTION*/T0*r692specialize_signature_in(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692try_to_undefine_aux(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/void r692collect(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692specialize_require_thru(T692*C,T0*a1,T0*a2,T0*a3);
/*E_FUNCTION*/void r692pretty_index(T692*C,T2 a1,T0*a2);
/*E_FUNCTION*/T0*r692specialize_permissions_thru(T692*C,T0*a1,T0*a2,T0*a3);
/*E_FUNCTION*/T6 r692empty_body_side_effect_free_effective_routine(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692inline_eq_neq1(T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*E_FUNCTION*/T0*r692inline_eq_neq0(T0*a1,T0*a2,T0*a3,T0*a4);
/*E_FUNCTION*/T0*r692simplify(T692*C,T0*a1);
/*E_FUNCTION*/void r692pretty_print_routine_body(T692*C,T2 a1);
/*E_FUNCTION*/T0*r692inline_assign_to_result_1(T692*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T6 a7,T6 a8);
/*E_FUNCTION*/T0*r692specialized_require_thru(T692*C,T0*a1,T0*a2,T0*a3);
/*E_FUNCTION*/void r692pretty_print_rescue(T692*C,T2 a1);
/*E_FUNCTION*/T0*r692specialize_closure_arguments_lists_in(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692first_name(T692*C);
/*E_FUNCTION*/T0*r692specialize_and_check(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692rescue_compound_in(T692*C,T0*a1);
/*E_FUNCTION*/void r692collect_body(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692names(T692*C);
/*E_FUNCTION*/T0*r692specialize_require_in(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692remove_first_redundant_initialisation(T0*a1,T0*a2);
/*E_FUNCTION*/void r692inline_dynamic_dispatch_(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/T6 r692no_rescue_no_local_expanded_in(T692*C,T0*a1);
/*E_FUNCTION*/void r692add_into(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/void r692make_effective_routine(T692*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T6 a8);
/*E_FUNCTION*/T0*r692inline_call_1(T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*E_FUNCTION*/void r692make_routine(T692*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*E_FUNCTION*/T0*r692merge_signature_thru(T692*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*E_FUNCTION*/void r692make(T692*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T0*a8,T6 a9);
/*E_FUNCTION*/T0*r692try_to_undefine(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/T0*r692specialize_closure_arguments_lists_thru(T692*C,T0*a1,T0*a2,T0*a3);
/*E_FUNCTION*/void r692add_into_(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/T0*r692new_run_feature_for(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/T0*r692inline_eq_neq0_(T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*E_FUNCTION*/void r692valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*E_FUNCTION*/T6 r692use_current(T692*C,T0*a1);
/*E_FUNCTION*/void r692obsolete_warning_check(T692*C,T0*a1,T351 a2);
/*E_FUNCTION*/void r692init(T692*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*E_FUNCTION*/T0*r692inline_expression_n(T692*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*E_FUNCTION*/T0*r692change_ensure(T692*C,T0*a1,T6 a2);
/*E_FUNCTION*/T0*r692brand_new_run_feature_for(T692*C,T0*a1,T0*a2,T6 a3);
/*E_FUNCTION*/void r692set_arguments(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/T0*r692specialize_permissions_in(T692*C,T0*a1);
/*E_FUNCTION*/void r692pretty_print_once_or_do(T2 a1);
/*E_FUNCTION*/void r692pretty_print_names(T692*C);
/*E_FUNCTION*/T0*r692specialize_permissions(T692*C,T0*a1,T6 a2);
/*E_FUNCTION*/T0*r692left_most_current_direct_call_0_sequence_inline(T0*a1,T0*a2,T0*a3,T0*a4);
/*E_FUNCTION*/void r692set_closure(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/void r692pretty(T692*C,T2 a1,T6 a2);
/*E_FUNCTION*/T6 r692same_body_as(T692*C,T0*a1);
/*E_FUNCTION*/void r692inline_dynamic_dispatch(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/T0*r692specialize_body_thru(T692*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*E_FUNCTION*/T6 r692same_signature(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/T351 r692sedb_trace_before_exit(T692*C);
/*E_FUNCTION*/T0*r692specialize_signature_thru(T692*C,T0*a1,T0*a2,T0*a3);
/*E_FUNCTION*/T0*r692specialize_ensure_in(T692*C,T0*a1,T6 a2);
/*E_FUNCTION*/T0*r692specialize_closure_local_var_lists_thru(T692*C,T0*a1,T0*a2,T0*a3);
/*E_FUNCTION*/T0*r692specialize_ensure_thru(T692*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*E_FUNCTION*/T0*r692twin(T692*C);
/*E_FUNCTION*/void r692add_into_shared(T692*C,T0*a1,T0*a2);
/*E_FUNCTION*/T0*r692error_handler(void);
/*E_FUNCTION*/void r692accept(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692specialize_closure_local_var_lists_in(T692*C,T0*a1);
/*E_FUNCTION*/T0*r692inline_expression_1(T692*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6,T0*a7);
/*E_FUNCTION*/T0*r692inline_expression_0(T692*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*E_FUNCTION*/T0*r692left_most_current_direct_call_0_sequence(T0*a1,T0*a2);
/*E_FUNCTION*/T6 r692valid_redefinition(T692*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*E_FUNCTION*/T0*r692change_require(T692*C,T0*a1,T6 a2);
/*E_FUNCTION*/T0*r692inline_assign_to_result_n(T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T6 a7,T6 a8);
/*E_FUNCTION*/T0*r692obsolete_warning_check_memory(void);
/*E_FUNCTION*/T351 r692start_position(T692*C);
/*E_FUNCTION*/T0*r692specialize_body_in(T692*C,T0*a1,T6 a2);
/*E_FUNCTION*/T6 r692_P_349_same_body_as(T692*C,T0*a1);
/*DEFERRED_PROCEDURE*/T0*r688specialized_ensure_thru(T688*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_PROCEDURE*/T0*r688specialize_signature_in(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/T0*r688try_to_undefine_aux(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/void r688collect(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/T0*r688specialize_require_thru(T688*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_PROCEDURE*/void r688from_effective(T688*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*DEFERRED_PROCEDURE*/void r688pretty_index(T688*C,T2 a1,T0*a2);
/*DEFERRED_PROCEDURE*/T0*r688specialize_permissions_thru(T688*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_PROCEDURE*/T0*r688simplify(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/void r688pretty_print_routine_body(T688*C,T2 a1);
/*DEFERRED_PROCEDURE*/T0*r688specialized_require_thru(T688*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_PROCEDURE*/T0*r688specialize_closure_arguments_lists_in(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/T0*r688first_name(T688*C);
/*DEFERRED_PROCEDURE*/T0*r688specialize_and_check(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/T0*r688names(T688*C);
/*DEFERRED_PROCEDURE*/T0*r688specialize_require_in(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/void r688add_into(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/void r688make_routine(T688*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*DEFERRED_PROCEDURE*/T0*r688merge_signature_thru(T688*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*DEFERRED_PROCEDURE*/void r688make(T688*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*DEFERRED_PROCEDURE*/T0*r688try_to_undefine(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/T0*r688specialize_closure_arguments_lists_thru(T688*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_PROCEDURE*/void r688add_into_(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/T0*r688new_run_feature_for(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/T0*r688result_type(void);
/*DEFERRED_PROCEDURE*/void r688valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*DEFERRED_PROCEDURE*/T6 r688use_current(T0*a1);
/*DEFERRED_PROCEDURE*/void r688obsolete_warning_check(T688*C,T0*a1,T351 a2);
/*DEFERRED_PROCEDURE*/T0*r688change_ensure(T688*C,T0*a1,T6 a2);
/*DEFERRED_PROCEDURE*/T0*r688brand_new_run_feature_for(T688*C,T0*a1,T0*a2,T6 a3);
/*DEFERRED_PROCEDURE*/void r688set_arguments(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/T0*r688specialize_permissions_in(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/void r688pretty_print_names(T688*C);
/*DEFERRED_PROCEDURE*/T0*r688specialize_permissions(T688*C,T0*a1,T6 a2);
/*DEFERRED_PROCEDURE*/void r688set_closure(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/void r688pretty(T688*C,T2 a1,T6 a2);
/*DEFERRED_PROCEDURE*/T6 r688same_body_as(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/void r688inline_dynamic_dispatch(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/T6 r688same_signature(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/T0*r688specialize_signature_thru(T688*C,T0*a1,T0*a2,T0*a3);
/*DEFERRED_PROCEDURE*/T0*r688specialize_ensure_in(T688*C,T0*a1,T6 a2);
/*DEFERRED_PROCEDURE*/T0*r688specialize_ensure_thru(T688*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*DEFERRED_PROCEDURE*/T0*r688twin(T688*C);
/*DEFERRED_PROCEDURE*/void r688add_into_shared(T688*C,T0*a1,T0*a2);
/*DEFERRED_PROCEDURE*/T0*r688error_handler(void);
/*DEFERRED_PROCEDURE*/void r688accept(T688*C,T0*a1);
/*DEFERRED_PROCEDURE*/T6 r688valid_redefinition(T688*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*DEFERRED_PROCEDURE*/T0*r688change_require(T688*C,T0*a1,T6 a2);
/*DEFERRED_PROCEDURE*/T0*r688obsolete_warning_check_memory(void);
/*DEFERRED_PROCEDURE*/T351 r688start_position(T688*C);
/*DEFERRED_PROCEDURE*/void r688set_rescue_compound(T688*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690specialized_ensure_thru(T690*C,T0*a1,T0*a2,T0*a3);
/*ONCE_PROCEDURE*/T0*r690specialize_signature_in(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690try_to_undefine_aux(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/void r690collect(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690specialize_require_thru(T690*C,T0*a1,T0*a2,T0*a3);
/*ONCE_PROCEDURE*/void r690pretty_index(T690*C,T2 a1,T0*a2);
/*ONCE_PROCEDURE*/T0*r690specialize_permissions_thru(T690*C,T0*a1,T0*a2,T0*a3);
/*ONCE_PROCEDURE*/T6 r690empty_body_side_effect_free_effective_routine(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690simplify(T690*C,T0*a1);
/*ONCE_PROCEDURE*/void r690pretty_print_routine_body(T690*C,T2 a1);
/*ONCE_PROCEDURE*/T0*r690specialized_require_thru(T690*C,T0*a1,T0*a2,T0*a3);
/*ONCE_PROCEDURE*/void r690pretty_print_rescue(T690*C,T2 a1);
/*ONCE_PROCEDURE*/T0*r690specialize_closure_arguments_lists_in(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690first_name(T690*C);
/*ONCE_PROCEDURE*/T0*r690specialize_and_check(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690rescue_compound_in(T690*C,T0*a1);
/*ONCE_PROCEDURE*/void r690collect_body(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690names(T690*C);
/*ONCE_PROCEDURE*/T0*r690specialize_require_in(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690remove_first_redundant_initialisation(T0*a1,T0*a2);
/*ONCE_PROCEDURE*/void r690inline_dynamic_dispatch_(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/T6 r690no_rescue_no_local_expanded_in(T690*C,T0*a1);
/*ONCE_PROCEDURE*/void r690add_into(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/void r690make_routine(T690*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*ONCE_PROCEDURE*/T0*r690merge_signature_thru(T690*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*ONCE_PROCEDURE*/void r690make(T690*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6,T0*a7,T6 a8);
/*ONCE_PROCEDURE*/T0*r690try_to_undefine(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/T0*r690specialize_closure_arguments_lists_thru(T690*C,T0*a1,T0*a2,T0*a3);
/*ONCE_PROCEDURE*/void r690add_into_(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/T0*r690new_run_feature_for(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/T0*r690result_type(void);
/*ONCE_PROCEDURE*/void r690valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
/*ONCE_PROCEDURE*/T6 r690use_current(T690*C,T0*a1);
/*ONCE_PROCEDURE*/void r690obsolete_warning_check(T690*C,T0*a1,T351 a2);
/*ONCE_PROCEDURE*/void r690init(T690*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T0*a6);
/*ONCE_PROCEDURE*/T0*r690change_ensure(T690*C,T0*a1,T6 a2);
/*ONCE_PROCEDURE*/T0*r690brand_new_run_feature_for(T690*C,T0*a1,T0*a2,T6 a3);
/*ONCE_PROCEDURE*/void r690set_arguments(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/T0*r690specialize_permissions_in(T690*C,T0*a1);
/*ONCE_PROCEDURE*/void r690pretty_print_once_or_do(T2 a1);
/*ONCE_PROCEDURE*/void r690pretty_print_names(T690*C);
/*ONCE_PROCEDURE*/T0*r690specialize_permissions(T690*C,T0*a1,T6 a2);
/*ONCE_PROCEDURE*/void r690set_closure(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/void r690pretty(T690*C,T2 a1,T6 a2);
/*ONCE_PROCEDURE*/T6 r690same_body_as(T690*C,T0*a1);
/*ONCE_PROCEDURE*/void r690inline_dynamic_dispatch(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/T0*r690specialize_body_thru(T690*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*ONCE_PROCEDURE*/T6 r690same_signature(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/T351 r690sedb_trace_before_exit(T690*C);
/*ONCE_PROCEDURE*/T0*r690specialize_signature_thru(T690*C,T0*a1,T0*a2,T0*a3);
/*ONCE_PROCEDURE*/T0*r690specialize_ensure_in(T690*C,T0*a1,T6 a2);
/*ONCE_PROCEDURE*/T0*r690specialize_closure_local_var_lists_thru(T690*C,T0*a1,T0*a2,T0*a3);
/*ONCE_PROCEDURE*/T0*r690specialize_ensure_thru(T690*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*ONCE_PROCEDURE*/T0*r690twin(T690*C);
/*ONCE_PROCEDURE*/void r690add_into_shared(T690*C,T0*a1,T0*a2);
/*ONCE_PROCEDURE*/T0*r690error_handler(void);
/*ONCE_PROCEDURE*/void r690accept(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T0*r690specialize_closure_local_var_lists_in(T690*C,T0*a1);
/*ONCE_PROCEDURE*/T6 r690valid_redefinition(T690*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*ONCE_PROCEDURE*/T0*r690change_require(T690*C,T0*a1,T6 a2);
/*ONCE_PROCEDURE*/T0*r690obsolete_warning_check_memory(void);
/*ONCE_PROCEDURE*/T351 r690start_position(T690*C);
/*ONCE_PROCEDURE*/T0*r690specialize_body_in(T690*C,T0*a1,T6 a2);
/*ONCE_PROCEDURE*/T6 r690_P_349_same_body_as(T690*C,T0*a1);
/*CST_ATT_UNIQUE*/T697*create697with(T0*a1,T2 a2,T0*a3,T0*a4);
/*CST_ATT_UNIQUE*/T0*r697specialized_ensure_thru(T697*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_UNIQUE*/T0*r697try_to_undefine_aux(T697*C,T0*a1,T0*a2);
/*CST_ATT_UNIQUE*/void r697collect(T697*C,T0*a1);
/*CST_ATT_UNIQUE*/T0*r697specialize_require_thru(T697*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_UNIQUE*/void r697pretty_constant_value(T2 a1);
/*CST_ATT_UNIQUE*/T0*r697specialize_permissions_thru(T697*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_UNIQUE*/void r697with(T697*C,T0*a1,T2 a2,T0*a3,T0*a4);
/*CST_ATT_UNIQUE*/T0*r697simplify(T697*C,T0*a1);
/*CST_ATT_UNIQUE*/T0*r697arguments(void);
/*CST_ATT_UNIQUE*/T0*r697specialized_require_thru(T697*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_UNIQUE*/T0*r697first_name(T697*C);
/*CST_ATT_UNIQUE*/T0*r697specialize_and_check(T697*C,T0*a1);
/*CST_ATT_UNIQUE*/void r697collect_body(T697*C,T0*a1);
/*CST_ATT_UNIQUE*/T0*r697names(T697*C);
/*CST_ATT_UNIQUE*/T0*r697specialize_require_in(T697*C,T0*a1);
/*CST_ATT_UNIQUE*/void r697add_into(T697*C,T0*a1,T0*a2);
/*CST_ATT_UNIQUE*/T0*r697merge_signature_thru(T697*C,T0*a1,T0*a2,T0*a3,T0*a4,T6 a5);
/*CST_ATT_UNIQUE*/void r697make(T697*C,T0*a1);
/*CST_ATT_UNIQUE*/T0*r697try_to_undefine(T697*C,T0*a1,T0*a2);
/*CST_ATT_UNIQUE*/void r697add_into_(T697*C,T0*a1,T0*a2);
/*CST_ATT_UNIQUE*/T0*r697new_run_feature_for(T697*C,T0*a1,T0*a2);
/*CST_ATT_UNIQUE*/void r697valid_redefinition_error(T0*a1,T0*a2,T0*a3,T0*a4);
extern T0*oBC697counter;
/*CST_ATT_UNIQUE*/T6 r697use_current(T0*a1);
/*CST_ATT_UNIQUE*/void r697obsolete_warning_check(T697*C,T0*a1,T351 a2);
/*CST_ATT_UNIQUE*/T0*r697change_ensure(T697*C,T0*a1,T6 a2);
/*CST_ATT_UNIQUE*/T0*r697brand_new_run_feature_for(T697*C,T0*a1,T0*a2,T6 a3);
/*CST_ATT_UNIQUE*/T0*r697specialize_permissions_in(T697*C,T0*a1);
/*CST_ATT_UNIQUE*/void r697pretty_print_names(T697*C);
/*CST_ATT_UNIQUE*/T0*r697specialize_permissions(T697*C,T0*a1,T6 a2);
/*CST_ATT_UNIQUE*/void r697set_closure(T697*C,T0*a1,T0*a2);
/*CST_ATT_UNIQUE*/void r697pretty(T697*C,T2 a1,T6 a2);
/*CST_ATT_UNIQUE*/T6 r697same_body_as(T697*C,T0*a1);
/*CST_ATT_UNIQUE*/void r697inline_dynamic_dispatch(T697*C,T0*a1,T0*a2);
/*CST_ATT_UNIQUE*/T6 r697same_signature(T697*C,T0*a1,T0*a2);
/*CST_ATT_UNIQUE*/T0*r697specialize_signature_thru(T697*C,T0*a1,T0*a2,T0*a3);
/*CST_ATT_UNIQUE*/T0*r697specialize_ensure_in(T697*C,T0*a1,T6 a2);
/*CST_ATT_UNIQUE*/T0*r697specialize_ensure_thru(T697*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*CST_ATT_UNIQUE*/T0*r697twin(T697*C);
/*CST_ATT_UNIQUE*/T0*r697error_handler(void);
/*CST_ATT_UNIQUE*/T0*r697inline_expression_0(T697*C,T0*a1,T0*a2,T351 a3,T0*a4,T0*a5,T0*a6);
/*CST_ATT_UNIQUE*/T6 r697valid_redefinition(T697*C,T0*a1,T0*a2,T0*a3,T0*a4);
/*CST_ATT_UNIQUE*/T0*r697change_require(T697*C,T0*a1,T6 a2);
/*CST_ATT_UNIQUE*/T0*r697obsolete_warning_check_memory(void);
/*CST_ATT_UNIQUE*/T351 r697start_position(T697*C);
/*CST_ATT_UNIQUE*/void r697set_rescue_compound(T697*C,T0*a1);
/*INDEX_LIST*/void r432make(T432*C,T0*a1);
/*INDEX_LIST*/void r432pretty(T432*C,T2 a1,T0*a2);
/*RENAME_LIST*/void r713check_level_2(T713*C,T0*a1);
/*RENAME_LIST*/void r713make(T713*C,T0*a1);
/*RENAME_LIST*/T0*r713name_in_child(T713*C,T0*a1);
/*RENAME_LIST*/T6 r713is_target_of_rename(T713*C,T0*a1);
/*RENAME_LIST*/void r713initialize_and_check_level_1(T713*C);
/*RENAME_LIST*/T0*r713name_in_parent(T713*C,T0*a1);
/*RENAME_LIST*/T0*r713item(T713*C,T2 a1);
/*RENAME_LIST*/T0*r713error_handler(void);
/*RENAME_LIST*/T2 r713count(T713*C);
/*WHEN_ITEM_2*/void r763make(T763*C,T0*a1,T0*a2);
/*WHEN_ITEM_2*/void r763pretty(T763*C,T2 a1);
/*WHEN_ITEM_2*/T0*r763specialize_and_check_integer(T763*C,T0*a1);
/*WHEN_ITEM_2*/void r763set_lower_upper_manifest_expression(T763*C,T0*a1);
/*WHEN_ITEM_2*/void r763validity_check(T763*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_2*/T0*r763specialize_in(T763*C,T0*a1);
/*WHEN_ITEM_2*/void r763character_check(T0*a1,T0*a2);
/*WHEN_ITEM_2*/void r763init(T763*C,T0*a1,T0*a2);
/*WHEN_ITEM_2*/void r763set_values_integer(T763*C);
/*WHEN_ITEM_2*/T2 r763upper_value(T763*C);
/*WHEN_ITEM_2*/void r763integer_check(T0*a1,T0*a2);
/*WHEN_ITEM_2*/void r763force_internal_integer_values(T763*C,T0*a1,T0*a2);
/*WHEN_ITEM_2*/T0*r763specialize_thru(T763*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_2*/T6 r763validity_check_continued(T763*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_2*/T0*r763specialize_and_check_character(T763*C,T0*a1);
/*WHEN_ITEM_2*/T0*r763adapt_for(T763*C,T0*a1);
/*WHEN_ITEM_2*/T2 r763lower_value(T763*C);
/*WHEN_ITEM_2*/void r763collect(T763*C,T0*a1);
/*WHEN_ITEM_2*/void r763validity_check_continued_when_item_2(T763*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_2*/void r763validity_check_continued_when_item_1(T763*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_2*/T0*r763manifest_expression_check(T0*a1,T0*a2);
/*WHEN_ITEM_2*/T351 r763start_position(T763*C);
/*WHEN_ITEM_2*/T2 r763integer_value_of(T0*a1);
/*WHEN_ITEM_2*/T0*r763twin(T763*C);
/*WHEN_ITEM_2*/void r763set_values_character(T763*C);
/*WHEN_ITEM_2*/T2 r763locate_in_values(T0*a1,T2 a2);
/*WHEN_ITEM_2*/T6 r763side_effect_free(T763*C,T0*a1);
/*WHEN_ITEM_2*/T0*r763error_handler(void);
/*WHEN_ITEM_2*/void r763lower_upper_value_check(T763*C);
/*WHEN_ITEM_2*/void r763validity_check_continued_(T763*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_2*/void r763force_internal_character_values(T763*C,T0*a1,T0*a2);
/*WHEN_ITEM_2*/T6 r763match_value(T763*C,T2 a1);
/*WHEN_ITEM_2*/T0*r763compute_values(T763*C,T0*a1,T0*a2);
/*WHEN_ITEM_2*/void r763explain_fatal_error(T0*a1,T0*a2);
/*WHEN_ITEM_2*/T0*r763current_or_twin_init(T763*C,T0*a1,T0*a2);
/*WHEN_ITEM_1*/void r394set_manifest_expression(T394*C,T0*a1);
/*WHEN_ITEM_1*/void r394make(T394*C,T0*a1);
/*WHEN_ITEM_1*/void r394pretty(T394*C,T2 a1);
/*WHEN_ITEM_1*/T0*r394specialize_and_check_integer(T394*C,T0*a1);
/*WHEN_ITEM_1*/void r394validity_check(T394*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_1*/T0*r394specialize_in(T394*C,T0*a1);
/*WHEN_ITEM_1*/void r394character_check(T0*a1,T0*a2);
/*WHEN_ITEM_1*/void r394set_expression_value(T394*C,T2 a1);
/*WHEN_ITEM_1*/void r394integer_check(T0*a1,T0*a2);
/*WHEN_ITEM_1*/void r394force_internal_integer_values(T394*C,T0*a1,T0*a2);
/*WHEN_ITEM_1*/T0*r394specialize_thru(T394*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_1*/T2 r394expression_value(T394*C);
/*WHEN_ITEM_1*/T6 r394validity_check_continued(T394*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_1*/T0*r394specialize_and_check_character(T394*C,T0*a1);
/*WHEN_ITEM_1*/T0*r394adapt_for(T394*C,T0*a1);
/*WHEN_ITEM_1*/void r394collect(T394*C,T0*a1);
/*WHEN_ITEM_1*/void r394validity_check_continued_when_item_2(T394*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_1*/void r394validity_check_continued_when_item_1(T394*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_1*/T0*r394manifest_expression_check(T0*a1,T0*a2);
/*WHEN_ITEM_1*/T351 r394start_position(T394*C);
/*WHEN_ITEM_1*/T2 r394integer_value_of(T0*a1);
/*WHEN_ITEM_1*/void r394set_expression_value_character(T394*C);
/*WHEN_ITEM_1*/T0*r394twin(T394*C);
/*WHEN_ITEM_1*/T2 r394locate_in_values(T0*a1,T2 a2);
/*WHEN_ITEM_1*/T6 r394side_effect_free(T394*C,T0*a1);
/*WHEN_ITEM_1*/T0*r394error_handler(void);
/*WHEN_ITEM_1*/void r394validity_check_continued_(T394*C,T0*a1,T0*a2,T0*a3);
/*WHEN_ITEM_1*/void r394force_internal_character_values(T394*C,T0*a1,T0*a2);
/*WHEN_ITEM_1*/T6 r394match_value(T394*C,T2 a1);
/*WHEN_ITEM_1*/T0*r394compute_values(T394*C,T0*a1,T0*a2);
/*WHEN_ITEM_1*/void r394set_expression_value_integer(T394*C);
/*WHEN_ITEM_1*/void r394explain_fatal_error(T0*a1,T0*a2);
/*WHEN_ITEM_1*/T0*r394current_or_twin_init(T394*C,T0*a1);
/*COMPOUND_EXPRESSION*/void r465simplify_add(T0*a1,T0*a2);
/*COMPOUND_EXPRESSION*/T0*r465specialize_and_check(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T0*r465to_expression(T465*C);
/*COMPOUND_EXPRESSION*/T0*r465simplify(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T0*r465static_simplify(T465*C);
/*COMPOUND_EXPRESSION*/T0*r465specialize_in(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/void r465inline_dynamic_dispatch_(T465*C,T0*a1,T0*a2);
/*COMPOUND_EXPRESSION*/void r465safety_check(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T0*r465last(T465*C);
/*COMPOUND_EXPRESSION*/void r465set_list(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T0*r465specialize_thru(T465*C,T0*a1,T0*a2,T0*a3);
/*COMPOUND_EXPRESSION*/T2 r465upper(T465*C);
/*COMPOUND_EXPRESSION*/T6 r465is_stored_in_some_local_variable(void);
/*COMPOUND_EXPRESSION*/void r465accept(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T0*r465adapt_for(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/void r465from_list(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T0*r465collect(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T351 r465start_position(T465*C);
/*COMPOUND_EXPRESSION*/T0*r465twin(T465*C);
/*COMPOUND_EXPRESSION*/T0*r465written_declaration_type_mark(void);
/*COMPOUND_EXPRESSION*/T6 r465use_current(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/void r465crash(T465*C);
/*COMPOUND_EXPRESSION*/T0*r465non_void_no_dispatch_type(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T6 r465side_effect_free(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/void r465not_yet_implemented(T465*C);
/*COMPOUND_EXPRESSION*/T0*r465resolve_in(T465*C,T0*a1);
/*COMPOUND_EXPRESSION*/T0*r465to_instruction(T465*C);
/*CREATE_WRITABLE*/T0*r675specialize_and_check(T675*C,T0*a1);
/*CREATE_WRITABLE*/T0*r675to_expression(T675*C);
/*CREATE_WRITABLE*/void r675make(T675*C,T0*a1,T0*a2);
/*CREATE_WRITABLE*/void r675pretty(T675*C,T2 a1);
/*CREATE_WRITABLE*/T0*r675simplify(T675*C,T0*a1);
/*CREATE_WRITABLE*/T6 r675extra_bracket_flag(T675*C);
/*CREATE_WRITABLE*/void r675validity_check(T675*C,T0*a1);
/*CREATE_WRITABLE*/T0*r675static_simplify(T675*C);
/*CREATE_WRITABLE*/T0*r675specialize_in(T675*C,T0*a1);
/*CREATE_WRITABLE*/void r675inline_dynamic_dispatch_(T675*C,T0*a1,T0*a2);
/*CREATE_WRITABLE*/void r675safety_check(T675*C,T0*a1);
/*CREATE_WRITABLE*/void r675init(T675*C,T0*a1,T0*a2);
/*CREATE_WRITABLE*/T6 r675is_result(T675*C);
/*CREATE_WRITABLE*/T2 r675precedence(T675*C);
/*CREATE_WRITABLE*/T0*r675specialize_thru(T675*C,T0*a1,T0*a2,T0*a3);
/*CREATE_WRITABLE*/T6 r675is_stored_in_some_local_variable(void);
/*CREATE_WRITABLE*/void r675accept(T675*C,T0*a1);
/*CREATE_WRITABLE*/T0*r675adapt_for(T675*C,T0*a1);
/*CREATE_WRITABLE*/T0*r675collect(T675*C,T0*a1);
/*CREATE_WRITABLE*/void r675pretty_target(T675*C,T2 a1);
/*CREATE_WRITABLE*/T351 r675start_position(T675*C);
/*CREATE_WRITABLE*/T0*r675twin(T675*C);
/*CREATE_WRITABLE*/T0*r675written_declaration_type_mark(T675*C);
/*CREATE_WRITABLE*/T6 r675use_current(T675*C,T0*a1);
/*CREATE_WRITABLE*/void r675bracketed_pretty(T675*C,T2 a1);
/*CREATE_WRITABLE*/T0*r675non_void_no_dispatch_type(T0*a1);
/*CREATE_WRITABLE*/T6 r675side_effect_free(T675*C,T0*a1);
/*CREATE_WRITABLE*/T0*r675error_handler(void);
/*CREATE_WRITABLE*/void r675make_specialized(T675*C,T0*a1,T0*a2);
/*CREATE_WRITABLE*/T0*r675resolve_in(T675*C,T0*a1);
/*CREATE_WRITABLE*/T0*r675to_instruction(T675*C);
/*CREATE_WRITABLE*/T0*r675current_or_twin_init(T675*C,T0*a1,T0*a2);
/*CLOSED_OPERAND*/T0*r676specialize_and_check(T676*C,T0*a1);
/*CLOSED_OPERAND*/T0*r676to_expression(T676*C);
/*CLOSED_OPERAND*/void r676make(T676*C,T2 a1,T0*a2);
/*CLOSED_OPERAND*/void r676pretty(T676*C,T2 a1);
/*CLOSED_OPERAND*/T0*r676simplify(T676*C,T0*a1);
/*CLOSED_OPERAND*/T6 r676extra_bracket_flag(T676*C);
/*CLOSED_OPERAND*/T0*r676static_simplify(T676*C);
/*CLOSED_OPERAND*/T0*r676specialize_in(T676*C,T0*a1);
/*CLOSED_OPERAND*/void r676inline_dynamic_dispatch_(T676*C,T0*a1,T0*a2);
/*CLOSED_OPERAND*/void r676safety_check(T676*C,T0*a1);
/*CLOSED_OPERAND*/T6 r676is_result(T676*C);
/*CLOSED_OPERAND*/T2 r676precedence(T676*C);
/*CLOSED_OPERAND*/T0*r676specialize_thru(T676*C,T0*a1,T0*a2,T0*a3);
/*CLOSED_OPERAND*/T6 r676is_static(T676*C);
/*CLOSED_OPERAND*/T6 r676is_stored_in_some_local_variable(void);
/*CLOSED_OPERAND*/void r676accept(T676*C,T0*a1);
/*CLOSED_OPERAND*/T0*r676adapt_for(T676*C,T0*a1);
/*CLOSED_OPERAND*/T0*r676declaration_type(T676*C);
/*CLOSED_OPERAND*/T0*r676collect(T676*C,T0*a1);
/*CLOSED_OPERAND*/T6 r676is_current(T676*C);
/*CLOSED_OPERAND*/void r676pretty_target(T676*C,T2 a1);
/*CLOSED_OPERAND*/T0*r676twin(T676*C);
/*CLOSED_OPERAND*/T0*r676written_declaration_type_mark(T676*C);
/*CLOSED_OPERAND*/T6 r676use_current(T676*C,T0*a1);
/*CLOSED_OPERAND*/void r676bracketed_pretty(T676*C,T2 a1);
/*CLOSED_OPERAND*/T6 r676is_void(T676*C);
/*CLOSED_OPERAND*/T0*r676non_void_no_dispatch_type(T676*C,T0*a1);
/*CLOSED_OPERAND*/T6 r676side_effect_free(T676*C,T0*a1);
/*CLOSED_OPERAND*/T6 r676is_manifest_string(T676*C);
/*CLOSED_OPERAND*/T6 r676is_implicit_current(T676*C);
/*CLOSED_OPERAND*/T0*r676resolve_in(T676*C,T0*a1);
/*CLOSED_OPERAND*/T0*r676to_instruction(T676*C);
/*NO_INVARIANT_WRAPPER*/T0*r428specialize_and_check(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T0*r428to_expression(T428*C);
/*NO_INVARIANT_WRAPPER*/void r428make(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T0*r428simplify(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T0*r428specialize_in(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/void r428inline_dynamic_dispatch_(T428*C,T0*a1,T0*a2);
/*NO_INVARIANT_WRAPPER*/void r428safety_check(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T0*r428specialize_thru(T428*C,T0*a1,T0*a2,T0*a3);
/*NO_INVARIANT_WRAPPER*/void r428accept(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T0*r428adapt_for(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T0*r428collect(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T6 r428end_mark_comment(T428*C);
/*NO_INVARIANT_WRAPPER*/T351 r428start_position(T428*C);
/*NO_INVARIANT_WRAPPER*/T0*r428twin(T428*C);
/*NO_INVARIANT_WRAPPER*/T6 r428use_current(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T6 r428side_effect_free(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T0*r428inline_dynamic_dispatch(T428*C,T0*a1,T0*a2);
/*NO_INVARIANT_WRAPPER*/T0*r428to_instruction(T428*C);
/*NO_INVARIANT_WRAPPER*/T0*r428specialize_without_checks(T428*C,T0*a1);
/*NO_INVARIANT_WRAPPER*/T0*r428current_or_twin_init(T428*C,T0*a1);
/*C_GARBAGE_COLLECTOR_STRUCTER*/void r879make(T879*C);
/*FAKE_ARGUMENT*/T0*r369to_expression(T369*C);
/*FAKE_ARGUMENT*/void r369make(T369*C,T0*a1,T351 a2,T0*a3,T2 a4);
/*FAKE_ARGUMENT*/T0*r369static_simplify(T369*C);
/*FAKE_ARGUMENT*/T0*r369specialize_in(T369*C,T0*a1);
/*FAKE_ARGUMENT*/void r369inline_dynamic_dispatch_(T369*C,T0*a1,T0*a2);
/*FAKE_ARGUMENT*/T6 r369is_stored_in_some_local_variable(void);
/*FAKE_ARGUMENT*/void r369accept(T369*C,T0*a1);
/*FAKE_ARGUMENT*/T0*r369collect(T369*C,T0*a1);
/*FAKE_ARGUMENT*/T0*r369twin(T369*C);
/*FAKE_ARGUMENT*/T0*r369written_declaration_type_mark(T369*C);
/*FAKE_ARGUMENT*/T6 r369use_current(T0*a1);
/*FAKE_ARGUMENT*/T0*r369non_void_no_dispatch_type(T0*a1);
/*FAKE_ARGUMENT*/T6 r369side_effect_free(T0*a1);
/*FAKE_ARGUMENT*/T0*r369resolve_in(T369*C,T0*a1);
/*FAKE_ARGUMENT*/T0*r369to_instruction(T369*C);
/*PROCESS_POSIX*/void r801make(T801*C);
/*PROCESS_POSIX*/T6 r801is_finished(T801*C);
/*PROCESS_POSIX*/void r801cleanup_streams(T801*C);
/*PROCESS_POSIX*/T2 r801id(T801*C);
/*PROCESS_POSIX*/void r801do_execute(T801*C,T8 a1,T8 a2,T6 a3,T8 a4);
/*PROCESS_POSIX*/void r801do_cleanup(T801*C);
/*PROCESS_POSIX*/void r801execute_command_line(T801*C,T0*a1,T6 a2);
/*PROCESS_POSIX*/void r801dispose(T801*C);
/*PROCESS_POSIX*/T6 r801is_child(T801*C);
/*PROCESS_POSIX*/void r801wait(T801*C);
/*PROCESS_WIN32*/void r802make(T802*C);
/*PROCESS_WIN32*/T6 r802is_finished(T802*C);
/*PROCESS_WIN32*/void r802cleanup_streams(T802*C);
/*PROCESS_WIN32*/T2 r802handle(T802*C);
/*PROCESS_WIN32*/void r802do_execute(T802*C,T8 a1,T6 a2);
/*PROCESS_WIN32*/void r802do_cleanup(T802*C);
/*PROCESS_WIN32*/void r802execute_command_line(T802*C,T0*a1,T6 a2);
/*PROCESS_WIN32*/void r802dispose(T802*C);
/*PROCESS_WIN32*/void r802wait(T802*C);
/*PROCESS_NONE*/void r803make(T803*C);
/*PROCESS_NONE*/void r803execute_command_line(T803*C,T0*a1,T6 a2);
/*PROCESS_GROUP_POSIX*/void r798make(T798*C);
/*PROCESS_GROUP_POSIX*/void r798unregister(T798*C,T0*a1);
/*PROCESS_GROUP_POSIX*/void r798register(T798*C,T0*a1);
/*PROCESS_GROUP_WIN32*/void r799make(T799*C);
/*PROCESS_GROUP_WIN32*/void r799unregister(T799*C,T0*a1);
/*PROCESS_GROUP_WIN32*/void r799register(T799*C,T0*a1);
/*STD_INPUT*/void r61make(T61*C);
/*MICROSOFT_PATH_NAME*/void r811remove_last(T811*C);
/*MICROSOFT_PATH_NAME*/void r811make_empty(T811*C);
/*MICROSOFT_PATH_NAME*/void r811start_join(T811*C,T0*a1,T2 a2);
/*MICROSOFT_PATH_NAME*/void r811join_element(T811*C,T0*a1);
/*MICROSOFT_PATH_NAME*/T2 r811start_join_to(T811*C,T0*a1);
/*MICROSOFT_PATH_NAME*/T0*r811drive_specification(T811*C);
/*MICROSOFT_PATH_NAME*/void r811end_join(T811*C);
/*MICROSOFT_PATH_NAME*/void r811make_from_string(T811*C,T0*a1);
/*MICROSOFT_PATH_NAME*/T0*r811last(T811*C);
/*MICROSOFT_PATH_NAME*/void r811add_last(T811*C,T0*a1);
/*MICROSOFT_PATH_NAME*/T6 r811is_separator(T3 a1);
/*MICROSOFT_PATH_NAME*/T6 r811is_absolute(T811*C);
/*MICROSOFT_PATH_NAME*/void r811go_up(T811*C);
/*MICROSOFT_PATH_NAME*/void r811make_current(T811*C);
/*MICROSOFT_PATH_NAME*/T2 r811scan_element(T811*C,T2 a1,T0*a2);
/*MICROSOFT_PATH_NAME*/T6 r811is_valid_path(T0*a1);
/*MICROSOFT_PATH_NAME*/void r811join_to(T811*C,T0*a1);
/*MICROSOFT_PATH_NAME*/void r811join(T811*C,T0*a1);
/*MICROSOFT_PATH_NAME*/T0*r811to_string(T811*C);
/*MICROSOFT_PATH_NAME*/T0*r811short_name(T811*C);
/*MICROSOFT_PATH_NAME*/void r811join_element_to(T0*a1,T0*a2);
/*MICROSOFT_PATH_NAME*/void r811join_directory_to(T0*a1,T0*a2);
/*MICROSOFT_PATH_NAME*/T2 r811count(T811*C);
/*MICROSOFT_PATH_NAME*/void r811make_root(T811*C);
/*MICROSOFT_PATH_NAME*/void r811_P_810_join_element(T811*C,T0*a1);
/*MICROSOFT_PATH_NAME*/void r811_P_808_end_join(T811*C);
/*UTF8_PARSER*/void r767decode(T767*C,T0*a1,T0*a2);
/*SEDB*/T682*create682make(T351 a1,T3 a2);
/*SEDB*/T0*r682to_expression(T682*C);
/*SEDB*/void r682make(T682*C,T351 a1,T3 a2);
/*SEDB*/T0*r682simplify(T682*C,T0*a1);
/*SEDB*/void r682inline_dynamic_dispatch_(T682*C,T0*a1,T0*a2);
/*SEDB*/void r682accept(T682*C,T0*a1);
/*SEDB*/T6 r682use_current(T0*a1);
/*SEDB*/T6 r682side_effect_free(T0*a1);
/*SEDB*/T0*r682inline_dynamic_dispatch(T682*C,T0*a1,T0*a2);
/*SEDB*/T0*r682to_instruction(T682*C);
/*EFFECTIVE_ARG_LIST_0*/T0*r702specialize_and_check(T702*C,T0*a1,T0*a2,T0*a3,T6 a4);
/*EFFECTIVE_ARG_LIST_0*/void r702make(T702*C,T351 a1);
/*EFFECTIVE_ARG_LIST_0*/void r702unused_expression_inline(T0*a1,T0*a2);
/*EFFECTIVE_ARG_LIST_0*/T0*r702simplify(T0*a1);
/*EFFECTIVE_ARG_LIST_0*/void r702set_end_position(T702*C,T351 a1);
/*EFFECTIVE_ARG_LIST_0*/T0*r702expression(T2 a1);
/*EFFECTIVE_ARG_LIST_0*/void r702specialize_count_error(T702*C,T351 a1,T0*a2);
/*EFFECTIVE_ARG_LIST_0*/void r702accept(T702*C,T0*a1);
/*EFFECTIVE_ARG_LIST_0*/T0*r702synthetize_tuple(T702*C,T0*a1,T0*a2,T0*a3);
/*EFFECTIVE_ARG_LIST_0*/void r702unused_expression_in(T0*a1,T0*a2);
/*EFFECTIVE_ARG_LIST_0*/void r702simple_collect(T0*a1,T0*a2);
/*EFFECTIVE_ARG_LIST_0*/T0*r702twin(T702*C);
/*EFFECTIVE_ARG_LIST_0*/T0*r702synthetic_tuple_arg(T2 a1,T0*a2,T0*a3,T0*a4);
/*EFFECTIVE_ARG_LIST_0*/T6 r702side_effect_free(T0*a1);
/*EFFECTIVE_ARG_LIST_0*/T0*r702error_handler(void);
/*NULL_POINTER*/T0*r667specialize_and_check(T667*C,T0*a1);
/*NULL_POINTER*/T0*r667to_expression(T667*C);
/*NULL_POINTER*/void r667make(T667*C,T351 a1,T0*a2);
/*NULL_POINTER*/T0*r667simplify(T667*C,T0*a1);
/*NULL_POINTER*/T0*r667static_simplify(T667*C);
/*NULL_POINTER*/T0*r667specialize_in(T667*C,T0*a1);
/*NULL_POINTER*/void r667inline_dynamic_dispatch_(T667*C,T0*a1,T0*a2);
/*NULL_POINTER*/T0*r667specialize_thru(T667*C,T0*a1,T0*a2,T0*a3);
/*NULL_POINTER*/T6 r667is_stored_in_some_local_variable(void);
/*NULL_POINTER*/void r667accept(T667*C,T0*a1);
extern T0*oBC667declaration_type;
extern int fBC667declaration_type;
/*NULL_POINTER*/T0*r667declaration_type(void);
/*NULL_POINTER*/T0*r667twin(T667*C);
/*NULL_POINTER*/T0*r667written_declaration_type_mark(void);
/*NULL_POINTER*/T6 r667use_current(T0*a1);
/*NULL_POINTER*/T0*r667non_void_no_dispatch_type(T0*a1);
/*NULL_POINTER*/T6 r667side_effect_free(T0*a1);
/*NULL_POINTER*/T0*r667resolve_in(T0*a1);
/*NULL_POINTER*/T0*r667to_instruction(T667*C);
/*VOID_CALL*/T580*create580make(T351 a1,T0*a2,T0*a3);
/*VOID_CALL*/T0*r580specialize_and_check(T580*C,T0*a1);
/*VOID_CALL*/T0*r580to_expression(T580*C);
/*VOID_CALL*/void r580make(T580*C,T351 a1,T0*a2,T0*a3);
/*VOID_CALL*/T0*r580simplify(T580*C,T0*a1);
/*VOID_CALL*/T0*r580static_simplify(T580*C);
/*VOID_CALL*/T0*r580specialize_in(T580*C,T0*a1);
/*VOID_CALL*/void r580inline_dynamic_dispatch_(T580*C,T0*a1,T0*a2);
/*VOID_CALL*/void r580safety_check(T580*C,T0*a1);
/*VOID_CALL*/T0*r580specialize_thru(T580*C,T0*a1,T0*a2,T0*a3);
/*VOID_CALL*/T6 r580is_stored_in_some_local_variable(void);
/*VOID_CALL*/void r580accept(T580*C,T0*a1);
/*VOID_CALL*/T0*r580declaration_type(T580*C);
/*VOID_CALL*/T0*r580twin(T580*C);
/*VOID_CALL*/T0*r580written_declaration_type_mark(T580*C);
/*VOID_CALL*/T6 r580use_current(T0*a1);
/*VOID_CALL*/T0*r580non_void_no_dispatch_type(T0*a1);
/*VOID_CALL*/T6 r580side_effect_free(T0*a1);
/*VOID_CALL*/T0*r580error_handler(void);
/*VOID_CALL*/T0*r580resolve_in(T580*C,T0*a1);
/*VOID_CALL*/T0*r580to_instruction(T580*C);
/*INLINE_MEMO*/T0*r548expression(T548*C);
/*INLINE_MEMO*/T0*r548instruction(T548*C);
/*NO_DISPATCH*/T0*r668specialize_and_check(T668*C,T0*a1);
/*NO_DISPATCH*/T0*r668to_expression(T668*C);
/*NO_DISPATCH*/void r668make(T668*C,T0*a1,T0*a2,T0*a3);
/*NO_DISPATCH*/T0*r668simplify(T668*C,T0*a1);
/*NO_DISPATCH*/T0*r668static_simplify(T668*C);
/*NO_DISPATCH*/T0*r668specialize_in(T668*C,T0*a1);
/*NO_DISPATCH*/void r668inline_dynamic_dispatch_(T668*C,T0*a1,T0*a2);
/*NO_DISPATCH*/void r668safety_check(T668*C,T0*a1);
/*NO_DISPATCH*/T6 r668is_writable(T668*C);
/*NO_DISPATCH*/T6 r668is_result(T668*C);
/*NO_DISPATCH*/T0*r668specialize_thru(T668*C,T0*a1,T0*a2,T0*a3);
/*NO_DISPATCH*/T6 r668is_stored_in_some_local_variable(void);
/*NO_DISPATCH*/void r668accept(T668*C,T0*a1);
/*NO_DISPATCH*/T0*r668adapt_for(T668*C,T0*a1);
/*NO_DISPATCH*/T0*r668collect(T668*C,T0*a1);
/*NO_DISPATCH*/T351 r668start_position(T668*C);
/*NO_DISPATCH*/T0*r668twin(T668*C);
/*NO_DISPATCH*/T0*r668written_declaration_type_mark(T668*C);
/*NO_DISPATCH*/T6 r668use_current(T668*C,T0*a1);
/*NO_DISPATCH*/T0*r668non_void_no_dispatch_type(T668*C,T0*a1);
/*NO_DISPATCH*/T6 r668side_effect_free(T0*a1);
/*NO_DISPATCH*/T0*r668resolve_in(T668*C,T0*a1);
/*NO_DISPATCH*/T0*r668to_instruction(T668*C);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672specialize_and_check(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672to_expression(T672*C);
/*DYNAMIC_DISPATCH_TEMPORARY1*/void r672make(T672*C,T0*a1,T0*a2);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672simplify(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/void r672set_tag(T672*C,T0*a1,T0*a2);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672static_simplify(T672*C);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672specialize_in(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/void r672inline_dynamic_dispatch_(T672*C,T0*a1,T0*a2);
/*DYNAMIC_DISPATCH_TEMPORARY1*/void r672safety_check(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T6 r672is_writable(T672*C);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T6 r672is_result(T672*C);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672specialize_thru(T672*C,T0*a1,T0*a2,T0*a3);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T6 r672is_static(T672*C);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T6 r672is_stored_in_some_local_variable(void);
/*DYNAMIC_DISPATCH_TEMPORARY1*/void r672accept(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672adapt_for(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672collect(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T351 r672start_position(T672*C);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672twin(T672*C);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672written_declaration_type_mark(void);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T6 r672use_current(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672non_void_no_dispatch_type(T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T6 r672side_effect_free(T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672tag(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672resolve_in(T672*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1*/T0*r672to_instruction(T672*C);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671specialize_and_check(T671*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671to_expression(T671*C);
/*DYNAMIC_DISPATCH_TEMPORARY2*/void r671make(T671*C,T0*a1,T0*a2);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671simplify(T671*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671static_simplify(T671*C);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671specialize_in(T671*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY2*/void r671inline_dynamic_dispatch_(T671*C,T0*a1,T0*a2);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T6 r671is_result(T671*C);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671specialize_thru(T671*C,T0*a1,T0*a2,T0*a3);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T6 r671is_static(T671*C);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T6 r671is_stored_in_some_local_variable(void);
/*DYNAMIC_DISPATCH_TEMPORARY2*/void r671accept(T671*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T351 r671start_position(T671*C);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671twin(T671*C);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671written_declaration_type_mark(void);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T6 r671use_current(T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671non_void_no_dispatch_type(T671*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T6 r671side_effect_free(T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671resolve_in(T671*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY2*/T0*r671to_instruction(T671*C);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T673*create673make(T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673specialize_and_check(T673*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673to_expression(T673*C);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/void r673make(T673*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673simplify(T673*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673static_simplify(T673*C);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673specialize_in(T673*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/void r673inline_dynamic_dispatch_(T673*C,T0*a1,T0*a2);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/void r673safety_check(T673*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673specialize_thru(T673*C,T0*a1,T0*a2,T0*a3);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T6 r673is_stored_in_some_local_variable(void);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/void r673accept(T673*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673collect(T673*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T351 r673start_position(T673*C);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673twin(T673*C);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673written_declaration_type_mark(void);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T6 r673use_current(T673*C,T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673non_void_no_dispatch_type(T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T6 r673side_effect_free(T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673resolve_in(T0*a1);
/*DYNAMIC_DISPATCH_TEMPORARY1_ID*/T0*r673to_instruction(T673*C);
/*INTERNAL_LOCAL2*/T670*create670make(T351 a1,T0*a2,T0*a3,T6 a4);
/*INTERNAL_LOCAL2*/T0*r670specialize_and_check(T670*C,T0*a1);
/*INTERNAL_LOCAL2*/T0*r670to_expression(T670*C);
/*INTERNAL_LOCAL2*/void r670make(T670*C,T351 a1,T0*a2,T0*a3,T6 a4);
/*INTERNAL_LOCAL2*/T0*r670simplify(T670*C,T0*a1);
/*INTERNAL_LOCAL2*/void r670set_tag(T670*C,T0*a1,T0*a2);
/*INTERNAL_LOCAL2*/T0*r670static_simplify(T670*C);
/*INTERNAL_LOCAL2*/T0*r670specialize_in(T670*C,T0*a1);
/*INTERNAL_LOCAL2*/void r670inline_dynamic_dispatch_(T670*C,T0*a1,T0*a2);
/*INTERNAL_LOCAL2*/T0*r670specialize_thru(T670*C,T0*a1,T0*a2,T0*a3);
/*INTERNAL_LOCAL2*/T0*r670tagged_tag(T670*C,T0*a1);
/*INTERNAL_LOCAL2*/T6 r670is_stored_in_some_local_variable(void);
/*INTERNAL_LOCAL2*/void r670accept(T670*C,T0*a1);
/*INTERNAL_LOCAL2*/T0*r670declaration_type(T670*C);
/*INTERNAL_LOCAL2*/T0*r670collect(T670*C,T0*a1);
/*INTERNAL_LOCAL2*/T0*r670twin(T670*C);
/*INTERNAL_LOCAL2*/T0*r670written_declaration_type_mark(T670*C);
/*INTERNAL_LOCAL2*/T6 r670use_current(T0*a1);
/*INTERNAL_LOCAL2*/T0*r670non_void_no_dispatch_type(T0*a1);
/*INTERNAL_LOCAL2*/T6 r670side_effect_free(T0*a1);
/*INTERNAL_LOCAL2*/T0*r670resolve_in(T670*C,T0*a1);
/*INTERNAL_LOCAL2*/T0*r670to_instruction(T670*C);
/*UNUSED_EXPRESSION*/T681*create681make(T0*a1);
/*UNUSED_EXPRESSION*/T0*r681to_expression(T681*C);
/*UNUSED_EXPRESSION*/void r681make(T681*C,T0*a1);
/*UNUSED_EXPRESSION*/T0*r681simplify(T681*C,T0*a1);
/*UNUSED_EXPRESSION*/void r681inline_dynamic_dispatch_(T681*C,T0*a1,T0*a2);
/*UNUSED_EXPRESSION*/void r681safety_check(T681*C,T0*a1);
/*UNUSED_EXPRESSION*/void r681accept(T681*C,T0*a1);
/*UNUSED_EXPRESSION*/T0*r681adapt_for(T681*C,T0*a1);
/*UNUSED_EXPRESSION*/T0*r681collect(T681*C,T0*a1);
/*UNUSED_EXPRESSION*/T351 r681start_position(T681*C);
/*UNUSED_EXPRESSION*/T6 r681use_current(T681*C,T0*a1);
/*UNUSED_EXPRESSION*/T6 r681side_effect_free(T681*C,T0*a1);
/*UNUSED_EXPRESSION*/T0*r681inline_dynamic_dispatch(T681*C,T0*a1,T0*a2);
/*UNUSED_EXPRESSION*/T0*r681to_instruction(T681*C);
/*NATURAL_CONSTANT*/T0*r666to_expression(T666*C);
/*NATURAL_CONSTANT*/void r666make(T666*C,uint64_t a1,T351 a2);
/*NATURAL_CONSTANT*/void r666pretty(T666*C,T2 a1);
/*NATURAL_CONSTANT*/T0*r666simplify(T666*C,T0*a1);
/*NATURAL_CONSTANT*/T0*r666static_simplify(T666*C);
/*NATURAL_CONSTANT*/void r666inline_dynamic_dispatch_(T666*C,T0*a1,T0*a2);
/*NATURAL_CONSTANT*/T6 r666is_stored_in_some_local_variable(void);
/*NATURAL_CONSTANT*/void r666accept(T666*C,T0*a1);
/*NATURAL_CONSTANT*/void r666with(T666*C,uint64_t a1,T351 a2,T0*a3);
/*NATURAL_CONSTANT*/T0*r666result_type(T666*C);
/*NATURAL_CONSTANT*/T0*r666declaration_type(T666*C);
/*NATURAL_CONSTANT*/T0*r666collect(T666*C,T0*a1);
/*NATURAL_CONSTANT*/void r666pretty_target(T666*C,T2 a1);
/*NATURAL_CONSTANT*/T0*r666twin(T666*C);
/*NATURAL_CONSTANT*/T0*r666written_declaration_type_mark(T666*C);
/*NATURAL_CONSTANT*/T6 r666use_current(T0*a1);
/*NATURAL_CONSTANT*/void r666bracketed_pretty(T666*C,T2 a1);
/*NATURAL_CONSTANT*/T0*r666non_void_no_dispatch_type(T666*C,T0*a1);
/*NATURAL_CONSTANT*/T0*r666to_string(T666*C);
/*NATURAL_CONSTANT*/T6 r666side_effect_free(T0*a1);
/*NATURAL_CONSTANT*/void r666append_in(T666*C,T0*a1);
/*NATURAL_CONSTANT*/T0*r666resolve_in(T666*C,T0*a1);
/*NATURAL_CONSTANT*/T0*r666to_instruction(T666*C);
/*NATURAL_CONSTANT*/void r666_P_387_pretty_target(T666*C,T2 a1);
/*RUN_TIME_ERROR_INSTRUCTION*/T683*create683make(T351 a1,T0*a2,T2 a3);
/*RUN_TIME_ERROR_INSTRUCTION*/T0*r683to_expression(T683*C);
/*RUN_TIME_ERROR_INSTRUCTION*/void r683make(T683*C,T351 a1,T0*a2,T2 a3);
/*RUN_TIME_ERROR_INSTRUCTION*/T0*r683simplify(T683*C,T0*a1);
/*RUN_TIME_ERROR_INSTRUCTION*/void r683inline_dynamic_dispatch_(T683*C,T0*a1,T0*a2);
/*RUN_TIME_ERROR_INSTRUCTION*/void r683accept(T683*C,T0*a1);
/*RUN_TIME_ERROR_INSTRUCTION*/T0*r683error_name(T683*C);
/*RUN_TIME_ERROR_INSTRUCTION*/T6 r683use_current(T0*a1);
/*RUN_TIME_ERROR_INSTRUCTION*/T6 r683side_effect_free(T0*a1);
/*RUN_TIME_ERROR_INSTRUCTION*/T0*r683inline_dynamic_dispatch(T683*C,T0*a1,T0*a2);
/*RUN_TIME_ERROR_INSTRUCTION*/T0*r683to_instruction(T683*C);
/*EXCEPTIONS*/T0*r342name_of_exception(T2 a1);
/*IMPLICIT_CAST*/T0*r544specialize_and_check(T544*C,T0*a1);
/*IMPLICIT_CAST*/T0*r544to_expression(T544*C);
/*IMPLICIT_CAST*/void r544make(T544*C,T0*a1,T0*a2,T0*a3);
/*IMPLICIT_CAST*/void r544pretty(T544*C,T2 a1);
/*IMPLICIT_CAST*/T0*r544simplify(T544*C,T0*a1);
/*IMPLICIT_CAST*/T6 r544extra_bracket_flag(T544*C);
/*IMPLICIT_CAST*/T0*r544static_simplify(T544*C);
/*IMPLICIT_CAST*/void r544inline_dynamic_dispatch_(T544*C,T0*a1,T0*a2);
/*IMPLICIT_CAST*/void r544safety_check(T544*C,T0*a1);
/*IMPLICIT_CAST*/T6 r544is_writable(T544*C);
/*IMPLICIT_CAST*/T6 r544is_result(T544*C);
/*IMPLICIT_CAST*/T2 r544precedence(T544*C);
/*IMPLICIT_CAST*/T0*r544specialize_thru(T544*C,T0*a1,T0*a2,T0*a3);
/*IMPLICIT_CAST*/T6 r544is_static(T544*C);
/*IMPLICIT_CAST*/T6 r544is_stored_in_some_local_variable(void);
/*IMPLICIT_CAST*/void r544accept(T544*C,T0*a1);
/*IMPLICIT_CAST*/T0*r544adapt_for(T544*C,T0*a1);
/*IMPLICIT_CAST*/T0*r544collect(T544*C,T0*a1);
/*IMPLICIT_CAST*/T6 r544is_current(void);
/*IMPLICIT_CAST*/void r544pretty_target(T544*C,T2 a1);
/*IMPLICIT_CAST*/T351 r544start_position(T544*C);
/*IMPLICIT_CAST*/T0*r544twin(T544*C);
/*IMPLICIT_CAST*/T0*r544written_declaration_type_mark(T544*C);
/*IMPLICIT_CAST*/T6 r544use_current(T544*C,T0*a1);
/*IMPLICIT_CAST*/void r544bracketed_pretty(T544*C,T2 a1);
/*IMPLICIT_CAST*/T6 r544is_void(T544*C);
/*IMPLICIT_CAST*/T0*r544non_void_no_dispatch_type(T0*a1);
/*IMPLICIT_CAST*/T6 r544side_effect_free(T544*C,T0*a1);
/*IMPLICIT_CAST*/T6 r544is_manifest_string(T544*C);
/*IMPLICIT_CAST*/T0*r544resolve_in(T544*C,T0*a1);
/*IMPLICIT_CAST*/T0*r544to_instruction(T544*C);
/*AGENT_EXPRESSION*/T0*r677specialize_and_check(T677*C,T0*a1);
/*AGENT_EXPRESSION*/T0*r677to_expression(T677*C);
/*AGENT_EXPRESSION*/void r677make(T677*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*AGENT_EXPRESSION*/void r677agent_launcher_collect(T677*C,T0*a1);
/*AGENT_EXPRESSION*/void r677pretty(T677*C,T2 a1);
/*AGENT_EXPRESSION*/T0*r677simplify(T677*C,T0*a1);
/*AGENT_EXPRESSION*/T0*r677static_simplify(T677*C);
/*AGENT_EXPRESSION*/void r677inline_dynamic_dispatch_(T677*C,T0*a1,T0*a2);
/*AGENT_EXPRESSION*/void r677safety_check(T677*C,T0*a1);
/*AGENT_EXPRESSION*/void r677init(T677*C,T0*a1,T0*a2);
/*AGENT_EXPRESSION*/T0*r677specialize_thru(T677*C,T0*a1,T0*a2,T0*a3);
/*AGENT_EXPRESSION*/void r677specialize_check(T677*C,T0*a1);
/*AGENT_EXPRESSION*/T6 r677is_stored_in_some_local_variable(void);
/*AGENT_EXPRESSION*/void r677accept(T677*C,T0*a1);
/*AGENT_EXPRESSION*/T0*r677adapt_for(T677*C,T0*a1);
/*AGENT_EXPRESSION*/T0*r677collect(T677*C,T0*a1);
/*AGENT_EXPRESSION*/void r677pretty_target(T677*C,T2 a1);
/*AGENT_EXPRESSION*/T351 r677start_position(T677*C);
/*AGENT_EXPRESSION*/T0*r677feature_name(T677*C);
/*AGENT_EXPRESSION*/T0*r677twin(T677*C);
/*AGENT_EXPRESSION*/T0*r677written_declaration_type_mark(T677*C);
/*AGENT_EXPRESSION*/T6 r677use_current(T677*C,T0*a1);
/*AGENT_EXPRESSION*/void r677bracketed_pretty(T677*C,T2 a1);
/*AGENT_EXPRESSION*/T0*r677non_void_no_dispatch_type(T0*a1);
/*AGENT_EXPRESSION*/T6 r677side_effect_free(T0*a1);
/*AGENT_EXPRESSION*/T0*r677error_handler(void);
/*AGENT_EXPRESSION*/T0*r677resolve_in(T677*C,T0*a1);
/*AGENT_EXPRESSION*/T0*r677to_instruction(T677*C);
/*AGENT_EXPRESSION*/T0*r677current_or_twin_init(T677*C,T0*a1,T0*a2);
/*VOID_PROC_CALL*/T578*create578make(T351 a1,T0*a2,T0*a3);
/*VOID_PROC_CALL*/T0*r578to_expression(T578*C);
/*VOID_PROC_CALL*/void r578make(T578*C,T351 a1,T0*a2,T0*a3);
/*VOID_PROC_CALL*/T0*r578simplify(T578*C,T0*a1);
/*VOID_PROC_CALL*/void r578inline_dynamic_dispatch_(T578*C,T0*a1,T0*a2);
/*VOID_PROC_CALL*/void r578safety_check(T578*C,T0*a1);
/*VOID_PROC_CALL*/void r578accept(T578*C,T0*a1);
/*VOID_PROC_CALL*/T6 r578use_current(T0*a1);
/*VOID_PROC_CALL*/T6 r578side_effect_free(T0*a1);
/*VOID_PROC_CALL*/T0*r578error_handler(void);
/*VOID_PROC_CALL*/T0*r578inline_dynamic_dispatch(T578*C,T0*a1,T0*a2);
/*VOID_PROC_CALL*/T0*r578to_instruction(T578*C);
/*AGENT_INSTRUCTION*/T0*r685specialize_and_check(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/T0*r685to_expression(T685*C);
/*AGENT_INSTRUCTION*/void r685make(T685*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5);
/*AGENT_INSTRUCTION*/void r685agent_launcher_collect(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/T0*r685simplify(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/void r685inline_dynamic_dispatch_(T685*C,T0*a1,T0*a2);
/*AGENT_INSTRUCTION*/void r685safety_check(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/void r685init(T685*C,T0*a1,T0*a2);
/*AGENT_INSTRUCTION*/T0*r685specialize_thru(T685*C,T0*a1,T0*a2,T0*a3);
/*AGENT_INSTRUCTION*/void r685specialize_check(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/void r685accept(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/T0*r685adapt_for(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/T0*r685collect(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/T351 r685start_position(T685*C);
/*AGENT_INSTRUCTION*/T0*r685feature_name(T685*C);
/*AGENT_INSTRUCTION*/T0*r685twin(T685*C);
/*AGENT_INSTRUCTION*/T6 r685use_current(T685*C,T0*a1);
/*AGENT_INSTRUCTION*/T6 r685side_effect_free(T0*a1);
/*AGENT_INSTRUCTION*/T0*r685error_handler(void);
/*AGENT_INSTRUCTION*/T0*r685inline_dynamic_dispatch(T685*C,T0*a1,T0*a2);
/*AGENT_INSTRUCTION*/T0*r685to_instruction(T685*C);
/*AGENT_INSTRUCTION*/T0*r685current_or_twin_init(T685*C,T0*a1,T0*a2);
/*MANIFEST_STRING_INSPECTOR*/void r764make(T764*C,T0*a1);
/*MANIFEST_STRING_INSPECTOR*/T0*r764simplify(T764*C,T0*a1,T0*a2);
/*MANIFEST_STRING_INSPECTOR*/T0*r764strings(void);
/*MANIFEST_STRING_INSPECTOR*/T0*r764inline_inspect(T764*C,T0*a1,T0*a2,T0*a3,T0*a4,T0*a5,T351 a6);
/*MANIFEST_STRING_INSPECTOR*/T6 r764has_empty(T764*C);
/*MANIFEST_STRING_INSPECTOR*/T0*r764error_handler(void);
/*CODE_COMPARATOR*/void r765visit_assignment(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_debug_compound(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_argument_name_ref(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_class_invariant(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_void_call(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_create_expression(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_fake_tuple(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_e_false(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_native_array_item(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_implicit_cast(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_integer_constant(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_run_time_error_instruction(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_manifest_string_inspect_statement(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_compound_expression(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_precursor_instruction(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_dynamic_dispatch_temporary1_id(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_old_manifest_array(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_sedb(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_require_assertion(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_c_inline(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_create_instruction(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_generator_generating_type(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_effective_arg_list_n(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_implicit_current(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_local_name_ref(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_check_compound(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_compound(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_ifthen_exp(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_ifthenelse_exp(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_call_infix_or_else(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_real_constant(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_agent_creation(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_static_call_0_c(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_assignment_call_assigner(T765*C,T0*a1);
/*CODE_COMPARATOR*/T6 r765trace_in(T765*C,T0*a1,T0*a2,T0*a3);
/*CODE_COMPARATOR*/void r765visit_call_infix(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_no_dispatch(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_character_constant(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_dynamic_dispatch_temporary1(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_null_pointer(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_dynamic_dispatch_temporary2(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_e_true(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_ensure_assertion(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_procedure_call_n(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_natural_constant(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_call_infix_implies(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_assignment_attempt(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_assignment_test(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_written_current(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_retry_instruction(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_expression_with_comment(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_other_inspect_statement(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_assertion(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_function_call_0(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_manifest_string(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_function_call_1(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_non_void_no_dispatch(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_manifest_tuple(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_closed_operand(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_when_clause(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_ifthen(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_open_operand(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_call_infix_and_then(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_e_old(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_ifthenelse(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_create_writable(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_fake_target(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_call_prefix(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_writable_attribute_name(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_unused_expression(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_internal_local2(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_procedure_call_1(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_address_of(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_loop_instruction(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_procedure_call_0(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_fake_argument(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_void_proc_call(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_raw_create_instruction(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_e_void(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_agent_expression(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_loop_variant(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_manifest_generic(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_built_in_eq_neq(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_precursor_expression(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_agent_instruction(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_assertion_list(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_effective_arg_list_0(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_no_invariant_wrapper(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_result(T765*C,T0*a1);
/*CODE_COMPARATOR*/void r765visit_function_call_n(T765*C,T0*a1);
/*NUMBER_TOOLS*/T0*r320from_integer_64(T11 a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_compound(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128not_yet_implemented(T128*C);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_check_compound(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_procedure_call_n(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_once_function(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_native_plug_in(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_manifest_generic(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_run_time_error_instruction(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_fake_target(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_no_dispatch(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_call(T128*C,T0*a1,T0*a2);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_ifthenelse_exp(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T6 r128visit_once_body(T128*C,T0*a1,T0*a2);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_precursor_instruction(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_local_var_list(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_anonymous_feature(T128*C,T0*a1,T0*a2,T0*a3);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_address_of(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_procedure_call_1(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_procedure_call_0(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_inspect_statement(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_native_built_in(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_assertion_list(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_function_call_n(T128*C,T0*a1);
extern T0*oBC128anonymous_feature_stack;
extern int fBC128anonymous_feature_stack;
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T0*r128anonymous_feature_stack(void);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_retry_instruction(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_c_inline(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_assignment_test(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_no_invariant_wrapper(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_implicit_cast(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_once_procedure(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_deferred_procedure(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_effective_arg_list_n(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_create_expression(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_external_procedure(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_when_clause(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_built_in_eq_neq(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_manifest_tuple(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_fake_tuple(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_debug_compound(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_e_procedure(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_agent_instruction(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_closed_operand(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_call_1(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_call_0(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_deferred_function(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_void_call(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_unused_expression(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_writable_attribute(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_native_array_item(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_e_old(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_agent_creation(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T6 r128can_be_dropped(T128*C,T0*a1,T0*a2,T0*a3);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128crash(T128*C);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_ifthenelse(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_create_instruction(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_assertion(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_loop_instruction(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_e_function(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_ifthen(T128*C,T0*a1);
extern T0*oBC128type_stack;
extern int fBC128type_stack;
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T0*r128type_stack(void);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_assignment_call_assigner(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/T6 r128visit_once_then(T128*C,T0*a1,T0*a2);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_native_c_plus_plus(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_fast_array_of_expression(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_external_function(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_require_assertion(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_compound_expression(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_native_c(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_agent_expression(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_open_operand(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_void_proc_call(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_assignment_attempt(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_fake_argument(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_precursor_expression(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_expression_with_comment(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_ifthen_exp(T128*C,T0*a1);
/*PRECOMPUTABLE_ROUTINE_DETECTOR*/void r128visit_assignment(T128*C,T0*a1);
/*RUN_FEATURE_8*/T2 r770arg_count(T770*C);
/*RUN_FEATURE_8*/void r770compute_use_current(T770*C);
/*RUN_FEATURE_8*/void r770std_compute_use_current(T770*C);
/*RUN_FEATURE_8*/void r770for(T770*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_8*/void r770accept(T770*C,T0*a1);
/*RUN_FEATURE_8*/void r770set_result_type(T770*C);
/*RUN_FEATURE_8*/T351 r770start_position(T770*C);
/*RUN_FEATURE_8*/T6 r770use_current(T770*C);
/*RUN_FEATURE_8*/void r770mapping_name_in(T770*C,T0*a1);
/*RUN_FEATURE_8*/void r770do_adapt(T770*C);
/*RUN_FEATURE_8*/void r770adapt(T770*C);
/*RUN_FEATURE_8*/T0*r770feature_stamp(T770*C);
/*EXCEPTIONS_HANDLER*/void r122se_evobt(T122*C);
/*EXCEPTIONS_HANDLER*/void r122customize_c_runtime(T122*C);
/*EXCEPTIONS_HANDLER*/T0*r122cpp(void);
/*EXCEPTIONS_HANDLER*/void r122initialize_runtime(T122*C);
/*EXCEPTIONS_HANDLER*/void r122bad_inspect_value(T122*C,T351 a1);
/*STATIC_CALL_0_C*/T0*r429declaration_type(T429*C);
/*STATIC_CALL_0_C*/T0*r429adapt_for(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429resolve_in(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429use_current_stack(void);
/*STATIC_CALL_0_C*/T0*r429collect(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429specialize_in(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429written_declaration_type_mark(T429*C);
/*STATIC_CALL_0_C*/T0*r429simplify(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429arguments(void);
/*STATIC_CALL_0_C*/void r429pretty_target(T429*C,T2 a1);
/*STATIC_CALL_0_C*/void r429safety_check(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429to_expression(T429*C);
/*STATIC_CALL_0_C*/T0*r429specialize_thru(T429*C,T0*a1,T0*a2,T0*a3);
/*STATIC_CALL_0_C*/T0*r429manifest_expression(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429feature_accumulator(void);
/*STATIC_CALL_0_C*/T0*r429specialize_and_check(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T6 r429simplify_limit_reached(T429*C);
/*STATIC_CALL_0_C*/void r429inline_dynamic_dispatch_(T429*C,T0*a1,T0*a2);
/*STATIC_CALL_0_C*/T0*r429to_instruction(T429*C);
/*STATIC_CALL_0_C*/T0*r429current_or_twin_init(T429*C,T0*a1,T0*a2);
/*STATIC_CALL_0_C*/void r429standard_check_export_and_obsolete_calls(T429*C,T0*a1,T0*a2,T0*a3);
/*STATIC_CALL_0_C*/void r429make(T429*C,T0*a1,T0*a2);
/*STATIC_CALL_0_C*/T0*r429echo(void);
/*STATIC_CALL_0_C*/void r429type_id_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*STATIC_CALL_0_C*/void r429non_void_check(T0*a1,T0*a2,T0*a3,T0*a4);
/*STATIC_CALL_0_C*/T6 r429use_current(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429static_simplify(T429*C);
/*STATIC_CALL_0_C*/T0*r429extra_local_expanded(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T6 r429function_check(T429*C,T0*a1,T0*a2);
/*STATIC_CALL_0_C*/void r429pretty(T429*C,T2 a1);
/*STATIC_CALL_0_C*/T6 r429side_effect_free(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429non_void_no_dispatch_type(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429inline_with(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T0*r429twin(T429*C);
/*STATIC_CALL_0_C*/void r429bracketed_pretty(T429*C,T2 a1);
/*STATIC_CALL_0_C*/T0*r429error_handler(void);
/*STATIC_CALL_0_C*/void r429accept(T429*C,T0*a1);
/*STATIC_CALL_0_C*/T351 r429start_position(T429*C);
/*STATIC_CALL_0_C*/T6 r429is_stored_in_some_local_variable(void);
/*RAW_CREATE_INSTRUCTION*/T0*r426specialize_and_check(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426to_expression(T426*C);
/*RAW_CREATE_INSTRUCTION*/void r426make(T426*C,T351 a1,T0*a2,T0*a3);
/*RAW_CREATE_INSTRUCTION*/T0*r426created_type(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/void r426typed_internals(T426*C,T351 a1,T0*a2);
/*RAW_CREATE_INSTRUCTION*/void r426pretty(T426*C,T2 a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426simplify(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426specialize_in(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/void r426inline_dynamic_dispatch_(T426*C,T0*a1,T0*a2);
/*RAW_CREATE_INSTRUCTION*/void r426safety_check(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/void r426set_call(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/void r426init(T426*C,T0*a1,T0*a2,T0*a3);
/*RAW_CREATE_INSTRUCTION*/void r426specialize_checks(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426specialize_thru(T426*C,T0*a1,T0*a2,T0*a3);
/*RAW_CREATE_INSTRUCTION*/void r426accept(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/void r426set_eiffel_parser_stamp(T426*C,T2 a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426adapt_for(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426default_create_name(void);
/*RAW_CREATE_INSTRUCTION*/T0*r426collect(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426any_default_create_fs(void);
/*RAW_CREATE_INSTRUCTION*/T0*r426twin(T426*C);
/*RAW_CREATE_INSTRUCTION*/T0*r426creation_procedure(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/T6 r426use_current(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/T6 r426side_effect_free(T0*a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426arguments(T426*C);
/*RAW_CREATE_INSTRUCTION*/T0*r426error_handler(void);
/*RAW_CREATE_INSTRUCTION*/T0*r426inline_dynamic_dispatch(T426*C,T0*a1,T0*a2);
/*RAW_CREATE_INSTRUCTION*/void r426make_specialized(T426*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*RAW_CREATE_INSTRUCTION*/void r426create_instruction_make(T426*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*RAW_CREATE_INSTRUCTION*/T0*r426to_instruction(T426*C);
/*RAW_CREATE_INSTRUCTION*/T0*r426specialize_without_checks(T426*C,T0*a1);
/*RAW_CREATE_INSTRUCTION*/T0*r426current_or_twin_init(T426*C,T0*a1,T0*a2,T0*a3);
/*GENERATOR_GENERATING_TYPE*/T0*r380to_expression(T380*C);
/*GENERATOR_GENERATING_TYPE*/T0*r380simplify(T380*C,T0*a1);
/*GENERATOR_GENERATING_TYPE*/T0*r380static_simplify(T380*C);
/*GENERATOR_GENERATING_TYPE*/void r380inline_dynamic_dispatch_(T380*C,T0*a1,T0*a2);
/*GENERATOR_GENERATING_TYPE*/void r380make_generating_type(T380*C,T351 a1,T0*a2);
/*GENERATOR_GENERATING_TYPE*/T6 r380is_stored_in_some_local_variable(void);
/*GENERATOR_GENERATING_TYPE*/void r380accept(T380*C,T0*a1);
extern T0*oBC380declaration_type;
extern int fBC380declaration_type;
/*GENERATOR_GENERATING_TYPE*/T0*r380declaration_type(void);
/*GENERATOR_GENERATING_TYPE*/T0*r380collect(T380*C,T0*a1);
/*GENERATOR_GENERATING_TYPE*/T0*r380twin(T380*C);
extern T0*oBC380written_declaration_type_mark;
extern int fBC380written_declaration_type_mark;
/*GENERATOR_GENERATING_TYPE*/T0*r380written_declaration_type_mark(void);
/*GENERATOR_GENERATING_TYPE*/T6 r380use_current(T0*a1);
/*GENERATOR_GENERATING_TYPE*/T0*r380non_void_no_dispatch_type(T0*a1);
/*GENERATOR_GENERATING_TYPE*/T6 r380side_effect_free(T0*a1);
/*GENERATOR_GENERATING_TYPE*/void r380make_generator(T380*C,T351 a1,T0*a2);
/*GENERATOR_GENERATING_TYPE*/T0*r380resolve_in(T0*a1);
/*GENERATOR_GENERATING_TYPE*/T0*r380to_instruction(T380*C);
/*RUN_FEATURE_1*/T0*r820require_assertion(void);
/*RUN_FEATURE_1*/void r820for(T820*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_1*/void r820accept(T820*C,T0*a1);
/*RUN_FEATURE_1*/void r820set_result_type(T820*C);
/*RUN_FEATURE_1*/T351 r820start_position(T820*C);
/*RUN_FEATURE_1*/T6 r820use_current(T820*C);
/*RUN_FEATURE_1*/void r820mapping_name_in(T820*C,T0*a1);
/*RUN_FEATURE_1*/void r820adapt(T820*C);
/*RUN_FEATURE_1*/T0*r820feature_stamp(T820*C);
/*RUN_FEATURE_6*/void r663compute_use_current(T663*C);
/*RUN_FEATURE_6*/void r663std_compute_use_current(T663*C);
/*RUN_FEATURE_6*/void r663for(T663*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_6*/void r663accept(T663*C,T0*a1);
/*RUN_FEATURE_6*/void r663set_result_type(T663*C);
/*RUN_FEATURE_6*/T351 r663start_position(T663*C);
/*RUN_FEATURE_6*/T6 r663use_current(T663*C);
/*RUN_FEATURE_6*/void r663mapping_name_in(T663*C,T0*a1);
/*RUN_FEATURE_6*/void r663do_adapt(T663*C);
/*RUN_FEATURE_6*/void r663adapt(T663*C);
/*RUN_FEATURE_6*/T0*r663feature_stamp(T663*C);
/*RUN_FEATURE_6*/T6 r663is_precomputable_once(T663*C);
/*RUN_FEATURE_9*/void r818for(T818*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_9*/void r818accept(T818*C,T0*a1);
/*RUN_FEATURE_9*/void r818set_result_type(T818*C);
/*RUN_FEATURE_9*/T351 r818start_position(T818*C);
/*RUN_FEATURE_9*/T6 r818use_current(T818*C);
/*RUN_FEATURE_9*/void r818mapping_name_in(T818*C,T0*a1);
/*RUN_FEATURE_9*/void r818do_adapt(T818*C);
/*RUN_FEATURE_9*/void r818adapt(T818*C);
/*RUN_FEATURE_9*/T0*r818feature_stamp(T818*C);
/*RUN_FEATURE_7*/T2 r771arg_count(T771*C);
/*RUN_FEATURE_7*/void r771compute_use_current(T771*C);
/*RUN_FEATURE_7*/void r771std_compute_use_current(T771*C);
/*RUN_FEATURE_7*/void r771for(T771*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_7*/void r771accept(T771*C,T0*a1);
/*RUN_FEATURE_7*/T351 r771start_position(T771*C);
/*RUN_FEATURE_7*/T6 r771use_current(T771*C);
/*RUN_FEATURE_7*/void r771mapping_name_in(T771*C,T0*a1);
/*RUN_FEATURE_7*/void r771do_adapt(T771*C);
/*RUN_FEATURE_7*/void r771adapt(T771*C);
/*RUN_FEATURE_7*/T0*r771feature_stamp(T771*C);
/*NATIVE_ARRAY_ITEM*/T0*r669specialize_and_check(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/T0*r669to_expression(T669*C);
/*NATIVE_ARRAY_ITEM*/void r669make(T669*C,T351 a1,T0*a2,T0*a3);
/*NATIVE_ARRAY_ITEM*/T0*r669simplify(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/void r669make_(T669*C,T351 a1,T0*a2,T0*a3,T0*a4);
/*NATIVE_ARRAY_ITEM*/T0*r669static_simplify(T669*C);
/*NATIVE_ARRAY_ITEM*/T0*r669specialize_in(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/void r669inline_dynamic_dispatch_(T669*C,T0*a1,T0*a2);
/*NATIVE_ARRAY_ITEM*/void r669safety_check(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/void r669make_array(T669*C,T351 a1,T0*a2,T0*a3);
/*NATIVE_ARRAY_ITEM*/T0*r669specialize_thru(T669*C,T0*a1,T0*a2,T0*a3);
/*NATIVE_ARRAY_ITEM*/T6 r669is_stored_in_some_local_variable(void);
/*NATIVE_ARRAY_ITEM*/void r669accept(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/T0*r669adapt_for(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/T0*r669collect(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/T0*r669twin(T669*C);
/*NATIVE_ARRAY_ITEM*/T0*r669written_declaration_type_mark(T669*C);
/*NATIVE_ARRAY_ITEM*/T6 r669use_current(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/T0*r669non_void_no_dispatch_type(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/T6 r669side_effect_free(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/T0*r669resolve_in(T669*C,T0*a1);
/*NATIVE_ARRAY_ITEM*/T0*r669to_instruction(T669*C);
/*RUN_FEATURE_3*/void r553compute_use_current(T553*C);
/*RUN_FEATURE_3*/void r553std_compute_use_current(T553*C);
/*RUN_FEATURE_3*/void r553for(T553*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_3*/T6 r553empty_body_side_effect_free_in_boost(T553*C);
/*RUN_FEATURE_3*/T6 r553is_empty_or_null_body(T553*C);
/*RUN_FEATURE_3*/void r553accept(T553*C,T0*a1);
/*RUN_FEATURE_3*/T351 r553start_position(T553*C);
/*RUN_FEATURE_3*/T0*r553memory_dispose(T553*C);
/*RUN_FEATURE_3*/T6 r553use_current(T553*C);
/*RUN_FEATURE_3*/void r553mapping_name_in(T553*C,T0*a1);
/*RUN_FEATURE_3*/void r553do_adapt(T553*C);
/*RUN_FEATURE_3*/T6 r553side_effect_free(T553*C);
/*RUN_FEATURE_3*/void r553adapt(T553*C);
/*RUN_FEATURE_3*/T0*r553feature_stamp(T553*C);
/*RUN_FEATURE_4*/void r819compute_use_current(T819*C);
/*RUN_FEATURE_4*/void r819std_compute_use_current(T819*C);
/*RUN_FEATURE_4*/void r819for(T819*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_4*/void r819accept(T819*C,T0*a1);
/*RUN_FEATURE_4*/void r819set_result_type(T819*C);
/*RUN_FEATURE_4*/T351 r819start_position(T819*C);
/*RUN_FEATURE_4*/T6 r819use_current(T819*C);
/*RUN_FEATURE_4*/void r819mapping_name_in(T819*C,T0*a1);
/*RUN_FEATURE_4*/void r819do_adapt(T819*C);
/*RUN_FEATURE_4*/void r819adapt(T819*C);
/*RUN_FEATURE_4*/T0*r819feature_stamp(T819*C);
/*RUN_FEATURE_5*/void r662compute_use_current(T662*C);
/*RUN_FEATURE_5*/void r662std_compute_use_current(T662*C);
/*RUN_FEATURE_5*/void r662for(T662*C,T0*a1,T0*a2,T0*a3);
/*RUN_FEATURE_5*/void r662accept(T662*C,T0*a1);
/*RUN_FEATURE_5*/T351 r662start_position(T662*C);
/*RUN_FEATURE_5*/T6 r662use_current(T662*C);
/*RUN_FEATURE_5*/void r662mapping_name_in(T662*C,T0*a1);
/*RUN_FEATURE_5*/void r662do_adapt(T662*C);
/*RUN_FEATURE_5*/void r662adapt(T662*C);
/*RUN_FEATURE_5*/T0*r662feature_stamp(T662*C);
/*COUNTER*/void r350next(T350*C);
/*COUNTER*/void r350increment(T350*C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871put_line(T871*C,T0*a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871make(T871*C,T0*a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871filtered_put_character(T871*C,T3 a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871create_pipe(T871*C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871flush(T871*C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871put_string(T871*C,T0*a1);
/*EXEC_OUTPUT_STREAM_POSIX*/T0*r871tmp_string(void);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871put_real_format(T871*C,T5 a1,T2 a2);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871put_integer(T871*C,T11 a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871filtered_flush(T871*C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871put_abstract_string(T871*C,T0*a1);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871dispose(T871*C);
/*EXEC_OUTPUT_STREAM_POSIX*/void r871disconnect(T871*C);
/*EXEC_OUTPUT_STREAM_POSIX*/T0*r871as_output_stream(T871*C);
/*EXEC_INPUT_STREAM_POSIX*/void r873make(T873*C,T0*a1);
/*EXEC_INPUT_STREAM_POSIX*/void r873filtered_read_character(T873*C);
/*EXEC_INPUT_STREAM_POSIX*/void r873create_pipe(T873*C);
/*EXEC_INPUT_STREAM_POSIX*/void r873swap_unread_buffer(T873*C);
/*EXEC_INPUT_STREAM_POSIX*/void r873dispose(T873*C);
/*EXEC_INPUT_STREAM_POSIX*/void r873disconnect(T873*C);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874put_line(T874*C,T0*a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874make(T874*C,T0*a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874filtered_put_character(T874*C,T3 a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874create_pipe(T874*C);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874flush(T874*C);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874put_string(T874*C,T0*a1);
/*EXEC_OUTPUT_STREAM_WIN32*/T0*r874tmp_string(void);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874put_real_format(T874*C,T5 a1,T2 a2);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874put_integer(T874*C,T11 a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874filtered_flush(T874*C);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874put_abstract_string(T874*C,T0*a1);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874dispose(T874*C);
/*EXEC_OUTPUT_STREAM_WIN32*/void r874disconnect(T874*C);
/*EXEC_OUTPUT_STREAM_WIN32*/T0*r874as_output_stream(T874*C);
/*EXEC_INPUT_STREAM_WIN32*/void r875make(T875*C,T0*a1);
/*EXEC_INPUT_STREAM_WIN32*/void r875filtered_read_character(T875*C);
/*EXEC_INPUT_STREAM_WIN32*/void r875create_pipe(T875*C);
/*EXEC_INPUT_STREAM_WIN32*/void r875swap_unread_buffer(T875*C);
/*EXEC_INPUT_STREAM_WIN32*/void r875dispose(T875*C);
/*EXEC_INPUT_STREAM_WIN32*/void r875disconnect(T875*C);
/*FAKE_TUPLE*/T0*r674specialize_and_check(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674to_expression(T674*C);
/*FAKE_TUPLE*/void r674make(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674simplify(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674static_simplify(T674*C);
/*FAKE_TUPLE*/T0*r674specialize_in(T674*C,T0*a1);
/*FAKE_TUPLE*/void r674inline_dynamic_dispatch_(T674*C,T0*a1,T0*a2);
/*FAKE_TUPLE*/T0*r674expression(T674*C,T2 a1);
/*FAKE_TUPLE*/void r674safety_check(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674implicit_cast(T674*C,T0*a1,T0*a2);
/*FAKE_TUPLE*/T0*r674specialize_thru(T674*C,T0*a1,T0*a2,T0*a3);
/*FAKE_TUPLE*/T6 r674is_stored_in_some_local_variable(void);
/*FAKE_TUPLE*/void r674accept(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674adapt_for(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674declaration_type(T674*C);
/*FAKE_TUPLE*/T0*r674collect(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674inline_dynamic_dispatch_of(T0*a1,T0*a2,T0*a3);
/*FAKE_TUPLE*/T0*r674twin(T674*C);
/*FAKE_TUPLE*/T0*r674written_declaration_type_mark(T674*C);
/*FAKE_TUPLE*/T6 r674use_current(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674non_void_no_dispatch_type(T0*a1);
/*FAKE_TUPLE*/T6 r674side_effect_free(T0*a1);
/*FAKE_TUPLE*/T0*r674error_handler(void);
/*FAKE_TUPLE*/T2 r674count(T674*C);
/*FAKE_TUPLE*/T0*r674resolve_in(T674*C,T0*a1);
/*FAKE_TUPLE*/T0*r674to_instruction(T674*C);
/*TUPLE_STRING_POOL*/void r869count_states(T869*C);
extern T0*oBC870counter;
/*TUPLE_STRING_POOL*/void r869make_transitions_array(T869*C);
extern T0*oBC870transition_memory;
extern int fBC870transition_memory;
/*TUPLE_STRING_POOL*/T0*r869transition_memory(void);
/*TUPLE_STRING_POOL*/T2 r869external_state(T869*C,T2 a1);
/*TUPLE_STRING_POOL*/T2 r869the_final_state(T869*C,T0*a1,T2 a2,T2 a3);
/*TUPLE_STRING_POOL*/void r869externalize_tags(T869*C,T0*a1);
/*TUPLE_STRING_POOL*/void r869set_state(T869*C,T2 a1,T2 a2,T3 a3);
/*TUPLE_STRING_POOL*/T2 r869state(T869*C,T2 a1,T3 a2);
/*TUPLE_STRING_POOL*/void r869compile_headers(T869*C);
/*TUPLE_STRING_POOL*/void r869from_collection(T869*C,T0*a1);
/*TUPLE_STRING_POOL*/T0*r869transition(T869*C,T2 a1);
/*INTEGER_64_NUMBER*/void r738make(T738*C,T11 a1);
/*INTEGER_64_NUMBER*/T11 r738to_integer_64(T738*C);
/*INTEGER_64_NUMBER*/T0*r738multiply_with_big_integer_number(T738*C,T0*a1);
extern T0*oBC319zero;
extern T0*oBC319mutable_register1;
extern int fBC319mutable_register1;
/*INTEGER_64_NUMBER*/T0*r738mutable_register1(void);
extern T0*oBC319mutable_register2;
extern int fBC319mutable_register2;
/*INTEGER_64_NUMBER*/T0*r738mutable_register2(void);
extern T0*oBC319mutable_register3;
extern int fBC319mutable_register3;
/*INTEGER_64_NUMBER*/T0*r738mutable_register3(void);
/*INTEGER_64_NUMBER*/T0*r738_ix_42(T738*C,T0*a1);
/*INTEGER_64_NUMBER*/T0*r738_ix_43(T738*C,T0*a1);
/*INTEGER_64_NUMBER*/T6 r738is_integer_32(T738*C);
/*INTEGER_64_NUMBER*/T0*r738_px_45(T738*C);
/*INTEGER_64_NUMBER*/T0*r738_ix_45(T738*C,T0*a1);
/*INTEGER_64_NUMBER*/T6 r738is_integer_16(T738*C);
/*INTEGER_64_NUMBER*/T0*r738add_with_big_integer_number(T738*C,T0*a1);
/*INTEGER_64_NUMBER*/T6 r738is_integer_8(T738*C);
/*INTEGER_64_NUMBER*/T0*r738_ix_6442(T738*C,T11 a1);
/*INTEGER_64_NUMBER*/T0*r738_ix_6443(T738*C,T11 a1);
/*INTEGER_64_NUMBER*/T10 r738to_integer_16(T738*C);
/*INTEGER_64_NUMBER*/T0*r738to_string(T738*C);
/*INTEGER_64_NUMBER*/T1 r738to_integer_8(T738*C);
/*INTEGER_64_NUMBER*/T2 r738to_integer_32(T738*C);
/*INTEGER_64_NUMBER*/void r738append_in(T738*C,T0*a1);
extern T0*oBC319string_buffer;
extern int fBC319string_buffer;
/*INTEGER_64_NUMBER*/T0*r738string_buffer(void);
/*C_PLUGIN*/T6 r904is_equal(T904*C,T0*a1);
/*C_PLUGIN*/void r904make(T904*C,T351 a1,T0*a2,T0*a3);
/*C_PLUGIN*/void r904plugin_echo(T904*C,T0*a1);
/*C_PLUGIN*/void r904add_c_source(T904*C,T0*a1);
/*C_PLUGIN*/T0*r904echo(void);
/*C_PLUGIN*/void r904add_c_header(T904*C,T0*a1);
extern T0*oBC555tfr;
/*C_PLUGIN*/T0*r904cpp(void);
/*C_PLUGIN*/void r904read_auto_init(T904*C,T0*a1);
/*C_PLUGIN*/T0*r904system_tools(void);
/*C_PLUGIN*/T0*r904absolute_path(T904*C,T0*a1);
/*C_PLUGIN*/void r904try_auto_init(T904*C);
/*C_PLUGIN*/T0*r904error_handler(void);
/*C_PLUGIN*/T0*r904parser_buffer(void);
/*C_PLUGIN*/void r904include(T904*C,T351 a1);
/*C_PLUGIN*/T0*r904read(T0*a1);
/*INTERNAL_C_LOCAL*/void r577make(T577*C,T2 a1,T0*a2,T0*a3);
/*INTERNAL_C_LOCAL*/T0*r577lock_local(T577*C,T0*a1,T0*a2,T0*a3);
/*INTERNAL_C_LOCAL*/void r577unlock(T577*C);
extern T0*oBC577counter;
/*INTERNAL_C_LOCAL*/T6 r577declaration_dump(T577*C,T0*a1);
/*INTERNAL_C_LOCAL*/T0*r577cpp(void);
/*INTERNAL_C_LOCAL*/T6 r577can_be_recycle_with_type(T577*C,T0*a1);
/*INTERNAL_C_LOCAL*/void r577c_type_in(T577*C,T0*a1);
/*INTERNAL_C_LOCAL*/void r577append_in(T577*C,T0*a1);
/*INTERNAL_C_LOCAL_LIST*/T0*r659lock_local(T0*a1,T0*a2,T0*a3);
/*INTERNAL_C_LOCAL_LIST*/T0*r659echo(void);
/*INTERNAL_C_LOCAL_LIST*/void r659declaration_dump(T659*C,T0*a1);
extern T0*oBC659internal_c_local_pool;
extern int fBC659internal_c_local_pool;
/*INTERNAL_C_LOCAL_LIST*/T0*r659internal_c_local_pool(void);
/*INTERNAL_C_LOCAL_LIST*/void r659echo_information(T659*C);
/*CODE_CONTEXT_DIRECT_CALL*/void r571reserve(T571*C);
/*CODE_CONTEXT_CREATE_INSTRUCTION*/void r572reserve(T572*C);
/*CODE_CONTEXT_CREATE_EXPRESSION*/void r573reserve(T573*C);
/*CODE_CONTEXT_INSIDE_TWIN*/void r574reserve(T574*C);
/*CODE_CONTEXT_PRECURSOR*/void r575reserve(T575*C);
/*CODE_CONTEXT_INSIDE_SOME_WRAPPER*/void r576reserve(T576*C);
/*C_SPLITTER_LEGACY_ITERATOR*/void r824make(T824*C,T2 a1);
/*C_SPLITTER_LEGACY_ITERATOR*/void r824next(T824*C);
/*C_SPLITTER_LEGACY_ITERATOR*/void r824start(T824*C);
/*C_SPLITTER_LEGACY_ITERATOR*/T0*r824item(T824*C);
/*TAGGED_FLAG*/void r841as_true(T841*C);
/*MUTABLE_BIG_INTEGER*/void r743subtract_magnitude_raw_reverse(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/T11 r743to_integer_64(T743*C);
/*MUTABLE_BIG_INTEGER*/T6 r743is_one_negative(T743*C);
/*MUTABLE_BIG_INTEGER*/T2 r743divide_one_word(T743*C,T2 a1);
/*MUTABLE_BIG_INTEGER*/void r743add(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/void r743copy(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/T6 r743is_integer_64(T743*C);
extern T0*oBC743char_buffer;
extern int fBC743char_buffer;
/*MUTABLE_BIG_INTEGER*/T0*r743char_buffer(void);
/*MUTABLE_BIG_INTEGER*/void r743subtract_magnitude_raw_truncated(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/void r743add_integer_64(T743*C,T11 a1);
/*MUTABLE_BIG_INTEGER*/void r743negate(T743*C);
/*MUTABLE_BIG_INTEGER*/T2 r743append_in_char_buffer(T743*C);
/*MUTABLE_BIG_INTEGER*/void r743subtract_magnitude_raw(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/T6 r743is_one(T743*C);
/*MUTABLE_BIG_INTEGER*/void r743multiply_to(T743*C,T0*a1,T0*a2);
/*MUTABLE_BIG_INTEGER*/void r743subtract_magnitude_raw_reverse_truncated(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/T2 r743capacity_from_upper_bound(T2 a1,T2 a2);
/*MUTABLE_BIG_INTEGER*/void r743multiply_to_like_human(T743*C,T0*a1,T0*a2);
/*MUTABLE_BIG_INTEGER*/T0*r743to_integer_general_number(T743*C);
extern T0*oBC743register1;
extern int fBC743register1;
/*MUTABLE_BIG_INTEGER*/T0*r743register1(void);
/*MUTABLE_BIG_INTEGER*/void r743set_with_zero(T743*C);
/*MUTABLE_BIG_INTEGER*/void r743from_integer(T743*C,T2 a1);
/*MUTABLE_BIG_INTEGER*/void r743subtract_magnitude(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/void r743from_native_array(T743*C,T1030 a1,T2 a2,T6 a3);
/*MUTABLE_BIG_INTEGER*/T2 r743capacity_from_lower_bound(T2 a1,T2 a2);
/*MUTABLE_BIG_INTEGER*/void r743add_magnitude(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/void r743set_all(T743*C,T1030 a1,T2 a2,T2 a3,T2 a4,T6 a5);
/*MUTABLE_BIG_INTEGER*/void r743append_in(T743*C,T0*a1);
/*MUTABLE_BIG_INTEGER*/void r743from_integer_64(T743*C,T11 a1);
/*BIG_INTEGER_NUMBER*/T11 r740to_integer_64(T740*C);
/*BIG_INTEGER_NUMBER*/T0*r740multiply_with_big_integer_number(T740*C,T0*a1);
/*BIG_INTEGER_NUMBER*/T0*r740mutable_register1(void);
/*BIG_INTEGER_NUMBER*/T0*r740mutable_register2(void);
/*BIG_INTEGER_NUMBER*/T0*r740mutable_register3(void);
/*BIG_INTEGER_NUMBER*/T0*r740_ix_42(T740*C,T0*a1);
/*BIG_INTEGER_NUMBER*/T0*r740_ix_43(T740*C,T0*a1);
/*BIG_INTEGER_NUMBER*/void r740put_into_mutable_big_integer(T740*C,T0*a1);
/*BIG_INTEGER_NUMBER*/T0*r740_ix_45(T740*C,T0*a1);
/*BIG_INTEGER_NUMBER*/T0*r740_px_45(T740*C);
/*BIG_INTEGER_NUMBER*/T0*r740add_with_big_integer_number(T740*C,T0*a1);
/*BIG_INTEGER_NUMBER*/T0*r740_ix_6442(T740*C,T11 a1);
/*BIG_INTEGER_NUMBER*/T0*r740_ix_6443(T740*C,T11 a1);
/*BIG_INTEGER_NUMBER*/T10 r740to_integer_16(T740*C);
/*BIG_INTEGER_NUMBER*/T0*r740to_string(T740*C);
/*BIG_INTEGER_NUMBER*/T1 r740to_integer_8(T740*C);
/*BIG_INTEGER_NUMBER*/void r740from_native_array(T740*C,T1030 a1,T2 a2,T6 a3);
/*BIG_INTEGER_NUMBER*/T2 r740to_integer_32(T740*C);
/*BIG_INTEGER_NUMBER*/void r740append_in(T740*C,T0*a1);
/*BIG_INTEGER_NUMBER*/T0*r740string_buffer(void);
/*TAGGED_INTERNAL_C_LOCAL*/void r816set_item(T816*C,T0*a1);
/*TAGGED_INTEGER*/void r814set_item(T814*C,T2 a1);
void agent_launcher_o340o7(/*agent*/T0*a,T0* a1,T0* a2);
void agent_launcher_o476(/*agent*/T0*a,T0* a1);
void agent_launcher(/*agent*/T0*a);
void agent_launcher_o286o286(/*agent*/T0*a,T0* a1,T0* a2);
void agent_launcher_o488(/*agent*/T0*a,T0* a1);
void agent_launcher_o495(/*agent*/T0*a,T0* a1);
T6 agent_launcher_R6_o7(/*agent*/T0*a,T0* a1);
void agent_launcher_o547(/*agent*/T0*a,T0* a1);
void agent_launcher_o344(/*agent*/T0*a,T0* a1);
void agent_launcher_o97(/*agent*/T0*a,T0* a1);
T6 agent_launcher_R6_o421o421(/*agent*/T0*a,T0* a1,T0* a2);
void agent_launcher_o89(/*agent*/T0*a,T0* a1);
void agent_launcher_o403(/*agent*/T0*a,T0* a1);
void agent_launcher_o87(/*agent*/T0*a,T0* a1);
void agent_launcher_o421(/*agent*/T0*a,T0* a1);
void agent_launcher_o583(/*agent*/T0*a,T0* a1);
T0* agent_launcher_R40(/*agent*/T0*a);
void agent_launcher_o383(/*agent*/T0*a,T0* a1);
void agent_launcher_o435(/*agent*/T0*a,T0* a1);
void agent_launcher_o468o2(/*agent*/T0*a,T0* a1,T2 a2);
void agent_launcher_o676(/*agent*/T0*a,T0* a1);
union _se_agent{T0 s0;se_agent0 u0;
se_agenT990f817l57c25 uagenT990f817l57c25;
se_agenT117f117l4348c33 uagenT117f117l4348c33;
se_agenT117f117l4337c30 uagenT117f117l4337c30;
se_agenT117f117l4074c47 uagenT117f117l4074c47;
se_agenT117f117l605c22 uagenT117f117l605c22;
se_agenT117f117l662c22 uagenT117f117l662c22;
se_agenT117f117l4093c55 uagenT117f117l4093c55;
se_agenT117f117l4033c48 uagenT117f117l4033c48;
se_agenT117f117l4054c48 uagenT117f117l4054c48;
se_agenT117f117l3847c41 uagenT117f117l3847c41;
se_agenT117f117l3764c40 uagenT117f117l3764c40;
se_agenT111f111l488c40 uagenT111f111l488c40;
se_agenT588f588l40c32 uagenT588f588l40c32;
se_agenT588f589l25c46 uagenT588f589l25c46;
se_agenT621f589l25c46 uagenT621f589l25c46;
se_agenT622f589l25c46 uagenT622f589l25c46;
se_agenT623f623l22c52 uagenT623f623l22c52;
se_agenT623f589l25c46 uagenT623f589l25c46;
se_agenT624f589l25c46 uagenT624f589l25c46;
se_agenT625f625l584c33 uagenT625f625l584c33;
se_agenT625f625l600c30 uagenT625f625l600c30;
se_agenT625f625l256c33 uagenT625f625l256c33;
se_agenT625f625l276c30 uagenT625f625l276c30;
se_agenT625f625l357c33 uagenT625f625l357c33;
se_agenT625f625l375c30 uagenT625f625l375c30;
se_agenT625f625l424c33 uagenT625f625l424c33;
se_agenT625f625l437c30 uagenT625f625l437c30;
se_agenT625f625l447c72 uagenT625f625l447c72;
se_agenT625f625l81c56 uagenT625f625l81c56;
se_agenT625f625l108c55 uagenT625f625l108c55;
se_agenT625f625l119c20 uagenT625f625l119c20;
se_agenT639f640l132c33 uagenT639f640l132c33;
se_agenT639f640l152c30 uagenT639f640l152c30;
se_agenT641f640l132c33 uagenT641f640l132c33;
se_agenT641f640l152c30 uagenT641f640l152c30;
se_agenT642f642l80c35 uagenT642f642l80c35;
se_agenT642f642l1106c37 uagenT642f642l1106c37;
se_agenT642f642l61c35 uagenT642f642l61c35;
se_agenT642f642l1081c39 uagenT642f642l1081c39;
se_agenT642f642l1089c34 uagenT642f642l1089c34;
se_agenT642f642l1036c37 uagenT642f642l1036c37;
se_agenT642f640l132c33 uagenT642f640l132c33;
se_agenT642f640l152c30 uagenT642f640l152c30;
se_agenT646f640l132c33 uagenT646f640l132c33;
se_agenT646f640l152c30 uagenT646f640l152c30;
se_agenT647f647l691c61 uagenT647f647l691c61;
se_agenT647f647l707c61 uagenT647f647l707c61;
se_agenT383f383l155c38 uagenT383f383l155c38;
se_agenT383f383l474c46 uagenT383f383l474c46;
se_agenT108f108l185c20 uagenT108f108l185c20;
se_agenT108f108l175c20 uagenT108f108l175c20;
se_agenT729f729l536c33 uagenT729f729l536c33;
se_agenT729f729l558c30 uagenT729f729l558c30;
se_agenT807f807l126c52 uagenT807f807l126c52;
};
/*
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2005: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
*/
#define SE_AGENTS 1
#define EIF_AGENT se_agent*

se_agent* new_agent(Tid id);

#ifdef SE_GC_LIB

  typedef struct B_agent gc_agent;

  struct B_agent {
    se_agent object;
    union {
      void *flag;
      gc_agent *next;
    } header;
  };

  extern TLS(gc_agent *) store_agent;
  extern TLS(gc_agent *) gc_free_agent;
  extern TLS(int       ) store_left_agent;
  extern TLS(fsoc     *) store_chunk_agent;
  extern TLS(fsoc      ) H_agent;
  extern TLS(int       ) gc_info_nb_agent;

  void gc_align_mark_agent(fsoc *c, gc_agent* a);
  void gc_sweep_agent(fsoc *c);

#endif
extern T0*ms415_350193314Abc415A;
extern T0*ms650_5313505Abc650B;
extern T0*ms650_5313505Abc650A;
extern T0*ms113_686Abc113A;
extern T0*ms111_298390Abc111A;
extern T0*ms729_398948Abc729A;
extern T0*ms684_1760457965Abc684A;
extern T0*ms115_17794Abc115A;
extern T0*ms412_333554149Abc412A;
extern T0*ms764_989731302Abc764A;
extern T0*ms113_240Abc281A;
extern T0*ms33_406284Abc33A;
extern T0*ms117_523400916Abc117A;
extern T0*ms113_240Abc283A;
extern T0*ms33_1639475718Abc33A;
extern T0*ms729_125Abc729A;
extern T0*ms647_419Abc647A;
extern T0*ms647_419Abc647B;
extern T0*ms408_647790517Abc408A;
extern T0*ms467_161769183Abc467A;
extern T0*ms415_511502716Abc415B;
extern T0*ms415_511502716Abc415A;
extern T0*ms370_22271191Abc702A;
extern T0*ms104_1593742473Abc104A;
extern T0*ms117_1284Abc582A;
extern T0*ms415_1277330071Abc415A;
extern T0*ms589_1747685533Abc589A;
extern T0*ms104_1617443474Abc104A;
extern T0*ms848_101Abc848A;
extern T0*ms117_77Abc117A;
extern T0*ms117_1284Abc640A;
extern T0*ms117_1284Abc637A;
extern T0*ms122_51895507Abc122A;
extern T0*ms33_3501Abc33A;
extern T0*ms117_522691310Abc117A;
extern T0*ms117_1284Abc639A;
extern T0*ms642_1084495643Abc642A;
extern T0*ms117_1284Abc639B;
extern T0*ms117_1284Abc639C;
extern T0*ms729_34749Abc729A;
extern T0*ms381_762122588Abc381B;
extern T0*ms848_212314278Abc848A;
extern T0*ms381_762122588Abc381A;
extern T0*ms104_2087550139Abc104A;
extern T0*ms117_1284Abc647A;
extern T0*ms647_1338608648Abc647A;
extern T0*ms489_852437Abc489A;
extern T0*ms589_1747685533Abc624A;
extern T0*ms104_75996531Abc104A;
extern T0*ms415_165614527Abc415C;
extern T0*ms415_165614527Abc415B;
extern T0*ms117_1284Abc648A;
extern T0*ms415_165614527Abc415A;
extern T0*ms625_9775Abc625A;
extern T0*ms805_789213750Abc805A;
extern T0*ms467_1157128572Abc467A;
extern T0*ms462_1087076085Abc462A;
extern T0*ms117_107312226Abc117A;
extern T0*ms370_22271191Abc678A;
extern T0*ms763_1309017823Abc763A;
extern T0*ms104_1581435442Abc104A;
extern T0*ms647_162070Abc647A;
extern T0*ms642_693716559Abc642A;
extern T0*ms113_179868158Abc113A;
extern T0*ms283_3645Abc34A;
extern T0*ms283_17696Abc283A;
extern T0*ms647_1586596820Abc647A;
extern T0*ms577_1399364920Abc577A;
extern T0*ms647_1586596820Abc647B;
extern T0*ms104_2061122069Abc104A;
extern T0*ms647_1586596820Abc648A;
extern T0*ms117_1065055Abc117A;
extern T0*ms104_437331Abc104A;
extern T0*ms120_612334905Abc120A;
extern T0*ms642_23451005Abc642A;
extern T0*ms117_33425Abc117A;
extern T0*ms117_33425Abc117B;
extern T0*ms120_1752297822Abc120A;
extern T0*ms660_2025498932Abc660A;
extern T0*ms117_1284Abc727A;
extern T0*ms293_188916891Abc293A;
extern T0*ms846_81437Abc846A;
extern T0*ms117_1284Abc729A;
extern T0*ms117_17480Abc625A;
extern T0*ms34_878084737Abc34A;
extern T0*ms126_1293738877Abc126A;
extern T0*ms33_259659630Abc33A;
extern T0*ms436_797085749Abc436A;
extern T0*ms420_343527626Abc420A;
extern T0*ms436_1529695024Abc436A;
extern T0*ms113_830570470Abc113A;
extern T0*ms117_1040899642Abc117A;
extern T0*ms33_2246041Abc33A;
extern T0*ms113_1223801083Abc113A;
extern T0*ms33_548331507Abc33A;
extern T0*ms33_1597390874Abc33A;
extern T0*ms848_26635163Abc848A;
extern T0*ms647_1023363018Abc647A;
extern T0*ms293_1224218969Abc293A;
extern T0*ms409_1747372019Abc409A;
extern T0*ms125_2947Abc125A;
extern T0*ms418_1721243342Abc418A;
extern T0*ms583_992810240Abc583A;
extern T0*ms104_28789007Abc104A;
extern T0*ms34_1839765037Abc34A;
extern T0*ms848_6614Abc848A;
extern T0*ms289_92467250Abc289A;
extern T0*ms289_92467250Abc289B;
extern T0*ms30_63Abc30A;
extern T0*ms660_58505493Abc660A;
extern T0*ms30_7779Abc30A;
extern T0*ms728_1286Abc728A;
extern T0*ms117_1253959973Abc117A;
extern T0*ms106_1656731300Abc106A;
extern T0*ms728_636642526Abc728A;
extern T0*ms104_1922692108Abc104A;
extern T0*ms849_41300Abc849A;
extern T0*ms383_2870Abc383A;
extern T0*ms848_1847665958Abc848A;
extern T0*ms117_113036818Abc117A;
extern T0*ms843_496139469Abc843A;
extern T0*ms650_1236414794Abc650A;
extern T0*ms104_1307652273Abc104A;
extern T0*ms111_1131498768Abc111A;
extern T0*ms844_835204573Abc844A;
extern T0*ms552_1280946519Abc552A;
extern T0*ms113_1102814319Abc113A;
extern T0*ms711_78239462Abc711A;
extern T0*ms727_6284Abc727A;
extern T0*ms642_279959115Abc642A;
extern T0*ms117_1065942137Abc117A;
extern T0*ms727_6284Abc727B;
extern T0*ms625_674382779Abc625A;
extern T0*ms727_6284Abc729A;
extern T0*ms727_6284Abc729B;
extern T0*ms467_1876110531Abc467A;
extern T0*ms848_1279738389Abc848A;
extern T0*ms104_700613496Abc104A;
extern T0*ms848_32605Abc848A;
extern T0*ms642_2353775Abc642A;
extern T0*ms848_784300160Abc848A;
extern T0*ms647_108351709Abc647A;
extern T0*ms33_1326673961Abc33A;
extern T0*ms281_1587749191Abc281A;
extern T0*ms111_601041072Abc111A;
extern T0*ms104_888875725Abc104A;
extern T0*ms656_11205716Abc656A;
extern T0*ms117_1082664800Abc117A;
extern T0*ms104_1