#! /bin/sh
#
# Edit and run this file to change hooks of this directory.
#

chmod a+w *

# test if echo command interprets -n option
xxx=`echo -n`

if [ -z "$xxx" ]
  then
    eopt=-n
    eend=
  else
    eopt=
    eend="""\c"""
fi

# ---------------------------------------------------------------------------
# "hook000" - If this hook file exists, the contents of this file is
# printed very first.
cat >hook000 <<END
<!DOCTYPE HTML SYSTEM>
<!-- Generated by SmallEiffel short -html_css style hooks -->
<html>
<head>
<link type="text/css" rel="stylesheet" href="seshort.css">
<title>
END

# "hook002" - If this hook file exists, the contents of this file is
# printed after an extra class name.
cat >hook002 <<END
: Eiffel class interface
</title>
</head>
<body>
END

# "hook010" - If this hook file exists, and if the processed class is
# an expanded one, the contents of this file is printed before the
# class name to replace the default string "expanded class interface
# ".
echo $eopt '<p class="title"><span class="keywords">expanded class interface</span> '$eend > hook010

# "hook011" - If this hook file exists, and if the processed class is
# an deferred one, the contents of this file is printed before the
# class name to replace the default string "deferred class interface
# ".
echo $eopt '<p class="title"><span class="keywords">deferred class interface</span> '$eend > hook011

# "hook012" - If this hook file exists, and if the processed class is
# an ordinary one (not deferred nor expanded) the contents of this
# file is printed before the class name to replace the default string
# "class interface ".
echo $eopt '<p class="title"><span class="keywords">class interface</span> '$eend > hook012

# "hook013" _ If this hook file exists, the contents of this file is
# printed before the class name whatever the kind of class (expanded,
# deferred or ordinary) to replace the default empty string "".
rm -f hook013

# "hook014" - If this hook exists, the contents of the file is printed
# after the class name to replace the default string "%N".
echo $eopt '</p>
'$eend > hook014

# "hook015" - If this hook file exists, and if a class header comment
# is present, this file is printed once before the heading class
# comment.
echo $eopt '<p class="tab_comment"><span class="comment">'$eend > hook015
#jojo: echo $eopt '<span class="comment">'$eend > hook015

# "hook016" - If this hook file exists, and if an heading comment is
# present, the contents of this file is printed to replace the default
# string " -- " at the beginning of each comment line.
echo $eopt '&#151;&nbsp;&nbsp; '$eend > hook016
#jojo: echo $eopt '<span class="tab_comment"></span>&#151;'$eend > hook016

# "hook017" - If this hook file exists, and if an heading comment is
# present, the contents of this file is printed to replace the default
# string "%N" at the end of each comment line.
rm -f hook017

# "hook018" - If this hook file exists, and if a class heading comment
# is present, the contents of this file is printed once after the
# heading comment.
echo $eopt '</span></p>
'$eend > hook018
#echo $eopt '</span>
#'$eend > hook018

# "hook019" - If this hook file exists, and if the processed class has
# no heading comment, this file is printed once.
echo $eopt '
'$eend > hook019

# ---------------------------------------------------------------------------
# 2.2. Changing output of the creation list

# "hook100" - If it exists, this file is printed before the creation
# list to replace the default string "creation%N".
echo $eopt '<p class="section"><span class="keywords">creation</span></span>
</p>'$eend > hook100

# "hook101" - If it exists, this file is printed after the creation
# list to replace the default empty string "".
rm -f hook101

# "hook102" - If it exists, this file is printed when class has no
# creation list.
rm -f hook102

# ---------------------------------------------------------------------------
# 2.3. Changing output of the feature list

# "hook200" - If exists, printed before the feature list when option
# -sort is selected to replace the default string "feature(s)%N".
echo $eopt '<p class="section"><span class="keywords">feature(s)</span></span>
</p>'$eend > hook200

# "hook201" - If exists, printed after the feature list when option
# -sort is selected to replace the default empty string "".
echo $eopt '
'$eend > hook201

# "hook202" - If exists, printed before each feature list with no
# heading comment to replace the default string "feature(s) from ".
echo $eopt '<p class="section"><span class="keywords">feature(s) from </span>'$eend > hook202

# "hook203" - If exists, printed after the class name of "hook202" to
# replace the default string "%N".
echo $eopt '</span></p>
'$eend > hook203

# "hook204" - If exists, printed before a feature list with a heading
# comment to replace the default string "feature(s) from ".
echo $eopt '<p class="section"><span class="keywords">feature(s) from </span>'$eend > hook204

# "hook205" - If exists, printed after the class name introduced at
# "hook204" to replace the default string "%N".
echo $eopt '</span></p>
'$eend > hook205

# "hook206" - If exists, printed before each line of the feature list
# comment to replace the default string " -- ".
echo $eopt '<p class="tab_comment"><span class="comment">&#151;&nbsp;&nbsp; '$eend > hook206

# "hook207" - If exists, printed after each line of the feature list
# comment to replace the default string "%N".
echo $eopt '</span>
'$eend > hook207

# "hook208" - If exists, printed after a feature list comment to
# replace the default empty string "".
echo $eopt '
'$eend > hook208

# ---------------------------------------------------------------------------
# 2.4. Changing output of a feature signature

# "hook300" - If this hook exists, the contents of this file is
# printed before each feature to replace the default string " ".
echo $eopt '<p class="tab_feature"><span class="featurename">'$eend > hook300

# "hook301" - If this hook exists, the contents of this file is
# printed once when the feature has no arguments to replace the
# default empty string "".
echo $eopt '</span>'$eend > hook301

# "hook302" - If this hook exists, the contents of this file is
# printed once when the feature has arguments to replace the default
# string " (".
echo $eopt '</span> ('$eend > hook302

# "hook303" - If this hook exists, the contents of this file is
# printed when the feature has arguments to replace the default string
# " ;".
rm -f hook303

# "hook304" - If this hook exists, the contents of this file is
# printed when the feature has arguments to replace the default string
# ", ".
rm -f hook304

# "hook305" - If this hook exists, the contents of this file is
# printed when the feature has arguments to replace the default string
# ": ".
rm -f hook305

# "hook306" - If this hook exists, the contents of this file is
# printed once when the feature has arguments to replace the default
# string ")".
rm -f hook306

# "hook307" - If this hook exists, the contents of this file is
# printed once when the feature has no result to replace the default
# string "%N".
echo $eopt '</p>
'$eend > hook307

# "hook308" - If this hook exists, the contents of this file is
# printed once before the result type of the feature to replace the
# default string ": ".
rm -f hook308

# "hook309" - If this hook exists, the contents of this file is
# printed once after the result type of the feature to replace the
# default string "%N".
echo $eopt '
</p>'$eend > hook309

# ---------------------------------------------------------------------------
# 2.5. Changing output of a feature comment

# "hook310" - If this hook file exists, and if a feature has a heading
# comment, this file is printed once before the comment.
echo $eopt '<p class="tab_feature_comment"><span class="comment">'$eend > hook310

# "hook311" - If this hook file exists, and if a feature has a heading
# comment, the contents of this file is printed to replace the default
# string " -- " at the beginning of each comment line.
echo $eopt '&#151;&nbsp;&nbsp; '$eend > hook311

# "hook312" - If this hook file exists, and if a feature has a heading
# comment, the contents of this file is printed to replace the default
# string "%N" at the end of each comment line.
echo $eopt '
'$eend > hook312

# "hook313" - If this hook file exists, and if a feature has a heading
# comment, the contents of this file is printed once after this
# comment.
echo $eopt '</span></p>'$eend > hook313

# "hook314" - If this hook file exists, and if a feature has no
# heading comment, the contents of this file is printed.
rm -f hook314

# "hook315" - If this hook file exists, and if a feature is deferred,
# the contents of this file are printed.
echo $eopt '<p class="tab_feature_deferred"><span class="keywords">deferred</span></p>'$eend > hook315

# ---------------------------------------------------------------------------
# 2.6. Changing output of require clauses
# 2.6.1. For the header of a require clause

# "hook400" - If this hook file exists, and if a feature has no
# require assertion, the contents of this file is printed to replace
# the default empty string "".
rm -f hook400

# "hook401" - If this hook file exists, and if a feature has one
# require assertion, the contents of this file is printed before the
# latest inherited assertion to replace the default string "require%N".
echo $eopt '<p class="tab_contract"><span class="keywords">require</span></p>
'$eend > hook401

# "hook402" - If this hook file exists, and if a feature has more than
# one require assertion, the contents of this file is printed before
# the require assertion to replace the default string " require else%N".
echo $eopt '<p class="tab_contract"><span class="keywords">require else</span></p>
'$eend > hook402

# "hook403" - If this hook file exists, and if a feature has at least
# one require assertion, the contents of this file is printed to
# finish the job (once after the last printed require assertion) to
# replace the default empty string "".
rm -f hook403

# "hook412" - If exists, printed when a require clause has no heading
# comment to replace the default empty string "".
rm -f hook412

# "hook413" - If exists, printed once before the require clause
# heading comment to replace the default empty string "".
echo $eopt '<p class="tab_contract_comment"><span class="comment">'$eend > hook413

# "hook414" - If exists, printed before each line of the heading
# comment to replace the default string " -- ".
echo $eopt '&#151;&nbsp;&nbsp; '$eend > hook414

# "hook415" - If exists, printed after each line of the heading
# comment to replace the default string "%N".
echo $eopt '<br>
'$eend > hook415

# "hook416" - If exists, printed once after the require clause heading
# comment.
echo $eopt '</span></p>'$eend > hook416

# "hook417" - If exists, printed when a require clause has no
# assertion to replace the default empty string "".
rm -f hook417

# "hook418" - If exists, printed once before the first assertion of a
# require clause to replace the default empty string "".
rm -f hook418

# "hook433" - If exists, printed once after the last assertion of a
# require clause to replace the default empty string "".
rm -f hook433

# "hook434" - If exists, printed to finish a require clause to replace
# the default empty string "".
rm -f hook434

# 2.6.2. For each assertion in a require clause

# "hook419" - If exists, printed before each assertion of a require
# clause to replace the default string " ".
echo $eopt '<p class="tab_assertion">'$eend > hook419

# "hook420" - If exists, printed when an assertion has no tag to
# replace the default empty string "".
rm -f hook420

# "hook421" - If exists, printed before a tag to replace the default
# empty string "".
echo $eopt '<span class="assertiontag">'$eend > hook421
#jojo: rm -f hook421

# "hook422" - If exists, printed after a tag to replace the default
# string ": ".
echo $eopt ':</span>&nbsp;&nbsp; '$eend > hook422
#jojo: rm -f hook422

# "hook423" - If exists, printed when the assertion has no expression
# to replace the default empty string "".
rm -f hook423

# "hook424" - If exists, printed before the expression to replace the
# default empty string "".
rm -f hook424

# "hook425" - If exists, printed after the expression (except for the
# last assertion) to replace the default string ";".
rm -f hook425

# "hook426" - If exists, printed when an assertion has no comment to
# replace the default string "%N".
echo $eopt '</p>
'$eend > hook426

# "hook427" - If exists, printed once before the assertion comment to
# replace the default empty string "".
echo $eopt '</p><span class="comment"><p class="tab_contract_comment">
'$eend > hook427

# "hook428" - If exists, printed before each line of the expression
# comment to replace the default string " -- ".
echo $eopt '&#151;&nbsp;&nbsp; '$eend > hook428

# "hook429" - If exists, printed after each line of the expression
# comment to replace the default string "%N".
echo $eopt '<br>
'$eend > hook429

# "hook430" - If exists, printed once after the assertion's comment to
# replace the default string "".
echo $eopt '</p></span>'$eend > hook430

# "hook431" - If exists, printed after the assertion to replace the
# default empty string "".
rm -f hook431

# 2.6.3. For the last assertion in a require clause Same hook file
# list as described in section 2.6.2 except "hook425" which becomes :

# "hook432" - If exists, printed after the last expresion to replace
# the default empty string "".
rm -f hook432

# ---------------------------------------------------------------------------
# 2.7. Changing output of ensure clauses
# 2.7.1. For the header of the ensure clause

# "hook500" - If this hook file exists, and a feature has no ensure
# clause, the contents of this file is printed to replace the default
# empty string "".
rm -f hook500

# "hook511" - If this hook file exists, the contents of this file is
# printed before each ensure clause to replace the default string "ensure%N".
echo $eopt '<p class="tab_contract"><SPAN class="keywords">ensure</SPAN></p>
'$eend > hook511

# "hook512" - If exists, printed when ensure clause has no heading
# comment to replace default empty string "".
rm -f hook512

# "hook513" - If exists, printed once before the ensure clause heading
# comment to replace the default empty string "".
echo $eopt '<span class="comment">'$eend > hook513

# "hook514" - If exists, printed before each line of the heading
# comment to replace the default string " -- ".
echo $eopt '<p class="tab_contract_comment">&#151;&nbsp;&nbsp; '$eend > hook514

# "hook515" - If exists, printed after each line of the heading
# comment to replace the default string "%N".
echo $eopt '</p>
'$eend > hook515

# "hook516" - If exists, printed once after the ensure clause heading
# comment.
echo $eopt '</span>'$eend > hook516

# "hook517" - If exists, printed when an ensure clause has no
# assertion to replace the default empty string "".
rm -f hook517

# "hook518" - If exists, printed once before the first assertion of
# the ensure clause to replace the default empty string "".
rm -f hook518

# "hook533" - If exists, printed once after the last assertion of the
# ensure clause to replace the default empty string "".
rm -f hook533

# "hook534" - If exists, printed to finish the ensure clause to
# replace the default empty string "".
rm -f hook534

# 2.7.2. For each assertion in the ensure assertion

# "hook519" - If exists, printed before each assertion of the ensure
# clause to replace the default string " ".
echo $eopt '<p class="tab_assertion">'$eend > hook519

# "hook520" - If exists, printed when an assertion has no tag to
# replace the default empty string "".
rm -f hook520

# "hook521" - If exists, printed before a tag to replace the default
# empty string "".
echo $eopt '<span class="assertiontag">'$eend > hook521
#jojo: rm -f hook521

# "hook522" - If exists, printed after a tag to replace the default
# string ": ".
echo $eopt ':</span>&nbsp;&nbsp; '$eend > hook522
#jojo: rm -f hook522

# "hook523" - If exists, printed when the assertion has no expression
# to replace the default empty string "".
rm -f hook523

# "hook524" - If exists, printed before the expression to replace the
# default empty string "".
rm -f hook524

# "hook525" - If exists, printed after the expresion (except for the
# last assertion) to replace the default string ";".
rm -f hook525

# "hook526" - If exists, printed when an assertion has no comment to
# replace the default string "%N".
echo $eopt '</p>
'$eend > hook526

# "hook527" - If exists, printed once before the assertion comment to
# replace the default empty string "".
echo $eopt '</p><span class="comment"><p class="tab_contract_comment">'$eend > hook527

# "hook528" - If exists, printed before each line of the expression comment to replace the default string " -- ".
echo $eopt '&#151;&nbsp;&nbsp;'$eend > hook528

# "hook529" - If exists, printed after each line of the expression
# comment to replace the default string "%N".
echo $eopt '<br>
'$eend > hook529

# "hook530" - If exists, printed once after the assertion's comment to
# replace the default string "".
echo $eopt '</p></span>'$eend > hook530

# "hook531" - If exists, printed after the assertion to replace the
# default empty string "".
rm -f hook531

# 2.7.3. For the last assertion in the ensure clause Same hook files
# list as described in section 2.7.2 except "hook525" which becomes:

# "hook532" - If exists, printed after the last expresion to replace
# the default empty string "".
rm -f hook532

# ---------------------------------------------------------------------------
# 2.8. Changing output after each feature

# "hook599" - If exists, printed after each feature to replace the
# default empty string "".
echo $eopt '
'$eend > hook599

# ---------------------------------------------------------------------------
# 2.9. Changing output of the class invariant
# 2.9.1. For the header of the class invariant

# "hook800" - If this hook file exists, and when no class invariant
# exists, the contents of this file is printed to replace the default
# empty string "".
rm -f hook800

# "hook811" - If this hook file exists, the contents of this file is
# printed before the class invariant to replace the default string
# "invariant%N".
echo $eopt '<p class="section"><span class="keywords">invariant</span></span></p>
'$eend > hook811

# "hook812" - If exists, printed when class invariant has no heading
# comment to replace default empty string "".
rm -f hook812

# "hook813" - If exists, printed once before the invariant heading
# comment to replace the default empty string "".
echo $eopt '<p class="tab_comment"><span class="comment">'$eend > hook813

# "hook814" - If exists, printed before each line of the heading
# comment to replace the default string " -- ".
echo $eopt '&#151;&nbsp;&nbsp; '$eend > hook814

# "hook855" - If exists, printed after each line of the heading
# comment to replace the default string "%N".
echo $eopt '<br>
'$eend > hook855

# "hook816" - If exists, printed once after the invariant heading
# comment.
echo $eopt '</span></p>'$eend > hook816

# "hook817" - If exists, printed when class invariant has no assertion
# to replace the default empty string "".
rm -f hook817

# "hook818" - If exists, printed once before the first assertion of
# the class invariant to replace the default empty string "".
rm -f hook818

# "hook833" - If exists, printed once after the last assertion of the
# class invariant to replace the default empty string "".
rm -f hook833

# "hook834" - If exists, printed to finish the class invariant to
# replace the default empty string "".
rm -f hook834

# 2.9.2. For each assertion in the class invariant

# "hook819" - If exists, printed before each assertion of the class
# invariant to replace the default string " ".
echo $eopt '
<p class="tab_feature">'$eend > hook819

# "hook820" - If exists, printed when an assertion has no tag to
# replace the default empty string "".
rm -f hook820

# "hook821" - If exists, printed before a tag to replace the default
# empty string "".
echo $eopt '<span class="assertiontag">'$eend > hook821
#jojo: rm -f hook821

# "hook822" - If exists, printed after a tag to replace the default
# string ": ".
echo $eopt ':</span>&nbsp;&nbsp; '$eend > hook822
#jojo: rm -f hook822

# "hook823" - If exists, printed when the assertion has no expression
# to replace the default empty string "".
rm -f hook823

# "hook824" - If exists, printed before the expression to replace the
# default empty string "".
rm -f hook824

# "hook825" - If exists, printed after the expresion (except for the
# last assertion) to replace the default string ";".
rm -f hook825

# "hook826" - If exists, printed when an assertion has no comment to
# replace the default string "%N".
echo $eopt '</p>
'$eend > hook826

# "hook827" - If exists, printed once before the assertion comment to
# replace the default empty string "".
echo $eopt '</p><span class="comment"><p class="tab_feature_comment">'$eend > hook827

# "hook828" - If exists, printed before each line of the expression
# comment to replace the default string " -- ".
echo $eopt '&#151;&nbsp;&nbsp; '$eend > hook828

# "hook829" - If exists, printed after each line of the expression
# comment to replace the default string "%N".
echo $eopt '<br>
'$eend > hook829

# "hook830" - If exists, printed once after the assertion's comment to
# replace the default string "".
echo $eopt '</p></span>'$eend > hook830

# "hook831" - If exists, printed after the assertion to replace the
# default empty string "".
rm -f hook831

# 2.9.3. For the last assertion in the class invariant Same hook
# files list as described in section 2.9.2 except "hook825" which
# becomes :

# "hook832" - If exists, printed after the last expresion to replace
# the default string ";".
rm -f hook832

# ---------------------------------------------------------------------------
# 2.10. Changing output of the class interface footer

# "hook900" - When exists, printed once before class footer to replace
# the default empty string "".
echo $eopt '
<p class="section"><span class="keywords">'$eend > hook900

# "hook901" - When exists, printed once at the end of an expanded
# class before the class name to replace the default "end of expanded".
rm -f hook901

# "hook902" - When exists, printed once at the end of a deferred class
# before the class name to replace the default "end of deferred ".
rm -f hook902

# "hook903" - When exists, printed once at the end of an ordinary (not
# expanded nor deferred) class, before the class name to replace the
# default string "end of ".
rm -f hook903

# "hook904" - When exist, printed just before the class name to
# replace the default empty string "".
echo $eopt '</span>'$eend > hook904

# "hook905" - When exists, the contents of this file is printed after
# the class name to replace the default string "%N".
echo $eopt '</p>
'$eend > hook905

# "hook999" - If this hook file exists, the contents of this file is
# printed once to finish the job.
cat >hook999 <<END
</body>
</html>
END

# ---------------------------------------------------------------------------
# 2.11.1. Changing the output of class names

# "Bcn" - When exists, printed Before each class name.
echo $eopt '<span class="classname"><a href="'$eend > Bcn

# "Mcn" - When exists, the corresponding class name is printed one more 
#       time (using lower case letters) just before the contents of this 
#       hook file. 
echo $eopt '.html">'$eend> Mcn

# "Acn" - When exists, printed After each class name.
echo $eopt '</a></span>'$eend > Acn

# "Ucn" - To replace the Underscore character in a class name.
rm -f Ucn

# ---------------------------------------------------------------------------
# 2.11.2. Changing the output of formal generic arguments

# "Bfga" - When exists, printed Before each formal generic argument.
rm -f Bfga

# "Mfga" - When exists, the corresponding formal generic argument is printed one more 
#       time (using lower case letters) just before the contents of this 
#       hook file. 
rm -f Mfga

# "Afga" - When exists, printed After each formal generic argument.
rm -f Afga

# "Ufga" - To replace the Underscore character in a formal generic argument.
rm -f Ufga

# ---------------------------------------------------------------------------
# 2.12. Changing the output of a type mark

# "Btm" - When exists, printed Before each type mark.
rm -f Btm

# "Atm" - When exists, printed After each type mark.
rm -f Atm

# "open_sb" - To replace the opening square bracket (default "[").
rm -f open_sb

# "close_sb" - To replace the closing square bracket (default "]").
rm -f close_sb

# "fgl_sep" - To replace the default comma "," in a formal generic argument list.
rm -f fgl_sep

# "tm_blank" - To replace a blank character in a type mark.
rm -f tm_blank

# "tm_sep" - To replace default string "," as a separator in a generic list.
rm -f tm_sep

# "like" - To replace the default string "like ".
echo $eopt '<span class="keywords">like </span>'$eend > like


# "expanded" - To replace the default string "expanded ".
echo $eopt '<span class="keywords">expanded '$eend > expanded

# ---------------------------------------------------------------------------
#  2.14. Changing the output of an argument name

# "Ban" - When exists, printed Before each argument name.
# echo $eopt '<tt>'$eend > Ban
echo $eopt '<span class="argumentname">'$eend > Ban

# "Aan" - When exists, printed after each argument name.
# echo $eopt '</tt>'$eend > Aan
echo $eopt '</span>'$eend > Aan

# "Uan" - To replace the Underscore character in an argument name.
rm -f Uan

# ---------------------------------------------------------------------------
# 2.15. Changing the output of tag name

# "Btag" - When exists, printed Before each tag name.
rm -f Btag

# "Atag" - When exists, printed after each tag name.
rm -f Atag

# "Utag" - To replace the Underscore character in a tag name.
rm -f Utag

# ---------------------------------------------------------------------------
# 2.19. Changing the output of comments line

# "BECL" - Before Each Comment Line. This hook is applied to all
# comments whatever the kind of comment. If exists, printed before the
# contents of each line of each comment (usually after the default
# string "-- ").
rm -f BECL

# "AECL" - After Each Comment Line. This hook is applied to all
# comments whatever the kind of comment. If exits, printed after the
# contents of each line of each comment (usually, printed before the
# default "%N").
echo $eopt '<br>
'$eend > AECL

# "Ucomment" - To replace the Underscore character in a comment.
rm -f Ucomment

# "op_quote" - To replace the default opening quote mark "`".
echo $eopt '<strong>'$eend > op_quote

# "cl_quote" - To close an "op_quote" to replace the closing quote mark "'".
echo $eopt '</strong>'$eend > cl_quote

# ---------------------------------------------------------------------------
# 2.20. Miscellaneous tuning 

# "open_b" - To replace the default opening bracket "(" in expressions. 
rm -f open_b

# "close_b" - To replace the default closing bracket ")" in expressions. 
rm -f close_b

# "arrow" - To replace the default string "->" in a formal generic list. 
echo $eopt '&rarr;'$eend > arrow

# "dot" - To replace the default string "." in an expression. 
rm -f dot

# "Result" - To replace the default string "Result". 
echo $eopt '<span class="constants">Result</span>'$eend > Result

# "old" - To replace the default string "old " in ensure clauses. 
echo $eopt '<span class="keywords">old </span>'$eend > old

# "strip_open" - To replace the default string "strip (". 
echo $eopt '<span class="keywords">strip</span> ('$eend > strip_open

# "strip_close" - To replace default string ")" which closes "strip_open". 
rm -f strip_close

# "fnl_sep" - To replace the default string ", " in a feature name list. 
rm -f fnl_sep

# "Current" - To replace the default string "Current". 
echo $eopt '<span class="constants">Current</span>'$eend > Current

# "Void" - To replace the default string "Void". 
echo $eopt '<span class="constants">Void</span>'$eend > Void

# "once" - To replace the default string "once"
echo $eopt '<span class="keywords">once</span>'$eend > once

# Bifn - To replace the default string "infix %""
echo $eopt '<span class="keywords">infix</span> "'$eend > Bifn

# Bpfn - To replace the default string "prefix %""
echo $eopt '<span class="keywords">prefix</span> "'$eend > Bpfn

# Bsfn - Printed before each simple feature name
echo $eopt '<span class="simple_featurename">'$eend > Bsfn

#Asfn - Printed after each simple feature name
echo $eopt '</span>'$eend > Asfn

chmod a-w *
chmod a=rwx $0
