/*

  libassh - asynchronous ssh2 client/server library.

  Copyright (C) 2013-2020 Alexandre Becoulet <alexandre.becoulet@free.fr>

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301 USA

*/

#include "keys.h"

struct sign_algo_s
{
  const char *algo;
  const char *variant;
  const char *implem;
  const uint8_t *key;
  int gen_key;
  size_t kbits_min;
  size_t kbits_max;
  size_t key_len;
  size_t sign_len;
  const uint8_t *sign;
};

struct sign_algo_s algos[] = {

  { "ssh-dss", "key >= 1024", "assh-builtin",
    dsa1024_key, 1, 1024, 2304, sizeof(dsa1024_key),
    55,  (const uint8_t *)
    "\x00\x00\x00\x07\x73\x73\x68\x2d\x64\x73\x73\x00\x00\x00\x28\x11"
    "\x09\x68\x32\x63\x6c\x75\xbc\xb3\x3e\x88\x2a\xf9\xc8\xe7\x97\x4b"
    "\xe3\x4a\x1b\x20\x23\xfc\xd9\x6a\x9b\xd6\x2e\x43\x21\xdf\xa3\xc6"
    "\x24\xa7\x47\x84\x1a\x8b\xf1" },

  { "ssh-rsa", "sha*, md5, key >= 768", NULL,
    rsa1024_key, 1, 1024, 1536, sizeof(rsa1024_key),
    143, (const uint8_t *)
    "\x00\x00\x00\x07\x73\x73\x68\x2d\x72\x73\x61\x00\x00\x00\x80\x4d"
    "\x18\xf5\xdf\xea\x0c\x3e\x15\xa0\x75\x50\x8b\x4f\x56\xa3\x3d\x6e"
    "\x93\xab\x03\x7e\x67\x33\xa6\xb0\xde\xc1\x5f\xf9\x3d\xb6\x5f\xc5"
    "\x46\x86\x4f\x02\x37\x86\x43\x45\xa9\x12\x12\xd7\x76\x0f\x3f\x49"
    "\xb8\xcf\xaf\x2e\x5e\x23\x00\xe3\xc4\x15\x73\x74\x3b\x51\x60\x41"
    "\xaf\xb8\xde\x32\x93\x11\x1f\xdf\xd3\xc6\x64\xec\x9f\x30\x5d\xd5"
    "\x1f\x36\x6d\xbc\xfb\xaa\x68\xe8\x9e\x2a\x23\x43\xc3\xa8\x9f\xf8"
    "\x76\xaa\xed\x93\x0c\xdb\x22\xac\x9c\xa7\x7a\x12\x53\xfe\x00\xef"
    "\x31\x8a\x44\x94\x4a\x53\x49\x8d\x2f\xd1\x38\x48\x30\x20\xae"
    "\x00\x00\x00\x07\x73\x73\x68\x2d" },

  { "rsa-sha2-256", NULL, NULL,
    rsa2048_key, 0, 1024, 2048, sizeof(rsa2048_key),
    276, (const uint8_t *)
    "\x00\x00\x00\x0c\x72\x73\x61\x2d\x73\x68\x61\x32\x2d\x32\x35\x36"
    "\x00\x00\x01\x00\x13\x54\xee\x4b\x3d\xf3\x7a\x81\xa0\x0f\x65\x8e"
    "\xc3\x91\x67\x46\x57\xe9\x5e\x1a\xe8\xee\xbe\x6f\xa4\xe7\xc3\xb5"
    "\xbc\xa6\xdd\xd6\x23\x79\xe5\x11\x52\x5e\x96\x4f\xe3\x46\x93\x39"
    "\xb0\xe7\x6e\x48\x2f\x6b\x8c\x8a\xc9\xca\xde\xe2\x1f\xe9\x91\x5e"
    "\x91\xd5\x82\x21\xe5\xe6\x8d\x56\x66\x7f\x5d\xb1\xa2\x45\x26\x9a"
    "\xed\xe9\xe3\xaf\x7b\x02\xe5\xd8\xd2\x25\x35\x57\x97\x70\xa1\x6e"
    "\xb6\x72\xff\x30\xbd\x86\xf3\xf1\x88\x06\xf1\x70\x4a\x85\x18\x84"
    "\xb2\xb8\x1f\x20\xc9\xf7\x26\x1f\xb4\x81\x19\xe0\xd2\xc1\xd8\x2a"
    "\x8f\xd1\x62\xe7\x01\x0e\xc0\x35\x92\x0b\x94\xc2\x9d\xdf\x50\x3b"
    "\x0c\x11\xa1\x1d\xcb\x80\x52\xe8\x09\x49\x39\xd6\x73\xcc\x3d\x77"
    "\xc5\xde\x24\x06\xbe\x8e\xf9\x09\x2b\x15\x60\x73\xc9\x47\xb5\x79"
    "\xaf\x2b\x39\x83\xf9\x23\x1b\xd2\xa9\xf6\x36\x41\xb3\x97\xcc\x48"
    "\xf0\x62\x4d\x73\xb1\x59\x12\xba\x9d\x20\x45\xe1\x0a\xa1\x83\x0a"
    "\x2b\x33\x7f\x90\x95\xa3\x56\xc7\xa9\xbd\x07\xa2\x8f\x81\x5b\x39"
    "\x72\x75\x08\x45\x06\xfb\xd5\x06\x1c\xd3\xb1\x8f\xd8\x05\xcc\x5d"
    "\xcb\xe9\x9b\x32\x75\xed\x72\xb4\xb4\xb1\xb9\xe1\xa3\x99\xb2\x09"
    "\xef\xed\x1a\x91" },

  /* rsa key with bit_len(p) < bit_len(q) */
  { "rsa-sha2-256", NULL, NULL,
    rsa1027_key_pQ, 0, 1027, 1027, sizeof(rsa1027_key_pQ) },

  /* rsa key with bit_len(p) > bit_len(q) */
  { "rsa-sha2-256", NULL, NULL,
    rsa1027_key_Pq, 0, 1027, 1027, sizeof(rsa1027_key_Pq) },

  { "ssh-ed25519", NULL, NULL,
    ed25519_key, 1, 255, 255, sizeof(ed25519_key),
    4 + 11 + 4 + 2 * 32, (const uint8_t *)
    "\x00\x00\x00\x0b\x73\x73\x68\x2d\x65\x64\x32\x35\x35\x31\x39\x00"
    "\x00\x00\x40\xde\xd8\x65\x27\x76\xb7\x37\x8e\x1d\xed\x4a\x87\xef"
    "\x6e\x4e\xf8\x5d\x2b\xa7\xd9\x02\xfd\x22\x29\x27\xd4\x3c\xf7\x5c"
    "\x6f\x5a\x28\xb8\xc6\x86\xde\x39\xd6\x73\xfc\xe9\x34\x28\xaa\xa5"
    "\x41\xe9\x03\x46\x63\x9f\xe6\x25\xef\xc5\xcd\x8b\x92\xd8\xa5\x67"
    "\x0a\xe6\x05" },

  { "eddsa-e382-shake256@libassh.org", NULL, NULL,
    eddsa_e382_key, 1, 382, 382, sizeof(eddsa_e382_key),
    4 + 19 + 4 + 2 * 48, (const uint8_t *)
    "\x00\x00\x00\x13\x65\x64\x64\x73\x61\x2d\x65\x33\x38\x32\x2d\x73"
    "\x68\x61\x6b\x65\x32\x35\x36\x00\x00\x00\x60\x01\x50\xfa\xd7\xb4\xa5\x35\x43\xd9"
    "\x0f\x34\xdf\xea\xb8\x8f\xce\x3b\xa9\x3b\x25\xbf\x03\xa7\xa0\x53"
    "\x47\xbc\x5c\x7a\xa0\xa2\xc1\x8e\x1d\x27\x01\xcc\xbe\xab\xdd\x62"
    "\xfd\xcc\x9b\xd5\xf9\x62\x97\xa4\x5f\xc8\xc9\x53\x73\x9f\xd1\xc2"
    "\x8b\xd9\x27\x75\x06\xbb\xbe\x83\x88\xfa\xe8\xe4\xb1\xd6\x71\x9c"
    "\xf8\x16\x45\x7a\x41\xc6\x92\x9f\x8c\xe5\xdb\x1d\xae\x6b\x39\x53"
    "\xce\x33\xe4\x13\xb0\x34\x06" },

  { "eddsa-e521-shake256@libassh.org", NULL, NULL,
    eddsa_e521_key, 1, 521, 521, sizeof(eddsa_e521_key),
    4 + 19 + 4 + 2 * 66, (const uint8_t *)
    "\x00\x00\x00\x13\x65\x64\x64\x73\x61\x2d\x65\x35\x32\x31\x2d\x73"
    "\x68\x61\x6b\x65\x32\x35\x36\x00\x00\x00\x84\xe3\x59\x17\x34\xfd\xae\x8c\x83\xa7"
    "\x78\x91\x20\xa0\xf9\xd6\x08\x48\xe1\x07\xe9\xfb\x47\x4a\x9c\x72"
    "\x23\xd6\x27\xe3\x76\x92\xd1\xee\xa8\x74\xb0\x38\x55\xc4\xcb\xa5"
    "\xec\xc4\x32\x94\x11\xd1\x76\x23\xfc\x42\xbf\xa5\x35\x5c\x05\x44"
    "\xa6\x3c\x63\x04\x1e\x57\x4e\x1b\x01\xc1\xd6\x08\x3c\x50\x7d\x27"
    "\x0b\x86\x5b\xbd\x4a\x58\x50\x91\x4f\x15\xf1\xde\xe4\xf2\x52\xac"
    "\x06\x3a\x1f\x46\xee\x89\x43\x1a\xd5\x21\x06\x28\xbd\xe9\xa8\xce"
    "\x2d\x2e\x01\x03\x50\x27\x8a\x02\x92\x68\x6b\xbe\xbf\xfa\x57\x68"
    "\x04\xd3\x3a\x8e\x6f\x71\x60\x27\x8d\x4e\x00" },

  { "ecdsa-sha2-nistp256", NULL, "assh-builtin",
    ecdsa_nistp256_key, 1, 256, 256, sizeof(ecdsa_nistp256_key),
    101, (const uint8_t *)
    "\x00\x00\x00\x13\x65\x63\x64\x73\x61\x2d\x73\x68\x61\x32\x2d\x6e"
    "\x69\x73\x74\x70\x32\x35\x36\x00\x00\x00\x49\x00\x00\x00\x21\x00"
    "\xbb\x5d\xea\x45\x45\xd2\x8a\x9f\xfb\x8d\x89\x05\xd1\x26\x79\xf1"
    "\xc6\xb3\x95\x36\xea\x82\xe0\x0c\x33\x29\xb7\xf5\x9c\xc7\xd1\xbd"
    "\x00\x00\x00\x20\x6b\x6f\x13\xf6\xf9\xd2\x2f\x8c\xdc\x77\xdc\x79"
    "\x19\x77\xc9\xc3\x67\x41\x78\xa8\x2a\xf9\xa1\xcd\x67\xf2\xed\xbc"
    "\x10\x2e\x0f\x1a" },

  { "ecdsa-sha2-nistp384", NULL, "assh-builtin",
    ecdsa_nistp384_key, 1, 384, 384, sizeof(ecdsa_nistp384_key),
    133, (const uint8_t *)
    "\x00\x00\x00\x13\x65\x63\x64\x73\x61\x2d\x73\x68\x61\x32\x2d\x6e"
    "\x69\x73\x74\x70\x33\x38\x34\x00\x00\x00\x68\x00\x00\x00\x30\x1d"
    "\xf7\x1e\x4c\xff\x14\x46\x0c\xe3\x1d\x8d\xf1\xc6\xb1\x6a\xb9\x47"
    "\x9d\xd0\xf8\xa2\xb6\x77\xf1\x67\xf2\x70\x67\x7a\xbe\xaf\xf5\x66"
    "\x0d\xba\x3f\x57\x42\x58\x0a\x91\x90\x6a\xf0\x6c\x9e\x0f\x9d\x00"
    "\x00\x00\x30\x03\xd4\xf6\xf8\xf5\x56\xe9\xca\xd9\xbd\xbc\xa1\xe6"
    "\xb0\xbe\xa2\xe8\x8d\x9c\xf7\x7f\x0f\xf2\xfd\xb8\x45\x48\xda\xfa"
    "\x3c\x82\x29\x9e\xe4\xe5\x02\xb7\x3c\xd8\x69\xc0\x6c\x4d\x72\x40"
    "\x2d\x30\xb3" },

  { "ecdsa-sha2-nistp521", NULL, "assh-builtin",
    ecdsa_nistp521_key, 1, 521, 521, sizeof(ecdsa_nistp521_key),
    169, (const uint8_t *)
    "\x00\x00\x00\x13\x65\x63\x64\x73\x61\x2d\x73\x68\x61\x32\x2d\x6e"
    "\x69\x73\x74\x70\x35\x32\x31\x00\x00\x00\x8c\x00\x00\x00\x42\x00"
    "\x9d\x82\xec\xc8\x75\x66\xe3\x50\xdc\x77\x25\x3a\x39\x93\x85\xb9"
    "\x32\xcc\x8c\x6c\x0c\x7a\x99\xa7\x61\x18\xf7\x39\x47\x9f\x8c\x6c"
    "\x16\xef\x0f\x8b\xdf\x7d\xc6\x89\x71\x86\x8a\x42\xf8\x08\xa3\xcb"
    "\x52\x03\xb1\x84\xec\x1b\x41\xe1\xd9\x60\x1a\x9b\xfb\x3a\xcd\x3f"
    "\x09\x00\x00\x00\x42\x01\xa0\x2d\x50\x4d\x1a\xfc\xa9\x13\x8f\x53"
    "\x60\x89\x60\x1d\x4d\x5c\x34\x02\x6a\x84\xa3\xf3\x59\x28\x1e\xa9"
    "\x88\x02\x94\xaf\x51\x51\x6a\xb8\x10\xac\x90\xa9\x11\xae\x40\x77"
    "\xd0\xc9\x29\xcd\x9d\x7b\xa9\x71\xf3\xc5\xc0\xef\x9a\x81\x4c\x4c"
    "\x44\x0f\x79\x85\x6b\x4c\x2b" },

  { NULL },
};
