/*

  libassh - asynchronous ssh2 client/server library.

  Copyright (C) 2013-2020 Alexandre Becoulet <alexandre.becoulet@free.fr>

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301 USA

*/

const unsigned char dsa1024_key[1+446] = {
  ASSH_KEY_FMT_PV_PEM_ASN1,
  0x30, 0x82, 0x01, 0xba, 0x02, 0x01, 0x00, 0x02, 0x81, 0x81, 0x00, 0x9d, 0x0f, 0xcf, 0xce, 0x26, 
  0x6f, 0x01, 0x25, 0x39, 0xc2, 0x89, 0xcf, 0x2b, 0x57, 0x3b, 0x14, 0xb1, 0x3f, 0xea, 0x95, 0x2b, 
  0x3e, 0x96, 0xc8, 0x3a, 0x7e, 0xa7, 0xd2, 0x8d, 0xce, 0x68, 0xb3, 0x01, 0xdd, 0x5d, 0xd5, 0xf4, 
  0xc6, 0xcf, 0x7d, 0xe8, 0x1a, 0x9b, 0x42, 0x46, 0xbb, 0xbe, 0x01, 0x69, 0x91, 0x07, 0x27, 0x52, 
  0x91, 0xe1, 0x8c, 0x57, 0xa0, 0x64, 0x06, 0x0e, 0xf6, 0x3b, 0x7f, 0x0f, 0xc5, 0xd9, 0xa9, 0x25, 
  0x0b, 0x9b, 0x1a, 0x38, 0xb6, 0xd5, 0xe3, 0xbd, 0x8d, 0xc6, 0x7f, 0xb8, 0x87, 0xa9, 0x18, 0x12, 
  0xe2, 0x43, 0xdf, 0x9b, 0x15, 0x71, 0xa5, 0x3b, 0x4e, 0x30, 0x9e, 0x0e, 0x3d, 0x4f, 0x5c, 0x43, 
  0xd4, 0x95, 0x09, 0xd9, 0xf0, 0x2d, 0x57, 0x99, 0x7f, 0x7e, 0xe5, 0x46, 0x75, 0x5f, 0xbf, 0xde, 
  0x3e, 0x1e, 0x1f, 0xfb, 0x50, 0x35, 0xd5, 0x6f, 0x97, 0x78, 0xf1, 0x02, 0x15, 0x00, 0xc9, 0xd5, 
  0x94, 0x03, 0x26, 0xd3, 0xf5, 0xc5, 0x9f, 0xa4, 0x31, 0xe3, 0xf7, 0x85, 0x27, 0xa2, 0x44, 0x64, 
  0x62, 0xf9, 0x02, 0x81, 0x80, 0x1f, 0x5f, 0xc5, 0x32, 0xc1, 0x98, 0xe6, 0x8f, 0xa2, 0x67, 0xa8, 
  0xf1, 0xd7, 0xe2, 0x39, 0x29, 0xba, 0xa8, 0x8c, 0x3a, 0xeb, 0xde, 0x07, 0x9c, 0x76, 0x95, 0x24, 
  0xcd, 0x5d, 0x7c, 0xc9, 0x00, 0xba, 0xa1, 0xad, 0xd8, 0x76, 0x0a, 0x6d, 0x2d, 0x47, 0xaa, 0xf9, 
  0x7b, 0x14, 0xfe, 0x97, 0xe1, 0x5d, 0x41, 0x48, 0xd3, 0xd5, 0x33, 0xef, 0xef, 0xc7, 0x1a, 0x3c, 
  0x82, 0xce, 0xe9, 0x29, 0x80, 0x32, 0xf9, 0x61, 0xdc, 0x92, 0xa9, 0xbd, 0x76, 0x0f, 0xc9, 0x02, 
  0xbb, 0xb7, 0x0e, 0x09, 0xd5, 0x5b, 0x3c, 0x11, 0xeb, 0x12, 0x72, 0xf3, 0x78, 0x6c, 0xfb, 0x23, 
  0x10, 0x0b, 0xde, 0x1d, 0x4c, 0xc1, 0x65, 0x1d, 0x03, 0xb9, 0x6a, 0x8a, 0x5c, 0xdd, 0xbc, 0x21, 
  0x81, 0x4e, 0xd3, 0x81, 0x52, 0x74, 0x39, 0xa0, 0xeb, 0xf8, 0xf7, 0x3d, 0x94, 0x14, 0xea, 0xbb, 
  0x68, 0xae, 0x0e, 0xf8, 0xc1, 0x02, 0x81, 0x80, 0x47, 0xdd, 0x44, 0xe4, 0x51, 0x88, 0x37, 0x27, 
  0x72, 0xd5, 0xd8, 0xe7, 0x93, 0x42, 0x0f, 0x52, 0xf6, 0xbb, 0xf2, 0x1f, 0x55, 0x4d, 0x93, 0xc2, 
  0xf6, 0xf3, 0xbe, 0x4e, 0xef, 0x21, 0x8b, 0x4a, 0xf1, 0x51, 0xe1, 0x99, 0x95, 0xaf, 0x91, 0x9a, 
  0xfd, 0x39, 0x3a, 0x56, 0xd8, 0x28, 0x78, 0xa3, 0x51, 0x8b, 0xbd, 0x3f, 0x70, 0xcc, 0xbe, 0x30, 
  0x55, 0xb4, 0xc8, 0x37, 0x5d, 0xad, 0xa5, 0x7c, 0x71, 0x2c, 0x30, 0x12, 0xaf, 0xc9, 0x0b, 0xf1, 
  0x46, 0xbb, 0x9f, 0x6d, 0x5c, 0xbb, 0xbc, 0x54, 0x1d, 0xab, 0xb3, 0x36, 0xc6, 0xc5, 0x32, 0x22, 
  0xed, 0x50, 0xa0, 0x73, 0x54, 0xb5, 0xb9, 0x12, 0x37, 0xd5, 0x88, 0xd2, 0xf5, 0x74, 0x78, 0x35, 
  0xd6, 0x56, 0x9b, 0xe7, 0xdd, 0xf0, 0x5f, 0x25, 0x3f, 0xdb, 0x50, 0xf9, 0x47, 0xcf, 0x72, 0x93, 
  0x93, 0xfb, 0xe2, 0xac, 0x76, 0x1d, 0x01, 0xeb, 0x02, 0x14, 0x17, 0x6c, 0x5d, 0xd1, 0x88, 0x71, 
  0x12, 0x6b, 0xa2, 0x85, 0x07, 0x24, 0xec, 0xd7, 0x75, 0x8f, 0xcc, 0xc4, 0x37, 0x1f, 
};

const unsigned char dsa2048_key[1+857] = {
  ASSH_KEY_FMT_PV_PEM_ASN1,
  0x30, 0x82, 0x03, 0x55, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01, 0x01, 0x00, 0x92, 0x56, 0x42, 0x05, 
  0xfb, 0x21, 0xe2, 0x33, 0x20, 0x01, 0xb9, 0x87, 0x3f, 0x02, 0xb2, 0x6b, 0x7f, 0xcc, 0xad, 0x17, 
  0xbd, 0xd4, 0x24, 0x02, 0x68, 0x6c, 0x42, 0x34, 0xd4, 0x70, 0xcd, 0x98, 0x74, 0xca, 0x82, 0x7c, 
  0xa3, 0x96, 0xbc, 0x51, 0x9d, 0xe5, 0xbb, 0xee, 0x5d, 0x6d, 0x3e, 0x18, 0xc7, 0x2c, 0x20, 0xbb, 
  0x24, 0x74, 0xfc, 0x0a, 0xc3, 0x12, 0xd6, 0x97, 0x6a, 0xba, 0xcf, 0xb1, 0x86, 0x45, 0xd2, 0xaf, 
  0x09, 0x7e, 0xfb, 0x5f, 0x42, 0x43, 0x96, 0x15, 0x66, 0x25, 0xe3, 0x7a, 0xa6, 0x46, 0x59, 0xfa, 
  0x33, 0x41, 0x23, 0x28, 0xd8, 0xe3, 0xdc, 0xdd, 0xe4, 0xbd, 0xe4, 0x5c, 0xd8, 0x2f, 0xf2, 0x33, 
  0xff, 0xa3, 0xc2, 0x34, 0x0d, 0x3b, 0xf9, 0x66, 0x89, 0xfa, 0x56, 0x9d, 0x43, 0x4a, 0x29, 0x1d, 
  0x37, 0xe4, 0x02, 0x05, 0x7d, 0x72, 0xd2, 0x77, 0xb6, 0x87, 0x96, 0xc5, 0xb5, 0xd1, 0xf4, 0x71, 
  0x5e, 0x81, 0xae, 0x4a, 0x71, 0x0a, 0x19, 0x71, 0x3e, 0x7b, 0x7d, 0xe8, 0x6e, 0x89, 0x5c, 0x87, 
  0xf8, 0x9a, 0xb6, 0x48, 0x93, 0x53, 0x8d, 0x2a, 0x04, 0xab, 0x44, 0x5c, 0x1d, 0xfc, 0xdd, 0x71, 
  0xe3, 0xb5, 0x45, 0x67, 0x50, 0x1d, 0x9b, 0x98, 0x24, 0x0e, 0x4e, 0x79, 0x34, 0x5d, 0xff, 0x75, 
  0x7d, 0x2a, 0x2d, 0x60, 0x74, 0x87, 0x9d, 0x12, 0x28, 0xa0, 0xc4, 0xdb, 0x69, 0xa6, 0xae, 0xf5, 
  0x02, 0x03, 0xd0, 0x9f, 0xcb, 0x94, 0xf3, 0x13, 0xea, 0x50, 0xb9, 0xb7, 0x0d, 0xff, 0x5f, 0x00, 
  0xfd, 0xcb, 0xc8, 0xe7, 0xfa, 0x4a, 0xca, 0xd4, 0x62, 0xb8, 0xa0, 0x0e, 0xa1, 0x1f, 0x69, 0x07, 
  0x7c, 0xcc, 0xda, 0x4b, 0x8f, 0x45, 0x4f, 0x73, 0xe4, 0xf0, 0x48, 0xea, 0xb7, 0x32, 0x07, 0x5d, 
  0xca, 0x7a, 0x13, 0x09, 0x99, 0xd1, 0xa8, 0x53, 0x87, 0x79, 0xaf, 0x0f, 0x02, 0x21, 0x00, 0xa2, 
  0x85, 0xb2, 0x13, 0x9e, 0x02, 0xe6, 0xcc, 0xf3, 0xeb, 0x49, 0xf1, 0x3c, 0xde, 0x13, 0x07, 0xd2, 
  0x47, 0xa0, 0xe1, 0x08, 0x86, 0x75, 0x51, 0xe5, 0x09, 0x42, 0x47, 0xac, 0x5a, 0xfc, 0x3d, 0x02, 
  0x82, 0x01, 0x00, 0x63, 0xb5, 0xc2, 0xc7, 0xba, 0x7c, 0x3a, 0x55, 0x54, 0x40, 0x10, 0x1b, 0x65, 
  0x21, 0x17, 0xe8, 0xbb, 0xba, 0x1e, 0x8e, 0xec, 0x96, 0x5d, 0xe7, 0x2e, 0x32, 0x86, 0x5a, 0xb7, 
  0x5c, 0x00, 0xa4, 0x53, 0x22, 0x0e, 0x68, 0x39, 0x1c, 0xe7, 0xc4, 0x6f, 0x86, 0xa2, 0x38, 0xf9, 
  0x62, 0x61, 0xfd, 0xa1, 0x08, 0x7e, 0xba, 0x26, 0xd4, 0x45, 0x5e, 0x96, 0x72, 0x60, 0xb5, 0x22, 
  0x08, 0x26, 0xd9, 0x69, 0x29, 0x8e, 0x20, 0xf4, 0xa0, 0xc6, 0x4d, 0x4a, 0xae, 0xa1, 0x86, 0xf0, 
  0x0c, 0x96, 0x73, 0x65, 0x44, 0xbe, 0x02, 0x56, 0xbc, 0xc6, 0x5c, 0xce, 0x28, 0x1c, 0xa1, 0x9c, 
  0xff, 0x00, 0xac, 0x7f, 0x6c, 0x85, 0x94, 0xb3, 0x04, 0x51, 0x80, 0x33, 0x7a, 0x06, 0xd6, 0xb5, 
  0x6d, 0xe1, 0xfe, 0x24, 0xb5, 0x64, 0xa9, 0x56, 0x31, 0x4c, 0xad, 0x56, 0xd2, 0xd8, 0x02, 0x1f, 
  0xa5, 0xc0, 0x2e, 0xd9, 0x22, 0xe0, 0x65, 0x1a, 0x76, 0xb5, 0x5e, 0x12, 0x93, 0xc8, 0xd5, 0x0f, 
  0x56, 0xfa, 0x04, 0x36, 0x69, 0xc7, 0xb5, 0x7e, 0x7c, 0xb9, 0x71, 0xed, 0x42, 0xf5, 0x3b, 0x06, 
  0x78, 0x7a, 0x0b, 0xdb, 0x57, 0x82, 0x62, 0x93, 0x13, 0xdf, 0x5f, 0x8f, 0x8c, 0x28, 0xdf, 0x18, 
  0x6d, 0xae, 0x7d, 0x21, 0x03, 0xb4, 0x92, 0x17, 0x72, 0xff, 0x72, 0xda, 0x41, 0x6b, 0xb1, 0x6e, 
  0xe6, 0xf6, 0x75, 0x6a, 0x14, 0xfd, 0xfa, 0x1d, 0xe5, 0x05, 0xa1, 0xe0, 0x71, 0x9a, 0xef, 0x9e, 
  0xee, 0x18, 0x19, 0x40, 0xf9, 0x43, 0xa1, 0xba, 0xd4, 0x24, 0xca, 0x8d, 0x0b, 0x70, 0x0d, 0x0b, 
  0xdc, 0xd0, 0xc3, 0x0d, 0x8f, 0x33, 0xae, 0x78, 0x16, 0x3c, 0xf5, 0x57, 0xe8, 0x3b, 0x76, 0xab, 
  0xe9, 0xb1, 0xa2, 0x09, 0x13, 0xbb, 0x90, 0x2f, 0x10, 0x0f, 0xe2, 0x8d, 0x2c, 0x9d, 0xec, 0x26, 
  0x5f, 0xc0, 0x9c, 0x02, 0x82, 0x01, 0x00, 0x5e, 0x17, 0x51, 0xf4, 0x51, 0x3d, 0xcb, 0x75, 0xf3, 
  0xcb, 0x7f, 0xf1, 0x77, 0xee, 0x48, 0x37, 0x06, 0xef, 0x7d, 0xe9, 0x33, 0xff, 0x86, 0x7d, 0x4e, 
  0xb1, 0x55, 0x34, 0x27, 0x7c, 0x06, 0xaf, 0xc5, 0x44, 0xea, 0xe1, 0x24, 0x71, 0x5e, 0x36, 0x9e, 
  0x7e, 0x97, 0xca, 0xcc, 0x09, 0x01, 0xe4, 0x9c, 0x0d, 0x40, 0x19, 0xba, 0xb1, 0x91, 0x82, 0x10, 
  0x86, 0x4f, 0xd6, 0x4c, 0xb2, 0xfd, 0x5c, 0xcb, 0x93, 0x42, 0xb5, 0x96, 0xc6, 0x59, 0xbc, 0x1b, 
  0x76, 0x26, 0x29, 0xf0, 0x2f, 0x5d, 0x68, 0x3d, 0x4b, 0x81, 0x7f, 0x2e, 0x30, 0x9f, 0xd2, 0x4a, 
  0xd3, 0xc7, 0x4e, 0x8a, 0xc3, 0xa9, 0xb7, 0xaf, 0xf8, 0x44, 0x3a, 0x41, 0x56, 0xe3, 0x91, 0xc5, 
  0xf6, 0x39, 0x8a, 0x91, 0x7e, 0x1a, 0xee, 0xa6, 0x71, 0xe5, 0x13, 0xc5, 0x16, 0xdf, 0xa2, 0x72, 
  0xa3, 0x83, 0x59, 0xa6, 0x15, 0x16, 0x47, 0xd6, 0xdf, 0x82, 0x7e, 0x36, 0x27, 0xca, 0x2b, 0x0a, 
  0x06, 0xca, 0x09, 0x32, 0xdb, 0xe3, 0xac, 0xf4, 0xb7, 0x5d, 0x23, 0x13, 0xa0, 0x4f, 0xd6, 0x13, 
  0xef, 0x56, 0x07, 0x69, 0xe7, 0x39, 0x1e, 0x02, 0xb9, 0x93, 0x4b, 0xcb, 0x2e, 0x98, 0x4c, 0xdd, 
  0xa1, 0x18, 0x30, 0xca, 0xf4, 0x28, 0xc4, 0x54, 0x98, 0xb0, 0xbe, 0xa6, 0x79, 0x59, 0xcd, 0xb4, 
  0xf5, 0xe2, 0x66, 0x20, 0x73, 0xe4, 0xc9, 0x13, 0x85, 0x51, 0xf9, 0x26, 0xf2, 0xb5, 0xd3, 0xd9, 
  0x85, 0x47, 0x6c, 0x4c, 0xc2, 0x9a, 0xfc, 0xaa, 0xa0, 0xb3, 0x26, 0x8c, 0xec, 0xf4, 0xdf, 0x35, 
  0x5b, 0x1f, 0xae, 0x91, 0x8f, 0x7d, 0xc2, 0xd9, 0x29, 0xb5, 0xe3, 0xdc, 0x41, 0x1f, 0xf2, 0x0b, 
  0x65, 0xc6, 0x9b, 0xce, 0x81, 0xbb, 0x3e, 0xb0, 0x06, 0xb0, 0x73, 0xb2, 0xb8, 0x77, 0x51, 0xf2, 
  0x69, 0x8d, 0x1e, 0xe9, 0x59, 0x87, 0x94, 0x02, 0x20, 0x4a, 0x7a, 0xb0, 0x4b, 0x9a, 0xbe, 0xf7, 
  0x91, 0xc3, 0xda, 0x18, 0xd1, 0x46, 0xe7, 0x72, 0x64, 0x50, 0xa7, 0xc3, 0x29, 0x93, 0xee, 0xb6, 
  0xa1, 0x1a, 0x4b, 0x48, 0xd7, 0x06, 0x20, 0x22, 0x33, 
};

const unsigned char dsa3072_key[1+1242] = {
  ASSH_KEY_FMT_PV_PEM_ASN1,
  0x30, 0x82, 0x04, 0xd6, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01, 0x81, 0x00, 0x92, 0xf2, 0x25, 0x46, 
  0x93, 0x9d, 0x17, 0x96, 0x4c, 0xa1, 0x48, 0x10, 0xd4, 0x97, 0xdf, 0x3b, 0x14, 0xd2, 0x2a, 0x6c, 
  0x70, 0x4c, 0x3b, 0x17, 0x7c, 0xd4, 0x4a, 0x89, 0xf6, 0xf8, 0xca, 0xeb, 0xaa, 0x64, 0x2a, 0xed, 
  0x93, 0xae, 0xe0, 0xe6, 0xaf, 0xdb, 0xff, 0xc4, 0x15, 0xf6, 0xe3, 0x1a, 0xa4, 0x6e, 0x47, 0xd7, 
  0xd6, 0x86, 0x80, 0x7a, 0x6a, 0x0e, 0x92, 0xa8, 0xf8, 0x40, 0x28, 0x58, 0x0f, 0x85, 0xba, 0x05, 
  0x0c, 0x9b, 0xb5, 0xf4, 0xba, 0x25, 0xf9, 0xef, 0x1f, 0x08, 0xfa, 0xc5, 0xad, 0x2e, 0x19, 0x70, 
  0xce, 0x24, 0xa6, 0x7e, 0x37, 0x31, 0x5a, 0x8a, 0x88, 0xe8, 0xd9, 0x38, 0x9c, 0x73, 0xde, 0x20, 
  0x01, 0x26, 0xbb, 0xe9, 0x4d, 0x2f, 0x04, 0x37, 0xbf, 0x98, 0x35, 0x60, 0x00, 0x1c, 0xa2, 0xc2, 
  0xc8, 0x86, 0x4f, 0xaa, 0xd7, 0xda, 0x02, 0x3c, 0x41, 0x1f, 0x27, 0xdb, 0x97, 0x86, 0xb7, 0x85, 
  0x98, 0xee, 0x56, 0xee, 0x63, 0x11, 0xeb, 0x1c, 0x9a, 0xae, 0x1a, 0x70, 0xc8, 0x71, 0xbd, 0xdc, 
  0x74, 0x2c, 0x11, 0xcf, 0x8b, 0x3c, 0xca, 0xfd, 0x43, 0x10, 0xde, 0xfe, 0x0b, 0xc0, 0xad, 0x23, 
  0xf7, 0xd4, 0xe8, 0x7e, 0xba, 0x9e, 0xd2, 0xd1, 0x4e, 0x70, 0x83, 0x0b, 0x34, 0xad, 0xd2, 0xc0, 
  0x4e, 0xd8, 0x38, 0x86, 0x38, 0xa0, 0xd5, 0x0e, 0x40, 0x3d, 0x67, 0x15, 0x2c, 0xa1, 0x1b, 0xf7, 
  0x4f, 0xb5, 0x25, 0x2a, 0xdb, 0xf0, 0x1c, 0x9b, 0x4d, 0x56, 0x67, 0x8a, 0x4e, 0x51, 0x33, 0x61, 
  0x7e, 0x70, 0x01, 0x2e, 0x15, 0xbc, 0x43, 0xcc, 0xe1, 0xa6, 0xea, 0xad, 0x97, 0xb0, 0xce, 0x46, 
  0xf9, 0xe4, 0x0e, 0xee, 0xcc, 0xee, 0xeb, 0x2b, 0xc6, 0xc2, 0x97, 0x81, 0xb9, 0xd5, 0xaf, 0x26, 
  0x75, 0x62, 0x8e, 0x81, 0x3f, 0x52, 0x1b, 0xb5, 0xc1, 0xf7, 0xb0, 0xb9, 0xd7, 0xff, 0x3a, 0x0a, 
  0x8a, 0xda, 0x6d, 0x8f, 0xfa, 0x62, 0x45, 0x84, 0xcb, 0xa8, 0x74, 0x36, 0xae, 0xf6, 0x46, 0x5f, 
  0xd4, 0x5e, 0x37, 0x4b, 0x44, 0x2c, 0x25, 0x29, 0x2b, 0xca, 0xdf, 0x95, 0xf3, 0xf5, 0x70, 0x14, 
  0x71, 0x77, 0x22, 0x82, 0x1b, 0x1c, 0x92, 0xd8, 0x05, 0xd8, 0xd4, 0xc5, 0x4a, 0x1c, 0x12, 0x9e, 
  0xba, 0xdd, 0xa8, 0x7b, 0x51, 0x1c, 0xcd, 0x63, 0x71, 0x01, 0x6e, 0xb8, 0x1d, 0x54, 0x92, 0x7a, 
  0xc4, 0xcd, 0x69, 0x8c, 0x91, 0x5b, 0xca, 0xc0, 0xa6, 0xc9, 0x56, 0xfb, 0xf9, 0x36, 0x57, 0x18, 
  0x72, 0x94, 0x6f, 0xe8, 0x46, 0x3e, 0xb4, 0x60, 0xed, 0xc9, 0x52, 0x88, 0x8f, 0x8b, 0x95, 0xe8, 
  0x82, 0xe8, 0xd9, 0x68, 0x04, 0x3b, 0x0f, 0xa0, 0x86, 0x84, 0x69, 0xa9, 0x38, 0x66, 0x06, 0x40, 
  0xce, 0x57, 0x32, 0xac, 0xf1, 0x3a, 0x10, 0x90, 0xd1, 0xd9, 0x74, 0x9d, 0x02, 0x21, 0x00, 0xdb, 
  0x9f, 0x2f, 0x39, 0x1a, 0x84, 0xf0, 0x74, 0xcd, 0xa7, 0xd5, 0xb1, 0x93, 0xd3, 0x23, 0x2a, 0x3d, 
  0x74, 0x74, 0x65, 0xfa, 0x27, 0xb3, 0x38, 0xd0, 0x19, 0x98, 0x17, 0x3f, 0xc3, 0x25, 0xdb, 0x02, 
  0x82, 0x01, 0x80, 0x53, 0x3b, 0xf5, 0xcc, 0xb2, 0x32, 0x23, 0x1e, 0xb5, 0xfd, 0x8f, 0x98, 0x38, 
  0xdc, 0xc5, 0x6e, 0x71, 0xf1, 0xc8, 0x27, 0x91, 0x13, 0x16, 0xef, 0x25, 0x0b, 0x31, 0x08, 0xc9, 
  0x9a, 0xca, 0xfa, 0x8c, 0x1e, 0x96, 0x65, 0x58, 0x70, 0x3a, 0x70, 0x02, 0xc3, 0xb8, 0x4e, 0x6c, 
  0x31, 0xef, 0x67, 0xb4, 0x1e, 0x7b, 0xa0, 0x86, 0x8e, 0x3b, 0x9a, 0x34, 0x3d, 0xfb, 0xcc, 0x9e, 
  0x8c, 0x8b, 0x08, 0x03, 0xf3, 0x50, 0x82, 0x54, 0x15, 0xe9, 0x72, 0xd7, 0xaa, 0x20, 0xe9, 0xbd, 
  0xb0, 0xc3, 0xd7, 0xcb, 0xad, 0x7a, 0xd6, 0x02, 0x41, 0x9a, 0x33, 0x4e, 0x20, 0x89, 0x59, 0x01, 
  0x21, 0x5b, 0x96, 0xe4, 0xc0, 0x71, 0xc5, 0xe1, 0x9b, 0x40, 0x6a, 0x73, 0xf1, 0xa8, 0xea, 0x81, 
  0xb5, 0x23, 0x56, 0x2c, 0x86, 0x58, 0x94, 0xb6, 0xfb, 0xe7, 0x76, 0x4b, 0xde, 0xa3, 0xc8, 0x13, 
  0x91, 0xed, 0x96, 0xcc, 0xa0, 0x07, 0x28, 0xb2, 0xbb, 0xc4, 0x70, 0xf4, 0x52, 0x49, 0x36, 0x2d, 
  0xed, 0xdb, 0x02, 0xf5, 0xdd, 0x9f, 0x7a, 0xa4, 0x38, 0xaf, 0x0f, 0x04, 0x33, 0xa9, 0x1f, 0xd2, 
  0xe9, 0x0f, 0x9e, 0xd8, 0x68, 0xdf, 0x53, 0x03, 0xfb, 0xee, 0x25, 0xee, 0xcd, 0x35, 0x70, 0x9e, 
  0xbf, 0xf6, 0x37, 0x73, 0xc2, 0x4d, 0x6a, 0xef, 0xf4, 0xe5, 0x9d, 0x27, 0xfa, 0x86, 0xd1, 0x7b, 
  0x83, 0xd3, 0x37, 0xe0, 0x44, 0xc2, 0x40, 0xf7, 0xf4, 0xb3, 0x09, 0xf1, 0x61, 0x54, 0xcb, 0x95, 
  0x8d, 0xc9, 0x96, 0x57, 0x52, 0x77, 0x9a, 0xf3, 0x62, 0x50, 0xc3, 0x11, 0xe1, 0x0b, 0xd1, 0xa2, 
  0xd7, 0x6f, 0x2f, 0x0f, 0x17, 0x3a, 0x9b, 0x93, 0xf3, 0x8d, 0xa7, 0xdc, 0xdd, 0xaf, 0xd9, 0xcb, 
  0xae, 0x96, 0x85, 0x67, 0xf6, 0x00, 0x0c, 0xe5, 0x35, 0x52, 0xd8, 0xe7, 0x40, 0xc0, 0x9d, 0xb2, 
  0xbd, 0x5a, 0xf2, 0x3f, 0x02, 0x63, 0xbd, 0x30, 0x97, 0x5b, 0x97, 0xa5, 0x23, 0x65, 0xab, 0xb5, 
  0x1e, 0x8e, 0x7f, 0x02, 0x8e, 0x1b, 0x3e, 0xff, 0xa0, 0x93, 0x09, 0x78, 0xfd, 0x53, 0xc4, 0x72, 
  0xbc, 0x7e, 0x89, 0x8b, 0xfe, 0xa6, 0x2c, 0x61, 0x80, 0x1d, 0x07, 0x6f, 0x3e, 0x30, 0x5b, 0x2c, 
  0x34, 0xaa, 0x5b, 0x10, 0x01, 0x5a, 0x11, 0xd6, 0xde, 0x54, 0xc5, 0x39, 0x12, 0xde, 0x8a, 0x13, 
  0x87, 0x3a, 0x93, 0xb6, 0x30, 0xc7, 0xbe, 0x37, 0x48, 0x70, 0xd0, 0x55, 0x22, 0x73, 0x60, 0xb3, 
  0x2f, 0x31, 0x8c, 0x9f, 0x49, 0xdc, 0x91, 0xd0, 0xf8, 0x77, 0x2c, 0x93, 0x21, 0x93, 0x2c, 0x5a, 
  0x28, 0xc8, 0x3b, 0xc2, 0x66, 0xd3, 0xb7, 0x14, 0xd7, 0xe2, 0xb5, 0xde, 0xb0, 0x11, 0xae, 0xa9, 
  0xba, 0xea, 0xc8, 0xe6, 0x12, 0x78, 0xae, 0x00, 0x31, 0x91, 0x04, 0x6f, 0x47, 0x24, 0xc6, 0x70, 
  0x2b, 0x36, 0x0b, 0x02, 0x82, 0x01, 0x81, 0x00, 0x83, 0x80, 0x68, 0x39, 0xf8, 0x0d, 0x41, 0xc2, 
  0x0b, 0xe1, 0x0b, 0x3a, 0x0a, 0x80, 0x7d, 0xc7, 0xf5, 0xaa, 0x53, 0xef, 0x1a, 0xdb, 0xd2, 0xa2, 
  0x18, 0xcd, 0x6b, 0x42, 0x16, 0x9a, 0x93, 0x5b, 0x3e, 0x5d, 0x3b, 0xcd, 0x63, 0x71, 0x06, 0xad, 
  0xbe, 0xf0, 0x3c, 0xa5, 0xb3, 0x82, 0x94, 0x57, 0x32, 0xe3, 0x6d, 0xc6, 0xc0, 0xb6, 0x35, 0x81, 
  0x0b, 0x5f, 0xe2, 0x15, 0xb3, 0xe7, 0xe8, 0xe1, 0x64, 0x0f, 0x58, 0x76, 0xaf, 0x69, 0x41, 0x06, 
  0x4f, 0xb9, 0xa2, 0x81, 0x57, 0xf6, 0xd9, 0xe8, 0xde, 0x4e, 0x15, 0xc5, 0x23, 0x95, 0xbf, 0x9f, 
  0x82, 0x92, 0xb0, 0xde, 0x10, 0xac, 0xe8, 0xb1, 0x6a, 0x5b, 0x24, 0x0b, 0x30, 0x4a, 0x00, 0x02, 
  0xae, 0x32, 0x69, 0xf6, 0x5e, 0xaf, 0xe8, 0x60, 0x0e, 0x13, 0xde, 0x5b, 0x2e, 0x40, 0x31, 0x74, 
  0x3a, 0xc5, 0x16, 0xe8, 0xf1, 0xd9, 0xc8, 0xc3, 0x66, 0x59, 0x2c, 0xdd, 0x46, 0x26, 0x5a, 0xa9, 
  0x89, 0xdb, 0x6e, 0x09, 0xad, 0x12, 0xcb, 0x96, 0xe2, 0x8d, 0xd8, 0xbd, 0x17, 0xd3, 0x72, 0xc8, 
  0x72, 0xcd, 0x0b, 0x80, 0x9c, 0x8a, 0x33, 0x67, 0xa3, 0x08, 0x8e, 0x06, 0x11, 0xe2, 0x63, 0xc8, 
  0x07, 0xaf, 0xa8, 0x49, 0xe1, 0xb0, 0x48, 0x4f, 0x5f, 0xdd, 0xe7, 0xb3, 0x72, 0xd2, 0x5c, 0xa1, 
  0xdf, 0xd7, 0x33, 0x08, 0x06, 0xaf, 0xa4, 0x3b, 0x64, 0xc4, 0xfe, 0x99, 0x4f, 0x56, 0xd0, 0xd1, 
  0x4f, 0x3d, 0x68, 0x8a, 0x7e, 0x8a, 0x58, 0x4e, 0xa0, 0xc7, 0xe4, 0x09, 0x7a, 0x5c, 0x02, 0xce, 
  0xa7, 0x1c, 0xb0, 0x14, 0x1e, 0x63, 0x2e, 0x9b, 0xa6, 0xd7, 0x8a, 0xd6, 0xcb, 0xf3, 0x9c, 0xa8, 
  0xc6, 0xf1, 0xbe, 0x59, 0x8e, 0x7a, 0x8c, 0xef, 0x37, 0xe0, 0x61, 0x02, 0xf7, 0x9a, 0x50, 0x3e, 
  0xe9, 0x5b, 0xf9, 0xe2, 0x43, 0xba, 0x89, 0x9d, 0x40, 0x01, 0x37, 0x11, 0x10, 0x12, 0x7a, 0xf0, 
  0x17, 0xac, 0x37, 0xf9, 0xd1, 0xbf, 0x4e, 0x11, 0x74, 0xb7, 0xb6, 0xd1, 0x18, 0xa7, 0x3b, 0x49, 
  0x24, 0x6e, 0x7f, 0x2a, 0x14, 0xb3, 0x13, 0xb5, 0xba, 0x39, 0x98, 0xb9, 0x96, 0xad, 0x01, 0xff, 
  0xe4, 0x38, 0xad, 0x09, 0x43, 0x06, 0xc3, 0x91, 0x7f, 0xb8, 0xb2, 0x94, 0xd5, 0xd7, 0x55, 0x4d, 
  0x82, 0xc0, 0x33, 0x15, 0x5c, 0xde, 0xe9, 0x1e, 0xaf, 0xb5, 0x1a, 0xe7, 0x32, 0x25, 0x9d, 0x77, 
  0xc1, 0xd7, 0x9c, 0x80, 0xa3, 0xf0, 0xc0, 0x3b, 0xfa, 0x7d, 0x3f, 0xf0, 0xbf, 0xcb, 0xf5, 0xf6, 
  0xbf, 0x9a, 0xb1, 0xea, 0x57, 0x1c, 0x01, 0x4a, 0x10, 0x88, 0x3f, 0x94, 0xe8, 0x29, 0xcd, 0x42, 
  0x6f, 0xfe, 0xea, 0xa8, 0x33, 0xd4, 0x77, 0xb4, 0x9b, 0x47, 0x4d, 0x95, 0x3b, 0xfd, 0xe7, 0xd0, 
  0x69, 0x04, 0xb9, 0xdc, 0x15, 0x89, 0x40, 0x5e, 0x02, 0x20, 0x2f, 0x8a, 0xac, 0xf5, 0x20, 0x11, 
  0x9a, 0x25, 0xcb, 0x8e, 0x43, 0x96, 0x28, 0x83, 0xee, 0x4e, 0x85, 0x18, 0x0d, 0x3c, 0x7d, 0xe8, 
  0x73, 0xd3, 0x76, 0xee, 0x89, 0x46, 0xc7, 0x76, 0x95, 0x74, 
};


const unsigned char rsa1024_key[1+609] = {
  ASSH_KEY_FMT_PV_PEM_ASN1,
  0x30, 0x82, 0x02, 0x5d, 0x02, 0x01, 0x00, 0x02, 0x81, 0x81, 0x00, 0xe0, 0x17, 0x37, 0x0a, 0x19, 
  0xa2, 0xd1, 0xae, 0xa7, 0x1c, 0x4f, 0x95, 0x26, 0x7c, 0xac, 0x38, 0x6b, 0x5c, 0xec, 0x27, 0xa8, 
  0x4f, 0x47, 0x64, 0xc8, 0x03, 0x78, 0x74, 0x56, 0x05, 0xf6, 0xcb, 0xe5, 0x08, 0xd6, 0xdc, 0x10, 
  0x61, 0x48, 0x28, 0x3c, 0x00, 0x93, 0x20, 0x33, 0x9d, 0x12, 0x73, 0xd1, 0x69, 0xad, 0x71, 0x28, 
  0x6d, 0x4c, 0x67, 0x03, 0x89, 0x3d, 0x28, 0x4e, 0x6a, 0xea, 0x82, 0xa5, 0xaa, 0x0c, 0xed, 0x3c, 
  0xc4, 0x92, 0xb2, 0x9d, 0xef, 0x4b, 0x74, 0x39, 0xa2, 0xb2, 0xd8, 0xf2, 0x25, 0x7b, 0x42, 0xe2, 
  0x59, 0x19, 0x9c, 0xd1, 0x03, 0x82, 0xd6, 0xe4, 0x99, 0x7c, 0x6f, 0x69, 0x35, 0x55, 0x44, 0x54, 
  0x0b, 0x87, 0x8c, 0xe8, 0x92, 0x4b, 0xeb, 0x23, 0x93, 0xdc, 0xd9, 0x0f, 0x56, 0x38, 0x3e, 0xea, 
  0xd5, 0xce, 0xf5, 0xc5, 0x95, 0xe7, 0x66, 0x8d, 0x95, 0x75, 0x97, 0x02, 0x03, 0x01, 0x00, 0x01, 
  0x02, 0x81, 0x80, 0x0a, 0x6c, 0xea, 0x11, 0x9d, 0x39, 0xb6, 0xf9, 0xa2, 0x2a, 0xae, 0x05, 0x29, 
  0x62, 0x39, 0x7c, 0xf2, 0x79, 0xc3, 0x3e, 0xe1, 0x14, 0xb7, 0x24, 0x98, 0x2d, 0x99, 0x28, 0x08, 
  0x6c, 0x84, 0x9b, 0xdd, 0xce, 0xf8, 0x78, 0x0a, 0x87, 0x0c, 0x1d, 0x5b, 0x15, 0x47, 0xc3, 0x02, 
  0xc3, 0xb6, 0xfd, 0x0e, 0x6c, 0x15, 0x36, 0xa3, 0x83, 0xda, 0x3f, 0x1c, 0xaa, 0x00, 0xdf, 0x64, 
  0x2e, 0x93, 0x34, 0x64, 0x87, 0x11, 0x93, 0xca, 0x63, 0x3b, 0x0f, 0x96, 0x10, 0x87, 0xa7, 0xa7, 
  0x39, 0x3d, 0xd6, 0xb9, 0xef, 0x9d, 0x3c, 0x5b, 0x8d, 0xa6, 0x3d, 0x7b, 0xf1, 0xf9, 0x66, 0xba, 
  0x9e, 0xf0, 0x99, 0x8b, 0xf6, 0x5f, 0x49, 0x20, 0xc4, 0x15, 0xc1, 0x28, 0x6c, 0xa1, 0x9c, 0xc3, 
  0x71, 0x2a, 0xa5, 0xc4, 0x17, 0xf5, 0xf4, 0xa7, 0xad, 0x60, 0x0e, 0x10, 0x6f, 0x8c, 0xf0, 0x6a, 
  0x44, 0x11, 0x69, 0x02, 0x41, 0x00, 0xf6, 0x6f, 0x5e, 0xba, 0x92, 0xec, 0x1f, 0x08, 0x9d, 0x87, 
  0x8b, 0xfa, 0x5f, 0xc5, 0x66, 0x32, 0xed, 0xdf, 0xf5, 0xac, 0x75, 0x19, 0x28, 0x74, 0x93, 0x62, 
  0xab, 0xa5, 0xd8, 0x84, 0xda, 0x41, 0x85, 0x76, 0x30, 0x28, 0x5a, 0x9b, 0x8c, 0xe9, 0xc5, 0x85, 
  0x72, 0x93, 0x7e, 0x7a, 0xea, 0x11, 0x37, 0x6e, 0x11, 0xad, 0x7f, 0x8a, 0x02, 0x13, 0x74, 0x7a, 
  0xa1, 0x38, 0x79, 0xc8, 0x9b, 0x45, 0x02, 0x41, 0x00, 0xe8, 0xc9, 0xd3, 0xa8, 0x21, 0x11, 0xd8, 
  0x19, 0x12, 0x9d, 0x81, 0xd5, 0x20, 0xbc, 0xb7, 0x88, 0xe6, 0x9a, 0xba, 0x91, 0xe9, 0x17, 0xd3, 
  0x56, 0xe8, 0x73, 0xce, 0xd2, 0x00, 0x1a, 0x12, 0x90, 0x3e, 0xef, 0xa7, 0x75, 0xcf, 0x2f, 0xc9, 
  0xd5, 0xc0, 0x3e, 0xa2, 0xa6, 0x65, 0x8b, 0x4c, 0x09, 0xb0, 0xf8, 0xaf, 0xe0, 0xcb, 0x43, 0x17, 
  0x3c, 0xc9, 0x5f, 0x55, 0xf7, 0xbc, 0x9b, 0x6d, 0x2b, 0x02, 0x40, 0x08, 0x59, 0xfb, 0xde, 0xdc, 
  0xcd, 0xcd, 0xbb, 0x70, 0x03, 0x40, 0xf6, 0x2a, 0x3a, 0xb9, 0x5c, 0xee, 0x7c, 0xd1, 0x89, 0x97, 
  0xaa, 0x53, 0x99, 0xa7, 0xc9, 0x07, 0x42, 0x26, 0x95, 0x52, 0x04, 0x38, 0x6e, 0xa9, 0xf1, 0x24, 
  0x28, 0xf3, 0x5c, 0x94, 0xca, 0x11, 0xf8, 0xf7, 0xa7, 0x58, 0xb9, 0x5e, 0xa4, 0x87, 0x4a, 0xd6, 
  0xf0, 0xa9, 0x63, 0x59, 0x66, 0x32, 0x82, 0x84, 0x76, 0x0c, 0xf5, 0x02, 0x41, 0x00, 0x83, 0x53, 
  0x38, 0xe0, 0xa4, 0xa7, 0x58, 0x6d, 0xec, 0x9e, 0x86, 0xdc, 0x21, 0x77, 0xd5, 0x62, 0x9a, 0x15, 
  0xb8, 0x23, 0x10, 0x88, 0xac, 0x65, 0x5f, 0x05, 0xd6, 0x2b, 0x8a, 0x7b, 0x2a, 0xf5, 0xcd, 0x4b, 
  0x8e, 0x01, 0x5c, 0x3c, 0xed, 0x74, 0x74, 0xdb, 0xe1, 0x0e, 0x56, 0x42, 0xdb, 0x46, 0xac, 0x5b, 
  0xdf, 0x7c, 0xc5, 0xae, 0xb7, 0xb1, 0x47, 0x39, 0x4d, 0x5a, 0x51, 0x40, 0xad, 0xb9, 0x02, 0x41, 
  0x00, 0xb2, 0xfd, 0x2f, 0x90, 0x76, 0x84, 0x1a, 0xd3, 0xa3, 0xdb, 0x32, 0x51, 0x6a, 0xfa, 0x0d, 
  0x43, 0x5d, 0x6a, 0xf1, 0xf7, 0xd6, 0x9d, 0xc9, 0xab, 0x26, 0x75, 0x30, 0x66, 0x7a, 0x7b, 0x45, 
  0xf1, 0xf6, 0xd5, 0x70, 0x14, 0x55, 0xff, 0x01, 0x9e, 0xc5, 0x30, 0x50, 0xb7, 0x75, 0x14, 0x04, 
  0xae, 0xe9, 0xfd, 0x4c, 0xc6, 0x3e, 0x51, 0x12, 0x65, 0x53, 0xd7, 0xfe, 0x87, 0x82, 0x8d, 0x35, 
  0x0d, 
};

const unsigned char rsa1027_key_Pq[1+491] = {
  ASSH_KEY_FMT_PV_OPENSSH_V1_KEY,
  0x00, 0x00, 0x00, 0x07, 0x73, 0x73, 0x68, 0x2d, 0x72, 0x73, 0x61,
  /* N */
  0x00, 0x00, 0x00, 0x81, 0x07, 0x7f, 0x8b, 0xc9, 0xf2, 0xa3, 0xf3, 0x65, 0x69, 0x75, 0xd9, 0xe9, 0xe2, 0x8e, 0xc6, 0x25, 0x9e, 
  0x3a, 0x68, 0x25, 0x5c, 0x7e, 0x8d, 0x7d, 0xec, 0x2a, 0x0d, 0x2f, 0xcc, 0x27, 0x4e, 0x95, 0x66, 
  0x03, 0x06, 0xea, 0x04, 0x6b, 0xd1, 0xbd, 0x25, 0xd3, 0x11, 0x4e, 0x24, 0x2b, 0x8e, 0x4d, 0xb5, 
  0x56, 0x21, 0x0d, 0x74, 0xaa, 0x49, 0x39, 0x3a, 0xc9, 0xc8, 0xd3, 0x5e, 0x66, 0x4e, 0xf1, 0x07, 
  0x70, 0x6b, 0xbc, 0xe3, 0x1a, 0xee, 0x53, 0x92, 0xdf, 0x42, 0x26, 0xf7, 0x6b, 0x90, 0xcd, 0x40, 
  0xf4, 0x3c, 0x2e, 0x3a, 0x3e, 0xfc, 0x30, 0x17, 0x94, 0xb9, 0x96, 0x1b, 0x53, 0xe7, 0x30, 0x01, 
  0x81, 0x30, 0x48, 0x0a, 0xf3, 0x5d, 0x50, 0xa0, 0x07, 0x37, 0x67, 0xb6, 0xcf, 0x37, 0x3f, 0xdc, 
  0x02, 0x6d, 0x9a, 0xbe, 0x73, 0x56, 0x9f, 0xfb, 0x2e, 0x26, 0x64, 0x62, 0x27, 0x74, 0x5b, 0x17, 
  /* E */
  0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x01,
  /* D */
  0x00, 0x00, 0x00, 0x81, 0x06, 0xa2, 0x96, 0x07, 0x81, 
  0x40, 0x15, 0x5c, 0xb3, 0x02, 0xc7, 0x6f, 0x50, 0xbc, 0xf8, 0x98, 0x47, 0x38, 0xf5, 0xf9, 0xc1, 
  0xac, 0x76, 0xf6, 0x6b, 0xea, 0x16, 0x3b, 0x2a, 0x93, 0xc9, 0xd5, 0x28, 0x2d, 0x1b, 0x8c, 0x2f, 
  0x97, 0x5d, 0x44, 0xdc, 0x58, 0xb6, 0xe2, 0x87, 0xdd, 0x47, 0x12, 0x7a, 0x99, 0x99, 0xab, 0xf7, 
  0x85, 0xcc, 0x3f, 0xe9, 0x46, 0xb0, 0x00, 0x62, 0x73, 0x73, 0xfd, 0x8e, 0x65, 0xde, 0x8f, 0xfa, 
  0x01, 0xdb, 0xe6, 0x89, 0xdb, 0x3a, 0x91, 0x5f, 0xb0, 0xef, 0x96, 0x31, 0x63, 0x1f, 0xf4, 0xd3, 
  0x43, 0xd9, 0xee, 0x34, 0x73, 0xfb, 0xbe, 0x7f, 0x6e, 0xfc, 0x69, 0x0a, 0xca, 0x35, 0x15, 0x9d, 
  0x09, 0x2b, 0xf7, 0x5c, 0x00, 0x3c, 0xff, 0xb3, 0x26, 0xc6, 0xdb, 0x5d, 0x34, 0x11, 0xf6, 0x93, 
  0x48, 0xea, 0xba, 0x84, 0x33, 0x22, 0xb6, 0x2a, 0x1d, 0xb3, 0xc7, 0x11,
  /* I */
  0x00, 0x00, 0x00, 0x41, 0x01, 0x11, 0x85, 0x6b, 0x78, 0xcd, 0xcd, 0xf7, 0x4a, 0x30, 0x0f, 0xa4, 0x7b, 0xa2, 0x50, 0x36, 
  0x7c, 0x2c, 0x28, 0xf5, 0x6f, 0x71, 0xfc, 0x58, 0xd2, 0xbf, 0xb6, 0xe4, 0xfa, 0x8c, 0x7a, 0xc0, 
  0xd4, 0x9d, 0xf4, 0xe0, 0xce, 0x23, 0x68, 0x14, 0x1a, 0x7f, 0xc0, 0xd2, 0x68, 0xec, 0xdd, 0x8c, 
  0x76, 0x4f, 0x67, 0x42, 0x45, 0xcb, 0x22, 0xae, 0x07, 0xf1, 0x0d, 0x16, 0x29, 0x3b, 0x83, 0xb6, 
  0x10,
  /* P */
  0x00, 0x00, 0x00, 0x41, 0x03, 0xee, 0xbe, 0x36, 0xaa, 0x4a, 0x84, 0x15, 0x78, 0xcc, 0xb6, 
  0x3e, 0xc1, 0xb6, 0x7c, 0xef, 0xd6, 0x0c, 0x8a, 0xf5, 0x81, 0x17, 0x44, 0xc1, 0xa7, 0x7b, 0x6b, 
  0x72, 0xf9, 0xf9, 0x94, 0x31, 0x89, 0x5c, 0xbc, 0x8a, 0xe1, 0x8e, 0x47, 0x08, 0x76, 0x20, 0xed, 
  0x58, 0x85, 0x8d, 0xf1, 0x1c, 0x30, 0xf1, 0x35, 0x48, 0x9c, 0xff, 0x35, 0x18, 0xa9, 0xc5, 0xe8, 
  0xf0, 0x0b, 0xaf, 0x94, 0xca, 0x0f,
  /* Q */
  0x00, 0x00, 0x00, 0x41, 0x01, 0xe8, 0x1c, 0xc8, 0x9d, 0x83,
  0xb2, 0xe7, 0xb1, 0x47, 0x02, 0x47, 0x6a, 0xb5, 0x72, 0x7a, 0x01, 0xd0, 0xf2, 0xb9, 0xd9, 0xa3, 
  0x1e, 0x3e, 0xc6, 0x53, 0xd4, 0x59, 0x28, 0x0c, 0x16, 0xfc, 0x4d, 0x0d, 0x95, 0x00, 0x6c, 0x18, 
  0xa6, 0x08, 0x35, 0x85, 0x14, 0xd8, 0x4c, 0xb2, 0x5d, 0x53, 0xc0, 0xd2, 0xd4, 0xe3, 0xc3, 0x3a, 
  0x49, 0x1c, 0x24, 0x94, 0xcc, 0x74, 0x88, 0x62, 0xd3, 0x86, 0x79,
};

const unsigned char rsa1027_key_pQ[1+491] = {
  ASSH_KEY_FMT_PV_OPENSSH_V1_KEY,
  0x00, 0x00, 0x00, 0x07, 0x73, 0x73, 0x68, 0x2d, 0x72, 0x73, 0x61,
  /* N */
  0x00, 0x00, 0x00, 0x81, 0x07, 0x7f, 0x8b, 0xc9, 0xf2, 0xa3, 0xf3, 0x65, 0x69, 0x75, 0xd9, 0xe9, 0xe2, 0x8e, 0xc6, 0x25, 0x9e, 
  0x3a, 0x68, 0x25, 0x5c, 0x7e, 0x8d, 0x7d, 0xec, 0x2a, 0x0d, 0x2f, 0xcc, 0x27, 0x4e, 0x95, 0x66, 
  0x03, 0x06, 0xea, 0x04, 0x6b, 0xd1, 0xbd, 0x25, 0xd3, 0x11, 0x4e, 0x24, 0x2b, 0x8e, 0x4d, 0xb5, 
  0x56, 0x21, 0x0d, 0x74, 0xaa, 0x49, 0x39, 0x3a, 0xc9, 0xc8, 0xd3, 0x5e, 0x66, 0x4e, 0xf1, 0x07, 
  0x70, 0x6b, 0xbc, 0xe3, 0x1a, 0xee, 0x53, 0x92, 0xdf, 0x42, 0x26, 0xf7, 0x6b, 0x90, 0xcd, 0x40, 
  0xf4, 0x3c, 0x2e, 0x3a, 0x3e, 0xfc, 0x30, 0x17, 0x94, 0xb9, 0x96, 0x1b, 0x53, 0xe7, 0x30, 0x01, 
  0x81, 0x30, 0x48, 0x0a, 0xf3, 0x5d, 0x50, 0xa0, 0x07, 0x37, 0x67, 0xb6, 0xcf, 0x37, 0x3f, 0xdc, 
  0x02, 0x6d, 0x9a, 0xbe, 0x73, 0x56, 0x9f, 0xfb, 0x2e, 0x26, 0x64, 0x62, 0x27, 0x74, 0x5b, 0x17, 
  /* E */
  0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x01,
  /* D */
  0x00, 0x00, 0x00, 0x81, 0x06, 0xa2, 0x96, 0x07, 0x81, 
  0x40, 0x15, 0x5c, 0xb3, 0x02, 0xc7, 0x6f, 0x50, 0xbc, 0xf8, 0x98, 0x47, 0x38, 0xf5, 0xf9, 0xc1, 
  0xac, 0x76, 0xf6, 0x6b, 0xea, 0x16, 0x3b, 0x2a, 0x93, 0xc9, 0xd5, 0x28, 0x2d, 0x1b, 0x8c, 0x2f, 
  0x97, 0x5d, 0x44, 0xdc, 0x58, 0xb6, 0xe2, 0x87, 0xdd, 0x47, 0x12, 0x7a, 0x99, 0x99, 0xab, 0xf7, 
  0x85, 0xcc, 0x3f, 0xe9, 0x46, 0xb0, 0x00, 0x62, 0x73, 0x73, 0xfd, 0x8e, 0x65, 0xde, 0x8f, 0xfa, 
  0x01, 0xdb, 0xe6, 0x89, 0xdb, 0x3a, 0x91, 0x5f, 0xb0, 0xef, 0x96, 0x31, 0x63, 0x1f, 0xf4, 0xd3, 
  0x43, 0xd9, 0xee, 0x34, 0x73, 0xfb, 0xbe, 0x7f, 0x6e, 0xfc, 0x69, 0x0a, 0xca, 0x35, 0x15, 0x9d, 
  0x09, 0x2b, 0xf7, 0x5c, 0x00, 0x3c, 0xff, 0xb3, 0x26, 0xc6, 0xdb, 0x5d, 0x34, 0x11, 0xf6, 0x93, 
  0x48, 0xea, 0xba, 0x84, 0x33, 0x22, 0xb6, 0x2a, 0x1d, 0xb3, 0xc7, 0x11,
  /* I */
  0x00, 0x00, 0x00, 0x41,
  0x01, 0x63, 0x7f, 0x61, 0x21, 0x3e, 0x85, 0xf4, 0x0d, 0x29, 0x70, 0x1d, 0x99, 0x86, 0xba, 0x66,
  0x1a, 0x14, 0xea, 0x46, 0x25, 0xfd, 0xd4, 0x69, 0x60, 0x2a, 0x04, 0x27, 0xbf, 0xf1, 0xbf, 0x43,
  0xe1, 0x90, 0x3a, 0xfa, 0x50, 0x16, 0x06, 0x32, 0x88, 0xec, 0x6b, 0x65, 0xbf, 0x2d, 0xf1, 0x49,
  0x4c, 0xb8, 0xc6, 0x73, 0x5d, 0x8f, 0xd9, 0xca, 0xec, 0xd2, 0x4f, 0xec, 0x42, 0xe4, 0x44, 0xe1,
  0xf8,
  /* P */
  0x00, 0x00, 0x00, 0x41, 0x01, 0xe8, 0x1c, 0xc8, 0x9d, 0x83,
  0xb2, 0xe7, 0xb1, 0x47, 0x02, 0x47, 0x6a, 0xb5, 0x72, 0x7a, 0x01, 0xd0, 0xf2, 0xb9, 0xd9, 0xa3, 
  0x1e, 0x3e, 0xc6, 0x53, 0xd4, 0x59, 0x28, 0x0c, 0x16, 0xfc, 0x4d, 0x0d, 0x95, 0x00, 0x6c, 0x18, 
  0xa6, 0x08, 0x35, 0x85, 0x14, 0xd8, 0x4c, 0xb2, 0x5d, 0x53, 0xc0, 0xd2, 0xd4, 0xe3, 0xc3, 0x3a, 
  0x49, 0x1c, 0x24, 0x94, 0xcc, 0x74, 0x88, 0x62, 0xd3, 0x86, 0x79,
  /* Q */
  0x00, 0x00, 0x00, 0x41, 0x03, 0xee, 0xbe, 0x36, 0xaa, 0x4a, 0x84, 0x15, 0x78, 0xcc, 0xb6, 
  0x3e, 0xc1, 0xb6, 0x7c, 0xef, 0xd6, 0x0c, 0x8a, 0xf5, 0x81, 0x17, 0x44, 0xc1, 0xa7, 0x7b, 0x6b, 
  0x72, 0xf9, 0xf9, 0x94, 0x31, 0x89, 0x5c, 0xbc, 0x8a, 0xe1, 0x8e, 0x47, 0x08, 0x76, 0x20, 0xed, 
  0x58, 0x85, 0x8d, 0xf1, 0x1c, 0x30, 0xf1, 0x35, 0x48, 0x9c, 0xff, 0x35, 0x18, 0xa9, 0xc5, 0xe8, 
  0xf0, 0x0b, 0xaf, 0x94, 0xca, 0x0f,
};

const unsigned char rsa2048_key[1+1189] = {
  ASSH_KEY_FMT_PV_PEM_ASN1,
  0x30, 0x82, 0x04, 0xa1, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01, 0x01, 0x00, 0xae, 0xa2, 0xae, 0xc4, 
  0xfb, 0x48, 0x89, 0x64, 0xab, 0xaa, 0xbe, 0xac, 0x6d, 0x45, 0xf0, 0xd6, 0x72, 0xc8, 0xf3, 0x18, 
  0x45, 0x83, 0x29, 0xb2, 0x46, 0x17, 0x78, 0xf9, 0x14, 0x50, 0xbd, 0xb4, 0xf2, 0x5f, 0x8f, 0xfa, 
  0xb7, 0x76, 0x2f, 0x58, 0x14, 0x2f, 0x71, 0xd7, 0xbc, 0x0f, 0x1f, 0xe2, 0x88, 0x0e, 0xca, 0x80, 
  0x09, 0x73, 0x72, 0x66, 0x63, 0x1a, 0xe2, 0x15, 0xe9, 0xa2, 0xe3, 0x39, 0x3f, 0xbb, 0x61, 0x57, 
  0xe4, 0x6a, 0x19, 0x8a, 0x9e, 0x48, 0x2f, 0x95, 0xf7, 0x32, 0xac, 0x7e, 0x4d, 0x86, 0x34, 0x28, 
  0x47, 0x39, 0x30, 0x4b, 0xfa, 0x48, 0x85, 0x5a, 0x38, 0xa5, 0x24, 0xb6, 0x0a, 0x49, 0xb7, 0x4d, 
  0xf3, 0x4e, 0xe0, 0xcd, 0x7a, 0xfd, 0x6f, 0x81, 0x3e, 0xb3, 0xab, 0x32, 0xbc, 0x92, 0x8b, 0x25, 
  0xdc, 0x70, 0xe2, 0xaf, 0x83, 0x26, 0x89, 0xe3, 0x64, 0xe8, 0x06, 0x89, 0x7e, 0x3a, 0x5a, 0x2c, 
  0x8f, 0x7e, 0x63, 0xeb, 0x5c, 0x66, 0xc4, 0x30, 0xb2, 0xee, 0xa4, 0x09, 0x37, 0x13, 0x57, 0x6c, 
  0xb8, 0x42, 0x0f, 0x5f, 0x53, 0x60, 0xe9, 0xaa, 0x86, 0xa7, 0x92, 0x27, 0x3e, 0xf4, 0xb5, 0x7e, 
  0x0a, 0x63, 0x8c, 0x2e, 0x53, 0xc9, 0x4a, 0x44, 0x43, 0x62, 0xa6, 0x19, 0x16, 0x07, 0xc7, 0x6a, 
  0x6b, 0x6f, 0x2b, 0x9c, 0x7f, 0x2b, 0x89, 0x50, 0x7d, 0xd4, 0xf5, 0xdc, 0xf5, 0x35, 0x03, 0x5a, 
  0xec, 0x9a, 0xd0, 0x1e, 0xb3, 0x73, 0x73, 0x68, 0xd0, 0xf8, 0xa0, 0xed, 0x47, 0x95, 0x23, 0x6a, 
  0xba, 0xf6, 0xc6, 0x46, 0x41, 0x74, 0xd8, 0xd1, 0xcf, 0x49, 0x60, 0x00, 0x5d, 0xa3, 0x9f, 0x65, 
  0x45, 0x86, 0x24, 0x95, 0x6e, 0x3d, 0x42, 0x8c, 0x23, 0xc3, 0x2d, 0x25, 0xc3, 0x80, 0x2d, 0xdd, 
  0xf1, 0xf9, 0x28, 0xa6, 0x87, 0x47, 0x28, 0x44, 0x2a, 0x7b, 0xec, 0x47, 0x02, 0x03, 0x01, 0x00, 
  0x01, 0x02, 0x82, 0x01, 0x00, 0x44, 0x53, 0xee, 0xa1, 0xaf, 0xd7, 0xdf, 0xb9, 0xfd, 0xd8, 0xde, 
  0xa5, 0xc4, 0x53, 0x7b, 0x39, 0xcc, 0xcb, 0x87, 0x21, 0xd6, 0x00, 0xcd, 0xcd, 0xac, 0xd2, 0xfe, 
  0x48, 0x26, 0x84, 0xb8, 0xd5, 0x15, 0x88, 0x02, 0x63, 0x8c, 0x68, 0xb7, 0x79, 0x74, 0xdc, 0x63, 
  0x64, 0x8f, 0x76, 0x33, 0x79, 0x84, 0xd6, 0x94, 0xb0, 0xa8, 0x01, 0xfd, 0x9e, 0xc5, 0xe3, 0xfc, 
  0xd5, 0xaa, 0x06, 0x4b, 0x75, 0x58, 0xd4, 0x4d, 0xef, 0xff, 0xb4, 0xeb, 0xad, 0x6a, 0xe4, 0xbf, 
  0x89, 0xa3, 0xa0, 0xb6, 0x10, 0xec, 0xf0, 0x37, 0x74, 0x12, 0xf9, 0xf3, 0x45, 0xa6, 0xf5, 0xbd, 
  0x07, 0x61, 0xe6, 0x6b, 0x88, 0xb6, 0x59, 0xc5, 0x58, 0xc0, 0x7b, 0xfa, 0x45, 0x2b, 0x7c, 0x01, 
  0xa6, 0xc6, 0x0b, 0xb2, 0x4e, 0x35, 0xad, 0xf8, 0xb7, 0xa5, 0x9a, 0x9d, 0x77, 0x22, 0x8f, 0x6f, 
  0xa0, 0x03, 0x19, 0x2d, 0x84, 0xf4, 0x51, 0xd2, 0x06, 0x40, 0x25, 0xe2, 0x32, 0x55, 0x7c, 0xc3, 
  0xab, 0x87, 0x5d, 0xf1, 0xee, 0xcc, 0x34, 0xe1, 0xbc, 0xc6, 0xec, 0x6f, 0x91, 0xa3, 0x6f, 0x49, 
  0x86, 0xe6, 0x4f, 0x73, 0xfa, 0x5b, 0xe4, 0x30, 0xb6, 0xe9, 0xee, 0xf9, 0xd9, 0xa5, 0x72, 0xb0, 
  0xc5, 0xe5, 0x60, 0x47, 0xdc, 0xf9, 0x5f, 0xe4, 0x94, 0xfa, 0x00, 0x23, 0xe5, 0x5a, 0x80, 0xe3, 
  0x5d, 0x4f, 0x24, 0x9a, 0x38, 0x8c, 0x0c, 0xa1, 0x5f, 0xaf, 0xaf, 0x5c, 0xa2, 0x4e, 0x58, 0x24, 
  0x4f, 0x70, 0x11, 0x25, 0x4a, 0xbc, 0xb1, 0xec, 0xf9, 0xcf, 0x17, 0x89, 0x76, 0xd0, 0x82, 0x3e, 
  0x63, 0x68, 0xfd, 0x8d, 0x14, 0x31, 0xb2, 0xc1, 0x97, 0xa6, 0x2e, 0x44, 0x6b, 0x49, 0x5b, 0xbe, 
  0xbe, 0xef, 0x43, 0xae, 0x09, 0x2e, 0xa1, 0x3d, 0xf4, 0x4f, 0x3f, 0x74, 0x7e, 0xa6, 0x71, 0xb7, 
  0xb7, 0x19, 0xbe, 0x23, 0x91, 0x02, 0x81, 0x81, 0x00, 0xe5, 0xb3, 0xd1, 0x00, 0xb0, 0x8a, 0xf1, 
  0x3f, 0xf5, 0xe3, 0x19, 0x2e, 0x77, 0xdf, 0x32, 0x2f, 0xed, 0xc7, 0x67, 0x54, 0xad, 0x8a, 0x10, 
  0x67, 0xa0, 0xf8, 0x5c, 0xb7, 0xb2, 0xbd, 0xaa, 0x77, 0xec, 0x3c, 0xbf, 0x96, 0x1e, 0xd8, 0x6c, 
  0x29, 0x3e, 0x23, 0x52, 0x20, 0x9c, 0x03, 0x86, 0x5e, 0x63, 0x77, 0x65, 0xaf, 0xef, 0x76, 0xc7, 
  0x27, 0xd4, 0x67, 0xf5, 0x68, 0xa7, 0x38, 0x81, 0x1c, 0x9f, 0x28, 0xbb, 0x44, 0x59, 0xf6, 0xe8, 
  0x08, 0x66, 0x2b, 0x97, 0xf1, 0xf8, 0xf6, 0x87, 0xcb, 0xe8, 0x53, 0x27, 0xb2, 0xcd, 0x08, 0x45, 
  0x17, 0x61, 0x82, 0x7a, 0x80, 0x2a, 0x66, 0x4f, 0x32, 0xa9, 0x8e, 0x09, 0x0f, 0x5a, 0x9d, 0x58, 
  0xd5, 0xf0, 0x80, 0x02, 0xef, 0x8d, 0x88, 0x8b, 0x9e, 0x1d, 0xe3, 0x08, 0x6d, 0x40, 0xc3, 0xbf, 
  0xd7, 0xb8, 0x7b, 0x3e, 0x5e, 0xe9, 0xd1, 0x2c, 0x3b, 0x02, 0x81, 0x81, 0x00, 0xc2, 0xa0, 0xf2, 
  0xf5, 0x04, 0xe8, 0x48, 0x65, 0x8e, 0xe5, 0xa7, 0xd9, 0xd8, 0xba, 0x17, 0x7d, 0x55, 0xf5, 0x85, 
  0x2c, 0x38, 0xde, 0xf2, 0x77, 0xa3, 0x10, 0x77, 0x29, 0x94, 0x5f, 0xd9, 0x40, 0x1b, 0x5d, 0x29, 
  0xd9, 0x84, 0x69, 0xeb, 0xf5, 0x84, 0x62, 0x1e, 0x4f, 0x8f, 0x6d, 0xd8, 0xee, 0xd1, 0xd2, 0xf3, 
  0xf5, 0xb8, 0xa3, 0xbb, 0x7a, 0x5f, 0xaa, 0x2e, 0x45, 0x38, 0x54, 0xeb, 0x77, 0x0d, 0xbc, 0x1e, 
  0x6e, 0xef, 0xef, 0xcc, 0x84, 0x03, 0x19, 0x11, 0x47, 0xb7, 0xa2, 0xae, 0x5d, 0xdf, 0x7b, 0x12, 
  0xa9, 0xda, 0x12, 0x1e, 0xe1, 0x80, 0x83, 0x43, 0x01, 0xd7, 0x5a, 0xc4, 0xc0, 0x37, 0xc2, 0x40, 
  0x45, 0xd3, 0x87, 0x4f, 0x51, 0x0d, 0xf8, 0xe8, 0xd8, 0xe3, 0x46, 0xc7, 0x2d, 0xf2, 0x8b, 0x1c, 
  0x28, 0xf0, 0x1b, 0x98, 0x26, 0x2c, 0xd1, 0x90, 0x13, 0x1f, 0x6d, 0xdb, 0x65, 0x02, 0x81, 0x80, 
  0x2f, 0xe5, 0x13, 0x82, 0x42, 0x4d, 0x66, 0x4a, 0x40, 0xd9, 0xee, 0x69, 0x3b, 0x03, 0x65, 0xf2, 
  0x8a, 0x70, 0xd6, 0x81, 0xd8, 0x81, 0x7e, 0x34, 0x2d, 0x63, 0x3b, 0xe9, 0xed, 0xb2, 0x10, 0x76, 
  0x5a, 0xe2, 0xbb, 0xcb, 0xf0, 0x78, 0x8d, 0xec, 0xf7, 0x90, 0xe3, 0xd1, 0xfa, 0xd5, 0xdd, 0x51, 
  0x97, 0x09, 0xd1, 0x41, 0x22, 0xfc, 0x30, 0x40, 0x84, 0xd0, 0x7c, 0x62, 0x2a, 0xe3, 0xe4, 0x3f, 
  0xf4, 0x8b, 0xc8, 0xa8, 0x52, 0xdd, 0xe1, 0xb9, 0xc6, 0x9b, 0xf6, 0x5d, 0xb4, 0xdc, 0xaa, 0xaa, 
  0x00, 0xb2, 0x3e, 0x07, 0xd1, 0x2a, 0x95, 0x45, 0x6f, 0xc6, 0x86, 0x06, 0x6d, 0x50, 0xd1, 0xd8, 
  0xad, 0x73, 0xf9, 0x3d, 0xa3, 0x56, 0x45, 0xac, 0xae, 0x2d, 0xf2, 0xee, 0xc2, 0x23, 0x23, 0x81, 
  0x7f, 0x97, 0xd4, 0x2c, 0xfb, 0xa1, 0x15, 0x42, 0x44, 0xac, 0x25, 0xf0, 0x22, 0x6e, 0xc3, 0xfb, 
  0x02, 0x81, 0x81, 0x00, 0xc2, 0x5a, 0x3e, 0xc3, 0x76, 0x17, 0x0e, 0xd4, 0x7b, 0x91, 0xd1, 0xbf, 
  0xb4, 0xb0, 0x7f, 0xec, 0x64, 0xfe, 0x3b, 0xf2, 0x21, 0x08, 0x61, 0x50, 0x1e, 0xc1, 0xbe, 0x7d, 
  0x02, 0xf1, 0x83, 0xdc, 0x84, 0x76, 0xcf, 0xe7, 0xaa, 0x56, 0xab, 0x8e, 0x0c, 0x98, 0x7e, 0x74, 
  0x2c, 0x62, 0x21, 0x12, 0xba, 0xec, 0xd1, 0x39, 0x3b, 0x1c, 0x25, 0x86, 0xda, 0x28, 0xf2, 0xf3, 
  0xa4, 0x81, 0x08, 0x71, 0x66, 0x81, 0xc8, 0x52, 0x37, 0xbf, 0x5a, 0x97, 0x29, 0x10, 0xcb, 0x34, 
  0xb6, 0xa7, 0xf9, 0x3f, 0x3c, 0x7f, 0x85, 0xef, 0x9f, 0x18, 0x21, 0x46, 0x46, 0x32, 0xcd, 0xa2, 
  0xf5, 0x0e, 0x6b, 0x13, 0x17, 0x9b, 0x1e, 0xdb, 0x9b, 0x93, 0xaf, 0x1c, 0xdd, 0xbb, 0x05, 0xaa, 
  0x2f, 0xaa, 0xea, 0x13, 0x73, 0xf4, 0x7e, 0x36, 0x53, 0x2e, 0xfb, 0x0c, 0x84, 0x0c, 0xf0, 0xb6, 
  0x67, 0xd8, 0x28, 0x11, 0x02, 0x7f, 0x7b, 0x97, 0x32, 0x01, 0x10, 0xc8, 0xbb, 0x8c, 0x9e, 0xdd, 
  0x5c, 0x7f, 0xe0, 0xf4, 0x75, 0xea, 0x81, 0x99, 0x10, 0xb4, 0x52, 0x25, 0x60, 0xd7, 0xe0, 0xe0, 
  0xc2, 0xc3, 0x70, 0x6b, 0xa3, 0xdc, 0x62, 0xab, 0x10, 0x3e, 0x32, 0x82, 0xec, 0x55, 0xaa, 0x8b, 
  0xbe, 0x31, 0x81, 0x9d, 0xe6, 0x6a, 0x86, 0x8d, 0x0f, 0x9d, 0xa0, 0x9e, 0xc0, 0xac, 0x18, 0x24, 
  0xa8, 0xb9, 0x46, 0x6c, 0x7f, 0x3d, 0xa4, 0xc7, 0xe8, 0x86, 0x52, 0xe7, 0x0e, 0x59, 0x09, 0x35, 
  0x6a, 0xd4, 0xa2, 0x94, 0xf7, 0x34, 0xba, 0x88, 0xcd, 0x60, 0x35, 0x6b, 0x44, 0x24, 0x61, 0xc6, 
  0xca, 0xe4, 0xd9, 0xf6, 0x22, 0xf5, 0x8a, 0xc5, 0x60, 0x45, 0x7c, 0xc5, 0x55, 0xc7, 0x45, 0x4d, 
  0x9c, 0x6e, 0xd2, 0x97, 0xf4, 0x5a, 0x1f, 0xaa, 0xa7, 0x3b, 0x7c, 0x60, 0xca, 0xd5, 0x2f, 0xa1, 
  0x08, 0xf2, 0x46, 0x19, 0x41, 
};

const unsigned char rsa3072_key[1+1769] = {
  ASSH_KEY_FMT_PV_PEM_ASN1,
  0x30, 0x82, 0x06, 0xe5, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01, 0x81, 0x00, 0xc6, 0xbf, 0x76, 0xef, 
  0xa9, 0xc5, 0x3f, 0xea, 0xf9, 0x7b, 0xd3, 0x0a, 0x22, 0x6f, 0xe7, 0xa5, 0x87, 0x47, 0xd9, 0x15, 
  0x16, 0xb5, 0x41, 0x38, 0x9c, 0x17, 0x7a, 0xd8, 0xfc, 0xe7, 0x82, 0x9d, 0xeb, 0x0a, 0x1c, 0x2f, 
  0x60, 0xd9, 0xa2, 0x20, 0xea, 0xa5, 0xc2, 0x4c, 0x71, 0xdd, 0xf4, 0x1e, 0x10, 0x97, 0x6f, 0x40, 
  0x13, 0x89, 0x43, 0xef, 0xa8, 0x69, 0xcf, 0x65, 0xa8, 0x12, 0x42, 0xae, 0x50, 0xd0, 0x43, 0x3b, 
  0x72, 0x5c, 0x9c, 0xea, 0xe7, 0xf9, 0x9d, 0xfc, 0x45, 0x13, 0x33, 0xef, 0xf7, 0x3a, 0x60, 0xc3, 
  0x2f, 0xf1, 0x22, 0x3a, 0x73, 0x76, 0x2c, 0x86, 0x10, 0xfc, 0x1c, 0x3f, 0x9f, 0xeb, 0x91, 0xa9, 
  0xdb, 0x46, 0xdd, 0x76, 0xbc, 0xef, 0xe9, 0x3e, 0x86, 0x11, 0xd7, 0x85, 0x0d, 0xd3, 0xa3, 0xbc, 
  0xea, 0x9d, 0xcf, 0x65, 0x7e, 0x43, 0x78, 0xbb, 0x5f, 0xf9, 0x25, 0x7e, 0xe9, 0x32, 0x78, 0x1c, 
  0xbd, 0xff, 0xff, 0x41, 0xe9, 0x71, 0x46, 0x1a, 0x94, 0xf1, 0x32, 0xe1, 0xb4, 0xe1, 0xc3, 0xf8, 
  0x62, 0xe5, 0xa4, 0x4d, 0xc3, 0x6b, 0xdb, 0x9c, 0x38, 0xcf, 0xb2, 0xdb, 0x8e, 0x10, 0x1e, 0x27, 
  0x42, 0xe0, 0x67, 0xe2, 0x4a, 0x45, 0x7b, 0x2b, 0x05, 0x79, 0xaf, 0x3d, 0x91, 0xe1, 0xcd, 0xcc, 
  0xf7, 0x60, 0x84, 0x36, 0x1a, 0xfc, 0x7d, 0x72, 0xe1, 0xad, 0x50, 0x9d, 0xf5, 0x5a, 0x4c, 0x55, 
  0x94, 0xd4, 0xb7, 0xdc, 0xa5, 0xb5, 0x98, 0xcd, 0x48, 0xab, 0x93, 0xde, 0x10, 0x6c, 0xa7, 0x09, 
  0x56, 0x43, 0x4a, 0xc2, 0x2f, 0x3c, 0x90, 0x13, 0x01, 0x7a, 0x35, 0xac, 0x4c, 0x6b, 0xa5, 0xc3, 
  0x0c, 0x88, 0x56, 0xac, 0x79, 0xb7, 0x09, 0x63, 0x89, 0xc1, 0x76, 0xc8, 0x45, 0xba, 0xec, 0x1f, 
  0xe3, 0x3e, 0x60, 0xac, 0x6a, 0xa2, 0xed, 0x83, 0x1d, 0x8d, 0xfc, 0x15, 0xc6, 0x64, 0x48, 0x6f, 
  0x77, 0xa7, 0x31, 0xf4, 0xfd, 0xf3, 0x34, 0x0c, 0x2e, 0xf9, 0xdb, 0xfc, 0x56, 0x68, 0xf1, 0x73, 
  0xd3, 0x59, 0x7c, 0x69, 0xec, 0x02, 0x7a, 0xd1, 0x8c, 0x4b, 0x7e, 0xf0, 0xd4, 0xda, 0x7e, 0xe7, 
  0xd5, 0x49, 0x93, 0xf0, 0x8d, 0x2d, 0x3a, 0x50, 0x18, 0x6b, 0x49, 0x1d, 0x91, 0xb1, 0x65, 0x09, 
  0xc8, 0xb0, 0x50, 0x02, 0x6e, 0xec, 0xb2, 0xd4, 0xd7, 0x8b, 0xcf, 0xa2, 0xd3, 0x6f, 0x03, 0x9b, 
  0x01, 0x1f, 0x86, 0xe1, 0x29, 0x15, 0x6e, 0xe5, 0xcc, 0x44, 0xec, 0x63, 0xd2, 0x62, 0x94, 0x96, 
  0x07, 0xca, 0xe9, 0x11, 0xda, 0x57, 0x72, 0x3e, 0x3c, 0x1f, 0x9e, 0xa8, 0xcd, 0x9b, 0xb4, 0x46, 
  0xe8, 0x66, 0x58, 0xd1, 0x7b, 0xaa, 0xf3, 0x23, 0xdf, 0x89, 0xf8, 0x7a, 0x78, 0x22, 0x9a, 0x48, 
  0xe5, 0xb9, 0x49, 0x2d, 0xad, 0x7f, 0xaa, 0xf4, 0x1d, 0x02, 0xac, 0xa9, 0x02, 0x03, 0x01, 0x00, 
  0x01, 0x02, 0x82, 0x01, 0x80, 0x0a, 0xc5, 0x95, 0xcc, 0xa7, 0x86, 0xe9, 0x4f, 0xf2, 0xf5, 0xa3, 
  0x1a, 0x89, 0x83, 0x47, 0x2a, 0xd1, 0x8a, 0x33, 0x59, 0xd1, 0x41, 0x41, 0xa7, 0xaf, 0xce, 0x15, 
  0xfa, 0x6c, 0xba, 0x9f, 0x79, 0xaf, 0xa3, 0x7c, 0xa3, 0x94, 0xbc, 0x36, 0xed, 0x51, 0xca, 0x6a, 
  0x1d, 0x7a, 0x8e, 0x6d, 0x0c, 0xb4, 0x19, 0x81, 0x0e, 0x18, 0x00, 0xf8, 0x8d, 0xa4, 0xb3, 0x17, 
  0x6a, 0x8b, 0x11, 0x72, 0x4b, 0xc0, 0x55, 0x89, 0x4f, 0x4f, 0x83, 0x75, 0x7d, 0xc5, 0xd4, 0xe1, 
  0x9b, 0x2a, 0xa3, 0x3f, 0xcd, 0x61, 0xb8, 0xe8, 0x45, 0xab, 0xf3, 0x85, 0xc7, 0x65, 0x3a, 0xa2, 
  0x6f, 0x21, 0xbc, 0x88, 0x4b, 0x6a, 0x7f, 0x7a, 0x05, 0x9a, 0xbc, 0xdc, 0x83, 0xf2, 0xf9, 0x8d, 
  0xca, 0xb5, 0xb9, 0x81, 0xd4, 0xd4, 0x4b, 0x04, 0x34, 0xd9, 0x02, 0x74, 0x9b, 0x2b, 0x9c, 0xbc, 
  0x8e, 0x6b, 0x45, 0x35, 0xa3, 0x0b, 0x40, 0x91, 0x01, 0xfd, 0xca, 0x42, 0x2b, 0x70, 0x5b, 0x93, 
  0x51, 0x1d, 0x81, 0x75, 0x20, 0x86, 0x8d, 0x35, 0xf1, 0xe0, 0x6a, 0x51, 0xdd, 0x65, 0x1a, 0x13, 
  0x6d, 0x04, 0x27, 0x3d, 0xaa, 0x68, 0xa8, 0xb6, 0xf9, 0xa9, 0xc6, 0x3f, 0xdb, 0x23, 0xeb, 0x60, 
  0x21, 0x94, 0xca, 0x63, 0x95, 0x12, 0xb3, 0x0a, 0x54, 0x71, 0x93, 0xe9, 0x96, 0x85, 0x1f, 0xea, 
  0x2c, 0xaf, 0xce, 0x94, 0xef, 0xe2, 0x3b, 0x0a, 0xdd, 0xfb, 0xcc, 0x9a, 0x38, 0x9b, 0x35, 0x8e, 
  0xfa, 0x5d, 0xf7, 0x2b, 0x13, 0x40, 0x69, 0x57, 0xf5, 0xc0, 0x4c, 0x91, 0x79, 0x5a, 0x5e, 0xbc, 
  0x28, 0x78, 0x07, 0x70, 0x8d, 0xb1, 0x9b, 0xaf, 0x61, 0x41, 0x1f, 0x2e, 0x0d, 0x57, 0x95, 0x43, 
  0xb0, 0xfe, 0x7b, 0x16, 0x33, 0xf2, 0x4d, 0xb0, 0x7c, 0x06, 0xde, 0xc1, 0xf3, 0xdb, 0x49, 0xca, 
  0xdd, 0x1f, 0x67, 0x59, 0xd1, 0xcf, 0xa4, 0x00, 0x4d, 0x8a, 0x70, 0x23, 0x74, 0x08, 0xb4, 0x25, 
  0xc3, 0xa5, 0x73, 0x3c, 0x04, 0xcd, 0x72, 0xc0, 0xcc, 0x50, 0xc4, 0xe8, 0x9e, 0x2f, 0xc2, 0xdf, 
  0x12, 0xa4, 0xf3, 0xd6, 0xf4, 0x97, 0xf0, 0xae, 0xc4, 0x30, 0x27, 0x73, 0x5e, 0x36, 0x5e, 0xf2, 
  0xcf, 0x49, 0xcd, 0xf4, 0xfc, 0x8d, 0xcf, 0x0e, 0xb2, 0xc8, 0xf5, 0x77, 0xc1, 0x39, 0xb0, 0x64, 
  0x72, 0xfa, 0xae, 0xc2, 0x10, 0xf2, 0x93, 0x20, 0x7f, 0xa3, 0x9f, 0x28, 0xaa, 0x6a, 0xac, 0xae, 
  0x86, 0x51, 0x8e, 0x45, 0x3c, 0xac, 0xa7, 0x6c, 0x4d, 0x56, 0x21, 0x95, 0x0b, 0xbe, 0x61, 0xb1, 
  0xa5, 0xc3, 0x31, 0x9f, 0x01, 0xdf, 0x12, 0x40, 0xfd, 0x80, 0x8c, 0xbd, 0x56, 0xac, 0xc5, 0x5f, 
  0x11, 0x20, 0xc9, 0x3a, 0x22, 0x52, 0xfc, 0x12, 0xbf, 0x08, 0x74, 0x13, 0x27, 0x8c, 0xe9, 0x1e, 
  0x44, 0xbd, 0x38, 0xb0, 0x01, 0x02, 0x81, 0xc1, 0x00, 0xf1, 0x1e, 0x45, 0xe5, 0x82, 0x7d, 0x02, 
  0x1e, 0x4e, 0xe1, 0xdc, 0x36, 0x39, 0xa1, 0x2a, 0x43, 0x6a, 0x67, 0x7a, 0x6b, 0x43, 0x4c, 0x8f, 
  0x4b, 0xa9, 0x1a, 0x9c, 0x00, 0x85, 0x93, 0x56, 0x00, 0xb5, 0x5e, 0x8e, 0xab, 0xa0, 0xd9, 0x4d, 
  0xb1, 0x01, 0xb8, 0xe3, 0xd7, 0x99, 0xe7, 0x41, 0x57, 0xaa, 0xc9, 0xff, 0x52, 0x71, 0x6a, 0x2e, 
  0xbd, 0x9b, 0x16, 0x2c, 0x15, 0x33, 0xc1, 0x23, 0x60, 0xc1, 0x27, 0x67, 0x46, 0x6e, 0x96, 0x5b, 
  0xaa, 0xc8, 0xf9, 0xfd, 0xee, 0x96, 0xa1, 0xd9, 0x7c, 0xdc, 0xf5, 0x0d, 0x57, 0x1f, 0x11, 0x85, 
  0x96, 0xda, 0x40, 0x71, 0x44, 0x7c, 0x64, 0x45, 0x78, 0x13, 0x65, 0xb1, 0x8d, 0x38, 0x72, 0x08, 
  0x73, 0x6c, 0x14, 0x81, 0x8b, 0xcf, 0xbb, 0x4f, 0x78, 0x77, 0x4f, 0xd5, 0x27, 0x4c, 0x84, 0xc8, 
  0xac, 0xbf, 0x00, 0x59, 0x13, 0xfa, 0x3b, 0xac, 0x7b, 0x7e, 0x4e, 0x6f, 0x14, 0xaf, 0xa2, 0x80, 
  0x1d, 0x58, 0x93, 0xf5, 0xc2, 0x29, 0x90, 0x68, 0x3f, 0x27, 0xe8, 0xf3, 0xbf, 0x47, 0x69, 0x66, 
  0x01, 0xf6, 0x6e, 0xd0, 0x01, 0x3c, 0x1d, 0xf1, 0x91, 0x04, 0xa1, 0x18, 0x72, 0x93, 0x52, 0x03, 
  0x73, 0x5d, 0x66, 0x33, 0x0b, 0x00, 0x1b, 0x0f, 0xb0, 0x8c, 0x61, 0x5a, 0x2a, 0xf1, 0x11, 0x73, 
  0x9c, 0xf8, 0x2d, 0x7d, 0x0f, 0x92, 0x4f, 0x60, 0x79, 0x02, 0x81, 0xc1, 0x00, 0xd3, 0x03, 0xba, 
  0xd5, 0x11, 0x94, 0x64, 0xa5, 0xbb, 0x48, 0x9f, 0xc4, 0x40, 0x83, 0xfe, 0xc3, 0x55, 0x8b, 0x7d, 
  0x67, 0x47, 0xd7, 0x78, 0x27, 0x41, 0x83, 0x80, 0x3c, 0xd9, 0x50, 0x58, 0x61, 0xa1, 0xe8, 0x1e, 
  0x3b, 0x21, 0xd9, 0xc2, 0xe3, 0xff, 0xe0, 0x81, 0x59, 0x0a, 0xa8, 0x49, 0x1c, 0xf7, 0x13, 0x51, 
  0x94, 0x68, 0xfa, 0xc4, 0x31, 0xe4, 0x79, 0xdc, 0x9b, 0x4c, 0xa6, 0x20, 0xb2, 0x08, 0x47, 0x43, 
  0x11, 0x32, 0xbf, 0x1d, 0x7c, 0x11, 0xca, 0x0a, 0xe3, 0x21, 0x12, 0xb6, 0xf6, 0xb8, 0x54, 0xe1, 
  0xdf, 0x79, 0x61, 0xcf, 0x64, 0xea, 0x79, 0x79, 0x02, 0x64, 0xc4, 0xec, 0xc1, 0x7b, 0xe3, 0x05, 
  0x81, 0xe5, 0xce, 0x10, 0xd8, 0xad, 0xfc, 0x62, 0x68, 0x46, 0x94, 0x62, 0xfa, 0x3c, 0x23, 0x8b, 
  0x23, 0xa9, 0xb3, 0x8c, 0x9e, 0x3b, 0x56, 0x93, 0x2b, 0x04, 0x65, 0x20, 0xde, 0x59, 0x72, 0x3b, 
  0x88, 0x53, 0xe1, 0x9e, 0x4a, 0x7e, 0x1e, 0xca, 0xcb, 0xfd, 0x79, 0x37, 0x3f, 0x0d, 0x59, 0xd9, 
  0x00, 0x16, 0xf2, 0x00, 0xf2, 0xd0, 0x7d, 0x63, 0x6e, 0x3c, 0x97, 0x6d, 0x6a, 0xf3, 0x59, 0x29, 
  0xaf, 0x52, 0x08, 0xf4, 0x41, 0xb6, 0xc5, 0x0c, 0xe3, 0xd6, 0x9d, 0x66, 0xcd, 0x96, 0x89, 0x7c, 
  0x6f, 0x05, 0xba, 0x99, 0xea, 0xa6, 0x48, 0x25, 0xf9, 0x9f, 0xa4, 0x81, 0xb1, 0x02, 0x81, 0xc1, 
  0x00, 0x8f, 0x93, 0xd8, 0x49, 0x47, 0x7f, 0x8a, 0xf0, 0x63, 0x46, 0x89, 0x2b, 0xdc, 0xfb, 0x44, 
  0x40, 0x6a, 0xae, 0xfd, 0xad, 0xbb, 0xa0, 0x6e, 0x3f, 0xbe, 0x8d, 0xb2, 0xd1, 0x78, 0xb8, 0xf8, 
  0x60, 0x69, 0x9f, 0xc9, 0xd3, 0x17, 0x6f, 0xee, 0x9c, 0x75, 0x8b, 0x14, 0x59, 0x81, 0x32, 0xbc, 
  0xad, 0x28, 0x6d, 0x2a, 0x55, 0x7c, 0x65, 0x9f, 0x39, 0x96, 0x8d, 0x08, 0x69, 0x03, 0xad, 0x81, 
  0x94, 0x8e, 0xd0, 0x18, 0xe6, 0x4e, 0xd9, 0xc7, 0xf2, 0x15, 0xc5, 0x0f, 0x59, 0xb0, 0x66, 0xe6, 
  0x2c, 0x3d, 0x22, 0xca, 0xf3, 0xd2, 0xf3, 0x4b, 0x1a, 0x3e, 0x12, 0x5b, 0xa0, 0x4d, 0x76, 0x24, 
  0x0b, 0xd1, 0x79, 0x1f, 0xd6, 0x19, 0x03, 0x86, 0x56, 0xbc, 0xc8, 0x25, 0x30, 0x0c, 0xdd, 0xdb, 
  0xff, 0xbf, 0x04, 0x51, 0xc8, 0x19, 0xff, 0x83, 0xc3, 0xa1, 0xe4, 0xe2, 0x26, 0x4c, 0x3e, 0x96, 
  0x81, 0xde, 0xff, 0x73, 0x93, 0xdc, 0xd6, 0x25, 0xf5, 0xd3, 0x96, 0x1f, 0xa4, 0xa3, 0xbd, 0x72, 
  0xe6, 0x10, 0xac, 0xdd, 0xe0, 0x4b, 0xf4, 0xce, 0x22, 0x63, 0x0d, 0x2f, 0x5d, 0x5c, 0xdf, 0xf3, 
  0xc5, 0xc7, 0xfc, 0xe9, 0xa2, 0xe8, 0x68, 0xd0, 0xd7, 0x34, 0x89, 0xb3, 0xe1, 0x5c, 0x09, 0xc1, 
  0x38, 0xff, 0x0e, 0xc5, 0x73, 0x86, 0xa3, 0x3e, 0xb5, 0xfc, 0xee, 0x91, 0x66, 0xe1, 0x57, 0xd4, 
  0xf9, 0x02, 0x81, 0xc1, 0x00, 0x88, 0xa4, 0xe6, 0xac, 0xa9, 0x48, 0xa5, 0xf0, 0x68, 0x99, 0xfb, 
  0xd3, 0xb3, 0x4f, 0x86, 0x7f, 0x69, 0x7a, 0xfd, 0xc7, 0x0e, 0xcf, 0xaa, 0x20, 0x09, 0x9d, 0xa5, 
  0x42, 0x42, 0x1b, 0x74, 0x50, 0x2c, 0xef, 0x49, 0xfc, 0x52, 0xcc, 0x58, 0x17, 0x1b, 0x10, 0x7f, 
  0xd2, 0x70, 0x43, 0x4f, 0xad, 0x31, 0x16, 0x52, 0x82, 0xbf, 0x84, 0x7b, 0xde, 0x2f, 0x2c, 0xf6, 
  0xbd, 0x9e, 0x62, 0x09, 0xd4, 0x1f, 0xe6, 0x3d, 0xb8, 0xfa, 0x5a, 0xa6, 0x36, 0x3c, 0xb2, 0xd0, 
  0x60, 0x0a, 0x7f, 0xba, 0xf9, 0x83, 0x9e, 0x7b, 0xf2, 0x22, 0x01, 0x43, 0xb2, 0xfe, 0xdf, 0x90, 
  0x8c, 0x0b, 0x43, 0x36, 0x69, 0x88, 0xd7, 0x17, 0x2e, 0xe9, 0xe8, 0x8a, 0x22, 0x36, 0x70, 0xb4, 
  0x2d, 0x00, 0x5f, 0x80, 0xc4, 0xb8, 0x82, 0xef, 0xcc, 0x35, 0x4d, 0x6e, 0xe6, 0xdc, 0x58, 0x10, 
  0xcf, 0x0f, 0x76, 0x89, 0x55, 0x53, 0x28, 0xd5, 0x02, 0x50, 0x07, 0x4f, 0x60, 0xbf, 0xd1, 0x22, 
  0xd3, 0xfc, 0x1d, 0x2d, 0xb8, 0x67, 0xe5, 0xe1, 0xce, 0xdc, 0x0c, 0xf4, 0xae, 0x48, 0x72, 0x9a, 
  0x1b, 0xbd, 0xa2, 0xf5, 0x99, 0x07, 0x62, 0x9a, 0xca, 0xcc, 0x5d, 0xbe, 0x06, 0x7b, 0xdb, 0x98, 
  0xa0, 0x45, 0xcf, 0x01, 0xce, 0x6a, 0x08, 0x38, 0x0b, 0x10, 0xf3, 0xa8, 0x4e, 0x3a, 0x45, 0x88, 
  0x49, 0xe0, 0xa6, 0x3f, 0xd1, 0x02, 0x81, 0xc1, 0x00, 0xd2, 0x50, 0xe1, 0x1d, 0xfc, 0x7a, 0xfb, 
  0xfa, 0x0c, 0x17, 0xf0, 0x5e, 0x10, 0x43, 0x1c, 0x4f, 0x2b, 0x20, 0x18, 0x59, 0x26, 0x83, 0x0d, 
  0xa1, 0xcd, 0x0a, 0x2e, 0xdb, 0x11, 0x31, 0x62, 0xde, 0x55, 0xbb, 0xa7, 0x84, 0xa4, 0x0f, 0xe7, 
  0xc9, 0x9e, 0x3f, 0x61, 0x36, 0x00, 0x3a, 0xa0, 0x7c, 0xc5, 0x54, 0x31, 0x93, 0x95, 0x79, 0x9c, 
  0xf9, 0x18, 0x24, 0x3f, 0x8f, 0xc6, 0x8d, 0x7e, 0x14, 0x59, 0x31, 0x4c, 0xab, 0xcf, 0x97, 0x14, 
  0x6d, 0x69, 0x05, 0x90, 0x96, 0xf7, 0xb7, 0xd0, 0xbf, 0x7d, 0x68, 0xa0, 0xcc, 0xf2, 0x37, 0x62, 
  0x63, 0x1b, 0x5e, 0x16, 0x8d, 0xea, 0xec, 0x35, 0x8e, 0x55, 0x78, 0xb8, 0x2a, 0xa9, 0xa9, 0xe9, 
  0xd4, 0x32, 0x8b, 0x97, 0x67, 0x75, 0x34, 0xdf, 0x2a, 0xad, 0x3c, 0x2c, 0x77, 0xb1, 0x13, 0x21, 
  0xb2, 0x27, 0x96, 0xf7, 0xd3, 0x99, 0x5a, 0x62, 0x60, 0xa6, 0x21, 0xff, 0x5f, 0xfa, 0xe1, 0x50, 
  0xdd, 0x97, 0x0e, 0xcf, 0xd3, 0x10, 0xba, 0x83, 0x21, 0xf4, 0x7d, 0xac, 0x5f, 0x4f, 0x2d, 0x93, 
  0xae, 0x6f, 0xac, 0x66, 0xe5, 0x6a, 0xe3, 0xcf, 0x58, 0x06, 0xbe, 0x09, 0xd3, 0x50, 0x25, 0x59, 
  0x21, 0x0c, 0xb9, 0x5b, 0xb4, 0x71, 0xdf, 0xab, 0x73, 0x27, 0x26, 0xf4, 0xe2, 0x49, 0x4c, 0x68, 
  0x5d, 0x5b, 0xba, 0xe0, 0x32, 0x15, 0x48, 0x08, 0x18, 
};

const unsigned char ed25519_key[1+119] = {
  ASSH_KEY_FMT_PV_OPENSSH_V1_KEY,
  0x00, 0x00, 0x00, 0x0B, 0x73, 0x73, 0x68, 0x2D, 0x65, 0x64, 0x32, 0x35, 0x35, 0x31, 0x39,
  0x00, 0x00, 0x00, 0x20, 0x02, 0xbf, 0x07, 0x21, 0xff, 0x34, 0xac, 0x34, 0x42, 0x3b, 0x1f, 0x04,
  0x4d, 0x83, 0x7a, 0x76, 0x15, 0x50, 0x24, 0x4d, 0x5b, 0xc8, 0xaf, 0x72, 0x5c, 0x31, 0x53, 0x4b,
  0x7e, 0x33, 0x26, 0x71,
  0x00, 0x00, 0x00, 0x40, 0x4d, 0xb0, 0xf0, 0xad, 0x9e, 0x6d, 0x0d, 0x1e, 0x25, 0xbc, 0x9e, 0xc2,
  0x85, 0x01, 0x74, 0x1e, 0xdd, 0xc5, 0x95, 0x8b, 0x12, 0x67, 0xc2, 0xce, 0x07, 0x41, 0x36, 0xdd,
  0x2c, 0x5f, 0xf4, 0x22, 0x02, 0xbf, 0x07, 0x21, 0xff, 0x34, 0xac, 0x34, 0x42, 0x3b, 0x1f, 0x04,
  0x4d, 0x83, 0x7a, 0x76, 0x15, 0x50, 0x24, 0x4d, 0x5b, 0xc8, 0xaf, 0x72, 0x5c, 0x31, 0x53, 0x4b,
  0x7e, 0x33, 0x26, 0x71,
};

const unsigned char eddsa_e382_key[1+175] = {
  ASSH_KEY_FMT_PV_OPENSSH_V1_KEY,
  0x00, 0x00, 0x00, 0x13, 0x65, 0x64, 0x64, 0x73, 0x61, 0x2d, 0x65, 0x33, 0x38, 0x32, 0x2d, 0x73, 
  0x68, 0x61, 0x6b, 0x65, 0x32, 0x35, 0x36,
  0x00, 0x00, 0x00, 0x30, 0xbd, 0xfc, 0xfa, 0x80, 0xd8, 0xa2, 0x5e, 0x80, 0xc7, 0xb5, 0xf2, 0x75,
  0x78, 0x81, 0xa5, 0xb4, 0x6f, 0xfd, 0x8d, 0x3f, 0x1d, 0xde, 0x4f, 0xce, 0xaa, 0x48, 0xf5, 0x16,
  0x4a, 0x0a, 0xb5, 0x47, 0x1a, 0xb8, 0xde, 0xfe, 0x67, 0x23, 0xda, 0x40, 0xa5, 0x76, 0xae, 0x87,
  0x06, 0x0c, 0xe7, 0x27,
  0x00, 0x00, 0x00, 0x60, 0xb5, 0x4d, 0x18, 0x64, 0x62, 0x3e, 0x60, 0x3a, 0x1a, 0xb4, 0xd4, 0xaa,
  0xf4, 0x76, 0x1f, 0x3f, 0x01, 0xec, 0xa6, 0x07, 0x1e, 0x04, 0xc5, 0x08, 0xd0, 0xe7, 0x6e, 0x2f,
  0x78, 0x68, 0xa9, 0x11, 0xee, 0x8e, 0x80, 0x40, 0x8f, 0x7f, 0x2a, 0xa3, 0xd6, 0x73, 0x81, 0xbd,
  0x70, 0xff, 0xd7, 0x60, 0xbd, 0xfc, 0xfa, 0x80, 0xd8, 0xa2, 0x5e, 0x80, 0xc7, 0xb5, 0xf2, 0x75,
  0x78, 0x81, 0xa5, 0xb4, 0x6f, 0xfd, 0x8d, 0x3f, 0x1d, 0xde, 0x4f, 0xce, 0xaa, 0x48, 0xf5, 0x16,
  0x4a, 0x0a, 0xb5, 0x47, 0x1a, 0xb8, 0xde, 0xfe, 0x67, 0x23, 0xda, 0x40, 0xa5, 0x76, 0xae, 0x87,
  0x06, 0x0c, 0xe7, 0x27, 
};

const unsigned char eddsa_e521_key[1+229] = {
  ASSH_KEY_FMT_PV_OPENSSH_V1_KEY,
  0x00, 0x00, 0x00, 0x13, 0x65, 0x64, 0x64, 0x73, 0x61, 0x2d, 0x65, 0x35, 0x32, 0x31, 0x2d, 0x73, 
  0x68, 0x61, 0x6b, 0x65, 0x32, 0x35, 0x36,
  0x00, 0x00, 0x00, 0x42, 0xf3, 0x80, 0x8b, 0x19, 0xa4, 0xa7, 0xa0, 0xd5, 0x44, 
  0x01, 0x35, 0x1a, 0x3c, 0x83, 0xad, 0x80, 0x75, 0xda, 0x85, 0x2a, 0x5c, 0xd6, 0xd1, 0xc3, 0xfb, 
  0x13, 0x8e, 0xc9, 0xd4, 0xfb, 0x1d, 0x07, 0x2b, 0x3f, 0x2f, 0x6e, 0x33, 0x31, 0xe7, 0xf4, 0x3e, 
  0xd3, 0x89, 0x64, 0xd1, 0x1a, 0x5e, 0xdd, 0x42, 0x00, 0xdb, 0xcb, 0x9f, 0x94, 0x12, 0x2c, 0x0c, 
  0x63, 0x6d, 0x6f, 0x44, 0xf8, 0x18, 0x62, 0x47, 0x80, 0x00, 0x00, 0x00, 0x84, 0xa8, 0x87, 0x17, 
  0x5e, 0xfb, 0xff, 0x51, 0x7d, 0x21, 0x7d, 0x4d, 0x0d, 0xfe, 0xe5, 0x48, 0x81, 0xbc, 0xc9, 0x1f, 
  0x9d, 0xe3, 0x54, 0x66, 0x10, 0xb0, 0x47, 0xc2, 0x4c, 0xaf, 0x59, 0xa9, 0x2b, 0x61, 0x54, 0xce, 
  0xf4, 0xab, 0xa2, 0x85, 0xfd, 0x85, 0xd2, 0x4e, 0x6e, 0xfe, 0xe1, 0x2c, 0x81, 0x5a, 0xa2, 0x32, 
  0x2b, 0xfd, 0xb7, 0x1c, 0xc9, 0xef, 0x02, 0xb8, 0xbc, 0x1a, 0xa6, 0xd7, 0xa3, 0xe4, 0x08, 0xf3, 
  0x80, 0x8b, 0x19, 0xa4, 0xa7, 0xa0, 0xd5, 0x44, 0x01, 0x35, 0x1a, 0x3c, 0x83, 0xad, 0x80, 0x75, 
  0xda, 0x85, 0x2a, 0x5c, 0xd6, 0xd1, 0xc3, 0xfb, 0x13, 0x8e, 0xc9, 0xd4, 0xfb, 0x1d, 0x07, 0x2b, 
  0x3f, 0x2f, 0x6e, 0x33, 0x31, 0xe7, 0xf4, 0x3e, 0xd3, 0x89, 0x64, 0xd1, 0x1a, 0x5e, 0xdd, 0x42, 
  0x00, 0xdb, 0xcb, 0x9f, 0x94, 0x12, 0x2c, 0x0c, 0x63, 0x6d, 0x6f, 0x44, 0xf8, 0x18, 0x62, 0x47, 
  0x80, 
};

const unsigned char ecdsa_nistp256_key[1+140] = {
  ASSH_KEY_FMT_PV_OPENSSH_V1_KEY,
  0x00, 0x00, 0x00, 0x13, 0x65, 0x63, 0x64, 0x73, 0x61, 0x2d, 0x73, 0x68, 0x61, 0x32, 0x2d, 0x6e,
  0x69, 0x73, 0x74, 0x70, 0x32, 0x35, 0x36, 0x00, 0x00, 0x00, 0x08, 0x6e, 0x69, 0x73, 0x74, 0x70,
  0x32, 0x35, 0x36, 0x00, 0x00, 0x00, 0x41, 0x04, 0xb0, 0x91, 0xee, 0x9a, 0xc6, 0x5f, 0x5c, 0xde,
  0x84, 0xb9, 0x8d, 0x3c, 0x25, 0x4a, 0xf7, 0x78, 0x47, 0xe0, 0x29, 0x49, 0x33, 0xe1, 0xd5, 0x6a,
  0x44, 0x0e, 0x69, 0x97, 0x71, 0xca, 0x96, 0x7f, 0x2b, 0x79, 0xdc, 0x40, 0xc8, 0x1b, 0x54, 0x94,
  0x59, 0x73, 0x1f, 0x4f, 0xc4, 0xc6, 0x79, 0x3c, 0xa6, 0x0d, 0x84, 0x26, 0xe4, 0xd3, 0x31, 0xf3,
  0x43, 0xbb, 0x7b, 0x62, 0x5d, 0xb3, 0xb8, 0x04, 0x00, 0x00, 0x00, 0x20, 0x33, 0xd3, 0xc3, 0xbd,
  0x8a, 0x2b, 0x6a, 0xc3, 0x55, 0xbd, 0xb2, 0x99, 0x52, 0xff, 0x22, 0x08, 0xd9, 0xfa, 0x0f, 0x8a,
  0x19, 0x90, 0xf8, 0x1d, 0xc7, 0x27, 0x89, 0x3e, 0x13, 0x39, 0xbb, 0x50,
};

const unsigned char ecdsa_nistp384_key[1+189] = {
  ASSH_KEY_FMT_PV_OPENSSH_V1_KEY,
  0x00, 0x00, 0x00, 0x13, 0x65, 0x63, 0x64, 0x73, 0x61, 0x2d, 0x73, 0x68, 0x61, 0x32, 0x2d, 0x6e,
  0x69, 0x73, 0x74, 0x70, 0x33, 0x38, 0x34, 0x00, 0x00, 0x00, 0x08, 0x6e, 0x69, 0x73, 0x74, 0x70,
  0x33, 0x38, 0x34, 0x00, 0x00, 0x00, 0x61, 0x04, 0x28, 0x53, 0x7c, 0x02, 0x44, 0xa4, 0xff, 0x10,
  0x21, 0xc7, 0x41, 0x1b, 0x99, 0xe5, 0xbd, 0x4b, 0xb3, 0x38, 0xf8, 0xf9, 0x08, 0x28, 0xb8, 0x29,
  0xae, 0xdc, 0x89, 0x19, 0x9c, 0xfa, 0x0d, 0xbe, 0xb3, 0x18, 0xd5, 0x1b, 0x62, 0x9b, 0xd8, 0x4d,
  0xf8, 0x09, 0xf3, 0x08, 0xde, 0x47, 0x35, 0x42, 0xe1, 0x66, 0x64, 0xe9, 0x39, 0x80, 0xcc, 0xb4,
  0xe9, 0x82, 0x43, 0x3d, 0x9c, 0xc2, 0xf1, 0xc0, 0x92, 0x18, 0xce, 0x78, 0x92, 0x20, 0x51, 0xef,
  0xaf, 0x48, 0x49, 0xdd, 0xb8, 0x28, 0x62, 0xc8, 0x01, 0xea, 0xb0, 0x0d, 0x76, 0xdb, 0x53, 0xeb,
  0x0c, 0xdb, 0x9b, 0x66, 0x14, 0x5c, 0x01, 0x79, 0x00, 0x00, 0x00, 0x31, 0x00, 0x99, 0xbb, 0xf9,
  0x48, 0xfc, 0x3e, 0x6c, 0xec, 0xf8, 0x10, 0xcf, 0x3b, 0x01, 0x09, 0x59, 0x08, 0xd1, 0x4a, 0x46,
  0x20, 0x1c, 0xea, 0xc3, 0x85, 0x31, 0xa4, 0x1c, 0x3d, 0x40, 0x59, 0x69, 0x5c, 0x82, 0x36, 0xa9,
  0x1e, 0xae, 0x8c, 0xa8, 0x39, 0xc3, 0x42, 0x87, 0xe5, 0x98, 0x39, 0x7e, 0x4a,
};

const unsigned char ecdsa_nistp521_key[1+242] = {
  ASSH_KEY_FMT_PV_OPENSSH_V1_KEY,
  0x00, 0x00, 0x00, 0x13, 0x65, 0x63, 0x64, 0x73, 0x61, 0x2d, 0x73, 0x68, 0x61, 0x32, 0x2d, 0x6e,
  0x69, 0x73, 0x74, 0x70, 0x35, 0x32, 0x31, 0x00, 0x00, 0x00, 0x08, 0x6e, 0x69, 0x73, 0x74, 0x70,
  0x35, 0x32, 0x31, 0x00, 0x00, 0x00, 0x85, 0x04, 0x01, 0xa2, 0x43, 0xdd, 0x37, 0xc2, 0x86, 0xbd,
  0x45, 0x39, 0x00, 0x76, 0xd1, 0x1e, 0x18, 0x38, 0x78, 0xd9, 0x24, 0x59, 0x6c, 0x67, 0xfd, 0x97,
  0x64, 0x3e, 0xe1, 0xd2, 0x43, 0xfe, 0x47, 0x5d, 0xc5, 0x2a, 0x90, 0xbb, 0x47, 0x47, 0x94, 0xe0,
  0x1e, 0x8f, 0xb2, 0x02, 0xd7, 0xcc, 0x1a, 0x0f, 0x82, 0x82, 0xcf, 0xbd, 0x87, 0xba, 0xbd, 0xee,
  0x1b, 0x1b, 0xea, 0xea, 0x84, 0x72, 0xee, 0x10, 0x0c, 0x9b, 0x00, 0x77, 0x48, 0x9d, 0xf4, 0xaa,
  0xce, 0xb2, 0x00, 0x76, 0x84, 0x28, 0xc4, 0x6e, 0x19, 0x06, 0xdd, 0xfa, 0x03, 0xeb, 0x25, 0x46,
  0x84, 0x9a, 0xc7, 0x14, 0x7f, 0x8b, 0x00, 0x2d, 0x06, 0x3a, 0xde, 0x79, 0xde, 0x16, 0x36, 0x49,
  0x03, 0x24, 0x41, 0x10, 0x07, 0xbc, 0x15, 0xc4, 0x7e, 0x9a, 0x31, 0x25, 0x42, 0xbb, 0xde, 0xc5,
  0xcf, 0xcf, 0x7e, 0x02, 0x22, 0x37, 0xdf, 0x58, 0x15, 0x84, 0x7c, 0x44, 0x00, 0x00, 0x00, 0x42,
  0x01, 0x16, 0x59, 0xfc, 0xf1, 0xfe, 0x2d, 0xec, 0xa5, 0xf9, 0x27, 0x75, 0xb8, 0xa4, 0x0a, 0x71,
  0x50, 0xb7, 0x2c, 0x54, 0x61, 0x63, 0x19, 0x6b, 0x66, 0x2b, 0xb4, 0xeb, 0x1a, 0xb4, 0x68, 0x17,
  0xd9, 0xb1, 0x2e, 0x02, 0xc3, 0x94, 0xff, 0x81, 0xbd, 0x5d, 0x20, 0xf7, 0xca, 0xde, 0x49, 0x38,
  0x10, 0x97, 0xdc, 0xe0, 0x84, 0x25, 0x9a, 0x0a, 0x92, 0x79, 0xbb, 0x93, 0xaf, 0x70, 0x0d, 0x48,
  0x90, 0x6e,
};

const unsigned char none0_key[1] = {
  ASSH_KEY_FMT_PV_PEM_ASN1,
};
