#!/bin/bash

# LFS-Install - An Automated Linux From Scratch-Installer
# Copyright (C) 2002-2004 Daniel Baumann <daniel.baumann@panthera-systems.net>
#
# This program comes with ABSOLUTELY NO WARRANTY; for details see COPYING.
# This is free software, and you are welcome to redistribute it
# under certain conditions; see COPYING for details.


case "$1" in
	chapter5)
		cd $LFS_SOURCES
		tar xfz util-linux-2.12.tar.gz
		cd util-linux-2.12

		cp configure configure.backup
		sed "s@/usr/include@/tools/include@g" configure.backup > configure 
		./configure
		make -C lib
		make -C mount  mount umount
		make -C text-utils  more
		cp mount/{,u}mount text-utils/more /tools/bin

		cd ..
		rm -rf util-linux-2.12
		;;

	chapter6)
		cd $LFS_SOURCES
		tar xfz util-linux-2.12.tar.gz
		cd util-linux-2.12

		cp hwclock/hwclock.c{,.backup}
		sed 's%etc/adjtime%var/lib/hwclock/adjtime%' \
			hwclock/hwclock.c.backup > hwclock/hwclock.c
		mkdir -p /var/lib/hwclock
		./configure
		make HAVE_SLN=yes
		make HAVE_SLN=yes install

		cd ..
		rm -rf util-linux-2.12
		;;
esac
