#!/bin/bash

# LFS-Install - An Automated Linux From Scratch-Installer
# Copyright (C) 2002-2004 Daniel Baumann <daniel.baumann@panthera-systems.net>
#
# This program comes with ABSOLUTELY NO WARRANTY; for details see COPYING.
# This is free software, and you are welcome to redistribute it
# under certain conditions; see COPYING for details.


case "$1" in
	chapter5)
		cd $LFS_SOURCES
		tar xfz gzip-1.3.5.tar.gz
		cd gzip-1.3.5

		./configure --prefix=/tools
		make
		make install

		cd ..
		rm -rf gzip-1.3.5
		;;

	chapter6)
		cd $LFS_SOURCES
		tar xfz gzip-1.3.5.tar.gz
		cd gzip-1.3.5

		./configure --prefix=/usr
		cp gzexe.in{,.backup}
		sed 's%"BINDIR"%/bin%' gzexe.in.backup > gzexe.in
		make
		make install
		mv /usr/bin/gzip /bin
		rm /usr/bin/{gunzip,zcat}
		ln -s gzip /bin/gunzip
		ln -s gzip /bin/zcat
		ln -s gunzip /bin/uncompress

		cd ..
		rm -rf gzip-1.3.5
		;;
esac
