#!/bin/bash

# LFS-Install - An Automated Linux From Scratch-Installer
# Copyright (C) 2002-2004 Daniel Baumann <daniel.baumann@panthera-systems.net>
#
# This program comes with ABSOLUTELY NO WARRANTY; for details see COPYING.
# This is free software, and you are welcome to redistribute it
# under certain conditions; see COPYING for details.


case "$1" in
	chapter5)
		cd $LFS_SOURCES
		tar xfz glibc-2.3.2.tar.gz
		tar xfz glibc-linuxthreads-2.3.2.tar.gz -C glibc-2.3.2
		cd glibc-2.3.2

		mkdir /tools/etc
		touch /tools/etc/ld.so.conf
		patch -Np1 -i ../glibc-2.3.2-sscanf-1.patch
		mkdir ../glibc-build
		cd ../glibc-build
		../glibc-2.3.2/configure --prefix=/tools \
			--disable-profile --enable-add-ons \
			--with-headers=/tools/include \
			--with-binutils=/tools/bin \
			--without-gd
		make
		#make check
		make install
		make localedata/install-locales

		cd ..
		rm -rf glibc-2.3.2
		;;

	chapter6)
		cd $LFS_SOURCES
		tar xfz glibc-2.3.2.tar.gz
		tar xfz glibc-linuxthreads-2.3.2.tar.gz -C glibc-2.3.2
		cd glibc-2.3.2

		touch /etc/ld.so.conf
		patch -Np1 -i ../glibc-2.3.2-sscanf-1.patch
		mkdir ../glibc-build
		cd ../glibc-build
		../glibc-2.3.2/configure --prefix=/usr \
			--disable-profile --enable-add-ons \
			--libexecdir=/usr/bin --with-headers=/usr/include
		make
		#make check
		make install
		make localedata/install-locales
		make -C ../glibc-2.3.2/linuxthreads/man
		make -C ../glibc-2.3.2/linuxthreads/man install

cat > /etc/nsswitch.conf << "EOF"
# Begin /etc/nsswitch.conf

passwd: files
group: files
shadow: files

publickey: files

hosts: files dns
networks: files

protocols: db files
services: db files
ethers: db files
rpc: db files

netgroup: db files

# End /etc/nsswitch.conf
EOF

		cp --remove-destination /usr/share/zoneinfo/GMT /etc/localtime

cat > /etc/ld.so.conf << "EOF"
# Begin /etc/ld.so.conf

/usr/local/lib
/opt/lib

# End /etc/ld.so.conf
EOF
		;;
esac
