#!/bin/bash

# LFS-Install - An Automated Linux From Scratch-Installer
# Copyright (C) 2002-2004 Daniel Baumann <daniel.baumann@panthera-systems.net>
#
# This program comes with ABSOLUTELY NO WARRANTY; for details see COPYING.
# This is free software, and you are welcome to redistribute it
# under certain conditions; see COPYING for details.


case "$1" in
	chapter5_pass1)
		cd $LFS_SOURCES
		tar xfz binutils-2.14.tar.gz
		cd binutils-2.14

		mkdir ../binutils-build
		cd ../binutils-build
		../binutils-2.14/configure \
			--prefix=/tools --disable-nls
		make configure-host
		make LDFLAGS="-all-static"
		make install
		make -C ld clean
		make -C ld LDFLAGS="-all-static" LIB_PATH=/tools/lib

		# Build and source directory are removed later (FIXME)
		;;

	chapter5_locking-in-glibc)
		cd $LFS_SOURCES/binutils-build

		make -C ld install
		rm -f /tools/lib/gcc-lib/*/*/include/{pthread.h,bits/sigthread.h}

		cd ..
		rm -rf binutils-{2.14,build}
		;;

	chapter5_pass2)
		cd $LFS_SOURCES
		tar xfz binutils-2.14.tar.gz
		cd binutils-2.14

		mkdir ../binutils-build
		cd ../binutils-build
		../binutils-2.14/configure --prefix=/tools \
			--enable-shared --with-lib-path=/tools/lib
		make
		#make check
		make install
		make -C ld clean
		make -C ld LIB_PATH=/usr/lib:/lib

		# do not remove sources # FIXME
		;;

	chapter6_re-adjusting-the-toolchain)
		cd $LFS_SOURCES/binutils-build

		make -C ld INSTALL=/tools/bin/install install
		SPECFILE=/tools/lib/gcc-lib/*/*/specs &&
		sed -e 's@ /tools/lib/ld-linux.so.2@ /lib/ld-linux.so.2@g' \
			$SPECFILE > newspecfile &&
		mv -f newspecfile $SPECFILE &&
		unset SPECFILE

		cd ..
		rm -rf binutils-{2.14,build}
		;;

	chapter6)
		cd $LFS_SOURCES
		tar xfz binutils-2.14.tar.gz
		cd binutils-2.14

		expect -c "spawn ls"
		mkdir ../binutils-build
		cd ../binutils-build
		../binutils-2.14/configure \
			--prefix=/usr --enable-shared
		make tooldir=/usr
		#make check
		make tooldir=/usr install
		cp ../binutils-2.14/include/libiberty.h /usr/include

		cd ..
		rm -rf binutils-{2.14,build}
		;;
esac
