#!/bin/bash
# lfs_prepare.sh
source program/lfs-install.config


function DoPartition ()
{
	clear
	echo		"Partition disk"
	echo		"--------------------------------------------------------------------------------"
	echo		""
	echo		""
	echo -n		"Enter disk name: "
	read		lfs_disk

	fdisk		$lfs_disk
}

function DoFormat ()
{
	clear
	echo		"Format partition"
	echo		"--------------------------------------------------------------------------------"
	echo		""
	echo		""
	echo -n		"Enter partition name: "
	read		lfs_partition
	echo -n		"Enter partition mountpoint: "
	read		lfs_mountpoint

	if		[ ! -d $lfs_root$lfs_mountpoint ]; then
				mkdir -p $lfs_root$lfs_mountpoint
	fi

	echo		""
	mke2fs		$lfs_partition
	mount		$lfs_partition $lfs_root$lfs_mountpoint

	echo		""
	echo -n		"Use multiple partitions: "
	read		lfs_multiple

	if		[ "$lfs_multiple" = "y" ]; then
				DoFormat
	fi
}

function DoDownload ()
{
	clear
	echo		"Download packages"
	echo		"--------------------------------------------------------------------------------"
	echo		""
	echo		"[1] Ottawa, Canada        (100 Mbps)"
	echo		""
	echo		"[2] Oslo, Norway          (100 Mbit)   [3] Lancaster, UK      (100 Mbit)"
	echo		"[4] Vienna, Austria       (64 Mbit)    [5] Karlskrona, Sweden (10 Mbit)"
	echo		"[6] Saint-Denis, France   (10 Mbit)    [7] Sofia, Bulgaria    (5 Mbit/32 Kbit)"
	echo		"[8] Freising, Germany     (4 Mbit)     [9] Toulouse, France   (?? Mbit)"
	echo		""
	echo		"[10] Brisbane, Australia  (155 Mbit)"
	echo		""
	echo		"[11] Singapore, Singapore (45 Mbit)"
	echo		""
	echo		"[0] Custom server"
	echo		""
	echo		""
	echo -n		"Enter server number: "
	read		number

	if		[ "$number" = "1" ]; then
				server="ftp://ftp.linuxfromscratch.org"
	elif		[ "$number" = "2" ]; then
				server="ftp://ftp.no.linuxfromscratch.org/mirrors/lfs"
	elif		[ "$number" = "3" ]; then
				server="ftp://ftp.mirror.ac.uk/sites/ftp.linuxfromscratch.org/pub/lfs"
	elif		[ "$number" = "4" ]; then
				server="ftp://ftp.at.linuxfromscratch.org/pub/lfs"
	elif		[ "$number" = "5" ]; then
				server="ftp://ftp.se.linuxfromscratch.org/lfs"
	elif		[ "$number" = "6" ]; then
				server="ftp://ftp.doc.cs.univ-paris8.fr/mirrors/ftp.linuxfromscratch.org"
	elif		[ "$number" = "7" ]; then
				server="ftp://ftp.bg.linuxfromscratch.org/mirrors/lfs"
	elif		[ "$number" = "8" ]; then
				server="ftp://ftp.de.linuxfromscratch.org"
	elif		[ "$number" = "9" ]; then
				server="ftp://mirror.cict.fr/lfs"
	elif		[ "$number" = "10" ]; then
				server="ftp://ftp.planetmirror.com/pub/lfs"
	elif		[ "$number" = "11" ]; then
				server="ftp://ftp.sg.linuxfromscratch.org/pub/lfs"
	elif		[ "$number" = "0" ]; then
				echo -n "Enter server address: "
				read server
	else
			DoDownload
	fi

	mkdir -p 	$lfsinstall_cache/{linuxfromscratch,syslinux,other}/

	cd		$lfsinstall_cache/linuxfromscratch/
	wget		$server/lfs-books/$lfs_release/LFS-BOOK-$lfs_release-HTML.tar.bz2
	wget		$server/lfs-books/$lfs_release/LFS-BOOK-$lfs_release-NOCHUNKS.html.bz2
	wget		$server/lfs-books/$lfs_release/LFS-BOOK-$lfs_release-XML.tar.bz2
	wget		$server/lfs-books/$lfs_release/LFS-BOOK-$lfs_release.pdf.bz2
	wget		$server/lfs-books/$lfs_release/LFS-BOOK-$lfs_release.ps.bz2
	wget		$server/lfs-books/$lfs_release/LFS-BOOK-$lfs_release.txt.bz2
	#wget		$server/lfs-commands/lfs-commands-$lfs_release.tar.bz2
	wget		$server/lfs-packages/$lfs_release/lfs-packages-$lfs_release.tar
	cd		-

	cd		$lfsinstall_cache/other/
	wget		http://savannah.nongnu.org/download/lfs-install/linuxfromscratch/lfs-commands-$lfs_release-non-official.tar.bz2
	cd		-
	cd		$lfsinstall_cache/syslinux/
	wget		ftp.kernel.org/pub/linux/utils/boot/syslinux/syslinux-1.76.tar.bz2
	cd		-
}

function DoCheck ()
{
	clear

	cp		program/lfs-$lfs_release.md5sum $lfsinstall_cache/linuxfromscratch
	cd		$lfsinstall_cache/linuxfromscratch/
	md5sum -v -c	lfs-$lfs_release.md5sum
	rm -f		lfs-$lfs_release.md5sum
	cd		-
}

function DoUnpack ()
{
	clear

	mkdir -p	$lfsinstall_swap/linuxfromscratch/{lfs-books,lfs-commands,lfs-packages}/

	cd		$lfsinstall_cache/linuxfromscratch/
        tar xfjv        LFS-BOOK-$lfs_release-HTML.tar.bz2
        bzip2 -dkv      LFS-BOOK-$lfs_release{-NOCHUNKS.html,.pdf,.ps,.txt}.bz2
        tar xfjv        LFS-BOOK-$lfs_release-XML.tar.bz2
	cd		-
	mv		$lfsinstall_cache/linuxfromscratch/LFS-BOOK-$lfs_release{-HTML,-NOCHUNKS.html,-XML,.pdf,.ps,.txt} $lfsinstall_swap/linuxfromscratch/lfs-books/

	cp		program/lfs-commands-$lfs_release.patch $lfsinstall_cache/other/
	cd		$lfsinstall_cache/other/
	tar xfjv	lfs-commands-$lfs_release-non-official.tar.bz2
	cd		-
	cd		$lfsinstall_cache/other/lfs-commands-$lfs_release-non-official/
	patch -p1 <	../lfs-commands-$lfs_release.patch
	rm -f		../lfs-commands-$lfs_release.patch README legalnotice
	chmod 755 -R	*
	cd		-
	mv		$lfsinstall_cache/other/lfs-commands-$lfs_release-non-official/* $lfsinstall_swap/linuxfromscratch/lfs-commands/
	rm -rf		$lfsinstall_cache/other/lfs-commands-$lfs_release-non-official/

	cd		$lfsinstall_cache/linuxfromscratch/
	tar xfv		lfs-packages-$lfs_release.tar
	rm -f		lfs-packages-$lfs_release/00MD5SUMS
	cd		-

	mv		$lfsinstall_cache/linuxfromscratch/lfs-packages-$lfs_release/* $lfsinstall_swap/linuxfromscratch/lfs-packages/
	rm -rf		$lfsinstall_cache/linuxfromscratch/lfs-packages-$lfs_release/
}

function main ()
{
	DoPartition
	DoFormat

	if	[ ! -d $lfsinstall_cache/ ]; then
			DoDownload
			DoCheck
	fi

	if	[ ! -d $lfsinstall_swap/ ]; then
			DoUnpack
	fi
}

main
