#!/bin/bash
# compile_lfs-dynamic.sh
source scripts/scripts_settings


function ChrootCommand ()
{
	chroot $DIRECTORY_LFS /static/bin/env -i HOME=/root TERM=$TERM PS1='\u:\w\$ ' PATH=/bin:/usr/bin:/sbin:/usr/sbin:/static/bin /static/bin/bash --login /static/tmp/lfs-commands/$1
}

function PackageInstall ()
{
	cp ../lfs-packages/$1* $DIRECTORY_LFS/usr/src/

	cd $DIRECTORY_LFS/usr/src/

	for filename in *.bz2; do
		bzip2 -dv $filename
	done

	for filename in *.tar; do
		tar xfv $filename
		rm $filename
	done

	cd -

	ChrootCommand $2

	rm -rf $DIRECTORY_LFS/usr/src/$1*
}

function PackageCompile ()
{
	PackageInstall MAKEDEV		chapter6/Makedev-1.7
	PackageInstall linux		chapter6/Linux-2.4.19
	PackageInstall man-pages	chapter6/Man-pages-1.52
	PackageInstall glibc		chapter6/Glibc-2.2.5
	PackageInstall gcc		chapter6/GCC-3.2
	PackageInstall zlib		chapter6/Zlib-1.1.4
	PackageInstall findutils	chapter6/Findutils-4.1
	PackageInstall gawk		chapter6/Gawk-3.1.1
	PackageInstall ncurses		chapter6/Ncurses-5.2
	PackageInstall vim		chapter6/Vim-6.1
	PackageInstall bison		chapter6/Bison-1.35
	PackageInstall less		chapter6/Less-374
	PackageInstall groff		chapter6/Groff-1.18
	PackageInstall textutils	chapter6/Textutils-2.1
	PackageInstall sed		chapter6/Sed-3.02
	PackageInstall flex		chapter6/Flex-2.5.4a
	PackageInstall binutils		chapter6/Binutils-2.13
	PackageInstall fileutils	chapter6/Fileutils-4.1
	PackageInstall sh-utils		chapter6/Sh-utils-2.0
	PackageInstall gettext		chapter6/Gettext-0.11.5
	PackageInstall net-tools	chapter6/Net-tools-1.60
	PackageInstall perl		chapter6/Perl-5.8.0
	PackageInstall *linuxthreads	chapter6/Linuxthreads-2.2.5
	PackageInstall m4		chapter6/M4-1.4
	PackageInstall texinfo		chapter6/Texinfo-4.2
	PackageInstall autoconf		chapter6/Autoconf-2.53
	PackageInstall automake		chapter6/Automake-1.6.3
	PackageInstall bash		chapter6/Bash-2.05a
	PackageInstall file		chapter6/File-3.39
	PackageInstall libtool		chapter6/Libtool-1.4.2
	PackageInstall bin86		chapter6/Bin86-0.16.3
	PackageInstall bzip2		chapter6/Bzip2-1.0.2
	PackageInstall ed		chapter6/Ed-0.2
	PackageInstall kbd		chapter6/Kbd-1.06
	PackageInstall diffutils	chapter6/Diffutils-2.8.1
	PackageInstall e2fsprogs	chapter6/E2fsprogs-1.27
	PackageInstall grep		chapter6/Grep-2.5
	PackageInstall gzip		chapter6/Gzip-1.2.4a
	PackageInstall man		chapter6/Man-1.5k
	PackageInstall lilo		chapter6/Lilo-22.2
	PackageInstall make		chapter6/Make-3.79.1
	PackageInstall modutils		chapter6/Modutils-2.4.19
	PackageInstall netkit-base	chapter6/Netkit-base-0.17
	PackageInstall patch		chapter6/Patch-2.5.4
	PackageInstall procinfo		chapter6/Procinfo-18
	PackageInstall procps		chapter6/Procps-2.0.7
	PackageInstall psmisc		chapter6/Psmisc-21
	PackageInstall shadow		chapter6/Shadow-4.0.3
	PackageInstall sysklogd		chapter6/Sysklogd-1.4.1
	PackageInstall sysvinit		chapter6/Sysvinit-2.84
	PackageInstall tar		chapter6/Tar-1.13
	PackageInstall util-linux	chapter6/Util-linux-2.11u
	PackageInstall lfs-bootscripts	chapter6/LFS-Bootscripts-1.10
	PackageInstall linux		chapter8/linux-2.4.19
}

function main ()
{
	mkdir -p $DIRECTORY_LFS/static/tmp/
	cp -R ../lfs-commands/ $DIRECTORY_LFS/static/tmp/
	cp scripts/kernel_config $DIRECTORY_LFS/static/tmp/

	ChrootCommand chapter6/changing_ownership_lfs
	ChrootCommand chapter6/creating_directories
	ChrootCommand chapter6/mounting_lfs_proc
	ChrootCommand chapter6/creating_etc_mtab
	ChrootCommand chapter6/creating_bash_symlink
	ChrootCommand chapter6/creating_passwd_group
	
	PackageCompile

	ChrootCommand chapter6/configuring_vim
	ChrootCommand chapter6/configuring_glibc
	ChrootCommand chapter6/configuring_dynamic_loader
	ChrootCommand chapter6/configuring_sysklogd
	ChrootCommand chapter6/configuring_shadow_password
	ChrootCommand chapter6/configuring_sysvinit
	ChrootCommand chapter6/creating_var_run
	ChrootCommand chapter6/creating_root_password
	ChrootCommand chapter7/configuring_setclock_script
	ChrootCommand chapter7/configuring_localnet_script
	ChrootCommand chapter7/creating_etc_hosts
	ChrootCommand chapter7/creating_network_interface
	ChrootCommand chapter8/creating_etc_fstab
	ChrootCommand chapter9/the_end

	mkdir $DIRECTORY_LFS/usr/share/doc/lfs-books-4.0/
	cp -R ../lfs-books/* $DIRECTORY_LFS/usr/share/doc/lfs-books-4.0/
	umount $DIRECTORY_LFS/proc

	echo "Configure these things manually:"
	echo " . $LFS/etc/fstab"
	echo " . Lilo (MBR)"
	echo " ! and set a password for root !"
	echo ""
	echo "Happy hacking..."
}

main
