#!/bin/bash
# prepare_lfs-install.sh
source scripts/scripts_settings


function PackageServer ()
{
	clear
	echo "Download packages"
	echo "--------------------------------------------------------------------------------"
	echo ""
	echo "Instead of downloading the required packages to build your LFS system from the"
	echo "official distribution sites, you can download all of them conviniently from one"
	echo "of the mirror sites."
	echo "Please pick a mirror site that's geographically closest to your location."
	echo ""
	echo "North America"
	echo " 1  Fremont, California, USA [8 Mbit]"
	echo " 2  Lufkin, Texas, USA [6 Mbit]"
	echo "Europe"
	echo " 3  Univ. of Twente, The Netherlands [100 Mbit]"
	echo " 4  Oslo, Norway [100 Mbit]"
	echo " 5  Vienna Univ. of Tech., Austria [64 Mbit]"
	echo " 6  Karlskrona, Sweden [10 Mbit]"
	echo " 7  Freising, Germany [4 Mbit]"
	echo "Australia"
	echo " 8  Brisbane, Australia [155 Mbit]"
	echo "Asia"
	echo " 9  Singapore, Singapore [45 Mbit]"
	echo "Other"
	echo " 0  Custom server"
	echo -n "Enter mirror number: "

	read user_input

	if [ "$user_input" = "1" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://ftp.linuxfromscratch.org"
	elif [ "$user_input" = "2" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://linuxfromscratch.idge.net/linuxfromscratch"
	elif [ "$user_input" = "3" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://ftp.snt.utwente.nl/pub/os/linux/lfs"
	elif [ "$user_input" = "4" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://ftp.no.linuxfromscratch.org/mirrors/lfs"
	elif [ "$user_input" = "5" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://ftp.at.linuxfromscratch.org/pub/lfs"
	elif [ "$user_input" = "6" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://ftp.se.linuxfromscratch.org/lfs"
	elif [ "$user_input" = "7" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://ftp.de.linuxfromscratch.org/mirrors/ftp.linuxfromscratch.org"
	elif [ "$user_input" = "8" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://ftp.planetmirror.com/pub/lfs"
	elif [ "$user_input" = "9" ]; then
		SERVER_LINUXFROMSCRATCH="ftp://ftp.sg.linuxfromscratch.org/pub/lfs"
	elif [ "$user_input" = "0" ]; then
		echo -n "Enter server address: "
		read SERVER_LINUXFROMSCRATCH
	else
		PackageServer
	fi
}

function PackageGet ()
{
	clear
	cd $DIRECTORY_DOWNLOAD/

	wget $SERVER_LINUXFROMSCRATCH/lfs-books/4.0/LFS-BOOK-4.0-HTML.tar.bz2
	wget $SERVER_LINUXFROMSCRATCH/lfs-books/4.0/LFS-BOOK-4.0-NOCHUNKS.html.bz2
	wget $SERVER_LINUXFROMSCRATCH/lfs-books/4.0/LFS-BOOK-4.0.pdf.bz2
	wget $SERVER_LINUXFROMSCRATCH/lfs-books/4.0/LFS-BOOK-4.0.ps.bz2
	wget $SERVER_LINUXFROMSCRATCH/lfs-books/4.0/LFS-BOOK-4.0.txt.bz2
	wget $SERVER_LINUXFROMSCRATCH/lfs-books/4.0/LFS-BOOK-4.0-XML.tar.bz2
	# ##########
	# wget ftp://10.0.0.1/lfs-commands-4.0-non-official-2.tar.bz2
	wget http://savannah.gnu.org/download/lfs-install/linuxfromscratch/lfs-commands-4.0-non-official-2.tar.bz2
	# ##########
	wget $SERVER_LINUXFROMSCRATCH/lfs-packages/4.0/lfs-packages-4.0.tar

	cd -
}

function PackageCheck ()
{
	clear
	cd $DIRECTORY_DOWNLOAD/

	cat > MD5SUM << "EOF"
608005ec159b8958ee591e3002faed88  LFS-BOOK-4.0-HTML.tar.bz2
1e2383942784c5ec4356c9819aa32a1b  LFS-BOOK-4.0-NOCHUNKS.html.bz2
d79aae770b72c258a3f1ea6aae1e25de  LFS-BOOK-4.0.pdf.bz2
262d444520d33fc78a4342bc26a05027  LFS-BOOK-4.0.ps.bz2
7eaac2b22e88efb5df971361b8567895  LFS-BOOK-4.0.txt.bz2
4f87c3a60cb0dc0b660b1e49c187b8c5  LFS-BOOK-4.0-XML.tar.bz2
08c583b58daad608b1bb64590be2ef4d  lfs-commands-4.0-non-official-2.tar.bz2
74a556208a7b90de452af549ade5293f  lfs-packages-4.0.tar
EOF
	md5sum -c MD5SUM -v

	cd -
}

function PackageUnpack ()
{
	clear
	cd $DIRECTORY_DOWNLOAD/

	tar xfjv LFS-BOOK-*-HTML.tar.bz2
	bzip2 -dkv LFS-BOOK-*-NOCHUNKS.html.bz2
	bzip2 -dkv LFS-BOOK-*.pdf.bz2
	bzip2 -dkv LFS-BOOK-*.ps.bz2
	bzip2 -dkv LFS-BOOK-*.txt.bz2
	tar xfjv LFS-BOOK-*-XML.tar.bz2
	tar xfjv lfs-commands-*.tar.bz2
	tar xfv lfs-packages-*.tar

	cd -
}

function PackageCopy ()
{
	clear

	mv $DIRECTORY_DOWNLOAD/LFS-BOOK-*-HTML ../lfs-books/
	mv $DIRECTORY_DOWNLOAD/LFS-BOOK-*-NOCHUNKS.html ../lfs-books/
	mv $DIRECTORY_DOWNLOAD/LFS-BOOK-*.pdf ../lfs-books/
	mv $DIRECTORY_DOWNLOAD/LFS-BOOK-*.ps ../lfs-books/
	mv $DIRECTORY_DOWNLOAD/LFS-BOOK-*.txt ../lfs-books/
	mv $DIRECTORY_DOWNLOAD/LFS-BOOK-*-XML ../lfs-books/
	mv $DIRECTORY_DOWNLOAD/lfs-commands*/ ../lfs-commands/
	mv $DIRECTORY_DOWNLOAD/lfs-packages*/ ../lfs-packages/
}

function PackagePatch ()
{
	clear
	cd ../lfs-commands/

	patch -p1 < ../lfs-install/scripts/commands_patch

	for filename in chapter{5,6,7,8,9}/*; do
		chmod 755 $filename
	done

	cd -
}

function main ()
{
	if [ ! -d $DIRECTORY_DOWNLOAD/ ]; then
		mkdir $DIRECTORY_DOWNLOAD/

		PackageServer
		PackageGet
		PackageCheck
	fi

	if [ ! -d ../lfs-books ]; then
		mkdir ../lfs-books/

		PackageUnpack
		PackageCopy
		PackagePatch
	fi
}

main
