#!/bin/bash
# prepare_compilation.sh
source scripts/scripts_settings


function HarddiskPartition ()
{
	clear
	echo "Partition disk"
	echo "--------------------------------------------------------------------------------"
	echo ""
	echo "Before we can build our new Linux system, we need at least one empty Linux"
	echo "partition where we can build it. I recommend a partition size of at least 500 MB"
	echo "(1 GB if you tend to store the sources)."
	echo "Since your system memory can only hold a limited amount of data at one time, we"
	echo "recommend that disk space be set aside for swap files. You should create a swap"
	echo "partition."
	echo ""
	echo -n "Enter disk name: "

	read user_input

	fdisk $user_input
}

function HarddiskFormat ()
{
	clear
	echo "Format partition"
	echo "--------------------------------------------------------------------------------"
	echo ""

	echo "If you decided to create multiple partitions for LFS begin with the root"
	echo "partition."
	echo ""
	echo -n "Enter partition name: "
	read PARTITION_NAME

	echo -n "Enter mount point: "
	read PARTITION_MOUNTPOINT

	mkdir -p $DIRECTORY_LFS$PARTITION_MOUNTPOINT

	mke2fs $PARTITION_NAME
	mount -t ext2 $PARTITION_NAME $DIRECTORY_LFS$PARTITION_MOUNTPOINT

	echo -n "Proceed another partition (y/n): "
	read user_input

	if [ "$user_input" = "y" ]; then
		HarddiskFormat
	fi
}

function main ()
{
	HarddiskPartition

	if [ ! -d $DIRECTORY_LFS ]; then
		mkdir -p $DIRECTORY_LFS
	fi

	HarddiskFormat
}

main
