/*
	lfs-install creates a LFS-system
	Copyright (C) 2002 Daniel Baumann <danielbaumann@linuxmail.org>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include<stdio.h>
#include<stdlib.h>

void print_usage(void);
void print_help(void);
void print_copyright(void);
void print_version(void);

void get_lfs(void);

void get_disk(void);
void get_package(void);
void get_file(void);
void get_program(void);

int main(int argc, char *argv[])
{
	if (argc!=2)
	{
		print_usage();
		exit(EXIT_FAILURE);
	}

	if ((strcmp(argv[1],"-h")==0)||(strcmp(argv[1],"--help")==0))
	{
		print_help();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--version")==0)
	{
		print_version();
		exit(EXIT_SUCCESS);
	}

	if (strcmp(argv[1],"--create-lfs")==0)
	{
		get_lfs();
		exit(EXIT_SUCCESS);
	}

	print_usage();
	exit(EXIT_FAILURE);
}

void print_usage(void)
{
	fprintf(stderr, "Usage: lfs-install [ARGUMENT]\n");
	fprintf(stderr, "Type `lfs-install --help' for details\n");
}

void print_help(void)
{
	fprintf(stdout, "lfs-install creates a LFS-system\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Usage: lfs-install [ARGUMENT]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Arguments:\n");
	fprintf(stdout, "  --create-lfs                         Create a LFS-system\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "  --copyright                          Print the copyright information\n");
	fprintf(stdout, "  -h, --help                           Print this help\n");
	fprintf(stdout, "  --version                            Print version information\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Please report bugs to Daniel Baumann <danielbaumann@linuxmail.org> and\n");
	fprintf(stdout, "check `http://savannah.gnu.org/projects/lfs-install/' for updates.\n");
}

void print_copyright(void)
{
	fprintf(stdout, "lfs-install, Copyright (C) 2002 Daniel Baumann\n");
	fprintf(stdout, "lfs-install comes with ABSOLUTELY NO WARRANTY; for details see `COPYING'.\n");
	fprintf(stdout, "This is free software, and you are welcome to redistribute it\n");
	fprintf(stdout, "under certain conditions; see `COPYING' for details.\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "lfs-install depends on LFS:\n");
	fprintf(stdout, "Linux From Scratch version 3.3, Copyright (C) 1999-2002 Gerard Beekmans\n");
	fprintf(stdout, "see `http://www.linuxfromscratch.org/' for more information.\n");
}

void print_version(void)
{
	fprintf(stdout, "lfs-install version 0.0.1-20020617\n");
}

void get_lfs(void)
{
	get_disk();
	get_package();
	get_file();
	get_program();
}

void get_disk(void)
{
	char disk_name[100];
	char partition_name[100];
	char set_disk[100];
	char set_partition[100];
	char set_filesystem[100];

	fprintf(stdout, "Enter disk name (e.g. /dev/hda): ");
	fscanf(stdin, "%s", &disk_name);
	sprintf(set_disk, "fdisk %s", disk_name);
	system(set_disk);

	fprintf(stdout, "Enter partition name (e.g. /dev/hda1): ");
	fscanf(stdin, "%s", &partition_name);
	sprintf(set_partition, "mke2fs -L LFS %s", partition_name);
	system(set_partition);

	sprintf(set_filesystem, "if [ ! -d /mnt/lfs ]; then mkdir /mnt/lfs; fi && mount %s /mnt/lfs -t ext2 && if [ ! -d /mnt/lfs/proc ]; then mkdir /mnt/lfs/proc; fi && mount proc /mnt/lfs/proc -t proc", partition_name);
	system(set_filesystem);
}

void get_package(void)
{
	char mirror_number[100];
	char mirror_name[100];
	char set_package[1000];

	fprintf(stdout, "Instead of downloading the required packages to build your\n");
	fprintf(stdout, "LFS system from the official distribution sites, you can\n");
	fprintf(stdout, "download all of them conviniently from one of our FTP sites.\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Please pick a mirror site that's geographically closest to\n");
	fprintf(stdout, "your location.\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "North America\n");
	fprintf(stdout, "  1. Fremont, California, USA [8 Mbit]\n");
	fprintf(stdout, "  2. Lufkin, Texas, USA [6 Mbit]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Europe\n");
	fprintf(stdout, "  3. Univ. of Twente, The Netherlands [100 Mbit]\n");
	fprintf(stdout, "  4. Oslo, Norway [100 Mbit]\n");
	fprintf(stdout, "  5. Vienna Univ. of Tech., Austria [64 Mbit]\n");
	fprintf(stdout, "  6. Karlskrona, Sweden [10 Mbit]\n");
	fprintf(stdout, "  7. Freising, Germany [4 Mbit]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Australia\n");
	fprintf(stdout, "  8. Brisbane, Australia [155 Mbit]\n");
	fprintf(stdout, "\n");
	fprintf(stdout, "Other\n");
	fprintf(stdout, "  0. Custom server\n");
	fprintf(stdout, "\n");

	fprintf(stdout, "Enter mirror number (e.g. 1): ");
	fscanf(stdin, "%s", &mirror_number);

	if (strcmp(mirror_number,"1")==0)
	{
		sprintf(mirror_name, "ftp://ftp.linuxfromscratch.org/");
	}

	if (strcmp(mirror_number,"2")==0)
	{
		sprintf(mirror_name, "ftp://linuxfromscratch.idge.net/linuxfromscratch/");
	}
	
	if (strcmp(mirror_number,"3")==0)
	{
		sprintf(mirror_name, "ftp://ftp.snt.utwente.nl/pub/linux/lfs/");
	}
	
	if (strcmp(mirror_number,"4")==0)
	{
		sprintf(mirror_name, "ftp://ftp.no.linuxfromscratch.org/mirrors/lfs/");
	}
	
	if (strcmp(mirror_number,"5")==0)
	{
		sprintf(mirror_name, "ftp://ftp.at.linuxfromscratch.org/pub/lfs/");
	}
	
	if (strcmp(mirror_number,"6")==0)
	{
		sprintf(mirror_name, "ftp://ftp.se.linuxfromscratch.org/lfs/");
	}
	
	if (strcmp(mirror_number,"7")==0)
	{
		sprintf(mirror_name, "ftp://ftp.de.linuxfromscratch.org/mirrors/ftp.linuxfromscratch.org/");
	}
	
	if (strcmp(mirror_number,"8")==0)
	{
		sprintf(mirror_name, "ftp://ftp.planetmirror.com/pub/lfs/");
	}

	if (strcmp(mirror_number,"0")==0)
	{
		fprintf(stdout, "Enter custom server (e.g. ftp://localhost/mirror/lfs/): ");
		fscanf(stdin, "%s", &mirror_name);
	}

	sprintf(set_package, "if [ ! -d linuxfromscratch ]; then mkdir linuxfromscratch; fi && cd linuxfromscratch && if [ ! -e lfs-package-3.3.tar ]; then wget -c %slfs-packages/3.3/lfs-packages-3.3.tar; fi", mirror_name);
	system(set_package);
}

void get_file(void)
{
	char set_directory[100];
	char set_package[100];

	sprintf(set_directory, "cd commands && ./create_directories");
	system(set_directory);

	sprintf(set_package, "cd commands && ./copy_packages");
	system(set_package);
}

void get_program(void)
{
	char preset_bash[100];
	char preset_binutils[100];
	char preset_bzip2[100];
	char preset_diffutils[100];
	char preset_fileutils[100];
	char preset_gawk[100];
	char preset_gcc[100];
	char preset_grep[100];
	char preset_gzip[100];
	char preset_linux[100];
	char preset_make[100];
	char preset_patch[100];
	char preset_sed[100];
	char preset_shutils[100];
	char preset_tar[100];
	char preset_texinfo[100];
	char preset_textutils[100];
	char set_files[100];
	
	sprintf(preset_bash, "cd commands && ./precompile_bash");
	system(preset_bash);
	
	sprintf(preset_binutils, "cd commands && ./precompile_binutils");
	system(preset_binutils);
	
	sprintf(preset_bzip2, "cd commands && ./precompile_bzip2");
	system(preset_bzip2);
	
	sprintf(preset_diffutils, "cd commands && ./precompile_diffutils");
	system(preset_diffutils);
	
	sprintf(preset_fileutils, "cd commands && ./precompile_fileutils");
	system(preset_fileutils);
	
	sprintf(preset_gawk, "cd commands && ./precompile_gawk");
	system(preset_gawk);
	
	sprintf(preset_gcc, "cd commands && ./precompile_gcc");
	system(preset_gcc);

	sprintf(preset_grep, "cd commands && ./precompile_grep");
	system(preset_grep);

	sprintf(preset_gzip, "cd commands && ./precompile_gzip");
	system(preset_gzip);

	sprintf(preset_linux, "cd commands && ./precompile_linux");
	system(preset_linux);

	sprintf(preset_make, "cd commands && ./precompile_make");
	system(preset_make);

	sprintf(preset_patch, "cd commands && ./precompile_patch");
	system(preset_patch);

	sprintf(preset_sed, "cd commands && ./precompile_sed");
	system(preset_sed);

	sprintf(preset_shutils, "cd commands && ./precompile_shutils");
	system(preset_shutils);

	sprintf(preset_tar, "cd commands && ./precompile_tar");
	system(preset_tar);

	sprintf(preset_texinfo, "cd commands && ./precompile_texinfo");
	system(preset_texinfo);

	sprintf(preset_textutils, "cd commands && ./precompile_textutils");
	system(preset_textutils);

	sprintf(set_files, "cd commands && ./create_files");
	system(set_files);
}

