!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE WRTDUMP(ITER)

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PBCARRAY
  USE MDARRAY

  IMPLICIT NONE

  INTEGER :: I
  INTEGER :: ITER
  CHARACTER(LEN=50) :: FLNM

  IF (MDON .EQ. 0) THEN
     WRITE(FLNM,'("animate/snapshot.cfg")')
  ELSEIF (MDON .EQ. 1) THEN
     IF (ITER .LT. 10) THEN
        WRITE(FLNM,'("animate/dump.all.",I1)') ITER
     ELSEIF (ITER .GE. 10 .AND. ITER .LT. 100) THEN
        WRITE(FLNM,'("animate/dump.all.",I2)') ITER
     ELSEIF (ITER .GE. 100 .AND. ITER .LT. 1000) THEN
        WRITE(FLNM,'("animate/dump.all.",I3)') ITER
     ELSEIF (ITER .GE. 1000 .AND. ITER .LT. 10000) THEN
        WRITE(FLNM,'("animate/dump.all.",I4)') ITER
     ELSEIF (ITER .GE. 10000 .AND. ITER .LT. 100000) THEN
        WRITE(FLNM,'("animate/dump.all.",I5)') ITER
     ELSEIF (ITER .GE. 100000 .AND. ITER .LT. 1000000) THEN
        WRITE(FLNM,'("animate/dump.all.",I6)') ITER
     ELSEIF (ITER .GE. 1000000 .AND. ITER .LT. 10000000) THEN
        WRITE(FLNM,'("animate/dump.all.",I7)') ITER
     ELSEIF (ITER .GE. 10000000 .AND. ITER .LT. 100000000) THEN
        WRITE(FLNM,'("animate/dump.all.",I8)') ITER
     ENDIF
  ENDIF

  OPEN(UNIT = 20, STATUS="UNKNOWN", FILE=FLNM)

  WRITE(20,10) "Nats= ", NATS
  WRITE(20,11) ALAT
  WRITE(20,12) BOX(1,1)/ALAT, BOX(2,1)/ALAT, BOX(1,2)/ALAT, &
       BOX(2,2)/ALAT, BOX(1,3)/ALAT, BOX(2,3)/ALAT

  DO I = 1, NATS
     WRITE(20,13) CR(1,I), CR(2,I), CR(3,I), ATELE(I)
!     WRITE(20,13) CR(1,I), CR(2,I), CR(3,I), ATELE(I), & 
!          PBCUNWRAP(1,I), PBCUNWRAP(2,I), PBCUNWRAP(3,I)
  ENDDO

  DO I = 1, NATS
     WRITE(20,14) V(1,I), V(2,I), V(3,I)
  ENDDO

  DO I = 1, NATS
     WRITE(20,14) FTOT(1,I), FTOT(2,I), FTOT(3,I)
  ENDDO

10 FORMAT(A6,1X,I7)
11 FORMAT(F12.6)
12 FORMAT(6(F18.8,1X))
13 FORMAT(3(F18.8,1X),A2)
!13 FORMAT(3(F18.8,1X),A2,1X,3(I4,1X))
14 FORMAT(3(F18.8,1X))

  CLOSE(20)

  RETURN
  
END SUBROUTINE WRTDUMP
