!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE WRTCFGS(ITER)

  !
  ! This subroutine will write out all quantities during calculated
  ! during a MD run to .cfg files so they can be read into
  ! Ju Li's most awesome (and most free) Atomeye visualization code directly.
  !
  ! http://mt.seas.upenn.edu/Archive/Graphics/A/
  !
  ! I suppose that coordinates, velocity, forces, atomic temperature, 
  ! partials charges, and atomic spin densities would come handy
  !

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PBCARRAY
  USE MDARRAY
  USE SPINARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, L
  INTEGER :: ITER, NOMYELEMENTS, MYINDEX
  REAL(LATTEPREC), ALLOCATABLE :: T(:), MAGF(:), ATSPIN(:)
  REAL(LATTEPREC) :: V2, MYMASS, MASSMYELEMENTS(4)
  REAL(LATTEPREC), PARAMETER :: CONV = 1.66053D6/(3.0D0*1.38062D0)
  CHARACTER(LEN=50) :: FLNM
  CHARACTER(LEN=2) :: MYELEMENTS(4)
 
  ALLOCATE(T(NATS), MAGF(NATS))

  !
  ! Let's first get the temperature and |F| for each atom
  !

  DO I = 1, NATS

     V2 = V(1,I)*V(1,I) + V(2,I)*V(2,I) + V(3,I)*V(3,I)

     DO J = 1, NOELEM
        IF (ATELE(I) .EQ. ELE(J)) THEN
           MYMASS = MASS(J)
        ENDIF
     ENDDO

     T(I) = CONV*MYMASS*V2

     MAGF(I) = SQRT(FTOT(1,I)*FTOT(1,I) + FTOT(2,I)*FTOT(2,I) + & 
          FTOT(3,I)*FTOT(3,I))

  ENDDO
  
  !
  ! Now let's figure out how many elements we've got and the cfg 
  ! formats is most efficient when they're all written out in the same
  ! block
  !

  MYELEMENTS = "XX"
  NOMYELEMENTS = 1
  MYELEMENTS(NOMYELEMENTS) = ATELE(1)
  DO J = 1, NOELEM
     IF (ATELE(1) .EQ. ELE(J)) THEN
        MASSMYELEMENTS(NOMYELEMENTS) = MASS(J)
     ENDIF
  ENDDO


  DO J = 2, NATS
     
     IF (ATELE(J) .NE. MYELEMENTS(1) &
          .AND.  ATELE(J) .NE. MYELEMENTS(2) &
          .AND.  ATELE(J) .NE. MYELEMENTS(3) &
          .AND.  ATELE(J) .NE. MYELEMENTS(4) ) THEN
        
        NOMYELEMENTS = NOMYELEMENTS + 1
        MYELEMENTS(NOMYELEMENTS) = ATELE(J)
        
        DO L  = 1, NOELEM
           IF (ATELE(J) .EQ. ELE(L)) THEN
              MASSMYELEMENTS(NOMYELEMENTS) = MASS(L)
           ENDIF
        ENDDO
        
     ENDIF
          
  ENDDO
  
  IF (ITER .LT. 0) THEN
     WRITE(FLNM,'("animate/dump2atomeye.PANIC.cfg")') 
  ENDIF

  IF (ITER .GE. 0 .AND. ITER .LT. 10) THEN
     WRITE(FLNM,'("animate/dump2atomeye.",I1,".cfg")') ITER
  ELSEIF (ITER .GE. 10 .AND. ITER .LT. 100) THEN
     WRITE(FLNM,'("animate/dump2atomeye.",I2,".cfg")') ITER
  ELSEIF (ITER .GE. 100 .AND. ITER .LT. 1000) THEN
     WRITE(FLNM,'("animate/dump2atomeye.",I3,".cfg")') ITER
  ELSEIF (ITER .GE. 1000 .AND. ITER .LT. 10000) THEN
     WRITE(FLNM,'("animate/dump2atomeye.",I4,".cfg")') ITER
  ELSEIF (ITER .GE. 10000 .AND. ITER .LT. 100000) THEN
     WRITE(FLNM,'("animate/dump2atomeye.",I5,".cfg")') ITER
  ELSEIF (ITER .GE. 100000 .AND. ITER .LT. 1000000) THEN
     WRITE(FLNM,'("animate/dump2atomeye.",I6,".cfg")') ITER
  ELSEIF (ITER .GE. 1000000 .AND. ITER .LT. 10000000) THEN
     WRITE(FLNM,'("animate/dump2atomeye.",I7,".cfg")') ITER
  ELSEIF (ITER .GE. 10000000 .AND. ITER .LT. 100000000) THEN
     WRITE(FLNM,'("animate/dump2atomeye.",I8,".cfg")') ITER
  ENDIF

  OPEN(UNIT = 23, STATUS="UNKNOWN", FILE=FLNM)

  WRITE(23,10) "Number of particles = ", NATS
  WRITE(23,'("A = 1.0 Angstrom")')
  WRITE(23,11) "H0(1,1) = ", BOX(2,1), " A"
  WRITE(23,12) "H0(1,2) = 0.0 A"
  WRITE(23,12) "H0(1,3) = 0.0 A"
  WRITE(23,12) "H0(2,1) = 0.0 A"
  WRITE(23,11) "H0(2,2) = ", BOX(2,2), " A"
  WRITE(23,12) "H0(2,3) = 0.0 A"
  WRITE(23,12) "H0(3,1) = 0.0 A"
  WRITE(23,12) "H0(3,2) = 0.0 A"
  WRITE(23,11) "H0(3,3) = ", BOX(2,3), " A"

  !
  ! No partial charges, no spins
  ! 
  ! Write: x, y, z, vx, vy, vz, fx, fy, fz, |F|, temperature
  !

  If (ELECTRO .EQ. 0) THEN
     
     WRITE(23,'("entry_count = 11")')
     WRITE(23,13) "auxiliary[0] = fx "
     WRITE(23,13) "auxiliary[1] = fy "
     WRITE(23,13) "auxiliary[2] = fz "
     WRITE(23,13) "auxiliary[3] = |F|"
     WRITE(23,13) "auxiliary[4] = T "
     
     DO I = 1, NOMYELEMENTS

        WRITE(23,14) MASSMYELEMENTS(I)
        WRITE(23,15) MYELEMENTS(I)

        DO J = 1, NATS

           IF (ATELE(J) .EQ. MYELEMENTS(I)) THEN

              WRITE(23,16) CR(1,J)/BOX(2,1), CR(2,J)/BOX(2,2), &
                   CR(3,J)/BOX(2,3), V(1,J), V(2,J), V(3,J), &
                   FTOT(1,J), FTOT(2,J), FTOT(3,J), MAGF(J), T(J)

           ENDIF

        ENDDO
        
     ENDDO

  ELSEIF(ELECTRO .EQ. 1 .AND. SPINON .EQ. 0) THEN
     
     !
     ! Same as above, but now we add partial charges too
     !
     
     WRITE(23,'("entry_count = 12")')
     WRITE(23,13) "auxiliary[0] = fx "
     WRITE(23,13) "auxiliary[1] = fy "
     WRITE(23,13) "auxiliary[2] = fz "
     WRITE(23,13) "auxiliary[3] = |F|"
     WRITE(23,13) "auxiliary[4] = T/K"
     WRITE(23,13) "auxiliary[5] = q  "

     DO I = 1, NOMYELEMENTS

        WRITE(23,14) MASSMYELEMENTS(I)
        WRITE(23,15) MYELEMENTS(I)

        DO J = 1, NATS

           IF (ATELE(J) .EQ. MYELEMENTS(I)) THEN

              WRITE(23,17) CR(1,J)/BOX(2,1), CR(2,J)/BOX(2,2), &
                   CR(3,J)/BOX(2,3), V(1,J), V(2,J), V(3,J), &
                   FTOT(1,J), FTOT(2,J), FTOT(3,J), & 
                   MAGF(J), T(J), DELTAQ(J)

           ENDIF

        ENDDO

     ENDDO

  ELSEIF (ELECTRO .EQ. 1 .AND. SPINON .EQ. 1) THEN

     !
     ! Now we add the net spin per atom too
     !

     ALLOCATE(ATSPIN(NATS))
     
     MYINDEX = 0

     DO I = 1, NATS

        DO J = 1, NOELEM

           IF (ATELE(I) .EQ. ELE(J)) THEN

              IF (BASIS(J) .EQ. "ss") THEN

                 MYINDEX = MYINDEX + 1
                 ATSPIN(I) = DELTASPIN(MYINDEX)

              ELSEIF (BASIS(J) .EQ. "sp") THEN

                 ATSPIN(I) = DELTASPIN(MYINDEX + 1) + DELTASPIN(MYINDEX + 2)

                 MYINDEX = MYINDEX + 2

              ENDIF

           ENDIF

        ENDDO
        
     ENDDO

     WRITE(23,'("entry_count = 13")')
     WRITE(23,13) "auxiliary[0] = fx "
     WRITE(23,13) "auxiliary[1] = fy "
     WRITE(23,13) "auxiliary[2] = fz "
     WRITE(23,13) "auxiliary[3] = |F|"
     WRITE(23,13) "auxiliary[4] = T/K"
     WRITE(23,13) "auxiliary[5] = q  "
     WRITE(23,13) "auxiliary[6] = spn" 

     DO I = 1, NOMYELEMENTS

        WRITE(23,14) MASSMYELEMENTS(I)
        WRITE(23,15) MYELEMENTS(I)

        DO J = 1, NATS

           IF (ATELE(J) .EQ. MYELEMENTS(I)) THEN

              WRITE(23,18) CR(1,J)/BOX(2,1), CR(2,J)/BOX(2,2), &
                   CR(3,J)/BOX(2,3), V(1,J), V(2,J), V(3,J), &
                   FTOT(1,J), FTOT(2,J), FTOT(3,J), &
                   MAGF(J), T(J), DELTAQ(J), ATSPIN(J)

           ENDIF

        ENDDO

     ENDDO

     DEALLOCATE(ATSPIN)

  ENDIF

  DEALLOCATE(T, MAGF)

  CLOSE(23)

10 FORMAT(A22, 1X, I6)
11 FORMAT(A10,1X,F18.9, A2)
12 FORMAT(A15)
13 FORMAT(A18)
14 FORMAT(F4.1)
15 FORMAT(A2)
16 FORMAT(3(F8.6,1X), 6(F12.8,1X), F12.6, 1X, F12.2)
17 FORMAT(3(F8.6,1X), 6(F12.8,1X), F12.6, 1X, F12.2, 1X, F10.4)
18 FORMAT(3(F8.6,1X), 6(F12.8,1X), F12.6, 1X, F12.2, 1X, 2(F10.4, 1X))

  RETURN

END SUBROUTINE WRTCFGS
