!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE STDESCENT(ITER, MAXF)

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE RELAXCOMMON
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, ITER
  REAL(LATTEPREC) :: MAXF, DISP, MYSHIFT
  REAL(LATTEPREC), PARAMETER :: MAXMCONST = 0.1D0, MINMCONST = 1.0D-3
  REAL(LATTEPREC), PARAMETER :: MAXSHIFT = 0.01D0

  IF (ITER .EQ. 1) THEN
     RELCONST = 0.01D0
     PREVF = MAXF
  ENDIF

  IF (MAXF .GT. PREVF) THEN
     RELCONST = HALF*RELCONST
  ELSEIF (MAXF .LT. PREVF) THEN
     RELCONST = 1.1D0*RELCONST
  ENDIF

  RELCONST = MIN(RELCONST, MAXMCONST)
  RELCONST = MAX(RELCONST, MINMCONST)

  PREVF = MAXF

  DO I = 1, NATS

     DO J = 1, 3

        MYSHIFT = RELCONST*FTOT(J,I)
        
        IF (ABS(DISP) .GT. MAXSHIFT) THEN
           MYSHIFT = SIGN(MAXSHIFT, MYSHIFT)
        ENDIF

        CR(J,I) = CR(J,I) + MYSHIFT

     ENDDO

  ENDDO

  RETURN

END SUBROUTINE STDESCENT
