!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE RHOZERO

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE SPINARRAY
  USE RESTARTARRAY
  USE MYPRECISION

  IMPLICIT NONE
 
  INTEGER :: I, K, SUBI, MYINDEX
  REAL(LATTEPREC) :: STOT, PTOT
  REAL(LATTEPREC) :: SUP, SDOWN, PUP, PDOWN

  ESPIN_ZERO = ZERO

  IF (SPINON .EQ. 0) THEN

    ! No spins

     ALLOCATE(BOZERO(HDIM))
     
     BOZERO = ZERO
     
     MYINDEX = 0
     
     DO I = 1, NATS
        DO K = 1, NOELEM
           
           IF (ATELE(I) .EQ. ELE(K)) THEN
              
              IF (BASIS(K) .EQ. "sp") THEN
                 
                 STOT = TWO
                 
                 !
                 ! Total number of electrons, minus the 2x s-electrons, 
                 ! distributed evenly among the three p-orbitals
                 !
                 
                 PTOT = (ATOCC(K) - STOT)/THREE
                 
                 DO SUBI = 1, 4
                    
                    MYINDEX = MYINDEX + 1
                    
                    IF (SUBI .EQ. 1) THEN
                       
                       BOZERO(MYINDEX) = STOT
                       
                    ELSEIF (SUBI .GT. 1) THEN
                       
                       BOZERO(MYINDEX) = PTOT
                       
                    ENDIF
                 ENDDO
                 
              ELSEIF (BASIS(K) .EQ. "ss") THEN
                 
                 MYINDEX = MYINDEX + 1
                 
                 BOZERO(MYINDEX) = ATOCC(K)
                 
              ENDIF
              
           ENDIF
           
        ENDDO
     ENDDO

     !
     ! Initialize the diagonal elements of BO to those for free atoms
     !

     DO I = 1, HDIM
        BO(I,I) = BOZERO(I)
     ENDDO

  ELSEIF (SPINON .EQ. 1) THEN

     ! With spins

     ALLOCATE(RHOUPZERO(HDIM), RHODOWNZERO(HDIM))

     RHOUPZERO = ZERO
     RHODOWNZERO = ZERO

     MYINDEX = 0
     
     DO I = 1, NATS
        DO K = 1, NOELEM
           
           IF (ATELE(I) .EQ. ELE(K)) THEN
              
              IF (BASIS(K) .EQ. "sp") THEN

                 SUP = ONE
                 SDOWN = ONE

                 ! Applying Hund's rules with the population
                 ! of the p-orbital: three up spins followed by 
                 ! pairing with the down spins
                 
                 ! Total number of p-electrons

                 PTOT = ATOCC(K) - (SUP + SDOWN)

                 IF (INT(PTOT) .LE. 3) THEN

                    PUP = PTOT
                    PDOWN = ZERO

                 ELSEIF (INT(PTOT) .GT. 3) THEN

                    PUP = THREE
                    PDOWN = PTOT - THREE
                    
                 ENDIF

                 DO SUBI = 1, 4
                    
                    MYINDEX = MYINDEX + 1
                    
                    IF (SUBI .EQ. 1) THEN
                       
                       RHOUPZERO(MYINDEX) = SUP
                       RHODOWNZERO(MYINDEX) = SDOWN
                       
                    ELSEIF (SUBI .GT. 1) THEN
                       
                       ! Fill the three p-orbitals evenly

                       RHOUPZERO(MYINDEX) = PUP/THREE
                       RHODOWNZERO(MYINDEX) = PDOWN/THREE
                       
                    ENDIF
                 ENDDO
                 
              ELSEIF (BASIS(K) .EQ. "ss") THEN
                 
                 MYINDEX = MYINDEX + 1
                 
                 STOT = ATOCC(K)

                 IF (INT(STOT) .EQ. 1) THEN

                    SUP = ONE
                    SDOWN = ZERO

                 ELSEIF (INT(STOT) .EQ. 2) THEN

                    SUP = ONE
                    SDOWN = ONE

                 ENDIF

                 RHOUPZERO(MYINDEX) = SUP
                 RHODOWNZERO(MYINDEX) = SDOWN

              ENDIF
              
           ENDIF
           
        ENDDO
     ENDDO

     !
     ! Let's initialize our self-consistent spin densities as those for
     ! free atoms
     !            
     
     DO I = 1, HDIM
        
        RHOUP(I,I) = RHOUPZERO(I)
        RHODOWN(I,I) = RHODOWNZERO(I)
        
     ENDDO
        
     CALL GETSPINEZERO

  ENDIF

  RETURN

END SUBROUTINE RHOZERO
