!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE QCONSISTENCY(SWITCH, MDITER)

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE SPARSEIND
  USE SPINARRAY
  USE COULOMBARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, SWITCH, MDITER, ITER, II
  INTEGER :: ALLOKQ, ALLOKM, ALLOK

  !
  ! If FULLQCONV = 1, then we're going to iterate until all charges are within
  ! QTOL.
  !
  ! If FULLQCONV = 0, then we're going to run only a user specified number 
  ! of iterations (= QITER)
  !
  ! If SWITCH = 0, then we don't have any partial charges defined yet so
  ! we'll have to get these from our charge-independent H matrix first
  !

  SCFS_II = 0

  IF (FULLQCONV .EQ. 1 .OR. MDITER .EQ. 1) THEN

     IF (SWITCH .EQ. 0) THEN
        
        IF (CONTROL .EQ. 1) THEN

           CALL DIAGMYH()

           IF (SPINON .EQ. 0) THEN
              CALL BOEVECS()
           ELSEIF (SPINON .EQ. 1) THEN
              CALL SPINRHOEVECS
           ENDIF

        ELSEIF (CONTROL .EQ. 2) THEN

           CALL GERSHGORIN

           IF  (SPARSEON .EQ. 0) THEN

              CALL SP2PURE

           ELSEIF (SPARSEON .EQ. 1) THEN

              CALL INITSPARSESP2
              CALL SPARSESP2PURE

           ENDIF

        ELSEIF (CONTROL .EQ. 3) THEN

           IF (SPARSEON .EQ. 0) THEN

              CALL FERMIEXPANS

           ELSEIF (SPARSEON .EQ. 1) THEN

              CALL ALLOCATEPURE
              CALL GERSHGORIN
              CALL INITSPARSESP2
              CALL DEALLOCATEPURE
              CALL FERMIEXPANSSPARSE

           ENDIF
        
        ELSEIF (CONTROL .EQ. 4) THEN

           CALL GERSHGORIN
           CALL SP2T

        ELSEIF (CONTROL .EQ. 5) THEN

           CALL SP2FERMI

        ENDIF
        
        !
        ! Now we have our bond-order/density matrices,
        ! we can get the charges and spins
        !
        
        CALL GETDELTAQ

!        DO I = 1, NATS
!           PRINT*, I, DELTAQ(I)
!        ENDDO

        IF (SPINON .EQ. 1) THEN

           CALL GETDELTASPIN

        ENDIF
        
     ENDIF
     
     !
     ! Now we're going to run our iterations for self-consistency
     !
     
     ALLOK = 1
     ITER = 0
     
     DO WHILE (ALLOK .GT. 0)
        
        ITER = ITER + 1

        IF (ITER .EQ. MAXSCF) THEN
           WRITE(6,*) "SCF iterations in qconsistency are not converging"
           WRITE(6,'("Either increase MAXSCF or there is something wrong with the initial geometry")')
           WRITE(6,*) "STOP!!"
           CALL PANIC
           STOP
        ENDIF

        SCFS_II = SCFS_II + 1


        IF (ELECMETH .EQ. 0) THEN
           
           !
           ! First do the real space part of the electrostatics
           ! This subroutine is based on Sanville's work
           !

           CALL COULOMBRSPACE
           
           !
           ! And now the long range bit (this is also a modified version
           ! of Ed's code). 
           !
        
           CALL COULOMBEWALD


        ELSEIF (ELECMETH .EQ. 1) THEN

           !
           ! Doing the electrostatics all in real space
           ! help tremendously when getting the virial
           !

           CALL COULOMBOLDSKOOL

        ENDIF
        
        !
        ! Now let's modify the diagonal elements of our H matrix according
        ! to the electrostatic potential experience by each atom
        !
        
        CALL ADDQDEP

        IF (SPINON .EQ. 1) THEN

           ! Got to add the electrostatic potential to
           ! the Slater-Koster H before adding H_2 to form
           ! H_up and H_down

           !
           ! Calculate the spin-dependent H matrix again
           !
           
           CALL BLDSPINH
           
        ENDIF
           
        !
        ! New Hamiltonian: get the bond order 
        !
        
        IF (CONTROL .EQ. 1) THEN

           CALL DIAGMYH()
           IF (SPINON .EQ. 0) THEN
              CALL BOEVECS()
           ELSE
              CALL SPINRHOEVECS
           ENDIF

        ELSEIF (CONTROL .EQ. 2) THEN

           CALL GERSHGORIN

           IF  (SPARSEON .EQ. 0) THEN

              CALL SP2PURE

           ELSEIF (SPARSEON .EQ. 1) THEN

               CALL INITSPARSESP2
               CALL SPARSESP2PURE

           ENDIF

        ELSEIF (CONTROL .EQ. 3) THEN

           IF (SPARSEON .EQ. 0) THEN

              CALL FERMIEXPANS

           ELSEIF (SPARSEON .EQ. 1) THEN

              CALL ALLOCATEPURE
              CALL GERSHGORIN
              CALL INITSPARSESP2
              CALL DEALLOCATEPURE
              CALL FERMIEXPANSSPARSE

           ENDIF
        
        ELSEIF (CONTROL .EQ. 4) THEN

           CALL GERSHGORIN
           CALL SP2T

        ELSEIF (CONTROL .EQ. 5) THEN

           CALL SP2FERMI

        ENDIF
        
        !
        ! Save our old charges/spins so we can mix them later
        !
     
        IF (SPINON .EQ. 1) THEN

           OLDDELTASPIN = DELTASPIN
           CALL GETDELTASPIN

        ENDIF

        OLDDELTAQS = DELTAQ
        
        !
        ! Get a new set of charges for our system
        !
        
        CALL GETDELTAQ

        !
        ! Let's check for convergence
        !
        
        ALLOKQ = 0
        
        DO I = 1, NATS
           
           IF (ABS(DELTAQ(I) - OLDDELTAQS(I)) .GT. ELEC_QTOL) THEN
              ALLOKQ = ALLOKQ + 1
           ENDIF
           
        ENDDO

        ALLOKM = 0

        IF (SPINON .EQ. 1) THEN

           DO I = 1, DELTADIM

              IF (ABS(DELTASPIN(I) - OLDDELTASPIN(I)) .GT. SPINTOL) THEN
                 ALLOKM = ALLOKM + 1
              ENDIF

           ENDDO
           
        ENDIF

        ALLOK = ALLOKQ + ALLOKM

!        PRINT*, ITER, ALLOKQ, ALLOKM, ALLOK
        
        !
        ! If we haven't converged yet, let's mix them and continue the 
        ! DO WHILE loop... Mixing 25:75 seems to be the most efficient
        !
        
        IF (ALLOKQ .GT. 0) THEN
 
           DELTAQ = QMIX*DELTAQ + (ONE - QMIX)*OLDDELTAQS

        ENDIF

        IF (SPINON .EQ. 1 .AND. ALLOKM .GT. 0) THEN
           
           DELTASPIN = SPINMIX*DELTASPIN + (ONE - SPINMIX)*OLDDELTASPIN
           
        ENDIF
           
     ENDDO
     
  ELSEIF (FULLQCONV .EQ. 0 .AND. MDON .EQ. 1 .AND. MDITER .GT. 1) THEN
     
     ! Now we're doing MD 

     DO II = 1, QITER

        IF (ELECMETH .EQ. 0) THEN

           CALL COULOMBRSPACE
        
           CALL COULOMBEWALD

        ELSEIF (ELECMETH .EQ. 1) THEN

           CALL COULOMBOLDSKOOL

        ENDIF

        CALL ADDQDEP

        !
        ! Building the spin up and spin down H's after we've
        ! added the electrostatic potential to the Slater-Koster one,
        ! as it should be.
        !

        IF (SPINON .EQ. 1) THEN
           CALL BLDSPINH
        ENDIF
        
        !
        ! New Hamiltonian: get the bond order 
        !
        
        IF (CONTROL .EQ. 1) THEN

           CALL DIAGMYH

           IF (SPINON .EQ. 0) THEN
              CALL BOEVECS
           ELSE
              CALL SPINRHOEVECS
           ENDIF

        ELSEIF (CONTROL .EQ. 2) THEN

           CALL GERSHGORIN

           IF  (SPARSEON .EQ. 0) THEN

              CALL SP2PURE

           ELSEIF (SPARSEON .EQ. 1) THEN

              CALL INITSPARSESP2
              CALL SPARSESP2PURE

           ENDIF

        ELSEIF (CONTROL .EQ. 3) THEN

           IF (SPARSEON .EQ. 0) THEN

              CALL FERMIEXPANS

           ELSEIF (SPARSEON .EQ. 1) THEN

              CALL ALLOCATEPURE
              CALL GERSHGORIN
              CALL INITSPARSESP2
              CALL DEALLOCATEPURE
              CALL FERMIEXPANSSPARSE

           ENDIF
        
        ELSEIF (CONTROL .EQ. 4) THEN

           CALL GERSHGORIN
           CALL SP2T

        ELSEIF (CONTROL .EQ. 5) THEN
           
           CALL SP2FERMI

        ENDIF

        !
        ! Save our old charges/spins so we can mix them later and check
        ! for convergence
        !

        IF (SPINON .EQ. 1) THEN
           
           OLDDELTASPIN = DELTASPIN
           
           CALL GETDELTASPIN

        ENDIF
        
        OLDDELTAQS = DELTAQ

        !
        ! Get a new set of charges for our system
        !
        
        CALL GETDELTAQ

        !
        ! Mix to get new charges
        !
 
        DELTAQ = QMIX*DELTAQ + (ONE - QMIX)*OLDDELTAQS


        IF (SPINON .EQ. 1) THEN
           
           DELTASPIN = SPINMIX*DELTASPIN + (ONE - SPINMIX)*OLDDELTASPIN

        ENDIF

     ENDDO

     ! Calculate the bond order one more time since we need the forces for
     ! that charge distribution

     IF (ELECMETH .EQ. 0) THEN
     
        CALL COULOMBRSPACE
        
        CALL COULOMBEWALD

     ELSEIF (ELECMETH .EQ. 1) THEN

        CALL COULOMBOLDSKOOL

     ENDIF

     CALL ADDQDEP

     ! This is the right order

     IF (SPINON .EQ. 1) THEN
        CALL BLDSPINH
     ENDIF
     
     !
     ! New Hamiltonian: get the bond order/density matrices 
     !

     IF (CONTROL .EQ. 1) THEN
       
        CALL DIAGMYH()
        IF (SPINON .EQ. 0) THEN
           CALL BOEVECS()
        ELSEIF (SPINON .EQ. 1) THEN
           CALL SPINRHOEVECS
        ENDIF
        
     ELSEIF (CONTROL .EQ. 2) THEN
        
        CALL GERSHGORIN
        
        IF  (SPARSEON .EQ. 0) THEN
           CALL SP2PURE
        ELSEIF (SPARSEON .EQ. 1) THEN

           CALL INITSPARSESP2
           CALL SPARSESP2PURE

        ENDIF
        
     ELSEIF (CONTROL .EQ. 3) THEN
        
        IF (SPARSEON .EQ. 0) THEN
           
           CALL FERMIEXPANS
           
        ELSEIF (SPARSEON .EQ. 1) THEN
           
           CALL ALLOCATEPURE
           CALL GERSHGORIN
           CALL INITSPARSESP2
           CALL DEALLOCATEPURE
           CALL FERMIEXPANSSPARSE
           
        ENDIF
     
     ELSEIF (CONTROL .EQ. 4) THEN

        CALL GERSHGORIN
        CALL SP2T
        
     ELSEIF (CONTROL .EQ. 5) THEN

        CALL SP2FERMI

     ENDIF
     
  ENDIF
  
  RETURN
  
END SUBROUTINE QCONSISTENCY
