!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE INITIALV

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE MDARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, K
  INTEGER :: SEED
  REAL(LATTEPREC) :: RN(3), MAGRN, RNNORM(3)
  REAL(LATTEPREC) :: MYMASS, VELFACTOR
  REAL(LATTEPREC) :: VSUM(3), CONV
  REAL(LATTEPREC), PARAMETER :: KB = 1.38062D-4/1.60219D0

  CONV = 0.1D0*SQRT(1.60219D0/1.66053D0)

  VSUM = ZERO

  DO I = 1, NATS

     CALL RANDOM_NUMBER(RN)

     DO K = 1, 3
        RN(K) = TWO*RN(K) - ONE
     ENDDO

     MAGRN = SQRT(RN(1)*RN(1) + RN(2)*RN(2) + RN(3)*RN(3))

     DO K = 1, 3
        RNNORM(K) = RN(K)/MAGRN
     ENDDO

     DO J = 1, NOELEM
        IF (ATELE(I) .EQ. ELE(J)) THEN
           MYMASS = MASS(J)
        ENDIF
     ENDDO

     VELFACTOR = CONV*SQRT(THREE*KB*TEMP/MYMASS)
     
     DO K = 1, 3

        V(K,I) = RNNORM(K) * VELFACTOR
        VSUM(K) = VSUM(K) + V(K,I)

     ENDDO

  ENDDO

  ! Setting net velocity to zero

  DO I = 1, NATS
     DO K = 1, 3
        V(K,I) = V(K,I) - (VSUM(K)/FLOAT(NATS))
     ENDDO
  ENDDO

  RETURN

END SUBROUTINE INITIALV
     
