!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE GETMDF(SWITCH, CURRITER)

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PPOTARRAY
  USE SPARSEIND
  USE XBOARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: SWITCH, CURRITER

  !
  ! The atoms have moved, so we have to build a new H
  !

  CALL BLDNEWH(SWITCH)

  IF (SPINON .EQ. 1) THEN
     CALL GETDELTASPIN
     CALL BLDSPINH
  ENDIF

  IF (SWITCH .EQ. 0 .AND. RESTART .EQ. 1) THEN
     CALL IFRESTART
  ENDIF

  IF (CONTROL .EQ. 5 .AND. CURRITER .EQ. 1) THEN
     CONTROL = 2
     CALL QCONSISTENCY(0,1)
     CONTROL = 5
     CALL GERSHGORIN
     CALL SP2FERMIINIT
  ENDIF
     
  IF (ELECTRO .EQ. 1) THEN  ! Self-consistent charge transfer on

     !
     ! If we're running with XBO on, we start to propagate things
     ! after the first iteration
     !

     IF (XBOON .GT. 0 .AND. CURRITER .GT. 1 .AND. SWITCH .NE. 0) THEN
        
        IF (XBOON .EQ. 1) THEN ! We will add other types of XBO later
           
           ! Propagating partial charges or diagonal elements of H
           
           CALL XBO(CURRITER) ! Propagate q's
        
           !
           ! If we are also propagating the chemical potential
           !
        
           IF (CONTROL .EQ. 1 .OR. CONTROL .EQ. 3 .OR. CONTROL .EQ. 5) THEN

              CALL PROPCHEMPOT(CURRITER) ! Propagate mu

           ENDIF
        
           IF (SPINON .EQ. 1) THEN

              CALL PROPSPINS(CURRITER) ! Propagate m's

           ENDIF

        ENDIF
        
     ENDIF

     !
     ! If SWITCH = 0, then we don't have a set of partials charges
     ! yet and we'll have to get them from the charge-indenpendent
     ! H-matrix
     !
     ! Whether we're running full self consistency at each MD time step
     ! or only a user-specified number of iterations is determined by the
     ! value of FULLQCONV 
     !
     
     CALL QCONSISTENCY(SWITCH, CURRITER) ! Run to self-consistency

     !
     ! Setting up our XBO arrays after the first iteration
     !

     ! We initialize once we have our first set of self-consistent q's, mu, and m's
     
     IF (XBOON .GT. 0 .AND. CURRITER .EQ. 1) THEN 
        
        IF (XBOON .EQ. 1) THEN ! Other cases to come
           
           CALL XBO(1)
           
           IF (CONTROL .EQ. 1 .OR. CONTROL .EQ. 3 .OR. CONTROL .EQ. 5) THEN
              CALL PROPCHEMPOT(1)
           ENDIF
           
           IF (SPINON .EQ. 1) THEN
              CALL PROPSPINS(1)
           ENDIF
           
        ENDIF
           
     ENDIF
        
  ELSEIF (ELECTRO .EQ. 0) THEN ! Beyond here is only for electron = 0 and we're applying local charge neutrality

     IF (CONTROL .EQ. 1) THEN     

        IF (XBOON .EQ. 1 .AND. CURRITER .GT. 1) THEN
           
           CALL PROPCHEMPOT(CURRITER)
           
        ENDIF

        CALL DIAGMYH

        IF (SPINON .EQ. 0) THEN
           CALL BOEVECS
        ELSEIF (SPINON .EQ. 1) THEN
           CALL SPINRHOEVECS
        ENDIF

        IF (XBOON .EQ. 1 .AND. CURRITER .EQ. 1) THEN
           
           CALL PROPCHEMPOT(CURRITER)
           
        ENDIF

     ELSEIF (CONTROL .EQ. 2) THEN

        CALL GERSHGORIN
        IF (SPARSEON .EQ. 0) THEN
           CALL SP2PURE
        ELSEIF (SPARSEON .EQ. 1) THEN
           CALL INITSPARSESP2
           CALL SPARSESP2PURE
        ENDIF

     ELSEIF (CONTROL .EQ. 3) THEN
        
        ! Propagating guess for CHEMPOT in time reversible way
        
        IF (XBOON .EQ. 1 .AND. CURRITER .GT. 1) THEN
           
           CALL PROPCHEMPOT(CURRITER)
           
        ENDIF
        
        IF (SPARSEON .EQ. 0) THEN
           CALL FERMIEXPANS
        ELSEIF (SPARSEON .EQ. 1) THEN
           CALL ALLOCATEPURE
           CALL GERSHGORIN
           CALL INITSPARSESP2
           CALL DEALLOCATEPURE
           CALL FERMIEXPANSSPARSE
        ENDIF

        ! Initiating the Verlet propagation of time reversible guess
        ! for new CHEMPOT
        
        IF (XBOON .EQ. 1 .AND. CURRITER .EQ. 1) THEN
           
           CALL PROPCHEMPOT(CURRITER)
           
        ENDIF
        
     ELSEIF (CONTROL .EQ. 4) THEN

        CALL GERSHGORIN
        CALL SP2T

     ELSEIF (CONTROL .EQ. 5) THEN

        IF (XBOON .EQ. 1 .AND. CURRITER .GT. 1) THEN
           
           CALL PROPCHEMPOT(CURRITER)
           
        ENDIF
        
        CALL SP2FERMI

        IF (XBOON .EQ. 1 .AND. CURRITER .EQ. 1) THEN
           
           CALL PROPCHEMPOT(CURRITER)
           
        ENDIF
        
     ENDIF
        
     CALL ATOMCHARGE(SWITCH)

  ! Setting up the XBO arrays

     IF (XBOON .EQ. 1) THEN
        
        CALL RESETPRODHD
        
        IF (CURRITER .EQ. 1) THEN

           CALL XBO(1)

        ENDIF
        
     ENDIF
     
  ENDIF
  
  !
  ! Get the forces from the covalent part
  !

  CALL GRADH

  !
  ! ... and the energy and forces from the pair pot
  !

  CALL PPOTHYBRID

  FTOT = TWO*F + FPP
  
  IF (ELECTRO .EQ. 1) THEN
     FTOT = FTOT + FCOUL
  ENDIF

  RETURN
  
END SUBROUTINE GETMDF
