!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE GETDELTAQ

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE SPINARRAY
  USE COULOMBARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, SUBI, MYINDEX
  REAL(LATTEPREC) :: MYCHARGE

  MYINDEX = 0

  IF (SPINON .EQ. 0) THEN

     DO I = 1, HDIM
        QLIST(I) = BO(I,I)
     ENDDO

  ELSE

     DO I = 1, HDIM
        QLIST(I) = RHOUP(I,I) + RHODOWN(I,I)
     ENDDO

  ENDIF

  DO I = 1, NATS
     DO J = 1, NOELEM

        IF (ATELE(I) .EQ. ELE(J)) THEN

           MYCHARGE = ZERO

           IF (BASIS(J) .EQ. "sp") THEN

              DO SUBI = 1, 4
                 
                 MYINDEX = MYINDEX + 1

                 MYCHARGE = MYCHARGE + QLIST(MYINDEX)

              ENDDO

           ELSEIF (BASIS(J) .EQ. "ss") THEN

              MYINDEX = MYINDEX + 1

              MYCHARGE = QLIST(MYINDEX)

           ENDIF

           DELTAQ(I) = MYCHARGE - ATOCC(J)

        ENDIF

     ENDDO
  ENDDO

  RETURN

END SUBROUTINE GETDELTAQ
