!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE GERSHGORIN

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE SPINARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J
  REAL(LATTEPREC) :: CIRCLE(2), UPCIRC(2), DOWNCIRC(2)
  REAL(LATTEPREC) :: RADIUS, DOWNRAD, UPRAD
  REAL(LATTEPREC) :: UPMINEVAL, UPMAXEVAL, DOWNMINEVAL, DOWNMAXEVAL

  IF (SPINON .EQ. 0) THEN

     MINEVAL = 1.0E10
     MAXEVAL = -1.0E10

     DO I = 1, HDIM
        
        RADIUS = ZERO
        
        DO J = 1, HDIM
           
           IF (J .NE. I) THEN
              
              RADIUS = RADIUS + ABS(H(J,I))
              
           ENDIF
           
        ENDDO
        
        CIRCLE(1) = H(I,I) - RADIUS
        CIRCLE(2) = H(I,I) + RADIUS
     
        IF (CIRCLE(1) .LT. MINEVAL) THEN
           MINEVAL = CIRCLE(1)
        ENDIF
        IF (CIRCLE(2) .GT. MAXEVAL) THEN
           MAXEVAL = CIRCLE(2)
        ENDIF
        
     ENDDO

  ELSEIF (SPINON .EQ. 1) THEN
     
     UPMINEVAL = 1.0E10
     UPMAXEVAL = -1.0E10
     DOWNMINEVAL = 1.0E10
     DOWNMAXEVAL = -1.0E10

     DO I = 1, HDIM

        UPRAD = ZERO
        DOWNRAD = ZERO

        DO J = 1, HDIM

           IF (J .NE. I) THEN

              UPRAD = UPRAD + ABS(HUP(J,I))
              DOWNRAD = DOWNRAD + ABS(HDOWN(J,I))
              
           ENDIF
           
        ENDDO

        UPCIRC(1) = HUP(I,I) - UPRAD
        UPCIRC(2) = HUP(I,I) + UPRAD

        DOWNCIRC(1) = HDOWN(I,I) - DOWNRAD
        DOWNCIRC(2) = HDOWN(I,I) + DOWNRAD

        IF (UPCIRC(1) .LT. UPMINEVAL) THEN
           UPMINEVAL = UPCIRC(1)
        ENDIF
        IF (UPCIRC(2) .GT. UPMAXEVAL) THEN
           UPMAXEVAL = UPCIRC(2)
        ENDIF
        IF (DOWNCIRC(1) .LT. DOWNMINEVAL) THEN
           DOWNMINEVAL = DOWNCIRC(1)
        ENDIF
        IF (DOWNCIRC(2) .GT. DOWNMAXEVAL) THEN
           DOWNMAXEVAL = DOWNCIRC(2)
        ENDIF

     ENDDO

     MAXEVAL = MAX(UPMAXEVAL, DOWNMAXEVAL)
     MINEVAL = MIN(UPMINEVAL, DOWNMINEVAL)

  ENDIF

  MAXMINUSMIN = MAXEVAL - MINEVAL

  RETURN

END SUBROUTINE GERSHGORIN
