!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE FERMIEXPANSSPARSE

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE FERMICOMMON
  USE SPARSEIND
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, ITER
  INTEGER :: M
  REAL(LATTEPREC) :: ONEOVERKT, OCC, OCCERROR
  REAL(LATTEPREC) :: BOVER2M, TRX, TRXOMX
  REAL(LATTEPREC) :: MAXMUSHIFT = 0.1
  REAL(LATTEPREC) :: SHIFTCP, TOL

  TOL = 1.0E-6

  M = 6

  ONEOVERKT = ONE/KBT

  OCC = BNDFIL*DFLOAT(HDIM)

  ITER = 0

  OCCERROR = 1000000.0

  BOVER2M = ONEOVERKT/(TWO**(2+M))

  ALLOCATE (X(HDIM, HDIM))

  DO WHILE (ABS(OCCERROR) .GT. TOL)

     ITER = ITER + 1

     IF (ITER .EQ. 100) THEN
        WRITE(6,*) "Fermi expansion is not converging: STOP!"
        STOP
     ENDIF     

     X = ZERO

     DO I = 1, HDIM
        DO J = 1, TOTNONZERO(I)

           IF ( I .EQ. NONZERO(I,J) ) THEN

              X(I,I) = HALF - BOVER2M*(H(I,I) - CHEMPOT)
           
           ELSEIF ( I .NE. NONZERO(I,J) ) THEN

              X(I,NONZERO(I,J)) = MINUSONE*BOVER2M*H(I,NONZERO(I,J))

           ENDIF

        ENDDO
     ENDDO     

     CALL FERMIALLOCATE

     DO I = 1, M

        CALL SOLVEMATCGSPARSE

     ENDDO

     CALL FERMIDEALLOCATE

     ! Modifying chemical potential

     TRX = ZERO
     TRXOMX = ZERO

     DO I = 1, HDIM
        DO J = 1, TOTNONZERO(I)

           IF (I .EQ. NONZERO(I,J)) THEN

              TRXOMX = TRXOMX + X(I,I)*(ONE - X(I,I))

           ELSEIF (I .NE. NONZERO(I,J)) THEN

              TRXOMX = TRXOMX - X(NONZERO(I,J),I)*X(I,NONZERO(I,J))

           ENDIF

        ENDDO

        TRX = TRX + X(I,I)

     ENDDO
        
     OCCERROR = OCC - TRX

     TRXOMX = TRXOMX*ONEOVERKT

     SHIFTCP = OCCERROR/TRXOMX

     IF (SHIFTCP .GT. MAXMUSHIFT) THEN
        SHIFTCP = MAXMUSHIFT
     ELSEIF (SHIFTCP .LT. MINUSONE*MAXMUSHIFT) THEN
        SHIFTCP = MINUSONE*MAXMUSHIFT
     ENDIF

     CHEMPOT = CHEMPOT + SHIFTCP     

  ENDDO

  BO = TWO*X

  DEALLOCATE (X)

  RETURN

END SUBROUTINE FERMIEXPANSSPARSE
           
  
  
