!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE BUILDSPARSELIST

  USE CONSTANTS_MOD
  USE SPARSEIND 
  USE FERMICOMMON

  IMPLICIT NONE

  INTEGER :: I, J, L, M 
  INTEGER :: MAXDIM
  INTEGER, ALLOCATABLE :: TMP(:,:)
  REAL(LATTEPREC) :: TOL

  TOL = 1.0E-12

  TOTNONZERO = 0
  MAXDIM = 30

  DO I = 1, HDIM
     DO J = 1, HDIM

        !
        ! User defined tolerance - should be moved to an input file
        !

        IF (ABS(X(J,I)) .GT. TOL) THEN

           TOTNONZERO(I) = TOTNONZERO(I) + 1

           IF (TOTNONZERO(I) .GT. MAXDIM) THEN

!              PRINT*, "Increasing size of sparse map array"

              ALLOCATE(TMP(HDIM, MAXDIM))

              MAXDIM = TOTNONZERO(I)

              DO L = 1, I
                 DO M = 1, MAXDIM - 1
                    TMP(L,M) = NONZERO(L,M)
                 ENDDO
              ENDDO

              DEALLOCATE (NONZERO)

              ALLOCATE(NONZERO(HDIM,MAXDIM))

              DO L = 1, I
                 DO M = 1, MAXDIM - 1
                    NONZERO(L,M) = TMP(L,M)
                 ENDDO
              ENDDO
              
              DEALLOCATE(TMP)

           ENDIF

           NONZERO(I,TOTNONZERO(I)) = J
           
        ENDIF

     ENDDO
  ENDDO
  
  RETURN  

END SUBROUTINE BUILDSPARSELIST
