!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE BLDNEWH(SWITCH)

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE GSPARRAY
  USE NEBLISTARRAY
  USE XBOARRAY
  USE COULOMBARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, NEWJ, K, KK, SUBI
  INTEGER :: MYINDEX, INDI, INDJ
  INTEGER :: SWITCH
  INTEGER :: PBCI, PBCJ, PBCK
  REAL(LATTEPREC) :: HPPS, HPPP, PPSMPPP
  REAL(LATTEPREC) :: SCLGSP
  REAL(LATTEPREC) :: L, M, N, RIJ(3), MAGR

  !
  ! The sp H-matrix elements so we don't confuse ourselves...
  !

  REAL(LATTEPREC) :: SISJ = ZERO 
  REAL(LATTEPREC) :: SIPXJ = ZERO, SIPYJ = ZERO, SIPZJ = ZERO
  REAL(LATTEPREC) :: PXISJ = ZERO, PYISJ = ZERO, PZISJ = ZERO
  REAL(LATTEPREC) :: PXPX = ZERO, PXPY = ZERO, PXPZ = ZERO
  REAL(LATTEPREC) :: PYPX = ZERO, PYPY = ZERO, PYPZ = ZERO
  REAL(LATTEPREC) :: PZPX = ZERO, PZPY = ZERO, PZPZ = ZERO

  !

  CHARACTER(LEN=2) :: BASISI, BASISJ

  IF (SWITCH .EQ. 0) THEN

     H = ZERO

     MYINDEX = 0

     DO I = 1, NATS
        DO K = 1, NOELEM
           
           IF (ATELE(I) .EQ. ELE(K)) THEN
              
              IF (BASIS(K) .EQ. "sp") THEN
                 
                 DO SUBI = 1, 4
                    
                    MYINDEX = MYINDEX + 1
                    
                    IF (SUBI .EQ. 1) THEN
                       
                       H(MYINDEX, MYINDEX) = HES(K)
                       
                    ELSEIF (SUBI .GT. 1) THEN
                       
                       H(MYINDEX, MYINDEX) = HEP(K)
                       
                    ENDIF

                 ENDDO
                 
              ELSEIF (BASIS(K) .EQ. "ss") THEN
                 
                 MYINDEX = MYINDEX + 1
              
                 H(MYINDEX, MYINDEX) = HES(K)
                 
              ENDIF
              
           ENDIF
           
        ENDDO
     ENDDO

  ENDIF

  DO I = 1, HDIM
     DO J = 1, HDIM

        IF (I .NE. J) THEN
           H(J,I) = ZERO
        ENDIF

     ENDDO
  ENDDO

  INDI = 0
  INDJ = 0

  !
  ! Calling XBO propagation of the on-site H matrix elements
  !
  ! It is done here only if electrostatics are off!
  !

  IF (XBOON .EQ. 1 .AND. SWITCH .NE. 0 .AND. ELECTRO .EQ. 0) THEN

     CALL XBO
     
  ENDIF

  !
  ! In the following, just to be clear, 
  !
  ! SSS = S S SIGMA
  ! SPS = S P SIGMA
  ! PSS = P S SIGMA
  ! PPS = P P SIGMA
  ! PPP = P P PI,
  ! 
  ! are the fundamental Slater-Koster bond integrals
  !

  DO I = 1, NATS

     DO K = 1, NOELEM
        IF (ATELE(I) .EQ. ELE(K)) THEN           
           BASISI = BASIS(K)
        ENDIF
     ENDDO

     DO NEWJ = 1, TOTNEBTB(I)

        !
        ! Getting neighbors from the TB neighborlist
        !

        J = NEBTB(I, NEWJ, 1)

        IF (J .GT. I) THEN
           
           PBCI = NEBTB(I, NEWJ, 2)
           PBCJ = NEBTB(I, NEWJ, 3)
           PBCK = NEBTB(I, NEWJ, 4)
           

           INDJ = 0
           DO K = 1, J-1
              DO KK = 1, NOELEM
                 IF (ATELE(K) .EQ. ELE(KK)) THEN
                    IF (BASIS(KK) .EQ. "sp") THEN
                       INDJ = INDJ + 4
                    ELSEIF (BASIS(KK) .EQ. "ss") THEN
                       INDJ = INDJ + 1
                    ENDIF
                 ENDIF
              ENDDO
           ENDDO
           
           !
           !     Which orbitals does J have? (s, sp, etc.)?
           !
           
           DO K = 1, NOELEM
              IF (ATELE(J) .EQ. ELE(K)) THEN
                 BASISJ = BASIS(K)
              ENDIF
           ENDDO
           
           RIJ(1) = CR(1,J) + FLOAT(PBCI)*(BOX(2,1)-BOX(1,1)) - CR(1,I)
           RIJ(2) = CR(2,J) + FLOAT(PBCJ)*(BOX(2,2)-BOX(1,2)) - CR(2,I)
           RIJ(3) = CR(3,J) + FLOAT(PBCK)*(BOX(2,3)-BOX(1,3)) - CR(3,I)
           
           MAGR = SQRT(RIJ(1)*RIJ(1) + RIJ(2)*RIJ(2) + RIJ(3)*RIJ(3))

           !
           ! Direction cosines
           !
           
           L = RIJ(1)/MAGR
           M = RIJ(2)/MAGR
           N = RIJ(3)/MAGR
           
           !
           ! 5/3/10: Major bug fix by Ed Sanville for when 
           ! the periodic cell measures less than the cut-off
           ! for the bond integrals.
           !
           
           IF (BASISI .EQ. "ss") THEN
              
              IF (BASISJ .EQ. "ss") THEN

                 ! SISJ 

                 DO K = 1, NOINT
                    IF ((ATELE(I) .EQ. ELE1(K) .AND. &
                         ATELE(J) .EQ. ELE2(K)) .OR. &
                         (ATELE(I) .EQ. ELE2(K) .AND. &
                         ATELE(J) .EQ. ELE1(K))) THEN

                       IF (BTYPE(K) .EQ. "sss") THEN
                          CALL GSP(MAGR, K, SCLGSP)
                          SISJ = HR0(K)*SCLGSP
                       ENDIF

                    ENDIF
                 ENDDO
                 
                 H(INDI+1, INDJ+1) = H(INDI+1, INDJ+1) + SISJ

              ELSEIF (BASISJ .EQ. "sp") THEN

                 ! SISJ, SIPXJ, SIPYJ, SIPZJ
                 
                 DO K = 1, NOINT
                    
                    IF ((ATELE(I) .EQ. ELE1(K) .AND. &
                         ATELE(J) .EQ. ELE2(K)) .OR. &
                         (ATELE(I) .EQ. ELE2(K) .AND. &
                         ATELE(J) .EQ. ELE1(K))) THEN
                       
                       IF (BTYPE(K) .EQ. "sss") THEN
                          
                          CALL GSP(MAGR, K, SCLGSP)
                          SISJ = HR0(K)*SCLGSP
                          
                       ELSEIF (BTYPE(K) .EQ. "sps") THEN
                          
                          CALL GSP(MAGR, K, SCLGSP)
                          
                          SIPXJ = L * HR0(K)*SCLGSP
                          SIPYJ = M * HR0(K)*SCLGSP
                          SIPZJ = N * HR0(K)*SCLGSP
                          
                       ENDIF
                    ENDIF
                 ENDDO
                 
                 H(INDI+1, INDJ+1) = H(INDI+1, INDJ+1) + SISJ
                 H(INDI+1, INDJ+2) = H(INDI+1, INDJ+2) + SIPXJ
                 H(INDI+1, INDJ+3) = H(INDI+1, INDJ+3) + SIPYJ
                 H(INDI+1, INDJ+4) = H(INDI+1, INDJ+4) + SIPZJ
                 
              ENDIF
              
           ELSEIF (BASISI .EQ. "sp") THEN
              
              IF (BASISJ .EQ. "ss") THEN
                 
                 ! SISJ, PXISJ, PYISJ, PZISJ
                 
                 DO K = 1, NOINT
                    
                    IF ((ATELE(I) .EQ. ELE1(K) .AND. &
                         ATELE(J) .EQ. ELE2(K)) .OR. &
                         (ATELE(I) .EQ. ELE2(K) .AND. &
                         ATELE(J) .EQ. ELE1(K))) THEN
                       
                       IF (BTYPE(K) .EQ. "sss") THEN
                          
                          CALL GSP(MAGR, K, SCLGSP)
                          SISJ = HR0(K)*SCLGSP
                          
                       ELSEIF (BTYPE(K) .EQ. "sps") THEN
                          
                          CALL GSP(MAGR, K, SCLGSP)
                          
                          PXISJ = MINUSONE * L * HR0(K)*SCLGSP
                          PYISJ = MINUSONE * M * HR0(K)*SCLGSP
                          PZISJ = MINUSONE * N * HR0(K)*SCLGSP
                          
                       ENDIF
                    ENDIF
                 ENDDO
                 
                 H(INDI+1, INDJ+1) = H(INDI+1, INDJ+1) + SISJ
                 H(INDI+2, INDJ+1) = H(INDI+2, INDJ+1) + PXISJ
                 H(INDI+3, INDJ+1) = H(INDI+3, INDJ+1) + PYISJ
                 H(INDI+4, INDJ+1) = H(INDI+4, INDJ+1) + PZISJ
                 
              ELSEIF (BASISJ .EQ. "sp") THEN
                 
                 ! element I = element J is a bit simpler 
                 
                 IF (ATELE(I) .EQ. ATELE(J)) THEN
                    
                    DO K = 1, NOINT
                       
                       IF (ATELE(I) .EQ. ELE1(K) .AND. &
                            ATELE(J) .EQ. ELE2(K)) THEN
                          
                          IF (BTYPE(K) .EQ. "sss") THEN                 
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             SISJ = HR0(K)*SCLGSP
                             
                          ELSEIF (BTYPE(K) .EQ. "sps") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             
                             SIPXJ = L * HR0(K)*SCLGSP
                             SIPYJ = M * HR0(K)*SCLGSP
                             SIPZJ = N * HR0(K)*SCLGSP
                             
                             PXISJ = MINUSONE * L * HR0(K)*SCLGSP
                             PYISJ = MINUSONE * M * HR0(K)*SCLGSP
                             PZISJ = MINUSONE * N * HR0(K)*SCLGSP
                             
                          ELSEIF (BTYPE(K) .EQ. "pps") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             HPPS = HR0(K)*SCLGSP
                             
                          ELSEIF (BTYPE(K) .EQ. "ppp") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             HPPP = HR0(K)*SCLGSP
                             
                          ENDIF
                       ENDIF
                    ENDDO
                    
                 ELSEIF (ATELE(I) .NE. ATELE(J)) THEN
                    
                    DO K = 1, NOINT
                       
                       IF (ATELE(I) .EQ. ELE1(K) .AND. &
                            ATELE(J) .EQ. ELE2(K)) THEN
                          
                          IF (BTYPE(K) .EQ. "sss") THEN                 
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             SISJ = HR0(K)*SCLGSP
                             
                          ELSEIF (BTYPE(K) .EQ. "sps") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             SIPXJ = L * HR0(K) * SCLGSP
                             SIPYJ = M * HR0(K) * SCLGSP
                             SIPZJ = N * HR0(K) * SCLGSP
                             
                          ELSEIF (BTYPE(K) .EQ. "pps") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             
                             HPPS = HR0(K)*SCLGSP
                             
                          ELSEIF (BTYPE(K) .EQ. "ppp") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             
                             HPPP = HR0(K)*SCLGSP
                             
                          ENDIF
                          
                       ELSEIF (ATELE(I) .EQ. ELE2(K) .AND. &
                            ATELE(J) .EQ. ELE1(K)) THEN

                          IF (BTYPE(K) .EQ. "sss") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             SISJ = HR0(K)*SCLGSP
                             
                          ELSEIF (BTYPE(K) .EQ. "sps") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
!                             SIPXJ = L * HR0(K) * SCLGSP
!                             SIPYJ = M * HR0(K) * SCLGSP
!                             SIPZJ = N * HR0(K) * SCLGSP
                             
                             PXISJ = MINUSONE * L * HR0(K) * SCLGSP
                             PYISJ = MINUSONE * M * HR0(K) * SCLGSP
                             PZISJ = MINUSONE * N * HR0(K) * SCLGSP

                          ELSEIF (BTYPE(K) .EQ. "pps") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             
                             HPPS = HR0(K)*SCLGSP
                             
                          ELSEIF (BTYPE(K) .EQ. "ppp") THEN
                             
                             CALL GSP(MAGR, K, SCLGSP)
                             
                             HPPP = HR0(K)*SCLGSP
                             
                          ENDIF
                          
                       ENDIF
                    ENDDO
                    
                 ENDIF
                 
                 PPSMPPP = HPPS - HPPP
                 
                 PXPX = HPPP + L*L*PPSMPPP
                 PXPY = L*M*PPSMPPP
                 PXPZ = L*N*PPSMPPP
                 PYPX = M*L*PPSMPPP
                 PYPY = HPPP + M*M*PPSMPPP
                 PYPZ = M*N*PPSMPPP
                 PZPX = N*L*PPSMPPP
                 PZPY = N*M*PPSMPPP
                 PZPZ = HPPP + N*N*PPSMPPP
                 
                 H(INDI+1,INDJ+1) = H(INDI+1,INDJ+1) + SISJ
                 H(INDI+1,INDJ+2) = H(INDI+1,INDJ+2) + SIPXJ
                 H(INDI+1,INDJ+3) = H(INDI+1,INDJ+3) + SIPYJ
                 H(INDI+1,INDJ+4) = H(INDI+1,INDJ+4) + SIPZJ
                 H(INDI+2,INDJ+1) = H(INDI+2,INDJ+1) + PXISJ
                 H(INDI+2,INDJ+2) = H(INDI+2,INDJ+2) + PXPX
                 H(INDI+2,INDJ+3) = H(INDI+2,INDJ+3) + PXPY
                 H(INDI+2,INDJ+4) = H(INDI+2,INDJ+4) + PXPZ
                 H(INDI+3,INDJ+1) = H(INDI+3,INDJ+1) + PYISJ
                 H(INDI+3,INDJ+2) = H(INDI+3,INDJ+2) + PYPX
                 H(INDI+3,INDJ+3) = H(INDI+3,INDJ+3) + PYPY
                 H(INDI+3,INDJ+4) = H(INDI+3,INDJ+4) + PYPZ
                 H(INDI+4,INDJ+1) = H(INDI+4,INDJ+1) + PZISJ
                 H(INDI+4,INDJ+2) = H(INDI+4,INDJ+2) + PZPX
                 H(INDI+4,INDJ+3) = H(INDI+4,INDJ+3) + PZPY
                 H(INDI+4,INDJ+4) = H(INDI+4,INDJ+4) + PZPZ
                 
              ENDIF
           ENDIF
        ENDIF
        
     ENDDO
     
     IF (BASISI .EQ. "sp") THEN
        INDI = INDI + 4
     ELSEIF (BASISI .EQ. "ss") THEN
        INDI = INDI + 1
     ENDIF
     
  ENDDO
  
  ! 
  ! ... and fill in the other half of the matrix
  !

  DO I = 1, HDIM
     DO J = I, HDIM
        H(J,I) = H(I,J)
     ENDDO
  ENDDO
  
  
!  OPEN(UNIT=30, STATUS="UNKNOWN", FILE="myH.dat")
  
!  PRINT*, "warning - the H matrix is being written to file for testing"

!  DO I = 1, HDIM
!     WRITE(30,10) (H(I,J), J = 1, HDIM)
!  ENDDO

!  CLOSE(30)
!10 FORMAT(8F12.6)
  
  RETURN
  
END SUBROUTINE BLDNEWH
