/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

#include <math.h>
#include <stdio.h>

#undef REALSIZE
#define REALSIZE 4
#include "Matrix.h"

#undef REALSIZE
#define REALSIZE 8
#include "Matrix.h"

extern "C" void multiply_matrices_(void *a, int *a_m_p, int *a_n_p, void *b, int *b_m_p, int *b_n_p, void *c, int *Precision_p) {
  //printf("Calling lib function!\n");
  if (*Precision_p==4) {
    Matrix4 A, B, C;
    M_InitWithLocal(A, (float *)a, *a_m_p, *a_n_p);
    M_InitWithLocal(B, (float *)b, *a_m_p, *a_n_p);
    M_InitWithLocal(C, (float *)c, *a_m_p, *a_n_p);
    M_Push(A);
    M_Push(B);
    M_Multiply(A, B, C);
    M_Pull(C);
    M_DeallocateDevice(A);
    M_DeallocateDevice(B);
    M_DeallocateDevice(C);
  }
  if (*Precision_p==8) {
    Matrix8 A, B, C;
    M_InitWithLocal(A, (double *)a, *a_m_p, *a_n_p);
    M_InitWithLocal(B, (double *)b, *a_m_p, *a_n_p);
    M_InitWithLocal(C, (double *)c, *a_m_p, *a_n_p);
    M_Push(A);
    M_Push(B);
    M_Multiply(A, B, C);
    M_Pull(C);
    M_DeallocateDevice(A);
    M_DeallocateDevice(B);
    M_DeallocateDevice(C);
  }
}

