<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */

  function xfs_update($dbv_src,$dbv_tgt){
  // NOTE: probably we have to blacklist some updates in the future for specific versions to prevent trouble :)
  $update_steps = array('preparing','running','cleaning');
  $update_catalog = array(
  01=>array(0,'--'),
  10=>array(0,'1.0.0 »»» 1.2.0')
  );

    foreach ( $update_catalog as $k=>$v ){
      if ( (int)$dbv_src >= $k )
      continue;
    $error = false;
    require_once('update_'.$v[0].'.php');
    echon(sprintf(xf_i18n('update_description'),$k,$v[1]).'<br /><br />');
    XF::sql_transaction('begin',array());
      foreach ( $update_steps as $u ){
      XF::$sql_had_error = false;
      $fn = 'xfs_update__'.$k.'__'.$u;
      echon('&nbsp;&nbsp;&nbsp;&nbsp;'.xf_i18n('update_'.$u).'...
      <span id="xfs_update_'.$k.'_'.$u.'_status"></span><div id="xfs_update_'.$k.'_'.$u.'_msg">');
        if ( !$error && function_exists($fn) ){
        $r = call_user_func($fn);
          if ( !$r )
          $error = true;
        xfs_update_status($r,$k,$u);
        }
        else
        xfs_update_status(-1,$k,$u);
      echon('</div><br />');
      }
    echon('<hr />');
    ( !$error ) ? XF::sql_transaction('commit') : XF::sql_transaction('rollback');
      if ( !$error ){
      echon(xf_i18n('update_applied'));
      XF::sql_query("UPDATE ".XF::tbl('config')." SET c_value = :value WHERE c_id = :id",array('id'=>array('_','str'),'value'=>array($k,'int')),__FILE__,__LINE__);
      }
    break; // only one update per run...
    }

    if ( !isset($error) && max(array_keys($update_catalog)) === $dbv_tgt ){
    echon('<button class="xf_setup_button" onclick="location.href=\'index.php?step=8\'">'.xf_i18n('update_complete').'</button>');
    $_SESSION['xf_setup']['allow_update'] = false;
    }
  XF::$sql_had_error = false;
  return true;
  }

  function xfs_update_status($a,$b,$c){
    if ( is_bool($a) ){
      if ( $a )
      $o = array(xf_i18n('update_ok'),'ok');
      else
      $o = array(xf_i18n('update_fail'),'fail');
    }
    else
    $o = array(xf_i18n('update_skip'),'skip');

  echon('<script type="text/javascript">/* <![CDATA[ */
  document.getElementById("xfs_update_'.$b.'_'.$c.'_status").innerHTML="'.$o[0].'";
  document.getElementById("xfs_update_'.$b.'_'.$c.'_status").className="xf_update_'.$o[1].'";
  /* ]]> */</script>');
  return true;
  }

  function xfs_update_msg($a,$b,$c){
  echon('<script type="text/javascript">/* <![CDATA[ */
  document.getElementById("xfs_update_'.$b.'_'.$c.'_msg").innerHTML+="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;· '.$a.'<br />";
  /* ]]> */</script>');
  return true;
  }

  function xfs_update_add_acl($a,$b){
  static $groups = array();
    if ( sizeof($groups) === 0 ){
    $sgrp = XF::sql_query("SELECT * FROM ".XF::tbl('group'),'',__FILE__,__LINE__);
      while ( $r = $sgrp->fetchObject() ){
      $groups[(int)$r->g_id] = (array)$r;
      $groups[(int)$r->g_id]['USER'] = false;
      }
    $sgrp->closeCursor();
    $susr = XF::sql_query("SELECT a_key,a_use_group,a_allow FROM ".XF::tbl('acl')." WHERE a_action = 'ucp_profile'",'',__FILE__,__LINE__);
      while ( $r = $susr->fetchObject() ){
        if ( isset($groups[(int)$r->a_key]) && (bool)$r->a_use_group )
        $groups[(int)$r->a_key]['__USER'] = (bool)$r->a_allow;
      }
    $susr->closeCursor();
    }
  $b = explode(',',$b);
    foreach ( $groups as $v ){
    $c = false;
      if ( in_array('*',$b,true) )
      $c = true;
      if ( in_array('user',$b,true) && $v['USER'] )
      $c = true;
      if ( in_array('mod',$b,true) && (bool)$v['g_moderator'] )
      $c = true;
      if ( in_array('exec',$b,true) && (bool)$v['g_executive'] )
      $c = true;
    XF::sql_query("INSERT INTO ".XF::tbl('acl')." (a_action,a_key,a_allow) VALUES (:action,:group,:allow)",array('action'=>array($a,'str'),'group'=>array($v['g_id'],'int'),'allow'=>array($c,'int')),__FILE__,__LINE__);
    }
  return true;
  }

?>