<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

/**
* XFHttp is a simple wrapper API around PHP HTTP streaming extension as easier interface for LB
* @package lbbackend
*/
class XFHttp {
/**
* @var string the full uri to the external resource
*/
protected $uri = '';
/**
* @var string what http method should be used?
*/
protected $request_method = 'GET';
/**
* @var array some options for this class
*/
protected $flags = array('http_version'=>'1.0','enable_gzip_response'=>false);
/**
* @var array set a proxy for the connection
*/
protected $proxy = array('host'=>'','port'=>8080);
/**
* @var string the response code of a request i.e. "200 OK"
*/
protected $response_code = null;
/**
* @var array the http request headers sent to the remote server
*/
protected $header_request = array();
/**
* @var array the http response headers received from the remote server
*/
protected $header_response = array();
/**
* @var string body payload for request to server
*/
protected $body_request = '';
/**
* @var string body payload from response from server
*/
protected $body_response = '';

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * set an option
  * @param string $a name of option (see XFHttp::$flags for details)
  * @param string $b value of option
  * @return boolean
  * @since 1.1.3
  */
  public function set_option($a,$b){
  $s = false;
    switch ( $a ){
    case 'http_version':
      if ( $b === '1.0' || $b === '1.1' ){
      $this->flags['http_version'] = $b;
      $s = true;
      }
    break;
    case 'enable_gzip_response':
    $this->flags['enable_gzip_response'] = (bool)$b;
    $s = true;
    break;
    default: break;
    }
  return $s;
  }

  /**
  * set the http method used for this request
  * @param string $a method type (HEAD,GET,POST,PUT)
  * @return boolean
  * @since 1.1.3
  */
  public function set_method($a){
  $a = strtoupper($a);
    if ( in_array($a,array('HEAD','GET','POST','PUT'),true) ){
    $this->request_method = $a;
    return true;
    }
    else
    return false;
  }

  /**
  * set a http method that relays our request
  * @param string $h hostname or ip-address
  * @param integer $p optional port number (can also be in $h like host.domain.xx:8080)
  * @return boolean
  * @since 1.1.3
  */
  public function set_proxy($h,$p = 8080){
    if ( preg_match('/:([0-9]{1,5})$/D',$h,$r) ){
    $h = str_replace($r[0],'',$h);
    $p = intval($r[1]);
    }
    if ( preg_match('/^[a-z0-9\.\-]+$/im',$h) ){
    $this->proxy['host'] = $h;
      if ( (int)$p >= 1 && (int)$p <= 65534 )
      $this->proxy['port'] = intval($p);
    return true;
    }
    else
    return false;
  }

  /**
  * set the full uri for our request i.e. "http://sub.domain.com/foo.html"
  * any get paramaters can be appended as usual i.e. "?foo=bar&lbis=fine"
  * @param string $a "well-formed" uri
  * @return boolean
  * @since 1.1.3
  */
  public function set_uri($a){
  $a = XF::sanitize_var($a,'uri');
    if ( $a ){
    $this->uri = $a;
    $this->set_header('Date',gmdate(XF::DATE_RFC822));
    $this->set_header('User-Agent','Larus Board/'.substr(XF::VERSION,0,strrpos(XF::VERSION,'.')).' (HTTP API)');
    $this->set_header('Connection','close');
    return true;
    }
    else
    return false;
  }

  /**
  * push a custom http header on the stack for our request
  * "Date" and "Connection" are added automatically and required "Content-*" in case of POST/PUT
  * @param string $a name of the header
  * @param string $b value of the header
  * @param string $c 'replace' is default, 'keep' preserves previous if already defined and 'append' or 'preprend' modifies it
  * @return boolean
  * @since 1.1.3
  */
  public function set_header($a,$b,$c='replace'){
    if ( preg_match('/^[A-Z]{1}[a-zA-Z0-9\-]{1,40}$/m',$a) ){
    $v = ( isset($this->header_request[$a]) ) ? $this->header_request[$a] : '';
    $z = XF::sanitize_var($b,'str','notrim');
      if ( $c === 'keep' && isset($this->header_request[$a]) )
      return false;
      if ( $c === 'prepend' )
      $v = $z.$v;
      elseif ( $c === 'append' )
      $v = $v.$z;
      else
      $v = $z;
    $this->header_request[$a] = $v;
    return true;
    }
    else
    return false;
  }

  /**
  * set the body for our request usually on POST/PUT
  * provide an array or a prepared urlencoded string
  * @param mixed $a body payload
  * @return true
  * @since 1.1.3
  */
  public function set_body($a){
    if ( is_array($a) )
    $this->body_request = http_build_query($a);
    else
    $this->body_request = $a;
  return true;
  }

  /**
  * get the response from the remote server after our request
  * returns "code", "header" and "body"
  * @param none
  * @return mixed
  * @since 1.1.3
  */
  public function get_response($a = ''){
    if ( is_null($this->response_code) )
    $this->execute();
  return array('code'=>$this->response_code,'header'=>$this->header_response,'body'=>$this->body_response);
  }

  /**
  * well, parse the data and issue the request
  * @param none
  * @return boolean
  * @since 1.1.3
  */
  protected function execute(){
    if ( empty($this->uri) ){
    trigger_error('not ready to execute your request (uri is missing)',E_USER_ERROR);
    return false;
    }
    if ( $this->request_method === 'POST' && empty($this->body_request) ){
    trigger_error('not ready to execute your request (no post data)',E_USER_ERROR);
    return false;
    }
    if ( $this->flags['enable_gzip_response'] )
    $this->set_header('Accept-Encoding','gzip');
  $wp = substr($this->uri,0,strpos($this->uri,'://'));
  $co = array($wp=>array(
  //'verify_peer'=>false,
  //'allow_self_signed'=>false,
  'ignore_errors'=>true,
  'protocol_version'=>$this->flags['http_version'],
  'method'=>$this->request_method
  ));
    if ( version_compare(PHP_VERSION,'5.2.1','>=') )
    $co[$wp]['timeout'] = 5;
    if ( !empty($this->proxy['host']) ){
    $this->set_header('Proxy-Connection','close');
    $co[$wp]['proxy'] = 'tcp://'.$this->proxy['host'].':'.$this->proxy['port'];
    $co[$wp]['request_fulluri'] = true;
    }
    if ( in_array($this->request_method,array('POST','PUT')) ){
    $co[$wp]['content'] = $this->body_request;
      if ( $this->request_method === 'POST' )
      $this->set_header('Content-Type','application/x-www-form-urlencoded; charset=utf-8');
    $this->set_header('Content-Length',strlen($this->body_request));
    $this->set_header('Content-MD5',md5($this->body_request));
    $this->set_header('X-Content-SHA1',sha1($this->body_request));
    }
  $co[$wp]['header'] = $this->header_to_str($this->header_request);
  $res = file_get_contents($this->uri,false,stream_context_create($co));
    if ( isset($http_response_header) && is_array($http_response_header) ){
      if ( isset($http_response_header[0]) && preg_match('/^HTTP\/1\.[01]+\s+(\d+\s+.+)$/im',$http_response_header[0],$r) )
      $this->response_code = $r[1];
    }
  $this->header_response = $http_response_header;
  $this->body_response = ( stripos(implode(chr(10),$this->header_response),'Content-Encoding: gzip') )
  ? gzinflate(substr($res,10))
  : $res;
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,XF::arr2str(array_merge(array('request_uri'=>$this->uri,'response_code'=>$this->response_code,'proxy'=>implode(':',$this->proxy)),$co[$wp])));
  return true;
  }

  /**
  * transform array to a compatible string for requests
  * @param array $a header data
  * @return string
  * @since 1.1.3
  */
  protected function header_to_str($a){
  $b = '';
    foreach ( $a as $k=>$v )
    $b .= $k.': '.$v.chr(13).chr(10);
  return rtrim($b);
  }

}
?>