<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_register extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','register');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $stage = XF::sanitize_var(XF::ifset('get','stage',1),'int');
  $id = XF::sanitize_var(XF::ifset('get','id',0),'int');
  $hash = XF::sanitize_var(XF::ifset('get','hash',''),'str','okifempty,restrict');
  $this->gpc = array('stage'=>$stage,'id'=>$id,'hash'=>$hash);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('overview'));
  unset($stage,$id,$hash); // stage: 1=terms, 2=captcha, 3=form, 4=activate
    if ( $this->gpc['stage'] === 4 )
    return $this->activate();
    elseif ( $this->gpc['stage'] === 3 )
    XFUI::ajax_init();
  XFUI::html_head('{:register}');
  XF::$tpl->assign('stage',$this->gpc['stage']);
  XF::$tpl->assign('terms_of_use',XF::file_handler('lang/'.XF::vault_query('current_language').'/terms.txt','','read,local'));
  XF::$tpl->display('form_register.tpl',$this->gpc['stage']);
  XFUI::html_foot();
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $uid = XF::sanitize_var(XF::ifset($input,'f_user',''),'uid');
  $mail = XF::sanitize_var(XF::ifset($input,'f_mail',''),'mail');
  $this->gpc = array('f_user'=>$uid,'f_mail'=>$mail);
  $this->markgpc = array('f_user','f_mail');
  return true;
  }

  /**
  * register a new user account
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $susr = XF::sql_query("SELECT u_id FROM ".XF::tbl('user')." WHERE u_name = :username",
    array('username'=>array($this->gpc['f_user'],'str')),__METHOD__,__LINE__);
    $userdata = $susr->fetchObject();
    $susr->closeCursor();
      if ( is_object($userdata) )
      $this->error = '{:username_already_used}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user'=>'w','user_request'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $hash = XF::token(16,'alnum');
      XF::sql_query("INSERT INTO ".XF::tbl('user')." (u_active,u_uuid,u_name,u_mail,u_group,u_time_registration) VALUES
      (:active,:uuid,:username,:mail,:group,:regtime)",
      array('active'=>array(0,'str'),
      'uuid'=>XF::uuid(),
      'username'=>array($this->gpc['f_user'],'str'),
      'mail'=>array($this->gpc['f_mail'],'str'),
      'group'=>array(XF::get_cfg('main_default_group'),'int'),
      'regtime'=>array(XF::vault_query('uts'),'int')),__METHOD__,__LINE__);
      $newuid = XF::sql_lastId('user.u_id');
        if ( !$newuid )
        throw new XFE('new user could not be inserted');
      $link = XF::link('register',array('stage'=>4,'id'=>$newuid,'hash'=>$hash),false);
      $i = XF::sql_query("INSERT INTO ".XF::tbl('user_request')." (ur_class,ur_u_id,ur_time,ur_hash) VALUES
      ('ACTIVATE_ACCOUNT',:userid,:time,:hash)",
      array('userid'=>array($newuid,'int'),
      'hash'=>array($hash,'str'),
      'time'=>array(XF::vault_query('uts'),'int')),__METHOD__,__LINE__);
        if ( !$i )
        throw new XFE('new request could not be inserted');
      require_once(XF::vault_query('root_path').'/class.mail.php');
      $m = XFMail::send(array(
      'to'=>$this->gpc['f_mail'],
      'subject'=>XF::get_cfg('main_title').' - '.XFUI::i18n('register_account'),
      'message'=>sprintf(XF::file_handler('lang/'.XF::vault_query('current_language').'/registration.txt','','read,local'),
        XF::get_cfg('main_title'),
        $this->gpc['f_user'],
        round(XF::get_cfg('auth_activate_limit')/3600,0),
        $link,
        XF::get_cfg('mail_from_name')
        )
      ));
        if ( !$m )
        throw new XFE('account activation mail was not sent');
      XF::logger('info','new_userid',$newuid,'hash',$hash);
      XF::statistic('account_register');
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

  /**
  * activate an user account by requested confirmation token
  * @return boolean
  * @since 1.0.0
  */
  protected function activate(){
    try {
    $susr = XF::sql_query("SELECT u_active,u_password,ur_time,ur_hash FROM ".XF::tbl('user')."
    LEFT JOIN ".XF::tbl('user_request')." ON ".XF::tbl('user_request').".ur_u_id = ".XF::tbl('user').".u_id
    WHERE u_id = :id AND ur_class = 'ACTIVATE_ACCOUNT'",
    array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $userdata = $susr->fetchObject();
    $susr->closeCursor();
      if ( !is_object($userdata) )
      $this->error = '{:no_valid_id}';
      else{
        if ( (bool)$userdata->u_active && empty($this->error) )
        $this->error = '{:already_activated}';
        if ( $userdata->ur_time+XF::get_cfg('auth_activate_limit') < XF::vault_query('uts') && empty($this->error) )
        $this->error = '{:time limit for activation exceeded}';
        if ( $userdata->ur_hash !== $this->gpc['hash'] && empty($this->error) )
        $this->error = '{:hash_not_equal}';
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user'=>'w','user_request'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $r = XF::link('login');
      $u = XF::sql_query("UPDATE ".XF::tbl('user')." SET u_active = true WHERE u_id = :id",
      array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
        if ( $u ){
        XF::sql_query("DELETE FROM ".XF::tbl('user_request')." WHERE ur_u_id = :id AND ur_class = 'ACTIVATE_ACCOUNT'",
        array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
          if ( empty($userdata->u_password) ){
          $hash = XF::token(16,'alnum');
          XF::sql_query("INSERT INTO ".XF::tbl('user_request')." (ur_class,ur_u_id,ur_time,ur_hash) VALUES ('ACTIVATE_PASSWORD',:userid,:time,:hash)",
          array('userid'=>array($this->gpc['id'],'int'),
          'hash'=>array($hash,'str'),
          'time'=>array(XF::vault_query('uts'),'int')),__METHOD__,__LINE__);
          $r = XF::link('reset_password',array('hash'=>$hash));
          }
        }
      XFCache::statistic('user','rebuild');
      XF::logger(':'.$u,'sub','ACTIVATE_ACCOUNT','userid',$this->gpc['id']);
      XF::statistic('account_activation');
      XF::sql_transaction('commit');
      XFUI::html_redirect(1,$r,'{:account_activation_success}');
      }
      else
      XFUI::html_redirect(0,XF::link('overview'),$this->error);

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_register($input){
  $a = new XFAction_register();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('overview','',false),'{:account_successfully_registered}');
    else
    return xfaf_failure($a->get_error());
  }

?>