<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_group_edit extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('acp_overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $name = XF::sanitize_var(XF::ifset($input,'f_name',''),'str','stripspaces,length=4-32');
  $color = XF::sanitize_var(XF::ifset($input,'f_color','000000'),'color','forcestr');
  $weight = XF::sanitize_var(XF::ifset($input,'f_weight',1),'int','range=1-5');
  $perm_pa = XF::sanitize_var(XF::ifset($input,'f_perm_pa',0),'booli');
  $perm_pr = XF::sanitize_var(XF::ifset($input,'f_perm_pr',0),'booli');
  $perm_pf = XF::sanitize_var(XF::ifset($input,'f_perm_pf',0),'booli');
  $perm_ra = XF::sanitize_var(XF::ifset($input,'f_perm_ra',0),'booli');
  $perm_md = XF::sanitize_var(XF::ifset($input,'f_perm_md',0),'booli');
  $perm_ex = XF::sanitize_var(XF::ifset($input,'f_perm_ex',0),'booli');
  $this->gpc = array('id'=>$id,'f_name'=>$name,'f_color'=>$color,'f_weight'=>$weight,
  'f_perm_pa'=>$perm_pa,'f_perm_pr'=>$perm_pr,'f_perm_pf'=>$perm_pf,'f_perm_ra'=>$perm_ra,
  'f_perm_md'=>$perm_md,'f_perm_ex'=>$perm_ex);
  $this->markgpc = array('f_name','f_color');
  return true;
  }

  /**
  * edit an user group
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('group'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $u = XF::sql_query("UPDATE ".XF::tbl('group')." SET g_name = :name, g_color = :color, g_max_post_weight = :weight,
      g_post_approved = :perm_pa, g_read_unapproved = :perm_ra, g_post_repeat = :perm_pr, g_post_filter = :perm_pf,
      g_moderator = :perm_md, g_executive = :perm_ex
      WHERE g_id = :id",array(
      'id'=>array($this->gpc['id'],'int'),
      'name'=>array($this->gpc['f_name'],'str'),
      'color'=>array($this->gpc['f_color'],'str'),
      'weight'=>array($this->gpc['f_weight'],'int'),
      'perm_pa'=>array($this->gpc['f_perm_pa'],'str'),
      'perm_pr'=>array($this->gpc['f_perm_pr'],'str'),
      'perm_pf'=>array($this->gpc['f_perm_pf'],'str'),
      'perm_ra'=>array($this->gpc['f_perm_ra'],'str'),
      'perm_md'=>array($this->gpc['f_perm_md'],'str'),
      'perm_ex'=>array($this->gpc['f_perm_ex'],'str')),__METHOD__,__LINE__);
        if ( !$u )
        throw new XFE('cannot edit group data');
      XF::logger('info','id',$this->gpc['id']);
      XF::sql_transaction('commit');
      XFCache::purge('simple','group');
      $this->success = true;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_group_edit($input){
  $a = new XFAction_acp_group_edit();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('acp_group_list','',false),'{:edit_group_successful}');
    else
    return xfaf_failure($a->get_error());
  }

?>