<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_group_delete extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('acp_overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $this->gpc = array('id'=>$id);
  return true;
  }

  /**
  * delete an user group
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $group_data = XF::get_group($this->gpc['id']);
      if ( !$group_data || in_array($this->gpc['id'],array(1,2,3,4,5),true) )
      $this->error = '{:no_valid_id}';
      else{
      $schk = XF::sql_query("SELECT COUNT(u_id) AS user_in_group FROM ".XF::tbl('user')." WHERE u_group = :id",array(
      'id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
      $user_data = $schk->fetchObject();
        if ( (int)$user_data->user_in_group > 0 )
        $this->error = '{:group_is_not_empty}';
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('acl'=>'w','group'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $d = XF::sql_query("DELETE FROM ".XF::tbl('group')." WHERE g_id = :id",array(
      'id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
        if ( !$d )
        throw new XFE('user group "'.$this->gpc['id'].'" could not be deleted');
      $sacl = XF::sql_query("SELECT a_id,a_action FROM ".XF::tbl('acl')." WHERE a_key = :group AND a_use_group = true",array('group'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
        while ( $r = $sacl->fetchObject() ){
        XF::sql_query("DELETE FROM ".XF::tbl('acl')." WHERE a_id = :aclid",array('aclid'=>array($r->a_id,'int')),__METHOD__,__LINE__);
        XFCache::purge('acl',crc32($r->a_action));
        }
      $sacl->closeCursor();
      XF::logger('info','id',$this->gpc['id']);
      XF::sql_transaction('commit');
      XFCache::purge('simple','group');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_group_delete($input){
  $a = new XFAction_acp_group_delete();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('acp_group_list','',false),'{:delete_group_successful}');
    else
    return xfaf_failure($a->get_error());
  }

?>