/*
    MISK.C - SOME FUNKTIONS FOR WE USE IN LAMPA.
    Copyright (C) 2005/6  Alexandre Mulatinho

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include "lampiao.h"

int is_logged(int user) 
{
	int fd, logged = 0;

	aux = first;
	while (aux) {
		if (aux->id == user) {
			if (!(fd = open(FILE_USER, O_RDONLY))) {
				while (read(fd, &now, sizeof(struct luser))) {
					if (!strncmp(aux->login, now->login, strlen(now->login)))
						logged++;
				}
				close(fd);
			}
		} 
		aux = aux->next;
	}

	return logged;
}

int getperm(int user)
{
	int fd, perm = 0;

	aux = first;
	while (aux) {
		if (aux->id == user) {
			if (!(fd = open(FILE_USER, O_RDONLY))) {
				while (read(fd, &now, sizeof(struct luser))) {
					if (!strncmp(aux->login, now->login, strlen(now->login)))
						perm = now->perm;
				}
				close(fd);
			}
		} 
		aux = aux->next;
	}

	return perm;
}

char *UPDATE_VERSION(char *version)
{
	char *nversion = (char*)malloc(SMAX);
	char *mst=NULL,*slv=NULL;
	int a,b;

	mst = (char*)strkey(version,0,'.');
	slv = (char*)strkey(version,1,'.');
	
	if (mst)
		a = atoi(mst);
	else
		a = 0;
	
	if (slv)
		b = atoi(slv);
	else 
		b = 1;
	
	b++;
	
	if (b > 49) { b = 0; a++; }
		
	snprintf(nversion, SMAX-1, "%d.%d\0", a, b);
	return nversion;
}

// REGISTRA O NOVO ARQUIVO NA DATABASE;
// UPDATE_NEWFILE("test.c", "devel", "-fix the jumpah", "alexandre");	
int UPDATE_NEWFILE(char *filen, char *dir, char *log, char *user)
{
	char *newv=NULL,*curr=NULL,*p=NULL;
	char buf[SMAX], path[SMAX];
	int i=0, fd=0, bytes=0, userid=0, totalsiz=0, totalfilez=0;

	// GET THE TOTAL BYTEZ
	if ((fd = open(filen, O_RDONLY))) {
		while ((bytes=read(fd, buf, sizeof(buf)-1))) {
			totalsiz += bytes;
		}
		close(fd);
	}

	// GET CURRENT USER && VERIFY IF HE IS LOGGED
	aux = first;
	while (aux) {
		if ((fd = open(FILE_USER, O_RDONLY))!=-1) {
			while (read(fd, &now, sizeof(struct luser))) {
				if (!strncmp(now->login, aux->login, strlen(now->login)))
					userid++;
			}

			close(fd);
		}

		aux = aux->next;
	}

	if (userid) {
		// VERIFY IS HE IS A DEVEL OF THIS PROJECT :)
		if ((fd = open(FILE_PROJ, O_RDONLY))!=-1) {
			while (read(fd, &pold, sizeof(struct project))) {
				while ((p=(char*)strkey(pold->users,i,';'))) {
					if (!strncmp(p, user, strlen(p))) 
						userid=0;

					i++;
				}
			}
			close(fd);
		}

		// MAKE A NEW REGISTER
		if (!userid) {
			curr = (char*)get_current_dir_name();
			snprintf(path, SMAX-1, "%s/%s/%s\0", curr, dir, FILE_PROJ);

			f_out = (struct FILEDIST *)malloc(sizeof(struct FILEDIST));
			f_in  = (struct FILEDIST *)malloc(sizeof(struct FILEDIST));

			if ((fd = open(path, O_RDONLY))!=-1) {
				while (read(fd, f_in, sizeof(struct FILEDIST))) {
					if (!strncmp(f_in->fname, filen, strlen(f_in->fname))) {
						newv = UPDATE_VERSION(f_in->version);
						snprintf(f_out->version, sizeof(f_out->version)-1, "%s\0", newv);
						f_out->patch = f_in->patch+1;
					}

					totalfilez++;
				}
				close(fd);
			} else {
				f_out->patch = 0;
				strncpy(f_out->version, "0.1\0", sizeof(f_out->version)-1);
			}

			strncpy(f_out->fname, filen, sizeof(f_out->fname)-1);
			strncpy(f_out->dir, dir, sizeof(f_out->dir)-1);
			strncpy(f_out->changelog, log, sizeof(f_out->changelog)-1);
			strncpy(f_out->login, user, sizeof(f_out->login)-1);
	
			f_out->fsize = totalsiz;
			f_out->id    = totalfilez;
	
			fprintf(stdout, "DEBUG:\n[fname: %s] [size: %u] [dir: %s] [version: %s] [patch: %d]\n[id: %d] [user: %s] [changelog: %s]\n", 
				f_out->fname, f_out->fsize, 
				f_out->dir, f_out->version, 
				f_out->patch, f_out->id,
				f_out->login, f_out->changelog);
	
			if (!totalfilez)
				fd = open(path, O_CREAT|O_WRONLY, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
			else	
				fd = open(path, O_WRONLY|O_APPEND);

			lseek(fd, sizeof(struct FILEDIST)*totalfilez, SEEK_SET);
			write(fd, f_out, sizeof(struct FILEDIST));
			close(fd);
			
			free(f_in);
			free(f_out);
		}
	}

	return 0;
}
