/*
    STRKEY.H - AN FUNCTION FOR REPLACE STRTOK().
    Copyright (C) 2004  Alexandre Mulatinho

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA


    Basicamente o lampiao serve como um daemon que escuta conexes numa
    porta TCP e administra / gerencia o controle de verses, patchs.
    Tem seu proprio database o que ajuda na hora de pesquisa, envio e
    recebimentos de arquivos no sistema UNIX em questo.
*/

#include "lampiao.h"

int main(void) 
{
	fd_set slave, master;
	char info[SMAX], buf[SMAX];
	struct sockaddr_in net, cln;
	int bytes, fdmax, user, nsoq, loop, soq;
	socklen_t tsiz;

	net.sin_port        = htons(PORT);
	net.sin_family      = AF_INET;
	net.sin_addr.s_addr = INADDR_ANY;
	
	if ((soq = socket(AF_INET,SOCK_STREAM,0)) < 0)
		return -0x211;

	if (bind(soq, (struct sockaddr *)&net, sizeof(net)) < 0)
		return -0xB6F;

	if (listen(soq, UMAX))
		return -0x021;

	FD_ZERO(&slave); FD_ZERO(&master);
	FD_SET(fileno(stdin), &master);
	FD_SET(soq, &master);

	fdmax = soq; tsiz = sizeof(net); loop = 0;
	for (;;) {
		slave = master;
		if (select(fdmax+1, &slave, NULL, NULL, NULL) == -1)
			return -0xAF0;

		for (user=0; user<=fdmax; user++) {
			if (FD_ISSET(user, &slave)) {
				if (user==soq) {
					if ((nsoq = accept(soq, (struct sockaddr *)&cln, &tsiz)) == -1)
						return -0xDEC;
					
					FD_SET(nsoq, &master);
					if (nsoq > soq)
						fdmax = nsoq+1;

					fprintf(stdout, "[~] nova conexo\033[1m:\033[m %s\n", inet_ntoa(cln.sin_addr));
					snprintf(info, SMAX-1, "[~] Welcome to the lampio v%s\n$ \0", LAMPIAO_VERS);
					send(nsoq, info, strlen(info), 0);
				} else {
					if ((bytes = recv(user, buf, SMAX-1, 0)) <= 0) {
						if (!bytes) 
							fprintf(stdout, "[~] conexo fechada\033[1m:\033[m %s\n", inet_ntoa(cln.sin_addr));
						
						now = first;
						while (now) {
							if (now->id == user) {
								if (!remove_user(now->id))
									fprintf(stdout, "%s\n", now->login);
							}
								
								
							now = now->next;
						}

						FD_CLR(user, &master);
						close(user);
					} else { 
						buf[bytes] = '\0';
						do_cmd(&cln, user, buf);
						memset(buf, 0, SMAX);
					}
				}
			}
		}
	}
	
	return 0;
}
