/*
    LAMPIO - UMA FERRAMENTA PARA GERENCIAMENTO DE PROJETOS DE CDIGO.
    Copyright (C) 2005/6  Alexandre Mulatinho

    The lampio is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The lampio is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA


    Basicamente o lampiao serve como um daemon que escuta conexes numa
    porta TCP e administra / gerencia o controle de verses, patchs.
    Tem seu proprio database o que ajuda na hora de pesquisa, envio e
    recebimentos de arquivos no sistema UNIX em questo.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/param.h>
#include <dirent.h>
#include <unistd.h>
#include <fcntl.h>
#include <ncurses.h>

#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <netdb.h>

// DEFINIES GERAIS
 
// TEMPORALY
#define LAMPIAO_DIR "~/projetos/lampiao"

#define LAMPIAO_CLNT "lampiao"
#define LAMPIAO_SERV "lampiaod"
#define LAMPIAO_VERS "0.90"

#define PM_ADMIN 0x00
#define PM_DEVEL 0x01
#define PM_ANONM 0x02
#define PM_OWNER 0x03

#define FILE_USER ".users"
#define FILE_NODE ".filez"
#define FILE_CLNT ".lampiao"
#define FILE_PROJ ".projects"

// 50 USERS PER SESSION :)
#define UMAX 50 
#define SMAX 512
#define PORT 15157

// ESTRUTURA DE ARQUIVOS
struct FILEDIST {
	int id, patch;
	long fsize;
	char login[20], dir[25], fname[25];
	char version[8], changelog[SMAX/2];
} *f_in, *f_out;

// ESTRUTURA DE PROJETOS
struct project {
	int id;
	char name[15];
	char admin[20], users[SMAX];
} *pnew, *pold;

// ESTRUTURA DE REGISTRO
struct luser {
	unsigned int id;
	unsigned int perm:2;
	char login[20], passw[20];
	char ip[20];
	struct luser *next;
}  *aux, *ant, *first, *now;

// main.c && cmd.c
int insert_user(int, char *, char *, unsigned int);
int remove_user(int code);
int do_cmd(struct sockaddr_in *, int, char *);
extern int alphasort();


// misk.c
int is_logged(int);
int getperm(int);
int UPDATE_NEWFILE(char *, char *, char *, char *);
char *UPDATE_VERSION(char *);

// client.c
int client_cmd(int, char *, char *);
