/*
    CMD.C - SOME COMMANDS OF LAMPIAO IS WRITTEN HERE.
    Copyright (C) 2004  Alexandre Mulatinho

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "lampiao.h"
#include "strkey.c"

int do_cmd(struct sockaddr_in *out, int user, char *s)
{
	FILE *fp;
	char *cmd, *arg0, *arg1, *arg2;
	char fln[SMAX], buf[SMAX], str[SMAX], rbuf[SMAX];
	int bytes=0, loop=0, flag=0, stat, fd;
	struct luser *new;
	struct dirent **files;

	memset(buf, 0, SMAX);
	
	cmd = strkey(s,0,' ');
	if (!cmd) {
		usleep(9);
		snprintf(buf, SMAX-1, "no commands here :)z");
		return send(user, buf, strlen(buf), 0);
	}

	fprintf(stdout, "$-  cmd.\033[1m:\033[m %s\n", cmd);
	fprintf(stdout, "$- userz\033[1m:\033[m "); aux = first;
	while (aux) { fprintf(stdout, "%s ", aux->login); aux = aux->next; }
	fprintf(stdout, "\n");


	if (!strncmp(cmd,"register",8)) {
		arg0 = strkey(s,1,' ');
		if (arg0)
			*(arg0 + (strlen(arg0)-1)) = '\0';

		if (!arg0) {
			snprintf(buf, SMAX-1, "syntax error: register <user>\n$ \0");
			return send(user, buf, strlen(buf), 0);
		}

		snprintf(str, SMAX-1, "password: \0");
		send(user, str, strlen(str), 0);

		bytes=0;
		while (!(bytes=recv(user, rbuf, sizeof(buf)-1, 0)));
		rbuf[bytes] = '\0';

		new = (struct luser *)malloc(sizeof(struct luser));
		stat = 0;
		if (!access(FILE_USER,F_OK)) {
			fp = fopen(FILE_USER, "r");
			
			while (fread(&aux, sizeof(struct luser), 1, fp)) {
				if (!strncmp(aux->login, arg0, strlen(aux->login))) {
					snprintf(buf, SMAX-1, "this username is registered, choice other please!.\n$ \0");
					return send(user, buf, strlen(buf), 0);
					stat++;
				}
				loop++;
			} 
			fclose(fp);

			new->perm = PM_DEVEL;
		} else {
			new->perm = PM_ADMIN;
		}

		new->id = user;
		strncpy(new->login, arg0, 20-1);
		strncpy(new->passw, rbuf, 20-1);
		strncpy(new->ip, inet_ntoa(out->sin_addr), 20-1);
//		new->next = NULL;

		if (!stat) {
			fprintf(stdout, "%s/%s\n", new->login, new->passw);
			fp = fopen(FILE_USER, "a");
			fwrite(&new, sizeof(struct luser), 1, fp);
			fclose(fp);

			snprintf(buf, SMAX-1, "congratulations! your register was recorded in my database with successfully.\n"
					      "now you can reconnect and use this: \033[1mexport LAMPIAOSERV=project@host\033[m\n$ \0");
			send(user, buf, strlen(buf), 0);
		}
	}
	
	else if (!strncmp(cmd,"login",5)) {
		arg0 = strkey(s,1,' ');

		if (arg0)
			*(arg0 + (strlen(arg0)-1)) = '\0';

		if (!arg0) {
			snprintf(buf, SMAX-1, "syntax error: login <user>\n$ \0");
			return send(user, buf, strlen(buf), 0);
		}

		if (!access(FILE_USER, F_OK)) {
			aux = first;
			while (aux) {
				if (aux->id == user) {
					snprintf(buf, SMAX-1, "you are logged in!\n$ \0");
					send(user, buf, strlen(buf), 0);
					return -0xDEAD;
				}
			}

			snprintf(buf, SMAX-1, "password: \0");
			send(user, buf, strlen(buf), 0);

			fd=0;
			while (!(fd=recv(user, rbuf, sizeof(rbuf)-1, 0)));
			rbuf[fd] = '\0';

			fp = fopen(FILE_USER, "r");
			// FIXME
			stat = 0;
			while (fread(&now, sizeof(struct luser), 1, fp)) {
				if (!strncmp(now->login, arg0, strlen(now->login)) && !strncmp(now->passw, rbuf, strlen(now->passw)))  {
					if (!insert_user(user, now->login, inet_ntoa(out->sin_addr), now->perm)) {
						fprintf(stdout, "user %d:%s, logged with perm: %d\n", user, inet_ntoa(out->sin_addr), now->perm);
						stat++; 
					}
				}
			}
			fclose(fp);
			
			if (!stat)
				snprintf(buf, SMAX-1, "username or password invalid.\n$ \0");
			else
				snprintf(buf, SMAX-1, "login successfully!\n$ \0");
				
		} else {
			snprintf(buf, SMAX-1, "i dont have any user in my database. and i dont have you too!\n$ \0");
		}

		send(user, buf, strlen(buf), 0);
	}

	else if (!strncmp(cmd,"help",4)) {
		arg0 = strkey(s, 1, ' ');
		
		if (!arg0) {
			snprintf(buf, SMAX-1, "\033[1m%s\033[m v.%s\n\n" \
					"\t     list\tlist a directory or file.\n" \
					"\t     recv\tget some directory or file.\n" \
					"\t     send\tsend an directory or file to the server.\n" \
					"\t    login\tlogin your username on the system.\n" \
					"\t register\tregister an username on the lampiao.\n" \
					"\t   update\tupdate a directory or filename in project.\n" \
					"\tupversion\taumenta uma verso de um arquivo.\n\n" \
					"\t     help\timprime esta ajuda.\n$ \0", LAMPIAO_SERV, LAMPIAO_VERS);
			return send(user, buf, strlen(buf), 0);
		} else {
			if (!strncmp(arg0, "recv", 4)) 
				snprintf(buf, SMAX-1, "recv <directory> [file]\n$ \0");

			else if (!strncmp(arg0, "send", 4)) 
				snprintf(buf, SMAX-1, "send <directory> [file]\n$ \0");

			else if (!strncmp(arg0, "login", 5)) 
				snprintf(buf, SMAX-1, "login <user>\n$ \0");

			else if (!strncmp(arg0, "register", 8)) 
				snprintf(buf, SMAX-1, "register <login>\n$ \0");

			else if (!strncmp(arg0, "list", 4)) 
				snprintf(buf, SMAX-1, "list <directory>\n$ \0");

			else if (!strncmp(arg0, "update", 6)) 
				snprintf(buf, SMAX-1, "update <directory> [file]\n$ \0");

			else if (!strncmp(arg0, "upversion", 9)) 
				snprintf(buf, SMAX-1, "upversion <directory> [file]\n$ \0");

			else if (!strncmp(arg0, "newproj", 7)) 
				snprintf(buf, SMAX-1, "newproj <project>\n$ \0");

			else if (!strncmp(arg0, "adduser", 7)) 
				snprintf(buf, SMAX-1, "adduser <project> <user>\n$ \0");

			else
				snprintf(buf, SMAX-1, "no help for this topic, try help!\n$ \0");

			return send(user, buf, strlen(buf), 0);
		}
	}
	
	else if (!strncmp(cmd, "mkdir", 5)) {
		arg0 = (char*)get_current_dir_name();
		arg1 = strkey(s, 1, ' ');

		// ARE YOU SURE YOU ARE OWNER OR DEVELOPER OF THIS PROJECT?

		if (arg1) {
			*(arg1 + (strlen(arg1)-1)) = '\0';
			snprintf(buf, SMAX-1, "%s/%s\0", arg0, arg1);

			if (!mkdir(buf, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH))
				snprintf(buf, SMAX-1, "[@] NEW DIRECTORY %s/%s\n$ \0", arg1);
			else
				snprintf(buf, SMAX-1, "permission denied!\n$ \0");
			
			send(user, buf, strlen(buf), 0);
		} else {
			snprintf(buf, SMAX-1, "syntax error: mkdir <diretorio>\n$ \0");
			return send(user, buf, strlen(buf), 0);
		}	
	}

	else if (!strncmp(cmd,"list",4)) {
		arg0 = strkey(s,1,' ');
		arg1 = (char*)get_current_dir_name();
		
		if (!arg1) {
			snprintf(buf, SMAX-1, "%s\0", arg1);
		} else {
			snprintf(buf, SMAX-1, "%s/%s\0", arg1, arg0);
		}

		stat = scandir(buf, &files, 0, alphasort);

		if (!stat) {
			snprintf(buf, SMAX-1, "sem arquivos neste diretrio..\n$ \0");
			return send(user, buf, strlen(buf), 0);
		} else {
			for (loop = 0; loop < stat; loop++) {
				snprintf(buf, SMAX-1, "%s\n\0", files[loop]->d_name);
				send(user, buf, strlen(buf), 0);
				free(files[loop]);
			}
			free(files);
		}
	}

	else if (!strncmp(cmd,"recv",4)) {
	}	

	else if (!strncmp(cmd, "send", 4)) {
		arg0 = strkey(s, 1, ' ');
		arg1 = strkey(s, 2, ' ');
		arg2 = (char*)get_current_dir_name();

		if (!is_logged(user)) {
			snprintf(buf, SMAX-1, "permission denied: try login first!\n$ \0");
			return send(user, buf, strlen(buf), 0);
		}

		if (arg1)
			*(arg1 + (strlen(arg1)-1)) = '\0';

		if (!arg0) {
			snprintf(buf, SMAX-1, "erro de sintaxe.\nsend <diretorio> [arquivo]\n$ \0");
			return send(user, buf, strlen(buf), 0);
		}
		
		snprintf(buf, SMAX-1, "%s/%s\0", arg2, arg0);
		stat = scandir(buf, &files, 0, alphasort); flag = 0;
		for (loop=0; loop<stat; loop++) {
			// FIXME: GET THE DIFF FILE
			if (!strncmp(files[loop]->d_name, arg1, strlen(files[loop]->d_name))) 
				flag++;
		}

		snprintf(fln, SMAX-1, "%s/%s\0", buf, arg1); bytes = 0;
		if ((fd = open(fln, O_CREAT|O_WRONLY, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH))) {
			bytes=0;

			while ((bytes = read(user, rbuf, sizeof(rbuf)-1))) {
				rbuf[bytes] = '\0';
	
				if (!strncmp(rbuf,"-eof", 4))
					break;
				else
					write(fd, rbuf, bytes);
			}
			close(fd);
		}

		if (!flag)
			snprintf(buf, SMAX-1, "[@] CREATED %s/%s\n\0", arg0, arg1);
		else
			snprintf(buf, SMAX-1, "[@] UPDATED %s/%s\n\0", arg0, arg1);

		write(user, buf, strlen(buf));

		// GET THE PERMISSION OF THE DUDE.
		// AND RETURN FOR THE CODE.
	}

	else if (!strncmp(cmd,"newproj",7)) {
		arg0 = strkey(s,1,' ');
		*(arg0 + (strlen(arg0)-1)) = '\0';

		if (!is_logged(user) || (getperm(user)!=PM_ADMIN)) {
			snprintf(buf, SMAX-1, "permission denied: try login first!\n$ \0");
			return send(user, buf, strlen(buf), 0);
		}

		if (!arg0) {
			snprintf(buf, SMAX-1, "sintaxe error: newproj <projeto>\n$ \0", LAMPIAO_CLNT);
			return send(user, buf, strlen(buf), 0);
		}

		aux = first;
		while (aux) {
			if (aux->id == user && aux->perm == PM_ADMIN) {
				arg1 = (char*)get_current_dir_name();
				snprintf(buf, SMAX-1, "%s/%s\0", arg1, arg0);

				if (!mkdir(buf,S_IRWXU)) {
					snprintf(str, SMAX-1, "%s\0", buf);
					mkdir(str,S_IRWXU);

					snprintf(buf, SMAX-1, "[CREATE] project \033[1m%s\033[m createc[d with sucessfully!\n$ \0", arg0);
				}
			} else {
				snprintf(buf, SMAX-1, "you dont have permission to do this operation.\n$ \0");
				return send(user, buf, strlen(buf), 0);
			}
			aux = aux->next;
		}
		send(user, buf, strlen(buf), 0);
	}
	
	else if (strncmp(cmd,"logoff",6)==0 || strncmp(cmd,"exit",4)==0 || strncmp(cmd,"quit",4)==0) {
		aux = first;
		while (aux) {	
			if (aux->id == user)
				remove_user(aux->id);
								
			aux = aux->next;
		}

		snprintf(buf, SMAX-1, "logout efetuado com sucesso.\n$ \0");
		send(user, buf, strlen(buf), 0);

		exit(0);
	}
	
	else {
		snprintf(buf, SMAX-1, "error, try use \033[1mhelp\033[m.\n$ \0");
		return send(user, buf, strlen(buf), 0);
	}
	
	return 0;
}
