#! /usr/bin/env python
# -*- coding: utf-8 -*-

# A simple script to run a match between 2 AIs.
# Note: does not handle well comment lines sent by AI (for example, welcome string)
#  -- it simply ignores all lines echoed by AI not starting from a digit or '-'.

import cgi, sys, os, subprocess

# note: blackAI should use protocol=3, because it has to make the first move
blackAIprog = ['./kropki', 'C4y']
blackAIname = 'kropki-BD'
blackProtocol = 3
whiteAIprog = ['../../kekvAI/PointsConsole/a.out']
whiteAIname = 'kekvAI'
whiteProtocol = 2

boardSize = 20
numberOfDoubleMoves = 80   # in a match at most (2*numberOfDoubleMoves + 1) moves will be played

class AI:
    def __init__(self, AIprog, AIname, protocol, board):
        """AIprog = ['programName', 'parameter1', 'param2', ...], protocol=2,3; board=INT"""
        self.protocol = protocol
        self.AIname = AIname
        self.AI = subprocess.Popen(AIprog, stdin = subprocess.PIPE , stdout = subprocess.PIPE, close_fds=True)
        self.write2stdin('%d %d %d\n' % (protocol, board, board) )

    def write2stdin(self, line):
        self.AI.stdin.write('%s\n' % line)
        f = open(self.AIname + '.stdin', 'a+')
        f.write('%s\n' % line)
        f.close()
    def readLineFromStdout(self):
        line = self.AI.stdout.readline()
        f = open(self.AIname + '.stdout', 'a+')
        f.write('%s\n' % line)
        f.close()
        return line.strip()

    def makeMoveAndGenerateNext(self, moveDescription):
        """moveDescription is of the form 'X Y colour' """
        if self.protocol == 2:
            self.write2stdin(moveDescription + ' 1')
            # read all lines until line with move is read (strictly speaking, it is badly checked...)
            # TODO: check it better (here and below)
            res = self.readLineFromStdout()
            while len(res)==0 or (not res[0].isdigit() and res[0] != '-'):
                res = self.readLineFromStdout()
            return self.readLineFromStdout()
        elif self.protocol == 3:
            self.write2stdin('0 ' + moveDescription)
            res = self.readLineFromStdout()
            while len(res)==0 or (not res[0].isdigit() and res[0] != '-'):
                res = self.readLineFromStdout()
            self.write2stdin('1')
            return self.readLineFromStdout()
            
    def generateMove(self):
        if self.protocol == 3:
            self.write2stdin('1')
            res = self.readLineFromStdout()
            while len(res)==0 or (not res[0].isdigit() and res[0] != '-'):
                res = self.readLineFromStdout()
            return res

    def bye(self):
        self.write2stdin('-1')
        self.AI.stdout.close()
        self.AI.stdin.close()

        
blackAI = AI(blackAIprog, blackAIname, blackProtocol, boardSize)
whiteAI = AI(whiteAIprog, whiteAIname, whiteProtocol, boardSize)

move = blackAI.generateMove()
print '1: ', move
for n in range(numberOfDoubleMoves):
    move = whiteAI.makeMoveAndGenerateNext(move)
    print '%d: %s' % (2*n+2, move)
    move = blackAI.makeMoveAndGenerateNext(move)
    print '%d: %s' % (2*n+3, move)

blackAI.bye()
whiteAI.bye()

